package com.google.android.material.snackbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.view.r0;
import c6.f;
import c6.k;
/* loaded from: classes.dex */
public class SnackbarContentLayout extends LinearLayout {

    /* renamed from: g  reason: collision with root package name */
    private TextView f6172g;

    /* renamed from: h  reason: collision with root package name */
    private Button f6173h;

    /* renamed from: i  reason: collision with root package name */
    private int f6174i;

    /* renamed from: j  reason: collision with root package name */
    private int f6175j;

    public SnackbarContentLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, k.J2);
        this.f6174i = obtainStyledAttributes.getDimensionPixelSize(k.K2, -1);
        this.f6175j = obtainStyledAttributes.getDimensionPixelSize(k.P2, -1);
        obtainStyledAttributes.recycle();
    }

    private static void a(View view, int i10, int i11) {
        if (r0.T(view)) {
            r0.B0(view, r0.G(view), i10, r0.F(view), i11);
        } else {
            view.setPadding(view.getPaddingLeft(), i10, view.getPaddingRight(), i11);
        }
    }

    private boolean b(int i10, int i11, int i12) {
        boolean z9;
        if (i10 != getOrientation()) {
            setOrientation(i10);
            z9 = true;
        } else {
            z9 = false;
        }
        if (this.f6172g.getPaddingTop() == i11 && this.f6172g.getPaddingBottom() == i12) {
            return z9;
        }
        a(this.f6172g, i11, i12);
        return true;
    }

    public Button getActionView() {
        return this.f6173h;
    }

    public TextView getMessageView() {
        return this.f6172g;
    }

    @Override // android.view.View
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.f6172g = (TextView) findViewById(f.snackbar_text);
        this.f6173h = (Button) findViewById(f.snackbar_action);
    }

    /* JADX WARN: Code restructure failed: missing block: B:17:0x0053, code lost:
        if (b(1, r0, r0 - r1) != false) goto L21;
     */
    /* JADX WARN: Code restructure failed: missing block: B:23:0x005e, code lost:
        if (b(0, r0, r0) != false) goto L21;
     */
    /* JADX WARN: Code restructure failed: missing block: B:24:0x0060, code lost:
        r3 = true;
     */
    @Override // android.widget.LinearLayout, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    protected void onMeasure(int i10, int i11) {
        super.onMeasure(i10, i11);
        if (this.f6174i > 0) {
            int measuredWidth = getMeasuredWidth();
            int i12 = this.f6174i;
            if (measuredWidth > i12) {
                i10 = View.MeasureSpec.makeMeasureSpec(i12, 1073741824);
                super.onMeasure(i10, i11);
            }
        }
        int dimensionPixelSize = getResources().getDimensionPixelSize(c6.d.design_snackbar_padding_vertical_2lines);
        int dimensionPixelSize2 = getResources().getDimensionPixelSize(c6.d.design_snackbar_padding_vertical);
        boolean z9 = false;
        boolean z10 = this.f6172g.getLayout().getLineCount() > 1;
        if (!z10 || this.f6175j <= 0 || this.f6173h.getMeasuredWidth() <= this.f6175j) {
            if (!z10) {
                dimensionPixelSize = dimensionPixelSize2;
            }
        }
        if (z9) {
            super.onMeasure(i10, i11);
        }
    }
}
