package com.google.android.material.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import androidx.appcompat.widget.q1;
import c6.k;
import g.j;
/* loaded from: classes.dex */
public abstract class d extends q1 {
    boolean A;

    /* renamed from: v  reason: collision with root package name */
    private Drawable f6155v;

    /* renamed from: w  reason: collision with root package name */
    private final Rect f6156w;

    /* renamed from: x  reason: collision with root package name */
    private final Rect f6157x;

    /* renamed from: y  reason: collision with root package name */
    private int f6158y;

    /* renamed from: z  reason: collision with root package name */
    protected boolean f6159z;

    public d(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.f6156w = new Rect();
        this.f6157x = new Rect();
        this.f6158y = j.F0;
        this.f6159z = true;
        this.A = false;
        TypedArray k10 = f.k(context, attributeSet, k.W0, i10, 0, new int[0]);
        this.f6158y = k10.getInt(k.Y0, this.f6158y);
        Drawable drawable = k10.getDrawable(k.X0);
        if (drawable != null) {
            setForeground(drawable);
        }
        this.f6159z = k10.getBoolean(k.Z0, true);
        k10.recycle();
    }

    @Override // android.view.View
    public void draw(Canvas canvas) {
        super.draw(canvas);
        Drawable drawable = this.f6155v;
        if (drawable != null) {
            if (this.A) {
                this.A = false;
                Rect rect = this.f6156w;
                Rect rect2 = this.f6157x;
                int right = getRight() - getLeft();
                int bottom = getBottom() - getTop();
                if (this.f6159z) {
                    rect.set(0, 0, right, bottom);
                } else {
                    rect.set(getPaddingLeft(), getPaddingTop(), right - getPaddingRight(), bottom - getPaddingBottom());
                }
                Gravity.apply(this.f6158y, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), rect, rect2);
                drawable.setBounds(rect2);
            }
            drawable.draw(canvas);
        }
    }

    @Override // android.view.View
    public void drawableHotspotChanged(float f10, float f11) {
        super.drawableHotspotChanged(f10, f11);
        Drawable drawable = this.f6155v;
        if (drawable != null) {
            drawable.setHotspot(f10, f11);
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable = this.f6155v;
        if (drawable == null || !drawable.isStateful()) {
            return;
        }
        this.f6155v.setState(getDrawableState());
    }

    @Override // android.view.View
    public Drawable getForeground() {
        return this.f6155v;
    }

    @Override // android.view.View
    public int getForegroundGravity() {
        return this.f6158y;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        Drawable drawable = this.f6155v;
        if (drawable != null) {
            drawable.jumpToCurrentState();
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.appcompat.widget.q1, android.view.ViewGroup, android.view.View
    public void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        super.onLayout(z9, i10, i11, i12, i13);
        this.A = z9 | this.A;
    }

    @Override // android.view.View
    protected void onSizeChanged(int i10, int i11, int i12, int i13) {
        super.onSizeChanged(i10, i11, i12, i13);
        this.A = true;
    }

    @Override // android.view.View
    public void setForeground(Drawable drawable) {
        Drawable drawable2 = this.f6155v;
        if (drawable2 != drawable) {
            if (drawable2 != null) {
                drawable2.setCallback(null);
                unscheduleDrawable(this.f6155v);
            }
            this.f6155v = drawable;
            if (drawable != null) {
                setWillNotDraw(false);
                drawable.setCallback(this);
                if (drawable.isStateful()) {
                    drawable.setState(getDrawableState());
                }
                if (this.f6158y == 119) {
                    drawable.getPadding(new Rect());
                }
            } else {
                setWillNotDraw(true);
            }
            requestLayout();
            invalidate();
        }
    }

    @Override // android.view.View
    public void setForegroundGravity(int i10) {
        if (this.f6158y != i10) {
            if ((8388615 & i10) == 0) {
                i10 |= 8388611;
            }
            if ((i10 & 112) == 0) {
                i10 |= 48;
            }
            this.f6158y = i10;
            if (i10 == 119 && this.f6155v != null) {
                this.f6155v.getPadding(new Rect());
            }
            requestLayout();
        }
    }

    @Override // android.view.View
    protected boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.f6155v;
    }
}
