package com.google.android.material.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.CheckedTextView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.appcompat.view.menu.i;
import androidx.appcompat.view.menu.n;
import androidx.appcompat.widget.q1;
import androidx.appcompat.widget.q2;
import androidx.core.view.r0;
import androidx.core.widget.v;
import w.l;
/* loaded from: classes.dex */
public class NavigationMenuItemView extends d implements n.a {
    private static final int[] L = {16842912};
    private int B;
    private boolean C;
    boolean D;
    private final CheckedTextView E;
    private FrameLayout F;
    private i G;
    private ColorStateList H;
    private boolean I;
    private Drawable J;
    private final androidx.core.view.a K;

    /* loaded from: classes.dex */
    class a extends androidx.core.view.a {
        a() {
        }

        @Override // androidx.core.view.a
        public void g(View view, l lVar) {
            super.g(view, lVar);
            lVar.h0(NavigationMenuItemView.this.D);
        }
    }

    public NavigationMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public NavigationMenuItemView(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        a aVar = new a();
        this.K = aVar;
        setOrientation(0);
        LayoutInflater.from(context).inflate(c6.h.design_navigation_menu_item, (ViewGroup) this, true);
        setIconSize(context.getResources().getDimensionPixelSize(c6.d.design_navigation_icon_size));
        CheckedTextView checkedTextView = (CheckedTextView) findViewById(c6.f.design_menu_item_text);
        this.E = checkedTextView;
        checkedTextView.setDuplicateParentStateEnabled(true);
        r0.n0(checkedTextView, aVar);
    }

    private StateListDrawable A() {
        TypedValue typedValue = new TypedValue();
        if (getContext().getTheme().resolveAttribute(g.a.f7769t, typedValue, true)) {
            StateListDrawable stateListDrawable = new StateListDrawable();
            stateListDrawable.addState(L, new ColorDrawable(typedValue.data));
            stateListDrawable.addState(ViewGroup.EMPTY_STATE_SET, new ColorDrawable(0));
            return stateListDrawable;
        }
        return null;
    }

    private boolean B() {
        return this.G.getTitle() == null && this.G.getIcon() == null && this.G.getActionView() != null;
    }

    private void setActionView(View view) {
        if (view != null) {
            if (this.F == null) {
                this.F = (FrameLayout) ((ViewStub) findViewById(c6.f.design_menu_item_action_area_stub)).inflate();
            }
            this.F.removeAllViews();
            this.F.addView(view);
        }
    }

    private void z() {
        q1.a aVar;
        int i10;
        if (B()) {
            this.E.setVisibility(8);
            FrameLayout frameLayout = this.F;
            if (frameLayout == null) {
                return;
            }
            aVar = (q1.a) frameLayout.getLayoutParams();
            i10 = -1;
        } else {
            this.E.setVisibility(0);
            FrameLayout frameLayout2 = this.F;
            if (frameLayout2 == null) {
                return;
            }
            aVar = (q1.a) frameLayout2.getLayoutParams();
            i10 = -2;
        }
        ((LinearLayout.LayoutParams) aVar).width = i10;
        this.F.setLayoutParams(aVar);
    }

    @Override // androidx.appcompat.view.menu.n.a
    public boolean c() {
        return false;
    }

    @Override // androidx.appcompat.view.menu.n.a
    public void d(i iVar, int i10) {
        this.G = iVar;
        setVisibility(iVar.isVisible() ? 0 : 8);
        if (getBackground() == null) {
            r0.r0(this, A());
        }
        setCheckable(iVar.isCheckable());
        setChecked(iVar.isChecked());
        setEnabled(iVar.isEnabled());
        setTitle(iVar.getTitle());
        setIcon(iVar.getIcon());
        setActionView(iVar.getActionView());
        setContentDescription(iVar.getContentDescription());
        q2.a(this, iVar.getTooltipText());
        z();
    }

    @Override // androidx.appcompat.view.menu.n.a
    public i getItemData() {
        return this.G;
    }

    @Override // android.view.ViewGroup, android.view.View
    protected int[] onCreateDrawableState(int i10) {
        int[] onCreateDrawableState = super.onCreateDrawableState(i10 + 1);
        i iVar = this.G;
        if (iVar != null && iVar.isCheckable() && this.G.isChecked()) {
            View.mergeDrawableStates(onCreateDrawableState, L);
        }
        return onCreateDrawableState;
    }

    public void setCheckable(boolean z9) {
        refreshDrawableState();
        if (this.D != z9) {
            this.D = z9;
            this.K.l(this.E, 2048);
        }
    }

    public void setChecked(boolean z9) {
        refreshDrawableState();
        this.E.setChecked(z9);
    }

    public void setHorizontalPadding(int i10) {
        setPadding(i10, 0, i10, 0);
    }

    public void setIcon(Drawable drawable) {
        if (drawable != null) {
            if (this.I) {
                Drawable.ConstantState constantState = drawable.getConstantState();
                if (constantState != null) {
                    drawable = constantState.newDrawable();
                }
                drawable = androidx.core.graphics.drawable.a.r(drawable).mutate();
                androidx.core.graphics.drawable.a.o(drawable, this.H);
            }
            int i10 = this.B;
            drawable.setBounds(0, 0, i10, i10);
        } else if (this.C) {
            if (this.J == null) {
                Drawable d10 = androidx.core.content.res.h.d(getResources(), c6.e.navigation_empty_icon, getContext().getTheme());
                this.J = d10;
                if (d10 != null) {
                    int i11 = this.B;
                    d10.setBounds(0, 0, i11, i11);
                }
            }
            drawable = this.J;
        }
        v.i(this.E, drawable, null, null, null);
    }

    public void setIconPadding(int i10) {
        this.E.setCompoundDrawablePadding(i10);
    }

    public void setIconSize(int i10) {
        this.B = i10;
    }

    void setIconTintList(ColorStateList colorStateList) {
        this.H = colorStateList;
        this.I = colorStateList != null;
        i iVar = this.G;
        if (iVar != null) {
            setIcon(iVar.getIcon());
        }
    }

    public void setMaxLines(int i10) {
        this.E.setMaxLines(i10);
    }

    public void setNeedsEmptyIcon(boolean z9) {
        this.C = z9;
    }

    public void setTextAppearance(int i10) {
        v.n(this.E, i10);
    }

    public void setTextColor(ColorStateList colorStateList) {
        this.E.setTextColor(colorStateList);
    }

    public void setTitle(CharSequence charSequence) {
        this.E.setText(charSequence);
    }
}
