package com.google.android.material.internal;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Checkable;
import androidx.appcompat.widget.p;
import androidx.core.view.r0;
import w.l;
/* loaded from: classes.dex */
public class CheckableImageButton extends p implements Checkable {

    /* renamed from: m  reason: collision with root package name */
    private static final int[] f6116m = {16842912};

    /* renamed from: j  reason: collision with root package name */
    private boolean f6117j;

    /* renamed from: k  reason: collision with root package name */
    private boolean f6118k;

    /* renamed from: l  reason: collision with root package name */
    private boolean f6119l;

    /* loaded from: classes.dex */
    class a extends androidx.core.view.a {
        a() {
        }

        @Override // androidx.core.view.a
        public void f(View view, AccessibilityEvent accessibilityEvent) {
            super.f(view, accessibilityEvent);
            accessibilityEvent.setChecked(CheckableImageButton.this.isChecked());
        }

        @Override // androidx.core.view.a
        public void g(View view, l lVar) {
            super.g(view, lVar);
            lVar.h0(CheckableImageButton.this.a());
            lVar.i0(CheckableImageButton.this.isChecked());
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class b extends b0.a {
        public static final Parcelable.Creator<b> CREATOR = new a();

        /* renamed from: i  reason: collision with root package name */
        boolean f6121i;

        /* loaded from: classes.dex */
        static class a implements Parcelable.ClassLoaderCreator {
            a() {
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: a */
            public b createFromParcel(Parcel parcel) {
                return new b(parcel, null);
            }

            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: b */
            public b createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new b(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: c */
            public b[] newArray(int i10) {
                return new b[i10];
            }
        }

        public b(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            c(parcel);
        }

        public b(Parcelable parcelable) {
            super(parcelable);
        }

        private void c(Parcel parcel) {
            this.f6121i = parcel.readInt() == 1;
        }

        @Override // b0.a, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i10) {
            super.writeToParcel(parcel, i10);
            parcel.writeInt(this.f6121i ? 1 : 0);
        }
    }

    public CheckableImageButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, g.a.imageButtonStyle);
    }

    public CheckableImageButton(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.f6118k = true;
        this.f6119l = true;
        r0.n0(this, new a());
    }

    public boolean a() {
        return this.f6118k;
    }

    @Override // android.widget.Checkable
    public boolean isChecked() {
        return this.f6117j;
    }

    @Override // android.widget.ImageView, android.view.View
    public int[] onCreateDrawableState(int i10) {
        if (this.f6117j) {
            int[] iArr = f6116m;
            return View.mergeDrawableStates(super.onCreateDrawableState(i10 + iArr.length), iArr);
        }
        return super.onCreateDrawableState(i10);
    }

    @Override // android.view.View
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof b)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        b bVar = (b) parcelable;
        super.onRestoreInstanceState(bVar.a());
        setChecked(bVar.f6121i);
    }

    @Override // android.view.View
    protected Parcelable onSaveInstanceState() {
        b bVar = new b(super.onSaveInstanceState());
        bVar.f6121i = this.f6117j;
        return bVar;
    }

    public void setCheckable(boolean z9) {
        if (this.f6118k != z9) {
            this.f6118k = z9;
            sendAccessibilityEvent(0);
        }
    }

    @Override // android.widget.Checkable
    public void setChecked(boolean z9) {
        if (!this.f6118k || this.f6117j == z9) {
            return;
        }
        this.f6117j = z9;
        refreshDrawableState();
        sendAccessibilityEvent(2048);
    }

    public void setPressable(boolean z9) {
        this.f6119l = z9;
    }

    @Override // android.view.View
    public void setPressed(boolean z9) {
        if (this.f6119l) {
            super.setPressed(z9);
        }
    }

    @Override // android.widget.Checkable
    public void toggle() {
        setChecked(!this.f6117j);
    }
}
