package com.google.android.material.datepicker;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.view.r0;
import androidx.fragment.app.w;
import com.google.android.material.datepicker.a;
import com.google.android.material.internal.CheckableImageButton;
import java.util.Iterator;
import java.util.LinkedHashSet;
/* loaded from: classes.dex */
public final class i<S> extends androidx.fragment.app.d {
    static final Object M = "CONFIRM_BUTTON_TAG";
    static final Object N = "CANCEL_BUTTON_TAG";
    static final Object O = "TOGGLE_BUTTON_TAG";
    private int A;
    private com.google.android.material.datepicker.d B;
    private p C;
    private com.google.android.material.datepicker.a D;
    private h E;
    private int F;
    private CharSequence G;
    private boolean H;
    private TextView I;
    private CheckableImageButton J;
    private p6.g K;
    private Button L;

    /* renamed from: w  reason: collision with root package name */
    private final LinkedHashSet f6073w = new LinkedHashSet();

    /* renamed from: x  reason: collision with root package name */
    private final LinkedHashSet f6074x = new LinkedHashSet();

    /* renamed from: y  reason: collision with root package name */
    private final LinkedHashSet f6075y = new LinkedHashSet();

    /* renamed from: z  reason: collision with root package name */
    private final LinkedHashSet f6076z = new LinkedHashSet();

    /* loaded from: classes.dex */
    class a implements View.OnClickListener {
        a() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            Iterator it = i.this.f6073w.iterator();
            while (it.hasNext()) {
                ((j) it.next()).a(i.this.F());
            }
            i.this.j();
        }
    }

    /* loaded from: classes.dex */
    class b implements View.OnClickListener {
        b() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            Iterator it = i.this.f6074x.iterator();
            while (it.hasNext()) {
                ((View.OnClickListener) it.next()).onClick(view);
            }
            i.this.j();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class c implements o {
        c() {
        }

        @Override // com.google.android.material.datepicker.o
        public void a(Object obj) {
            Button button;
            boolean z9;
            i.this.L();
            if (i.this.B.n()) {
                button = i.this.L;
                z9 = true;
            } else {
                button = i.this.L;
                z9 = false;
            }
            button.setEnabled(z9);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class d implements View.OnClickListener {
        d() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            i.this.J.toggle();
            i iVar = i.this;
            iVar.M(iVar.J);
            i.this.J();
        }
    }

    private static Drawable B(Context context) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842912}, h.a.b(context, c6.e.ic_calendar_black_24dp));
        stateListDrawable.addState(new int[0], h.a.b(context, c6.e.ic_edit_black_24dp));
        return stateListDrawable;
    }

    private static int C(Context context) {
        Resources resources = context.getResources();
        int dimensionPixelSize = resources.getDimensionPixelSize(c6.d.mtrl_calendar_navigation_height) + resources.getDimensionPixelOffset(c6.d.mtrl_calendar_navigation_top_padding) + resources.getDimensionPixelOffset(c6.d.mtrl_calendar_navigation_bottom_padding);
        int dimensionPixelSize2 = resources.getDimensionPixelSize(c6.d.mtrl_calendar_days_of_week_height);
        int i10 = m.f6091k;
        return dimensionPixelSize + dimensionPixelSize2 + (resources.getDimensionPixelSize(c6.d.mtrl_calendar_day_height) * i10) + ((i10 - 1) * resources.getDimensionPixelOffset(c6.d.mtrl_calendar_month_vertical_padding)) + resources.getDimensionPixelOffset(c6.d.mtrl_calendar_bottom_padding);
    }

    private static int E(Context context) {
        Resources resources = context.getResources();
        int dimensionPixelOffset = resources.getDimensionPixelOffset(c6.d.mtrl_calendar_content_padding);
        int i10 = l.C().f6088k;
        return (dimensionPixelOffset * 2) + (resources.getDimensionPixelSize(c6.d.mtrl_calendar_day_width) * i10) + ((i10 - 1) * resources.getDimensionPixelOffset(c6.d.mtrl_calendar_month_horizontal_padding));
    }

    private int G(Context context) {
        int i10 = this.A;
        return i10 != 0 ? i10 : this.B.l(context);
    }

    private void H(Context context) {
        this.J.setTag(O);
        this.J.setImageDrawable(B(context));
        r0.n0(this.J, null);
        M(this.J);
        this.J.setOnClickListener(new d());
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean I(Context context) {
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(m6.b.c(context, c6.b.materialCalendarStyle, h.class.getCanonicalName()), new int[]{16843277});
        boolean z9 = obtainStyledAttributes.getBoolean(0, false);
        obtainStyledAttributes.recycle();
        return z9;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void J() {
        this.E = h.x(this.B, G(requireContext()), this.D);
        this.C = this.J.isChecked() ? k.i(this.B, this.D) : this.E;
        L();
        w m10 = getChildFragmentManager().m();
        m10.m(c6.f.mtrl_calendar_frame, this.C);
        m10.h();
        this.C.g(new c());
    }

    public static long K() {
        return l.C().f6090m;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void L() {
        String D = D();
        this.I.setContentDescription(String.format(getString(c6.i.mtrl_picker_announce_current_selection), D));
        this.I.setText(D);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void M(CheckableImageButton checkableImageButton) {
        this.J.setContentDescription(checkableImageButton.getContext().getString(this.J.isChecked() ? c6.i.mtrl_picker_toggle_to_calendar_input_mode : c6.i.mtrl_picker_toggle_to_text_input_mode));
    }

    public String D() {
        return this.B.b(getContext());
    }

    public final Object F() {
        return this.B.p();
    }

    @Override // androidx.fragment.app.d
    public final Dialog n(Bundle bundle) {
        Dialog dialog = new Dialog(requireContext(), G(requireContext()));
        Context context = dialog.getContext();
        this.H = I(context);
        int c10 = m6.b.c(context, c6.b.colorSurface, i.class.getCanonicalName());
        p6.g gVar = new p6.g(context, null, c6.b.materialCalendarStyle, c6.j.Widget_MaterialComponents_MaterialCalendar);
        this.K = gVar;
        gVar.J(context);
        this.K.R(ColorStateList.valueOf(c10));
        this.K.Q(r0.v(dialog.getWindow().getDecorView()));
        return dialog;
    }

    @Override // androidx.fragment.app.d, android.content.DialogInterface.OnCancelListener
    public final void onCancel(DialogInterface dialogInterface) {
        Iterator it = this.f6075y.iterator();
        while (it.hasNext()) {
            ((DialogInterface.OnCancelListener) it.next()).onCancel(dialogInterface);
        }
        super.onCancel(dialogInterface);
    }

    @Override // androidx.fragment.app.d, androidx.fragment.app.Fragment
    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle == null) {
            bundle = getArguments();
        }
        this.A = bundle.getInt("OVERRIDE_THEME_RES_ID");
        this.B = (com.google.android.material.datepicker.d) bundle.getParcelable("DATE_SELECTOR_KEY");
        this.D = (com.google.android.material.datepicker.a) bundle.getParcelable("CALENDAR_CONSTRAINTS_KEY");
        this.F = bundle.getInt("TITLE_TEXT_RES_ID_KEY");
        this.G = bundle.getCharSequence("TITLE_TEXT_KEY");
    }

    @Override // androidx.fragment.app.Fragment
    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View inflate = layoutInflater.inflate(this.H ? c6.h.mtrl_picker_fullscreen : c6.h.mtrl_picker_dialog, viewGroup);
        Context context = inflate.getContext();
        if (this.H) {
            inflate.findViewById(c6.f.mtrl_calendar_frame).setLayoutParams(new LinearLayout.LayoutParams(E(context), -2));
        } else {
            View findViewById = inflate.findViewById(c6.f.mtrl_calendar_main_pane);
            View findViewById2 = inflate.findViewById(c6.f.mtrl_calendar_frame);
            findViewById.setLayoutParams(new LinearLayout.LayoutParams(E(context), -1));
            findViewById2.setMinimumHeight(C(requireContext()));
        }
        TextView textView = (TextView) inflate.findViewById(c6.f.mtrl_picker_header_selection_text);
        this.I = textView;
        r0.p0(textView, 1);
        this.J = (CheckableImageButton) inflate.findViewById(c6.f.mtrl_picker_header_toggle);
        TextView textView2 = (TextView) inflate.findViewById(c6.f.mtrl_picker_title_text);
        CharSequence charSequence = this.G;
        if (charSequence != null) {
            textView2.setText(charSequence);
        } else {
            textView2.setText(this.F);
        }
        H(context);
        this.L = (Button) inflate.findViewById(c6.f.confirm_button);
        if (this.B.n()) {
            this.L.setEnabled(true);
        } else {
            this.L.setEnabled(false);
        }
        this.L.setTag(M);
        this.L.setOnClickListener(new a());
        Button button = (Button) inflate.findViewById(c6.f.cancel_button);
        button.setTag(N);
        button.setOnClickListener(new b());
        return inflate;
    }

    @Override // androidx.fragment.app.d, android.content.DialogInterface.OnDismissListener
    public final void onDismiss(DialogInterface dialogInterface) {
        Iterator it = this.f6076z.iterator();
        while (it.hasNext()) {
            ((DialogInterface.OnDismissListener) it.next()).onDismiss(dialogInterface);
        }
        ViewGroup viewGroup = (ViewGroup) getView();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        super.onDismiss(dialogInterface);
    }

    @Override // androidx.fragment.app.d, androidx.fragment.app.Fragment
    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt("OVERRIDE_THEME_RES_ID", this.A);
        bundle.putParcelable("DATE_SELECTOR_KEY", this.B);
        a.b bVar = new a.b(this.D);
        if (this.E.t() != null) {
            bVar.b(this.E.t().f6090m);
        }
        bundle.putParcelable("CALENDAR_CONSTRAINTS_KEY", bVar.a());
        bundle.putInt("TITLE_TEXT_RES_ID_KEY", this.F);
        bundle.putCharSequence("TITLE_TEXT_KEY", this.G);
    }

    @Override // androidx.fragment.app.d, androidx.fragment.app.Fragment
    public void onStart() {
        super.onStart();
        Window window = r().getWindow();
        if (this.H) {
            window.setLayout(-1, -1);
            window.setBackgroundDrawable(this.K);
        } else {
            window.setLayout(-2, -2);
            int dimensionPixelOffset = getResources().getDimensionPixelOffset(c6.d.mtrl_calendar_dialog_background_inset);
            Rect rect = new Rect(dimensionPixelOffset, dimensionPixelOffset, dimensionPixelOffset, dimensionPixelOffset);
            window.setBackgroundDrawable(new InsetDrawable((Drawable) this.K, dimensionPixelOffset, dimensionPixelOffset, dimensionPixelOffset, dimensionPixelOffset));
            window.getDecorView().setOnTouchListener(new h6.a(r(), rect));
        }
        J();
    }

    @Override // androidx.fragment.app.d, androidx.fragment.app.Fragment
    public void onStop() {
        this.C.h();
        super.onStop();
    }
}
