package com.google.android.material.datepicker;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import androidx.core.view.r0;
import java.util.Calendar;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public final class MaterialCalendarGridView extends GridView {

    /* renamed from: g  reason: collision with root package name */
    private final Calendar f6007g;

    /* loaded from: classes.dex */
    class a extends androidx.core.view.a {
        a() {
        }

        @Override // androidx.core.view.a
        public void g(View view, w.l lVar) {
            super.g(view, lVar);
            lVar.l0(null);
        }
    }

    public MaterialCalendarGridView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MaterialCalendarGridView(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.f6007g = r.k();
        if (i.I(getContext())) {
            setNextFocusLeftId(c6.f.cancel_button);
            setNextFocusRightId(c6.f.confirm_button);
        }
        r0.n0(this, new a());
    }

    private void a(int i10, Rect rect) {
        int b10;
        if (i10 == 33) {
            b10 = getAdapter2().h();
        } else if (i10 != 130) {
            super.onFocusChanged(true, i10, rect);
            return;
        } else {
            b10 = getAdapter2().b();
        }
        setSelection(b10);
    }

    private static int c(View view) {
        return view.getLeft() + (view.getWidth() / 2);
    }

    private static boolean d(Long l10, Long l11, Long l12, Long l13) {
        return l10 == null || l11 == null || l12 == null || l13 == null || l12.longValue() > l11.longValue() || l13.longValue() < l10.longValue();
    }

    @Override // android.widget.GridView, android.widget.AdapterView
    /* renamed from: b */
    public m getAdapter2() {
        return (m) super.getAdapter();
    }

    @Override // android.widget.AbsListView, android.view.ViewGroup, android.view.View
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        getAdapter2().notifyDataSetChanged();
    }

    @Override // android.view.View
    protected final void onDraw(Canvas canvas) {
        int a10;
        int c10;
        int a11;
        int c11;
        MaterialCalendarGridView materialCalendarGridView = this;
        super.onDraw(canvas);
        m adapter2 = getAdapter2();
        d dVar = adapter2.f6093h;
        c cVar = adapter2.f6094i;
        Long item = adapter2.getItem(adapter2.b());
        Long item2 = adapter2.getItem(adapter2.h());
        for (v.d dVar2 : dVar.g()) {
            Object obj = dVar2.f13914a;
            if (obj != null) {
                if (dVar2.f13915b == null) {
                    continue;
                } else {
                    long longValue = ((Long) obj).longValue();
                    long longValue2 = ((Long) dVar2.f13915b).longValue();
                    if (d(item, item2, Long.valueOf(longValue), Long.valueOf(longValue2))) {
                        return;
                    }
                    if (longValue < item.longValue()) {
                        a10 = adapter2.b();
                        c10 = adapter2.f(a10) ? 0 : materialCalendarGridView.getChildAt(a10 - 1).getRight();
                    } else {
                        materialCalendarGridView.f6007g.setTimeInMillis(longValue);
                        a10 = adapter2.a(materialCalendarGridView.f6007g.get(5));
                        c10 = c(materialCalendarGridView.getChildAt(a10));
                    }
                    if (longValue2 > item2.longValue()) {
                        a11 = adapter2.h();
                        c11 = adapter2.g(a11) ? getWidth() : materialCalendarGridView.getChildAt(a11).getRight();
                    } else {
                        materialCalendarGridView.f6007g.setTimeInMillis(longValue2);
                        a11 = adapter2.a(materialCalendarGridView.f6007g.get(5));
                        c11 = c(materialCalendarGridView.getChildAt(a11));
                    }
                    int itemId = (int) adapter2.getItemId(a10);
                    int itemId2 = (int) adapter2.getItemId(a11);
                    while (itemId <= itemId2) {
                        int numColumns = getNumColumns() * itemId;
                        int numColumns2 = (getNumColumns() + numColumns) - 1;
                        View childAt = materialCalendarGridView.getChildAt(numColumns);
                        canvas.drawRect(numColumns > a10 ? 0 : c10, childAt.getTop() + cVar.f6027a.c(), a11 > numColumns2 ? getWidth() : c11, childAt.getBottom() - cVar.f6027a.b(), cVar.f6034h);
                        itemId++;
                        materialCalendarGridView = this;
                    }
                }
            }
            materialCalendarGridView = this;
        }
    }

    @Override // android.widget.GridView, android.widget.AbsListView, android.view.View
    protected void onFocusChanged(boolean z9, int i10, Rect rect) {
        if (z9) {
            a(i10, rect);
        } else {
            super.onFocusChanged(false, i10, rect);
        }
    }

    @Override // android.widget.GridView, android.widget.AbsListView, android.view.View, android.view.KeyEvent.Callback
    public boolean onKeyDown(int i10, KeyEvent keyEvent) {
        if (super.onKeyDown(i10, keyEvent)) {
            if (getSelectedItemPosition() == -1 || getSelectedItemPosition() >= getAdapter2().b()) {
                return true;
            }
            if (19 == i10) {
                setSelection(getAdapter2().b());
                return true;
            }
            return false;
        }
        return false;
    }

    @Override // android.widget.AdapterView
    public final void setAdapter(ListAdapter listAdapter) {
        if (!(listAdapter instanceof m)) {
            throw new IllegalArgumentException(String.format("%1$s must have its Adapter set to a %2$s", MaterialCalendarGridView.class.getCanonicalName(), m.class.getCanonicalName()));
        }
        super.setAdapter(listAdapter);
    }

    @Override // android.widget.GridView, android.widget.AdapterView
    public void setSelection(int i10) {
        if (i10 < getAdapter2().b()) {
            i10 = getAdapter2().b();
        }
        super.setSelection(i10);
    }
}
