package com.google.android.material.chip;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.text.TextUtils;
import android.util.AttributeSet;
import c6.k;
import com.google.android.material.internal.e;
import com.google.android.material.internal.f;
import d6.d;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import m6.c;
import n6.b;
import p6.g;
/* loaded from: classes.dex */
public class a extends g implements Drawable.Callback, e.b {
    private static final int[] L0 = {16842910};
    private static final ShapeDrawable M0 = new ShapeDrawable(new OvalShape());
    private PorterDuffColorFilter A0;
    private ColorStateList B0;
    private ColorStateList C;
    private PorterDuff.Mode C0;
    private ColorStateList D;
    private int[] D0;
    private float E;
    private boolean E0;
    private float F;
    private ColorStateList F0;
    private ColorStateList G;
    private WeakReference G0;
    private float H;
    private TextUtils.TruncateAt H0;
    private ColorStateList I;
    private boolean I0;
    private CharSequence J;
    private int J0;
    private boolean K;
    private boolean K0;
    private Drawable L;
    private ColorStateList M;
    private float N;
    private boolean O;
    private boolean P;
    private Drawable Q;
    private Drawable R;
    private ColorStateList S;
    private float T;
    private CharSequence U;
    private boolean V;
    private boolean W;
    private Drawable X;
    private d Y;
    private d Z;

    /* renamed from: a0  reason: collision with root package name */
    private float f5981a0;

    /* renamed from: b0  reason: collision with root package name */
    private float f5982b0;

    /* renamed from: c0  reason: collision with root package name */
    private float f5983c0;

    /* renamed from: d0  reason: collision with root package name */
    private float f5984d0;

    /* renamed from: e0  reason: collision with root package name */
    private float f5985e0;

    /* renamed from: f0  reason: collision with root package name */
    private float f5986f0;

    /* renamed from: g0  reason: collision with root package name */
    private float f5987g0;

    /* renamed from: h0  reason: collision with root package name */
    private float f5988h0;

    /* renamed from: i0  reason: collision with root package name */
    private final Context f5989i0;

    /* renamed from: j0  reason: collision with root package name */
    private final Paint f5990j0;

    /* renamed from: k0  reason: collision with root package name */
    private final Paint f5991k0;

    /* renamed from: l0  reason: collision with root package name */
    private final Paint.FontMetrics f5992l0;

    /* renamed from: m0  reason: collision with root package name */
    private final RectF f5993m0;

    /* renamed from: n0  reason: collision with root package name */
    private final PointF f5994n0;

    /* renamed from: o0  reason: collision with root package name */
    private final Path f5995o0;

    /* renamed from: p0  reason: collision with root package name */
    private final e f5996p0;

    /* renamed from: q0  reason: collision with root package name */
    private int f5997q0;

    /* renamed from: r0  reason: collision with root package name */
    private int f5998r0;

    /* renamed from: s0  reason: collision with root package name */
    private int f5999s0;

    /* renamed from: t0  reason: collision with root package name */
    private int f6000t0;

    /* renamed from: u0  reason: collision with root package name */
    private int f6001u0;

    /* renamed from: v0  reason: collision with root package name */
    private int f6002v0;

    /* renamed from: w0  reason: collision with root package name */
    private boolean f6003w0;

    /* renamed from: x0  reason: collision with root package name */
    private int f6004x0;

    /* renamed from: y0  reason: collision with root package name */
    private int f6005y0;

    /* renamed from: z0  reason: collision with root package name */
    private ColorFilter f6006z0;

    /* renamed from: com.google.android.material.chip.a$a  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public interface InterfaceC0086a {
        void a();
    }

    private a(Context context, AttributeSet attributeSet, int i10, int i11) {
        super(context, attributeSet, i10, i11);
        this.f5990j0 = new Paint(1);
        this.f5992l0 = new Paint.FontMetrics();
        this.f5993m0 = new RectF();
        this.f5994n0 = new PointF();
        this.f5995o0 = new Path();
        this.f6005y0 = 255;
        this.C0 = PorterDuff.Mode.SRC_IN;
        this.G0 = new WeakReference(null);
        J(context);
        this.f5989i0 = context;
        e eVar = new e(this);
        this.f5996p0 = eVar;
        this.J = "";
        eVar.e().density = context.getResources().getDisplayMetrics().density;
        this.f5991k0 = null;
        int[] iArr = L0;
        setState(iArr);
        Y1(iArr);
        this.I0 = true;
        if (b.f10517a) {
            M0.setTint(-1);
        }
    }

    private boolean A2() {
        return this.K && this.L != null;
    }

    private boolean B2() {
        return this.P && this.Q != null;
    }

    private void C2(Drawable drawable) {
        if (drawable != null) {
            drawable.setCallback(null);
        }
    }

    private void D2() {
        this.F0 = this.E0 ? b.a(this.I) : null;
    }

    private void E2() {
        this.R = new RippleDrawable(b.a(U0()), this.Q, M0);
    }

    private void O1(ColorStateList colorStateList) {
        if (this.C != colorStateList) {
            this.C = colorStateList;
            onStateChange(getState());
        }
    }

    private ColorFilter a1() {
        ColorFilter colorFilter = this.f6006z0;
        return colorFilter != null ? colorFilter : this.A0;
    }

    private void c0(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        drawable.setCallback(this);
        androidx.core.graphics.drawable.a.m(drawable, androidx.core.graphics.drawable.a.f(this));
        drawable.setLevel(getLevel());
        drawable.setVisible(isVisible(), false);
        if (drawable == this.Q) {
            if (drawable.isStateful()) {
                drawable.setState(N0());
            }
            androidx.core.graphics.drawable.a.o(drawable, this.S);
            return;
        }
        if (drawable.isStateful()) {
            drawable.setState(getState());
        }
        Drawable drawable2 = this.L;
        if (drawable == drawable2 && this.O) {
            androidx.core.graphics.drawable.a.o(drawable2, this.M);
        }
    }

    private static boolean c1(int[] iArr, int i10) {
        if (iArr == null) {
            return false;
        }
        for (int i11 : iArr) {
            if (i11 == i10) {
                return true;
            }
        }
        return false;
    }

    private void d0(Rect rect, RectF rectF) {
        rectF.setEmpty();
        if (A2() || z2()) {
            float f10 = this.f5981a0 + this.f5982b0;
            if (androidx.core.graphics.drawable.a.f(this) == 0) {
                float f11 = rect.left + f10;
                rectF.left = f11;
                rectF.right = f11 + this.N;
            } else {
                float f12 = rect.right - f10;
                rectF.right = f12;
                rectF.left = f12 - this.N;
            }
            float exactCenterY = rect.exactCenterY();
            float f13 = this.N;
            float f14 = exactCenterY - (f13 / 2.0f);
            rectF.top = f14;
            rectF.bottom = f14 + f13;
        }
    }

    private void f0(Rect rect, RectF rectF) {
        rectF.set(rect);
        if (B2()) {
            float f10 = this.f5988h0 + this.f5987g0 + this.T + this.f5986f0 + this.f5985e0;
            if (androidx.core.graphics.drawable.a.f(this) == 0) {
                rectF.right = rect.right - f10;
            } else {
                rectF.left = rect.left + f10;
            }
        }
    }

    private void g0(Rect rect, RectF rectF) {
        rectF.setEmpty();
        if (B2()) {
            float f10 = this.f5988h0 + this.f5987g0;
            if (androidx.core.graphics.drawable.a.f(this) == 0) {
                float f11 = rect.right - f10;
                rectF.right = f11;
                rectF.left = f11 - this.T;
            } else {
                float f12 = rect.left + f10;
                rectF.left = f12;
                rectF.right = f12 + this.T;
            }
            float exactCenterY = rect.exactCenterY();
            float f13 = this.T;
            float f14 = exactCenterY - (f13 / 2.0f);
            rectF.top = f14;
            rectF.bottom = f14 + f13;
        }
    }

    private static boolean g1(ColorStateList colorStateList) {
        return colorStateList != null && colorStateList.isStateful();
    }

    private void h0(Rect rect, RectF rectF) {
        rectF.setEmpty();
        if (B2()) {
            float f10 = this.f5988h0 + this.f5987g0 + this.T + this.f5986f0 + this.f5985e0;
            if (androidx.core.graphics.drawable.a.f(this) == 0) {
                float f11 = rect.right;
                rectF.right = f11;
                rectF.left = f11 - f10;
            } else {
                int i10 = rect.left;
                rectF.left = i10;
                rectF.right = i10 + f10;
            }
            rectF.top = rect.top;
            rectF.bottom = rect.bottom;
        }
    }

    private static boolean h1(Drawable drawable) {
        return drawable != null && drawable.isStateful();
    }

    private static boolean i1(m6.d dVar) {
        ColorStateList colorStateList;
        return (dVar == null || (colorStateList = dVar.f10187b) == null || !colorStateList.isStateful()) ? false : true;
    }

    private void j0(Rect rect, RectF rectF) {
        rectF.setEmpty();
        if (this.J != null) {
            float e02 = this.f5981a0 + e0() + this.f5984d0;
            float i02 = this.f5988h0 + i0() + this.f5985e0;
            if (androidx.core.graphics.drawable.a.f(this) == 0) {
                rectF.left = rect.left + e02;
                rectF.right = rect.right - i02;
            } else {
                rectF.left = rect.left + i02;
                rectF.right = rect.right - e02;
            }
            rectF.top = rect.top;
            rectF.bottom = rect.bottom;
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:25:0x00cc  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void j1(AttributeSet attributeSet, int i10, int i11) {
        TextUtils.TruncateAt truncateAt;
        int i12;
        TypedArray k10 = f.k(this.f5989i0, attributeSet, k.I, i10, i11, new int[0]);
        this.K0 = k10.hasValue(k.f5451s0);
        O1(c.a(this.f5989i0, k10, k.f5374f0));
        s1(c.a(this.f5989i0, k10, k.S));
        G1(k10.getDimension(k.f5344a0, 0.0f));
        int i13 = k.T;
        if (k10.hasValue(i13)) {
            u1(k10.getDimension(i13, 0.0f));
        }
        K1(c.a(this.f5989i0, k10, k.f5362d0));
        M1(k10.getDimension(k.f5368e0, 0.0f));
        l2(c.a(this.f5989i0, k10, k.f5446r0));
        q2(k10.getText(k.N));
        r2(c.f(this.f5989i0, k10, k.J));
        int i14 = k10.getInt(k.L, 0);
        if (i14 == 1) {
            truncateAt = TextUtils.TruncateAt.START;
        } else if (i14 != 2) {
            if (i14 == 3) {
                truncateAt = TextUtils.TruncateAt.END;
            }
            F1(k10.getBoolean(k.Z, false));
            if (attributeSet != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "chipIconEnabled") != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "chipIconVisible") == null) {
                F1(k10.getBoolean(k.W, false));
            }
            y1(c.d(this.f5989i0, k10, k.V));
            i12 = k.Y;
            if (k10.hasValue(i12)) {
                C1(c.a(this.f5989i0, k10, i12));
            }
            A1(k10.getDimension(k.X, 0.0f));
            b2(k10.getBoolean(k.f5416m0, false));
            if (attributeSet != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "closeIconEnabled") != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "closeIconVisible") == null) {
                b2(k10.getBoolean(k.f5386h0, false));
            }
            P1(c.d(this.f5989i0, k10, k.f5380g0));
            Z1(c.a(this.f5989i0, k10, k.f5410l0));
            U1(k10.getDimension(k.f5398j0, 0.0f));
            m1(k10.getBoolean(k.O, false));
            r1(k10.getBoolean(k.R, false));
            if (attributeSet != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "checkedIconEnabled") != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "checkedIconVisible") == null) {
                r1(k10.getBoolean(k.Q, false));
            }
            o1(c.d(this.f5989i0, k10, k.P));
            o2(d.b(this.f5989i0, k10, k.f5456t0));
            e2(d.b(this.f5989i0, k10, k.f5428o0));
            I1(k10.getDimension(k.f5356c0, 0.0f));
            i2(k10.getDimension(k.f5440q0, 0.0f));
            g2(k10.getDimension(k.f5434p0, 0.0f));
            v2(k10.getDimension(k.f5466v0, 0.0f));
            t2(k10.getDimension(k.f5461u0, 0.0f));
            W1(k10.getDimension(k.f5404k0, 0.0f));
            R1(k10.getDimension(k.f5392i0, 0.0f));
            w1(k10.getDimension(k.U, 0.0f));
            k2(k10.getDimensionPixelSize(k.M, Integer.MAX_VALUE));
            k10.recycle();
        } else {
            truncateAt = TextUtils.TruncateAt.MIDDLE;
        }
        d2(truncateAt);
        F1(k10.getBoolean(k.Z, false));
        if (attributeSet != null) {
            F1(k10.getBoolean(k.W, false));
        }
        y1(c.d(this.f5989i0, k10, k.V));
        i12 = k.Y;
        if (k10.hasValue(i12)) {
        }
        A1(k10.getDimension(k.X, 0.0f));
        b2(k10.getBoolean(k.f5416m0, false));
        if (attributeSet != null) {
            b2(k10.getBoolean(k.f5386h0, false));
        }
        P1(c.d(this.f5989i0, k10, k.f5380g0));
        Z1(c.a(this.f5989i0, k10, k.f5410l0));
        U1(k10.getDimension(k.f5398j0, 0.0f));
        m1(k10.getBoolean(k.O, false));
        r1(k10.getBoolean(k.R, false));
        if (attributeSet != null) {
            r1(k10.getBoolean(k.Q, false));
        }
        o1(c.d(this.f5989i0, k10, k.P));
        o2(d.b(this.f5989i0, k10, k.f5456t0));
        e2(d.b(this.f5989i0, k10, k.f5428o0));
        I1(k10.getDimension(k.f5356c0, 0.0f));
        i2(k10.getDimension(k.f5440q0, 0.0f));
        g2(k10.getDimension(k.f5434p0, 0.0f));
        v2(k10.getDimension(k.f5466v0, 0.0f));
        t2(k10.getDimension(k.f5461u0, 0.0f));
        W1(k10.getDimension(k.f5404k0, 0.0f));
        R1(k10.getDimension(k.f5392i0, 0.0f));
        w1(k10.getDimension(k.U, 0.0f));
        k2(k10.getDimensionPixelSize(k.M, Integer.MAX_VALUE));
        k10.recycle();
    }

    private float k0() {
        this.f5996p0.e().getFontMetrics(this.f5992l0);
        Paint.FontMetrics fontMetrics = this.f5992l0;
        return (fontMetrics.descent + fontMetrics.ascent) / 2.0f;
    }

    /* JADX WARN: Removed duplicated region for block: B:71:0x00db  */
    /* JADX WARN: Removed duplicated region for block: B:72:0x00e2  */
    /* JADX WARN: Removed duplicated region for block: B:75:0x00e7  */
    /* JADX WARN: Removed duplicated region for block: B:76:0x00f4  */
    /* JADX WARN: Removed duplicated region for block: B:79:0x00fd  */
    /* JADX WARN: Removed duplicated region for block: B:82:0x010c  */
    /* JADX WARN: Removed duplicated region for block: B:85:0x011b  */
    /* JADX WARN: Removed duplicated region for block: B:92:0x0145  */
    /* JADX WARN: Removed duplicated region for block: B:94:0x014a  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private boolean l1(int[] iArr, int[] iArr2) {
        boolean z9;
        int colorForState;
        boolean onStateChange = super.onStateChange(iArr);
        ColorStateList colorStateList = this.C;
        int colorForState2 = colorStateList != null ? colorStateList.getColorForState(iArr, this.f5997q0) : 0;
        boolean z10 = true;
        if (this.f5997q0 != colorForState2) {
            this.f5997q0 = colorForState2;
            onStateChange = true;
        }
        ColorStateList colorStateList2 = this.D;
        int colorForState3 = colorStateList2 != null ? colorStateList2.getColorForState(iArr, this.f5998r0) : 0;
        if (this.f5998r0 != colorForState3) {
            this.f5998r0 = colorForState3;
            onStateChange = true;
        }
        int e10 = g6.a.e(colorForState2, colorForState3);
        if ((this.f5999s0 != e10) | (w() == null)) {
            this.f5999s0 = e10;
            R(ColorStateList.valueOf(e10));
            onStateChange = true;
        }
        ColorStateList colorStateList3 = this.G;
        int colorForState4 = colorStateList3 != null ? colorStateList3.getColorForState(iArr, this.f6000t0) : 0;
        if (this.f6000t0 != colorForState4) {
            this.f6000t0 = colorForState4;
            onStateChange = true;
        }
        int colorForState5 = (this.F0 == null || !b.b(iArr)) ? 0 : this.F0.getColorForState(iArr, this.f6001u0);
        if (this.f6001u0 != colorForState5) {
            this.f6001u0 = colorForState5;
            if (this.E0) {
                onStateChange = true;
            }
        }
        int colorForState6 = (this.f5996p0.d() == null || this.f5996p0.d().f10187b == null) ? 0 : this.f5996p0.d().f10187b.getColorForState(iArr, this.f6002v0);
        if (this.f6002v0 != colorForState6) {
            this.f6002v0 = colorForState6;
            onStateChange = true;
        }
        boolean z11 = c1(getState(), 16842912) && this.V;
        if (this.f6003w0 != z11 && this.X != null) {
            float e02 = e0();
            this.f6003w0 = z11;
            if (e02 != e0()) {
                onStateChange = true;
                z9 = true;
                ColorStateList colorStateList4 = this.B0;
                colorForState = colorStateList4 == null ? colorStateList4.getColorForState(iArr, this.f6004x0) : 0;
                if (this.f6004x0 == colorForState) {
                    this.f6004x0 = colorForState;
                    this.A0 = i6.a.a(this, this.B0, this.C0);
                } else {
                    z10 = onStateChange;
                }
                if (h1(this.L)) {
                    z10 |= this.L.setState(iArr);
                }
                if (h1(this.X)) {
                    z10 |= this.X.setState(iArr);
                }
                if (h1(this.Q)) {
                    int[] iArr3 = new int[iArr.length + iArr2.length];
                    System.arraycopy(iArr, 0, iArr3, 0, iArr.length);
                    System.arraycopy(iArr2, 0, iArr3, iArr.length, iArr2.length);
                    z10 |= this.Q.setState(iArr3);
                }
                if (b.f10517a && h1(this.R)) {
                    z10 |= this.R.setState(iArr2);
                }
                if (z10) {
                    invalidateSelf();
                }
                if (z9) {
                    k1();
                }
                return z10;
            }
            onStateChange = true;
        }
        z9 = false;
        ColorStateList colorStateList42 = this.B0;
        if (colorStateList42 == null) {
        }
        if (this.f6004x0 == colorForState) {
        }
        if (h1(this.L)) {
        }
        if (h1(this.X)) {
        }
        if (h1(this.Q)) {
        }
        if (b.f10517a) {
            z10 |= this.R.setState(iArr2);
        }
        if (z10) {
        }
        if (z9) {
        }
        return z10;
    }

    private boolean m0() {
        return this.W && this.X != null && this.V;
    }

    public static a n0(Context context, AttributeSet attributeSet, int i10, int i11) {
        a aVar = new a(context, attributeSet, i10, i11);
        aVar.j1(attributeSet, i10, i11);
        return aVar;
    }

    private void o0(Canvas canvas, Rect rect) {
        if (z2()) {
            d0(rect, this.f5993m0);
            RectF rectF = this.f5993m0;
            float f10 = rectF.left;
            float f11 = rectF.top;
            canvas.translate(f10, f11);
            this.X.setBounds(0, 0, (int) this.f5993m0.width(), (int) this.f5993m0.height());
            this.X.draw(canvas);
            canvas.translate(-f10, -f11);
        }
    }

    private void p0(Canvas canvas, Rect rect) {
        if (this.K0) {
            return;
        }
        this.f5990j0.setColor(this.f5998r0);
        this.f5990j0.setStyle(Paint.Style.FILL);
        this.f5990j0.setColorFilter(a1());
        this.f5993m0.set(rect);
        canvas.drawRoundRect(this.f5993m0, z0(), z0(), this.f5990j0);
    }

    private void q0(Canvas canvas, Rect rect) {
        if (A2()) {
            d0(rect, this.f5993m0);
            RectF rectF = this.f5993m0;
            float f10 = rectF.left;
            float f11 = rectF.top;
            canvas.translate(f10, f11);
            this.L.setBounds(0, 0, (int) this.f5993m0.width(), (int) this.f5993m0.height());
            this.L.draw(canvas);
            canvas.translate(-f10, -f11);
        }
    }

    private void r0(Canvas canvas, Rect rect) {
        if (this.H <= 0.0f || this.K0) {
            return;
        }
        this.f5990j0.setColor(this.f6000t0);
        this.f5990j0.setStyle(Paint.Style.STROKE);
        if (!this.K0) {
            this.f5990j0.setColorFilter(a1());
        }
        RectF rectF = this.f5993m0;
        float f10 = this.H;
        rectF.set(rect.left + (f10 / 2.0f), rect.top + (f10 / 2.0f), rect.right - (f10 / 2.0f), rect.bottom - (f10 / 2.0f));
        float f11 = this.F - (this.H / 2.0f);
        canvas.drawRoundRect(this.f5993m0, f11, f11, this.f5990j0);
    }

    private void s0(Canvas canvas, Rect rect) {
        if (this.K0) {
            return;
        }
        this.f5990j0.setColor(this.f5997q0);
        this.f5990j0.setStyle(Paint.Style.FILL);
        this.f5993m0.set(rect);
        canvas.drawRoundRect(this.f5993m0, z0(), z0(), this.f5990j0);
    }

    private void t0(Canvas canvas, Rect rect) {
        Drawable drawable;
        if (B2()) {
            g0(rect, this.f5993m0);
            RectF rectF = this.f5993m0;
            float f10 = rectF.left;
            float f11 = rectF.top;
            canvas.translate(f10, f11);
            this.Q.setBounds(0, 0, (int) this.f5993m0.width(), (int) this.f5993m0.height());
            if (b.f10517a) {
                this.R.setBounds(this.Q.getBounds());
                this.R.jumpToCurrentState();
                drawable = this.R;
            } else {
                drawable = this.Q;
            }
            drawable.draw(canvas);
            canvas.translate(-f10, -f11);
        }
    }

    private void u0(Canvas canvas, Rect rect) {
        this.f5990j0.setColor(this.f6001u0);
        this.f5990j0.setStyle(Paint.Style.FILL);
        this.f5993m0.set(rect);
        if (!this.K0) {
            canvas.drawRoundRect(this.f5993m0, z0(), z0(), this.f5990j0);
            return;
        }
        g(new RectF(rect), this.f5995o0);
        super.o(canvas, this.f5990j0, this.f5995o0, t());
    }

    private void v0(Canvas canvas, Rect rect) {
        Paint paint = this.f5991k0;
        if (paint != null) {
            paint.setColor(androidx.core.graphics.a.f(-16777216, 127));
            canvas.drawRect(rect, this.f5991k0);
            if (A2() || z2()) {
                d0(rect, this.f5993m0);
                canvas.drawRect(this.f5993m0, this.f5991k0);
            }
            if (this.J != null) {
                canvas.drawLine(rect.left, rect.exactCenterY(), rect.right, rect.exactCenterY(), this.f5991k0);
            }
            if (B2()) {
                g0(rect, this.f5993m0);
                canvas.drawRect(this.f5993m0, this.f5991k0);
            }
            this.f5991k0.setColor(androidx.core.graphics.a.f(-65536, 127));
            f0(rect, this.f5993m0);
            canvas.drawRect(this.f5993m0, this.f5991k0);
            this.f5991k0.setColor(androidx.core.graphics.a.f(-16711936, 127));
            h0(rect, this.f5993m0);
            canvas.drawRect(this.f5993m0, this.f5991k0);
        }
    }

    private void w0(Canvas canvas, Rect rect) {
        if (this.J != null) {
            Paint.Align l02 = l0(rect, this.f5994n0);
            j0(rect, this.f5993m0);
            if (this.f5996p0.d() != null) {
                this.f5996p0.e().drawableState = getState();
                this.f5996p0.j(this.f5989i0);
            }
            this.f5996p0.e().setTextAlign(l02);
            int i10 = 0;
            boolean z9 = Math.round(this.f5996p0.f(W0().toString())) > Math.round(this.f5993m0.width());
            if (z9) {
                i10 = canvas.save();
                canvas.clipRect(this.f5993m0);
            }
            CharSequence charSequence = this.J;
            if (z9 && this.H0 != null) {
                charSequence = TextUtils.ellipsize(charSequence, this.f5996p0.e(), this.f5993m0.width(), this.H0);
            }
            CharSequence charSequence2 = charSequence;
            int length = charSequence2.length();
            PointF pointF = this.f5994n0;
            canvas.drawText(charSequence2, 0, length, pointF.x, pointF.y, this.f5996p0.e());
            if (z9) {
                canvas.restoreToCount(i10);
            }
        }
    }

    private boolean z2() {
        return this.W && this.X != null && this.f6003w0;
    }

    public float A0() {
        return this.f5988h0;
    }

    public void A1(float f10) {
        if (this.N != f10) {
            float e02 = e0();
            this.N = f10;
            float e03 = e0();
            invalidateSelf();
            if (e02 != e03) {
                k1();
            }
        }
    }

    public Drawable B0() {
        Drawable drawable = this.L;
        if (drawable != null) {
            return androidx.core.graphics.drawable.a.q(drawable);
        }
        return null;
    }

    public void B1(int i10) {
        A1(this.f5989i0.getResources().getDimension(i10));
    }

    public float C0() {
        return this.N;
    }

    public void C1(ColorStateList colorStateList) {
        this.O = true;
        if (this.M != colorStateList) {
            this.M = colorStateList;
            if (A2()) {
                androidx.core.graphics.drawable.a.o(this.L, colorStateList);
            }
            onStateChange(getState());
        }
    }

    public ColorStateList D0() {
        return this.M;
    }

    public void D1(int i10) {
        C1(h.a.a(this.f5989i0, i10));
    }

    public float E0() {
        return this.E;
    }

    public void E1(int i10) {
        F1(this.f5989i0.getResources().getBoolean(i10));
    }

    public float F0() {
        return this.f5981a0;
    }

    public void F1(boolean z9) {
        if (this.K != z9) {
            boolean A2 = A2();
            this.K = z9;
            boolean A22 = A2();
            if (A2 != A22) {
                if (A22) {
                    c0(this.L);
                } else {
                    C2(this.L);
                }
                invalidateSelf();
                k1();
            }
        }
    }

    public ColorStateList G0() {
        return this.G;
    }

    public void G1(float f10) {
        if (this.E != f10) {
            this.E = f10;
            invalidateSelf();
            k1();
        }
    }

    public float H0() {
        return this.H;
    }

    public void H1(int i10) {
        G1(this.f5989i0.getResources().getDimension(i10));
    }

    public Drawable I0() {
        Drawable drawable = this.Q;
        if (drawable != null) {
            return androidx.core.graphics.drawable.a.q(drawable);
        }
        return null;
    }

    public void I1(float f10) {
        if (this.f5981a0 != f10) {
            this.f5981a0 = f10;
            invalidateSelf();
            k1();
        }
    }

    public CharSequence J0() {
        return this.U;
    }

    public void J1(int i10) {
        I1(this.f5989i0.getResources().getDimension(i10));
    }

    public float K0() {
        return this.f5987g0;
    }

    public void K1(ColorStateList colorStateList) {
        if (this.G != colorStateList) {
            this.G = colorStateList;
            if (this.K0) {
                X(colorStateList);
            }
            onStateChange(getState());
        }
    }

    public float L0() {
        return this.T;
    }

    public void L1(int i10) {
        K1(h.a.a(this.f5989i0, i10));
    }

    public float M0() {
        return this.f5986f0;
    }

    public void M1(float f10) {
        if (this.H != f10) {
            this.H = f10;
            this.f5990j0.setStrokeWidth(f10);
            if (this.K0) {
                super.Y(f10);
            }
            invalidateSelf();
        }
    }

    public int[] N0() {
        return this.D0;
    }

    public void N1(int i10) {
        M1(this.f5989i0.getResources().getDimension(i10));
    }

    public ColorStateList O0() {
        return this.S;
    }

    public void P0(RectF rectF) {
        h0(getBounds(), rectF);
    }

    public void P1(Drawable drawable) {
        Drawable I0 = I0();
        if (I0 != drawable) {
            float i02 = i0();
            this.Q = drawable != null ? androidx.core.graphics.drawable.a.r(drawable).mutate() : null;
            if (b.f10517a) {
                E2();
            }
            float i03 = i0();
            C2(I0);
            if (B2()) {
                c0(this.Q);
            }
            invalidateSelf();
            if (i02 != i03) {
                k1();
            }
        }
    }

    public TextUtils.TruncateAt Q0() {
        return this.H0;
    }

    public void Q1(CharSequence charSequence) {
        if (this.U != charSequence) {
            this.U = androidx.core.text.a.c().h(charSequence);
            invalidateSelf();
        }
    }

    public d R0() {
        return this.Z;
    }

    public void R1(float f10) {
        if (this.f5987g0 != f10) {
            this.f5987g0 = f10;
            invalidateSelf();
            if (B2()) {
                k1();
            }
        }
    }

    public float S0() {
        return this.f5983c0;
    }

    public void S1(int i10) {
        R1(this.f5989i0.getResources().getDimension(i10));
    }

    public float T0() {
        return this.f5982b0;
    }

    public void T1(int i10) {
        P1(h.a.b(this.f5989i0, i10));
    }

    public ColorStateList U0() {
        return this.I;
    }

    public void U1(float f10) {
        if (this.T != f10) {
            this.T = f10;
            invalidateSelf();
            if (B2()) {
                k1();
            }
        }
    }

    public d V0() {
        return this.Y;
    }

    public void V1(int i10) {
        U1(this.f5989i0.getResources().getDimension(i10));
    }

    public CharSequence W0() {
        return this.J;
    }

    public void W1(float f10) {
        if (this.f5986f0 != f10) {
            this.f5986f0 = f10;
            invalidateSelf();
            if (B2()) {
                k1();
            }
        }
    }

    public m6.d X0() {
        return this.f5996p0.d();
    }

    public void X1(int i10) {
        W1(this.f5989i0.getResources().getDimension(i10));
    }

    public float Y0() {
        return this.f5985e0;
    }

    public boolean Y1(int[] iArr) {
        if (Arrays.equals(this.D0, iArr)) {
            return false;
        }
        this.D0 = iArr;
        if (B2()) {
            return l1(getState(), iArr);
        }
        return false;
    }

    public float Z0() {
        return this.f5984d0;
    }

    public void Z1(ColorStateList colorStateList) {
        if (this.S != colorStateList) {
            this.S = colorStateList;
            if (B2()) {
                androidx.core.graphics.drawable.a.o(this.Q, colorStateList);
            }
            onStateChange(getState());
        }
    }

    @Override // com.google.android.material.internal.e.b
    public void a() {
        k1();
        invalidateSelf();
    }

    public void a2(int i10) {
        Z1(h.a.a(this.f5989i0, i10));
    }

    public boolean b1() {
        return this.E0;
    }

    public void b2(boolean z9) {
        if (this.P != z9) {
            boolean B2 = B2();
            this.P = z9;
            boolean B22 = B2();
            if (B2 != B22) {
                if (B22) {
                    c0(this.Q);
                } else {
                    C2(this.Q);
                }
                invalidateSelf();
                k1();
            }
        }
    }

    public void c2(InterfaceC0086a interfaceC0086a) {
        this.G0 = new WeakReference(interfaceC0086a);
    }

    public boolean d1() {
        return this.V;
    }

    public void d2(TextUtils.TruncateAt truncateAt) {
        this.H0 = truncateAt;
    }

    @Override // p6.g, android.graphics.drawable.Drawable
    public void draw(Canvas canvas) {
        Rect bounds = getBounds();
        if (bounds.isEmpty() || getAlpha() == 0) {
            return;
        }
        int i10 = this.f6005y0;
        int a10 = i10 < 255 ? e6.a.a(canvas, bounds.left, bounds.top, bounds.right, bounds.bottom, i10) : 0;
        s0(canvas, bounds);
        p0(canvas, bounds);
        if (this.K0) {
            super.draw(canvas);
        }
        r0(canvas, bounds);
        u0(canvas, bounds);
        q0(canvas, bounds);
        o0(canvas, bounds);
        if (this.I0) {
            w0(canvas, bounds);
        }
        t0(canvas, bounds);
        v0(canvas, bounds);
        if (this.f6005y0 < 255) {
            canvas.restoreToCount(a10);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public float e0() {
        if (A2() || z2()) {
            return this.f5982b0 + this.N + this.f5983c0;
        }
        return 0.0f;
    }

    public boolean e1() {
        return h1(this.Q);
    }

    public void e2(d dVar) {
        this.Z = dVar;
    }

    public boolean f1() {
        return this.P;
    }

    public void f2(int i10) {
        e2(d.c(this.f5989i0, i10));
    }

    public void g2(float f10) {
        if (this.f5983c0 != f10) {
            float e02 = e0();
            this.f5983c0 = f10;
            float e03 = e0();
            invalidateSelf();
            if (e02 != e03) {
                k1();
            }
        }
    }

    @Override // android.graphics.drawable.Drawable
    public int getAlpha() {
        return this.f6005y0;
    }

    @Override // android.graphics.drawable.Drawable
    public ColorFilter getColorFilter() {
        return this.f6006z0;
    }

    @Override // android.graphics.drawable.Drawable
    public int getIntrinsicHeight() {
        return (int) this.E;
    }

    @Override // android.graphics.drawable.Drawable
    public int getIntrinsicWidth() {
        return Math.min(Math.round(this.f5981a0 + e0() + this.f5984d0 + this.f5996p0.f(W0().toString()) + this.f5985e0 + i0() + this.f5988h0), this.J0);
    }

    @Override // p6.g, android.graphics.drawable.Drawable
    public int getOpacity() {
        return -3;
    }

    @Override // p6.g, android.graphics.drawable.Drawable
    public void getOutline(Outline outline) {
        if (this.K0) {
            super.getOutline(outline);
            return;
        }
        Rect bounds = getBounds();
        if (bounds.isEmpty()) {
            outline.setRoundRect(0, 0, getIntrinsicWidth(), getIntrinsicHeight(), this.F);
        } else {
            outline.setRoundRect(bounds, this.F);
        }
        outline.setAlpha(getAlpha() / 255.0f);
    }

    public void h2(int i10) {
        g2(this.f5989i0.getResources().getDimension(i10));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public float i0() {
        if (B2()) {
            return this.f5986f0 + this.T + this.f5987g0;
        }
        return 0.0f;
    }

    public void i2(float f10) {
        if (this.f5982b0 != f10) {
            float e02 = e0();
            this.f5982b0 = f10;
            float e03 = e0();
            invalidateSelf();
            if (e02 != e03) {
                k1();
            }
        }
    }

    @Override // android.graphics.drawable.Drawable.Callback
    public void invalidateDrawable(Drawable drawable) {
        Drawable.Callback callback = getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    @Override // p6.g, android.graphics.drawable.Drawable
    public boolean isStateful() {
        return g1(this.C) || g1(this.D) || g1(this.G) || (this.E0 && g1(this.F0)) || i1(this.f5996p0.d()) || m0() || h1(this.L) || h1(this.X) || g1(this.B0);
    }

    public void j2(int i10) {
        i2(this.f5989i0.getResources().getDimension(i10));
    }

    protected void k1() {
        InterfaceC0086a interfaceC0086a = (InterfaceC0086a) this.G0.get();
        if (interfaceC0086a != null) {
            interfaceC0086a.a();
        }
    }

    public void k2(int i10) {
        this.J0 = i10;
    }

    Paint.Align l0(Rect rect, PointF pointF) {
        pointF.set(0.0f, 0.0f);
        Paint.Align align = Paint.Align.LEFT;
        if (this.J != null) {
            float e02 = this.f5981a0 + e0() + this.f5984d0;
            if (androidx.core.graphics.drawable.a.f(this) == 0) {
                pointF.x = rect.left + e02;
                align = Paint.Align.LEFT;
            } else {
                pointF.x = rect.right - e02;
                align = Paint.Align.RIGHT;
            }
            pointF.y = rect.centerY() - k0();
        }
        return align;
    }

    public void l2(ColorStateList colorStateList) {
        if (this.I != colorStateList) {
            this.I = colorStateList;
            D2();
            onStateChange(getState());
        }
    }

    public void m1(boolean z9) {
        if (this.V != z9) {
            this.V = z9;
            float e02 = e0();
            if (!z9 && this.f6003w0) {
                this.f6003w0 = false;
            }
            float e03 = e0();
            invalidateSelf();
            if (e02 != e03) {
                k1();
            }
        }
    }

    public void m2(int i10) {
        l2(h.a.a(this.f5989i0, i10));
    }

    public void n1(int i10) {
        m1(this.f5989i0.getResources().getBoolean(i10));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void n2(boolean z9) {
        this.I0 = z9;
    }

    public void o1(Drawable drawable) {
        if (this.X != drawable) {
            float e02 = e0();
            this.X = drawable;
            float e03 = e0();
            C2(this.X);
            c0(this.X);
            invalidateSelf();
            if (e02 != e03) {
                k1();
            }
        }
    }

    public void o2(d dVar) {
        this.Y = dVar;
    }

    @Override // android.graphics.drawable.Drawable
    public boolean onLayoutDirectionChanged(int i10) {
        boolean onLayoutDirectionChanged = super.onLayoutDirectionChanged(i10);
        if (A2()) {
            onLayoutDirectionChanged |= androidx.core.graphics.drawable.a.m(this.L, i10);
        }
        if (z2()) {
            onLayoutDirectionChanged |= androidx.core.graphics.drawable.a.m(this.X, i10);
        }
        if (B2()) {
            onLayoutDirectionChanged |= androidx.core.graphics.drawable.a.m(this.Q, i10);
        }
        if (onLayoutDirectionChanged) {
            invalidateSelf();
            return true;
        }
        return true;
    }

    @Override // android.graphics.drawable.Drawable
    protected boolean onLevelChange(int i10) {
        boolean onLevelChange = super.onLevelChange(i10);
        if (A2()) {
            onLevelChange |= this.L.setLevel(i10);
        }
        if (z2()) {
            onLevelChange |= this.X.setLevel(i10);
        }
        if (B2()) {
            onLevelChange |= this.Q.setLevel(i10);
        }
        if (onLevelChange) {
            invalidateSelf();
        }
        return onLevelChange;
    }

    @Override // p6.g, android.graphics.drawable.Drawable, com.google.android.material.internal.e.b
    public boolean onStateChange(int[] iArr) {
        if (this.K0) {
            super.onStateChange(iArr);
        }
        return l1(iArr, N0());
    }

    public void p1(int i10) {
        o1(h.a.b(this.f5989i0, i10));
    }

    public void p2(int i10) {
        o2(d.c(this.f5989i0, i10));
    }

    public void q1(int i10) {
        r1(this.f5989i0.getResources().getBoolean(i10));
    }

    public void q2(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "";
        }
        if (TextUtils.equals(this.J, charSequence)) {
            return;
        }
        this.J = charSequence;
        this.f5996p0.i(true);
        invalidateSelf();
        k1();
    }

    public void r1(boolean z9) {
        if (this.W != z9) {
            boolean z22 = z2();
            this.W = z9;
            boolean z23 = z2();
            if (z22 != z23) {
                if (z23) {
                    c0(this.X);
                } else {
                    C2(this.X);
                }
                invalidateSelf();
                k1();
            }
        }
    }

    public void r2(m6.d dVar) {
        this.f5996p0.h(dVar, this.f5989i0);
    }

    public void s1(ColorStateList colorStateList) {
        if (this.D != colorStateList) {
            this.D = colorStateList;
            onStateChange(getState());
        }
    }

    public void s2(int i10) {
        r2(new m6.d(this.f5989i0, i10));
    }

    @Override // android.graphics.drawable.Drawable.Callback
    public void scheduleDrawable(Drawable drawable, Runnable runnable, long j10) {
        Drawable.Callback callback = getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, runnable, j10);
        }
    }

    @Override // p6.g, android.graphics.drawable.Drawable
    public void setAlpha(int i10) {
        if (this.f6005y0 != i10) {
            this.f6005y0 = i10;
            invalidateSelf();
        }
    }

    @Override // p6.g, android.graphics.drawable.Drawable
    public void setColorFilter(ColorFilter colorFilter) {
        if (this.f6006z0 != colorFilter) {
            this.f6006z0 = colorFilter;
            invalidateSelf();
        }
    }

    @Override // p6.g, android.graphics.drawable.Drawable
    public void setTintList(ColorStateList colorStateList) {
        if (this.B0 != colorStateList) {
            this.B0 = colorStateList;
            onStateChange(getState());
        }
    }

    @Override // p6.g, android.graphics.drawable.Drawable
    public void setTintMode(PorterDuff.Mode mode) {
        if (this.C0 != mode) {
            this.C0 = mode;
            this.A0 = i6.a.a(this, this.B0, mode);
            invalidateSelf();
        }
    }

    @Override // android.graphics.drawable.Drawable
    public boolean setVisible(boolean z9, boolean z10) {
        boolean visible = super.setVisible(z9, z10);
        if (A2()) {
            visible |= this.L.setVisible(z9, z10);
        }
        if (z2()) {
            visible |= this.X.setVisible(z9, z10);
        }
        if (B2()) {
            visible |= this.Q.setVisible(z9, z10);
        }
        if (visible) {
            invalidateSelf();
        }
        return visible;
    }

    public void t1(int i10) {
        s1(h.a.a(this.f5989i0, i10));
    }

    public void t2(float f10) {
        if (this.f5985e0 != f10) {
            this.f5985e0 = f10;
            invalidateSelf();
            k1();
        }
    }

    public void u1(float f10) {
        if (this.F != f10) {
            this.F = f10;
            setShapeAppearanceModel(A().w(f10));
        }
    }

    public void u2(int i10) {
        t2(this.f5989i0.getResources().getDimension(i10));
    }

    @Override // android.graphics.drawable.Drawable.Callback
    public void unscheduleDrawable(Drawable drawable, Runnable runnable) {
        Drawable.Callback callback = getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, runnable);
        }
    }

    public void v1(int i10) {
        u1(this.f5989i0.getResources().getDimension(i10));
    }

    public void v2(float f10) {
        if (this.f5984d0 != f10) {
            this.f5984d0 = f10;
            invalidateSelf();
            k1();
        }
    }

    public void w1(float f10) {
        if (this.f5988h0 != f10) {
            this.f5988h0 = f10;
            invalidateSelf();
            k1();
        }
    }

    public void w2(int i10) {
        v2(this.f5989i0.getResources().getDimension(i10));
    }

    public Drawable x0() {
        return this.X;
    }

    public void x1(int i10) {
        w1(this.f5989i0.getResources().getDimension(i10));
    }

    public void x2(boolean z9) {
        if (this.E0 != z9) {
            this.E0 = z9;
            D2();
            onStateChange(getState());
        }
    }

    public ColorStateList y0() {
        return this.D;
    }

    public void y1(Drawable drawable) {
        Drawable B0 = B0();
        if (B0 != drawable) {
            float e02 = e0();
            this.L = drawable != null ? androidx.core.graphics.drawable.a.r(drawable).mutate() : null;
            float e03 = e0();
            C2(B0);
            if (A2()) {
                c0(this.L);
            }
            invalidateSelf();
            if (e02 != e03) {
                k1();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean y2() {
        return this.I0;
    }

    public float z0() {
        return this.K0 ? C() : this.F;
    }

    public void z1(int i10) {
        y1(h.a.b(this.f5989i0, i10));
    }
}
