package com.google.android.material.chip;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import c6.j;
import c6.k;
import com.google.android.material.internal.f;
/* loaded from: classes.dex */
public class ChipGroup extends com.google.android.material.internal.c {

    /* renamed from: j  reason: collision with root package name */
    private int f5970j;

    /* renamed from: k  reason: collision with root package name */
    private int f5971k;

    /* renamed from: l  reason: collision with root package name */
    private boolean f5972l;

    /* renamed from: m  reason: collision with root package name */
    private d f5973m;

    /* renamed from: n  reason: collision with root package name */
    private final b f5974n;

    /* renamed from: o  reason: collision with root package name */
    private e f5975o;

    /* renamed from: p  reason: collision with root package name */
    private int f5976p;

    /* renamed from: q  reason: collision with root package name */
    private boolean f5977q;

    /* loaded from: classes.dex */
    private class b implements CompoundButton.OnCheckedChangeListener {
        private b() {
        }

        @Override // android.widget.CompoundButton.OnCheckedChangeListener
        public void onCheckedChanged(CompoundButton compoundButton, boolean z9) {
            if (ChipGroup.this.f5977q) {
                return;
            }
            int id = compoundButton.getId();
            if (!z9) {
                if (ChipGroup.this.f5976p == id) {
                    ChipGroup.this.setCheckedId(-1);
                    return;
                }
                return;
            }
            if (ChipGroup.this.f5976p != -1 && ChipGroup.this.f5976p != id && ChipGroup.this.f5972l) {
                ChipGroup chipGroup = ChipGroup.this;
                chipGroup.k(chipGroup.f5976p, false);
            }
            ChipGroup.this.setCheckedId(id);
        }
    }

    /* loaded from: classes.dex */
    public static class c extends ViewGroup.MarginLayoutParams {
        public c(int i10, int i11) {
            super(i10, i11);
        }

        public c(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public c(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    /* loaded from: classes.dex */
    public interface d {
        void a(ChipGroup chipGroup, int i10);
    }

    /* loaded from: classes.dex */
    private class e implements ViewGroup.OnHierarchyChangeListener {

        /* renamed from: g  reason: collision with root package name */
        private ViewGroup.OnHierarchyChangeListener f5979g;

        private e() {
        }

        @Override // android.view.ViewGroup.OnHierarchyChangeListener
        public void onChildViewAdded(View view, View view2) {
            if (view == ChipGroup.this && (view2 instanceof Chip)) {
                if (view2.getId() == -1) {
                    view2.setId(View.generateViewId());
                }
                ((Chip) view2).setOnCheckedChangeListenerInternal(ChipGroup.this.f5974n);
            }
            ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = this.f5979g;
            if (onHierarchyChangeListener != null) {
                onHierarchyChangeListener.onChildViewAdded(view, view2);
            }
        }

        @Override // android.view.ViewGroup.OnHierarchyChangeListener
        public void onChildViewRemoved(View view, View view2) {
            if (view == ChipGroup.this && (view2 instanceof Chip)) {
                ((Chip) view2).setOnCheckedChangeListenerInternal(null);
            }
            ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = this.f5979g;
            if (onHierarchyChangeListener != null) {
                onHierarchyChangeListener.onChildViewRemoved(view, view2);
            }
        }
    }

    public ChipGroup(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, c6.b.chipGroupStyle);
    }

    public ChipGroup(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.f5974n = new b();
        this.f5975o = new e();
        this.f5976p = -1;
        this.f5977q = false;
        TypedArray k10 = f.k(context, attributeSet, k.f5471w0, i10, j.Widget_MaterialComponents_ChipGroup, new int[0]);
        int dimensionPixelOffset = k10.getDimensionPixelOffset(k.f5481y0, 0);
        setChipSpacingHorizontal(k10.getDimensionPixelOffset(k.f5486z0, dimensionPixelOffset));
        setChipSpacingVertical(k10.getDimensionPixelOffset(k.A0, dimensionPixelOffset));
        setSingleLine(k10.getBoolean(k.B0, false));
        setSingleSelection(k10.getBoolean(k.C0, false));
        int resourceId = k10.getResourceId(k.f5476x0, -1);
        if (resourceId != -1) {
            this.f5976p = resourceId;
        }
        k10.recycle();
        super.setOnHierarchyChangeListener(this.f5975o);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void k(int i10, boolean z9) {
        View findViewById = findViewById(i10);
        if (findViewById instanceof Chip) {
            this.f5977q = true;
            ((Chip) findViewById).setChecked(z9);
            this.f5977q = false;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void setCheckedId(int i10) {
        this.f5976p = i10;
        d dVar = this.f5973m;
        if (dVar == null || !this.f5972l) {
            return;
        }
        dVar.a(this, i10);
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i10, ViewGroup.LayoutParams layoutParams) {
        if (view instanceof Chip) {
            Chip chip = (Chip) view;
            if (chip.isChecked()) {
                int i11 = this.f5976p;
                if (i11 != -1 && this.f5972l) {
                    k(i11, false);
                }
                setCheckedId(chip.getId());
            }
        }
        super.addView(view, i10, layoutParams);
    }

    @Override // com.google.android.material.internal.c
    public boolean b() {
        return super.b();
    }

    @Override // android.view.ViewGroup
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return super.checkLayoutParams(layoutParams) && (layoutParams instanceof c);
    }

    @Override // android.view.ViewGroup
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new c(-2, -2);
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new c(getContext(), attributeSet);
    }

    @Override // android.view.ViewGroup
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new c(layoutParams);
    }

    public int getCheckedChipId() {
        if (this.f5972l) {
            return this.f5976p;
        }
        return -1;
    }

    public int getChipSpacingHorizontal() {
        return this.f5970j;
    }

    public int getChipSpacingVertical() {
        return this.f5971k;
    }

    public void j() {
        this.f5977q = true;
        for (int i10 = 0; i10 < getChildCount(); i10++) {
            View childAt = getChildAt(i10);
            if (childAt instanceof Chip) {
                ((Chip) childAt).setChecked(false);
            }
        }
        this.f5977q = false;
        setCheckedId(-1);
    }

    @Override // android.view.View
    protected void onFinishInflate() {
        super.onFinishInflate();
        int i10 = this.f5976p;
        if (i10 != -1) {
            k(i10, true);
            setCheckedId(this.f5976p);
        }
    }

    public void setChipSpacing(int i10) {
        setChipSpacingHorizontal(i10);
        setChipSpacingVertical(i10);
    }

    public void setChipSpacingHorizontal(int i10) {
        if (this.f5970j != i10) {
            this.f5970j = i10;
            setItemSpacing(i10);
            requestLayout();
        }
    }

    public void setChipSpacingHorizontalResource(int i10) {
        setChipSpacingHorizontal(getResources().getDimensionPixelOffset(i10));
    }

    public void setChipSpacingResource(int i10) {
        setChipSpacing(getResources().getDimensionPixelOffset(i10));
    }

    public void setChipSpacingVertical(int i10) {
        if (this.f5971k != i10) {
            this.f5971k = i10;
            setLineSpacing(i10);
            requestLayout();
        }
    }

    public void setChipSpacingVerticalResource(int i10) {
        setChipSpacingVertical(getResources().getDimensionPixelOffset(i10));
    }

    @Deprecated
    public void setDividerDrawableHorizontal(Drawable drawable) {
        throw new UnsupportedOperationException("Changing divider drawables have no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setDividerDrawableVertical(Drawable drawable) {
        throw new UnsupportedOperationException("Changing divider drawables have no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setFlexWrap(int i10) {
        throw new UnsupportedOperationException("Changing flex wrap not allowed. ChipGroup exposes a singleLine attribute instead.");
    }

    public void setOnCheckedChangeListener(d dVar) {
        this.f5973m = dVar;
    }

    @Override // android.view.ViewGroup
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.f5975o.f5979g = onHierarchyChangeListener;
    }

    @Deprecated
    public void setShowDividerHorizontal(int i10) {
        throw new UnsupportedOperationException("Changing divider modes has no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setShowDividerVertical(int i10) {
        throw new UnsupportedOperationException("Changing divider modes has no effect. ChipGroup do not use divider drawables as spacing.");
    }

    public void setSingleLine(int i10) {
        setSingleLine(getResources().getBoolean(i10));
    }

    @Override // com.google.android.material.internal.c
    public void setSingleLine(boolean z9) {
        super.setSingleLine(z9);
    }

    public void setSingleSelection(int i10) {
        setSingleSelection(getResources().getBoolean(i10));
    }

    public void setSingleSelection(boolean z9) {
        if (this.f5972l != z9) {
            this.f5972l = z9;
            j();
        }
    }
}
