package com.google.android.material.chip;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.appcompat.widget.g;
import androidx.core.view.r0;
import androidx.recyclerview.widget.RecyclerView;
import c6.i;
import c6.j;
import c6.k;
import com.google.android.material.chip.a;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import m6.d;
import m6.f;
import p6.h;
import p6.n;
import w.l;
/* loaded from: classes.dex */
public class Chip extends g implements a.InterfaceC0086a, n {
    private static final Rect A = new Rect();
    private static final int[] B = {16842913};
    private static final int[] C = {16842911};

    /* renamed from: k  reason: collision with root package name */
    private com.google.android.material.chip.a f5951k;

    /* renamed from: l  reason: collision with root package name */
    private InsetDrawable f5952l;

    /* renamed from: m  reason: collision with root package name */
    private RippleDrawable f5953m;

    /* renamed from: n  reason: collision with root package name */
    private View.OnClickListener f5954n;

    /* renamed from: o  reason: collision with root package name */
    private CompoundButton.OnCheckedChangeListener f5955o;

    /* renamed from: p  reason: collision with root package name */
    private boolean f5956p;

    /* renamed from: q  reason: collision with root package name */
    private boolean f5957q;

    /* renamed from: r  reason: collision with root package name */
    private boolean f5958r;

    /* renamed from: s  reason: collision with root package name */
    private boolean f5959s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f5960t;

    /* renamed from: u  reason: collision with root package name */
    private int f5961u;

    /* renamed from: v  reason: collision with root package name */
    private int f5962v;

    /* renamed from: w  reason: collision with root package name */
    private final c f5963w;

    /* renamed from: x  reason: collision with root package name */
    private final Rect f5964x;

    /* renamed from: y  reason: collision with root package name */
    private final RectF f5965y;

    /* renamed from: z  reason: collision with root package name */
    private final f f5966z;

    /* loaded from: classes.dex */
    class a extends f {
        a() {
        }

        @Override // m6.f
        public void a(int i10) {
        }

        @Override // m6.f
        public void b(Typeface typeface, boolean z9) {
            Chip chip = Chip.this;
            chip.setText(chip.f5951k.y2() ? Chip.this.f5951k.W0() : Chip.this.getText());
            Chip.this.requestLayout();
            Chip.this.invalidate();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b extends ViewOutlineProvider {
        b() {
        }

        @Override // android.view.ViewOutlineProvider
        public void getOutline(View view, Outline outline) {
            if (Chip.this.f5951k != null) {
                Chip.this.f5951k.getOutline(outline);
            } else {
                outline.setAlpha(0.0f);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class c extends c0.a {
        c(Chip chip) {
            super(chip);
        }

        @Override // c0.a
        protected int B(float f10, float f11) {
            return (Chip.this.m() && Chip.this.getCloseIconTouchBounds().contains(f10, f11)) ? 1 : 0;
        }

        @Override // c0.a
        protected void C(List list) {
            list.add(0);
            if (Chip.this.m() && Chip.this.r()) {
                list.add(1);
            }
        }

        @Override // c0.a
        protected boolean J(int i10, int i11, Bundle bundle) {
            if (i11 == 16) {
                if (i10 == 0) {
                    return Chip.this.performClick();
                }
                if (i10 == 1) {
                    return Chip.this.s();
                }
                return false;
            }
            return false;
        }

        @Override // c0.a
        protected void M(l lVar) {
            lVar.h0(Chip.this.q());
            lVar.k0(Chip.this.isClickable());
            lVar.j0((Chip.this.q() || Chip.this.isClickable()) ? Chip.this.q() ? "android.widget.CompoundButton" : "android.widget.Button" : "android.view.View");
            CharSequence text = Chip.this.getText();
            if (Build.VERSION.SDK_INT >= 23) {
                lVar.E0(text);
            } else {
                lVar.n0(text);
            }
        }

        @Override // c0.a
        protected void N(int i10, l lVar) {
            if (i10 != 1) {
                lVar.n0("");
                lVar.f0(Chip.A);
                return;
            }
            CharSequence closeIconContentDescription = Chip.this.getCloseIconContentDescription();
            if (closeIconContentDescription == null) {
                CharSequence text = Chip.this.getText();
                Context context = Chip.this.getContext();
                int i11 = i.mtrl_chip_close_icon_content_description;
                Object[] objArr = new Object[1];
                objArr[0] = TextUtils.isEmpty(text) ? "" : text;
                closeIconContentDescription = context.getString(i11, objArr).trim();
            }
            lVar.n0(closeIconContentDescription);
            lVar.f0(Chip.this.getCloseIconTouchBoundsInt());
            lVar.b(l.a.f14175i);
            lVar.p0(Chip.this.isEnabled());
        }

        @Override // c0.a
        protected void O(int i10, boolean z9) {
            if (i10 == 1) {
                Chip.this.f5959s = z9;
                Chip.this.refreshDrawableState();
            }
        }
    }

    public Chip(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, c6.b.chipStyle);
    }

    public Chip(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.f5964x = new Rect();
        this.f5965y = new RectF();
        this.f5966z = new a();
        B(attributeSet);
        int i11 = j.Widget_MaterialComponents_Chip_Action;
        com.google.android.material.chip.a n02 = com.google.android.material.chip.a.n0(context, attributeSet, i10, i11);
        n(context, attributeSet, i10);
        setChipDrawable(n02);
        n02.Q(r0.v(this));
        TypedArray k10 = com.google.android.material.internal.f.k(context, attributeSet, k.I, i10, i11, new int[0]);
        int i12 = Build.VERSION.SDK_INT;
        if (i12 < 23) {
            setTextColor(m6.c.a(context, k10, k.K));
        }
        boolean hasValue = k10.hasValue(k.f5451s0);
        k10.recycle();
        c cVar = new c(this);
        this.f5963w = cVar;
        if (i12 >= 24) {
            r0.n0(this, cVar);
        } else {
            w();
        }
        if (!hasValue) {
            o();
        }
        setChecked(this.f5956p);
        setText(n02.W0());
        setEllipsize(n02.Q0());
        setIncludeFontPadding(false);
        A();
        if (!this.f5951k.y2()) {
            setSingleLine();
        }
        setGravity(8388627);
        z();
        if (u()) {
            setMinHeight(this.f5962v);
        }
        this.f5961u = r0.B(this);
    }

    private void A() {
        TextPaint paint = getPaint();
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            paint.drawableState = aVar.getState();
        }
        d textAppearance = getTextAppearance();
        if (textAppearance != null) {
            textAppearance.i(getContext(), paint, this.f5966z);
        }
    }

    private void B(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        if (attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "background") != null) {
            Log.w("Chip", "Do not set the background; Chip manages its own background drawable.");
        }
        if (attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "drawableLeft") != null) {
            throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
        }
        if (attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "drawableStart") != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "drawableEnd") != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        if (attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "drawableRight") != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        if (!attributeSet.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "singleLine", true) || attributeSet.getAttributeIntValue("http://schemas.android.com/apk/res/android", "lines", 1) != 1 || attributeSet.getAttributeIntValue("http://schemas.android.com/apk/res/android", "minLines", 1) != 1 || attributeSet.getAttributeIntValue("http://schemas.android.com/apk/res/android", "maxLines", 1) != 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        if (attributeSet.getAttributeIntValue("http://schemas.android.com/apk/res/android", "gravity", 8388627) != 8388627) {
            Log.w("Chip", "Chip text must be vertically center and start aligned");
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public RectF getCloseIconTouchBounds() {
        this.f5965y.setEmpty();
        if (m()) {
            this.f5951k.P0(this.f5965y);
        }
        return this.f5965y;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public Rect getCloseIconTouchBoundsInt() {
        RectF closeIconTouchBounds = getCloseIconTouchBounds();
        this.f5964x.set((int) closeIconTouchBounds.left, (int) closeIconTouchBounds.top, (int) closeIconTouchBounds.right, (int) closeIconTouchBounds.bottom);
        return this.f5964x;
    }

    private d getTextAppearance() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.X0();
        }
        return null;
    }

    private void h(com.google.android.material.chip.a aVar) {
        aVar.c2(this);
    }

    /* JADX WARN: Type inference failed for: r0v0, types: [int, boolean] */
    private int[] i() {
        ?? isEnabled = isEnabled();
        int i10 = isEnabled;
        if (this.f5959s) {
            i10 = isEnabled + 1;
        }
        int i11 = i10;
        if (this.f5958r) {
            i11 = i10 + 1;
        }
        int i12 = i11;
        if (this.f5957q) {
            i12 = i11 + 1;
        }
        int i13 = i12;
        if (isChecked()) {
            i13 = i12 + 1;
        }
        int[] iArr = new int[i13];
        int i14 = 0;
        if (isEnabled()) {
            iArr[0] = 16842910;
            i14 = 1;
        }
        if (this.f5959s) {
            iArr[i14] = 16842908;
            i14++;
        }
        if (this.f5958r) {
            iArr[i14] = 16843623;
            i14++;
        }
        if (this.f5957q) {
            iArr[i14] = 16842919;
            i14++;
        }
        if (isChecked()) {
            iArr[i14] = 16842913;
        }
        return iArr;
    }

    private void k() {
        if (getBackgroundDrawable() == this.f5952l && this.f5951k.getCallback() == null) {
            this.f5951k.setCallback(this.f5952l);
        }
    }

    private boolean l(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 10) {
            try {
                Field declaredField = c0.a.class.getDeclaredField("m");
                declaredField.setAccessible(true);
                if (((Integer) declaredField.get(this.f5963w)).intValue() != Integer.MIN_VALUE) {
                    Method declaredMethod = c0.a.class.getDeclaredMethod("V", Integer.TYPE);
                    declaredMethod.setAccessible(true);
                    declaredMethod.invoke(this.f5963w, Integer.valueOf((int) RecyclerView.UNDEFINED_DURATION));
                    return true;
                }
            } catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e10) {
                Log.e("Chip", "Unable to send Accessibility Exit event", e10);
            }
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public boolean m() {
        com.google.android.material.chip.a aVar = this.f5951k;
        return (aVar == null || aVar.I0() == null) ? false : true;
    }

    private void n(Context context, AttributeSet attributeSet, int i10) {
        TypedArray k10 = com.google.android.material.internal.f.k(context, attributeSet, k.I, i10, j.Widget_MaterialComponents_Chip_Action, new int[0]);
        this.f5960t = k10.getBoolean(k.f5422n0, false);
        this.f5962v = (int) Math.ceil(k10.getDimension(k.f5350b0, (float) Math.ceil(com.google.android.material.internal.g.a(getContext(), 48))));
        k10.recycle();
    }

    private void o() {
        setOutlineProvider(new b());
    }

    private void p(int i10, int i11, int i12, int i13) {
        this.f5952l = new InsetDrawable((Drawable) this.f5951k, i10, i11, i12, i13);
    }

    private void setCloseIconHovered(boolean z9) {
        if (this.f5958r != z9) {
            this.f5958r = z9;
            refreshDrawableState();
        }
    }

    private void setCloseIconPressed(boolean z9) {
        if (this.f5957q != z9) {
            this.f5957q = z9;
            refreshDrawableState();
        }
    }

    private void t() {
        if (this.f5952l != null) {
            this.f5952l = null;
            setMinWidth(0);
            setMinHeight((int) getChipMinHeight());
            x();
        }
    }

    private void v(com.google.android.material.chip.a aVar) {
        if (aVar != null) {
            aVar.c2(null);
        }
    }

    private void w() {
        if (Build.VERSION.SDK_INT >= 24) {
            return;
        }
        r0.n0(this, (m() && r()) ? this.f5963w : null);
    }

    private void x() {
        if (n6.b.f10517a) {
            y();
            return;
        }
        this.f5951k.x2(true);
        r0.r0(this, getBackgroundDrawable());
        k();
    }

    private void y() {
        this.f5953m = new RippleDrawable(n6.b.a(this.f5951k.U0()), getBackgroundDrawable(), null);
        this.f5951k.x2(false);
        r0.r0(this, this.f5953m);
    }

    private void z() {
        com.google.android.material.chip.a aVar;
        if (TextUtils.isEmpty(getText()) || (aVar = this.f5951k) == null) {
            return;
        }
        r0.B0(this, (int) (this.f5951k.F0() + this.f5951k.Z0() + this.f5951k.e0()), getPaddingTop(), (int) (aVar.A0() + this.f5951k.Y0() + this.f5951k.i0()), getPaddingBottom());
    }

    @Override // com.google.android.material.chip.a.InterfaceC0086a
    public void a() {
        j(this.f5962v);
        x();
        z();
        requestLayout();
        invalidateOutline();
    }

    @Override // android.view.View
    protected boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return l(motionEvent) || this.f5963w.v(motionEvent) || super.dispatchHoverEvent(motionEvent);
    }

    @Override // android.view.View
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (!this.f5963w.w(keyEvent) || this.f5963w.A() == Integer.MIN_VALUE) {
            return super.dispatchKeyEvent(keyEvent);
        }
        return true;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.appcompat.widget.g, android.widget.CompoundButton, android.widget.TextView, android.view.View
    public void drawableStateChanged() {
        super.drawableStateChanged();
        com.google.android.material.chip.a aVar = this.f5951k;
        if ((aVar == null || !aVar.e1()) ? false : this.f5951k.Y1(i())) {
            invalidate();
        }
    }

    public Drawable getBackgroundDrawable() {
        InsetDrawable insetDrawable = this.f5952l;
        return insetDrawable == null ? this.f5951k : insetDrawable;
    }

    public Drawable getCheckedIcon() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.x0();
        }
        return null;
    }

    public ColorStateList getChipBackgroundColor() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.y0();
        }
        return null;
    }

    public float getChipCornerRadius() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.z0();
        }
        return 0.0f;
    }

    public Drawable getChipDrawable() {
        return this.f5951k;
    }

    public float getChipEndPadding() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.A0();
        }
        return 0.0f;
    }

    public Drawable getChipIcon() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.B0();
        }
        return null;
    }

    public float getChipIconSize() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.C0();
        }
        return 0.0f;
    }

    public ColorStateList getChipIconTint() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.D0();
        }
        return null;
    }

    public float getChipMinHeight() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.E0();
        }
        return 0.0f;
    }

    public float getChipStartPadding() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.F0();
        }
        return 0.0f;
    }

    public ColorStateList getChipStrokeColor() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.G0();
        }
        return null;
    }

    public float getChipStrokeWidth() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.H0();
        }
        return 0.0f;
    }

    @Deprecated
    public CharSequence getChipText() {
        return getText();
    }

    public Drawable getCloseIcon() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.I0();
        }
        return null;
    }

    public CharSequence getCloseIconContentDescription() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.J0();
        }
        return null;
    }

    public float getCloseIconEndPadding() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.K0();
        }
        return 0.0f;
    }

    public float getCloseIconSize() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.L0();
        }
        return 0.0f;
    }

    public float getCloseIconStartPadding() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.M0();
        }
        return 0.0f;
    }

    public ColorStateList getCloseIconTint() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.O0();
        }
        return null;
    }

    @Override // android.widget.TextView
    public TextUtils.TruncateAt getEllipsize() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.Q0();
        }
        return null;
    }

    @Override // android.widget.TextView, android.view.View
    public void getFocusedRect(Rect rect) {
        if (this.f5963w.A() == 1 || this.f5963w.x() == 1) {
            rect.set(getCloseIconTouchBoundsInt());
        } else {
            super.getFocusedRect(rect);
        }
    }

    public d6.d getHideMotionSpec() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.R0();
        }
        return null;
    }

    public float getIconEndPadding() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.S0();
        }
        return 0.0f;
    }

    public float getIconStartPadding() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.T0();
        }
        return 0.0f;
    }

    public ColorStateList getRippleColor() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.U0();
        }
        return null;
    }

    public p6.k getShapeAppearanceModel() {
        return this.f5951k.A();
    }

    public d6.d getShowMotionSpec() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.V0();
        }
        return null;
    }

    public float getTextEndPadding() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.Y0();
        }
        return 0.0f;
    }

    public float getTextStartPadding() {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            return aVar.Z0();
        }
        return 0.0f;
    }

    public boolean j(int i10) {
        this.f5962v = i10;
        if (!u()) {
            t();
            return false;
        }
        int max = Math.max(0, i10 - this.f5951k.getIntrinsicHeight());
        int max2 = Math.max(0, i10 - this.f5951k.getIntrinsicWidth());
        if (max2 <= 0 && max <= 0) {
            t();
            return false;
        }
        int i11 = max2 > 0 ? max2 / 2 : 0;
        int i12 = max > 0 ? max / 2 : 0;
        if (this.f5952l != null) {
            Rect rect = new Rect();
            this.f5952l.getPadding(rect);
            if (rect.top == i12 && rect.bottom == i12 && rect.left == i11 && rect.right == i11) {
                return true;
            }
        }
        if (getMinHeight() != i10) {
            setMinHeight(i10);
        }
        if (getMinWidth() != i10) {
            setMinWidth(i10);
        }
        p(i11, i12, i11, i12);
        return true;
    }

    @Override // android.widget.TextView, android.view.View
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        h.f(this, this.f5951k);
    }

    @Override // android.widget.CompoundButton, android.widget.TextView, android.view.View
    protected int[] onCreateDrawableState(int i10) {
        int[] onCreateDrawableState = super.onCreateDrawableState(i10 + 2);
        if (isChecked()) {
            View.mergeDrawableStates(onCreateDrawableState, B);
        }
        if (q()) {
            View.mergeDrawableStates(onCreateDrawableState, C);
        }
        return onCreateDrawableState;
    }

    @Override // android.widget.TextView, android.view.View
    protected void onFocusChanged(boolean z9, int i10, Rect rect) {
        super.onFocusChanged(z9, i10, rect);
        this.f5963w.I(z9, i10, rect);
    }

    @Override // android.view.View
    public boolean onHoverEvent(MotionEvent motionEvent) {
        boolean contains;
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked != 7) {
            if (actionMasked == 10) {
                contains = false;
            }
            return super.onHoverEvent(motionEvent);
        }
        contains = getCloseIconTouchBounds().contains(motionEvent.getX(), motionEvent.getY());
        setCloseIconHovered(contains);
        return super.onHoverEvent(motionEvent);
    }

    @Override // android.view.View
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((q() || isClickable()) ? q() ? "android.widget.CompoundButton" : "android.widget.Button" : "android.view.View");
        accessibilityNodeInfo.setCheckable(q());
        accessibilityNodeInfo.setClickable(isClickable());
    }

    @Override // android.widget.Button, android.widget.TextView, android.view.View
    public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int i10) {
        if (getCloseIconTouchBounds().contains(motionEvent.getX(), motionEvent.getY()) && isEnabled()) {
            return PointerIcon.getSystemIcon(getContext(), 1002);
        }
        return null;
    }

    @Override // android.widget.TextView, android.view.View
    public void onRtlPropertiesChanged(int i10) {
        super.onRtlPropertiesChanged(i10);
        if (this.f5961u != i10) {
            this.f5961u = i10;
            z();
        }
    }

    /* JADX WARN: Code restructure failed: missing block: B:8:0x001e, code lost:
        if (r0 != 3) goto L16;
     */
    @Override // android.widget.TextView, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean z9;
        int actionMasked = motionEvent.getActionMasked();
        boolean contains = getCloseIconTouchBounds().contains(motionEvent.getX(), motionEvent.getY());
        if (actionMasked != 0) {
            if (actionMasked != 1) {
                if (actionMasked == 2) {
                    if (this.f5957q) {
                        if (!contains) {
                            setCloseIconPressed(false);
                        }
                        z9 = true;
                    }
                }
                z9 = false;
            } else if (this.f5957q) {
                s();
                z9 = true;
                setCloseIconPressed(false);
            }
            z9 = false;
            setCloseIconPressed(false);
        } else {
            if (contains) {
                setCloseIconPressed(true);
                z9 = true;
            }
            z9 = false;
        }
        return z9 || super.onTouchEvent(motionEvent);
    }

    public boolean q() {
        com.google.android.material.chip.a aVar = this.f5951k;
        return aVar != null && aVar.d1();
    }

    public boolean r() {
        com.google.android.material.chip.a aVar = this.f5951k;
        return aVar != null && aVar.f1();
    }

    public boolean s() {
        boolean z9 = false;
        playSoundEffect(0);
        View.OnClickListener onClickListener = this.f5954n;
        if (onClickListener != null) {
            onClickListener.onClick(this);
            z9 = true;
        }
        this.f5963w.U(1, 1);
        return z9;
    }

    @Override // android.view.View
    public void setBackground(Drawable drawable) {
        if (drawable == getBackgroundDrawable() || drawable == this.f5953m) {
            super.setBackground(drawable);
        } else {
            Log.w("Chip", "Do not set the background; Chip manages its own background drawable.");
        }
    }

    @Override // android.view.View
    public void setBackgroundColor(int i10) {
        Log.w("Chip", "Do not set the background color; Chip manages its own background drawable.");
    }

    @Override // androidx.appcompat.widget.g, android.view.View
    public void setBackgroundDrawable(Drawable drawable) {
        if (drawable == getBackgroundDrawable() || drawable == this.f5953m) {
            super.setBackgroundDrawable(drawable);
        } else {
            Log.w("Chip", "Do not set the background drawable; Chip manages its own background drawable.");
        }
    }

    @Override // androidx.appcompat.widget.g, android.view.View
    public void setBackgroundResource(int i10) {
        Log.w("Chip", "Do not set the background resource; Chip manages its own background drawable.");
    }

    @Override // android.view.View
    public void setBackgroundTintList(ColorStateList colorStateList) {
        Log.w("Chip", "Do not set the background tint list; Chip manages its own background drawable.");
    }

    @Override // android.view.View
    public void setBackgroundTintMode(PorterDuff.Mode mode) {
        Log.w("Chip", "Do not set the background tint mode; Chip manages its own background drawable.");
    }

    public void setCheckable(boolean z9) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.m1(z9);
        }
    }

    public void setCheckableResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.n1(i10);
        }
    }

    @Override // android.widget.CompoundButton, android.widget.Checkable
    public void setChecked(boolean z9) {
        CompoundButton.OnCheckedChangeListener onCheckedChangeListener;
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar == null) {
            this.f5956p = z9;
        } else if (aVar.d1()) {
            boolean isChecked = isChecked();
            super.setChecked(z9);
            if (isChecked == z9 || (onCheckedChangeListener = this.f5955o) == null) {
                return;
            }
            onCheckedChangeListener.onCheckedChanged(this, z9);
        }
    }

    public void setCheckedIcon(Drawable drawable) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.o1(drawable);
        }
    }

    @Deprecated
    public void setCheckedIconEnabled(boolean z9) {
        setCheckedIconVisible(z9);
    }

    @Deprecated
    public void setCheckedIconEnabledResource(int i10) {
        setCheckedIconVisible(i10);
    }

    public void setCheckedIconResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.p1(i10);
        }
    }

    public void setCheckedIconVisible(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.q1(i10);
        }
    }

    public void setCheckedIconVisible(boolean z9) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.r1(z9);
        }
    }

    public void setChipBackgroundColor(ColorStateList colorStateList) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.s1(colorStateList);
        }
    }

    public void setChipBackgroundColorResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.t1(i10);
        }
    }

    @Deprecated
    public void setChipCornerRadius(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.u1(f10);
        }
    }

    @Deprecated
    public void setChipCornerRadiusResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.v1(i10);
        }
    }

    public void setChipDrawable(com.google.android.material.chip.a aVar) {
        com.google.android.material.chip.a aVar2 = this.f5951k;
        if (aVar2 != aVar) {
            v(aVar2);
            this.f5951k = aVar;
            aVar.n2(false);
            h(this.f5951k);
            j(this.f5962v);
            x();
        }
    }

    public void setChipEndPadding(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.w1(f10);
        }
    }

    public void setChipEndPaddingResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.x1(i10);
        }
    }

    public void setChipIcon(Drawable drawable) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.y1(drawable);
        }
    }

    @Deprecated
    public void setChipIconEnabled(boolean z9) {
        setChipIconVisible(z9);
    }

    @Deprecated
    public void setChipIconEnabledResource(int i10) {
        setChipIconVisible(i10);
    }

    public void setChipIconResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.z1(i10);
        }
    }

    public void setChipIconSize(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.A1(f10);
        }
    }

    public void setChipIconSizeResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.B1(i10);
        }
    }

    public void setChipIconTint(ColorStateList colorStateList) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.C1(colorStateList);
        }
    }

    public void setChipIconTintResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.D1(i10);
        }
    }

    public void setChipIconVisible(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.E1(i10);
        }
    }

    public void setChipIconVisible(boolean z9) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.F1(z9);
        }
    }

    public void setChipMinHeight(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.G1(f10);
        }
    }

    public void setChipMinHeightResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.H1(i10);
        }
    }

    public void setChipStartPadding(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.I1(f10);
        }
    }

    public void setChipStartPaddingResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.J1(i10);
        }
    }

    public void setChipStrokeColor(ColorStateList colorStateList) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.K1(colorStateList);
        }
    }

    public void setChipStrokeColorResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.L1(i10);
        }
    }

    public void setChipStrokeWidth(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.M1(f10);
        }
    }

    public void setChipStrokeWidthResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.N1(i10);
        }
    }

    @Deprecated
    public void setChipText(CharSequence charSequence) {
        setText(charSequence);
    }

    @Deprecated
    public void setChipTextResource(int i10) {
        setText(getResources().getString(i10));
    }

    public void setCloseIcon(Drawable drawable) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.P1(drawable);
        }
        w();
    }

    public void setCloseIconContentDescription(CharSequence charSequence) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.Q1(charSequence);
        }
    }

    @Deprecated
    public void setCloseIconEnabled(boolean z9) {
        setCloseIconVisible(z9);
    }

    @Deprecated
    public void setCloseIconEnabledResource(int i10) {
        setCloseIconVisible(i10);
    }

    public void setCloseIconEndPadding(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.R1(f10);
        }
    }

    public void setCloseIconEndPaddingResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.S1(i10);
        }
    }

    public void setCloseIconResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.T1(i10);
        }
        w();
    }

    public void setCloseIconSize(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.U1(f10);
        }
    }

    public void setCloseIconSizeResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.V1(i10);
        }
    }

    public void setCloseIconStartPadding(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.W1(f10);
        }
    }

    public void setCloseIconStartPaddingResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.X1(i10);
        }
    }

    public void setCloseIconTint(ColorStateList colorStateList) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.Z1(colorStateList);
        }
    }

    public void setCloseIconTintResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.a2(i10);
        }
    }

    public void setCloseIconVisible(int i10) {
        setCloseIconVisible(getResources().getBoolean(i10));
    }

    public void setCloseIconVisible(boolean z9) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.b2(z9);
        }
        w();
    }

    @Override // androidx.appcompat.widget.g, android.widget.TextView
    public void setCompoundDrawables(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        if (drawable != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (drawable3 != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawables(drawable, drawable2, drawable3, drawable4);
    }

    @Override // androidx.appcompat.widget.g, android.widget.TextView
    public void setCompoundDrawablesRelative(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        if (drawable != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (drawable3 != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelative(drawable, drawable2, drawable3, drawable4);
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int i10, int i11, int i12, int i13) {
        if (i10 != 0) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (i12 != 0) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(i10, i11, i12, i13);
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        if (drawable != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (drawable3 != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesWithIntrinsicBounds(int i10, int i11, int i12, int i13) {
        if (i10 != 0) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (i12 != 0) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesWithIntrinsicBounds(i10, i11, i12, i13);
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        if (drawable != null) {
            throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
        }
        if (drawable3 != null) {
            throw new UnsupportedOperationException("Please set right drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
    }

    @Override // android.view.View
    public void setElevation(float f10) {
        super.setElevation(f10);
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.Q(f10);
        }
    }

    @Override // android.widget.TextView
    public void setEllipsize(TextUtils.TruncateAt truncateAt) {
        if (this.f5951k == null) {
            return;
        }
        if (truncateAt == TextUtils.TruncateAt.MARQUEE) {
            throw new UnsupportedOperationException("Text within a chip are not allowed to scroll.");
        }
        super.setEllipsize(truncateAt);
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.d2(truncateAt);
        }
    }

    public void setEnsureMinTouchTargetSize(boolean z9) {
        this.f5960t = z9;
        j(this.f5962v);
    }

    @Override // android.widget.TextView
    public void setGravity(int i10) {
        if (i10 != 8388627) {
            Log.w("Chip", "Chip text must be vertically center and start aligned");
        } else {
            super.setGravity(i10);
        }
    }

    public void setHideMotionSpec(d6.d dVar) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.e2(dVar);
        }
    }

    public void setHideMotionSpecResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.f2(i10);
        }
    }

    public void setIconEndPadding(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.g2(f10);
        }
    }

    public void setIconEndPaddingResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.h2(i10);
        }
    }

    public void setIconStartPadding(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.i2(f10);
        }
    }

    public void setIconStartPaddingResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.j2(i10);
        }
    }

    @Override // android.view.View
    public void setLayoutDirection(int i10) {
        if (this.f5951k == null) {
            return;
        }
        super.setLayoutDirection(i10);
    }

    @Override // android.widget.TextView
    public void setLines(int i10) {
        if (i10 > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setLines(i10);
    }

    @Override // android.widget.TextView
    public void setMaxLines(int i10) {
        if (i10 > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setMaxLines(i10);
    }

    @Override // android.widget.TextView
    public void setMaxWidth(int i10) {
        super.setMaxWidth(i10);
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.k2(i10);
        }
    }

    @Override // android.widget.TextView
    public void setMinLines(int i10) {
        if (i10 > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setMinLines(i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void setOnCheckedChangeListenerInternal(CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        this.f5955o = onCheckedChangeListener;
    }

    public void setOnCloseIconClickListener(View.OnClickListener onClickListener) {
        this.f5954n = onClickListener;
    }

    public void setRippleColor(ColorStateList colorStateList) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.l2(colorStateList);
        }
        if (this.f5951k.b1()) {
            return;
        }
        y();
    }

    public void setRippleColorResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.m2(i10);
            if (this.f5951k.b1()) {
                return;
            }
            y();
        }
    }

    @Override // p6.n
    public void setShapeAppearanceModel(p6.k kVar) {
        this.f5951k.setShapeAppearanceModel(kVar);
    }

    public void setShowMotionSpec(d6.d dVar) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.o2(dVar);
        }
    }

    public void setShowMotionSpecResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.p2(i10);
        }
    }

    @Override // android.widget.TextView
    public void setSingleLine(boolean z9) {
        if (!z9) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setSingleLine(z9);
    }

    @Override // android.widget.TextView
    public void setText(CharSequence charSequence, TextView.BufferType bufferType) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar == null) {
            return;
        }
        if (charSequence == null) {
            charSequence = "";
        }
        super.setText(aVar.y2() ? null : charSequence, bufferType);
        com.google.android.material.chip.a aVar2 = this.f5951k;
        if (aVar2 != null) {
            aVar2.q2(charSequence);
        }
    }

    @Override // android.widget.TextView
    public void setTextAppearance(int i10) {
        super.setTextAppearance(i10);
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.s2(i10);
        }
        A();
    }

    @Override // android.widget.TextView
    public void setTextAppearance(Context context, int i10) {
        super.setTextAppearance(context, i10);
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.s2(i10);
        }
        A();
    }

    public void setTextAppearance(d dVar) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.r2(dVar);
        }
        A();
    }

    public void setTextAppearanceResource(int i10) {
        setTextAppearance(getContext(), i10);
    }

    public void setTextEndPadding(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.t2(f10);
        }
    }

    public void setTextEndPaddingResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.u2(i10);
        }
    }

    public void setTextStartPadding(float f10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.v2(f10);
        }
    }

    public void setTextStartPaddingResource(int i10) {
        com.google.android.material.chip.a aVar = this.f5951k;
        if (aVar != null) {
            aVar.w2(i10);
        }
    }

    public boolean u() {
        return this.f5960t;
    }
}
