package com.google.android.material.button;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import androidx.core.view.r0;
import c6.b;
import m6.c;
import p6.g;
import p6.k;
import p6.n;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class a {

    /* renamed from: s  reason: collision with root package name */
    private static final boolean f5932s = true;

    /* renamed from: a  reason: collision with root package name */
    private final MaterialButton f5933a;

    /* renamed from: b  reason: collision with root package name */
    private k f5934b;

    /* renamed from: c  reason: collision with root package name */
    private int f5935c;

    /* renamed from: d  reason: collision with root package name */
    private int f5936d;

    /* renamed from: e  reason: collision with root package name */
    private int f5937e;

    /* renamed from: f  reason: collision with root package name */
    private int f5938f;

    /* renamed from: g  reason: collision with root package name */
    private int f5939g;

    /* renamed from: h  reason: collision with root package name */
    private int f5940h;

    /* renamed from: i  reason: collision with root package name */
    private PorterDuff.Mode f5941i;

    /* renamed from: j  reason: collision with root package name */
    private ColorStateList f5942j;

    /* renamed from: k  reason: collision with root package name */
    private ColorStateList f5943k;

    /* renamed from: l  reason: collision with root package name */
    private ColorStateList f5944l;

    /* renamed from: m  reason: collision with root package name */
    private Drawable f5945m;

    /* renamed from: n  reason: collision with root package name */
    private boolean f5946n = false;

    /* renamed from: o  reason: collision with root package name */
    private boolean f5947o = false;

    /* renamed from: p  reason: collision with root package name */
    private boolean f5948p = false;

    /* renamed from: q  reason: collision with root package name */
    private boolean f5949q;

    /* renamed from: r  reason: collision with root package name */
    private LayerDrawable f5950r;

    /* JADX INFO: Access modifiers changed from: package-private */
    public a(MaterialButton materialButton, k kVar) {
        this.f5933a = materialButton;
        this.f5934b = kVar;
    }

    private void A(k kVar) {
        if (d() != null) {
            d().setShapeAppearanceModel(kVar);
        }
        if (l() != null) {
            l().setShapeAppearanceModel(kVar);
        }
        if (c() != null) {
            c().setShapeAppearanceModel(kVar);
        }
    }

    private void C() {
        g d10 = d();
        g l10 = l();
        if (d10 != null) {
            d10.W(this.f5940h, this.f5943k);
            if (l10 != null) {
                l10.V(this.f5940h, this.f5946n ? g6.a.c(this.f5933a, b.colorSurface) : 0);
            }
        }
    }

    private InsetDrawable D(Drawable drawable) {
        return new InsetDrawable(drawable, this.f5935c, this.f5937e, this.f5936d, this.f5938f);
    }

    private Drawable a() {
        g gVar = new g(this.f5934b);
        gVar.J(this.f5933a.getContext());
        androidx.core.graphics.drawable.a.o(gVar, this.f5942j);
        PorterDuff.Mode mode = this.f5941i;
        if (mode != null) {
            androidx.core.graphics.drawable.a.p(gVar, mode);
        }
        gVar.W(this.f5940h, this.f5943k);
        g gVar2 = new g(this.f5934b);
        gVar2.setTint(0);
        gVar2.V(this.f5940h, this.f5946n ? g6.a.c(this.f5933a, b.colorSurface) : 0);
        if (f5932s) {
            g gVar3 = new g(this.f5934b);
            this.f5945m = gVar3;
            androidx.core.graphics.drawable.a.n(gVar3, -1);
            RippleDrawable rippleDrawable = new RippleDrawable(n6.b.a(this.f5944l), D(new LayerDrawable(new Drawable[]{gVar2, gVar})), this.f5945m);
            this.f5950r = rippleDrawable;
            return rippleDrawable;
        }
        n6.a aVar = new n6.a(this.f5934b);
        this.f5945m = aVar;
        androidx.core.graphics.drawable.a.o(aVar, n6.b.a(this.f5944l));
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{gVar2, gVar, this.f5945m});
        this.f5950r = layerDrawable;
        return D(layerDrawable);
    }

    private g e(boolean z9) {
        LayerDrawable layerDrawable = this.f5950r;
        if (layerDrawable == null || layerDrawable.getNumberOfLayers() <= 0) {
            return null;
        }
        return (g) (f5932s ? (LayerDrawable) ((InsetDrawable) this.f5950r.getDrawable(0)).getDrawable() : this.f5950r).getDrawable(!z9 ? 1 : 0);
    }

    private g l() {
        return e(true);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void B(int i10, int i11) {
        Drawable drawable = this.f5945m;
        if (drawable != null) {
            drawable.setBounds(this.f5935c, this.f5937e, i11 - this.f5936d, i10 - this.f5938f);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int b() {
        return this.f5939g;
    }

    public n c() {
        LayerDrawable layerDrawable = this.f5950r;
        if (layerDrawable == null || layerDrawable.getNumberOfLayers() <= 1) {
            return null;
        }
        return (n) (this.f5950r.getNumberOfLayers() > 2 ? this.f5950r.getDrawable(2) : this.f5950r.getDrawable(1));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public g d() {
        return e(false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public ColorStateList f() {
        return this.f5944l;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public k g() {
        return this.f5934b;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public ColorStateList h() {
        return this.f5943k;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int i() {
        return this.f5940h;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public ColorStateList j() {
        return this.f5942j;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public PorterDuff.Mode k() {
        return this.f5941i;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean m() {
        return this.f5947o;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean n() {
        return this.f5949q;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void o(TypedArray typedArray) {
        this.f5935c = typedArray.getDimensionPixelOffset(c6.k.f5393i1, 0);
        this.f5936d = typedArray.getDimensionPixelOffset(c6.k.f5399j1, 0);
        this.f5937e = typedArray.getDimensionPixelOffset(c6.k.f5405k1, 0);
        this.f5938f = typedArray.getDimensionPixelOffset(c6.k.f5411l1, 0);
        int i10 = c6.k.f5435p1;
        if (typedArray.hasValue(i10)) {
            int dimensionPixelSize = typedArray.getDimensionPixelSize(i10, -1);
            this.f5939g = dimensionPixelSize;
            u(this.f5934b.w(dimensionPixelSize));
            this.f5948p = true;
        }
        this.f5940h = typedArray.getDimensionPixelSize(c6.k.f5487z1, 0);
        this.f5941i = com.google.android.material.internal.g.c(typedArray.getInt(c6.k.f5429o1, -1), PorterDuff.Mode.SRC_IN);
        this.f5942j = c.a(this.f5933a.getContext(), typedArray, c6.k.f5423n1);
        this.f5943k = c.a(this.f5933a.getContext(), typedArray, c6.k.f5482y1);
        this.f5944l = c.a(this.f5933a.getContext(), typedArray, c6.k.f5477x1);
        this.f5949q = typedArray.getBoolean(c6.k.f5417m1, false);
        int dimensionPixelSize2 = typedArray.getDimensionPixelSize(c6.k.f5441q1, 0);
        int G = r0.G(this.f5933a);
        int paddingTop = this.f5933a.getPaddingTop();
        int F = r0.F(this.f5933a);
        int paddingBottom = this.f5933a.getPaddingBottom();
        this.f5933a.setInternalBackground(a());
        g d10 = d();
        if (d10 != null) {
            d10.Q(dimensionPixelSize2);
        }
        r0.B0(this.f5933a, G + this.f5935c, paddingTop + this.f5937e, F + this.f5936d, paddingBottom + this.f5938f);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void p(int i10) {
        if (d() != null) {
            d().setTint(i10);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void q() {
        this.f5947o = true;
        this.f5933a.setSupportBackgroundTintList(this.f5942j);
        this.f5933a.setSupportBackgroundTintMode(this.f5941i);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void r(boolean z9) {
        this.f5949q = z9;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void s(int i10) {
        if (this.f5948p && this.f5939g == i10) {
            return;
        }
        this.f5939g = i10;
        this.f5948p = true;
        u(this.f5934b.w(i10));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void t(ColorStateList colorStateList) {
        if (this.f5944l != colorStateList) {
            this.f5944l = colorStateList;
            boolean z9 = f5932s;
            if (z9 && (this.f5933a.getBackground() instanceof RippleDrawable)) {
                ((RippleDrawable) this.f5933a.getBackground()).setColor(n6.b.a(colorStateList));
            } else if (z9 || !(this.f5933a.getBackground() instanceof n6.a)) {
            } else {
                ((n6.a) this.f5933a.getBackground()).setTintList(n6.b.a(colorStateList));
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void u(k kVar) {
        this.f5934b = kVar;
        A(kVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void v(boolean z9) {
        this.f5946n = z9;
        C();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void w(ColorStateList colorStateList) {
        if (this.f5943k != colorStateList) {
            this.f5943k = colorStateList;
            C();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void x(int i10) {
        if (this.f5940h != i10) {
            this.f5940h = i10;
            C();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void y(ColorStateList colorStateList) {
        if (this.f5942j != colorStateList) {
            this.f5942j = colorStateList;
            if (d() != null) {
                androidx.core.graphics.drawable.a.o(d(), this.f5942j);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void z(PorterDuff.Mode mode) {
        if (this.f5941i != mode) {
            this.f5941i = mode;
            if (d() == null || this.f5941i == null) {
                return;
            }
            androidx.core.graphics.drawable.a.p(d(), this.f5941i);
        }
    }
}
