package com.google.android.material.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.Checkable;
import android.widget.CompoundButton;
import androidx.appcompat.widget.f;
import androidx.core.view.r0;
import androidx.core.widget.v;
import c6.j;
import c6.k;
import com.google.android.material.internal.g;
import java.util.Iterator;
import java.util.LinkedHashSet;
import m6.c;
import p6.h;
import p6.n;
/* loaded from: classes.dex */
public class MaterialButton extends f implements Checkable, n {

    /* renamed from: v  reason: collision with root package name */
    private static final int[] f5917v = {16842911};

    /* renamed from: w  reason: collision with root package name */
    private static final int[] f5918w = {16842912};

    /* renamed from: x  reason: collision with root package name */
    private static final int f5919x = j.Widget_MaterialComponents_Button;

    /* renamed from: j  reason: collision with root package name */
    private final com.google.android.material.button.a f5920j;

    /* renamed from: k  reason: collision with root package name */
    private final LinkedHashSet f5921k;

    /* renamed from: l  reason: collision with root package name */
    private b f5922l;

    /* renamed from: m  reason: collision with root package name */
    private PorterDuff.Mode f5923m;

    /* renamed from: n  reason: collision with root package name */
    private ColorStateList f5924n;

    /* renamed from: o  reason: collision with root package name */
    private Drawable f5925o;

    /* renamed from: p  reason: collision with root package name */
    private int f5926p;

    /* renamed from: q  reason: collision with root package name */
    private int f5927q;

    /* renamed from: r  reason: collision with root package name */
    private int f5928r;

    /* renamed from: s  reason: collision with root package name */
    private boolean f5929s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f5930t;

    /* renamed from: u  reason: collision with root package name */
    private int f5931u;

    /* loaded from: classes.dex */
    public interface a {
        void a(MaterialButton materialButton, boolean z9);
    }

    /* loaded from: classes.dex */
    interface b {
        void a(MaterialButton materialButton, boolean z9);
    }

    public MaterialButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, c6.b.materialButtonStyle);
    }

    /* JADX WARN: Illegal instructions before constructor call */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public MaterialButton(Context context, AttributeSet attributeSet, int i10) {
        super(com.google.android.material.internal.f.f(context, attributeSet, i10, r6), attributeSet, i10);
        int i11 = f5919x;
        this.f5921k = new LinkedHashSet();
        this.f5929s = false;
        this.f5930t = false;
        Context context2 = getContext();
        TypedArray k10 = com.google.android.material.internal.f.k(context2, attributeSet, k.f5387h1, i10, i11, new int[0]);
        this.f5928r = k10.getDimensionPixelSize(k.f5457t1, 0);
        this.f5923m = g.c(k10.getInt(k.f5472w1, -1), PorterDuff.Mode.SRC_IN);
        this.f5924n = c.a(getContext(), k10, k.f5467v1);
        this.f5925o = c.d(getContext(), k10, k.f5447r1);
        this.f5931u = k10.getInteger(k.f5452s1, 1);
        this.f5926p = k10.getDimensionPixelSize(k.f5462u1, 0);
        com.google.android.material.button.a aVar = new com.google.android.material.button.a(this, p6.k.e(context2, attributeSet, i10, i11).m());
        this.f5920j = aVar;
        aVar.o(k10);
        k10.recycle();
        setCompoundDrawablePadding(this.f5928r);
        e(this.f5925o != null);
    }

    private boolean b() {
        return r0.B(this) == 1;
    }

    private boolean c() {
        com.google.android.material.button.a aVar = this.f5920j;
        return (aVar == null || aVar.m()) ? false : true;
    }

    private void d(boolean z9) {
        if (z9) {
            v.i(this, this.f5925o, null, null, null);
        } else {
            v.i(this, null, null, this.f5925o, null);
        }
    }

    private void e(boolean z9) {
        Drawable drawable = this.f5925o;
        boolean z10 = false;
        if (drawable != null) {
            Drawable mutate = androidx.core.graphics.drawable.a.r(drawable).mutate();
            this.f5925o = mutate;
            androidx.core.graphics.drawable.a.o(mutate, this.f5924n);
            PorterDuff.Mode mode = this.f5923m;
            if (mode != null) {
                androidx.core.graphics.drawable.a.p(this.f5925o, mode);
            }
            int i10 = this.f5926p;
            if (i10 == 0) {
                i10 = this.f5925o.getIntrinsicWidth();
            }
            int i11 = this.f5926p;
            if (i11 == 0) {
                i11 = this.f5925o.getIntrinsicHeight();
            }
            Drawable drawable2 = this.f5925o;
            int i12 = this.f5927q;
            drawable2.setBounds(i12, 0, i10 + i12, i11);
        }
        int i13 = this.f5931u;
        boolean z11 = i13 == 1 || i13 == 2;
        if (z9) {
            d(z11);
            return;
        }
        Drawable[] a10 = v.a(this);
        Drawable drawable3 = a10[0];
        Drawable drawable4 = a10[2];
        if ((z11 && drawable3 != this.f5925o) || (!z11 && drawable4 != this.f5925o)) {
            z10 = true;
        }
        if (z10) {
            d(z11);
        }
    }

    private void f() {
        if (this.f5925o == null || getLayout() == null) {
            return;
        }
        int i10 = this.f5931u;
        if (i10 == 1 || i10 == 3) {
            this.f5927q = 0;
            e(false);
            return;
        }
        TextPaint paint = getPaint();
        String charSequence = getText().toString();
        if (getTransformationMethod() != null) {
            charSequence = getTransformationMethod().getTransformation(charSequence, this).toString();
        }
        int min = Math.min((int) paint.measureText(charSequence), getLayout().getEllipsizedWidth());
        int i11 = this.f5926p;
        if (i11 == 0) {
            i11 = this.f5925o.getIntrinsicWidth();
        }
        int measuredWidth = (((((getMeasuredWidth() - min) - r0.F(this)) - i11) - this.f5928r) - r0.G(this)) / 2;
        if (b() != (this.f5931u == 4)) {
            measuredWidth = -measuredWidth;
        }
        if (this.f5927q != measuredWidth) {
            this.f5927q = measuredWidth;
            e(false);
        }
    }

    private String getA11yClassName() {
        return (a() ? CompoundButton.class : Button.class).getName();
    }

    public boolean a() {
        com.google.android.material.button.a aVar = this.f5920j;
        return aVar != null && aVar.n();
    }

    @Override // android.view.View
    public ColorStateList getBackgroundTintList() {
        return getSupportBackgroundTintList();
    }

    @Override // android.view.View
    public PorterDuff.Mode getBackgroundTintMode() {
        return getSupportBackgroundTintMode();
    }

    public int getCornerRadius() {
        if (c()) {
            return this.f5920j.b();
        }
        return 0;
    }

    public Drawable getIcon() {
        return this.f5925o;
    }

    public int getIconGravity() {
        return this.f5931u;
    }

    public int getIconPadding() {
        return this.f5928r;
    }

    public int getIconSize() {
        return this.f5926p;
    }

    public ColorStateList getIconTint() {
        return this.f5924n;
    }

    public PorterDuff.Mode getIconTintMode() {
        return this.f5923m;
    }

    public ColorStateList getRippleColor() {
        if (c()) {
            return this.f5920j.f();
        }
        return null;
    }

    public p6.k getShapeAppearanceModel() {
        if (c()) {
            return this.f5920j.g();
        }
        throw new IllegalStateException("Attempted to get ShapeAppearanceModel from a MaterialButton which has an overwritten background.");
    }

    public ColorStateList getStrokeColor() {
        if (c()) {
            return this.f5920j.h();
        }
        return null;
    }

    public int getStrokeWidth() {
        if (c()) {
            return this.f5920j.i();
        }
        return 0;
    }

    @Override // androidx.appcompat.widget.f
    public ColorStateList getSupportBackgroundTintList() {
        return c() ? this.f5920j.j() : super.getSupportBackgroundTintList();
    }

    @Override // androidx.appcompat.widget.f
    public PorterDuff.Mode getSupportBackgroundTintMode() {
        return c() ? this.f5920j.k() : super.getSupportBackgroundTintMode();
    }

    @Override // android.widget.Checkable
    public boolean isChecked() {
        return this.f5929s;
    }

    @Override // android.widget.TextView, android.view.View
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        h.f(this, this.f5920j.d());
    }

    @Override // android.widget.TextView, android.view.View
    protected int[] onCreateDrawableState(int i10) {
        int[] onCreateDrawableState = super.onCreateDrawableState(i10 + 2);
        if (a()) {
            View.mergeDrawableStates(onCreateDrawableState, f5917v);
        }
        if (isChecked()) {
            View.mergeDrawableStates(onCreateDrawableState, f5918w);
        }
        return onCreateDrawableState;
    }

    @Override // androidx.appcompat.widget.f, android.view.View
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(getA11yClassName());
        accessibilityEvent.setChecked(isChecked());
    }

    @Override // androidx.appcompat.widget.f, android.view.View
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(getA11yClassName());
        accessibilityNodeInfo.setCheckable(a());
        accessibilityNodeInfo.setChecked(isChecked());
        accessibilityNodeInfo.setClickable(isClickable());
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.appcompat.widget.f, android.widget.TextView, android.view.View
    public void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        com.google.android.material.button.a aVar;
        super.onLayout(z9, i10, i11, i12, i13);
        if (Build.VERSION.SDK_INT != 21 || (aVar = this.f5920j) == null) {
            return;
        }
        aVar.B(i13 - i11, i12 - i10);
    }

    @Override // android.widget.TextView, android.view.View
    protected void onMeasure(int i10, int i11) {
        super.onMeasure(i10, i11);
        f();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.appcompat.widget.f, android.widget.TextView
    public void onTextChanged(CharSequence charSequence, int i10, int i11, int i12) {
        super.onTextChanged(charSequence, i10, i11, i12);
        f();
    }

    @Override // android.view.View
    public boolean performClick() {
        toggle();
        return super.performClick();
    }

    @Override // android.view.View
    public void setBackground(Drawable drawable) {
        setBackgroundDrawable(drawable);
    }

    @Override // android.view.View
    public void setBackgroundColor(int i10) {
        if (c()) {
            this.f5920j.p(i10);
        } else {
            super.setBackgroundColor(i10);
        }
    }

    @Override // androidx.appcompat.widget.f, android.view.View
    public void setBackgroundDrawable(Drawable drawable) {
        if (c()) {
            if (drawable == getBackground()) {
                getBackground().setState(drawable.getState());
                return;
            } else {
                Log.w("MaterialButton", "Do not set the background; MaterialButton manages its own background drawable.");
                this.f5920j.q();
            }
        }
        super.setBackgroundDrawable(drawable);
    }

    @Override // androidx.appcompat.widget.f, android.view.View
    public void setBackgroundResource(int i10) {
        setBackgroundDrawable(i10 != 0 ? h.a.b(getContext(), i10) : null);
    }

    @Override // android.view.View
    public void setBackgroundTintList(ColorStateList colorStateList) {
        setSupportBackgroundTintList(colorStateList);
    }

    @Override // android.view.View
    public void setBackgroundTintMode(PorterDuff.Mode mode) {
        setSupportBackgroundTintMode(mode);
    }

    public void setCheckable(boolean z9) {
        if (c()) {
            this.f5920j.r(z9);
        }
    }

    @Override // android.widget.Checkable
    public void setChecked(boolean z9) {
        if (a() && isEnabled() && this.f5929s != z9) {
            this.f5929s = z9;
            refreshDrawableState();
            if (this.f5930t) {
                return;
            }
            this.f5930t = true;
            Iterator it = this.f5921k.iterator();
            while (it.hasNext()) {
                ((a) it.next()).a(this, this.f5929s);
            }
            this.f5930t = false;
        }
    }

    public void setCornerRadius(int i10) {
        if (c()) {
            this.f5920j.s(i10);
        }
    }

    public void setCornerRadiusResource(int i10) {
        if (c()) {
            setCornerRadius(getResources().getDimensionPixelSize(i10));
        }
    }

    @Override // android.view.View
    public void setElevation(float f10) {
        super.setElevation(f10);
        if (c()) {
            this.f5920j.d().Q(f10);
        }
    }

    public void setIcon(Drawable drawable) {
        if (this.f5925o != drawable) {
            this.f5925o = drawable;
            e(true);
        }
    }

    public void setIconGravity(int i10) {
        if (this.f5931u != i10) {
            this.f5931u = i10;
            f();
        }
    }

    public void setIconPadding(int i10) {
        if (this.f5928r != i10) {
            this.f5928r = i10;
            setCompoundDrawablePadding(i10);
        }
    }

    public void setIconResource(int i10) {
        setIcon(i10 != 0 ? h.a.b(getContext(), i10) : null);
    }

    public void setIconSize(int i10) {
        if (i10 < 0) {
            throw new IllegalArgumentException("iconSize cannot be less than 0");
        }
        if (this.f5926p != i10) {
            this.f5926p = i10;
            e(true);
        }
    }

    public void setIconTint(ColorStateList colorStateList) {
        if (this.f5924n != colorStateList) {
            this.f5924n = colorStateList;
            e(false);
        }
    }

    public void setIconTintMode(PorterDuff.Mode mode) {
        if (this.f5923m != mode) {
            this.f5923m = mode;
            e(false);
        }
    }

    public void setIconTintResource(int i10) {
        setIconTint(h.a.a(getContext(), i10));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void setInternalBackground(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
    }

    void setOnPressedChangeListenerInternal(b bVar) {
        this.f5922l = bVar;
    }

    @Override // android.view.View
    public void setPressed(boolean z9) {
        b bVar = this.f5922l;
        if (bVar != null) {
            bVar.a(this, z9);
        }
        super.setPressed(z9);
    }

    public void setRippleColor(ColorStateList colorStateList) {
        if (c()) {
            this.f5920j.t(colorStateList);
        }
    }

    public void setRippleColorResource(int i10) {
        if (c()) {
            setRippleColor(h.a.a(getContext(), i10));
        }
    }

    @Override // p6.n
    public void setShapeAppearanceModel(p6.k kVar) {
        if (!c()) {
            throw new IllegalStateException("Attempted to set ShapeAppearanceModel on a MaterialButton which has an overwritten background.");
        }
        this.f5920j.u(kVar);
    }

    void setShouldDrawSurfaceColorStroke(boolean z9) {
        if (c()) {
            this.f5920j.v(z9);
        }
    }

    public void setStrokeColor(ColorStateList colorStateList) {
        if (c()) {
            this.f5920j.w(colorStateList);
        }
    }

    public void setStrokeColorResource(int i10) {
        if (c()) {
            setStrokeColor(h.a.a(getContext(), i10));
        }
    }

    public void setStrokeWidth(int i10) {
        if (c()) {
            this.f5920j.x(i10);
        }
    }

    public void setStrokeWidthResource(int i10) {
        if (c()) {
            setStrokeWidth(getResources().getDimensionPixelSize(i10));
        }
    }

    @Override // androidx.appcompat.widget.f
    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        if (c()) {
            this.f5920j.y(colorStateList);
        } else {
            super.setSupportBackgroundTintList(colorStateList);
        }
    }

    @Override // androidx.appcompat.widget.f
    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        if (c()) {
            this.f5920j.z(mode);
        } else {
            super.setSupportBackgroundTintMode(mode);
        }
    }

    @Override // android.widget.Checkable
    public void toggle() {
        setChecked(!this.f5929s);
    }
}
