package com.google.android.material.appbar;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.i;
import androidx.core.view.r0;
import androidx.core.view.y2;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
/* loaded from: classes.dex */
abstract class b extends c {

    /* renamed from: d  reason: collision with root package name */
    final Rect f5834d;

    /* renamed from: e  reason: collision with root package name */
    final Rect f5835e;

    /* renamed from: f  reason: collision with root package name */
    private int f5836f;

    /* renamed from: g  reason: collision with root package name */
    private int f5837g;

    public b() {
        this.f5834d = new Rect();
        this.f5835e = new Rect();
        this.f5836f = 0;
    }

    public b(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f5834d = new Rect();
        this.f5835e = new Rect();
        this.f5836f = 0;
    }

    private static int L(int i10) {
        if (i10 == 0) {
            return 8388659;
        }
        return i10;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // com.google.android.material.appbar.c
    public void F(CoordinatorLayout coordinatorLayout, View view, int i10) {
        int i11;
        View G = G(coordinatorLayout.q(view));
        if (G != null) {
            CoordinatorLayout.e eVar = (CoordinatorLayout.e) view.getLayoutParams();
            Rect rect = this.f5834d;
            rect.set(coordinatorLayout.getPaddingLeft() + ((ViewGroup.MarginLayoutParams) eVar).leftMargin, G.getBottom() + ((ViewGroup.MarginLayoutParams) eVar).topMargin, (coordinatorLayout.getWidth() - coordinatorLayout.getPaddingRight()) - ((ViewGroup.MarginLayoutParams) eVar).rightMargin, ((coordinatorLayout.getHeight() + G.getBottom()) - coordinatorLayout.getPaddingBottom()) - ((ViewGroup.MarginLayoutParams) eVar).bottomMargin);
            y2 lastWindowInsets = coordinatorLayout.getLastWindowInsets();
            if (lastWindowInsets != null && r0.y(coordinatorLayout) && !r0.y(view)) {
                rect.left += lastWindowInsets.i();
                rect.right -= lastWindowInsets.j();
            }
            Rect rect2 = this.f5835e;
            i.a(L(eVar.f1903c), view.getMeasuredWidth(), view.getMeasuredHeight(), rect, rect2, i10);
            int H = H(G);
            view.layout(rect2.left, rect2.top - H, rect2.right, rect2.bottom - H);
            i11 = rect2.top - G.getBottom();
        } else {
            super.F(coordinatorLayout, view, i10);
            i11 = 0;
        }
        this.f5836f = i11;
    }

    abstract View G(List list);

    /* JADX INFO: Access modifiers changed from: package-private */
    public final int H(View view) {
        if (this.f5837g == 0) {
            return 0;
        }
        float I = I(view);
        int i10 = this.f5837g;
        return s.a.b((int) (I * i10), 0, i10);
    }

    abstract float I(View view);

    /* JADX INFO: Access modifiers changed from: package-private */
    public int J(View view) {
        return view.getMeasuredHeight();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public final int K() {
        return this.f5836f;
    }

    public final void M(int i10) {
        this.f5837g = i10;
    }

    protected boolean N() {
        return false;
    }

    @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
    public boolean m(CoordinatorLayout coordinatorLayout, View view, int i10, int i11, int i12, int i13) {
        View G;
        y2 lastWindowInsets;
        int i14 = view.getLayoutParams().height;
        if ((i14 == -1 || i14 == -2) && (G = G(coordinatorLayout.q(view))) != null) {
            int size = View.MeasureSpec.getSize(i12);
            if (size <= 0) {
                size = coordinatorLayout.getHeight();
            } else if (r0.y(G) && (lastWindowInsets = coordinatorLayout.getLastWindowInsets()) != null) {
                size += lastWindowInsets.k() + lastWindowInsets.h();
            }
            int J = size + J(G);
            int measuredHeight = G.getMeasuredHeight();
            if (N()) {
                view.setTranslationY(-measuredHeight);
            } else {
                J -= measuredHeight;
            }
            coordinatorLayout.H(view, i10, i11, View.MeasureSpec.makeMeasureSpec(J, i14 == -1 ? 1073741824 : RecyclerView.UNDEFINED_DURATION), i13);
            return true;
        }
        return false;
    }
}
