package com.google.android.material.appbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.r0;
import c6.k;
import java.lang.ref.WeakReference;
import java.util.List;
/* loaded from: classes.dex */
public abstract class AppBarLayout extends LinearLayout {

    /* JADX INFO: Access modifiers changed from: protected */
    /* loaded from: classes.dex */
    public static class BaseBehavior<T extends AppBarLayout> extends com.google.android.material.appbar.a {

        /* renamed from: k  reason: collision with root package name */
        private int f5814k;

        /* renamed from: l  reason: collision with root package name */
        private int f5815l;

        /* renamed from: m  reason: collision with root package name */
        private int f5816m;

        /* renamed from: n  reason: collision with root package name */
        private boolean f5817n;

        /* renamed from: o  reason: collision with root package name */
        private float f5818o;

        /* renamed from: p  reason: collision with root package name */
        private WeakReference f5819p;

        /* JADX INFO: Access modifiers changed from: protected */
        /* loaded from: classes.dex */
        public static class a extends b0.a {
            public static final Parcelable.Creator<a> CREATOR = new C0084a();

            /* renamed from: i  reason: collision with root package name */
            int f5820i;

            /* renamed from: j  reason: collision with root package name */
            float f5821j;

            /* renamed from: k  reason: collision with root package name */
            boolean f5822k;

            /* renamed from: com.google.android.material.appbar.AppBarLayout$BaseBehavior$a$a  reason: collision with other inner class name */
            /* loaded from: classes.dex */
            static class C0084a implements Parcelable.ClassLoaderCreator {
                C0084a() {
                }

                @Override // android.os.Parcelable.Creator
                /* renamed from: a */
                public a createFromParcel(Parcel parcel) {
                    return new a(parcel, null);
                }

                @Override // android.os.Parcelable.ClassLoaderCreator
                /* renamed from: b */
                public a createFromParcel(Parcel parcel, ClassLoader classLoader) {
                    return new a(parcel, classLoader);
                }

                @Override // android.os.Parcelable.Creator
                /* renamed from: c */
                public a[] newArray(int i10) {
                    return new a[i10];
                }
            }

            public a(Parcel parcel, ClassLoader classLoader) {
                super(parcel, classLoader);
                this.f5820i = parcel.readInt();
                this.f5821j = parcel.readFloat();
                this.f5822k = parcel.readByte() != 0;
            }

            @Override // b0.a, android.os.Parcelable
            public void writeToParcel(Parcel parcel, int i10) {
                super.writeToParcel(parcel, i10);
                parcel.writeInt(this.f5820i);
                parcel.writeFloat(this.f5821j);
                parcel.writeByte(this.f5822k ? (byte) 1 : (byte) 0);
            }
        }

        public BaseBehavior() {
            this.f5816m = -1;
        }

        public BaseBehavior(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.f5816m = -1;
        }

        private int S(AppBarLayout appBarLayout, int i10) {
            throw null;
        }

        private void f0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout) {
            if (S(appBarLayout, L()) >= 0) {
                throw null;
            }
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ boolean A(CoordinatorLayout coordinatorLayout, View view, View view2, View view3, int i10, int i11) {
            android.support.v4.media.session.b.a(view);
            return c0(coordinatorLayout, null, view2, view3, i10, i11);
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ void C(CoordinatorLayout coordinatorLayout, View view, View view2, int i10) {
            android.support.v4.media.session.b.a(view);
            d0(coordinatorLayout, null, view2, i10);
        }

        @Override // com.google.android.material.appbar.a
        /* bridge */ /* synthetic */ boolean G(View view) {
            android.support.v4.media.session.b.a(view);
            return R(null);
        }

        @Override // com.google.android.material.appbar.a
        /* bridge */ /* synthetic */ int J(View view) {
            android.support.v4.media.session.b.a(view);
            return T(null);
        }

        @Override // com.google.android.material.appbar.a
        /* bridge */ /* synthetic */ int K(View view) {
            android.support.v4.media.session.b.a(view);
            return U(null);
        }

        @Override // com.google.android.material.appbar.a
        int L() {
            return E() + this.f5814k;
        }

        @Override // com.google.android.material.appbar.a
        /* bridge */ /* synthetic */ void M(CoordinatorLayout coordinatorLayout, View view) {
            android.support.v4.media.session.b.a(view);
            V(coordinatorLayout, null);
        }

        @Override // com.google.android.material.appbar.a
        /* bridge */ /* synthetic */ int P(CoordinatorLayout coordinatorLayout, View view, int i10, int i11, int i12) {
            android.support.v4.media.session.b.a(view);
            return e0(coordinatorLayout, null, i10, i11, i12);
        }

        boolean R(AppBarLayout appBarLayout) {
            WeakReference weakReference = this.f5819p;
            if (weakReference != null) {
                View view = (View) weakReference.get();
                return (view == null || !view.isShown() || view.canScrollVertically(-1)) ? false : true;
            }
            return true;
        }

        int T(AppBarLayout appBarLayout) {
            throw null;
        }

        int U(AppBarLayout appBarLayout) {
            throw null;
        }

        void V(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout) {
            f0(coordinatorLayout, appBarLayout);
            throw null;
        }

        public boolean W(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int i10) {
            super.l(coordinatorLayout, appBarLayout, i10);
            throw null;
        }

        public boolean X(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int i10, int i11, int i12, int i13) {
            throw null;
        }

        public void Y(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, int i10, int i11, int[] iArr, int i12) {
            throw null;
        }

        public void Z(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, int i10, int i11, int i12, int i13, int i14, int[] iArr) {
            if (i13 < 0) {
                throw null;
            }
        }

        public void a0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, Parcelable parcelable) {
            if (!(parcelable instanceof a)) {
                super.x(coordinatorLayout, appBarLayout, parcelable);
                this.f5816m = -1;
                return;
            }
            a aVar = (a) parcelable;
            super.x(coordinatorLayout, appBarLayout, aVar.a());
            this.f5816m = aVar.f5820i;
            this.f5818o = aVar.f5821j;
            this.f5817n = aVar.f5822k;
        }

        public Parcelable b0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout) {
            super.y(coordinatorLayout, appBarLayout);
            E();
            throw null;
        }

        public boolean c0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, View view2, int i10, int i11) {
            if ((i10 & 2) == 0) {
                this.f5819p = null;
                this.f5815l = i11;
                return false;
            }
            throw null;
        }

        public void d0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, int i10) {
            if (this.f5815l == 0 || i10 == 1) {
                f0(coordinatorLayout, appBarLayout);
                throw null;
            } else {
                this.f5819p = new WeakReference(view);
            }
        }

        int e0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int i10, int i11, int i12) {
            int L = L();
            if (i11 == 0 || L < i11 || L > i12) {
                this.f5814k = 0;
            } else if (L != s.a.b(i10, i11, i12)) {
                throw null;
            }
            return 0;
        }

        @Override // com.google.android.material.appbar.c, androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ boolean l(CoordinatorLayout coordinatorLayout, View view, int i10) {
            android.support.v4.media.session.b.a(view);
            return W(coordinatorLayout, null, i10);
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ boolean m(CoordinatorLayout coordinatorLayout, View view, int i10, int i11, int i12, int i13) {
            android.support.v4.media.session.b.a(view);
            return X(coordinatorLayout, null, i10, i11, i12, i13);
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ void q(CoordinatorLayout coordinatorLayout, View view, View view2, int i10, int i11, int[] iArr, int i12) {
            android.support.v4.media.session.b.a(view);
            Y(coordinatorLayout, null, view2, i10, i11, iArr, i12);
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ void t(CoordinatorLayout coordinatorLayout, View view, View view2, int i10, int i11, int i12, int i13, int i14, int[] iArr) {
            android.support.v4.media.session.b.a(view);
            Z(coordinatorLayout, null, view2, i10, i11, i12, i13, i14, iArr);
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ void x(CoordinatorLayout coordinatorLayout, View view, Parcelable parcelable) {
            android.support.v4.media.session.b.a(view);
            a0(coordinatorLayout, null, parcelable);
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ Parcelable y(CoordinatorLayout coordinatorLayout, View view) {
            android.support.v4.media.session.b.a(view);
            return b0(coordinatorLayout, null);
        }
    }

    /* loaded from: classes.dex */
    public static class Behavior extends BaseBehavior<AppBarLayout> {
        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        @Override // com.google.android.material.appbar.c
        public /* bridge */ /* synthetic */ int E() {
            return super.E();
        }

        @Override // com.google.android.material.appbar.AppBarLayout.BaseBehavior
        public /* bridge */ /* synthetic */ boolean W(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int i10) {
            return super.W(coordinatorLayout, appBarLayout, i10);
        }

        @Override // com.google.android.material.appbar.AppBarLayout.BaseBehavior
        public /* bridge */ /* synthetic */ boolean X(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int i10, int i11, int i12, int i13) {
            return super.X(coordinatorLayout, appBarLayout, i10, i11, i12, i13);
        }

        @Override // com.google.android.material.appbar.AppBarLayout.BaseBehavior
        public /* bridge */ /* synthetic */ void Y(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, int i10, int i11, int[] iArr, int i12) {
            super.Y(coordinatorLayout, appBarLayout, view, i10, i11, iArr, i12);
        }

        @Override // com.google.android.material.appbar.AppBarLayout.BaseBehavior
        public /* bridge */ /* synthetic */ void Z(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, int i10, int i11, int i12, int i13, int i14, int[] iArr) {
            super.Z(coordinatorLayout, appBarLayout, view, i10, i11, i12, i13, i14, iArr);
        }

        @Override // com.google.android.material.appbar.AppBarLayout.BaseBehavior
        public /* bridge */ /* synthetic */ void a0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, Parcelable parcelable) {
            super.a0(coordinatorLayout, appBarLayout, parcelable);
        }

        @Override // com.google.android.material.appbar.AppBarLayout.BaseBehavior
        public /* bridge */ /* synthetic */ Parcelable b0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout) {
            return super.b0(coordinatorLayout, appBarLayout);
        }

        @Override // com.google.android.material.appbar.AppBarLayout.BaseBehavior
        public /* bridge */ /* synthetic */ boolean c0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, View view2, int i10, int i11) {
            return super.c0(coordinatorLayout, appBarLayout, view, view2, i10, i11);
        }

        @Override // com.google.android.material.appbar.AppBarLayout.BaseBehavior
        public /* bridge */ /* synthetic */ void d0(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, int i10) {
            super.d0(coordinatorLayout, appBarLayout, view, i10);
        }
    }

    /* loaded from: classes.dex */
    public static class ScrollingViewBehavior extends b {
        public ScrollingViewBehavior() {
        }

        public ScrollingViewBehavior(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, k.f5463u2);
            M(obtainStyledAttributes.getDimensionPixelSize(k.f5468v2, 0));
            obtainStyledAttributes.recycle();
        }

        private void P(View view, View view2) {
            CoordinatorLayout.b e10 = ((CoordinatorLayout.e) view2.getLayoutParams()).e();
            if (e10 instanceof BaseBehavior) {
                r0.Y(view, (((view2.getBottom() - view.getTop()) + ((BaseBehavior) e10).f5814k) + K()) - H(view2));
            }
        }

        private void Q(View view, View view2) {
        }

        @Override // com.google.android.material.appbar.b
        /* bridge */ /* synthetic */ View G(List list) {
            O(list);
            return null;
        }

        @Override // com.google.android.material.appbar.b
        float I(View view) {
            return 0.0f;
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // com.google.android.material.appbar.b
        public int J(View view) {
            return super.J(view);
        }

        AppBarLayout O(List list) {
            int size = list.size();
            for (int i10 = 0; i10 < size; i10++) {
                View view = (View) list.get(i10);
            }
            return null;
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public boolean e(CoordinatorLayout coordinatorLayout, View view, View view2) {
            return false;
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public boolean h(CoordinatorLayout coordinatorLayout, View view, View view2) {
            P(view, view2);
            Q(view, view2);
            return false;
        }

        @Override // com.google.android.material.appbar.c, androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ boolean l(CoordinatorLayout coordinatorLayout, View view, int i10) {
            return super.l(coordinatorLayout, view, i10);
        }

        @Override // com.google.android.material.appbar.b, androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public /* bridge */ /* synthetic */ boolean m(CoordinatorLayout coordinatorLayout, View view, int i10, int i11, int i12, int i13) {
            return super.m(coordinatorLayout, view, i10, i11, i12, i13);
        }

        @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
        public boolean w(CoordinatorLayout coordinatorLayout, View view, Rect rect, boolean z9) {
            O(coordinatorLayout.q(view));
            return false;
        }
    }
}
