package com.bumptech.glide.manager;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.fragment.app.w;
import com.bumptech.glide.c;
import java.util.HashMap;
import java.util.Map;
/* loaded from: classes.dex */
public class q implements Handler.Callback {

    /* renamed from: q  reason: collision with root package name */
    private static final b f5765q = new a();

    /* renamed from: g  reason: collision with root package name */
    private volatile com.bumptech.glide.k f5766g;

    /* renamed from: j  reason: collision with root package name */
    private final Handler f5769j;

    /* renamed from: k  reason: collision with root package name */
    private final b f5770k;

    /* renamed from: o  reason: collision with root package name */
    private final k f5774o;

    /* renamed from: p  reason: collision with root package name */
    private final n f5775p;

    /* renamed from: h  reason: collision with root package name */
    final Map f5767h = new HashMap();

    /* renamed from: i  reason: collision with root package name */
    final Map f5768i = new HashMap();

    /* renamed from: l  reason: collision with root package name */
    private final o.a f5771l = new o.a();

    /* renamed from: m  reason: collision with root package name */
    private final o.a f5772m = new o.a();

    /* renamed from: n  reason: collision with root package name */
    private final Bundle f5773n = new Bundle();

    /* loaded from: classes.dex */
    class a implements b {
        a() {
        }

        @Override // com.bumptech.glide.manager.q.b
        public com.bumptech.glide.k a(com.bumptech.glide.b bVar, l lVar, r rVar, Context context) {
            return new com.bumptech.glide.k(bVar, lVar, rVar, context);
        }
    }

    /* loaded from: classes.dex */
    public interface b {
        com.bumptech.glide.k a(com.bumptech.glide.b bVar, l lVar, r rVar, Context context);
    }

    public q(b bVar, com.bumptech.glide.e eVar) {
        bVar = bVar == null ? f5765q : bVar;
        this.f5770k = bVar;
        this.f5769j = new Handler(Looper.getMainLooper(), this);
        this.f5775p = new n(bVar);
        this.f5774o = b(eVar);
    }

    private static void a(Activity activity) {
        if (activity.isDestroyed()) {
            throw new IllegalArgumentException("You cannot start a load for a destroyed activity");
        }
    }

    private static k b(com.bumptech.glide.e eVar) {
        return (p4.n.f11753h && p4.n.f11752g) ? eVar.a(c.d.class) ? new i() : new j() : new g();
    }

    private static Activity c(Context context) {
        if (context instanceof Activity) {
            return (Activity) context;
        }
        if (context instanceof ContextWrapper) {
            return c(((ContextWrapper) context).getBaseContext());
        }
        return null;
    }

    private com.bumptech.glide.k d(Context context, FragmentManager fragmentManager, Fragment fragment, boolean z9) {
        p j10 = j(fragmentManager, fragment);
        com.bumptech.glide.k e10 = j10.e();
        if (e10 == null) {
            e10 = this.f5770k.a(com.bumptech.glide.b.d(context), j10.c(), j10.f(), context);
            if (z9) {
                e10.onStart();
            }
            j10.k(e10);
        }
        return e10;
    }

    private com.bumptech.glide.k h(Context context) {
        if (this.f5766g == null) {
            synchronized (this) {
                if (this.f5766g == null) {
                    this.f5766g = this.f5770k.a(com.bumptech.glide.b.d(context.getApplicationContext()), new com.bumptech.glide.manager.b(), new h(), context.getApplicationContext());
                }
            }
        }
        return this.f5766g;
    }

    private p j(FragmentManager fragmentManager, Fragment fragment) {
        p pVar = (p) this.f5767h.get(fragmentManager);
        if (pVar == null) {
            p pVar2 = (p) fragmentManager.findFragmentByTag("com.bumptech.glide.manager");
            if (pVar2 == null) {
                pVar2 = new p();
                pVar2.j(fragment);
                this.f5767h.put(fragmentManager, pVar2);
                fragmentManager.beginTransaction().add(pVar2, "com.bumptech.glide.manager").commitAllowingStateLoss();
                this.f5769j.obtainMessage(1, fragmentManager).sendToTarget();
            }
            return pVar2;
        }
        return pVar;
    }

    private u l(androidx.fragment.app.n nVar, androidx.fragment.app.Fragment fragment) {
        u uVar = (u) this.f5768i.get(nVar);
        if (uVar == null) {
            u uVar2 = (u) nVar.i0("com.bumptech.glide.manager");
            if (uVar2 == null) {
                uVar2 = new u();
                uVar2.p(fragment);
                this.f5768i.put(nVar, uVar2);
                nVar.m().d(uVar2, "com.bumptech.glide.manager").g();
                this.f5769j.obtainMessage(2, nVar).sendToTarget();
            }
            return uVar2;
        }
        return uVar;
    }

    private static boolean m(Context context) {
        Activity c10 = c(context);
        return c10 == null || !c10.isFinishing();
    }

    private boolean n(FragmentManager fragmentManager, boolean z9) {
        p pVar = (p) this.f5767h.get(fragmentManager);
        p pVar2 = (p) fragmentManager.findFragmentByTag("com.bumptech.glide.manager");
        if (pVar2 == pVar) {
            return true;
        }
        if (pVar2 != null && pVar2.e() != null) {
            throw new IllegalStateException("We've added two fragments with requests! Old: " + pVar2 + " New: " + pVar);
        } else if (z9 || fragmentManager.isDestroyed()) {
            if (Log.isLoggable("RMRetriever", 5)) {
                Log.w("RMRetriever", fragmentManager.isDestroyed() ? "Parent was destroyed before our Fragment could be added" : "Tried adding Fragment twice and failed twice, giving up!");
            }
            pVar.c().a();
            return true;
        } else {
            FragmentTransaction add = fragmentManager.beginTransaction().add(pVar, "com.bumptech.glide.manager");
            if (pVar2 != null) {
                add.remove(pVar2);
            }
            add.commitAllowingStateLoss();
            this.f5769j.obtainMessage(1, 1, 0, fragmentManager).sendToTarget();
            if (Log.isLoggable("RMRetriever", 3)) {
                Log.d("RMRetriever", "We failed to add our Fragment the first time around, trying again...");
            }
            return false;
        }
    }

    private boolean o(androidx.fragment.app.n nVar, boolean z9) {
        u uVar = (u) this.f5768i.get(nVar);
        u uVar2 = (u) nVar.i0("com.bumptech.glide.manager");
        if (uVar2 == uVar) {
            return true;
        }
        if (uVar2 != null && uVar2.k() != null) {
            throw new IllegalStateException("We've added two fragments with requests! Old: " + uVar2 + " New: " + uVar);
        } else if (z9 || nVar.E0()) {
            if (nVar.E0()) {
                if (Log.isLoggable("RMRetriever", 5)) {
                    Log.w("RMRetriever", "Parent was destroyed before our Fragment could be added, all requests for the destroyed parent are cancelled");
                }
            } else if (Log.isLoggable("RMRetriever", 6)) {
                Log.e("RMRetriever", "ERROR: Tried adding Fragment twice and failed twice, giving up and cancelling all associated requests! This probably means you're starting loads in a unit test with an Activity that you haven't created and never create. If you're using Robolectric, create the Activity as part of your test setup");
            }
            uVar.i().a();
            return true;
        } else {
            w d10 = nVar.m().d(uVar, "com.bumptech.glide.manager");
            if (uVar2 != null) {
                d10.l(uVar2);
            }
            d10.i();
            this.f5769j.obtainMessage(2, 1, 0, nVar).sendToTarget();
            if (Log.isLoggable("RMRetriever", 3)) {
                Log.d("RMRetriever", "We failed to add our Fragment the first time around, trying again...");
            }
            return false;
        }
    }

    public com.bumptech.glide.k e(Activity activity) {
        if (b5.l.q()) {
            return f(activity.getApplicationContext());
        }
        if (activity instanceof androidx.fragment.app.e) {
            return g((androidx.fragment.app.e) activity);
        }
        a(activity);
        this.f5774o.a(activity);
        return d(activity, activity.getFragmentManager(), null, m(activity));
    }

    public com.bumptech.glide.k f(Context context) {
        if (context != null) {
            if (b5.l.r() && !(context instanceof Application)) {
                if (context instanceof androidx.fragment.app.e) {
                    return g((androidx.fragment.app.e) context);
                }
                if (context instanceof Activity) {
                    return e((Activity) context);
                }
                if (context instanceof ContextWrapper) {
                    ContextWrapper contextWrapper = (ContextWrapper) context;
                    if (contextWrapper.getBaseContext().getApplicationContext() != null) {
                        return f(contextWrapper.getBaseContext());
                    }
                }
            }
            return h(context);
        }
        throw new IllegalArgumentException("You cannot start a load on a null Context");
    }

    public com.bumptech.glide.k g(androidx.fragment.app.e eVar) {
        if (b5.l.q()) {
            return f(eVar.getApplicationContext());
        }
        a(eVar);
        this.f5774o.a(eVar);
        boolean m10 = m(eVar);
        return this.f5775p.b(eVar, com.bumptech.glide.b.d(eVar.getApplicationContext()), eVar.getLifecycle(), eVar.getSupportFragmentManager(), m10);
    }

    @Override // android.os.Handler.Callback
    public boolean handleMessage(Message message) {
        FragmentManager fragmentManager;
        FragmentManager fragmentManager2;
        Map map;
        boolean z9 = false;
        boolean z10 = true;
        boolean z11 = message.arg1 == 1;
        int i10 = message.what;
        Object obj = null;
        if (i10 == 1) {
            FragmentManager fragmentManager3 = (FragmentManager) message.obj;
            if (n(fragmentManager3, z11)) {
                map = this.f5767h;
                fragmentManager2 = fragmentManager3;
                obj = map.remove(fragmentManager2);
                z9 = true;
                fragmentManager = fragmentManager2;
            }
            fragmentManager = null;
        } else if (i10 != 2) {
            fragmentManager = null;
            z10 = false;
        } else {
            androidx.fragment.app.n nVar = (androidx.fragment.app.n) message.obj;
            if (o(nVar, z11)) {
                map = this.f5768i;
                fragmentManager2 = nVar;
                obj = map.remove(fragmentManager2);
                z9 = true;
                fragmentManager = fragmentManager2;
            }
            fragmentManager = null;
        }
        if (Log.isLoggable("RMRetriever", 5) && z9 && obj == null) {
            Log.w("RMRetriever", "Failed to remove expected request manager fragment, manager: " + fragmentManager);
        }
        return z10;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public p i(Activity activity) {
        return j(activity.getFragmentManager(), null);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public u k(androidx.fragment.app.n nVar) {
        return l(nVar, null);
    }
}
