package com.bumptech.glide.load.data;

import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.load.data.d;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
/* loaded from: classes.dex */
public class j implements d {

    /* renamed from: m  reason: collision with root package name */
    static final b f5732m = new a();

    /* renamed from: g  reason: collision with root package name */
    private final m4.h f5733g;

    /* renamed from: h  reason: collision with root package name */
    private final int f5734h;

    /* renamed from: i  reason: collision with root package name */
    private final b f5735i;

    /* renamed from: j  reason: collision with root package name */
    private HttpURLConnection f5736j;

    /* renamed from: k  reason: collision with root package name */
    private InputStream f5737k;

    /* renamed from: l  reason: collision with root package name */
    private volatile boolean f5738l;

    /* loaded from: classes.dex */
    private static class a implements b {
        a() {
        }

        @Override // com.bumptech.glide.load.data.j.b
        public HttpURLConnection a(URL url) {
            return (HttpURLConnection) url.openConnection();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public interface b {
        HttpURLConnection a(URL url);
    }

    public j(m4.h hVar, int i10) {
        this(hVar, i10, f5732m);
    }

    j(m4.h hVar, int i10, b bVar) {
        this.f5733g = hVar;
        this.f5734h = i10;
        this.f5735i = bVar;
    }

    private HttpURLConnection c(URL url, Map map) {
        try {
            HttpURLConnection a10 = this.f5735i.a(url);
            for (Map.Entry entry : map.entrySet()) {
                a10.addRequestProperty((String) entry.getKey(), (String) entry.getValue());
            }
            a10.setConnectTimeout(this.f5734h);
            a10.setReadTimeout(this.f5734h);
            a10.setUseCaches(false);
            a10.setDoInput(true);
            a10.setInstanceFollowRedirects(false);
            return a10;
        } catch (IOException e10) {
            throw new g4.e("URL.openConnection threw", 0, e10);
        }
    }

    private static int f(HttpURLConnection httpURLConnection) {
        try {
            return httpURLConnection.getResponseCode();
        } catch (IOException e10) {
            if (Log.isLoggable("HttpUrlFetcher", 3)) {
                Log.d("HttpUrlFetcher", "Failed to get a response code", e10);
                return -1;
            }
            return -1;
        }
    }

    private InputStream g(HttpURLConnection httpURLConnection) {
        InputStream inputStream;
        try {
            if (TextUtils.isEmpty(httpURLConnection.getContentEncoding())) {
                inputStream = b5.c.b(httpURLConnection.getInputStream(), httpURLConnection.getContentLength());
            } else {
                if (Log.isLoggable("HttpUrlFetcher", 3)) {
                    Log.d("HttpUrlFetcher", "Got non empty content encoding: " + httpURLConnection.getContentEncoding());
                }
                inputStream = httpURLConnection.getInputStream();
            }
            this.f5737k = inputStream;
            return this.f5737k;
        } catch (IOException e10) {
            throw new g4.e("Failed to obtain InputStream", f(httpURLConnection), e10);
        }
    }

    private static boolean h(int i10) {
        return i10 / 100 == 2;
    }

    private static boolean i(int i10) {
        return i10 / 100 == 3;
    }

    private InputStream j(URL url, int i10, URL url2, Map map) {
        if (i10 < 5) {
            if (url2 != null) {
                try {
                    if (url.toURI().equals(url2.toURI())) {
                        throw new g4.e("In re-direct loop", -1);
                    }
                } catch (URISyntaxException unused) {
                }
            }
            HttpURLConnection c10 = c(url, map);
            this.f5736j = c10;
            try {
                c10.connect();
                this.f5737k = this.f5736j.getInputStream();
                if (this.f5738l) {
                    return null;
                }
                int f10 = f(this.f5736j);
                if (h(f10)) {
                    return g(this.f5736j);
                }
                if (!i(f10)) {
                    if (f10 == -1) {
                        throw new g4.e(f10);
                    }
                    try {
                        throw new g4.e(this.f5736j.getResponseMessage(), f10);
                    } catch (IOException e10) {
                        throw new g4.e("Failed to get a response message", f10, e10);
                    }
                }
                String headerField = this.f5736j.getHeaderField("Location");
                if (TextUtils.isEmpty(headerField)) {
                    throw new g4.e("Received empty or null redirect url", f10);
                }
                try {
                    URL url3 = new URL(url, headerField);
                    b();
                    return j(url3, i10 + 1, url, map);
                } catch (MalformedURLException e11) {
                    throw new g4.e("Bad redirect url: " + headerField, f10, e11);
                }
            } catch (IOException e12) {
                throw new g4.e("Failed to connect or obtain data", f(this.f5736j), e12);
            }
        }
        throw new g4.e("Too many (> 5) redirects!", -1);
    }

    @Override // com.bumptech.glide.load.data.d
    public Class a() {
        return InputStream.class;
    }

    @Override // com.bumptech.glide.load.data.d
    public void b() {
        InputStream inputStream = this.f5737k;
        if (inputStream != null) {
            try {
                inputStream.close();
            } catch (IOException unused) {
            }
        }
        HttpURLConnection httpURLConnection = this.f5736j;
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        this.f5736j = null;
    }

    @Override // com.bumptech.glide.load.data.d
    public void cancel() {
        this.f5738l = true;
    }

    @Override // com.bumptech.glide.load.data.d
    public g4.a d() {
        return g4.a.REMOTE;
    }

    @Override // com.bumptech.glide.load.data.d
    public void e(com.bumptech.glide.g gVar, d.a aVar) {
        StringBuilder sb;
        long b10 = b5.g.b();
        try {
            try {
                aVar.f(j(this.f5733g.h(), 0, null, this.f5733g.e()));
            } catch (IOException e10) {
                if (Log.isLoggable("HttpUrlFetcher", 3)) {
                    Log.d("HttpUrlFetcher", "Failed to load data for url", e10);
                }
                aVar.c(e10);
                if (!Log.isLoggable("HttpUrlFetcher", 2)) {
                    return;
                }
                sb = new StringBuilder();
            }
            if (Log.isLoggable("HttpUrlFetcher", 2)) {
                sb = new StringBuilder();
                sb.append("Finished http url fetcher fetch in ");
                sb.append(b5.g.a(b10));
                Log.v("HttpUrlFetcher", sb.toString());
            }
        } catch (Throwable th) {
            if (Log.isLoggable("HttpUrlFetcher", 2)) {
                Log.v("HttpUrlFetcher", "Finished http url fetcher fetch in " + b5.g.a(b10));
            }
            throw th;
        }
    }
}
