package com.bumptech.glide;

import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.util.Log;
import com.bumptech.glide.manager.q;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
/* loaded from: classes.dex */
public class b implements ComponentCallbacks2 {

    /* renamed from: q  reason: collision with root package name */
    private static volatile b f5616q;

    /* renamed from: r  reason: collision with root package name */
    private static volatile boolean f5617r;

    /* renamed from: g  reason: collision with root package name */
    private final i4.k f5618g;

    /* renamed from: h  reason: collision with root package name */
    private final j4.d f5619h;

    /* renamed from: i  reason: collision with root package name */
    private final k4.h f5620i;

    /* renamed from: j  reason: collision with root package name */
    private final d f5621j;

    /* renamed from: k  reason: collision with root package name */
    private final j4.b f5622k;

    /* renamed from: l  reason: collision with root package name */
    private final q f5623l;

    /* renamed from: m  reason: collision with root package name */
    private final com.bumptech.glide.manager.d f5624m;

    /* renamed from: o  reason: collision with root package name */
    private final a f5626o;

    /* renamed from: n  reason: collision with root package name */
    private final List f5625n = new ArrayList();

    /* renamed from: p  reason: collision with root package name */
    private f f5627p = f.NORMAL;

    /* loaded from: classes.dex */
    public interface a {
        x4.h build();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public b(Context context, i4.k kVar, k4.h hVar, j4.d dVar, j4.b bVar, q qVar, com.bumptech.glide.manager.d dVar2, int i10, a aVar, Map map, List list, List list2, v4.a aVar2, e eVar) {
        this.f5618g = kVar;
        this.f5619h = dVar;
        this.f5622k = bVar;
        this.f5620i = hVar;
        this.f5623l = qVar;
        this.f5624m = dVar2;
        this.f5626o = aVar;
        this.f5621j = new d(context, bVar, i.d(this, list2, aVar2), new y4.b(), aVar, map, list, kVar, eVar, i10);
    }

    static void a(Context context, GeneratedAppGlideModule generatedAppGlideModule) {
        if (f5617r) {
            throw new IllegalStateException("Glide has been called recursively, this is probably an internal library error!");
        }
        f5617r = true;
        try {
            n(context, generatedAppGlideModule);
        } finally {
            f5617r = false;
        }
    }

    public static b d(Context context) {
        if (f5616q == null) {
            GeneratedAppGlideModule e10 = e(context.getApplicationContext());
            synchronized (b.class) {
                if (f5616q == null) {
                    a(context, e10);
                }
            }
        }
        return f5616q;
    }

    private static GeneratedAppGlideModule e(Context context) {
        try {
            return (GeneratedAppGlideModule) Class.forName("com.bumptech.glide.GeneratedAppGlideModuleImpl").getDeclaredConstructor(Context.class).newInstance(context.getApplicationContext());
        } catch (ClassNotFoundException unused) {
            if (Log.isLoggable("Glide", 5)) {
                Log.w("Glide", "Failed to find GeneratedAppGlideModule. You should include an annotationProcessor compile dependency on com.github.bumptech.glide:compiler in your application and a @GlideModule annotated AppGlideModule implementation or LibraryGlideModules will be silently ignored");
            }
            return null;
        } catch (IllegalAccessException e10) {
            e = e10;
            r(e);
            return null;
        } catch (InstantiationException e11) {
            e = e11;
            r(e);
            return null;
        } catch (NoSuchMethodException e12) {
            e = e12;
            r(e);
            return null;
        } catch (InvocationTargetException e13) {
            e = e13;
            r(e);
            return null;
        }
    }

    private static q m(Context context) {
        b5.k.e(context, "You cannot start a load on a not yet attached View or a Fragment where getActivity() returns null (which usually occurs when getActivity() is called before the Fragment is attached or after the Fragment is destroyed).");
        return d(context).l();
    }

    private static void n(Context context, GeneratedAppGlideModule generatedAppGlideModule) {
        o(context, new c(), generatedAppGlideModule);
    }

    private static void o(Context context, c cVar, GeneratedAppGlideModule generatedAppGlideModule) {
        Context applicationContext = context.getApplicationContext();
        List<v4.b> emptyList = Collections.emptyList();
        if (generatedAppGlideModule == null || generatedAppGlideModule.c()) {
            emptyList = new v4.d(applicationContext).b();
        }
        if (generatedAppGlideModule != null && !generatedAppGlideModule.d().isEmpty()) {
            Set d10 = generatedAppGlideModule.d();
            Iterator it = emptyList.iterator();
            while (it.hasNext()) {
                v4.b bVar = (v4.b) it.next();
                if (d10.contains(bVar.getClass())) {
                    if (Log.isLoggable("Glide", 3)) {
                        Log.d("Glide", "AppGlideModule excludes manifest GlideModule: " + bVar);
                    }
                    it.remove();
                }
            }
        }
        if (Log.isLoggable("Glide", 3)) {
            Iterator it2 = emptyList.iterator();
            while (it2.hasNext()) {
                Log.d("Glide", "Discovered GlideModule from manifest: " + ((v4.b) it2.next()).getClass());
            }
        }
        cVar.b(generatedAppGlideModule != null ? generatedAppGlideModule.e() : null);
        for (v4.b bVar2 : emptyList) {
            bVar2.a(applicationContext, cVar);
        }
        if (generatedAppGlideModule != null) {
            generatedAppGlideModule.b(applicationContext, cVar);
        }
        b a10 = cVar.a(applicationContext, emptyList, generatedAppGlideModule);
        applicationContext.registerComponentCallbacks(a10);
        f5616q = a10;
    }

    private static void r(Exception exc) {
        throw new IllegalStateException("GeneratedAppGlideModuleImpl is implemented incorrectly. If you've manually implemented this class, remove your implementation. The Annotation processor will generate a correct implementation.", exc);
    }

    public static k u(Context context) {
        return m(context).f(context);
    }

    public void b() {
        b5.l.a();
        this.f5618g.e();
    }

    public void c() {
        b5.l.b();
        this.f5620i.b();
        this.f5619h.b();
        this.f5622k.b();
    }

    public j4.b f() {
        return this.f5622k;
    }

    public j4.d g() {
        return this.f5619h;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public com.bumptech.glide.manager.d h() {
        return this.f5624m;
    }

    public Context i() {
        return this.f5621j.getBaseContext();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public d j() {
        return this.f5621j;
    }

    public h k() {
        return this.f5621j.h();
    }

    public q l() {
        return this.f5623l;
    }

    @Override // android.content.ComponentCallbacks
    public void onConfigurationChanged(Configuration configuration) {
    }

    @Override // android.content.ComponentCallbacks
    public void onLowMemory() {
        c();
    }

    @Override // android.content.ComponentCallbacks2
    public void onTrimMemory(int i10) {
        s(i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void p(k kVar) {
        synchronized (this.f5625n) {
            if (this.f5625n.contains(kVar)) {
                throw new IllegalStateException("Cannot register already registered manager");
            }
            this.f5625n.add(kVar);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean q(y4.d dVar) {
        synchronized (this.f5625n) {
            for (k kVar : this.f5625n) {
                if (kVar.u(dVar)) {
                    return true;
                }
            }
            return false;
        }
    }

    public void s(int i10) {
        b5.l.b();
        synchronized (this.f5625n) {
            for (k kVar : this.f5625n) {
                kVar.onTrimMemory(i10);
            }
        }
        this.f5620i.a(i10);
        this.f5619h.a(i10);
        this.f5622k.a(i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void t(k kVar) {
        synchronized (this.f5625n) {
            if (!this.f5625n.contains(kVar)) {
                throw new IllegalStateException("Cannot unregister not yet registered manager");
            }
            this.f5625n.remove(kVar);
        }
    }
}
