package androidx.work.impl;

import android.content.Context;
import androidx.work.WorkerParameters;
import androidx.work.c;
import androidx.work.impl.background.systemalarm.RescheduleReceiver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
/* loaded from: classes.dex */
public class v0 implements Runnable {

    /* renamed from: y  reason: collision with root package name */
    static final String f4831y = r3.m.i("WorkerWrapper");

    /* renamed from: g  reason: collision with root package name */
    Context f4832g;

    /* renamed from: h  reason: collision with root package name */
    private final String f4833h;

    /* renamed from: i  reason: collision with root package name */
    private WorkerParameters.a f4834i;

    /* renamed from: j  reason: collision with root package name */
    w3.w f4835j;

    /* renamed from: k  reason: collision with root package name */
    androidx.work.c f4836k;

    /* renamed from: l  reason: collision with root package name */
    y3.c f4837l;

    /* renamed from: n  reason: collision with root package name */
    private androidx.work.a f4839n;

    /* renamed from: o  reason: collision with root package name */
    private r3.b f4840o;

    /* renamed from: p  reason: collision with root package name */
    private androidx.work.impl.foreground.a f4841p;

    /* renamed from: q  reason: collision with root package name */
    private WorkDatabase f4842q;

    /* renamed from: r  reason: collision with root package name */
    private w3.x f4843r;

    /* renamed from: s  reason: collision with root package name */
    private w3.b f4844s;

    /* renamed from: t  reason: collision with root package name */
    private List f4845t;

    /* renamed from: u  reason: collision with root package name */
    private String f4846u;

    /* renamed from: m  reason: collision with root package name */
    c.a f4838m = c.a.a();

    /* renamed from: v  reason: collision with root package name */
    androidx.work.impl.utils.futures.c f4847v = androidx.work.impl.utils.futures.c.t();

    /* renamed from: w  reason: collision with root package name */
    final androidx.work.impl.utils.futures.c f4848w = androidx.work.impl.utils.futures.c.t();

    /* renamed from: x  reason: collision with root package name */
    private volatile int f4849x = -256;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ v6.e f4850g;

        a(v6.e eVar) {
            this.f4850g = eVar;
        }

        @Override // java.lang.Runnable
        public void run() {
            if (v0.this.f4848w.isCancelled()) {
                return;
            }
            try {
                this.f4850g.get();
                r3.m e10 = r3.m.e();
                String str = v0.f4831y;
                e10.a(str, "Starting work for " + v0.this.f4835j.f14802c);
                v0 v0Var = v0.this;
                v0Var.f4848w.r(v0Var.f4836k.n());
            } catch (Throwable th) {
                v0.this.f4848w.q(th);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ String f4852g;

        b(String str) {
            this.f4852g = str;
        }

        @Override // java.lang.Runnable
        public void run() {
            try {
                try {
                    c.a aVar = (c.a) v0.this.f4848w.get();
                    if (aVar == null) {
                        r3.m e10 = r3.m.e();
                        String str = v0.f4831y;
                        e10.c(str, v0.this.f4835j.f14802c + " returned a null result. Treating it as a failure.");
                    } else {
                        r3.m e11 = r3.m.e();
                        String str2 = v0.f4831y;
                        e11.a(str2, v0.this.f4835j.f14802c + " returned a " + aVar + ".");
                        v0.this.f4838m = aVar;
                    }
                } catch (InterruptedException e12) {
                    e = e12;
                    r3.m e13 = r3.m.e();
                    String str3 = v0.f4831y;
                    e13.d(str3, this.f4852g + " failed because it threw an exception/error", e);
                } catch (CancellationException e14) {
                    r3.m e15 = r3.m.e();
                    String str4 = v0.f4831y;
                    e15.g(str4, this.f4852g + " was cancelled", e14);
                } catch (ExecutionException e16) {
                    e = e16;
                    r3.m e132 = r3.m.e();
                    String str32 = v0.f4831y;
                    e132.d(str32, this.f4852g + " failed because it threw an exception/error", e);
                }
            } finally {
                v0.this.j();
            }
        }
    }

    /* loaded from: classes.dex */
    public static class c {

        /* renamed from: a  reason: collision with root package name */
        Context f4854a;

        /* renamed from: b  reason: collision with root package name */
        androidx.work.c f4855b;

        /* renamed from: c  reason: collision with root package name */
        androidx.work.impl.foreground.a f4856c;

        /* renamed from: d  reason: collision with root package name */
        y3.c f4857d;

        /* renamed from: e  reason: collision with root package name */
        androidx.work.a f4858e;

        /* renamed from: f  reason: collision with root package name */
        WorkDatabase f4859f;

        /* renamed from: g  reason: collision with root package name */
        w3.w f4860g;

        /* renamed from: h  reason: collision with root package name */
        private final List f4861h;

        /* renamed from: i  reason: collision with root package name */
        WorkerParameters.a f4862i = new WorkerParameters.a();

        public c(Context context, androidx.work.a aVar, y3.c cVar, androidx.work.impl.foreground.a aVar2, WorkDatabase workDatabase, w3.w wVar, List list) {
            this.f4854a = context.getApplicationContext();
            this.f4857d = cVar;
            this.f4856c = aVar2;
            this.f4858e = aVar;
            this.f4859f = workDatabase;
            this.f4860g = wVar;
            this.f4861h = list;
        }

        public v0 b() {
            return new v0(this);
        }

        public c c(WorkerParameters.a aVar) {
            if (aVar != null) {
                this.f4862i = aVar;
            }
            return this;
        }
    }

    v0(c cVar) {
        this.f4832g = cVar.f4854a;
        this.f4837l = cVar.f4857d;
        this.f4841p = cVar.f4856c;
        w3.w wVar = cVar.f4860g;
        this.f4835j = wVar;
        this.f4833h = wVar.f14800a;
        this.f4834i = cVar.f4862i;
        this.f4836k = cVar.f4855b;
        androidx.work.a aVar = cVar.f4858e;
        this.f4839n = aVar;
        this.f4840o = aVar.a();
        WorkDatabase workDatabase = cVar.f4859f;
        this.f4842q = workDatabase;
        this.f4843r = workDatabase.H();
        this.f4844s = this.f4842q.C();
        this.f4845t = cVar.f4861h;
    }

    private String b(List list) {
        StringBuilder sb = new StringBuilder("Work [ id=");
        sb.append(this.f4833h);
        sb.append(", tags={ ");
        Iterator it = list.iterator();
        boolean z9 = true;
        while (it.hasNext()) {
            String str = (String) it.next();
            if (z9) {
                z9 = false;
            } else {
                sb.append(", ");
            }
            sb.append(str);
        }
        sb.append(" } ]");
        return sb.toString();
    }

    private void f(c.a aVar) {
        if (aVar instanceof c.a.C0057c) {
            r3.m e10 = r3.m.e();
            String str = f4831y;
            e10.f(str, "Worker result SUCCESS for " + this.f4846u);
            if (!this.f4835j.m()) {
                q();
                return;
            }
        } else if (aVar instanceof c.a.b) {
            r3.m e11 = r3.m.e();
            String str2 = f4831y;
            e11.f(str2, "Worker result RETRY for " + this.f4846u);
            k();
            return;
        } else {
            r3.m e12 = r3.m.e();
            String str3 = f4831y;
            e12.f(str3, "Worker result FAILURE for " + this.f4846u);
            if (!this.f4835j.m()) {
                p();
                return;
            }
        }
        l();
    }

    private void h(String str) {
        LinkedList linkedList = new LinkedList();
        linkedList.add(str);
        while (!linkedList.isEmpty()) {
            String str2 = (String) linkedList.remove();
            if (this.f4843r.p(str2) != r3.x.CANCELLED) {
                this.f4843r.h(r3.x.FAILED, str2);
            }
            linkedList.addAll(this.f4844s.b(str2));
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void i(v6.e eVar) {
        if (this.f4848w.isCancelled()) {
            eVar.cancel(true);
        }
    }

    private void k() {
        this.f4842q.e();
        try {
            this.f4843r.h(r3.x.ENQUEUED, this.f4833h);
            this.f4843r.k(this.f4833h, this.f4840o.a());
            this.f4843r.y(this.f4833h, this.f4835j.h());
            this.f4843r.c(this.f4833h, -1L);
            this.f4842q.A();
        } finally {
            this.f4842q.i();
            m(true);
        }
    }

    private void l() {
        this.f4842q.e();
        try {
            this.f4843r.k(this.f4833h, this.f4840o.a());
            this.f4843r.h(r3.x.ENQUEUED, this.f4833h);
            this.f4843r.s(this.f4833h);
            this.f4843r.y(this.f4833h, this.f4835j.h());
            this.f4843r.b(this.f4833h);
            this.f4843r.c(this.f4833h, -1L);
            this.f4842q.A();
        } finally {
            this.f4842q.i();
            m(false);
        }
    }

    private void m(boolean z9) {
        this.f4842q.e();
        try {
            if (!this.f4842q.H().m()) {
                x3.p.c(this.f4832g, RescheduleReceiver.class, false);
            }
            if (z9) {
                this.f4843r.h(r3.x.ENQUEUED, this.f4833h);
                this.f4843r.g(this.f4833h, this.f4849x);
                this.f4843r.c(this.f4833h, -1L);
            }
            this.f4842q.A();
            this.f4842q.i();
            this.f4847v.p(Boolean.valueOf(z9));
        } catch (Throwable th) {
            this.f4842q.i();
            throw th;
        }
    }

    private void n() {
        boolean z9;
        r3.x p10 = this.f4843r.p(this.f4833h);
        if (p10 == r3.x.RUNNING) {
            r3.m e10 = r3.m.e();
            String str = f4831y;
            e10.a(str, "Status for " + this.f4833h + " is RUNNING; not doing any work and rescheduling for later execution");
            z9 = true;
        } else {
            r3.m e11 = r3.m.e();
            String str2 = f4831y;
            e11.a(str2, "Status for " + this.f4833h + " is " + p10 + " ; not doing any work");
            z9 = false;
        }
        m(z9);
    }

    private void o() {
        androidx.work.b a10;
        if (r()) {
            return;
        }
        this.f4842q.e();
        try {
            w3.w wVar = this.f4835j;
            if (wVar.f14801b != r3.x.ENQUEUED) {
                n();
                this.f4842q.A();
                r3.m e10 = r3.m.e();
                String str = f4831y;
                e10.a(str, this.f4835j.f14802c + " is not in ENQUEUED state. Nothing more to do");
            } else if ((wVar.m() || this.f4835j.l()) && this.f4840o.a() < this.f4835j.c()) {
                r3.m.e().a(f4831y, String.format("Delaying execution for %s because it is being executed before schedule.", this.f4835j.f14802c));
                m(true);
                this.f4842q.A();
            } else {
                this.f4842q.A();
                this.f4842q.i();
                if (this.f4835j.m()) {
                    a10 = this.f4835j.f14804e;
                } else {
                    r3.i b10 = this.f4839n.f().b(this.f4835j.f14803d);
                    if (b10 == null) {
                        r3.m e11 = r3.m.e();
                        String str2 = f4831y;
                        e11.c(str2, "Could not create Input Merger " + this.f4835j.f14803d);
                        p();
                        return;
                    }
                    ArrayList arrayList = new ArrayList();
                    arrayList.add(this.f4835j.f14804e);
                    arrayList.addAll(this.f4843r.v(this.f4833h));
                    a10 = b10.a(arrayList);
                }
                androidx.work.b bVar = a10;
                UUID fromString = UUID.fromString(this.f4833h);
                List list = this.f4845t;
                WorkerParameters.a aVar = this.f4834i;
                w3.w wVar2 = this.f4835j;
                WorkerParameters workerParameters = new WorkerParameters(fromString, bVar, list, aVar, wVar2.f14810k, wVar2.f(), this.f4839n.d(), this.f4837l, this.f4839n.n(), new x3.b0(this.f4842q, this.f4837l), new x3.a0(this.f4842q, this.f4841p, this.f4837l));
                if (this.f4836k == null) {
                    this.f4836k = this.f4839n.n().b(this.f4832g, this.f4835j.f14802c, workerParameters);
                }
                androidx.work.c cVar = this.f4836k;
                if (cVar == null) {
                    r3.m e12 = r3.m.e();
                    String str3 = f4831y;
                    e12.c(str3, "Could not create Worker " + this.f4835j.f14802c);
                    p();
                } else if (cVar.k()) {
                    r3.m e13 = r3.m.e();
                    String str4 = f4831y;
                    e13.c(str4, "Received an already-used Worker " + this.f4835j.f14802c + "; Worker Factory should return new instances");
                    p();
                } else {
                    this.f4836k.m();
                    if (!s()) {
                        n();
                    } else if (r()) {
                    } else {
                        x3.z zVar = new x3.z(this.f4832g, this.f4835j, this.f4836k, workerParameters.b(), this.f4837l);
                        this.f4837l.b().execute(zVar);
                        final v6.e b11 = zVar.b();
                        this.f4848w.c(new Runnable() { // from class: androidx.work.impl.u0
                            @Override // java.lang.Runnable
                            public final void run() {
                                v0.this.i(b11);
                            }
                        }, new x3.v());
                        b11.c(new a(b11), this.f4837l.b());
                        this.f4848w.c(new b(this.f4846u), this.f4837l.c());
                    }
                }
            }
        } finally {
            this.f4842q.i();
        }
    }

    private void q() {
        this.f4842q.e();
        try {
            this.f4843r.h(r3.x.SUCCEEDED, this.f4833h);
            this.f4843r.j(this.f4833h, ((c.a.C0057c) this.f4838m).e());
            long a10 = this.f4840o.a();
            for (String str : this.f4844s.b(this.f4833h)) {
                if (this.f4843r.p(str) == r3.x.BLOCKED && this.f4844s.c(str)) {
                    r3.m e10 = r3.m.e();
                    String str2 = f4831y;
                    e10.f(str2, "Setting status to enqueued for " + str);
                    this.f4843r.h(r3.x.ENQUEUED, str);
                    this.f4843r.k(str, a10);
                }
            }
            this.f4842q.A();
        } finally {
            this.f4842q.i();
            m(false);
        }
    }

    private boolean r() {
        if (this.f4849x != -256) {
            r3.m e10 = r3.m.e();
            String str = f4831y;
            e10.a(str, "Work interrupted for " + this.f4846u);
            r3.x p10 = this.f4843r.p(this.f4833h);
            if (p10 == null) {
                m(false);
            } else {
                m(!p10.g());
            }
            return true;
        }
        return false;
    }

    private boolean s() {
        boolean z9;
        this.f4842q.e();
        try {
            if (this.f4843r.p(this.f4833h) == r3.x.ENQUEUED) {
                this.f4843r.h(r3.x.RUNNING, this.f4833h);
                this.f4843r.w(this.f4833h);
                this.f4843r.g(this.f4833h, -256);
                z9 = true;
            } else {
                z9 = false;
            }
            this.f4842q.A();
            return z9;
        } finally {
            this.f4842q.i();
        }
    }

    public v6.e c() {
        return this.f4847v;
    }

    public w3.n d() {
        return w3.z.a(this.f4835j);
    }

    public w3.w e() {
        return this.f4835j;
    }

    public void g(int i10) {
        this.f4849x = i10;
        r();
        this.f4848w.cancel(true);
        if (this.f4836k != null && this.f4848w.isCancelled()) {
            this.f4836k.o(i10);
            return;
        }
        r3.m.e().a(f4831y, "WorkSpec " + this.f4835j + " is already done. Not interrupting.");
    }

    void j() {
        if (r()) {
            return;
        }
        this.f4842q.e();
        try {
            r3.x p10 = this.f4843r.p(this.f4833h);
            this.f4842q.G().a(this.f4833h);
            if (p10 == null) {
                m(false);
            } else if (p10 == r3.x.RUNNING) {
                f(this.f4838m);
            } else if (!p10.g()) {
                this.f4849x = -512;
                k();
            }
            this.f4842q.A();
        } finally {
            this.f4842q.i();
        }
    }

    void p() {
        this.f4842q.e();
        try {
            h(this.f4833h);
            androidx.work.b e10 = ((c.a.C0056a) this.f4838m).e();
            this.f4843r.y(this.f4833h, this.f4835j.h());
            this.f4843r.j(this.f4833h, e10);
            this.f4842q.A();
        } finally {
            this.f4842q.i();
            m(false);
        }
    }

    @Override // java.lang.Runnable
    public void run() {
        this.f4846u = b(this.f4845t);
        o();
    }
}
