package androidx.work.impl.utils.futures;

import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
/* loaded from: classes.dex */
public abstract class a implements v6.e {

    /* renamed from: j  reason: collision with root package name */
    static final boolean f4801j = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));

    /* renamed from: k  reason: collision with root package name */
    private static final Logger f4802k = Logger.getLogger(a.class.getName());

    /* renamed from: l  reason: collision with root package name */
    static final b f4803l;

    /* renamed from: m  reason: collision with root package name */
    private static final Object f4804m;

    /* renamed from: g  reason: collision with root package name */
    volatile Object f4805g;

    /* renamed from: h  reason: collision with root package name */
    volatile e f4806h;

    /* renamed from: i  reason: collision with root package name */
    volatile i f4807i;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static abstract class b {
        private b() {
        }

        abstract boolean a(a aVar, e eVar, e eVar2);

        abstract boolean b(a aVar, Object obj, Object obj2);

        abstract boolean c(a aVar, i iVar, i iVar2);

        abstract void d(i iVar, i iVar2);

        abstract void e(i iVar, Thread thread);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class c {

        /* renamed from: c  reason: collision with root package name */
        static final c f4808c;

        /* renamed from: d  reason: collision with root package name */
        static final c f4809d;

        /* renamed from: a  reason: collision with root package name */
        final boolean f4810a;

        /* renamed from: b  reason: collision with root package name */
        final Throwable f4811b;

        static {
            if (a.f4801j) {
                f4809d = null;
                f4808c = null;
                return;
            }
            f4809d = new c(false, null);
            f4808c = new c(true, null);
        }

        c(boolean z9, Throwable th) {
            this.f4810a = z9;
            this.f4811b = th;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class d {

        /* renamed from: b  reason: collision with root package name */
        static final d f4812b = new d(new C0061a("Failure occurred while trying to finish a future."));

        /* renamed from: a  reason: collision with root package name */
        final Throwable f4813a;

        /* renamed from: androidx.work.impl.utils.futures.a$d$a  reason: collision with other inner class name */
        /* loaded from: classes.dex */
        class C0061a extends Throwable {
            C0061a(String str) {
                super(str);
            }

            @Override // java.lang.Throwable
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        }

        d(Throwable th) {
            this.f4813a = (Throwable) a.e(th);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class e {

        /* renamed from: d  reason: collision with root package name */
        static final e f4814d = new e(null, null);

        /* renamed from: a  reason: collision with root package name */
        final Runnable f4815a;

        /* renamed from: b  reason: collision with root package name */
        final Executor f4816b;

        /* renamed from: c  reason: collision with root package name */
        e f4817c;

        e(Runnable runnable, Executor executor) {
            this.f4815a = runnable;
            this.f4816b = executor;
        }
    }

    /* loaded from: classes.dex */
    private static final class f extends b {

        /* renamed from: a  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f4818a;

        /* renamed from: b  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f4819b;

        /* renamed from: c  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f4820c;

        /* renamed from: d  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f4821d;

        /* renamed from: e  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f4822e;

        f(AtomicReferenceFieldUpdater atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater5) {
            super();
            this.f4818a = atomicReferenceFieldUpdater;
            this.f4819b = atomicReferenceFieldUpdater2;
            this.f4820c = atomicReferenceFieldUpdater3;
            this.f4821d = atomicReferenceFieldUpdater4;
            this.f4822e = atomicReferenceFieldUpdater5;
        }

        @Override // androidx.work.impl.utils.futures.a.b
        boolean a(a aVar, e eVar, e eVar2) {
            return androidx.concurrent.futures.b.a(this.f4821d, aVar, eVar, eVar2);
        }

        @Override // androidx.work.impl.utils.futures.a.b
        boolean b(a aVar, Object obj, Object obj2) {
            return androidx.concurrent.futures.b.a(this.f4822e, aVar, obj, obj2);
        }

        @Override // androidx.work.impl.utils.futures.a.b
        boolean c(a aVar, i iVar, i iVar2) {
            return androidx.concurrent.futures.b.a(this.f4820c, aVar, iVar, iVar2);
        }

        @Override // androidx.work.impl.utils.futures.a.b
        void d(i iVar, i iVar2) {
            this.f4819b.lazySet(iVar, iVar2);
        }

        @Override // androidx.work.impl.utils.futures.a.b
        void e(i iVar, Thread thread) {
            this.f4818a.lazySet(iVar, thread);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class g implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final a f4823g;

        /* renamed from: h  reason: collision with root package name */
        final v6.e f4824h;

        g(a aVar, v6.e eVar) {
            this.f4823g = aVar;
            this.f4824h = eVar;
        }

        @Override // java.lang.Runnable
        public void run() {
            if (this.f4823g.f4805g != this) {
                return;
            }
            if (a.f4803l.b(this.f4823g, this, a.j(this.f4824h))) {
                a.g(this.f4823g);
            }
        }
    }

    /* loaded from: classes.dex */
    private static final class h extends b {
        h() {
            super();
        }

        @Override // androidx.work.impl.utils.futures.a.b
        boolean a(a aVar, e eVar, e eVar2) {
            synchronized (aVar) {
                if (aVar.f4806h == eVar) {
                    aVar.f4806h = eVar2;
                    return true;
                }
                return false;
            }
        }

        @Override // androidx.work.impl.utils.futures.a.b
        boolean b(a aVar, Object obj, Object obj2) {
            synchronized (aVar) {
                if (aVar.f4805g == obj) {
                    aVar.f4805g = obj2;
                    return true;
                }
                return false;
            }
        }

        @Override // androidx.work.impl.utils.futures.a.b
        boolean c(a aVar, i iVar, i iVar2) {
            synchronized (aVar) {
                if (aVar.f4807i == iVar) {
                    aVar.f4807i = iVar2;
                    return true;
                }
                return false;
            }
        }

        @Override // androidx.work.impl.utils.futures.a.b
        void d(i iVar, i iVar2) {
            iVar.f4827b = iVar2;
        }

        @Override // androidx.work.impl.utils.futures.a.b
        void e(i iVar, Thread thread) {
            iVar.f4826a = thread;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class i {

        /* renamed from: c  reason: collision with root package name */
        static final i f4825c = new i(false);

        /* renamed from: a  reason: collision with root package name */
        volatile Thread f4826a;

        /* renamed from: b  reason: collision with root package name */
        volatile i f4827b;

        i() {
            a.f4803l.e(this, Thread.currentThread());
        }

        i(boolean z9) {
        }

        void a(i iVar) {
            a.f4803l.d(this, iVar);
        }

        void b() {
            Thread thread = this.f4826a;
            if (thread != null) {
                this.f4826a = null;
                LockSupport.unpark(thread);
            }
        }
    }

    static {
        b hVar;
        try {
            hVar = new f(AtomicReferenceFieldUpdater.newUpdater(i.class, Thread.class, "a"), AtomicReferenceFieldUpdater.newUpdater(i.class, i.class, "b"), AtomicReferenceFieldUpdater.newUpdater(a.class, i.class, "i"), AtomicReferenceFieldUpdater.newUpdater(a.class, e.class, "h"), AtomicReferenceFieldUpdater.newUpdater(a.class, Object.class, "g"));
            th = null;
        } catch (Throwable th) {
            th = th;
            hVar = new h();
        }
        f4803l = hVar;
        if (th != null) {
            f4802k.log(Level.SEVERE, "SafeAtomicHelper is broken!", th);
        }
        f4804m = new Object();
    }

    private void a(StringBuilder sb) {
        String str = "]";
        try {
            Object k10 = k(this);
            sb.append("SUCCESS, result=[");
            sb.append(s(k10));
            sb.append("]");
        } catch (CancellationException unused) {
            str = "CANCELLED";
            sb.append(str);
        } catch (RuntimeException e10) {
            sb.append("UNKNOWN, cause=[");
            sb.append(e10.getClass());
            str = " thrown from get()]";
            sb.append(str);
        } catch (ExecutionException e11) {
            sb.append("FAILURE, cause=[");
            sb.append(e11.getCause());
            sb.append(str);
        }
    }

    private static CancellationException d(String str, Throwable th) {
        CancellationException cancellationException = new CancellationException(str);
        cancellationException.initCause(th);
        return cancellationException;
    }

    static Object e(Object obj) {
        obj.getClass();
        return obj;
    }

    private e f(e eVar) {
        e eVar2;
        do {
            eVar2 = this.f4806h;
        } while (!f4803l.a(this, eVar2, e.f4814d));
        e eVar3 = eVar;
        e eVar4 = eVar2;
        while (eVar4 != null) {
            e eVar5 = eVar4.f4817c;
            eVar4.f4817c = eVar3;
            eVar3 = eVar4;
            eVar4 = eVar5;
        }
        return eVar3;
    }

    static void g(a aVar) {
        e eVar = null;
        while (true) {
            aVar.n();
            aVar.b();
            e f10 = aVar.f(eVar);
            while (f10 != null) {
                eVar = f10.f4817c;
                Runnable runnable = f10.f4815a;
                if (runnable instanceof g) {
                    g gVar = (g) runnable;
                    aVar = gVar.f4823g;
                    if (aVar.f4805g == gVar) {
                        if (f4803l.b(aVar, gVar, j(gVar.f4824h))) {
                            break;
                        }
                    } else {
                        continue;
                    }
                } else {
                    h(runnable, f10.f4816b);
                }
                f10 = eVar;
            }
            return;
        }
    }

    private static void h(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        } catch (RuntimeException e10) {
            Logger logger = f4802k;
            Level level = Level.SEVERE;
            logger.log(level, "RuntimeException while executing runnable " + runnable + " with executor " + executor, (Throwable) e10);
        }
    }

    private Object i(Object obj) {
        if (obj instanceof c) {
            throw d("Task was cancelled.", ((c) obj).f4811b);
        }
        if (obj instanceof d) {
            throw new ExecutionException(((d) obj).f4813a);
        }
        if (obj == f4804m) {
            return null;
        }
        return obj;
    }

    static Object j(v6.e eVar) {
        if (eVar instanceof a) {
            Object obj = ((a) eVar).f4805g;
            if (obj instanceof c) {
                c cVar = (c) obj;
                return cVar.f4810a ? cVar.f4811b != null ? new c(false, cVar.f4811b) : c.f4809d : obj;
            }
            return obj;
        }
        boolean isCancelled = eVar.isCancelled();
        if ((!f4801j) && isCancelled) {
            return c.f4809d;
        }
        try {
            Object k10 = k(eVar);
            return k10 == null ? f4804m : k10;
        } catch (CancellationException e10) {
            if (isCancelled) {
                return new c(false, e10);
            }
            return new d(new IllegalArgumentException("get() threw CancellationException, despite reporting isCancelled() == false: " + eVar, e10));
        } catch (ExecutionException e11) {
            return new d(e11.getCause());
        } catch (Throwable th) {
            return new d(th);
        }
    }

    private static Object k(Future future) {
        Object obj;
        boolean z9 = false;
        while (true) {
            try {
                obj = future.get();
                break;
            } catch (InterruptedException unused) {
                z9 = true;
            } catch (Throwable th) {
                if (z9) {
                    Thread.currentThread().interrupt();
                }
                throw th;
            }
        }
        if (z9) {
            Thread.currentThread().interrupt();
        }
        return obj;
    }

    private void n() {
        i iVar;
        do {
            iVar = this.f4807i;
        } while (!f4803l.c(this, iVar, i.f4825c));
        while (iVar != null) {
            iVar.b();
            iVar = iVar.f4827b;
        }
    }

    private void o(i iVar) {
        iVar.f4826a = null;
        while (true) {
            i iVar2 = this.f4807i;
            if (iVar2 == i.f4825c) {
                return;
            }
            i iVar3 = null;
            while (iVar2 != null) {
                i iVar4 = iVar2.f4827b;
                if (iVar2.f4826a != null) {
                    iVar3 = iVar2;
                } else if (iVar3 != null) {
                    iVar3.f4827b = iVar4;
                    if (iVar3.f4826a == null) {
                        break;
                    }
                } else if (!f4803l.c(this, iVar2, iVar4)) {
                    break;
                }
                iVar2 = iVar4;
            }
            return;
        }
    }

    private String s(Object obj) {
        return obj == this ? "this future" : String.valueOf(obj);
    }

    protected void b() {
    }

    @Override // v6.e
    public final void c(Runnable runnable, Executor executor) {
        e(runnable);
        e(executor);
        e eVar = this.f4806h;
        if (eVar == e.f4814d) {
            h(runnable, executor);
        }
        e eVar2 = new e(runnable, executor);
        do {
            eVar2.f4817c = eVar;
            if (f4803l.a(this, eVar, eVar2)) {
                return;
            }
            eVar = this.f4806h;
        } while (eVar != e.f4814d);
        h(runnable, executor);
    }

    @Override // java.util.concurrent.Future
    public final boolean cancel(boolean z9) {
        Object obj = this.f4805g;
        if (!(obj == null) && !(obj instanceof g)) {
            return false;
        }
        c cVar = f4801j ? new c(z9, new CancellationException("Future.cancel() was called.")) : z9 ? c.f4808c : c.f4809d;
        boolean z10 = false;
        a aVar = this;
        while (true) {
            if (f4803l.b(aVar, obj, cVar)) {
                if (z9) {
                    aVar.l();
                }
                g(aVar);
                if (!(obj instanceof g)) {
                    return true;
                }
                v6.e eVar = ((g) obj).f4824h;
                if (!(eVar instanceof a)) {
                    eVar.cancel(z9);
                    return true;
                }
                aVar = (a) eVar;
                obj = aVar.f4805g;
                if (!(obj == null) && !(obj instanceof g)) {
                    return true;
                }
                z10 = true;
            } else {
                obj = aVar.f4805g;
                if (!(obj instanceof g)) {
                    return z10;
                }
            }
        }
    }

    @Override // java.util.concurrent.Future
    public final Object get() {
        Object obj;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object obj2 = this.f4805g;
        if ((obj2 != null) && (!(obj2 instanceof g))) {
            return i(obj2);
        }
        i iVar = this.f4807i;
        if (iVar != i.f4825c) {
            i iVar2 = new i();
            do {
                iVar2.a(iVar);
                if (f4803l.c(this, iVar, iVar2)) {
                    do {
                        LockSupport.park(this);
                        if (Thread.interrupted()) {
                            o(iVar2);
                            throw new InterruptedException();
                        }
                        obj = this.f4805g;
                    } while (!((obj != null) & (!(obj instanceof g))));
                    return i(obj);
                }
                iVar = this.f4807i;
            } while (iVar != i.f4825c);
            return i(this.f4805g);
        }
        return i(this.f4805g);
    }

    @Override // java.util.concurrent.Future
    public final Object get(long j10, TimeUnit timeUnit) {
        Locale locale;
        long nanos = timeUnit.toNanos(j10);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object obj = this.f4805g;
        if ((obj != null) && (!(obj instanceof g))) {
            return i(obj);
        }
        long nanoTime = nanos > 0 ? System.nanoTime() + nanos : 0L;
        if (nanos >= 1000) {
            i iVar = this.f4807i;
            if (iVar != i.f4825c) {
                i iVar2 = new i();
                do {
                    iVar2.a(iVar);
                    if (f4803l.c(this, iVar, iVar2)) {
                        do {
                            LockSupport.parkNanos(this, nanos);
                            if (Thread.interrupted()) {
                                o(iVar2);
                                throw new InterruptedException();
                            }
                            Object obj2 = this.f4805g;
                            if ((obj2 != null) && (!(obj2 instanceof g))) {
                                return i(obj2);
                            }
                            nanos = nanoTime - System.nanoTime();
                        } while (nanos >= 1000);
                        o(iVar2);
                    } else {
                        iVar = this.f4807i;
                    }
                } while (iVar != i.f4825c);
                return i(this.f4805g);
            }
            return i(this.f4805g);
        }
        while (nanos > 0) {
            Object obj3 = this.f4805g;
            if ((obj3 != null) && (!(obj3 instanceof g))) {
                return i(obj3);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            nanos = nanoTime - System.nanoTime();
        }
        String aVar = toString();
        String lowerCase = timeUnit.toString().toLowerCase(Locale.ROOT);
        String str = "Waited " + j10 + " " + timeUnit.toString().toLowerCase(locale);
        if (nanos + 1000 < 0) {
            String str2 = str + " (plus ";
            long j11 = -nanos;
            long convert = timeUnit.convert(j11, TimeUnit.NANOSECONDS);
            long nanos2 = j11 - timeUnit.toNanos(convert);
            int i10 = (convert > 0L ? 1 : (convert == 0L ? 0 : -1));
            boolean z9 = i10 == 0 || nanos2 > 1000;
            if (i10 > 0) {
                String str3 = str2 + convert + " " + lowerCase;
                if (z9) {
                    str3 = str3 + ",";
                }
                str2 = str3 + " ";
            }
            if (z9) {
                str2 = str2 + nanos2 + " nanoseconds ";
            }
            str = str2 + "delay)";
        }
        if (isDone()) {
            throw new TimeoutException(str + " but future completed as timeout expired");
        }
        throw new TimeoutException(str + " for " + aVar);
    }

    @Override // java.util.concurrent.Future
    public final boolean isCancelled() {
        return this.f4805g instanceof c;
    }

    @Override // java.util.concurrent.Future
    public final boolean isDone() {
        Object obj = this.f4805g;
        return (!(obj instanceof g)) & (obj != null);
    }

    protected void l() {
    }

    protected String m() {
        Object obj = this.f4805g;
        if (obj instanceof g) {
            return "setFuture=[" + s(((g) obj).f4824h) + "]";
        } else if (this instanceof ScheduledFuture) {
            return "remaining delay=[" + ((ScheduledFuture) this).getDelay(TimeUnit.MILLISECONDS) + " ms]";
        } else {
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public boolean p(Object obj) {
        if (obj == null) {
            obj = f4804m;
        }
        if (f4803l.b(this, null, obj)) {
            g(this);
            return true;
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public boolean q(Throwable th) {
        if (f4803l.b(this, null, new d((Throwable) e(th)))) {
            g(this);
            return true;
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public boolean r(v6.e eVar) {
        d dVar;
        e(eVar);
        Object obj = this.f4805g;
        if (obj == null) {
            if (eVar.isDone()) {
                if (f4803l.b(this, null, j(eVar))) {
                    g(this);
                    return true;
                }
                return false;
            }
            g gVar = new g(this, eVar);
            if (f4803l.b(this, null, gVar)) {
                try {
                    eVar.c(gVar, androidx.work.impl.utils.futures.b.INSTANCE);
                } catch (Throwable th) {
                    try {
                        dVar = new d(th);
                    } catch (Throwable unused) {
                        dVar = d.f4812b;
                    }
                    f4803l.b(this, gVar, dVar);
                }
                return true;
            }
            obj = this.f4805g;
        }
        if (obj instanceof c) {
            eVar.cancel(((c) obj).f4810a);
        }
        return false;
    }

    public String toString() {
        String str;
        String str2;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[status=");
        if (!isCancelled()) {
            if (!isDone()) {
                try {
                    str = m();
                } catch (RuntimeException e10) {
                    str = "Exception thrown from implementation: " + e10.getClass();
                }
                if (str != null && !str.isEmpty()) {
                    sb.append("PENDING, info=[");
                    sb.append(str);
                    sb.append("]");
                    sb.append("]");
                    return sb.toString();
                }
                str2 = isDone() ? "PENDING" : "PENDING";
            }
            a(sb);
            sb.append("]");
            return sb.toString();
        }
        str2 = "CANCELLED";
        sb.append(str2);
        sb.append("]");
        return sb.toString();
    }
}
