package androidx.work.impl.utils;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.ApplicationExitInfo;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SQLiteAccessPermException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteTableLockedException;
import android.os.Build;
import android.text.TextUtils;
import androidx.core.os.n;
import androidx.work.a;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.background.systemjob.k;
import androidx.work.impl.f0;
import androidx.work.impl.r0;
import androidx.work.impl.z;
import java.util.List;
import java.util.concurrent.TimeUnit;
import r3.m;
import w3.s;
import w3.w;
import w3.x;
import x3.q;
import x3.r;
/* loaded from: classes.dex */
public class ForceStopRunnable implements Runnable {

    /* renamed from: k  reason: collision with root package name */
    private static final String f4794k = m.i("ForceStopRunnable");

    /* renamed from: l  reason: collision with root package name */
    private static final long f4795l = TimeUnit.DAYS.toMillis(3650);

    /* renamed from: g  reason: collision with root package name */
    private final Context f4796g;

    /* renamed from: h  reason: collision with root package name */
    private final r0 f4797h;

    /* renamed from: i  reason: collision with root package name */
    private final q f4798i;

    /* renamed from: j  reason: collision with root package name */
    private int f4799j = 0;

    /* loaded from: classes.dex */
    public static class BroadcastReceiver extends android.content.BroadcastReceiver {

        /* renamed from: a  reason: collision with root package name */
        private static final String f4800a = m.i("ForceStopRunnable$Rcvr");

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (intent == null || !"ACTION_FORCE_STOP_RESCHEDULE".equals(intent.getAction())) {
                return;
            }
            m.e().j(f4800a, "Rescheduling alarm that keeps track of force-stops.");
            ForceStopRunnable.g(context);
        }
    }

    public ForceStopRunnable(Context context, r0 r0Var) {
        this.f4796g = context.getApplicationContext();
        this.f4797h = r0Var;
        this.f4798i = r0Var.k();
    }

    static Intent c(Context context) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(context, BroadcastReceiver.class));
        intent.setAction("ACTION_FORCE_STOP_RESCHEDULE");
        return intent;
    }

    private static PendingIntent d(Context context, int i10) {
        return PendingIntent.getBroadcast(context, -1, c(context), i10);
    }

    static void g(Context context) {
        AlarmManager alarmManager = (AlarmManager) context.getSystemService("alarm");
        PendingIntent d10 = d(context, Build.VERSION.SDK_INT >= 31 ? 167772160 : 134217728);
        long currentTimeMillis = System.currentTimeMillis() + f4795l;
        if (alarmManager != null) {
            alarmManager.setExact(0, currentTimeMillis, d10);
        }
    }

    public boolean a() {
        boolean i10 = Build.VERSION.SDK_INT >= 23 ? k.i(this.f4796g, this.f4797h.o()) : false;
        WorkDatabase o10 = this.f4797h.o();
        x H = o10.H();
        s G = o10.G();
        o10.e();
        try {
            List<w> l10 = H.l();
            boolean z9 = (l10 == null || l10.isEmpty()) ? false : true;
            if (z9) {
                for (w wVar : l10) {
                    H.h(r3.x.ENQUEUED, wVar.f14800a);
                    H.g(wVar.f14800a, -512);
                    H.c(wVar.f14800a, -1L);
                }
            }
            G.b();
            o10.A();
            return z9 || i10;
        } finally {
            o10.i();
        }
    }

    public void b() {
        boolean a10 = a();
        if (h()) {
            m.e().a(f4794k, "Rescheduling Workers.");
            this.f4797h.r();
            this.f4797h.k().e(false);
        } else if (e()) {
            m.e().a(f4794k, "Application was force-stopped, rescheduling.");
            this.f4797h.r();
            this.f4798i.d(this.f4797h.h().a().a());
        } else if (a10) {
            m.e().a(f4794k, "Found unfinished work, scheduling it.");
            z.h(this.f4797h.h(), this.f4797h.o(), this.f4797h.m());
        }
    }

    public boolean e() {
        List historicalProcessExitReasons;
        try {
            int i10 = Build.VERSION.SDK_INT;
            PendingIntent d10 = d(this.f4796g, i10 >= 31 ? 570425344 : 536870912);
            if (i10 >= 30) {
                if (d10 != null) {
                    d10.cancel();
                }
                historicalProcessExitReasons = ((ActivityManager) this.f4796g.getSystemService("activity")).getHistoricalProcessExitReasons(null, 0, 0);
                if (historicalProcessExitReasons != null && !historicalProcessExitReasons.isEmpty()) {
                    long a10 = this.f4798i.a();
                    for (int i11 = 0; i11 < historicalProcessExitReasons.size(); i11++) {
                        ApplicationExitInfo applicationExitInfo = (ApplicationExitInfo) historicalProcessExitReasons.get(i11);
                        if (applicationExitInfo.getReason() == 10 && applicationExitInfo.getTimestamp() >= a10) {
                            return true;
                        }
                    }
                }
            } else if (d10 == null) {
                g(this.f4796g);
                return true;
            }
            return false;
        } catch (IllegalArgumentException | SecurityException e10) {
            m.e().l(f4794k, "Ignoring exception", e10);
            return true;
        }
    }

    public boolean f() {
        a h10 = this.f4797h.h();
        if (TextUtils.isEmpty(h10.c())) {
            m.e().a(f4794k, "The default process name was not specified.");
            return true;
        }
        boolean b10 = r.b(this.f4796g, h10);
        m e10 = m.e();
        String str = f4794k;
        e10.a(str, "Is default app process = " + b10);
        return b10;
    }

    public boolean h() {
        return this.f4797h.k().b();
    }

    public void i(long j10) {
        try {
            Thread.sleep(j10);
        } catch (InterruptedException unused) {
        }
    }

    @Override // java.lang.Runnable
    public void run() {
        IllegalStateException illegalStateException;
        v.a e10;
        int i10;
        try {
            if (f()) {
                while (true) {
                    try {
                        f0.d(this.f4796g);
                        m.e().a(f4794k, "Performing cleanup operations.");
                    } catch (SQLiteException e11) {
                        m.e().c(f4794k, "Unexpected SQLite exception during migrations");
                        illegalStateException = new IllegalStateException("Unexpected SQLite exception during migrations", e11);
                        e10 = this.f4797h.h().e();
                        if (e10 == null) {
                            throw illegalStateException;
                        }
                    }
                    try {
                        b();
                        break;
                    } catch (SQLiteAccessPermException | SQLiteCantOpenDatabaseException | SQLiteConstraintException | SQLiteDatabaseCorruptException | SQLiteDatabaseLockedException | SQLiteDiskIOException | SQLiteTableLockedException e12) {
                        i10 = this.f4799j + 1;
                        this.f4799j = i10;
                        if (i10 >= 3) {
                            String str = n.a(this.f4796g) ? "The file system on the device is in a bad state. WorkManager cannot access the app's internal data store." : "WorkManager can't be accessed from direct boot, because credential encrypted storage isn't accessible.\nDon't access or initialise WorkManager from directAware components. See https://developer.android.com/training/articles/direct-boot";
                            m e13 = m.e();
                            String str2 = f4794k;
                            e13.d(str2, str, e12);
                            illegalStateException = new IllegalStateException(str, e12);
                            e10 = this.f4797h.h().e();
                            if (e10 == null) {
                                throw illegalStateException;
                            }
                            m.e().b(str2, "Routing exception to the specified exception handler", illegalStateException);
                            e10.accept(illegalStateException);
                        }
                        m e14 = m.e();
                        String str3 = f4794k;
                        e14.b(str3, "Retrying after " + (i10 * 300), e12);
                        i(((long) this.f4799j) * 300);
                    }
                    m e142 = m.e();
                    String str32 = f4794k;
                    e142.b(str32, "Retrying after " + (i10 * 300), e12);
                    i(((long) this.f4799j) * 300);
                }
            }
        } finally {
            this.f4797h.q();
        }
    }
}
