package androidx.work.impl.foreground;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import androidx.work.impl.f;
import androidx.work.impl.r0;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import r3.g;
import r3.m;
import t3.b;
import t3.d;
import t3.e;
import w3.n;
import w3.w;
import w3.z;
import z8.o1;
/* loaded from: classes.dex */
public class b implements d, f {

    /* renamed from: q  reason: collision with root package name */
    static final String f4724q = m.i("SystemFgDispatcher");

    /* renamed from: g  reason: collision with root package name */
    private Context f4725g;

    /* renamed from: h  reason: collision with root package name */
    private r0 f4726h;

    /* renamed from: i  reason: collision with root package name */
    private final y3.c f4727i;

    /* renamed from: j  reason: collision with root package name */
    final Object f4728j = new Object();

    /* renamed from: k  reason: collision with root package name */
    n f4729k;

    /* renamed from: l  reason: collision with root package name */
    final Map f4730l;

    /* renamed from: m  reason: collision with root package name */
    final Map f4731m;

    /* renamed from: n  reason: collision with root package name */
    final Map f4732n;

    /* renamed from: o  reason: collision with root package name */
    final e f4733o;

    /* renamed from: p  reason: collision with root package name */
    private InterfaceC0059b f4734p;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ String f4735g;

        a(String str) {
            this.f4735g = str;
        }

        @Override // java.lang.Runnable
        public void run() {
            w g10 = b.this.f4726h.l().g(this.f4735g);
            if (g10 == null || !g10.k()) {
                return;
            }
            synchronized (b.this.f4728j) {
                b.this.f4731m.put(z.a(g10), g10);
                b bVar = b.this;
                b.this.f4732n.put(z.a(g10), t3.f.b(bVar.f4733o, g10, bVar.f4727i.a(), b.this));
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: androidx.work.impl.foreground.b$b  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public interface InterfaceC0059b {
        void b(int i10, int i11, Notification notification);

        void c(int i10, Notification notification);

        void d(int i10);

        void stop();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public b(Context context) {
        this.f4725g = context;
        r0 j10 = r0.j(context);
        this.f4726h = j10;
        this.f4727i = j10.p();
        this.f4729k = null;
        this.f4730l = new LinkedHashMap();
        this.f4732n = new HashMap();
        this.f4731m = new HashMap();
        this.f4733o = new e(this.f4726h.n());
        this.f4726h.l().e(this);
    }

    public static Intent d(Context context, n nVar, g gVar) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction("ACTION_NOTIFY");
        intent.putExtra("KEY_NOTIFICATION_ID", gVar.c());
        intent.putExtra("KEY_FOREGROUND_SERVICE_TYPE", gVar.a());
        intent.putExtra("KEY_NOTIFICATION", gVar.b());
        intent.putExtra("KEY_WORKSPEC_ID", nVar.b());
        intent.putExtra("KEY_GENERATION", nVar.a());
        return intent;
    }

    public static Intent f(Context context, n nVar, g gVar) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction("ACTION_START_FOREGROUND");
        intent.putExtra("KEY_WORKSPEC_ID", nVar.b());
        intent.putExtra("KEY_GENERATION", nVar.a());
        intent.putExtra("KEY_NOTIFICATION_ID", gVar.c());
        intent.putExtra("KEY_FOREGROUND_SERVICE_TYPE", gVar.a());
        intent.putExtra("KEY_NOTIFICATION", gVar.b());
        return intent;
    }

    public static Intent g(Context context) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction("ACTION_STOP_FOREGROUND");
        return intent;
    }

    private void h(Intent intent) {
        m e10 = m.e();
        String str = f4724q;
        e10.f(str, "Stopping foreground work for " + intent);
        String stringExtra = intent.getStringExtra("KEY_WORKSPEC_ID");
        if (stringExtra == null || TextUtils.isEmpty(stringExtra)) {
            return;
        }
        this.f4726h.b(UUID.fromString(stringExtra));
    }

    private void i(Intent intent) {
        int i10 = 0;
        int intExtra = intent.getIntExtra("KEY_NOTIFICATION_ID", 0);
        int intExtra2 = intent.getIntExtra("KEY_FOREGROUND_SERVICE_TYPE", 0);
        String stringExtra = intent.getStringExtra("KEY_WORKSPEC_ID");
        n nVar = new n(stringExtra, intent.getIntExtra("KEY_GENERATION", 0));
        Notification notification = (Notification) intent.getParcelableExtra("KEY_NOTIFICATION");
        m e10 = m.e();
        String str = f4724q;
        e10.a(str, "Notifying with (id:" + intExtra + ", workSpecId: " + stringExtra + ", notificationType :" + intExtra2 + ")");
        if (notification == null || this.f4734p == null) {
            return;
        }
        this.f4730l.put(nVar, new g(intExtra, notification, intExtra2));
        if (this.f4729k == null) {
            this.f4729k = nVar;
            this.f4734p.b(intExtra, intExtra2, notification);
            return;
        }
        this.f4734p.c(intExtra, notification);
        if (intExtra2 == 0 || Build.VERSION.SDK_INT < 29) {
            return;
        }
        for (Map.Entry entry : this.f4730l.entrySet()) {
            i10 |= ((g) entry.getValue()).a();
        }
        g gVar = (g) this.f4730l.get(this.f4729k);
        if (gVar != null) {
            this.f4734p.b(gVar.c(), i10, gVar.b());
        }
    }

    private void j(Intent intent) {
        m e10 = m.e();
        String str = f4724q;
        e10.f(str, "Started foreground service " + intent);
        this.f4727i.d(new a(intent.getStringExtra("KEY_WORKSPEC_ID")));
    }

    @Override // t3.d
    public void a(w wVar, t3.b bVar) {
        if (bVar instanceof b.C0226b) {
            String str = wVar.f14800a;
            m e10 = m.e();
            String str2 = f4724q;
            e10.a(str2, "Constraints unmet for WorkSpec " + str);
            this.f4726h.t(z.a(wVar));
        }
    }

    @Override // androidx.work.impl.f
    public void e(n nVar, boolean z9) {
        Map.Entry entry;
        synchronized (this.f4728j) {
            o1 o1Var = ((w) this.f4731m.remove(nVar)) != null ? (o1) this.f4732n.remove(nVar) : null;
            if (o1Var != null) {
                o1Var.b(null);
            }
        }
        g gVar = (g) this.f4730l.remove(nVar);
        if (nVar.equals(this.f4729k)) {
            if (this.f4730l.size() > 0) {
                Iterator it = this.f4730l.entrySet().iterator();
                do {
                    entry = (Map.Entry) it.next();
                } while (it.hasNext());
                this.f4729k = (n) entry.getKey();
                if (this.f4734p != null) {
                    g gVar2 = (g) entry.getValue();
                    this.f4734p.b(gVar2.c(), gVar2.a(), gVar2.b());
                    this.f4734p.d(gVar2.c());
                }
            } else {
                this.f4729k = null;
            }
        }
        InterfaceC0059b interfaceC0059b = this.f4734p;
        if (gVar == null || interfaceC0059b == null) {
            return;
        }
        m e10 = m.e();
        String str = f4724q;
        e10.a(str, "Removing Notification (id: " + gVar.c() + ", workSpecId: " + nVar + ", notificationType: " + gVar.a());
        interfaceC0059b.d(gVar.c());
    }

    void k(Intent intent) {
        m.e().f(f4724q, "Stopping foreground service");
        InterfaceC0059b interfaceC0059b = this.f4734p;
        if (interfaceC0059b != null) {
            interfaceC0059b.stop();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void l() {
        this.f4734p = null;
        synchronized (this.f4728j) {
            for (o1 o1Var : this.f4732n.values()) {
                o1Var.b(null);
            }
        }
        this.f4726h.l().p(this);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void m(Intent intent) {
        String action = intent.getAction();
        if ("ACTION_START_FOREGROUND".equals(action)) {
            j(intent);
        } else if (!"ACTION_NOTIFY".equals(action)) {
            if ("ACTION_CANCEL_WORK".equals(action)) {
                h(intent);
                return;
            } else if ("ACTION_STOP_FOREGROUND".equals(action)) {
                k(intent);
                return;
            } else {
                return;
            }
        }
        i(intent);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void n(InterfaceC0059b interfaceC0059b) {
        if (this.f4734p != null) {
            m.e().c(f4724q, "A callback already exists.");
        } else {
            this.f4734p = interfaceC0059b;
        }
    }
}
