package androidx.work.impl.foreground;

import android.app.ForegroundServiceStartNotAllowedException;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.lifecycle.o;
import androidx.work.impl.foreground.b;
import r3.m;
/* loaded from: classes.dex */
public class SystemForegroundService extends o implements b.InterfaceC0059b {

    /* renamed from: l  reason: collision with root package name */
    private static final String f4709l = m.i("SystemFgService");

    /* renamed from: m  reason: collision with root package name */
    private static SystemForegroundService f4710m = null;

    /* renamed from: h  reason: collision with root package name */
    private Handler f4711h;

    /* renamed from: i  reason: collision with root package name */
    private boolean f4712i;

    /* renamed from: j  reason: collision with root package name */
    androidx.work.impl.foreground.b f4713j;

    /* renamed from: k  reason: collision with root package name */
    NotificationManager f4714k;

    /* loaded from: classes.dex */
    class a implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ int f4715g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ Notification f4716h;

        /* renamed from: i  reason: collision with root package name */
        final /* synthetic */ int f4717i;

        a(int i10, Notification notification, int i11) {
            this.f4715g = i10;
            this.f4716h = notification;
            this.f4717i = i11;
        }

        @Override // java.lang.Runnable
        public void run() {
            int i10 = Build.VERSION.SDK_INT;
            if (i10 >= 31) {
                e.a(SystemForegroundService.this, this.f4715g, this.f4716h, this.f4717i);
            } else if (i10 >= 29) {
                d.a(SystemForegroundService.this, this.f4715g, this.f4716h, this.f4717i);
            } else {
                SystemForegroundService.this.startForeground(this.f4715g, this.f4716h);
            }
        }
    }

    /* loaded from: classes.dex */
    class b implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ int f4719g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ Notification f4720h;

        b(int i10, Notification notification) {
            this.f4719g = i10;
            this.f4720h = notification;
        }

        @Override // java.lang.Runnable
        public void run() {
            SystemForegroundService.this.f4714k.notify(this.f4719g, this.f4720h);
        }
    }

    /* loaded from: classes.dex */
    class c implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ int f4722g;

        c(int i10) {
            this.f4722g = i10;
        }

        @Override // java.lang.Runnable
        public void run() {
            SystemForegroundService.this.f4714k.cancel(this.f4722g);
        }
    }

    /* loaded from: classes.dex */
    static class d {
        static void a(Service service, int i10, Notification notification, int i11) {
            service.startForeground(i10, notification, i11);
        }
    }

    /* loaded from: classes.dex */
    static class e {
        static void a(Service service, int i10, Notification notification, int i11) {
            try {
                service.startForeground(i10, notification, i11);
            } catch (ForegroundServiceStartNotAllowedException e10) {
                m.e().l(SystemForegroundService.f4709l, "Unable to start foreground service", e10);
            }
        }
    }

    private void f() {
        this.f4711h = new Handler(Looper.getMainLooper());
        this.f4714k = (NotificationManager) getApplicationContext().getSystemService("notification");
        androidx.work.impl.foreground.b bVar = new androidx.work.impl.foreground.b(getApplicationContext());
        this.f4713j = bVar;
        bVar.n(this);
    }

    @Override // androidx.work.impl.foreground.b.InterfaceC0059b
    public void b(int i10, int i11, Notification notification) {
        this.f4711h.post(new a(i10, notification, i11));
    }

    @Override // androidx.work.impl.foreground.b.InterfaceC0059b
    public void c(int i10, Notification notification) {
        this.f4711h.post(new b(i10, notification));
    }

    @Override // androidx.work.impl.foreground.b.InterfaceC0059b
    public void d(int i10) {
        this.f4711h.post(new c(i10));
    }

    @Override // androidx.lifecycle.o, android.app.Service
    public void onCreate() {
        super.onCreate();
        f4710m = this;
        f();
    }

    @Override // androidx.lifecycle.o, android.app.Service
    public void onDestroy() {
        super.onDestroy();
        this.f4713j.l();
    }

    @Override // androidx.lifecycle.o, android.app.Service
    public int onStartCommand(Intent intent, int i10, int i11) {
        super.onStartCommand(intent, i10, i11);
        if (this.f4712i) {
            m.e().f(f4709l, "Re-initializing SystemForegroundService after a request to shut-down.");
            this.f4713j.l();
            f();
            this.f4712i = false;
        }
        if (intent != null) {
            this.f4713j.m(intent);
            return 3;
        }
        return 3;
    }

    @Override // androidx.work.impl.foreground.b.InterfaceC0059b
    public void stop() {
        this.f4712i = true;
        m.e().a(f4709l, "All commands completed.");
        if (Build.VERSION.SDK_INT >= 26) {
            stopForeground(true);
        }
        f4710m = null;
        stopSelf();
    }
}
