package androidx.work.impl.background.systemjob;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.w;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import r3.r;
import w3.x;
import w3.z;
/* loaded from: classes.dex */
public class k implements w {

    /* renamed from: l  reason: collision with root package name */
    private static final String f4687l = r3.m.i("SystemJobScheduler");

    /* renamed from: g  reason: collision with root package name */
    private final Context f4688g;

    /* renamed from: h  reason: collision with root package name */
    private final JobScheduler f4689h;

    /* renamed from: i  reason: collision with root package name */
    private final j f4690i;

    /* renamed from: j  reason: collision with root package name */
    private final WorkDatabase f4691j;

    /* renamed from: k  reason: collision with root package name */
    private final androidx.work.a f4692k;

    public k(Context context, WorkDatabase workDatabase, androidx.work.a aVar) {
        this(context, workDatabase, aVar, (JobScheduler) context.getSystemService("jobscheduler"), new j(context, aVar.a()));
    }

    public k(Context context, WorkDatabase workDatabase, androidx.work.a aVar, JobScheduler jobScheduler, j jVar) {
        this.f4688g = context;
        this.f4689h = jobScheduler;
        this.f4690i = jVar;
        this.f4691j = workDatabase;
        this.f4692k = aVar;
    }

    public static void a(Context context) {
        List<JobInfo> g10;
        JobScheduler jobScheduler = (JobScheduler) context.getSystemService("jobscheduler");
        if (jobScheduler == null || (g10 = g(context, jobScheduler)) == null || g10.isEmpty()) {
            return;
        }
        for (JobInfo jobInfo : g10) {
            e(jobScheduler, jobInfo.getId());
        }
    }

    private static void e(JobScheduler jobScheduler, int i10) {
        try {
            jobScheduler.cancel(i10);
        } catch (Throwable th) {
            r3.m.e().d(f4687l, String.format(Locale.getDefault(), "Exception while trying to cancel job (%d)", Integer.valueOf(i10)), th);
        }
    }

    private static List f(Context context, JobScheduler jobScheduler, String str) {
        List<JobInfo> g10 = g(context, jobScheduler);
        if (g10 == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(2);
        for (JobInfo jobInfo : g10) {
            w3.n h10 = h(jobInfo);
            if (h10 != null && str.equals(h10.b())) {
                arrayList.add(Integer.valueOf(jobInfo.getId()));
            }
        }
        return arrayList;
    }

    private static List g(Context context, JobScheduler jobScheduler) {
        List<JobInfo> list;
        try {
            list = jobScheduler.getAllPendingJobs();
        } catch (Throwable th) {
            r3.m.e().d(f4687l, "getAllPendingJobs() is not reliable on this device.", th);
            list = null;
        }
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        ComponentName componentName = new ComponentName(context, SystemJobService.class);
        for (JobInfo jobInfo : list) {
            if (componentName.equals(jobInfo.getService())) {
                arrayList.add(jobInfo);
            }
        }
        return arrayList;
    }

    private static w3.n h(JobInfo jobInfo) {
        PersistableBundle extras = jobInfo.getExtras();
        if (extras != null) {
            try {
                if (extras.containsKey("EXTRA_WORK_SPEC_ID")) {
                    return new w3.n(extras.getString("EXTRA_WORK_SPEC_ID"), extras.getInt("EXTRA_WORK_SPEC_GENERATION", 0));
                }
                return null;
            } catch (NullPointerException unused) {
                return null;
            }
        }
        return null;
    }

    public static boolean i(Context context, WorkDatabase workDatabase) {
        JobScheduler jobScheduler = (JobScheduler) context.getSystemService("jobscheduler");
        List<JobInfo> g10 = g(context, jobScheduler);
        List<String> b10 = workDatabase.E().b();
        boolean z9 = false;
        HashSet hashSet = new HashSet(g10 != null ? g10.size() : 0);
        if (g10 != null && !g10.isEmpty()) {
            for (JobInfo jobInfo : g10) {
                w3.n h10 = h(jobInfo);
                if (h10 != null) {
                    hashSet.add(h10.b());
                } else {
                    e(jobScheduler, jobInfo.getId());
                }
            }
        }
        Iterator it = b10.iterator();
        while (true) {
            if (it.hasNext()) {
                if (!hashSet.contains((String) it.next())) {
                    r3.m.e().a(f4687l, "Reconciling jobs");
                    z9 = true;
                    break;
                }
            } else {
                break;
            }
        }
        if (z9) {
            workDatabase.e();
            try {
                x H = workDatabase.H();
                for (String str : b10) {
                    H.c(str, -1L);
                }
                workDatabase.A();
            } finally {
                workDatabase.i();
            }
        }
        return z9;
    }

    @Override // androidx.work.impl.w
    public boolean b() {
        return true;
    }

    @Override // androidx.work.impl.w
    public void c(w3.w... wVarArr) {
        WorkDatabase workDatabase;
        List f10;
        x3.i iVar = new x3.i(this.f4691j);
        for (w3.w wVar : wVarArr) {
            this.f4691j.e();
            try {
                w3.w q10 = this.f4691j.H().q(wVar.f14800a);
                if (q10 == null) {
                    r3.m.e().k(f4687l, "Skipping scheduling " + wVar.f14800a + " because it's no longer in the DB");
                    workDatabase = this.f4691j;
                } else if (q10.f14801b != r3.x.ENQUEUED) {
                    r3.m.e().k(f4687l, "Skipping scheduling " + wVar.f14800a + " because it is no longer enqueued");
                    workDatabase = this.f4691j;
                } else {
                    w3.n a10 = z.a(wVar);
                    w3.i d10 = this.f4691j.E().d(a10);
                    int e10 = d10 != null ? d10.f14775c : iVar.e(this.f4692k.i(), this.f4692k.g());
                    if (d10 == null) {
                        this.f4691j.E().c(w3.m.a(a10, e10));
                    }
                    j(wVar, e10);
                    if (Build.VERSION.SDK_INT == 23 && (f10 = f(this.f4688g, this.f4689h, wVar.f14800a)) != null) {
                        int indexOf = f10.indexOf(Integer.valueOf(e10));
                        if (indexOf >= 0) {
                            f10.remove(indexOf);
                        }
                        j(wVar, !f10.isEmpty() ? ((Integer) f10.get(0)).intValue() : iVar.e(this.f4692k.i(), this.f4692k.g()));
                    }
                    workDatabase = this.f4691j;
                }
                workDatabase.A();
            } finally {
                this.f4691j.i();
            }
        }
    }

    @Override // androidx.work.impl.w
    public void d(String str) {
        List<Integer> f10 = f(this.f4688g, this.f4689h, str);
        if (f10 == null || f10.isEmpty()) {
            return;
        }
        for (Integer num : f10) {
            e(this.f4689h, num.intValue());
        }
        this.f4691j.E().f(str);
    }

    public void j(w3.w wVar, int i10) {
        JobInfo a10 = this.f4690i.a(wVar, i10);
        r3.m e10 = r3.m.e();
        String str = f4687l;
        e10.a(str, "Scheduling work ID " + wVar.f14800a + "Job ID " + i10);
        try {
            if (this.f4689h.schedule(a10) == 0) {
                r3.m e11 = r3.m.e();
                e11.k(str, "Unable to schedule work ID " + wVar.f14800a);
                if (wVar.f14816q && wVar.f14817r == r.RUN_AS_NON_EXPEDITED_WORK_REQUEST) {
                    wVar.f14816q = false;
                    r3.m.e().a(str, String.format("Scheduling a non-expedited job (work ID %s)", wVar.f14800a));
                    j(wVar, i10);
                }
            }
        } catch (IllegalStateException e12) {
            List g10 = g(this.f4688g, this.f4689h);
            String format = String.format(Locale.getDefault(), "JobScheduler 100 job limit exceeded.  We count %d WorkManager jobs in JobScheduler; we have %d tracked jobs in our DB; our Configuration limit is %d.", Integer.valueOf(g10 != null ? g10.size() : 0), Integer.valueOf(this.f4691j.H().i().size()), Integer.valueOf(this.f4692k.h()));
            r3.m.e().c(f4687l, format);
            IllegalStateException illegalStateException = new IllegalStateException(format, e12);
            v.a l10 = this.f4692k.l();
            if (l10 == null) {
                throw illegalStateException;
            }
            l10.accept(illegalStateException);
        } catch (Throwable th) {
            r3.m e13 = r3.m.e();
            String str2 = f4687l;
            e13.d(str2, "Unable to schedule " + wVar, th);
        }
    }
}
