package androidx.work.impl.background.systemjob;

import android.app.job.JobInfo;
import android.app.job.JobInfo$TriggerContentUri;
import android.content.ComponentName;
import android.content.Context;
import android.net.NetworkRequest;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.os.PersistableBundle;
import r3.d;
import w3.w;
/* loaded from: classes.dex */
class j {

    /* renamed from: c  reason: collision with root package name */
    private static final String f4683c = r3.m.i("SystemJobInfoConverter");

    /* renamed from: a  reason: collision with root package name */
    private final ComponentName f4684a;

    /* renamed from: b  reason: collision with root package name */
    private final r3.b f4685b;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static /* synthetic */ class a {

        /* renamed from: a  reason: collision with root package name */
        static final /* synthetic */ int[] f4686a;

        static {
            int[] iArr = new int[r3.n.values().length];
            f4686a = iArr;
            try {
                iArr[r3.n.NOT_REQUIRED.ordinal()] = 1;
            } catch (NoSuchFieldError unused) {
            }
            try {
                f4686a[r3.n.CONNECTED.ordinal()] = 2;
            } catch (NoSuchFieldError unused2) {
            }
            try {
                f4686a[r3.n.UNMETERED.ordinal()] = 3;
            } catch (NoSuchFieldError unused3) {
            }
            try {
                f4686a[r3.n.NOT_ROAMING.ordinal()] = 4;
            } catch (NoSuchFieldError unused4) {
            }
            try {
                f4686a[r3.n.METERED.ordinal()] = 5;
            } catch (NoSuchFieldError unused5) {
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public j(Context context, r3.b bVar) {
        this.f4685b = bVar;
        this.f4684a = new ComponentName(context.getApplicationContext(), SystemJobService.class);
    }

    /* JADX WARN: Type inference failed for: r1v0, types: [android.app.job.JobInfo$TriggerContentUri] */
    private static JobInfo$TriggerContentUri b(d.c cVar) {
        boolean b10 = cVar.b();
        final Uri a10 = cVar.a();
        final int i10 = b10 ? 1 : 0;
        return new Parcelable(a10, i10) { // from class: android.app.job.JobInfo$TriggerContentUri
            static {
                throw new NoClassDefFoundError();
            }
        };
    }

    static int c(r3.n nVar) {
        int i10 = a.f4686a[nVar.ordinal()];
        if (i10 != 1) {
            if (i10 != 2) {
                if (i10 != 3) {
                    if (i10 != 4) {
                        if (i10 == 5 && Build.VERSION.SDK_INT >= 26) {
                            return 4;
                        }
                    } else if (Build.VERSION.SDK_INT >= 24) {
                        return 3;
                    }
                    r3.m e10 = r3.m.e();
                    String str = f4683c;
                    e10.a(str, "API version too low. Cannot convert network type value " + nVar);
                    return 1;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    static void d(JobInfo.Builder builder, r3.n nVar) {
        if (Build.VERSION.SDK_INT < 30 || nVar != r3.n.TEMPORARILY_UNMETERED) {
            builder.setRequiredNetworkType(c(nVar));
        } else {
            builder.setRequiredNetwork(new NetworkRequest.Builder().addCapability(25).build());
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public JobInfo a(w wVar, int i10) {
        r3.d dVar = wVar.f14809j;
        PersistableBundle persistableBundle = new PersistableBundle();
        persistableBundle.putString("EXTRA_WORK_SPEC_ID", wVar.f14800a);
        persistableBundle.putInt("EXTRA_WORK_SPEC_GENERATION", wVar.f());
        persistableBundle.putBoolean("EXTRA_IS_PERIODIC", wVar.m());
        JobInfo.Builder extras = new JobInfo.Builder(i10, this.f4684a).setRequiresCharging(dVar.g()).setRequiresDeviceIdle(dVar.h()).setExtras(persistableBundle);
        d(extras, dVar.d());
        if (!dVar.h()) {
            extras.setBackoffCriteria(wVar.f14812m, wVar.f14811l == r3.a.LINEAR ? 0 : 1);
        }
        long max = Math.max(wVar.c() - this.f4685b.a(), 0L);
        int i11 = Build.VERSION.SDK_INT;
        if (i11 <= 28 || max > 0) {
            extras.setMinimumLatency(max);
        } else if (!wVar.f14816q) {
            extras.setImportantWhileForeground(true);
        }
        if (i11 >= 24 && dVar.e()) {
            for (d.c cVar : dVar.c()) {
                extras.addTriggerContentUri(b(cVar));
            }
            extras.setTriggerContentUpdateDelay(dVar.b());
            extras.setTriggerContentMaxDelay(dVar.a());
        }
        extras.setPersisted(false);
        int i12 = Build.VERSION.SDK_INT;
        if (i12 >= 26) {
            extras.setRequiresBatteryNotLow(dVar.f());
            extras.setRequiresStorageNotLow(dVar.i());
        }
        boolean z9 = wVar.f14810k > 0;
        boolean z10 = max > 0;
        if (i12 >= 31 && wVar.f14816q && !z9 && !z10) {
            extras.setExpedited(true);
        }
        return extras.build();
    }
}
