package androidx.work.impl.background.systemjob;

import android.app.Application;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.net.Network;
import android.net.Uri;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.work.WorkerParameters;
import androidx.work.impl.a0;
import androidx.work.impl.b0;
import androidx.work.impl.o0;
import androidx.work.impl.p0;
import androidx.work.impl.r0;
import androidx.work.impl.u;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
/* loaded from: classes.dex */
public class SystemJobService extends JobService implements androidx.work.impl.f {

    /* renamed from: k  reason: collision with root package name */
    private static final String f4678k = r3.m.i("SystemJobService");

    /* renamed from: g  reason: collision with root package name */
    private r0 f4679g;

    /* renamed from: h  reason: collision with root package name */
    private final Map f4680h = new HashMap();

    /* renamed from: i  reason: collision with root package name */
    private final b0 f4681i = new b0();

    /* renamed from: j  reason: collision with root package name */
    private o0 f4682j;

    /* loaded from: classes.dex */
    static class a {
        static String[] a(JobParameters jobParameters) {
            String[] triggeredContentAuthorities;
            triggeredContentAuthorities = jobParameters.getTriggeredContentAuthorities();
            return triggeredContentAuthorities;
        }

        static Uri[] b(JobParameters jobParameters) {
            Uri[] triggeredContentUris;
            triggeredContentUris = jobParameters.getTriggeredContentUris();
            return triggeredContentUris;
        }
    }

    /* loaded from: classes.dex */
    static class b {
        static Network a(JobParameters jobParameters) {
            Network network;
            network = jobParameters.getNetwork();
            return network;
        }
    }

    /* loaded from: classes.dex */
    static class c {
        static int a(JobParameters jobParameters) {
            int stopReason;
            stopReason = jobParameters.getStopReason();
            return SystemJobService.a(stopReason);
        }
    }

    static int a(int i10) {
        switch (i10) {
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
            case 9:
            case 10:
            case 11:
            case 12:
            case 13:
            case 14:
            case 15:
                return i10;
            default:
                return -512;
        }
    }

    private static w3.n b(JobParameters jobParameters) {
        try {
            PersistableBundle extras = jobParameters.getExtras();
            if (extras == null || !extras.containsKey("EXTRA_WORK_SPEC_ID")) {
                return null;
            }
            return new w3.n(extras.getString("EXTRA_WORK_SPEC_ID"), extras.getInt("EXTRA_WORK_SPEC_GENERATION"));
        } catch (NullPointerException unused) {
            return null;
        }
    }

    @Override // androidx.work.impl.f
    public void e(w3.n nVar, boolean z9) {
        JobParameters jobParameters;
        r3.m e10 = r3.m.e();
        String str = f4678k;
        e10.a(str, nVar.b() + " executed on JobScheduler");
        synchronized (this.f4680h) {
            jobParameters = (JobParameters) this.f4680h.remove(nVar);
        }
        this.f4681i.b(nVar);
        if (jobParameters != null) {
            jobFinished(jobParameters, z9);
        }
    }

    @Override // android.app.Service
    public void onCreate() {
        super.onCreate();
        try {
            r0 j10 = r0.j(getApplicationContext());
            this.f4679g = j10;
            u l10 = j10.l();
            this.f4682j = new p0(l10, this.f4679g.p());
            l10.e(this);
        } catch (IllegalStateException e10) {
            if (!Application.class.equals(getApplication().getClass())) {
                throw new IllegalStateException("WorkManager needs to be initialized via a ContentProvider#onCreate() or an Application#onCreate().", e10);
            }
            r3.m.e().k(f4678k, "Could not find WorkManager instance; this may be because an auto-backup is in progress. Ignoring JobScheduler commands for now. Please make sure that you are initializing WorkManager if you have manually disabled WorkManagerInitializer.");
        }
    }

    @Override // android.app.Service
    public void onDestroy() {
        super.onDestroy();
        r0 r0Var = this.f4679g;
        if (r0Var != null) {
            r0Var.l().p(this);
        }
    }

    @Override // android.app.job.JobService
    public boolean onStartJob(JobParameters jobParameters) {
        if (this.f4679g == null) {
            r3.m.e().a(f4678k, "WorkManager is not initialized; requesting retry.");
            jobFinished(jobParameters, true);
            return false;
        }
        w3.n b10 = b(jobParameters);
        if (b10 == null) {
            r3.m.e().c(f4678k, "WorkSpec id not found!");
            return false;
        }
        synchronized (this.f4680h) {
            if (this.f4680h.containsKey(b10)) {
                r3.m e10 = r3.m.e();
                String str = f4678k;
                e10.a(str, "Job is already being executed by SystemJobService: " + b10);
                return false;
            }
            r3.m e11 = r3.m.e();
            String str2 = f4678k;
            e11.a(str2, "onStartJob for " + b10);
            this.f4680h.put(b10, jobParameters);
            WorkerParameters.a aVar = null;
            int i10 = Build.VERSION.SDK_INT;
            if (i10 >= 24) {
                aVar = new WorkerParameters.a();
                if (a.b(jobParameters) != null) {
                    aVar.f4564b = Arrays.asList(a.b(jobParameters));
                }
                if (a.a(jobParameters) != null) {
                    aVar.f4563a = Arrays.asList(a.a(jobParameters));
                }
                if (i10 >= 28) {
                    aVar.f4565c = b.a(jobParameters);
                }
            }
            this.f4682j.a(this.f4681i.d(b10), aVar);
            return true;
        }
    }

    @Override // android.app.job.JobService
    public boolean onStopJob(JobParameters jobParameters) {
        if (this.f4679g == null) {
            r3.m.e().a(f4678k, "WorkManager is not initialized; requesting retry.");
            return true;
        }
        w3.n b10 = b(jobParameters);
        if (b10 == null) {
            r3.m.e().c(f4678k, "WorkSpec id not found!");
            return false;
        }
        r3.m e10 = r3.m.e();
        String str = f4678k;
        e10.a(str, "onStopJob for " + b10);
        synchronized (this.f4680h) {
            this.f4680h.remove(b10);
        }
        a0 b11 = this.f4681i.b(b10);
        if (b11 != null) {
            this.f4682j.d(b11, Build.VERSION.SDK_INT >= 31 ? c.a(jobParameters) : -512);
        }
        return !this.f4679g.l().j(b10.b());
    }
}
