package androidx.work.impl.background.systemalarm;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.PowerManager;
import android.text.TextUtils;
import androidx.work.impl.b0;
import androidx.work.impl.o0;
import androidx.work.impl.p0;
import androidx.work.impl.r0;
import androidx.work.impl.u;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import r3.m;
import w3.n;
import x3.c0;
import x3.w;
/* loaded from: classes.dex */
public class g implements androidx.work.impl.f {

    /* renamed from: r  reason: collision with root package name */
    static final String f4659r = m.i("SystemAlarmDispatcher");

    /* renamed from: g  reason: collision with root package name */
    final Context f4660g;

    /* renamed from: h  reason: collision with root package name */
    final y3.c f4661h;

    /* renamed from: i  reason: collision with root package name */
    private final c0 f4662i;

    /* renamed from: j  reason: collision with root package name */
    private final u f4663j;

    /* renamed from: k  reason: collision with root package name */
    private final r0 f4664k;

    /* renamed from: l  reason: collision with root package name */
    final androidx.work.impl.background.systemalarm.b f4665l;

    /* renamed from: m  reason: collision with root package name */
    final List f4666m;

    /* renamed from: n  reason: collision with root package name */
    Intent f4667n;

    /* renamed from: o  reason: collision with root package name */
    private c f4668o;

    /* renamed from: p  reason: collision with root package name */
    private b0 f4669p;

    /* renamed from: q  reason: collision with root package name */
    private final o0 f4670q;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            Executor b10;
            d dVar;
            synchronized (g.this.f4666m) {
                g gVar = g.this;
                gVar.f4667n = (Intent) gVar.f4666m.get(0);
            }
            Intent intent = g.this.f4667n;
            if (intent != null) {
                String action = intent.getAction();
                int intExtra = g.this.f4667n.getIntExtra("KEY_START_ID", 0);
                m e10 = m.e();
                String str = g.f4659r;
                e10.a(str, "Processing command " + g.this.f4667n + ", " + intExtra);
                Context context = g.this.f4660g;
                PowerManager.WakeLock b11 = w.b(context, action + " (" + intExtra + ")");
                try {
                    m e11 = m.e();
                    e11.a(str, "Acquiring operation wake lock (" + action + ") " + b11);
                    b11.acquire();
                    g gVar2 = g.this;
                    gVar2.f4665l.q(gVar2.f4667n, intExtra, gVar2);
                    m e12 = m.e();
                    e12.a(str, "Releasing operation wake lock (" + action + ") " + b11);
                    b11.release();
                    b10 = g.this.f4661h.b();
                    dVar = new d(g.this);
                } catch (Throwable th) {
                    try {
                        m e13 = m.e();
                        String str2 = g.f4659r;
                        e13.d(str2, "Unexpected error in onHandleIntent", th);
                        m e14 = m.e();
                        e14.a(str2, "Releasing operation wake lock (" + action + ") " + b11);
                        b11.release();
                        b10 = g.this.f4661h.b();
                        dVar = new d(g.this);
                    } catch (Throwable th2) {
                        m e15 = m.e();
                        String str3 = g.f4659r;
                        e15.a(str3, "Releasing operation wake lock (" + action + ") " + b11);
                        b11.release();
                        g.this.f4661h.b().execute(new d(g.this));
                        throw th2;
                    }
                }
                b10.execute(dVar);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class b implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        private final g f4672g;

        /* renamed from: h  reason: collision with root package name */
        private final Intent f4673h;

        /* renamed from: i  reason: collision with root package name */
        private final int f4674i;

        /* JADX INFO: Access modifiers changed from: package-private */
        public b(g gVar, Intent intent, int i10) {
            this.f4672g = gVar;
            this.f4673h = intent;
            this.f4674i = i10;
        }

        @Override // java.lang.Runnable
        public void run() {
            this.f4672g.a(this.f4673h, this.f4674i);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public interface c {
        void a();
    }

    /* loaded from: classes.dex */
    static class d implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        private final g f4675g;

        d(g gVar) {
            this.f4675g = gVar;
        }

        @Override // java.lang.Runnable
        public void run() {
            this.f4675g.c();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public g(Context context) {
        this(context, null, null, null);
    }

    g(Context context, u uVar, r0 r0Var, o0 o0Var) {
        Context applicationContext = context.getApplicationContext();
        this.f4660g = applicationContext;
        this.f4669p = new b0();
        r0Var = r0Var == null ? r0.j(context) : r0Var;
        this.f4664k = r0Var;
        this.f4665l = new androidx.work.impl.background.systemalarm.b(applicationContext, r0Var.h().a(), this.f4669p);
        this.f4662i = new c0(r0Var.h().k());
        uVar = uVar == null ? r0Var.l() : uVar;
        this.f4663j = uVar;
        y3.c p10 = r0Var.p();
        this.f4661h = p10;
        this.f4670q = o0Var == null ? new p0(uVar, p10) : o0Var;
        uVar.e(this);
        this.f4666m = new ArrayList();
        this.f4667n = null;
    }

    private void b() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Needs to be invoked on the main thread.");
        }
    }

    private boolean j(String str) {
        b();
        synchronized (this.f4666m) {
            for (Intent intent : this.f4666m) {
                if (str.equals(intent.getAction())) {
                    return true;
                }
            }
            return false;
        }
    }

    private void l() {
        b();
        PowerManager.WakeLock b10 = w.b(this.f4660g, "ProcessCommand");
        try {
            b10.acquire();
            this.f4664k.p().d(new a());
        } finally {
            b10.release();
        }
    }

    public boolean a(Intent intent, int i10) {
        m e10 = m.e();
        String str = f4659r;
        e10.a(str, "Adding command " + intent + " (" + i10 + ")");
        b();
        String action = intent.getAction();
        if (TextUtils.isEmpty(action)) {
            m.e().k(str, "Unknown command. Ignoring");
            return false;
        } else if ("ACTION_CONSTRAINTS_CHANGED".equals(action) && j("ACTION_CONSTRAINTS_CHANGED")) {
            return false;
        } else {
            intent.putExtra("KEY_START_ID", i10);
            synchronized (this.f4666m) {
                boolean z9 = this.f4666m.isEmpty() ? false : true;
                this.f4666m.add(intent);
                if (!z9) {
                    l();
                }
            }
            return true;
        }
    }

    void c() {
        m e10 = m.e();
        String str = f4659r;
        e10.a(str, "Checking if commands are complete.");
        b();
        synchronized (this.f4666m) {
            if (this.f4667n != null) {
                m e11 = m.e();
                e11.a(str, "Removing command " + this.f4667n);
                if (!((Intent) this.f4666m.remove(0)).equals(this.f4667n)) {
                    throw new IllegalStateException("Dequeue-d command is not the first.");
                }
                this.f4667n = null;
            }
            y3.a c10 = this.f4661h.c();
            if (!this.f4665l.p() && this.f4666m.isEmpty() && !c10.v()) {
                m.e().a(str, "No more commands & intents.");
                c cVar = this.f4668o;
                if (cVar != null) {
                    cVar.a();
                }
            } else if (!this.f4666m.isEmpty()) {
                l();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public u d() {
        return this.f4663j;
    }

    @Override // androidx.work.impl.f
    public void e(n nVar, boolean z9) {
        this.f4661h.b().execute(new b(this, androidx.work.impl.background.systemalarm.b.c(this.f4660g, nVar, z9), 0));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public y3.c f() {
        return this.f4661h;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public r0 g() {
        return this.f4664k;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public c0 h() {
        return this.f4662i;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public o0 i() {
        return this.f4670q;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void k() {
        m.e().a(f4659r, "Destroying SystemAlarmDispatcher");
        this.f4663j.p(this);
        this.f4668o = null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void m(c cVar) {
        if (this.f4668o != null) {
            m.e().c(f4659r, "A completion listener for SystemAlarmDispatcher already exists.");
        } else {
            this.f4668o = cVar;
        }
    }
}
