package androidx.work.impl.background.systemalarm;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.a0;
import androidx.work.impl.b0;
import androidx.work.impl.background.systemalarm.g;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import r3.m;
import w3.n;
import w3.w;
/* loaded from: classes.dex */
public class b implements androidx.work.impl.f {

    /* renamed from: l  reason: collision with root package name */
    private static final String f4630l = m.i("CommandHandler");

    /* renamed from: g  reason: collision with root package name */
    private final Context f4631g;

    /* renamed from: h  reason: collision with root package name */
    private final Map f4632h = new HashMap();

    /* renamed from: i  reason: collision with root package name */
    private final Object f4633i = new Object();

    /* renamed from: j  reason: collision with root package name */
    private final r3.b f4634j;

    /* renamed from: k  reason: collision with root package name */
    private final b0 f4635k;

    /* JADX INFO: Access modifiers changed from: package-private */
    public b(Context context, r3.b bVar, b0 b0Var) {
        this.f4631g = context;
        this.f4634j = bVar;
        this.f4635k = b0Var;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Intent a(Context context) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction("ACTION_CONSTRAINTS_CHANGED");
        return intent;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Intent b(Context context, n nVar) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction("ACTION_DELAY_MET");
        return s(intent, nVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Intent c(Context context, n nVar, boolean z9) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction("ACTION_EXECUTION_COMPLETED");
        intent.putExtra("KEY_NEEDS_RESCHEDULE", z9);
        return s(intent, nVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Intent d(Context context) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction("ACTION_RESCHEDULE");
        return intent;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Intent f(Context context, n nVar) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction("ACTION_SCHEDULE_WORK");
        return s(intent, nVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Intent g(Context context, String str) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction("ACTION_STOP_WORK");
        intent.putExtra("KEY_WORKSPEC_ID", str);
        return intent;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Intent h(Context context, n nVar) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction("ACTION_STOP_WORK");
        return s(intent, nVar);
    }

    private void i(Intent intent, int i10, g gVar) {
        m e10 = m.e();
        String str = f4630l;
        e10.a(str, "Handling constraints changed " + intent);
        new c(this.f4631g, this.f4634j, i10, gVar).a();
    }

    private void j(Intent intent, int i10, g gVar) {
        synchronized (this.f4633i) {
            n r10 = r(intent);
            m e10 = m.e();
            String str = f4630l;
            e10.a(str, "Handing delay met for " + r10);
            if (this.f4632h.containsKey(r10)) {
                m e11 = m.e();
                e11.a(str, "WorkSpec " + r10 + " is is already being handled for ACTION_DELAY_MET");
            } else {
                f fVar = new f(this.f4631g, i10, gVar, this.f4635k.d(r10));
                this.f4632h.put(r10, fVar);
                fVar.f();
            }
        }
    }

    private void k(Intent intent, int i10) {
        n r10 = r(intent);
        boolean z9 = intent.getExtras().getBoolean("KEY_NEEDS_RESCHEDULE");
        m e10 = m.e();
        String str = f4630l;
        e10.a(str, "Handling onExecutionCompleted " + intent + ", " + i10);
        e(r10, z9);
    }

    private void l(Intent intent, int i10, g gVar) {
        m e10 = m.e();
        String str = f4630l;
        e10.a(str, "Handling reschedule " + intent + ", " + i10);
        gVar.g().r();
    }

    private void m(Intent intent, int i10, g gVar) {
        n r10 = r(intent);
        m e10 = m.e();
        String str = f4630l;
        e10.a(str, "Handling schedule work for " + r10);
        WorkDatabase o10 = gVar.g().o();
        o10.e();
        try {
            w q10 = o10.H().q(r10.b());
            if (q10 == null) {
                m e11 = m.e();
                e11.k(str, "Skipping scheduling " + r10 + " because it's no longer in the DB");
            } else if (q10.f14801b.g()) {
                m e12 = m.e();
                e12.k(str, "Skipping scheduling " + r10 + "because it is finished.");
            } else {
                long c10 = q10.c();
                if (q10.k()) {
                    m e13 = m.e();
                    e13.a(str, "Opportunistically setting an alarm for " + r10 + "at " + c10);
                    a.c(this.f4631g, o10, r10, c10);
                    gVar.f().b().execute(new g.b(gVar, a(this.f4631g), i10));
                } else {
                    m e14 = m.e();
                    e14.a(str, "Setting up Alarms for " + r10 + "at " + c10);
                    a.c(this.f4631g, o10, r10, c10);
                }
                o10.A();
            }
        } finally {
            o10.i();
        }
    }

    private void n(Intent intent, g gVar) {
        List<a0> c10;
        Bundle extras = intent.getExtras();
        String string = extras.getString("KEY_WORKSPEC_ID");
        if (extras.containsKey("KEY_WORKSPEC_GENERATION")) {
            int i10 = extras.getInt("KEY_WORKSPEC_GENERATION");
            c10 = new ArrayList(1);
            a0 b10 = this.f4635k.b(new n(string, i10));
            if (b10 != null) {
                c10.add(b10);
            }
        } else {
            c10 = this.f4635k.c(string);
        }
        for (a0 a0Var : c10) {
            m e10 = m.e();
            String str = f4630l;
            e10.a(str, "Handing stopWork work for " + string);
            gVar.i().e(a0Var);
            a.a(this.f4631g, gVar.g().o(), a0Var.a());
            gVar.e(a0Var.a(), false);
        }
    }

    private static boolean o(Bundle bundle, String... strArr) {
        if (bundle == null || bundle.isEmpty()) {
            return false;
        }
        for (String str : strArr) {
            if (bundle.get(str) == null) {
                return false;
            }
        }
        return true;
    }

    static n r(Intent intent) {
        return new n(intent.getStringExtra("KEY_WORKSPEC_ID"), intent.getIntExtra("KEY_WORKSPEC_GENERATION", 0));
    }

    private static Intent s(Intent intent, n nVar) {
        intent.putExtra("KEY_WORKSPEC_ID", nVar.b());
        intent.putExtra("KEY_WORKSPEC_GENERATION", nVar.a());
        return intent;
    }

    @Override // androidx.work.impl.f
    public void e(n nVar, boolean z9) {
        synchronized (this.f4633i) {
            f fVar = (f) this.f4632h.remove(nVar);
            this.f4635k.b(nVar);
            if (fVar != null) {
                fVar.g(z9);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean p() {
        boolean z9;
        synchronized (this.f4633i) {
            z9 = !this.f4632h.isEmpty();
        }
        return z9;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void q(Intent intent, int i10, g gVar) {
        String action = intent.getAction();
        if ("ACTION_CONSTRAINTS_CHANGED".equals(action)) {
            i(intent, i10, gVar);
        } else if ("ACTION_RESCHEDULE".equals(action)) {
            l(intent, i10, gVar);
        } else if (!o(intent.getExtras(), "KEY_WORKSPEC_ID")) {
            m e10 = m.e();
            String str = f4630l;
            e10.c(str, "Invalid request for " + action + " , requires KEY_WORKSPEC_ID .");
        } else if ("ACTION_SCHEDULE_WORK".equals(action)) {
            m(intent, i10, gVar);
        } else if ("ACTION_DELAY_MET".equals(action)) {
            j(intent, i10, gVar);
        } else if ("ACTION_STOP_WORK".equals(action)) {
            n(intent, gVar);
        } else if ("ACTION_EXECUTION_COMPLETED".equals(action)) {
            k(intent, i10);
        } else {
            m e11 = m.e();
            String str2 = f4630l;
            e11.k(str2, "Ignoring intent " + intent);
        }
    }
}
