package androidx.work.impl;

import e3.k0;
import e3.m0;
import g3.d;
import i3.k;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
/* loaded from: classes.dex */
public final class WorkDatabase_Impl extends WorkDatabase {

    /* renamed from: q  reason: collision with root package name */
    private volatile w3.x f4607q;

    /* renamed from: r  reason: collision with root package name */
    private volatile w3.b f4608r;

    /* renamed from: s  reason: collision with root package name */
    private volatile w3.c0 f4609s;

    /* renamed from: t  reason: collision with root package name */
    private volatile w3.k f4610t;

    /* renamed from: u  reason: collision with root package name */
    private volatile w3.p f4611u;

    /* renamed from: v  reason: collision with root package name */
    private volatile w3.s f4612v;

    /* renamed from: w  reason: collision with root package name */
    private volatile w3.e f4613w;

    /* loaded from: classes.dex */
    class a extends m0.b {
        a(int i10) {
            super(i10);
        }

        @Override // e3.m0.b
        public void a(i3.j jVar) {
            jVar.f("CREATE TABLE IF NOT EXISTS `Dependency` (`work_spec_id` TEXT NOT NULL, `prerequisite_id` TEXT NOT NULL, PRIMARY KEY(`work_spec_id`, `prerequisite_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE , FOREIGN KEY(`prerequisite_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
            jVar.f("CREATE INDEX IF NOT EXISTS `index_Dependency_work_spec_id` ON `Dependency` (`work_spec_id`)");
            jVar.f("CREATE INDEX IF NOT EXISTS `index_Dependency_prerequisite_id` ON `Dependency` (`prerequisite_id`)");
            jVar.f("CREATE TABLE IF NOT EXISTS `WorkSpec` (`id` TEXT NOT NULL, `state` INTEGER NOT NULL, `worker_class_name` TEXT NOT NULL, `input_merger_class_name` TEXT NOT NULL, `input` BLOB NOT NULL, `output` BLOB NOT NULL, `initial_delay` INTEGER NOT NULL, `interval_duration` INTEGER NOT NULL, `flex_duration` INTEGER NOT NULL, `run_attempt_count` INTEGER NOT NULL, `backoff_policy` INTEGER NOT NULL, `backoff_delay_duration` INTEGER NOT NULL, `last_enqueue_time` INTEGER NOT NULL DEFAULT -1, `minimum_retention_duration` INTEGER NOT NULL, `schedule_requested_at` INTEGER NOT NULL, `run_in_foreground` INTEGER NOT NULL, `out_of_quota_policy` INTEGER NOT NULL, `period_count` INTEGER NOT NULL DEFAULT 0, `generation` INTEGER NOT NULL DEFAULT 0, `next_schedule_time_override` INTEGER NOT NULL DEFAULT 9223372036854775807, `next_schedule_time_override_generation` INTEGER NOT NULL DEFAULT 0, `stop_reason` INTEGER NOT NULL DEFAULT -256, `required_network_type` INTEGER NOT NULL, `requires_charging` INTEGER NOT NULL, `requires_device_idle` INTEGER NOT NULL, `requires_battery_not_low` INTEGER NOT NULL, `requires_storage_not_low` INTEGER NOT NULL, `trigger_content_update_delay` INTEGER NOT NULL, `trigger_max_content_delay` INTEGER NOT NULL, `content_uri_triggers` BLOB NOT NULL, PRIMARY KEY(`id`))");
            jVar.f("CREATE INDEX IF NOT EXISTS `index_WorkSpec_schedule_requested_at` ON `WorkSpec` (`schedule_requested_at`)");
            jVar.f("CREATE INDEX IF NOT EXISTS `index_WorkSpec_last_enqueue_time` ON `WorkSpec` (`last_enqueue_time`)");
            jVar.f("CREATE TABLE IF NOT EXISTS `WorkTag` (`tag` TEXT NOT NULL, `work_spec_id` TEXT NOT NULL, PRIMARY KEY(`tag`, `work_spec_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
            jVar.f("CREATE INDEX IF NOT EXISTS `index_WorkTag_work_spec_id` ON `WorkTag` (`work_spec_id`)");
            jVar.f("CREATE TABLE IF NOT EXISTS `SystemIdInfo` (`work_spec_id` TEXT NOT NULL, `generation` INTEGER NOT NULL DEFAULT 0, `system_id` INTEGER NOT NULL, PRIMARY KEY(`work_spec_id`, `generation`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
            jVar.f("CREATE TABLE IF NOT EXISTS `WorkName` (`name` TEXT NOT NULL, `work_spec_id` TEXT NOT NULL, PRIMARY KEY(`name`, `work_spec_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
            jVar.f("CREATE INDEX IF NOT EXISTS `index_WorkName_work_spec_id` ON `WorkName` (`work_spec_id`)");
            jVar.f("CREATE TABLE IF NOT EXISTS `WorkProgress` (`work_spec_id` TEXT NOT NULL, `progress` BLOB NOT NULL, PRIMARY KEY(`work_spec_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
            jVar.f("CREATE TABLE IF NOT EXISTS `Preference` (`key` TEXT NOT NULL, `long_value` INTEGER, PRIMARY KEY(`key`))");
            jVar.f("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
            jVar.f("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '7d73d21f1bd82c9e5268b6dcf9fde2cb')");
        }

        @Override // e3.m0.b
        public void b(i3.j jVar) {
            jVar.f("DROP TABLE IF EXISTS `Dependency`");
            jVar.f("DROP TABLE IF EXISTS `WorkSpec`");
            jVar.f("DROP TABLE IF EXISTS `WorkTag`");
            jVar.f("DROP TABLE IF EXISTS `SystemIdInfo`");
            jVar.f("DROP TABLE IF EXISTS `WorkName`");
            jVar.f("DROP TABLE IF EXISTS `WorkProgress`");
            jVar.f("DROP TABLE IF EXISTS `Preference`");
            if (((e3.k0) WorkDatabase_Impl.this).f7281h != null) {
                int size = ((e3.k0) WorkDatabase_Impl.this).f7281h.size();
                for (int i10 = 0; i10 < size; i10++) {
                    ((k0.b) ((e3.k0) WorkDatabase_Impl.this).f7281h.get(i10)).b(jVar);
                }
            }
        }

        @Override // e3.m0.b
        public void c(i3.j jVar) {
            if (((e3.k0) WorkDatabase_Impl.this).f7281h != null) {
                int size = ((e3.k0) WorkDatabase_Impl.this).f7281h.size();
                for (int i10 = 0; i10 < size; i10++) {
                    ((k0.b) ((e3.k0) WorkDatabase_Impl.this).f7281h.get(i10)).a(jVar);
                }
            }
        }

        @Override // e3.m0.b
        public void d(i3.j jVar) {
            ((e3.k0) WorkDatabase_Impl.this).f7274a = jVar;
            jVar.f("PRAGMA foreign_keys = ON");
            WorkDatabase_Impl.this.u(jVar);
            if (((e3.k0) WorkDatabase_Impl.this).f7281h != null) {
                int size = ((e3.k0) WorkDatabase_Impl.this).f7281h.size();
                for (int i10 = 0; i10 < size; i10++) {
                    ((k0.b) ((e3.k0) WorkDatabase_Impl.this).f7281h.get(i10)).c(jVar);
                }
            }
        }

        @Override // e3.m0.b
        public void e(i3.j jVar) {
        }

        @Override // e3.m0.b
        public void f(i3.j jVar) {
            g3.b.a(jVar);
        }

        @Override // e3.m0.b
        public m0.c g(i3.j jVar) {
            HashMap hashMap = new HashMap(2);
            hashMap.put("work_spec_id", new d.a("work_spec_id", "TEXT", true, 1, null, 1));
            hashMap.put("prerequisite_id", new d.a("prerequisite_id", "TEXT", true, 2, null, 1));
            HashSet hashSet = new HashSet(2);
            hashSet.add(new d.c("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("work_spec_id"), Arrays.asList("id")));
            hashSet.add(new d.c("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("prerequisite_id"), Arrays.asList("id")));
            HashSet hashSet2 = new HashSet(2);
            hashSet2.add(new d.e("index_Dependency_work_spec_id", false, Arrays.asList("work_spec_id"), Arrays.asList("ASC")));
            hashSet2.add(new d.e("index_Dependency_prerequisite_id", false, Arrays.asList("prerequisite_id"), Arrays.asList("ASC")));
            g3.d dVar = new g3.d("Dependency", hashMap, hashSet, hashSet2);
            g3.d a10 = g3.d.a(jVar, "Dependency");
            if (!dVar.equals(a10)) {
                return new m0.c(false, "Dependency(androidx.work.impl.model.Dependency).\n Expected:\n" + dVar + "\n Found:\n" + a10);
            }
            HashMap hashMap2 = new HashMap(30);
            hashMap2.put("id", new d.a("id", "TEXT", true, 1, null, 1));
            hashMap2.put("state", new d.a("state", "INTEGER", true, 0, null, 1));
            hashMap2.put("worker_class_name", new d.a("worker_class_name", "TEXT", true, 0, null, 1));
            hashMap2.put("input_merger_class_name", new d.a("input_merger_class_name", "TEXT", true, 0, null, 1));
            hashMap2.put("input", new d.a("input", "BLOB", true, 0, null, 1));
            hashMap2.put("output", new d.a("output", "BLOB", true, 0, null, 1));
            hashMap2.put("initial_delay", new d.a("initial_delay", "INTEGER", true, 0, null, 1));
            hashMap2.put("interval_duration", new d.a("interval_duration", "INTEGER", true, 0, null, 1));
            hashMap2.put("flex_duration", new d.a("flex_duration", "INTEGER", true, 0, null, 1));
            hashMap2.put("run_attempt_count", new d.a("run_attempt_count", "INTEGER", true, 0, null, 1));
            hashMap2.put("backoff_policy", new d.a("backoff_policy", "INTEGER", true, 0, null, 1));
            hashMap2.put("backoff_delay_duration", new d.a("backoff_delay_duration", "INTEGER", true, 0, null, 1));
            hashMap2.put("last_enqueue_time", new d.a("last_enqueue_time", "INTEGER", true, 0, "-1", 1));
            hashMap2.put("minimum_retention_duration", new d.a("minimum_retention_duration", "INTEGER", true, 0, null, 1));
            hashMap2.put("schedule_requested_at", new d.a("schedule_requested_at", "INTEGER", true, 0, null, 1));
            hashMap2.put("run_in_foreground", new d.a("run_in_foreground", "INTEGER", true, 0, null, 1));
            hashMap2.put("out_of_quota_policy", new d.a("out_of_quota_policy", "INTEGER", true, 0, null, 1));
            hashMap2.put("period_count", new d.a("period_count", "INTEGER", true, 0, "0", 1));
            hashMap2.put("generation", new d.a("generation", "INTEGER", true, 0, "0", 1));
            hashMap2.put("next_schedule_time_override", new d.a("next_schedule_time_override", "INTEGER", true, 0, "9223372036854775807", 1));
            hashMap2.put("next_schedule_time_override_generation", new d.a("next_schedule_time_override_generation", "INTEGER", true, 0, "0", 1));
            hashMap2.put("stop_reason", new d.a("stop_reason", "INTEGER", true, 0, "-256", 1));
            hashMap2.put("required_network_type", new d.a("required_network_type", "INTEGER", true, 0, null, 1));
            hashMap2.put("requires_charging", new d.a("requires_charging", "INTEGER", true, 0, null, 1));
            hashMap2.put("requires_device_idle", new d.a("requires_device_idle", "INTEGER", true, 0, null, 1));
            hashMap2.put("requires_battery_not_low", new d.a("requires_battery_not_low", "INTEGER", true, 0, null, 1));
            hashMap2.put("requires_storage_not_low", new d.a("requires_storage_not_low", "INTEGER", true, 0, null, 1));
            hashMap2.put("trigger_content_update_delay", new d.a("trigger_content_update_delay", "INTEGER", true, 0, null, 1));
            hashMap2.put("trigger_max_content_delay", new d.a("trigger_max_content_delay", "INTEGER", true, 0, null, 1));
            hashMap2.put("content_uri_triggers", new d.a("content_uri_triggers", "BLOB", true, 0, null, 1));
            HashSet hashSet3 = new HashSet(0);
            HashSet hashSet4 = new HashSet(2);
            hashSet4.add(new d.e("index_WorkSpec_schedule_requested_at", false, Arrays.asList("schedule_requested_at"), Arrays.asList("ASC")));
            hashSet4.add(new d.e("index_WorkSpec_last_enqueue_time", false, Arrays.asList("last_enqueue_time"), Arrays.asList("ASC")));
            g3.d dVar2 = new g3.d("WorkSpec", hashMap2, hashSet3, hashSet4);
            g3.d a11 = g3.d.a(jVar, "WorkSpec");
            if (!dVar2.equals(a11)) {
                return new m0.c(false, "WorkSpec(androidx.work.impl.model.WorkSpec).\n Expected:\n" + dVar2 + "\n Found:\n" + a11);
            }
            HashMap hashMap3 = new HashMap(2);
            hashMap3.put("tag", new d.a("tag", "TEXT", true, 1, null, 1));
            hashMap3.put("work_spec_id", new d.a("work_spec_id", "TEXT", true, 2, null, 1));
            HashSet hashSet5 = new HashSet(1);
            hashSet5.add(new d.c("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("work_spec_id"), Arrays.asList("id")));
            HashSet hashSet6 = new HashSet(1);
            hashSet6.add(new d.e("index_WorkTag_work_spec_id", false, Arrays.asList("work_spec_id"), Arrays.asList("ASC")));
            g3.d dVar3 = new g3.d("WorkTag", hashMap3, hashSet5, hashSet6);
            g3.d a12 = g3.d.a(jVar, "WorkTag");
            if (!dVar3.equals(a12)) {
                return new m0.c(false, "WorkTag(androidx.work.impl.model.WorkTag).\n Expected:\n" + dVar3 + "\n Found:\n" + a12);
            }
            HashMap hashMap4 = new HashMap(3);
            hashMap4.put("work_spec_id", new d.a("work_spec_id", "TEXT", true, 1, null, 1));
            hashMap4.put("generation", new d.a("generation", "INTEGER", true, 2, "0", 1));
            hashMap4.put("system_id", new d.a("system_id", "INTEGER", true, 0, null, 1));
            HashSet hashSet7 = new HashSet(1);
            hashSet7.add(new d.c("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("work_spec_id"), Arrays.asList("id")));
            g3.d dVar4 = new g3.d("SystemIdInfo", hashMap4, hashSet7, new HashSet(0));
            g3.d a13 = g3.d.a(jVar, "SystemIdInfo");
            if (!dVar4.equals(a13)) {
                return new m0.c(false, "SystemIdInfo(androidx.work.impl.model.SystemIdInfo).\n Expected:\n" + dVar4 + "\n Found:\n" + a13);
            }
            HashMap hashMap5 = new HashMap(2);
            hashMap5.put("name", new d.a("name", "TEXT", true, 1, null, 1));
            hashMap5.put("work_spec_id", new d.a("work_spec_id", "TEXT", true, 2, null, 1));
            HashSet hashSet8 = new HashSet(1);
            hashSet8.add(new d.c("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("work_spec_id"), Arrays.asList("id")));
            HashSet hashSet9 = new HashSet(1);
            hashSet9.add(new d.e("index_WorkName_work_spec_id", false, Arrays.asList("work_spec_id"), Arrays.asList("ASC")));
            g3.d dVar5 = new g3.d("WorkName", hashMap5, hashSet8, hashSet9);
            g3.d a14 = g3.d.a(jVar, "WorkName");
            if (!dVar5.equals(a14)) {
                return new m0.c(false, "WorkName(androidx.work.impl.model.WorkName).\n Expected:\n" + dVar5 + "\n Found:\n" + a14);
            }
            HashMap hashMap6 = new HashMap(2);
            hashMap6.put("work_spec_id", new d.a("work_spec_id", "TEXT", true, 1, null, 1));
            hashMap6.put("progress", new d.a("progress", "BLOB", true, 0, null, 1));
            HashSet hashSet10 = new HashSet(1);
            hashSet10.add(new d.c("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("work_spec_id"), Arrays.asList("id")));
            g3.d dVar6 = new g3.d("WorkProgress", hashMap6, hashSet10, new HashSet(0));
            g3.d a15 = g3.d.a(jVar, "WorkProgress");
            if (!dVar6.equals(a15)) {
                return new m0.c(false, "WorkProgress(androidx.work.impl.model.WorkProgress).\n Expected:\n" + dVar6 + "\n Found:\n" + a15);
            }
            HashMap hashMap7 = new HashMap(2);
            hashMap7.put("key", new d.a("key", "TEXT", true, 1, null, 1));
            hashMap7.put("long_value", new d.a("long_value", "INTEGER", false, 0, null, 1));
            g3.d dVar7 = new g3.d("Preference", hashMap7, new HashSet(0), new HashSet(0));
            g3.d a16 = g3.d.a(jVar, "Preference");
            if (dVar7.equals(a16)) {
                return new m0.c(true, null);
            }
            return new m0.c(false, "Preference(androidx.work.impl.model.Preference).\n Expected:\n" + dVar7 + "\n Found:\n" + a16);
        }
    }

    @Override // androidx.work.impl.WorkDatabase
    public w3.b C() {
        w3.b bVar;
        if (this.f4608r != null) {
            return this.f4608r;
        }
        synchronized (this) {
            if (this.f4608r == null) {
                this.f4608r = new w3.c(this);
            }
            bVar = this.f4608r;
        }
        return bVar;
    }

    @Override // androidx.work.impl.WorkDatabase
    public w3.e D() {
        w3.e eVar;
        if (this.f4613w != null) {
            return this.f4613w;
        }
        synchronized (this) {
            if (this.f4613w == null) {
                this.f4613w = new w3.f(this);
            }
            eVar = this.f4613w;
        }
        return eVar;
    }

    @Override // androidx.work.impl.WorkDatabase
    public w3.k E() {
        w3.k kVar;
        if (this.f4610t != null) {
            return this.f4610t;
        }
        synchronized (this) {
            if (this.f4610t == null) {
                this.f4610t = new w3.l(this);
            }
            kVar = this.f4610t;
        }
        return kVar;
    }

    @Override // androidx.work.impl.WorkDatabase
    public w3.p F() {
        w3.p pVar;
        if (this.f4611u != null) {
            return this.f4611u;
        }
        synchronized (this) {
            if (this.f4611u == null) {
                this.f4611u = new w3.q(this);
            }
            pVar = this.f4611u;
        }
        return pVar;
    }

    @Override // androidx.work.impl.WorkDatabase
    public w3.s G() {
        w3.s sVar;
        if (this.f4612v != null) {
            return this.f4612v;
        }
        synchronized (this) {
            if (this.f4612v == null) {
                this.f4612v = new w3.t(this);
            }
            sVar = this.f4612v;
        }
        return sVar;
    }

    @Override // androidx.work.impl.WorkDatabase
    public w3.x H() {
        w3.x xVar;
        if (this.f4607q != null) {
            return this.f4607q;
        }
        synchronized (this) {
            if (this.f4607q == null) {
                this.f4607q = new w3.y(this);
            }
            xVar = this.f4607q;
        }
        return xVar;
    }

    @Override // androidx.work.impl.WorkDatabase
    public w3.c0 I() {
        w3.c0 c0Var;
        if (this.f4609s != null) {
            return this.f4609s;
        }
        synchronized (this) {
            if (this.f4609s == null) {
                this.f4609s = new w3.d0(this);
            }
            c0Var = this.f4609s;
        }
        return c0Var;
    }

    @Override // e3.k0
    protected e3.o g() {
        return new e3.o(this, new HashMap(0), new HashMap(0), "Dependency", "WorkSpec", "WorkTag", "SystemIdInfo", "WorkName", "WorkProgress", "Preference");
    }

    @Override // e3.k0
    protected i3.k h(e3.f fVar) {
        return fVar.f7245c.a(k.b.a(fVar.f7243a).d(fVar.f7244b).c(new e3.m0(fVar, new a(20), "7d73d21f1bd82c9e5268b6dcf9fde2cb", "3071c8717539de5d5353f4c8cd59a032")).b());
    }

    @Override // e3.k0
    public List j(Map map) {
        return Arrays.asList(new h0(), new i0(), new j0(), new k0(), new l0(), new m0());
    }

    @Override // e3.k0
    public Set o() {
        return new HashSet();
    }

    @Override // e3.k0
    protected Map p() {
        HashMap hashMap = new HashMap();
        hashMap.put(w3.x.class, w3.y.B());
        hashMap.put(w3.b.class, w3.c.e());
        hashMap.put(w3.c0.class, w3.d0.d());
        hashMap.put(w3.k.class, w3.l.h());
        hashMap.put(w3.p.class, w3.q.c());
        hashMap.put(w3.s.class, w3.t.c());
        hashMap.put(w3.e.class, w3.f.c());
        hashMap.put(w3.g.class, w3.h.a());
        return hashMap;
    }
}
