package androidx.window.java.layout;

import android.app.Activity;
import androidx.window.layout.WindowInfoTracker;
import c9.e;
import g8.q;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.jvm.internal.k;
import v.a;
import z8.g1;
import z8.i;
import z8.i0;
import z8.j0;
import z8.o1;
/* loaded from: classes.dex */
public final class WindowInfoTrackerCallbackAdapter implements WindowInfoTracker {
    private final Map<a, o1> consumerToJobMap;
    private final ReentrantLock lock;
    private final WindowInfoTracker tracker;

    public WindowInfoTrackerCallbackAdapter(WindowInfoTracker tracker) {
        k.e(tracker, "tracker");
        this.tracker = tracker;
        this.lock = new ReentrantLock();
        this.consumerToJobMap = new LinkedHashMap();
    }

    private final <T> void addListener(Executor executor, a aVar, e eVar) {
        o1 b10;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (this.consumerToJobMap.get(aVar) == null) {
                i0 a10 = j0.a(g1.a(executor));
                Map<a, o1> map = this.consumerToJobMap;
                b10 = i.b(a10, null, null, new WindowInfoTrackerCallbackAdapter$addListener$1$1(eVar, aVar, null), 3, null);
                map.put(aVar, b10);
            }
            q qVar = q.f8031a;
        } finally {
            reentrantLock.unlock();
        }
    }

    private final void removeListener(a aVar) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            o1 o1Var = this.consumerToJobMap.get(aVar);
            if (o1Var != null) {
                o1.a.a(o1Var, null, 1, null);
            }
            this.consumerToJobMap.remove(aVar);
        } finally {
            reentrantLock.unlock();
        }
    }

    public final void addWindowLayoutInfoListener(Activity activity, Executor executor, a consumer) {
        k.e(activity, "activity");
        k.e(executor, "executor");
        k.e(consumer, "consumer");
        addListener(executor, consumer, this.tracker.windowLayoutInfo(activity));
    }

    public final void removeWindowLayoutInfoListener(a consumer) {
        k.e(consumer, "consumer");
        removeListener(consumer);
    }

    @Override // androidx.window.layout.WindowInfoTracker
    public e windowLayoutInfo(Activity activity) {
        k.e(activity, "activity");
        return this.tracker.windowLayoutInfo(activity);
    }
}
