package androidx.window.embedding;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import androidx.window.R;
import androidx.window.core.ExperimentalWindowApi;
import h8.m0;
import java.util.HashSet;
import java.util.Set;
import kotlin.jvm.internal.k;
import y8.n;
@ExperimentalWindowApi
/* loaded from: classes.dex */
public final class SplitRuleParser {
    private final ComponentName buildClassName(String str, CharSequence charSequence) {
        int C;
        int C2;
        if (charSequence != null) {
            if (!(charSequence.length() == 0)) {
                String obj = charSequence.toString();
                if (obj.charAt(0) == '.') {
                    return new ComponentName(str, k.j(str, obj));
                }
                C = n.C(obj, '/', 0, false, 6, null);
                if (C > 0) {
                    str = obj.substring(0, C);
                    k.d(str, "(this as java.lang.Strin…ing(startIndex, endIndex)");
                    obj = obj.substring(C + 1);
                    k.d(obj, "(this as java.lang.String).substring(startIndex)");
                }
                if (!k.a(obj, "*")) {
                    C2 = n.C(obj, '.', 0, false, 6, null);
                    if (C2 < 0) {
                        return new ComponentName(str, str + '.' + obj);
                    }
                }
                return new ComponentName(str, obj);
            }
        }
        throw new IllegalArgumentException("Activity name must not be null");
    }

    private final ActivityFilter parseActivityFilter(Context context, XmlResourceParser xmlResourceParser) {
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(xmlResourceParser, R.styleable.ActivityFilter, 0, 0);
        String string = obtainStyledAttributes.getString(R.styleable.ActivityFilter_activityName);
        String string2 = obtainStyledAttributes.getString(R.styleable.ActivityFilter_activityAction);
        String packageName = context.getApplicationContext().getPackageName();
        k.d(packageName, "packageName");
        return new ActivityFilter(buildClassName(packageName, string), string2);
    }

    private final ActivityRule parseSplitActivityRule(Context context, XmlResourceParser xmlResourceParser) {
        Set d10;
        boolean z9 = context.getTheme().obtainStyledAttributes(xmlResourceParser, R.styleable.ActivityRule, 0, 0).getBoolean(R.styleable.ActivityRule_alwaysExpand, false);
        d10 = m0.d();
        return new ActivityRule(d10, z9);
    }

    private final SplitPairFilter parseSplitPairFilter(Context context, XmlResourceParser xmlResourceParser) {
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(xmlResourceParser, R.styleable.SplitPairFilter, 0, 0);
        String string = obtainStyledAttributes.getString(R.styleable.SplitPairFilter_primaryActivityName);
        String string2 = obtainStyledAttributes.getString(R.styleable.SplitPairFilter_secondaryActivityName);
        String string3 = obtainStyledAttributes.getString(R.styleable.SplitPairFilter_secondaryActivityAction);
        String packageName = context.getApplicationContext().getPackageName();
        k.d(packageName, "packageName");
        return new SplitPairFilter(buildClassName(packageName, string), buildClassName(packageName, string2), string3);
    }

    private final SplitPairRule parseSplitPairRule(Context context, XmlResourceParser xmlResourceParser) {
        Set d10;
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(xmlResourceParser, R.styleable.SplitPairRule, 0, 0);
        float f10 = obtainStyledAttributes.getFloat(R.styleable.SplitPairRule_splitRatio, 0.0f);
        int dimension = (int) obtainStyledAttributes.getDimension(R.styleable.SplitPairRule_splitMinWidth, 0.0f);
        int dimension2 = (int) obtainStyledAttributes.getDimension(R.styleable.SplitPairRule_splitMinSmallestWidth, 0.0f);
        int i10 = obtainStyledAttributes.getInt(R.styleable.SplitPairRule_splitLayoutDirection, 3);
        boolean z9 = obtainStyledAttributes.getBoolean(R.styleable.SplitPairRule_finishPrimaryWithSecondary, false);
        boolean z10 = obtainStyledAttributes.getBoolean(R.styleable.SplitPairRule_finishSecondaryWithPrimary, true);
        boolean z11 = obtainStyledAttributes.getBoolean(R.styleable.SplitPairRule_clearTop, false);
        d10 = m0.d();
        return new SplitPairRule(d10, z9, z10, z11, dimension, dimension2, f10, i10);
    }

    private final SplitPlaceholderRule parseSplitPlaceholderRule(Context context, XmlResourceParser xmlResourceParser) {
        Set d10;
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(xmlResourceParser, R.styleable.SplitPlaceholderRule, 0, 0);
        String string = obtainStyledAttributes.getString(R.styleable.SplitPlaceholderRule_placeholderActivityName);
        float f10 = obtainStyledAttributes.getFloat(R.styleable.SplitPlaceholderRule_splitRatio, 0.0f);
        int dimension = (int) obtainStyledAttributes.getDimension(R.styleable.SplitPlaceholderRule_splitMinWidth, 0.0f);
        int dimension2 = (int) obtainStyledAttributes.getDimension(R.styleable.SplitPlaceholderRule_splitMinSmallestWidth, 0.0f);
        int i10 = obtainStyledAttributes.getInt(R.styleable.SplitPlaceholderRule_splitLayoutDirection, 3);
        String packageName = context.getApplicationContext().getPackageName();
        k.d(packageName, "packageName");
        ComponentName buildClassName = buildClassName(packageName, string);
        d10 = m0.d();
        Intent component = new Intent().setComponent(buildClassName);
        k.d(component, "Intent().setComponent(pl…eholderActivityClassName)");
        return new SplitPlaceholderRule(d10, component, dimension, dimension2, f10, i10);
    }

    /* JADX WARN: Code restructure failed: missing block: B:72:0x00e5, code lost:
        continue;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private final Set<EmbeddingRule> parseSplitXml(Context context, int i10) {
        String name;
        SplitPlaceholderRule plus$window_release;
        ActivityRule plus$window_release2;
        SplitPairRule parseSplitPairRule;
        try {
            XmlResourceParser xml = context.getResources().getXml(i10);
            k.d(xml, "resources.getXml(splitResourceId)");
            HashSet hashSet = new HashSet();
            int depth = xml.getDepth();
            ActivityRule activityRule = null;
            SplitPairRule splitPairRule = null;
            SplitPlaceholderRule splitPlaceholderRule = null;
            for (int next = xml.next(); next != 1 && (next != 3 || xml.getDepth() > depth); next = xml.next()) {
                if (xml.getEventType() == 2 && !k.a("split-config", xml.getName()) && (name = xml.getName()) != null) {
                    switch (name.hashCode()) {
                        case 511422343:
                            if (!name.equals("ActivityFilter")) {
                                continue;
                            } else if (activityRule != null || splitPlaceholderRule != null) {
                                ActivityFilter parseActivityFilter = parseActivityFilter(context, xml);
                                if (activityRule != null) {
                                    hashSet.remove(activityRule);
                                    plus$window_release2 = activityRule.plus$window_release(parseActivityFilter);
                                    hashSet.add(plus$window_release2);
                                    activityRule = plus$window_release2;
                                    break;
                                } else if (splitPlaceholderRule != null) {
                                    hashSet.remove(splitPlaceholderRule);
                                    plus$window_release = splitPlaceholderRule.plus$window_release(parseActivityFilter);
                                    hashSet.add(plus$window_release);
                                    splitPlaceholderRule = plus$window_release;
                                    break;
                                } else {
                                    break;
                                }
                            } else {
                                throw new IllegalArgumentException("Found orphaned ActivityFilter");
                            }
                        case 520447504:
                            if (name.equals("SplitPairRule")) {
                                parseSplitPairRule = parseSplitPairRule(context, xml);
                                hashSet.add(parseSplitPairRule);
                                activityRule = null;
                                splitPlaceholderRule = null;
                                splitPairRule = parseSplitPairRule;
                                break;
                            } else {
                                break;
                            }
                        case 1579230604:
                            if (!name.equals("SplitPairFilter")) {
                                continue;
                            } else if (splitPairRule != null) {
                                SplitPairFilter parseSplitPairFilter = parseSplitPairFilter(context, xml);
                                hashSet.remove(splitPairRule);
                                parseSplitPairRule = splitPairRule.plus$window_release(parseSplitPairFilter);
                                hashSet.add(parseSplitPairRule);
                                splitPairRule = parseSplitPairRule;
                                break;
                            } else {
                                throw new IllegalArgumentException("Found orphaned SplitPairFilter outside of SplitPairRule");
                            }
                        case 1793077963:
                            if (name.equals("ActivityRule")) {
                                plus$window_release2 = parseSplitActivityRule(context, xml);
                                hashSet.add(plus$window_release2);
                                splitPairRule = null;
                                splitPlaceholderRule = null;
                                activityRule = plus$window_release2;
                                break;
                            } else {
                                break;
                            }
                        case 2050988213:
                            if (name.equals("SplitPlaceholderRule")) {
                                plus$window_release = parseSplitPlaceholderRule(context, xml);
                                hashSet.add(plus$window_release);
                                activityRule = null;
                                splitPairRule = null;
                                splitPlaceholderRule = plus$window_release;
                                break;
                            } else {
                                break;
                            }
                    }
                }
            }
            return hashSet;
        } catch (Resources.NotFoundException unused) {
            return null;
        }
    }

    public final Set<EmbeddingRule> parseSplitRules$window_release(Context context, int i10) {
        k.e(context, "context");
        return parseSplitXml(context, i10);
    }
}
