package androidx.window.embedding;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import androidx.window.core.ExperimentalWindowApi;
import kotlin.jvm.internal.k;
import y8.n;
@ExperimentalWindowApi
/* loaded from: classes.dex */
public final class SplitPairFilter {
    private final ComponentName primaryActivityName;
    private final String secondaryActivityIntentAction;
    private final ComponentName secondaryActivityName;

    /* JADX WARN: Removed duplicated region for block: B:15:0x005d  */
    /* JADX WARN: Removed duplicated region for block: B:28:0x0078  */
    /* JADX WARN: Removed duplicated region for block: B:37:0x009d  */
    /* JADX WARN: Removed duplicated region for block: B:47:0x00cd  */
    /* JADX WARN: Removed duplicated region for block: B:55:0x00ec  */
    /* JADX WARN: Removed duplicated region for block: B:65:0x0115  */
    /* JADX WARN: Removed duplicated region for block: B:67:0x011f  */
    /* JADX WARN: Removed duplicated region for block: B:69:0x0129  */
    /* JADX WARN: Removed duplicated region for block: B:71:0x0133  */
    /* JADX WARN: Removed duplicated region for block: B:73:0x013f  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public SplitPairFilter(ComponentName primaryActivityName, ComponentName secondaryActivityName, String str) {
        boolean z9;
        boolean z10;
        boolean u9;
        boolean z11;
        boolean u10;
        Object obj;
        CharSequence charSequence;
        String str2;
        boolean z12;
        int i10;
        boolean z13;
        boolean u11;
        boolean z14;
        boolean u12;
        int D;
        int D2;
        int D3;
        int D4;
        k.e(primaryActivityName, "primaryActivityName");
        k.e(secondaryActivityName, "secondaryActivityName");
        this.primaryActivityName = primaryActivityName;
        this.secondaryActivityName = secondaryActivityName;
        this.secondaryActivityIntentAction = str;
        String packageName = primaryActivityName.getPackageName();
        k.d(packageName, "primaryActivityName.packageName");
        String className = primaryActivityName.getClassName();
        k.d(className, "primaryActivityName.className");
        String packageName2 = secondaryActivityName.getPackageName();
        k.d(packageName2, "secondaryActivityName.packageName");
        String className2 = secondaryActivityName.getClassName();
        k.d(className2, "secondaryActivityName.className");
        boolean z15 = true;
        if (!(packageName.length() == 0)) {
            if (!(packageName2.length() == 0)) {
                z9 = true;
                if (z9) {
                    throw new IllegalArgumentException("Package name must not be empty".toString());
                }
                if (!(className.length() == 0)) {
                    if (!(className2.length() == 0)) {
                        z10 = true;
                        if (z10) {
                            throw new IllegalArgumentException("Activity class name must not be empty.".toString());
                        }
                        u9 = n.u(packageName, "*", false, 2, null);
                        if (u9) {
                            D4 = n.D(packageName, "*", 0, false, 6, null);
                            if (D4 != packageName.length() - 1) {
                                z11 = false;
                                if (z11) {
                                    throw new IllegalArgumentException("Wildcard in package name is only allowed at the end.".toString());
                                }
                                u10 = n.u(className, "*", false, 2, null);
                                if (u10) {
                                    obj = null;
                                    i10 = 2;
                                    charSequence = "*";
                                    z12 = false;
                                    str2 = className2;
                                    D3 = n.D(className, "*", 0, false, 6, null);
                                    if (D3 != className.length() - 1) {
                                        z13 = false;
                                        if (z13) {
                                            throw new IllegalArgumentException("Wildcard in class name is only allowed at the end.".toString());
                                        }
                                        u11 = n.u(packageName2, charSequence, z12, i10, obj);
                                        if (u11) {
                                            D2 = n.D(packageName2, "*", 0, false, 6, null);
                                            if (D2 != packageName2.length() - 1) {
                                                z14 = false;
                                                if (z14) {
                                                    throw new IllegalArgumentException("Wildcard in package name is only allowed at the end.".toString());
                                                }
                                                u12 = n.u(str2, charSequence, z12, i10, obj);
                                                if (u12) {
                                                    D = n.D(str2, "*", 0, false, 6, null);
                                                    if (D != str2.length() - 1) {
                                                        z15 = false;
                                                    }
                                                }
                                                if (!z15) {
                                                    throw new IllegalArgumentException("Wildcard in class name is only allowed at the end.".toString());
                                                }
                                                return;
                                            }
                                        }
                                        z14 = true;
                                        if (z14) {
                                        }
                                    }
                                } else {
                                    obj = null;
                                    charSequence = "*";
                                    str2 = className2;
                                    z12 = false;
                                    i10 = 2;
                                }
                                z13 = true;
                                if (z13) {
                                }
                            }
                        }
                        z11 = true;
                        if (z11) {
                        }
                    }
                }
                z10 = false;
                if (z10) {
                }
            }
        }
        z9 = false;
        if (z9) {
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SplitPairFilter) {
            SplitPairFilter splitPairFilter = (SplitPairFilter) obj;
            return k.a(this.primaryActivityName, splitPairFilter.primaryActivityName) && k.a(this.secondaryActivityName, splitPairFilter.secondaryActivityName) && k.a(this.secondaryActivityIntentAction, splitPairFilter.secondaryActivityIntentAction);
        }
        return false;
    }

    public final ComponentName getPrimaryActivityName() {
        return this.primaryActivityName;
    }

    public final String getSecondaryActivityIntentAction() {
        return this.secondaryActivityIntentAction;
    }

    public final ComponentName getSecondaryActivityName() {
        return this.secondaryActivityName;
    }

    public int hashCode() {
        int hashCode = ((this.primaryActivityName.hashCode() * 31) + this.secondaryActivityName.hashCode()) * 31;
        String str = this.secondaryActivityIntentAction;
        return hashCode + (str == null ? 0 : str.hashCode());
    }

    public final boolean matchesActivityIntentPair(Activity primaryActivity, Intent secondaryActivityIntent) {
        k.e(primaryActivity, "primaryActivity");
        k.e(secondaryActivityIntent, "secondaryActivityIntent");
        ComponentName componentName = primaryActivity.getComponentName();
        MatcherUtils matcherUtils = MatcherUtils.INSTANCE;
        if (matcherUtils.areComponentsMatching$window_release(componentName, this.primaryActivityName) && matcherUtils.areComponentsMatching$window_release(secondaryActivityIntent.getComponent(), this.secondaryActivityName)) {
            String str = this.secondaryActivityIntentAction;
            return str == null || k.a(str, secondaryActivityIntent.getAction());
        }
        return false;
    }

    /* JADX WARN: Code restructure failed: missing block: B:12:0x003e, code lost:
        if (matchesActivityIntentPair(r6, r7) != false) goto L11;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public final boolean matchesActivityPair(Activity primaryActivity, Activity secondaryActivity) {
        k.e(primaryActivity, "primaryActivity");
        k.e(secondaryActivity, "secondaryActivity");
        MatcherUtils matcherUtils = MatcherUtils.INSTANCE;
        boolean z9 = true;
        boolean z10 = matcherUtils.areComponentsMatching$window_release(primaryActivity.getComponentName(), this.primaryActivityName) && matcherUtils.areComponentsMatching$window_release(secondaryActivity.getComponentName(), this.secondaryActivityName);
        if (secondaryActivity.getIntent() != null) {
            if (z10) {
                Intent intent = secondaryActivity.getIntent();
                k.d(intent, "secondaryActivity.intent");
            }
            z9 = false;
            return z9;
        }
        return z10;
    }

    public String toString() {
        return "SplitPairFilter{primaryActivityName=" + this.primaryActivityName + ", secondaryActivityName=" + this.secondaryActivityName + ", secondaryActivityAction=" + ((Object) this.secondaryActivityIntentAction) + '}';
    }
}
