package androidx.vectordrawable.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import androidx.core.content.res.m;
import androidx.core.graphics.e;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
/* loaded from: classes.dex */
public class g extends androidx.vectordrawable.graphics.drawable.f {

    /* renamed from: q  reason: collision with root package name */
    static final PorterDuff.Mode f4443q = PorterDuff.Mode.SRC_IN;

    /* renamed from: h  reason: collision with root package name */
    private h f4444h;

    /* renamed from: i  reason: collision with root package name */
    private PorterDuffColorFilter f4445i;

    /* renamed from: j  reason: collision with root package name */
    private ColorFilter f4446j;

    /* renamed from: k  reason: collision with root package name */
    private boolean f4447k;

    /* renamed from: l  reason: collision with root package name */
    private boolean f4448l;

    /* renamed from: m  reason: collision with root package name */
    private Drawable.ConstantState f4449m;

    /* renamed from: n  reason: collision with root package name */
    private final float[] f4450n;

    /* renamed from: o  reason: collision with root package name */
    private final Matrix f4451o;

    /* renamed from: p  reason: collision with root package name */
    private final Rect f4452p;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class b extends f {
        b() {
        }

        b(b bVar) {
            super(bVar);
        }

        private void f(TypedArray typedArray, XmlPullParser xmlPullParser) {
            String string = typedArray.getString(0);
            if (string != null) {
                this.f4479b = string;
            }
            String string2 = typedArray.getString(1);
            if (string2 != null) {
                this.f4478a = androidx.core.graphics.e.d(string2);
            }
            this.f4480c = m.g(typedArray, xmlPullParser, "fillType", 2, 0);
        }

        @Override // androidx.vectordrawable.graphics.drawable.g.f
        public boolean c() {
            return true;
        }

        public void e(Resources resources, AttributeSet attributeSet, Resources.Theme theme, XmlPullParser xmlPullParser) {
            if (m.j(xmlPullParser, "pathData")) {
                TypedArray k10 = m.k(resources, theme, attributeSet, androidx.vectordrawable.graphics.drawable.a.f4418d);
                f(k10, xmlPullParser);
                k10.recycle();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class c extends f {

        /* renamed from: e  reason: collision with root package name */
        private int[] f4453e;

        /* renamed from: f  reason: collision with root package name */
        androidx.core.content.res.d f4454f;

        /* renamed from: g  reason: collision with root package name */
        float f4455g;

        /* renamed from: h  reason: collision with root package name */
        androidx.core.content.res.d f4456h;

        /* renamed from: i  reason: collision with root package name */
        float f4457i;

        /* renamed from: j  reason: collision with root package name */
        float f4458j;

        /* renamed from: k  reason: collision with root package name */
        float f4459k;

        /* renamed from: l  reason: collision with root package name */
        float f4460l;

        /* renamed from: m  reason: collision with root package name */
        float f4461m;

        /* renamed from: n  reason: collision with root package name */
        Paint.Cap f4462n;

        /* renamed from: o  reason: collision with root package name */
        Paint.Join f4463o;

        /* renamed from: p  reason: collision with root package name */
        float f4464p;

        c() {
            this.f4455g = 0.0f;
            this.f4457i = 1.0f;
            this.f4458j = 1.0f;
            this.f4459k = 0.0f;
            this.f4460l = 1.0f;
            this.f4461m = 0.0f;
            this.f4462n = Paint.Cap.BUTT;
            this.f4463o = Paint.Join.MITER;
            this.f4464p = 4.0f;
        }

        c(c cVar) {
            super(cVar);
            this.f4455g = 0.0f;
            this.f4457i = 1.0f;
            this.f4458j = 1.0f;
            this.f4459k = 0.0f;
            this.f4460l = 1.0f;
            this.f4461m = 0.0f;
            this.f4462n = Paint.Cap.BUTT;
            this.f4463o = Paint.Join.MITER;
            this.f4464p = 4.0f;
            this.f4453e = cVar.f4453e;
            this.f4454f = cVar.f4454f;
            this.f4455g = cVar.f4455g;
            this.f4457i = cVar.f4457i;
            this.f4456h = cVar.f4456h;
            this.f4480c = cVar.f4480c;
            this.f4458j = cVar.f4458j;
            this.f4459k = cVar.f4459k;
            this.f4460l = cVar.f4460l;
            this.f4461m = cVar.f4461m;
            this.f4462n = cVar.f4462n;
            this.f4463o = cVar.f4463o;
            this.f4464p = cVar.f4464p;
        }

        private Paint.Cap e(int i10, Paint.Cap cap) {
            return i10 != 0 ? i10 != 1 ? i10 != 2 ? cap : Paint.Cap.SQUARE : Paint.Cap.ROUND : Paint.Cap.BUTT;
        }

        private Paint.Join f(int i10, Paint.Join join) {
            return i10 != 0 ? i10 != 1 ? i10 != 2 ? join : Paint.Join.BEVEL : Paint.Join.ROUND : Paint.Join.MITER;
        }

        private void h(TypedArray typedArray, XmlPullParser xmlPullParser, Resources.Theme theme) {
            this.f4453e = null;
            if (m.j(xmlPullParser, "pathData")) {
                String string = typedArray.getString(0);
                if (string != null) {
                    this.f4479b = string;
                }
                String string2 = typedArray.getString(2);
                if (string2 != null) {
                    this.f4478a = androidx.core.graphics.e.d(string2);
                }
                this.f4456h = m.e(typedArray, xmlPullParser, theme, "fillColor", 1, 0);
                this.f4458j = m.f(typedArray, xmlPullParser, "fillAlpha", 12, this.f4458j);
                this.f4462n = e(m.g(typedArray, xmlPullParser, "strokeLineCap", 8, -1), this.f4462n);
                this.f4463o = f(m.g(typedArray, xmlPullParser, "strokeLineJoin", 9, -1), this.f4463o);
                this.f4464p = m.f(typedArray, xmlPullParser, "strokeMiterLimit", 10, this.f4464p);
                this.f4454f = m.e(typedArray, xmlPullParser, theme, "strokeColor", 3, 0);
                this.f4457i = m.f(typedArray, xmlPullParser, "strokeAlpha", 11, this.f4457i);
                this.f4455g = m.f(typedArray, xmlPullParser, "strokeWidth", 4, this.f4455g);
                this.f4460l = m.f(typedArray, xmlPullParser, "trimPathEnd", 6, this.f4460l);
                this.f4461m = m.f(typedArray, xmlPullParser, "trimPathOffset", 7, this.f4461m);
                this.f4459k = m.f(typedArray, xmlPullParser, "trimPathStart", 5, this.f4459k);
                this.f4480c = m.g(typedArray, xmlPullParser, "fillType", 13, this.f4480c);
            }
        }

        @Override // androidx.vectordrawable.graphics.drawable.g.e
        public boolean a() {
            return this.f4456h.i() || this.f4454f.i();
        }

        @Override // androidx.vectordrawable.graphics.drawable.g.e
        public boolean b(int[] iArr) {
            return this.f4454f.j(iArr) | this.f4456h.j(iArr);
        }

        public void g(Resources resources, AttributeSet attributeSet, Resources.Theme theme, XmlPullParser xmlPullParser) {
            TypedArray k10 = m.k(resources, theme, attributeSet, androidx.vectordrawable.graphics.drawable.a.f4417c);
            h(k10, xmlPullParser, theme);
            k10.recycle();
        }

        float getFillAlpha() {
            return this.f4458j;
        }

        int getFillColor() {
            return this.f4456h.e();
        }

        float getStrokeAlpha() {
            return this.f4457i;
        }

        int getStrokeColor() {
            return this.f4454f.e();
        }

        float getStrokeWidth() {
            return this.f4455g;
        }

        float getTrimPathEnd() {
            return this.f4460l;
        }

        float getTrimPathOffset() {
            return this.f4461m;
        }

        float getTrimPathStart() {
            return this.f4459k;
        }

        void setFillAlpha(float f10) {
            this.f4458j = f10;
        }

        void setFillColor(int i10) {
            this.f4456h.k(i10);
        }

        void setStrokeAlpha(float f10) {
            this.f4457i = f10;
        }

        void setStrokeColor(int i10) {
            this.f4454f.k(i10);
        }

        void setStrokeWidth(float f10) {
            this.f4455g = f10;
        }

        void setTrimPathEnd(float f10) {
            this.f4460l = f10;
        }

        void setTrimPathOffset(float f10) {
            this.f4461m = f10;
        }

        void setTrimPathStart(float f10) {
            this.f4459k = f10;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class d extends e {

        /* renamed from: a  reason: collision with root package name */
        final Matrix f4465a;

        /* renamed from: b  reason: collision with root package name */
        final ArrayList f4466b;

        /* renamed from: c  reason: collision with root package name */
        float f4467c;

        /* renamed from: d  reason: collision with root package name */
        private float f4468d;

        /* renamed from: e  reason: collision with root package name */
        private float f4469e;

        /* renamed from: f  reason: collision with root package name */
        private float f4470f;

        /* renamed from: g  reason: collision with root package name */
        private float f4471g;

        /* renamed from: h  reason: collision with root package name */
        private float f4472h;

        /* renamed from: i  reason: collision with root package name */
        private float f4473i;

        /* renamed from: j  reason: collision with root package name */
        final Matrix f4474j;

        /* renamed from: k  reason: collision with root package name */
        int f4475k;

        /* renamed from: l  reason: collision with root package name */
        private int[] f4476l;

        /* renamed from: m  reason: collision with root package name */
        private String f4477m;

        public d() {
            super();
            this.f4465a = new Matrix();
            this.f4466b = new ArrayList();
            this.f4467c = 0.0f;
            this.f4468d = 0.0f;
            this.f4469e = 0.0f;
            this.f4470f = 1.0f;
            this.f4471g = 1.0f;
            this.f4472h = 0.0f;
            this.f4473i = 0.0f;
            this.f4474j = new Matrix();
            this.f4477m = null;
        }

        public d(d dVar, o.a aVar) {
            super();
            f bVar;
            this.f4465a = new Matrix();
            this.f4466b = new ArrayList();
            this.f4467c = 0.0f;
            this.f4468d = 0.0f;
            this.f4469e = 0.0f;
            this.f4470f = 1.0f;
            this.f4471g = 1.0f;
            this.f4472h = 0.0f;
            this.f4473i = 0.0f;
            Matrix matrix = new Matrix();
            this.f4474j = matrix;
            this.f4477m = null;
            this.f4467c = dVar.f4467c;
            this.f4468d = dVar.f4468d;
            this.f4469e = dVar.f4469e;
            this.f4470f = dVar.f4470f;
            this.f4471g = dVar.f4471g;
            this.f4472h = dVar.f4472h;
            this.f4473i = dVar.f4473i;
            this.f4476l = dVar.f4476l;
            String str = dVar.f4477m;
            this.f4477m = str;
            this.f4475k = dVar.f4475k;
            if (str != null) {
                aVar.put(str, this);
            }
            matrix.set(dVar.f4474j);
            ArrayList arrayList = dVar.f4466b;
            for (int i10 = 0; i10 < arrayList.size(); i10++) {
                Object obj = arrayList.get(i10);
                if (obj instanceof d) {
                    this.f4466b.add(new d((d) obj, aVar));
                } else {
                    if (obj instanceof c) {
                        bVar = new c((c) obj);
                    } else if (!(obj instanceof b)) {
                        throw new IllegalStateException("Unknown object in the tree!");
                    } else {
                        bVar = new b((b) obj);
                    }
                    this.f4466b.add(bVar);
                    Object obj2 = bVar.f4479b;
                    if (obj2 != null) {
                        aVar.put(obj2, bVar);
                    }
                }
            }
        }

        private void d() {
            this.f4474j.reset();
            this.f4474j.postTranslate(-this.f4468d, -this.f4469e);
            this.f4474j.postScale(this.f4470f, this.f4471g);
            this.f4474j.postRotate(this.f4467c, 0.0f, 0.0f);
            this.f4474j.postTranslate(this.f4472h + this.f4468d, this.f4473i + this.f4469e);
        }

        private void e(TypedArray typedArray, XmlPullParser xmlPullParser) {
            this.f4476l = null;
            this.f4467c = m.f(typedArray, xmlPullParser, "rotation", 5, this.f4467c);
            this.f4468d = typedArray.getFloat(1, this.f4468d);
            this.f4469e = typedArray.getFloat(2, this.f4469e);
            this.f4470f = m.f(typedArray, xmlPullParser, "scaleX", 3, this.f4470f);
            this.f4471g = m.f(typedArray, xmlPullParser, "scaleY", 4, this.f4471g);
            this.f4472h = m.f(typedArray, xmlPullParser, "translateX", 6, this.f4472h);
            this.f4473i = m.f(typedArray, xmlPullParser, "translateY", 7, this.f4473i);
            String string = typedArray.getString(0);
            if (string != null) {
                this.f4477m = string;
            }
            d();
        }

        @Override // androidx.vectordrawable.graphics.drawable.g.e
        public boolean a() {
            for (int i10 = 0; i10 < this.f4466b.size(); i10++) {
                if (((e) this.f4466b.get(i10)).a()) {
                    return true;
                }
            }
            return false;
        }

        @Override // androidx.vectordrawable.graphics.drawable.g.e
        public boolean b(int[] iArr) {
            boolean z9 = false;
            for (int i10 = 0; i10 < this.f4466b.size(); i10++) {
                z9 |= ((e) this.f4466b.get(i10)).b(iArr);
            }
            return z9;
        }

        public void c(Resources resources, AttributeSet attributeSet, Resources.Theme theme, XmlPullParser xmlPullParser) {
            TypedArray k10 = m.k(resources, theme, attributeSet, androidx.vectordrawable.graphics.drawable.a.f4416b);
            e(k10, xmlPullParser);
            k10.recycle();
        }

        public String getGroupName() {
            return this.f4477m;
        }

        public Matrix getLocalMatrix() {
            return this.f4474j;
        }

        public float getPivotX() {
            return this.f4468d;
        }

        public float getPivotY() {
            return this.f4469e;
        }

        public float getRotation() {
            return this.f4467c;
        }

        public float getScaleX() {
            return this.f4470f;
        }

        public float getScaleY() {
            return this.f4471g;
        }

        public float getTranslateX() {
            return this.f4472h;
        }

        public float getTranslateY() {
            return this.f4473i;
        }

        public void setPivotX(float f10) {
            if (f10 != this.f4468d) {
                this.f4468d = f10;
                d();
            }
        }

        public void setPivotY(float f10) {
            if (f10 != this.f4469e) {
                this.f4469e = f10;
                d();
            }
        }

        public void setRotation(float f10) {
            if (f10 != this.f4467c) {
                this.f4467c = f10;
                d();
            }
        }

        public void setScaleX(float f10) {
            if (f10 != this.f4470f) {
                this.f4470f = f10;
                d();
            }
        }

        public void setScaleY(float f10) {
            if (f10 != this.f4471g) {
                this.f4471g = f10;
                d();
            }
        }

        public void setTranslateX(float f10) {
            if (f10 != this.f4472h) {
                this.f4472h = f10;
                d();
            }
        }

        public void setTranslateY(float f10) {
            if (f10 != this.f4473i) {
                this.f4473i = f10;
                d();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static abstract class e {
        private e() {
        }

        public boolean a() {
            return false;
        }

        public boolean b(int[] iArr) {
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static abstract class f extends e {

        /* renamed from: a  reason: collision with root package name */
        protected e.b[] f4478a;

        /* renamed from: b  reason: collision with root package name */
        String f4479b;

        /* renamed from: c  reason: collision with root package name */
        int f4480c;

        /* renamed from: d  reason: collision with root package name */
        int f4481d;

        public f() {
            super();
            this.f4478a = null;
            this.f4480c = 0;
        }

        public f(f fVar) {
            super();
            this.f4478a = null;
            this.f4480c = 0;
            this.f4479b = fVar.f4479b;
            this.f4481d = fVar.f4481d;
            this.f4478a = androidx.core.graphics.e.f(fVar.f4478a);
        }

        public boolean c() {
            return false;
        }

        public void d(Path path) {
            path.reset();
            e.b[] bVarArr = this.f4478a;
            if (bVarArr != null) {
                e.b.i(bVarArr, path);
            }
        }

        public e.b[] getPathData() {
            return this.f4478a;
        }

        public String getPathName() {
            return this.f4479b;
        }

        public void setPathData(e.b[] bVarArr) {
            if (androidx.core.graphics.e.b(this.f4478a, bVarArr)) {
                androidx.core.graphics.e.k(this.f4478a, bVarArr);
            } else {
                this.f4478a = androidx.core.graphics.e.f(bVarArr);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* renamed from: androidx.vectordrawable.graphics.drawable.g$g  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0054g {

        /* renamed from: q  reason: collision with root package name */
        private static final Matrix f4482q = new Matrix();

        /* renamed from: a  reason: collision with root package name */
        private final Path f4483a;

        /* renamed from: b  reason: collision with root package name */
        private final Path f4484b;

        /* renamed from: c  reason: collision with root package name */
        private final Matrix f4485c;

        /* renamed from: d  reason: collision with root package name */
        Paint f4486d;

        /* renamed from: e  reason: collision with root package name */
        Paint f4487e;

        /* renamed from: f  reason: collision with root package name */
        private PathMeasure f4488f;

        /* renamed from: g  reason: collision with root package name */
        private int f4489g;

        /* renamed from: h  reason: collision with root package name */
        final d f4490h;

        /* renamed from: i  reason: collision with root package name */
        float f4491i;

        /* renamed from: j  reason: collision with root package name */
        float f4492j;

        /* renamed from: k  reason: collision with root package name */
        float f4493k;

        /* renamed from: l  reason: collision with root package name */
        float f4494l;

        /* renamed from: m  reason: collision with root package name */
        int f4495m;

        /* renamed from: n  reason: collision with root package name */
        String f4496n;

        /* renamed from: o  reason: collision with root package name */
        Boolean f4497o;

        /* renamed from: p  reason: collision with root package name */
        final o.a f4498p;

        public C0054g() {
            this.f4485c = new Matrix();
            this.f4491i = 0.0f;
            this.f4492j = 0.0f;
            this.f4493k = 0.0f;
            this.f4494l = 0.0f;
            this.f4495m = 255;
            this.f4496n = null;
            this.f4497o = null;
            this.f4498p = new o.a();
            this.f4490h = new d();
            this.f4483a = new Path();
            this.f4484b = new Path();
        }

        public C0054g(C0054g c0054g) {
            this.f4485c = new Matrix();
            this.f4491i = 0.0f;
            this.f4492j = 0.0f;
            this.f4493k = 0.0f;
            this.f4494l = 0.0f;
            this.f4495m = 255;
            this.f4496n = null;
            this.f4497o = null;
            o.a aVar = new o.a();
            this.f4498p = aVar;
            this.f4490h = new d(c0054g.f4490h, aVar);
            this.f4483a = new Path(c0054g.f4483a);
            this.f4484b = new Path(c0054g.f4484b);
            this.f4491i = c0054g.f4491i;
            this.f4492j = c0054g.f4492j;
            this.f4493k = c0054g.f4493k;
            this.f4494l = c0054g.f4494l;
            this.f4489g = c0054g.f4489g;
            this.f4495m = c0054g.f4495m;
            this.f4496n = c0054g.f4496n;
            String str = c0054g.f4496n;
            if (str != null) {
                aVar.put(str, this);
            }
            this.f4497o = c0054g.f4497o;
        }

        private static float a(float f10, float f11, float f12, float f13) {
            return (f10 * f13) - (f11 * f12);
        }

        private void c(d dVar, Matrix matrix, Canvas canvas, int i10, int i11, ColorFilter colorFilter) {
            dVar.f4465a.set(matrix);
            dVar.f4465a.preConcat(dVar.f4474j);
            canvas.save();
            for (int i12 = 0; i12 < dVar.f4466b.size(); i12++) {
                e eVar = (e) dVar.f4466b.get(i12);
                if (eVar instanceof d) {
                    c((d) eVar, dVar.f4465a, canvas, i10, i11, colorFilter);
                } else if (eVar instanceof f) {
                    d(dVar, (f) eVar, canvas, i10, i11, colorFilter);
                }
            }
            canvas.restore();
        }

        private void d(d dVar, f fVar, Canvas canvas, int i10, int i11, ColorFilter colorFilter) {
            float f10 = i10 / this.f4493k;
            float f11 = i11 / this.f4494l;
            float min = Math.min(f10, f11);
            Matrix matrix = dVar.f4465a;
            this.f4485c.set(matrix);
            this.f4485c.postScale(f10, f11);
            float e10 = e(matrix);
            if (e10 == 0.0f) {
                return;
            }
            fVar.d(this.f4483a);
            Path path = this.f4483a;
            this.f4484b.reset();
            if (fVar.c()) {
                this.f4484b.setFillType(fVar.f4480c == 0 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD);
                this.f4484b.addPath(path, this.f4485c);
                canvas.clipPath(this.f4484b);
                return;
            }
            c cVar = (c) fVar;
            float f12 = cVar.f4459k;
            if (f12 != 0.0f || cVar.f4460l != 1.0f) {
                float f13 = cVar.f4461m;
                float f14 = (f12 + f13) % 1.0f;
                float f15 = (cVar.f4460l + f13) % 1.0f;
                if (this.f4488f == null) {
                    this.f4488f = new PathMeasure();
                }
                this.f4488f.setPath(this.f4483a, false);
                float length = this.f4488f.getLength();
                float f16 = f14 * length;
                float f17 = f15 * length;
                path.reset();
                if (f16 > f17) {
                    this.f4488f.getSegment(f16, length, path, true);
                    this.f4488f.getSegment(0.0f, f17, path, true);
                } else {
                    this.f4488f.getSegment(f16, f17, path, true);
                }
                path.rLineTo(0.0f, 0.0f);
            }
            this.f4484b.addPath(path, this.f4485c);
            if (cVar.f4456h.l()) {
                androidx.core.content.res.d dVar2 = cVar.f4456h;
                if (this.f4487e == null) {
                    Paint paint = new Paint(1);
                    this.f4487e = paint;
                    paint.setStyle(Paint.Style.FILL);
                }
                Paint paint2 = this.f4487e;
                if (dVar2.h()) {
                    Shader f18 = dVar2.f();
                    f18.setLocalMatrix(this.f4485c);
                    paint2.setShader(f18);
                    paint2.setAlpha(Math.round(cVar.f4458j * 255.0f));
                } else {
                    paint2.setShader(null);
                    paint2.setAlpha(255);
                    paint2.setColor(g.a(dVar2.e(), cVar.f4458j));
                }
                paint2.setColorFilter(colorFilter);
                this.f4484b.setFillType(cVar.f4480c == 0 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD);
                canvas.drawPath(this.f4484b, paint2);
            }
            if (cVar.f4454f.l()) {
                androidx.core.content.res.d dVar3 = cVar.f4454f;
                if (this.f4486d == null) {
                    Paint paint3 = new Paint(1);
                    this.f4486d = paint3;
                    paint3.setStyle(Paint.Style.STROKE);
                }
                Paint paint4 = this.f4486d;
                Paint.Join join = cVar.f4463o;
                if (join != null) {
                    paint4.setStrokeJoin(join);
                }
                Paint.Cap cap = cVar.f4462n;
                if (cap != null) {
                    paint4.setStrokeCap(cap);
                }
                paint4.setStrokeMiter(cVar.f4464p);
                if (dVar3.h()) {
                    Shader f19 = dVar3.f();
                    f19.setLocalMatrix(this.f4485c);
                    paint4.setShader(f19);
                    paint4.setAlpha(Math.round(cVar.f4457i * 255.0f));
                } else {
                    paint4.setShader(null);
                    paint4.setAlpha(255);
                    paint4.setColor(g.a(dVar3.e(), cVar.f4457i));
                }
                paint4.setColorFilter(colorFilter);
                paint4.setStrokeWidth(cVar.f4455g * min * e10);
                canvas.drawPath(this.f4484b, paint4);
            }
        }

        private float e(Matrix matrix) {
            float[] fArr = {0.0f, 1.0f, 1.0f, 0.0f};
            matrix.mapVectors(fArr);
            float a10 = a(fArr[0], fArr[1], fArr[2], fArr[3]);
            float max = Math.max((float) Math.hypot(fArr[0], fArr[1]), (float) Math.hypot(fArr[2], fArr[3]));
            if (max > 0.0f) {
                return Math.abs(a10) / max;
            }
            return 0.0f;
        }

        public void b(Canvas canvas, int i10, int i11, ColorFilter colorFilter) {
            c(this.f4490h, f4482q, canvas, i10, i11, colorFilter);
        }

        public boolean f() {
            if (this.f4497o == null) {
                this.f4497o = Boolean.valueOf(this.f4490h.a());
            }
            return this.f4497o.booleanValue();
        }

        public boolean g(int[] iArr) {
            return this.f4490h.b(iArr);
        }

        public float getAlpha() {
            return getRootAlpha() / 255.0f;
        }

        public int getRootAlpha() {
            return this.f4495m;
        }

        public void setAlpha(float f10) {
            setRootAlpha((int) (f10 * 255.0f));
        }

        public void setRootAlpha(int i10) {
            this.f4495m = i10;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class h extends Drawable.ConstantState {

        /* renamed from: a  reason: collision with root package name */
        int f4499a;

        /* renamed from: b  reason: collision with root package name */
        C0054g f4500b;

        /* renamed from: c  reason: collision with root package name */
        ColorStateList f4501c;

        /* renamed from: d  reason: collision with root package name */
        PorterDuff.Mode f4502d;

        /* renamed from: e  reason: collision with root package name */
        boolean f4503e;

        /* renamed from: f  reason: collision with root package name */
        Bitmap f4504f;

        /* renamed from: g  reason: collision with root package name */
        ColorStateList f4505g;

        /* renamed from: h  reason: collision with root package name */
        PorterDuff.Mode f4506h;

        /* renamed from: i  reason: collision with root package name */
        int f4507i;

        /* renamed from: j  reason: collision with root package name */
        boolean f4508j;

        /* renamed from: k  reason: collision with root package name */
        boolean f4509k;

        /* renamed from: l  reason: collision with root package name */
        Paint f4510l;

        public h() {
            this.f4501c = null;
            this.f4502d = g.f4443q;
            this.f4500b = new C0054g();
        }

        public h(h hVar) {
            this.f4501c = null;
            this.f4502d = g.f4443q;
            if (hVar != null) {
                this.f4499a = hVar.f4499a;
                C0054g c0054g = new C0054g(hVar.f4500b);
                this.f4500b = c0054g;
                if (hVar.f4500b.f4487e != null) {
                    c0054g.f4487e = new Paint(hVar.f4500b.f4487e);
                }
                if (hVar.f4500b.f4486d != null) {
                    this.f4500b.f4486d = new Paint(hVar.f4500b.f4486d);
                }
                this.f4501c = hVar.f4501c;
                this.f4502d = hVar.f4502d;
                this.f4503e = hVar.f4503e;
            }
        }

        public boolean a(int i10, int i11) {
            return i10 == this.f4504f.getWidth() && i11 == this.f4504f.getHeight();
        }

        public boolean b() {
            return !this.f4509k && this.f4505g == this.f4501c && this.f4506h == this.f4502d && this.f4508j == this.f4503e && this.f4507i == this.f4500b.getRootAlpha();
        }

        public void c(int i10, int i11) {
            if (this.f4504f == null || !a(i10, i11)) {
                this.f4504f = Bitmap.createBitmap(i10, i11, Bitmap.Config.ARGB_8888);
                this.f4509k = true;
            }
        }

        public void d(Canvas canvas, ColorFilter colorFilter, Rect rect) {
            canvas.drawBitmap(this.f4504f, (Rect) null, rect, e(colorFilter));
        }

        public Paint e(ColorFilter colorFilter) {
            if (f() || colorFilter != null) {
                if (this.f4510l == null) {
                    Paint paint = new Paint();
                    this.f4510l = paint;
                    paint.setFilterBitmap(true);
                }
                this.f4510l.setAlpha(this.f4500b.getRootAlpha());
                this.f4510l.setColorFilter(colorFilter);
                return this.f4510l;
            }
            return null;
        }

        public boolean f() {
            return this.f4500b.getRootAlpha() < 255;
        }

        public boolean g() {
            return this.f4500b.f();
        }

        @Override // android.graphics.drawable.Drawable.ConstantState
        public int getChangingConfigurations() {
            return this.f4499a;
        }

        public boolean h(int[] iArr) {
            boolean g10 = this.f4500b.g(iArr);
            this.f4509k |= g10;
            return g10;
        }

        public void i() {
            this.f4505g = this.f4501c;
            this.f4506h = this.f4502d;
            this.f4507i = this.f4500b.getRootAlpha();
            this.f4508j = this.f4503e;
            this.f4509k = false;
        }

        public void j(int i10, int i11) {
            this.f4504f.eraseColor(0);
            this.f4500b.b(new Canvas(this.f4504f), i10, i11, null);
        }

        @Override // android.graphics.drawable.Drawable.ConstantState
        public Drawable newDrawable() {
            return new g(this);
        }

        @Override // android.graphics.drawable.Drawable.ConstantState
        public Drawable newDrawable(Resources resources) {
            return new g(this);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class i extends Drawable.ConstantState {

        /* renamed from: a  reason: collision with root package name */
        private final Drawable.ConstantState f4511a;

        public i(Drawable.ConstantState constantState) {
            this.f4511a = constantState;
        }

        @Override // android.graphics.drawable.Drawable.ConstantState
        public boolean canApplyTheme() {
            return this.f4511a.canApplyTheme();
        }

        @Override // android.graphics.drawable.Drawable.ConstantState
        public int getChangingConfigurations() {
            return this.f4511a.getChangingConfigurations();
        }

        @Override // android.graphics.drawable.Drawable.ConstantState
        public Drawable newDrawable() {
            g gVar = new g();
            gVar.f4442g = (VectorDrawable) this.f4511a.newDrawable();
            return gVar;
        }

        @Override // android.graphics.drawable.Drawable.ConstantState
        public Drawable newDrawable(Resources resources) {
            g gVar = new g();
            gVar.f4442g = (VectorDrawable) this.f4511a.newDrawable(resources);
            return gVar;
        }

        @Override // android.graphics.drawable.Drawable.ConstantState
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            g gVar = new g();
            gVar.f4442g = (VectorDrawable) this.f4511a.newDrawable(resources, theme);
            return gVar;
        }
    }

    g() {
        this.f4448l = true;
        this.f4450n = new float[9];
        this.f4451o = new Matrix();
        this.f4452p = new Rect();
        this.f4444h = new h();
    }

    g(h hVar) {
        this.f4448l = true;
        this.f4450n = new float[9];
        this.f4451o = new Matrix();
        this.f4452p = new Rect();
        this.f4444h = hVar;
        this.f4445i = j(this.f4445i, hVar.f4501c, hVar.f4502d);
    }

    static int a(int i10, float f10) {
        return (i10 & 16777215) | (((int) (Color.alpha(i10) * f10)) << 24);
    }

    public static g b(Resources resources, int i10, Resources.Theme theme) {
        int next;
        if (Build.VERSION.SDK_INT >= 24) {
            g gVar = new g();
            gVar.f4442g = androidx.core.content.res.h.d(resources, i10, theme);
            gVar.f4449m = new i(gVar.f4442g.getConstantState());
            return gVar;
        }
        try {
            XmlResourceParser xml = resources.getXml(i10);
            AttributeSet asAttributeSet = Xml.asAttributeSet(xml);
            while (true) {
                next = xml.next();
                if (next == 2 || next == 1) {
                    break;
                }
            }
            if (next == 2) {
                return c(resources, xml, asAttributeSet, theme);
            }
            throw new XmlPullParserException("No start tag found");
        } catch (IOException | XmlPullParserException e10) {
            Log.e("VectorDrawableCompat", "parser error", e10);
            return null;
        }
    }

    public static g c(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
        g gVar = new g();
        gVar.inflate(resources, xmlPullParser, attributeSet, theme);
        return gVar;
    }

    /* JADX WARN: Multi-variable type inference failed */
    private void e(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
        int i10;
        int i11;
        b bVar;
        h hVar = this.f4444h;
        C0054g c0054g = hVar.f4500b;
        ArrayDeque arrayDeque = new ArrayDeque();
        arrayDeque.push(c0054g.f4490h);
        int eventType = xmlPullParser.getEventType();
        int depth = xmlPullParser.getDepth() + 1;
        boolean z9 = true;
        while (eventType != 1 && (xmlPullParser.getDepth() >= depth || eventType != 3)) {
            if (eventType == 2) {
                String name = xmlPullParser.getName();
                d dVar = (d) arrayDeque.peek();
                if ("path".equals(name)) {
                    c cVar = new c();
                    cVar.g(resources, attributeSet, theme, xmlPullParser);
                    dVar.f4466b.add(cVar);
                    if (cVar.getPathName() != null) {
                        c0054g.f4498p.put(cVar.getPathName(), cVar);
                    }
                    z9 = false;
                    bVar = cVar;
                } else if ("clip-path".equals(name)) {
                    b bVar2 = new b();
                    bVar2.e(resources, attributeSet, theme, xmlPullParser);
                    dVar.f4466b.add(bVar2);
                    String pathName = bVar2.getPathName();
                    bVar = bVar2;
                    if (pathName != null) {
                        c0054g.f4498p.put(bVar2.getPathName(), bVar2);
                        bVar = bVar2;
                    }
                } else if ("group".equals(name)) {
                    d dVar2 = new d();
                    dVar2.c(resources, attributeSet, theme, xmlPullParser);
                    dVar.f4466b.add(dVar2);
                    arrayDeque.push(dVar2);
                    if (dVar2.getGroupName() != null) {
                        c0054g.f4498p.put(dVar2.getGroupName(), dVar2);
                    }
                    i10 = hVar.f4499a;
                    i11 = dVar2.f4475k;
                    hVar.f4499a = i11 | i10;
                }
                i10 = hVar.f4499a;
                i11 = bVar.f4481d;
                hVar.f4499a = i11 | i10;
            } else if (eventType == 3 && "group".equals(xmlPullParser.getName())) {
                arrayDeque.pop();
            }
            eventType = xmlPullParser.next();
        }
        if (z9) {
            throw new XmlPullParserException("no path defined");
        }
    }

    private boolean f() {
        return isAutoMirrored() && androidx.core.graphics.drawable.a.f(this) == 1;
    }

    private static PorterDuff.Mode g(int i10, PorterDuff.Mode mode) {
        if (i10 != 3) {
            if (i10 != 5) {
                if (i10 != 9) {
                    switch (i10) {
                        case 14:
                            return PorterDuff.Mode.MULTIPLY;
                        case 15:
                            return PorterDuff.Mode.SCREEN;
                        case 16:
                            return PorterDuff.Mode.ADD;
                        default:
                            return mode;
                    }
                }
                return PorterDuff.Mode.SRC_ATOP;
            }
            return PorterDuff.Mode.SRC_IN;
        }
        return PorterDuff.Mode.SRC_OVER;
    }

    private void i(TypedArray typedArray, XmlPullParser xmlPullParser, Resources.Theme theme) {
        h hVar = this.f4444h;
        C0054g c0054g = hVar.f4500b;
        hVar.f4502d = g(m.g(typedArray, xmlPullParser, "tintMode", 6, -1), PorterDuff.Mode.SRC_IN);
        ColorStateList c10 = m.c(typedArray, xmlPullParser, theme, "tint", 1);
        if (c10 != null) {
            hVar.f4501c = c10;
        }
        hVar.f4503e = m.a(typedArray, xmlPullParser, "autoMirrored", 5, hVar.f4503e);
        c0054g.f4493k = m.f(typedArray, xmlPullParser, "viewportWidth", 7, c0054g.f4493k);
        float f10 = m.f(typedArray, xmlPullParser, "viewportHeight", 8, c0054g.f4494l);
        c0054g.f4494l = f10;
        if (c0054g.f4493k <= 0.0f) {
            throw new XmlPullParserException(typedArray.getPositionDescription() + "<vector> tag requires viewportWidth > 0");
        } else if (f10 <= 0.0f) {
            throw new XmlPullParserException(typedArray.getPositionDescription() + "<vector> tag requires viewportHeight > 0");
        } else {
            c0054g.f4491i = typedArray.getDimension(3, c0054g.f4491i);
            float dimension = typedArray.getDimension(2, c0054g.f4492j);
            c0054g.f4492j = dimension;
            if (c0054g.f4491i <= 0.0f) {
                throw new XmlPullParserException(typedArray.getPositionDescription() + "<vector> tag requires width > 0");
            } else if (dimension <= 0.0f) {
                throw new XmlPullParserException(typedArray.getPositionDescription() + "<vector> tag requires height > 0");
            } else {
                c0054g.setAlpha(m.f(typedArray, xmlPullParser, "alpha", 4, c0054g.getAlpha()));
                String string = typedArray.getString(0);
                if (string != null) {
                    c0054g.f4496n = string;
                    c0054g.f4498p.put(string, c0054g);
                }
            }
        }
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
    }

    @Override // android.graphics.drawable.Drawable
    public boolean canApplyTheme() {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            androidx.core.graphics.drawable.a.b(drawable);
            return false;
        }
        return false;
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ void clearColorFilter() {
        super.clearColorFilter();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Object d(String str) {
        return this.f4444h.f4500b.f4498p.get(str);
    }

    @Override // android.graphics.drawable.Drawable
    public void draw(Canvas canvas) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            drawable.draw(canvas);
            return;
        }
        copyBounds(this.f4452p);
        if (this.f4452p.width() <= 0 || this.f4452p.height() <= 0) {
            return;
        }
        ColorFilter colorFilter = this.f4446j;
        if (colorFilter == null) {
            colorFilter = this.f4445i;
        }
        canvas.getMatrix(this.f4451o);
        this.f4451o.getValues(this.f4450n);
        float abs = Math.abs(this.f4450n[0]);
        float abs2 = Math.abs(this.f4450n[4]);
        float abs3 = Math.abs(this.f4450n[1]);
        float abs4 = Math.abs(this.f4450n[3]);
        if (abs3 != 0.0f || abs4 != 0.0f) {
            abs = 1.0f;
            abs2 = 1.0f;
        }
        int min = Math.min(2048, (int) (this.f4452p.width() * abs));
        int min2 = Math.min(2048, (int) (this.f4452p.height() * abs2));
        if (min <= 0 || min2 <= 0) {
            return;
        }
        int save = canvas.save();
        Rect rect = this.f4452p;
        canvas.translate(rect.left, rect.top);
        if (f()) {
            canvas.translate(this.f4452p.width(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        this.f4452p.offsetTo(0, 0);
        this.f4444h.c(min, min2);
        if (!this.f4448l) {
            this.f4444h.j(min, min2);
        } else if (!this.f4444h.b()) {
            this.f4444h.j(min, min2);
            this.f4444h.i();
        }
        this.f4444h.d(canvas, colorFilter, this.f4452p);
        canvas.restoreToCount(save);
    }

    @Override // android.graphics.drawable.Drawable
    public int getAlpha() {
        Drawable drawable = this.f4442g;
        return drawable != null ? androidx.core.graphics.drawable.a.d(drawable) : this.f4444h.f4500b.getRootAlpha();
    }

    @Override // android.graphics.drawable.Drawable
    public int getChangingConfigurations() {
        Drawable drawable = this.f4442g;
        return drawable != null ? drawable.getChangingConfigurations() : super.getChangingConfigurations() | this.f4444h.getChangingConfigurations();
    }

    @Override // android.graphics.drawable.Drawable
    public ColorFilter getColorFilter() {
        Drawable drawable = this.f4442g;
        return drawable != null ? androidx.core.graphics.drawable.a.e(drawable) : this.f4446j;
    }

    @Override // android.graphics.drawable.Drawable
    public Drawable.ConstantState getConstantState() {
        if (this.f4442g == null || Build.VERSION.SDK_INT < 24) {
            this.f4444h.f4499a = getChangingConfigurations();
            return this.f4444h;
        }
        return new i(this.f4442g.getConstantState());
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ Drawable getCurrent() {
        return super.getCurrent();
    }

    @Override // android.graphics.drawable.Drawable
    public int getIntrinsicHeight() {
        Drawable drawable = this.f4442g;
        return drawable != null ? drawable.getIntrinsicHeight() : (int) this.f4444h.f4500b.f4492j;
    }

    @Override // android.graphics.drawable.Drawable
    public int getIntrinsicWidth() {
        Drawable drawable = this.f4442g;
        return drawable != null ? drawable.getIntrinsicWidth() : (int) this.f4444h.f4500b.f4491i;
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ int getMinimumHeight() {
        return super.getMinimumHeight();
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ int getMinimumWidth() {
        return super.getMinimumWidth();
    }

    @Override // android.graphics.drawable.Drawable
    public int getOpacity() {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            return drawable.getOpacity();
        }
        return -3;
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ boolean getPadding(Rect rect) {
        return super.getPadding(rect);
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ int[] getState() {
        return super.getState();
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ Region getTransparentRegion() {
        return super.getTransparentRegion();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void h(boolean z9) {
        this.f4448l = z9;
    }

    @Override // android.graphics.drawable.Drawable
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            drawable.inflate(resources, xmlPullParser, attributeSet);
        } else {
            inflate(resources, xmlPullParser, attributeSet, null);
        }
    }

    @Override // android.graphics.drawable.Drawable
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            androidx.core.graphics.drawable.a.g(drawable, resources, xmlPullParser, attributeSet, theme);
            return;
        }
        h hVar = this.f4444h;
        hVar.f4500b = new C0054g();
        TypedArray k10 = m.k(resources, theme, attributeSet, androidx.vectordrawable.graphics.drawable.a.f4415a);
        i(k10, xmlPullParser, theme);
        k10.recycle();
        hVar.f4499a = getChangingConfigurations();
        hVar.f4509k = true;
        e(resources, xmlPullParser, attributeSet, theme);
        this.f4445i = j(this.f4445i, hVar.f4501c, hVar.f4502d);
    }

    @Override // android.graphics.drawable.Drawable
    public void invalidateSelf() {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            drawable.invalidateSelf();
        } else {
            super.invalidateSelf();
        }
    }

    @Override // android.graphics.drawable.Drawable
    public boolean isAutoMirrored() {
        Drawable drawable = this.f4442g;
        return drawable != null ? androidx.core.graphics.drawable.a.h(drawable) : this.f4444h.f4503e;
    }

    @Override // android.graphics.drawable.Drawable
    public boolean isStateful() {
        h hVar;
        ColorStateList colorStateList;
        Drawable drawable = this.f4442g;
        return drawable != null ? drawable.isStateful() : super.isStateful() || ((hVar = this.f4444h) != null && (hVar.g() || ((colorStateList = this.f4444h.f4501c) != null && colorStateList.isStateful())));
    }

    PorterDuffColorFilter j(PorterDuffColorFilter porterDuffColorFilter, ColorStateList colorStateList, PorterDuff.Mode mode) {
        if (colorStateList == null || mode == null) {
            return null;
        }
        return new PorterDuffColorFilter(colorStateList.getColorForState(getState(), 0), mode);
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ void jumpToCurrentState() {
        super.jumpToCurrentState();
    }

    @Override // android.graphics.drawable.Drawable
    public Drawable mutate() {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            drawable.mutate();
            return this;
        }
        if (!this.f4447k && super.mutate() == this) {
            this.f4444h = new h(this.f4444h);
            this.f4447k = true;
        }
        return this;
    }

    @Override // android.graphics.drawable.Drawable
    protected void onBoundsChange(Rect rect) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            drawable.setBounds(rect);
        }
    }

    @Override // android.graphics.drawable.Drawable
    protected boolean onStateChange(int[] iArr) {
        PorterDuff.Mode mode;
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            return drawable.setState(iArr);
        }
        boolean z9 = false;
        h hVar = this.f4444h;
        ColorStateList colorStateList = hVar.f4501c;
        if (colorStateList != null && (mode = hVar.f4502d) != null) {
            this.f4445i = j(this.f4445i, colorStateList, mode);
            invalidateSelf();
            z9 = true;
        }
        if (hVar.g() && hVar.h(iArr)) {
            invalidateSelf();
            return true;
        }
        return z9;
    }

    @Override // android.graphics.drawable.Drawable
    public void scheduleSelf(Runnable runnable, long j10) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            drawable.scheduleSelf(runnable, j10);
        } else {
            super.scheduleSelf(runnable, j10);
        }
    }

    @Override // android.graphics.drawable.Drawable
    public void setAlpha(int i10) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            drawable.setAlpha(i10);
        } else if (this.f4444h.f4500b.getRootAlpha() != i10) {
            this.f4444h.f4500b.setRootAlpha(i10);
            invalidateSelf();
        }
    }

    @Override // android.graphics.drawable.Drawable
    public void setAutoMirrored(boolean z9) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            androidx.core.graphics.drawable.a.j(drawable, z9);
        } else {
            this.f4444h.f4503e = z9;
        }
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ void setChangingConfigurations(int i10) {
        super.setChangingConfigurations(i10);
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ void setColorFilter(int i10, PorterDuff.Mode mode) {
        super.setColorFilter(i10, mode);
    }

    @Override // android.graphics.drawable.Drawable
    public void setColorFilter(ColorFilter colorFilter) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            drawable.setColorFilter(colorFilter);
            return;
        }
        this.f4446j = colorFilter;
        invalidateSelf();
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ void setFilterBitmap(boolean z9) {
        super.setFilterBitmap(z9);
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ void setHotspot(float f10, float f11) {
        super.setHotspot(f10, f11);
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ void setHotspotBounds(int i10, int i11, int i12, int i13) {
        super.setHotspotBounds(i10, i11, i12, i13);
    }

    @Override // androidx.vectordrawable.graphics.drawable.f, android.graphics.drawable.Drawable
    public /* bridge */ /* synthetic */ boolean setState(int[] iArr) {
        return super.setState(iArr);
    }

    @Override // android.graphics.drawable.Drawable
    public void setTint(int i10) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            androidx.core.graphics.drawable.a.n(drawable, i10);
        } else {
            setTintList(ColorStateList.valueOf(i10));
        }
    }

    @Override // android.graphics.drawable.Drawable
    public void setTintList(ColorStateList colorStateList) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            androidx.core.graphics.drawable.a.o(drawable, colorStateList);
            return;
        }
        h hVar = this.f4444h;
        if (hVar.f4501c != colorStateList) {
            hVar.f4501c = colorStateList;
            this.f4445i = j(this.f4445i, colorStateList, hVar.f4502d);
            invalidateSelf();
        }
    }

    @Override // android.graphics.drawable.Drawable
    public void setTintMode(PorterDuff.Mode mode) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            androidx.core.graphics.drawable.a.p(drawable, mode);
            return;
        }
        h hVar = this.f4444h;
        if (hVar.f4502d != mode) {
            hVar.f4502d = mode;
            this.f4445i = j(this.f4445i, hVar.f4501c, mode);
            invalidateSelf();
        }
    }

    @Override // android.graphics.drawable.Drawable
    public boolean setVisible(boolean z9, boolean z10) {
        Drawable drawable = this.f4442g;
        return drawable != null ? drawable.setVisible(z9, z10) : super.setVisible(z9, z10);
    }

    @Override // android.graphics.drawable.Drawable
    public void unscheduleSelf(Runnable runnable) {
        Drawable drawable = this.f4442g;
        if (drawable != null) {
            drawable.unscheduleSelf(runnable);
        } else {
            super.unscheduleSelf(runnable);
        }
    }
}
