package androidx.recyclerview.widget;

import android.content.Context;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import androidx.recyclerview.widget.RecyclerView;
/* loaded from: classes.dex */
public class g extends RecyclerView.z {

    /* renamed from: k  reason: collision with root package name */
    protected PointF f4358k;

    /* renamed from: l  reason: collision with root package name */
    private final DisplayMetrics f4359l;

    /* renamed from: n  reason: collision with root package name */
    private float f4361n;

    /* renamed from: i  reason: collision with root package name */
    protected final LinearInterpolator f4356i = new LinearInterpolator();

    /* renamed from: j  reason: collision with root package name */
    protected final DecelerateInterpolator f4357j = new DecelerateInterpolator();

    /* renamed from: m  reason: collision with root package name */
    private boolean f4360m = false;

    /* renamed from: o  reason: collision with root package name */
    protected int f4362o = 0;

    /* renamed from: p  reason: collision with root package name */
    protected int f4363p = 0;

    public g(Context context) {
        this.f4359l = context.getResources().getDisplayMetrics();
    }

    private float A() {
        if (!this.f4360m) {
            this.f4361n = v(this.f4359l);
            this.f4360m = true;
        }
        return this.f4361n;
    }

    private int y(int i10, int i11) {
        int i12 = i10 - i11;
        if (i10 * i12 <= 0) {
            return 0;
        }
        return i12;
    }

    protected int B() {
        PointF pointF = this.f4358k;
        if (pointF != null) {
            float f10 = pointF.y;
            if (f10 != 0.0f) {
                return f10 > 0.0f ? 1 : -1;
            }
        }
        return 0;
    }

    protected void C(RecyclerView.z.a aVar) {
        PointF a10 = a(f());
        if (a10 == null || (a10.x == 0.0f && a10.y == 0.0f)) {
            aVar.b(f());
            r();
            return;
        }
        i(a10);
        this.f4358k = a10;
        this.f4362o = (int) (a10.x * 10000.0f);
        this.f4363p = (int) (a10.y * 10000.0f);
        aVar.d((int) (this.f4362o * 1.2f), (int) (this.f4363p * 1.2f), (int) (x(10000) * 1.2f), this.f4356i);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.z
    protected void l(int i10, int i11, RecyclerView.a0 a0Var, RecyclerView.z.a aVar) {
        if (c() == 0) {
            r();
            return;
        }
        this.f4362o = y(this.f4362o, i10);
        int y9 = y(this.f4363p, i11);
        this.f4363p = y9;
        if (this.f4362o == 0 && y9 == 0) {
            C(aVar);
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.z
    protected void m() {
    }

    @Override // androidx.recyclerview.widget.RecyclerView.z
    protected void n() {
        this.f4363p = 0;
        this.f4362o = 0;
        this.f4358k = null;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.z
    protected void o(View view, RecyclerView.a0 a0Var, RecyclerView.z.a aVar) {
        int t9 = t(view, z());
        int u9 = u(view, B());
        int w9 = w((int) Math.sqrt((t9 * t9) + (u9 * u9)));
        if (w9 > 0) {
            aVar.d(-t9, -u9, w9, this.f4357j);
        }
    }

    public int s(int i10, int i11, int i12, int i13, int i14) {
        if (i14 != -1) {
            if (i14 != 0) {
                if (i14 == 1) {
                    return i13 - i11;
                }
                throw new IllegalArgumentException("snap preference should be one of the constants defined in SmoothScroller, starting with SNAP_");
            }
            int i15 = i12 - i10;
            if (i15 > 0) {
                return i15;
            }
            int i16 = i13 - i11;
            if (i16 < 0) {
                return i16;
            }
            return 0;
        }
        return i12 - i10;
    }

    public int t(View view, int i10) {
        RecyclerView.o e10 = e();
        if (e10 == null || !e10.k()) {
            return 0;
        }
        RecyclerView.p pVar = (RecyclerView.p) view.getLayoutParams();
        return s(e10.Q(view) - ((ViewGroup.MarginLayoutParams) pVar).leftMargin, e10.T(view) + ((ViewGroup.MarginLayoutParams) pVar).rightMargin, e10.e0(), e10.o0() - e10.f0(), i10);
    }

    public int u(View view, int i10) {
        RecyclerView.o e10 = e();
        if (e10 == null || !e10.l()) {
            return 0;
        }
        RecyclerView.p pVar = (RecyclerView.p) view.getLayoutParams();
        return s(e10.U(view) - ((ViewGroup.MarginLayoutParams) pVar).topMargin, e10.O(view) + ((ViewGroup.MarginLayoutParams) pVar).bottomMargin, e10.g0(), e10.W() - e10.d0(), i10);
    }

    protected float v(DisplayMetrics displayMetrics) {
        return 25.0f / displayMetrics.densityDpi;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public int w(int i10) {
        return (int) Math.ceil(x(i10) / 0.3356d);
    }

    protected int x(int i10) {
        return (int) Math.ceil(Math.abs(i10) * A());
    }

    protected int z() {
        PointF pointF = this.f4358k;
        if (pointF != null) {
            float f10 = pointF.x;
            if (f10 != 0.0f) {
                return f10 > 0.0f ? 1 : -1;
            }
        }
        return 0;
    }
}
