package androidx.recyclerview.widget;

import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public final class e implements Runnable {

    /* renamed from: k  reason: collision with root package name */
    static final ThreadLocal f4332k = new ThreadLocal();

    /* renamed from: l  reason: collision with root package name */
    static Comparator f4333l = new a();

    /* renamed from: h  reason: collision with root package name */
    long f4335h;

    /* renamed from: i  reason: collision with root package name */
    long f4336i;

    /* renamed from: g  reason: collision with root package name */
    ArrayList f4334g = new ArrayList();

    /* renamed from: j  reason: collision with root package name */
    private ArrayList f4337j = new ArrayList();

    /* loaded from: classes.dex */
    static class a implements Comparator {
        a() {
        }

        @Override // java.util.Comparator
        /* renamed from: a */
        public int compare(c cVar, c cVar2) {
            RecyclerView recyclerView = cVar.f4345d;
            if ((recyclerView == null) != (cVar2.f4345d == null)) {
                return recyclerView == null ? 1 : -1;
            }
            boolean z9 = cVar.f4342a;
            if (z9 != cVar2.f4342a) {
                return z9 ? -1 : 1;
            }
            int i10 = cVar2.f4343b - cVar.f4343b;
            if (i10 != 0) {
                return i10;
            }
            int i11 = cVar.f4344c - cVar2.f4344c;
            if (i11 != 0) {
                return i11;
            }
            return 0;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class b implements RecyclerView.o.c {

        /* renamed from: a  reason: collision with root package name */
        int f4338a;

        /* renamed from: b  reason: collision with root package name */
        int f4339b;

        /* renamed from: c  reason: collision with root package name */
        int[] f4340c;

        /* renamed from: d  reason: collision with root package name */
        int f4341d;

        @Override // androidx.recyclerview.widget.RecyclerView.o.c
        public void a(int i10, int i11) {
            if (i10 < 0) {
                throw new IllegalArgumentException("Layout positions must be non-negative");
            }
            if (i11 < 0) {
                throw new IllegalArgumentException("Pixel distance must be non-negative");
            }
            int i12 = this.f4341d * 2;
            int[] iArr = this.f4340c;
            if (iArr == null) {
                int[] iArr2 = new int[4];
                this.f4340c = iArr2;
                Arrays.fill(iArr2, -1);
            } else if (i12 >= iArr.length) {
                int[] iArr3 = new int[i12 * 2];
                this.f4340c = iArr3;
                System.arraycopy(iArr, 0, iArr3, 0, iArr.length);
            }
            int[] iArr4 = this.f4340c;
            iArr4[i12] = i10;
            iArr4[i12 + 1] = i11;
            this.f4341d++;
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public void b() {
            int[] iArr = this.f4340c;
            if (iArr != null) {
                Arrays.fill(iArr, -1);
            }
            this.f4341d = 0;
        }

        void c(RecyclerView recyclerView, boolean z9) {
            this.f4341d = 0;
            int[] iArr = this.f4340c;
            if (iArr != null) {
                Arrays.fill(iArr, -1);
            }
            RecyclerView.o oVar = recyclerView.mLayout;
            if (recyclerView.mAdapter == null || oVar == null || !oVar.u0()) {
                return;
            }
            if (z9) {
                if (!recyclerView.mAdapterHelper.p()) {
                    oVar.p(recyclerView.mAdapter.c(), this);
                }
            } else if (!recyclerView.hasPendingAdapterUpdates()) {
                oVar.o(this.f4338a, this.f4339b, recyclerView.mState, this);
            }
            int i10 = this.f4341d;
            if (i10 > oVar.f4146m) {
                oVar.f4146m = i10;
                oVar.f4147n = z9;
                recyclerView.mRecycler.K();
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean d(int i10) {
            if (this.f4340c != null) {
                int i11 = this.f4341d * 2;
                for (int i12 = 0; i12 < i11; i12 += 2) {
                    if (this.f4340c[i12] == i10) {
                        return true;
                    }
                }
            }
            return false;
        }

        void e(int i10, int i11) {
            this.f4338a = i10;
            this.f4339b = i11;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class c {

        /* renamed from: a  reason: collision with root package name */
        public boolean f4342a;

        /* renamed from: b  reason: collision with root package name */
        public int f4343b;

        /* renamed from: c  reason: collision with root package name */
        public int f4344c;

        /* renamed from: d  reason: collision with root package name */
        public RecyclerView f4345d;

        /* renamed from: e  reason: collision with root package name */
        public int f4346e;

        c() {
        }

        public void a() {
            this.f4342a = false;
            this.f4343b = 0;
            this.f4344c = 0;
            this.f4345d = null;
            this.f4346e = 0;
        }
    }

    private void b() {
        c cVar;
        int size = this.f4334g.size();
        int i10 = 0;
        for (int i11 = 0; i11 < size; i11++) {
            RecyclerView recyclerView = (RecyclerView) this.f4334g.get(i11);
            if (recyclerView.getWindowVisibility() == 0) {
                recyclerView.mPrefetchRegistry.c(recyclerView, false);
                i10 += recyclerView.mPrefetchRegistry.f4341d;
            }
        }
        this.f4337j.ensureCapacity(i10);
        int i12 = 0;
        for (int i13 = 0; i13 < size; i13++) {
            RecyclerView recyclerView2 = (RecyclerView) this.f4334g.get(i13);
            if (recyclerView2.getWindowVisibility() == 0) {
                b bVar = recyclerView2.mPrefetchRegistry;
                int abs = Math.abs(bVar.f4338a) + Math.abs(bVar.f4339b);
                for (int i14 = 0; i14 < bVar.f4341d * 2; i14 += 2) {
                    if (i12 >= this.f4337j.size()) {
                        cVar = new c();
                        this.f4337j.add(cVar);
                    } else {
                        cVar = (c) this.f4337j.get(i12);
                    }
                    int[] iArr = bVar.f4340c;
                    int i15 = iArr[i14 + 1];
                    cVar.f4342a = i15 <= abs;
                    cVar.f4343b = abs;
                    cVar.f4344c = i15;
                    cVar.f4345d = recyclerView2;
                    cVar.f4346e = iArr[i14];
                    i12++;
                }
            }
        }
        Collections.sort(this.f4337j, f4333l);
    }

    private void c(c cVar, long j10) {
        RecyclerView.d0 i10 = i(cVar.f4345d, cVar.f4346e, cVar.f4342a ? Long.MAX_VALUE : j10);
        if (i10 == null || i10.f4102b == null || !i10.s() || i10.t()) {
            return;
        }
        h((RecyclerView) i10.f4102b.get(), j10);
    }

    private void d(long j10) {
        for (int i10 = 0; i10 < this.f4337j.size(); i10++) {
            c cVar = (c) this.f4337j.get(i10);
            if (cVar.f4345d == null) {
                return;
            }
            c(cVar, j10);
            cVar.a();
        }
    }

    static boolean e(RecyclerView recyclerView, int i10) {
        int j10 = recyclerView.mChildHelper.j();
        for (int i11 = 0; i11 < j10; i11++) {
            RecyclerView.d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(recyclerView.mChildHelper.i(i11));
            if (childViewHolderInt.f4103c == i10 && !childViewHolderInt.t()) {
                return true;
            }
        }
        return false;
    }

    private void h(RecyclerView recyclerView, long j10) {
        if (recyclerView == null) {
            return;
        }
        if (recyclerView.mDataSetHasChangedAfterLayout && recyclerView.mChildHelper.j() != 0) {
            recyclerView.removeAndRecycleViews();
        }
        b bVar = recyclerView.mPrefetchRegistry;
        bVar.c(recyclerView, true);
        if (bVar.f4341d != 0) {
            try {
                androidx.core.os.l.a("RV Nested Prefetch");
                recyclerView.mState.f(recyclerView.mAdapter);
                for (int i10 = 0; i10 < bVar.f4341d * 2; i10 += 2) {
                    i(recyclerView, bVar.f4340c[i10], j10);
                }
            } finally {
                androidx.core.os.l.b();
            }
        }
    }

    private RecyclerView.d0 i(RecyclerView recyclerView, int i10, long j10) {
        if (e(recyclerView, i10)) {
            return null;
        }
        RecyclerView.v vVar = recyclerView.mRecycler;
        try {
            recyclerView.onEnterLayoutOrScroll();
            RecyclerView.d0 I = vVar.I(i10, false, j10);
            if (I != null) {
                if (!I.s() || I.t()) {
                    vVar.a(I, false);
                } else {
                    vVar.B(I.f4101a);
                }
            }
            return I;
        } finally {
            recyclerView.onExitLayoutOrScroll(false);
        }
    }

    public void a(RecyclerView recyclerView) {
        this.f4334g.add(recyclerView);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void f(RecyclerView recyclerView, int i10, int i11) {
        if (recyclerView.isAttachedToWindow() && this.f4335h == 0) {
            this.f4335h = recyclerView.getNanoTime();
            recyclerView.post(this);
        }
        recyclerView.mPrefetchRegistry.e(i10, i11);
    }

    void g(long j10) {
        b();
        d(j10);
    }

    public void j(RecyclerView recyclerView) {
        this.f4334g.remove(recyclerView);
    }

    @Override // java.lang.Runnable
    public void run() {
        try {
            androidx.core.os.l.a("RV Prefetch");
            if (!this.f4334g.isEmpty()) {
                int size = this.f4334g.size();
                long j10 = 0;
                for (int i10 = 0; i10 < size; i10++) {
                    RecyclerView recyclerView = (RecyclerView) this.f4334g.get(i10);
                    if (recyclerView.getWindowVisibility() == 0) {
                        j10 = Math.max(recyclerView.getDrawingTime(), j10);
                    }
                }
                if (j10 != 0) {
                    g(TimeUnit.MILLISECONDS.toNanos(j10) + this.f4336i);
                }
            }
        } finally {
            this.f4335h = 0L;
            androidx.core.os.l.b();
        }
    }
}
