package androidx.recyclerview.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.MotionEvent;
import androidx.core.view.r0;
import androidx.recyclerview.widget.RecyclerView;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class d extends RecyclerView.n implements RecyclerView.s {
    private static final int[] D = {16842919};
    private static final int[] E = new int[0];
    int A;
    private final Runnable B;
    private final RecyclerView.t C;

    /* renamed from: a  reason: collision with root package name */
    private final int f4301a;

    /* renamed from: b  reason: collision with root package name */
    private final int f4302b;

    /* renamed from: c  reason: collision with root package name */
    final StateListDrawable f4303c;

    /* renamed from: d  reason: collision with root package name */
    final Drawable f4304d;

    /* renamed from: e  reason: collision with root package name */
    private final int f4305e;

    /* renamed from: f  reason: collision with root package name */
    private final int f4306f;

    /* renamed from: g  reason: collision with root package name */
    private final StateListDrawable f4307g;

    /* renamed from: h  reason: collision with root package name */
    private final Drawable f4308h;

    /* renamed from: i  reason: collision with root package name */
    private final int f4309i;

    /* renamed from: j  reason: collision with root package name */
    private final int f4310j;

    /* renamed from: k  reason: collision with root package name */
    int f4311k;

    /* renamed from: l  reason: collision with root package name */
    int f4312l;

    /* renamed from: m  reason: collision with root package name */
    float f4313m;

    /* renamed from: n  reason: collision with root package name */
    int f4314n;

    /* renamed from: o  reason: collision with root package name */
    int f4315o;

    /* renamed from: p  reason: collision with root package name */
    float f4316p;

    /* renamed from: s  reason: collision with root package name */
    private RecyclerView f4319s;

    /* renamed from: z  reason: collision with root package name */
    final ValueAnimator f4326z;

    /* renamed from: q  reason: collision with root package name */
    private int f4317q = 0;

    /* renamed from: r  reason: collision with root package name */
    private int f4318r = 0;

    /* renamed from: t  reason: collision with root package name */
    private boolean f4320t = false;

    /* renamed from: u  reason: collision with root package name */
    private boolean f4321u = false;

    /* renamed from: v  reason: collision with root package name */
    private int f4322v = 0;

    /* renamed from: w  reason: collision with root package name */
    private int f4323w = 0;

    /* renamed from: x  reason: collision with root package name */
    private final int[] f4324x = new int[2];

    /* renamed from: y  reason: collision with root package name */
    private final int[] f4325y = new int[2];

    /* loaded from: classes.dex */
    class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            d.this.q(500);
        }
    }

    /* loaded from: classes.dex */
    class b extends RecyclerView.t {
        b() {
        }

        @Override // androidx.recyclerview.widget.RecyclerView.t
        public void b(RecyclerView recyclerView, int i10, int i11) {
            d.this.B(recyclerView.computeHorizontalScrollOffset(), recyclerView.computeVerticalScrollOffset());
        }
    }

    /* loaded from: classes.dex */
    private class c extends AnimatorListenerAdapter {

        /* renamed from: a  reason: collision with root package name */
        private boolean f4329a = false;

        c() {
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationCancel(Animator animator) {
            this.f4329a = true;
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationEnd(Animator animator) {
            if (this.f4329a) {
                this.f4329a = false;
            } else if (((Float) d.this.f4326z.getAnimatedValue()).floatValue() == 0.0f) {
                d dVar = d.this;
                dVar.A = 0;
                dVar.y(0);
            } else {
                d dVar2 = d.this;
                dVar2.A = 2;
                dVar2.v();
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.d$d  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    private class C0051d implements ValueAnimator.AnimatorUpdateListener {
        C0051d() {
        }

        @Override // android.animation.ValueAnimator.AnimatorUpdateListener
        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            int floatValue = (int) (((Float) valueAnimator.getAnimatedValue()).floatValue() * 255.0f);
            d.this.f4303c.setAlpha(floatValue);
            d.this.f4304d.setAlpha(floatValue);
            d.this.v();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public d(RecyclerView recyclerView, StateListDrawable stateListDrawable, Drawable drawable, StateListDrawable stateListDrawable2, Drawable drawable2, int i10, int i11, int i12) {
        ValueAnimator ofFloat = ValueAnimator.ofFloat(0.0f, 1.0f);
        this.f4326z = ofFloat;
        this.A = 0;
        this.B = new a();
        this.C = new b();
        this.f4303c = stateListDrawable;
        this.f4304d = drawable;
        this.f4307g = stateListDrawable2;
        this.f4308h = drawable2;
        this.f4305e = Math.max(i10, stateListDrawable.getIntrinsicWidth());
        this.f4306f = Math.max(i10, drawable.getIntrinsicWidth());
        this.f4309i = Math.max(i10, stateListDrawable2.getIntrinsicWidth());
        this.f4310j = Math.max(i10, drawable2.getIntrinsicWidth());
        this.f4301a = i11;
        this.f4302b = i12;
        stateListDrawable.setAlpha(255);
        drawable.setAlpha(255);
        ofFloat.addListener(new c());
        ofFloat.addUpdateListener(new C0051d());
        j(recyclerView);
    }

    private void C(float f10) {
        int[] p10 = p();
        float max = Math.max(p10[0], Math.min(p10[1], f10));
        if (Math.abs(this.f4312l - max) < 2.0f) {
            return;
        }
        int x9 = x(this.f4313m, max, p10, this.f4319s.computeVerticalScrollRange(), this.f4319s.computeVerticalScrollOffset(), this.f4318r);
        if (x9 != 0) {
            this.f4319s.scrollBy(0, x9);
        }
        this.f4313m = max;
    }

    private void k() {
        this.f4319s.removeCallbacks(this.B);
    }

    private void l() {
        this.f4319s.removeItemDecoration(this);
        this.f4319s.removeOnItemTouchListener(this);
        this.f4319s.removeOnScrollListener(this.C);
        k();
    }

    private void m(Canvas canvas) {
        int i10 = this.f4318r;
        int i11 = this.f4309i;
        int i12 = i10 - i11;
        int i13 = this.f4315o;
        int i14 = this.f4314n;
        int i15 = i13 - (i14 / 2);
        this.f4307g.setBounds(0, 0, i14, i11);
        this.f4308h.setBounds(0, 0, this.f4317q, this.f4310j);
        canvas.translate(0.0f, i12);
        this.f4308h.draw(canvas);
        canvas.translate(i15, 0.0f);
        this.f4307g.draw(canvas);
        canvas.translate(-i15, -i12);
    }

    private void n(Canvas canvas) {
        int i10 = this.f4317q;
        int i11 = this.f4305e;
        int i12 = i10 - i11;
        int i13 = this.f4312l;
        int i14 = this.f4311k;
        int i15 = i13 - (i14 / 2);
        this.f4303c.setBounds(0, 0, i11, i14);
        this.f4304d.setBounds(0, 0, this.f4306f, this.f4318r);
        if (s()) {
            this.f4304d.draw(canvas);
            canvas.translate(this.f4305e, i15);
            canvas.scale(-1.0f, 1.0f);
            this.f4303c.draw(canvas);
            canvas.scale(1.0f, 1.0f);
            i12 = this.f4305e;
        } else {
            canvas.translate(i12, 0.0f);
            this.f4304d.draw(canvas);
            canvas.translate(0.0f, i15);
            this.f4303c.draw(canvas);
        }
        canvas.translate(-i12, -i15);
    }

    private int[] o() {
        int[] iArr = this.f4325y;
        int i10 = this.f4302b;
        iArr[0] = i10;
        iArr[1] = this.f4317q - i10;
        return iArr;
    }

    private int[] p() {
        int[] iArr = this.f4324x;
        int i10 = this.f4302b;
        iArr[0] = i10;
        iArr[1] = this.f4318r - i10;
        return iArr;
    }

    private void r(float f10) {
        int[] o10 = o();
        float max = Math.max(o10[0], Math.min(o10[1], f10));
        if (Math.abs(this.f4315o - max) < 2.0f) {
            return;
        }
        int x9 = x(this.f4316p, max, o10, this.f4319s.computeHorizontalScrollRange(), this.f4319s.computeHorizontalScrollOffset(), this.f4317q);
        if (x9 != 0) {
            this.f4319s.scrollBy(x9, 0);
        }
        this.f4316p = max;
    }

    private boolean s() {
        return r0.B(this.f4319s) == 1;
    }

    private void w(int i10) {
        k();
        this.f4319s.postDelayed(this.B, i10);
    }

    private int x(float f10, float f11, int[] iArr, int i10, int i11, int i12) {
        int i13 = iArr[1] - iArr[0];
        if (i13 == 0) {
            return 0;
        }
        int i14 = i10 - i12;
        int i15 = (int) (((f11 - f10) / i13) * i14);
        int i16 = i11 + i15;
        if (i16 >= i14 || i16 < 0) {
            return 0;
        }
        return i15;
    }

    private void z() {
        this.f4319s.addItemDecoration(this);
        this.f4319s.addOnItemTouchListener(this);
        this.f4319s.addOnScrollListener(this.C);
    }

    public void A() {
        int i10 = this.A;
        if (i10 != 0) {
            if (i10 != 3) {
                return;
            }
            this.f4326z.cancel();
        }
        this.A = 1;
        ValueAnimator valueAnimator = this.f4326z;
        valueAnimator.setFloatValues(((Float) valueAnimator.getAnimatedValue()).floatValue(), 1.0f);
        this.f4326z.setDuration(500L);
        this.f4326z.setStartDelay(0L);
        this.f4326z.start();
    }

    void B(int i10, int i11) {
        int computeVerticalScrollRange = this.f4319s.computeVerticalScrollRange();
        int i12 = this.f4318r;
        this.f4320t = computeVerticalScrollRange - i12 > 0 && i12 >= this.f4301a;
        int computeHorizontalScrollRange = this.f4319s.computeHorizontalScrollRange();
        int i13 = this.f4317q;
        boolean z9 = computeHorizontalScrollRange - i13 > 0 && i13 >= this.f4301a;
        this.f4321u = z9;
        boolean z10 = this.f4320t;
        if (!z10 && !z9) {
            if (this.f4322v != 0) {
                y(0);
                return;
            }
            return;
        }
        if (z10) {
            float f10 = i12;
            this.f4312l = (int) ((f10 * (i11 + (f10 / 2.0f))) / computeVerticalScrollRange);
            this.f4311k = Math.min(i12, (i12 * i12) / computeVerticalScrollRange);
        }
        if (this.f4321u) {
            float f11 = i13;
            this.f4315o = (int) ((f11 * (i10 + (f11 / 2.0f))) / computeHorizontalScrollRange);
            this.f4314n = Math.min(i13, (i13 * i13) / computeHorizontalScrollRange);
        }
        int i14 = this.f4322v;
        if (i14 == 0 || i14 == 1) {
            y(1);
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.s
    public void a(RecyclerView recyclerView, MotionEvent motionEvent) {
        if (this.f4322v == 0) {
            return;
        }
        if (motionEvent.getAction() == 0) {
            boolean u9 = u(motionEvent.getX(), motionEvent.getY());
            boolean t9 = t(motionEvent.getX(), motionEvent.getY());
            if (u9 || t9) {
                if (t9) {
                    this.f4323w = 1;
                    this.f4316p = (int) motionEvent.getX();
                } else if (u9) {
                    this.f4323w = 2;
                    this.f4313m = (int) motionEvent.getY();
                }
                y(2);
            }
        } else if (motionEvent.getAction() == 1 && this.f4322v == 2) {
            this.f4313m = 0.0f;
            this.f4316p = 0.0f;
            y(1);
            this.f4323w = 0;
        } else if (motionEvent.getAction() == 2 && this.f4322v == 2) {
            A();
            if (this.f4323w == 1) {
                r(motionEvent.getX());
            }
            if (this.f4323w == 2) {
                C(motionEvent.getY());
            }
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.s
    public boolean b(RecyclerView recyclerView, MotionEvent motionEvent) {
        int i10 = this.f4322v;
        if (i10 == 1) {
            boolean u9 = u(motionEvent.getX(), motionEvent.getY());
            boolean t9 = t(motionEvent.getX(), motionEvent.getY());
            if (motionEvent.getAction() != 0) {
                return false;
            }
            if (!u9 && !t9) {
                return false;
            }
            if (t9) {
                this.f4323w = 1;
                this.f4316p = (int) motionEvent.getX();
            } else if (u9) {
                this.f4323w = 2;
                this.f4313m = (int) motionEvent.getY();
            }
            y(2);
        } else if (i10 != 2) {
            return false;
        }
        return true;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.s
    public void c(boolean z9) {
    }

    @Override // androidx.recyclerview.widget.RecyclerView.n
    public void i(Canvas canvas, RecyclerView recyclerView, RecyclerView.a0 a0Var) {
        if (this.f4317q != this.f4319s.getWidth() || this.f4318r != this.f4319s.getHeight()) {
            this.f4317q = this.f4319s.getWidth();
            this.f4318r = this.f4319s.getHeight();
            y(0);
        } else if (this.A != 0) {
            if (this.f4320t) {
                n(canvas);
            }
            if (this.f4321u) {
                m(canvas);
            }
        }
    }

    public void j(RecyclerView recyclerView) {
        RecyclerView recyclerView2 = this.f4319s;
        if (recyclerView2 == recyclerView) {
            return;
        }
        if (recyclerView2 != null) {
            l();
        }
        this.f4319s = recyclerView;
        if (recyclerView != null) {
            z();
        }
    }

    void q(int i10) {
        int i11 = this.A;
        if (i11 == 1) {
            this.f4326z.cancel();
        } else if (i11 != 2) {
            return;
        }
        this.A = 3;
        ValueAnimator valueAnimator = this.f4326z;
        valueAnimator.setFloatValues(((Float) valueAnimator.getAnimatedValue()).floatValue(), 0.0f);
        this.f4326z.setDuration(i10);
        this.f4326z.start();
    }

    boolean t(float f10, float f11) {
        if (f11 >= this.f4318r - this.f4309i) {
            int i10 = this.f4315o;
            int i11 = this.f4314n;
            if (f10 >= i10 - (i11 / 2) && f10 <= i10 + (i11 / 2)) {
                return true;
            }
        }
        return false;
    }

    boolean u(float f10, float f11) {
        if (!s() ? f10 >= this.f4317q - this.f4305e : f10 <= this.f4305e / 2) {
            int i10 = this.f4312l;
            int i11 = this.f4311k;
            if (f11 >= i10 - (i11 / 2) && f11 <= i10 + (i11 / 2)) {
                return true;
            }
        }
        return false;
    }

    void v() {
        this.f4319s.invalidate();
    }

    void y(int i10) {
        int i11;
        if (i10 == 2 && this.f4322v != 2) {
            this.f4303c.setState(D);
            k();
        }
        if (i10 == 0) {
            v();
        } else {
            A();
        }
        if (this.f4322v != 2 || i10 == 2) {
            i11 = i10 == 1 ? 1500 : 1500;
            this.f4322v = i10;
        }
        this.f4303c.setState(E);
        i11 = 1200;
        w(i11);
        this.f4322v = i10;
    }
}
