package androidx.recyclerview.widget;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Observable;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.FocusFinder;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import androidx.core.view.e0;
import androidx.core.view.f0;
import androidx.core.view.o2;
import androidx.core.view.r0;
import androidx.recyclerview.widget.a;
import androidx.recyclerview.widget.b;
import androidx.recyclerview.widget.e;
import androidx.recyclerview.widget.k;
import androidx.recyclerview.widget.o;
import androidx.recyclerview.widget.p;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import w.l;
/* loaded from: classes.dex */
public class RecyclerView extends ViewGroup {
    static final boolean ALLOW_SIZE_IN_UNSPECIFIED_SPEC;
    static final boolean ALLOW_THREAD_GAP_WORK;
    static final boolean DEBUG = false;
    static final int DEFAULT_ORIENTATION = 1;
    static final boolean DISPATCH_TEMP_DETACH = false;
    private static final boolean FORCE_ABS_FOCUS_SEARCH_DIRECTION;
    static final boolean FORCE_INVALIDATE_DISPLAY_LIST;
    static final long FOREVER_NS = Long.MAX_VALUE;
    public static final int HORIZONTAL = 0;
    private static final boolean IGNORE_DETACHED_FOCUSED_CHILD;
    private static final int INVALID_POINTER = -1;
    public static final int INVALID_TYPE = -1;
    private static final Class<?>[] LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE;
    static final int MAX_SCROLL_DURATION = 2000;
    private static final int[] NESTED_SCROLLING_ATTRS = {16843830};
    public static final long NO_ID = -1;
    public static final int NO_POSITION = -1;
    static final boolean POST_UPDATES_ON_ANIMATION;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    static final String TAG = "RecyclerView";
    public static final int TOUCH_SLOP_DEFAULT = 0;
    public static final int TOUCH_SLOP_PAGING = 1;
    static final String TRACE_BIND_VIEW_TAG = "RV OnBindView";
    static final String TRACE_CREATE_VIEW_TAG = "RV CreateView";
    private static final String TRACE_HANDLE_ADAPTER_UPDATES_TAG = "RV PartialInvalidate";
    static final String TRACE_NESTED_PREFETCH_TAG = "RV Nested Prefetch";
    private static final String TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG = "RV FullInvalidate";
    private static final String TRACE_ON_LAYOUT_TAG = "RV OnLayout";
    static final String TRACE_PREFETCH_TAG = "RV Prefetch";
    static final String TRACE_SCROLL_TAG = "RV Scroll";
    public static final int UNDEFINED_DURATION = Integer.MIN_VALUE;
    static final boolean VERBOSE_TRACING = false;
    public static final int VERTICAL = 1;
    static final Interpolator sQuinticInterpolator;
    androidx.recyclerview.widget.k mAccessibilityDelegate;
    private final AccessibilityManager mAccessibilityManager;
    g mAdapter;
    androidx.recyclerview.widget.a mAdapterHelper;
    boolean mAdapterUpdateDuringMeasure;
    private EdgeEffect mBottomGlow;
    private j mChildDrawingOrderCallback;
    androidx.recyclerview.widget.b mChildHelper;
    boolean mClipToPadding;
    boolean mDataSetHasChangedAfterLayout;
    boolean mDispatchItemsChangedEvent;
    private int mDispatchScrollCounter;
    private int mEatenAccessibilityChangeFlags;
    private k mEdgeEffectFactory;
    boolean mEnableFastScroller;
    boolean mFirstLayoutComplete;
    androidx.recyclerview.widget.e mGapWorker;
    boolean mHasFixedSize;
    private boolean mIgnoreMotionEventTillDown;
    private int mInitialTouchX;
    private int mInitialTouchY;
    private int mInterceptRequestLayoutDepth;
    private s mInterceptingOnItemTouchListener;
    boolean mIsAttached;
    l mItemAnimator;
    private l.b mItemAnimatorListener;
    private Runnable mItemAnimatorRunner;
    final ArrayList<n> mItemDecorations;
    boolean mItemsAddedOrRemoved;
    boolean mItemsChanged;
    private int mLastTouchX;
    private int mLastTouchY;
    o mLayout;
    private int mLayoutOrScrollCounter;
    boolean mLayoutSuppressed;
    boolean mLayoutWasDefered;
    private EdgeEffect mLeftGlow;
    private final int mMaxFlingVelocity;
    private final int mMinFlingVelocity;
    private final int[] mMinMaxLayoutPositions;
    private final int[] mNestedOffsets;
    private final x mObserver;
    private List<q> mOnChildAttachStateListeners;
    private r mOnFlingListener;
    private final ArrayList<s> mOnItemTouchListeners;
    final List<d0> mPendingAccessibilityImportanceChange;
    private y mPendingSavedState;
    boolean mPostedAnimatorRunner;
    e.b mPrefetchRegistry;
    private boolean mPreserveFocusAfterLayout;
    final v mRecycler;
    w mRecyclerListener;
    final int[] mReusableIntPair;
    private EdgeEffect mRightGlow;
    private float mScaledHorizontalScrollFactor;
    private float mScaledVerticalScrollFactor;
    private t mScrollListener;
    private List<t> mScrollListeners;
    private final int[] mScrollOffset;
    private int mScrollPointerId;
    private int mScrollState;
    private f0 mScrollingChildHelper;
    final a0 mState;
    final Rect mTempRect;
    private final Rect mTempRect2;
    final RectF mTempRectF;
    private EdgeEffect mTopGlow;
    private int mTouchSlop;
    final Runnable mUpdateChildViewsRunnable;
    private VelocityTracker mVelocityTracker;
    final c0 mViewFlinger;
    private final p.b mViewInfoProcessCallback;
    final androidx.recyclerview.widget.p mViewInfoStore;

    /* loaded from: classes.dex */
    class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            RecyclerView recyclerView = RecyclerView.this;
            if (!recyclerView.mFirstLayoutComplete || recyclerView.isLayoutRequested()) {
                return;
            }
            RecyclerView recyclerView2 = RecyclerView.this;
            if (!recyclerView2.mIsAttached) {
                recyclerView2.requestLayout();
            } else if (recyclerView2.mLayoutSuppressed) {
                recyclerView2.mLayoutWasDefered = true;
            } else {
                recyclerView2.consumePendingUpdateOperations();
            }
        }
    }

    /* loaded from: classes.dex */
    public static class a0 {

        /* renamed from: b  reason: collision with root package name */
        private SparseArray f4075b;

        /* renamed from: m  reason: collision with root package name */
        int f4086m;

        /* renamed from: n  reason: collision with root package name */
        long f4087n;

        /* renamed from: o  reason: collision with root package name */
        int f4088o;

        /* renamed from: p  reason: collision with root package name */
        int f4089p;

        /* renamed from: q  reason: collision with root package name */
        int f4090q;

        /* renamed from: a  reason: collision with root package name */
        int f4074a = -1;

        /* renamed from: c  reason: collision with root package name */
        int f4076c = 0;

        /* renamed from: d  reason: collision with root package name */
        int f4077d = 0;

        /* renamed from: e  reason: collision with root package name */
        int f4078e = 1;

        /* renamed from: f  reason: collision with root package name */
        int f4079f = 0;

        /* renamed from: g  reason: collision with root package name */
        boolean f4080g = false;

        /* renamed from: h  reason: collision with root package name */
        boolean f4081h = false;

        /* renamed from: i  reason: collision with root package name */
        boolean f4082i = false;

        /* renamed from: j  reason: collision with root package name */
        boolean f4083j = false;

        /* renamed from: k  reason: collision with root package name */
        boolean f4084k = false;

        /* renamed from: l  reason: collision with root package name */
        boolean f4085l = false;

        void a(int i10) {
            if ((this.f4078e & i10) != 0) {
                return;
            }
            throw new IllegalStateException("Layout state should be one of " + Integer.toBinaryString(i10) + " but it is " + Integer.toBinaryString(this.f4078e));
        }

        public int b() {
            return this.f4081h ? this.f4076c - this.f4077d : this.f4079f;
        }

        public int c() {
            return this.f4074a;
        }

        public boolean d() {
            return this.f4074a != -1;
        }

        public boolean e() {
            return this.f4081h;
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public void f(g gVar) {
            this.f4078e = 1;
            this.f4079f = gVar.c();
            this.f4081h = false;
            this.f4082i = false;
            this.f4083j = false;
        }

        public boolean g() {
            return this.f4085l;
        }

        public String toString() {
            return "State{mTargetPosition=" + this.f4074a + ", mData=" + this.f4075b + ", mItemCount=" + this.f4079f + ", mIsMeasuring=" + this.f4083j + ", mPreviousLayoutItemCount=" + this.f4076c + ", mDeletedInvisibleItemCountSincePreviousLayout=" + this.f4077d + ", mStructureChanged=" + this.f4080g + ", mInPreLayout=" + this.f4081h + ", mRunSimpleAnimations=" + this.f4084k + ", mRunPredictiveAnimations=" + this.f4085l + '}';
        }
    }

    /* loaded from: classes.dex */
    class b implements Runnable {
        b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            l lVar = RecyclerView.this.mItemAnimator;
            if (lVar != null) {
                lVar.u();
            }
            RecyclerView.this.mPostedAnimatorRunner = false;
        }
    }

    /* loaded from: classes.dex */
    public static abstract class b0 {
    }

    /* loaded from: classes.dex */
    static class c implements Interpolator {
        c() {
        }

        @Override // android.animation.TimeInterpolator
        public float getInterpolation(float f10) {
            float f11 = f10 - 1.0f;
            return (f11 * f11 * f11 * f11 * f11) + 1.0f;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class c0 implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        private int f4092g;

        /* renamed from: h  reason: collision with root package name */
        private int f4093h;

        /* renamed from: i  reason: collision with root package name */
        OverScroller f4094i;

        /* renamed from: j  reason: collision with root package name */
        Interpolator f4095j;

        /* renamed from: k  reason: collision with root package name */
        private boolean f4096k;

        /* renamed from: l  reason: collision with root package name */
        private boolean f4097l;

        c0() {
            Interpolator interpolator = RecyclerView.sQuinticInterpolator;
            this.f4095j = interpolator;
            this.f4096k = false;
            this.f4097l = false;
            this.f4094i = new OverScroller(RecyclerView.this.getContext(), interpolator);
        }

        private int a(int i10, int i11, int i12, int i13) {
            int i14;
            int abs = Math.abs(i10);
            int abs2 = Math.abs(i11);
            boolean z9 = abs > abs2;
            int sqrt = (int) Math.sqrt((i12 * i12) + (i13 * i13));
            int sqrt2 = (int) Math.sqrt((i10 * i10) + (i11 * i11));
            RecyclerView recyclerView = RecyclerView.this;
            int width = z9 ? recyclerView.getWidth() : recyclerView.getHeight();
            int i15 = width / 2;
            float f10 = width;
            float f11 = i15;
            float b10 = f11 + (b(Math.min(1.0f, (sqrt2 * 1.0f) / f10)) * f11);
            if (sqrt > 0) {
                i14 = Math.round(Math.abs(b10 / sqrt) * 1000.0f) * 4;
            } else {
                if (!z9) {
                    abs = abs2;
                }
                i14 = (int) (((abs / f10) + 1.0f) * 300.0f);
            }
            return Math.min(i14, (int) RecyclerView.MAX_SCROLL_DURATION);
        }

        private float b(float f10) {
            return (float) Math.sin((f10 - 0.5f) * 0.47123894f);
        }

        private void d() {
            RecyclerView.this.removeCallbacks(this);
            r0.f0(RecyclerView.this, this);
        }

        public void c(int i10, int i11) {
            RecyclerView.this.setScrollState(2);
            this.f4093h = 0;
            this.f4092g = 0;
            Interpolator interpolator = this.f4095j;
            Interpolator interpolator2 = RecyclerView.sQuinticInterpolator;
            if (interpolator != interpolator2) {
                this.f4095j = interpolator2;
                this.f4094i = new OverScroller(RecyclerView.this.getContext(), interpolator2);
            }
            this.f4094i.fling(0, 0, i10, i11, RecyclerView.UNDEFINED_DURATION, Integer.MAX_VALUE, RecyclerView.UNDEFINED_DURATION, Integer.MAX_VALUE);
            e();
        }

        void e() {
            if (this.f4096k) {
                this.f4097l = true;
            } else {
                d();
            }
        }

        public void f(int i10, int i11, int i12, Interpolator interpolator) {
            if (i12 == Integer.MIN_VALUE) {
                i12 = a(i10, i11, 0, 0);
            }
            int i13 = i12;
            if (interpolator == null) {
                interpolator = RecyclerView.sQuinticInterpolator;
            }
            if (this.f4095j != interpolator) {
                this.f4095j = interpolator;
                this.f4094i = new OverScroller(RecyclerView.this.getContext(), interpolator);
            }
            this.f4093h = 0;
            this.f4092g = 0;
            RecyclerView.this.setScrollState(2);
            this.f4094i.startScroll(0, 0, i10, i11, i13);
            if (Build.VERSION.SDK_INT < 23) {
                this.f4094i.computeScrollOffset();
            }
            e();
        }

        public void g() {
            RecyclerView.this.removeCallbacks(this);
            this.f4094i.abortAnimation();
        }

        @Override // java.lang.Runnable
        public void run() {
            int i10;
            int i11;
            RecyclerView recyclerView = RecyclerView.this;
            if (recyclerView.mLayout == null) {
                g();
                return;
            }
            this.f4097l = false;
            this.f4096k = true;
            recyclerView.consumePendingUpdateOperations();
            OverScroller overScroller = this.f4094i;
            if (overScroller.computeScrollOffset()) {
                int currX = overScroller.getCurrX();
                int currY = overScroller.getCurrY();
                int i12 = currX - this.f4092g;
                int i13 = currY - this.f4093h;
                this.f4092g = currX;
                this.f4093h = currY;
                RecyclerView recyclerView2 = RecyclerView.this;
                int[] iArr = recyclerView2.mReusableIntPair;
                iArr[0] = 0;
                iArr[1] = 0;
                if (recyclerView2.dispatchNestedPreScroll(i12, i13, iArr, null, 1)) {
                    int[] iArr2 = RecyclerView.this.mReusableIntPair;
                    i12 -= iArr2[0];
                    i13 -= iArr2[1];
                }
                if (RecyclerView.this.getOverScrollMode() != 2) {
                    RecyclerView.this.considerReleasingGlowsOnScroll(i12, i13);
                }
                RecyclerView recyclerView3 = RecyclerView.this;
                if (recyclerView3.mAdapter != null) {
                    int[] iArr3 = recyclerView3.mReusableIntPair;
                    iArr3[0] = 0;
                    iArr3[1] = 0;
                    recyclerView3.scrollStep(i12, i13, iArr3);
                    RecyclerView recyclerView4 = RecyclerView.this;
                    int[] iArr4 = recyclerView4.mReusableIntPair;
                    i11 = iArr4[0];
                    i10 = iArr4[1];
                    i12 -= i11;
                    i13 -= i10;
                    z zVar = recyclerView4.mLayout.f4140g;
                    if (zVar != null && !zVar.g() && zVar.h()) {
                        int b10 = RecyclerView.this.mState.b();
                        if (b10 == 0) {
                            zVar.r();
                        } else {
                            if (zVar.f() >= b10) {
                                zVar.p(b10 - 1);
                            }
                            zVar.j(i11, i10);
                        }
                    }
                } else {
                    i10 = 0;
                    i11 = 0;
                }
                if (!RecyclerView.this.mItemDecorations.isEmpty()) {
                    RecyclerView.this.invalidate();
                }
                RecyclerView recyclerView5 = RecyclerView.this;
                int[] iArr5 = recyclerView5.mReusableIntPair;
                iArr5[0] = 0;
                iArr5[1] = 0;
                recyclerView5.dispatchNestedScroll(i11, i10, i12, i13, null, 1, iArr5);
                RecyclerView recyclerView6 = RecyclerView.this;
                int[] iArr6 = recyclerView6.mReusableIntPair;
                int i14 = i12 - iArr6[0];
                int i15 = i13 - iArr6[1];
                if (i11 != 0 || i10 != 0) {
                    recyclerView6.dispatchOnScrolled(i11, i10);
                }
                if (!RecyclerView.this.awakenScrollBars()) {
                    RecyclerView.this.invalidate();
                }
                boolean z9 = overScroller.isFinished() || (((overScroller.getCurrX() == overScroller.getFinalX()) || i14 != 0) && ((overScroller.getCurrY() == overScroller.getFinalY()) || i15 != 0));
                z zVar2 = RecyclerView.this.mLayout.f4140g;
                if ((zVar2 != null && zVar2.g()) || !z9) {
                    e();
                    RecyclerView recyclerView7 = RecyclerView.this;
                    androidx.recyclerview.widget.e eVar = recyclerView7.mGapWorker;
                    if (eVar != null) {
                        eVar.f(recyclerView7, i11, i10);
                    }
                } else {
                    if (RecyclerView.this.getOverScrollMode() != 2) {
                        int currVelocity = (int) overScroller.getCurrVelocity();
                        int i16 = i14 < 0 ? -currVelocity : i14 > 0 ? currVelocity : 0;
                        if (i15 < 0) {
                            currVelocity = -currVelocity;
                        } else if (i15 <= 0) {
                            currVelocity = 0;
                        }
                        RecyclerView.this.absorbGlows(i16, currVelocity);
                    }
                    if (RecyclerView.ALLOW_THREAD_GAP_WORK) {
                        RecyclerView.this.mPrefetchRegistry.b();
                    }
                }
            }
            z zVar3 = RecyclerView.this.mLayout.f4140g;
            if (zVar3 != null && zVar3.g()) {
                zVar3.j(0, 0);
            }
            this.f4096k = false;
            if (this.f4097l) {
                d();
                return;
            }
            RecyclerView.this.setScrollState(0);
            RecyclerView.this.stopNestedScroll(1);
        }
    }

    /* loaded from: classes.dex */
    class d implements p.b {
        d() {
        }

        @Override // androidx.recyclerview.widget.p.b
        public void a(d0 d0Var) {
            RecyclerView recyclerView = RecyclerView.this;
            recyclerView.mLayout.m1(d0Var.f4101a, recyclerView.mRecycler);
        }

        @Override // androidx.recyclerview.widget.p.b
        public void b(d0 d0Var, l.c cVar, l.c cVar2) {
            RecyclerView.this.animateAppearance(d0Var, cVar, cVar2);
        }

        @Override // androidx.recyclerview.widget.p.b
        public void c(d0 d0Var, l.c cVar, l.c cVar2) {
            RecyclerView.this.mRecycler.J(d0Var);
            RecyclerView.this.animateDisappearance(d0Var, cVar, cVar2);
        }

        @Override // androidx.recyclerview.widget.p.b
        public void d(d0 d0Var, l.c cVar, l.c cVar2) {
            d0Var.G(false);
            RecyclerView recyclerView = RecyclerView.this;
            boolean z9 = recyclerView.mDataSetHasChangedAfterLayout;
            l lVar = recyclerView.mItemAnimator;
            if (z9) {
                if (!lVar.b(d0Var, d0Var, cVar, cVar2)) {
                    return;
                }
            } else if (!lVar.d(d0Var, cVar, cVar2)) {
                return;
            }
            RecyclerView.this.postAnimationRunner();
        }
    }

    /* loaded from: classes.dex */
    public static abstract class d0 {

        /* renamed from: s  reason: collision with root package name */
        private static final List f4100s = Collections.emptyList();

        /* renamed from: a  reason: collision with root package name */
        public final View f4101a;

        /* renamed from: b  reason: collision with root package name */
        WeakReference f4102b;

        /* renamed from: j  reason: collision with root package name */
        int f4110j;

        /* renamed from: r  reason: collision with root package name */
        RecyclerView f4118r;

        /* renamed from: c  reason: collision with root package name */
        int f4103c = -1;

        /* renamed from: d  reason: collision with root package name */
        int f4104d = -1;

        /* renamed from: e  reason: collision with root package name */
        long f4105e = -1;

        /* renamed from: f  reason: collision with root package name */
        int f4106f = -1;

        /* renamed from: g  reason: collision with root package name */
        int f4107g = -1;

        /* renamed from: h  reason: collision with root package name */
        d0 f4108h = null;

        /* renamed from: i  reason: collision with root package name */
        d0 f4109i = null;

        /* renamed from: k  reason: collision with root package name */
        List f4111k = null;

        /* renamed from: l  reason: collision with root package name */
        List f4112l = null;

        /* renamed from: m  reason: collision with root package name */
        private int f4113m = 0;

        /* renamed from: n  reason: collision with root package name */
        v f4114n = null;

        /* renamed from: o  reason: collision with root package name */
        boolean f4115o = false;

        /* renamed from: p  reason: collision with root package name */
        private int f4116p = 0;

        /* renamed from: q  reason: collision with root package name */
        int f4117q = -1;

        public d0(View view) {
            if (view == null) {
                throw new IllegalArgumentException("itemView may not be null");
            }
            this.f4101a = view;
        }

        private void g() {
            if (this.f4111k == null) {
                ArrayList arrayList = new ArrayList();
                this.f4111k = arrayList;
                this.f4112l = Collections.unmodifiableList(arrayList);
            }
        }

        void A(int i10, boolean z9) {
            if (this.f4104d == -1) {
                this.f4104d = this.f4103c;
            }
            if (this.f4107g == -1) {
                this.f4107g = this.f4103c;
            }
            if (z9) {
                this.f4107g += i10;
            }
            this.f4103c += i10;
            if (this.f4101a.getLayoutParams() != null) {
                ((p) this.f4101a.getLayoutParams()).f4160c = true;
            }
        }

        void B(RecyclerView recyclerView) {
            int i10 = this.f4117q;
            if (i10 == -1) {
                i10 = r0.z(this.f4101a);
            }
            this.f4116p = i10;
            recyclerView.setChildImportantForAccessibilityInternal(this, 4);
        }

        void C(RecyclerView recyclerView) {
            recyclerView.setChildImportantForAccessibilityInternal(this, this.f4116p);
            this.f4116p = 0;
        }

        void D() {
            this.f4110j = 0;
            this.f4103c = -1;
            this.f4104d = -1;
            this.f4105e = -1L;
            this.f4107g = -1;
            this.f4113m = 0;
            this.f4108h = null;
            this.f4109i = null;
            d();
            this.f4116p = 0;
            this.f4117q = -1;
            RecyclerView.clearNestedRecyclerViewIfNotNested(this);
        }

        void E() {
            if (this.f4104d == -1) {
                this.f4104d = this.f4103c;
            }
        }

        void F(int i10, int i11) {
            this.f4110j = (i10 & i11) | (this.f4110j & (~i11));
        }

        public final void G(boolean z9) {
            int i10;
            int i11 = this.f4113m;
            int i12 = z9 ? i11 - 1 : i11 + 1;
            this.f4113m = i12;
            if (i12 < 0) {
                this.f4113m = 0;
                Log.e("View", "isRecyclable decremented below 0: unmatched pair of setIsRecyable() calls for " + this);
                return;
            }
            if (!z9 && i12 == 1) {
                i10 = this.f4110j | 16;
            } else if (!z9 || i12 != 0) {
                return;
            } else {
                i10 = this.f4110j & (-17);
            }
            this.f4110j = i10;
        }

        void H(v vVar, boolean z9) {
            this.f4114n = vVar;
            this.f4115o = z9;
        }

        boolean I() {
            return (this.f4110j & 16) != 0;
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean J() {
            return (this.f4110j & 128) != 0;
        }

        void K() {
            this.f4114n.J(this);
        }

        boolean L() {
            return (this.f4110j & 32) != 0;
        }

        void a(Object obj) {
            if (obj == null) {
                b(1024);
            } else if ((1024 & this.f4110j) == 0) {
                g();
                this.f4111k.add(obj);
            }
        }

        void b(int i10) {
            this.f4110j = i10 | this.f4110j;
        }

        void c() {
            this.f4104d = -1;
            this.f4107g = -1;
        }

        void d() {
            List list = this.f4111k;
            if (list != null) {
                list.clear();
            }
            this.f4110j &= -1025;
        }

        void e() {
            this.f4110j &= -33;
        }

        void f() {
            this.f4110j &= -257;
        }

        boolean h() {
            return (this.f4110j & 16) == 0 && r0.O(this.f4101a);
        }

        void i(int i10, int i11, boolean z9) {
            b(8);
            A(i11, z9);
            this.f4103c = i10;
        }

        public final int j() {
            RecyclerView recyclerView = this.f4118r;
            if (recyclerView == null) {
                return -1;
            }
            return recyclerView.getAdapterPositionFor(this);
        }

        public final long k() {
            return this.f4105e;
        }

        public final int l() {
            return this.f4106f;
        }

        public final int m() {
            int i10 = this.f4107g;
            return i10 == -1 ? this.f4103c : i10;
        }

        public final int n() {
            return this.f4104d;
        }

        List o() {
            if ((this.f4110j & 1024) == 0) {
                List list = this.f4111k;
                return (list == null || list.size() == 0) ? f4100s : this.f4112l;
            }
            return f4100s;
        }

        boolean p(int i10) {
            return (i10 & this.f4110j) != 0;
        }

        boolean q() {
            return (this.f4110j & 512) != 0 || t();
        }

        boolean r() {
            return (this.f4101a.getParent() == null || this.f4101a.getParent() == this.f4118r) ? false : true;
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean s() {
            return (this.f4110j & 1) != 0;
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean t() {
            return (this.f4110j & 4) != 0;
        }

        public String toString() {
            String simpleName = getClass().isAnonymousClass() ? "ViewHolder" : getClass().getSimpleName();
            StringBuilder sb = new StringBuilder(simpleName + "{" + Integer.toHexString(hashCode()) + " position=" + this.f4103c + " id=" + this.f4105e + ", oldPos=" + this.f4104d + ", pLpos:" + this.f4107g);
            if (w()) {
                sb.append(" scrap ");
                sb.append(this.f4115o ? "[changeScrap]" : "[attachedScrap]");
            }
            if (t()) {
                sb.append(" invalid");
            }
            if (!s()) {
                sb.append(" unbound");
            }
            if (z()) {
                sb.append(" update");
            }
            if (v()) {
                sb.append(" removed");
            }
            if (J()) {
                sb.append(" ignored");
            }
            if (x()) {
                sb.append(" tmpDetached");
            }
            if (!u()) {
                sb.append(" not recyclable(" + this.f4113m + ")");
            }
            if (q()) {
                sb.append(" undefined adapter position");
            }
            if (this.f4101a.getParent() == null) {
                sb.append(" no parent");
            }
            sb.append("}");
            return sb.toString();
        }

        public final boolean u() {
            return (this.f4110j & 16) == 0 && !r0.O(this.f4101a);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean v() {
            return (this.f4110j & 8) != 0;
        }

        boolean w() {
            return this.f4114n != null;
        }

        boolean x() {
            return (this.f4110j & 256) != 0;
        }

        boolean y() {
            return (this.f4110j & 2) != 0;
        }

        boolean z() {
            return (this.f4110j & 2) != 0;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class e implements b.InterfaceC0049b {
        e() {
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public View a(int i10) {
            return RecyclerView.this.getChildAt(i10);
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public void b(View view) {
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt != null) {
                childViewHolderInt.B(RecyclerView.this);
            }
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public int c() {
            return RecyclerView.this.getChildCount();
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public void d() {
            int c10 = c();
            for (int i10 = 0; i10 < c10; i10++) {
                View a10 = a(i10);
                RecyclerView.this.dispatchChildDetached(a10);
                a10.clearAnimation();
            }
            RecyclerView.this.removeAllViews();
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public int e(View view) {
            return RecyclerView.this.indexOfChild(view);
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public d0 f(View view) {
            return RecyclerView.getChildViewHolderInt(view);
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public void g(int i10) {
            d0 childViewHolderInt;
            View a10 = a(i10);
            if (a10 != null && (childViewHolderInt = RecyclerView.getChildViewHolderInt(a10)) != null) {
                if (childViewHolderInt.x() && !childViewHolderInt.J()) {
                    throw new IllegalArgumentException("called detach on an already detached child " + childViewHolderInt + RecyclerView.this.exceptionLabel());
                }
                childViewHolderInt.b(256);
            }
            RecyclerView.this.detachViewFromParent(i10);
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public void h(View view) {
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt != null) {
                childViewHolderInt.C(RecyclerView.this);
            }
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public void i(View view, int i10) {
            RecyclerView.this.addView(view, i10);
            RecyclerView.this.dispatchChildAttached(view);
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public void j(int i10) {
            View childAt = RecyclerView.this.getChildAt(i10);
            if (childAt != null) {
                RecyclerView.this.dispatchChildDetached(childAt);
                childAt.clearAnimation();
            }
            RecyclerView.this.removeViewAt(i10);
        }

        @Override // androidx.recyclerview.widget.b.InterfaceC0049b
        public void k(View view, int i10, ViewGroup.LayoutParams layoutParams) {
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt != null) {
                if (!childViewHolderInt.x() && !childViewHolderInt.J()) {
                    throw new IllegalArgumentException("Called attach on a child which is not detached: " + childViewHolderInt + RecyclerView.this.exceptionLabel());
                }
                childViewHolderInt.f();
            }
            RecyclerView.this.attachViewToParent(view, i10, layoutParams);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class f implements a.InterfaceC0048a {
        f() {
        }

        @Override // androidx.recyclerview.widget.a.InterfaceC0048a
        public void a(int i10, int i11) {
            RecyclerView.this.offsetPositionRecordsForMove(i10, i11);
            RecyclerView.this.mItemsAddedOrRemoved = true;
        }

        @Override // androidx.recyclerview.widget.a.InterfaceC0048a
        public void b(a.b bVar) {
            i(bVar);
        }

        @Override // androidx.recyclerview.widget.a.InterfaceC0048a
        public void c(int i10, int i11, Object obj) {
            RecyclerView.this.viewRangeUpdate(i10, i11, obj);
            RecyclerView.this.mItemsChanged = true;
        }

        @Override // androidx.recyclerview.widget.a.InterfaceC0048a
        public void d(a.b bVar) {
            i(bVar);
        }

        @Override // androidx.recyclerview.widget.a.InterfaceC0048a
        public d0 e(int i10) {
            d0 findViewHolderForPosition = RecyclerView.this.findViewHolderForPosition(i10, true);
            if (findViewHolderForPosition == null || RecyclerView.this.mChildHelper.n(findViewHolderForPosition.f4101a)) {
                return null;
            }
            return findViewHolderForPosition;
        }

        @Override // androidx.recyclerview.widget.a.InterfaceC0048a
        public void f(int i10, int i11) {
            RecyclerView.this.offsetPositionRecordsForRemove(i10, i11, false);
            RecyclerView.this.mItemsAddedOrRemoved = true;
        }

        @Override // androidx.recyclerview.widget.a.InterfaceC0048a
        public void g(int i10, int i11) {
            RecyclerView.this.offsetPositionRecordsForInsert(i10, i11);
            RecyclerView.this.mItemsAddedOrRemoved = true;
        }

        @Override // androidx.recyclerview.widget.a.InterfaceC0048a
        public void h(int i10, int i11) {
            RecyclerView.this.offsetPositionRecordsForRemove(i10, i11, true);
            RecyclerView recyclerView = RecyclerView.this;
            recyclerView.mItemsAddedOrRemoved = true;
            recyclerView.mState.f4077d += i11;
        }

        void i(a.b bVar) {
            int i10 = bVar.f4241a;
            if (i10 == 1) {
                RecyclerView recyclerView = RecyclerView.this;
                recyclerView.mLayout.R0(recyclerView, bVar.f4242b, bVar.f4244d);
            } else if (i10 == 2) {
                RecyclerView recyclerView2 = RecyclerView.this;
                recyclerView2.mLayout.U0(recyclerView2, bVar.f4242b, bVar.f4244d);
            } else if (i10 == 4) {
                RecyclerView recyclerView3 = RecyclerView.this;
                recyclerView3.mLayout.W0(recyclerView3, bVar.f4242b, bVar.f4244d, bVar.f4243c);
            } else if (i10 != 8) {
            } else {
                RecyclerView recyclerView4 = RecyclerView.this;
                recyclerView4.mLayout.T0(recyclerView4, bVar.f4242b, bVar.f4244d, 1);
            }
        }
    }

    /* loaded from: classes.dex */
    public static abstract class g {

        /* renamed from: a  reason: collision with root package name */
        private final h f4121a = new h();

        /* renamed from: b  reason: collision with root package name */
        private boolean f4122b = false;

        public final void a(d0 d0Var, int i10) {
            d0Var.f4103c = i10;
            if (g()) {
                d0Var.f4105e = d(i10);
            }
            d0Var.F(1, 519);
            androidx.core.os.l.a(RecyclerView.TRACE_BIND_VIEW_TAG);
            k(d0Var, i10, d0Var.o());
            d0Var.d();
            ViewGroup.LayoutParams layoutParams = d0Var.f4101a.getLayoutParams();
            if (layoutParams instanceof p) {
                ((p) layoutParams).f4160c = true;
            }
            androidx.core.os.l.b();
        }

        public final d0 b(ViewGroup viewGroup, int i10) {
            try {
                androidx.core.os.l.a(RecyclerView.TRACE_CREATE_VIEW_TAG);
                d0 l10 = l(viewGroup, i10);
                if (l10.f4101a.getParent() == null) {
                    l10.f4106f = i10;
                    return l10;
                }
                throw new IllegalStateException("ViewHolder views must not be attached when created. Ensure that you are not passing 'true' to the attachToRoot parameter of LayoutInflater.inflate(..., boolean attachToRoot)");
            } finally {
                androidx.core.os.l.b();
            }
        }

        public abstract int c();

        public long d(int i10) {
            return -1L;
        }

        public int e(int i10) {
            return 0;
        }

        public final boolean f() {
            return this.f4121a.a();
        }

        public final boolean g() {
            return this.f4122b;
        }

        public final void h() {
            this.f4121a.b();
        }

        public void i(RecyclerView recyclerView) {
        }

        public abstract void j(d0 d0Var, int i10);

        public void k(d0 d0Var, int i10, List list) {
            j(d0Var, i10);
        }

        public abstract d0 l(ViewGroup viewGroup, int i10);

        public void m(RecyclerView recyclerView) {
        }

        public boolean n(d0 d0Var) {
            return false;
        }

        public void o(d0 d0Var) {
        }

        public void p(d0 d0Var) {
        }

        public void q(d0 d0Var) {
        }

        public void r(i iVar) {
            this.f4121a.registerObserver(iVar);
        }

        public void s(boolean z9) {
            if (f()) {
                throw new IllegalStateException("Cannot change whether this adapter has stable IDs while the adapter has registered observers.");
            }
            this.f4122b = z9;
        }

        public void t(i iVar) {
            this.f4121a.unregisterObserver(iVar);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class h extends Observable {
        h() {
        }

        public boolean a() {
            return !((Observable) this).mObservers.isEmpty();
        }

        public void b() {
            for (int size = ((Observable) this).mObservers.size() - 1; size >= 0; size--) {
                ((i) ((Observable) this).mObservers.get(size)).a();
            }
        }
    }

    /* loaded from: classes.dex */
    public static abstract class i {
        public abstract void a();
    }

    /* loaded from: classes.dex */
    public interface j {
        int a(int i10, int i11);
    }

    /* loaded from: classes.dex */
    public static class k {
        protected EdgeEffect a(RecyclerView recyclerView, int i10) {
            return new EdgeEffect(recyclerView.getContext());
        }
    }

    /* loaded from: classes.dex */
    public static abstract class l {

        /* renamed from: a  reason: collision with root package name */
        private b f4123a = null;

        /* renamed from: b  reason: collision with root package name */
        private ArrayList f4124b = new ArrayList();

        /* renamed from: c  reason: collision with root package name */
        private long f4125c = 120;

        /* renamed from: d  reason: collision with root package name */
        private long f4126d = 120;

        /* renamed from: e  reason: collision with root package name */
        private long f4127e = 250;

        /* renamed from: f  reason: collision with root package name */
        private long f4128f = 250;

        /* loaded from: classes.dex */
        public interface a {
            void a();
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public interface b {
            void a(d0 d0Var);
        }

        /* loaded from: classes.dex */
        public static class c {

            /* renamed from: a  reason: collision with root package name */
            public int f4129a;

            /* renamed from: b  reason: collision with root package name */
            public int f4130b;

            /* renamed from: c  reason: collision with root package name */
            public int f4131c;

            /* renamed from: d  reason: collision with root package name */
            public int f4132d;

            public c a(d0 d0Var) {
                return b(d0Var, 0);
            }

            public c b(d0 d0Var, int i10) {
                View view = d0Var.f4101a;
                this.f4129a = view.getLeft();
                this.f4130b = view.getTop();
                this.f4131c = view.getRight();
                this.f4132d = view.getBottom();
                return this;
            }
        }

        static int e(d0 d0Var) {
            int i10 = d0Var.f4110j & 14;
            if (d0Var.t()) {
                return 4;
            }
            if ((i10 & 4) == 0) {
                int n10 = d0Var.n();
                int j10 = d0Var.j();
                return (n10 == -1 || j10 == -1 || n10 == j10) ? i10 : i10 | 2048;
            }
            return i10;
        }

        public abstract boolean a(d0 d0Var, c cVar, c cVar2);

        public abstract boolean b(d0 d0Var, d0 d0Var2, c cVar, c cVar2);

        public abstract boolean c(d0 d0Var, c cVar, c cVar2);

        public abstract boolean d(d0 d0Var, c cVar, c cVar2);

        public abstract boolean f(d0 d0Var);

        public boolean g(d0 d0Var, List list) {
            return f(d0Var);
        }

        public final void h(d0 d0Var) {
            r(d0Var);
            b bVar = this.f4123a;
            if (bVar != null) {
                bVar.a(d0Var);
            }
        }

        public final void i() {
            int size = this.f4124b.size();
            for (int i10 = 0; i10 < size; i10++) {
                ((a) this.f4124b.get(i10)).a();
            }
            this.f4124b.clear();
        }

        public abstract void j(d0 d0Var);

        public abstract void k();

        public long l() {
            return this.f4125c;
        }

        public long m() {
            return this.f4128f;
        }

        public long n() {
            return this.f4127e;
        }

        public long o() {
            return this.f4126d;
        }

        public abstract boolean p();

        public c q() {
            return new c();
        }

        public void r(d0 d0Var) {
        }

        public c s(a0 a0Var, d0 d0Var) {
            return q().a(d0Var);
        }

        public c t(a0 a0Var, d0 d0Var, int i10, List list) {
            return q().a(d0Var);
        }

        public abstract void u();

        void v(b bVar) {
            this.f4123a = bVar;
        }
    }

    /* loaded from: classes.dex */
    private class m implements l.b {
        m() {
        }

        @Override // androidx.recyclerview.widget.RecyclerView.l.b
        public void a(d0 d0Var) {
            d0Var.G(true);
            if (d0Var.f4108h != null && d0Var.f4109i == null) {
                d0Var.f4108h = null;
            }
            d0Var.f4109i = null;
            if (d0Var.I() || RecyclerView.this.removeAnimatingView(d0Var.f4101a) || !d0Var.x()) {
                return;
            }
            RecyclerView.this.removeDetachedView(d0Var.f4101a, false);
        }
    }

    /* loaded from: classes.dex */
    public static abstract class n {
        public void d(Rect rect, int i10, RecyclerView recyclerView) {
            rect.set(0, 0, 0, 0);
        }

        public void e(Rect rect, View view, RecyclerView recyclerView, a0 a0Var) {
            d(rect, ((p) view.getLayoutParams()).a(), recyclerView);
        }

        public void f(Canvas canvas, RecyclerView recyclerView) {
        }

        public void g(Canvas canvas, RecyclerView recyclerView, a0 a0Var) {
            f(canvas, recyclerView);
        }

        public void h(Canvas canvas, RecyclerView recyclerView) {
        }

        public void i(Canvas canvas, RecyclerView recyclerView, a0 a0Var) {
            h(canvas, recyclerView);
        }
    }

    /* loaded from: classes.dex */
    public static abstract class o {

        /* renamed from: a  reason: collision with root package name */
        androidx.recyclerview.widget.b f4134a;

        /* renamed from: b  reason: collision with root package name */
        RecyclerView f4135b;

        /* renamed from: c  reason: collision with root package name */
        private final o.b f4136c;

        /* renamed from: d  reason: collision with root package name */
        private final o.b f4137d;

        /* renamed from: e  reason: collision with root package name */
        androidx.recyclerview.widget.o f4138e;

        /* renamed from: f  reason: collision with root package name */
        androidx.recyclerview.widget.o f4139f;

        /* renamed from: g  reason: collision with root package name */
        z f4140g;

        /* renamed from: h  reason: collision with root package name */
        boolean f4141h;

        /* renamed from: i  reason: collision with root package name */
        boolean f4142i;

        /* renamed from: j  reason: collision with root package name */
        boolean f4143j;

        /* renamed from: k  reason: collision with root package name */
        private boolean f4144k;

        /* renamed from: l  reason: collision with root package name */
        private boolean f4145l;

        /* renamed from: m  reason: collision with root package name */
        int f4146m;

        /* renamed from: n  reason: collision with root package name */
        boolean f4147n;

        /* renamed from: o  reason: collision with root package name */
        private int f4148o;

        /* renamed from: p  reason: collision with root package name */
        private int f4149p;

        /* renamed from: q  reason: collision with root package name */
        private int f4150q;

        /* renamed from: r  reason: collision with root package name */
        private int f4151r;

        /* loaded from: classes.dex */
        class a implements o.b {
            a() {
            }

            @Override // androidx.recyclerview.widget.o.b
            public View a(int i10) {
                return o.this.I(i10);
            }

            @Override // androidx.recyclerview.widget.o.b
            public int b(View view) {
                return o.this.Q(view) - ((ViewGroup.MarginLayoutParams) ((p) view.getLayoutParams())).leftMargin;
            }

            @Override // androidx.recyclerview.widget.o.b
            public int c() {
                return o.this.e0();
            }

            @Override // androidx.recyclerview.widget.o.b
            public int d() {
                return o.this.o0() - o.this.f0();
            }

            @Override // androidx.recyclerview.widget.o.b
            public int e(View view) {
                return o.this.T(view) + ((ViewGroup.MarginLayoutParams) ((p) view.getLayoutParams())).rightMargin;
            }
        }

        /* loaded from: classes.dex */
        class b implements o.b {
            b() {
            }

            @Override // androidx.recyclerview.widget.o.b
            public View a(int i10) {
                return o.this.I(i10);
            }

            @Override // androidx.recyclerview.widget.o.b
            public int b(View view) {
                return o.this.U(view) - ((ViewGroup.MarginLayoutParams) ((p) view.getLayoutParams())).topMargin;
            }

            @Override // androidx.recyclerview.widget.o.b
            public int c() {
                return o.this.g0();
            }

            @Override // androidx.recyclerview.widget.o.b
            public int d() {
                return o.this.W() - o.this.d0();
            }

            @Override // androidx.recyclerview.widget.o.b
            public int e(View view) {
                return o.this.O(view) + ((ViewGroup.MarginLayoutParams) ((p) view.getLayoutParams())).bottomMargin;
            }
        }

        /* loaded from: classes.dex */
        public interface c {
            void a(int i10, int i11);
        }

        /* loaded from: classes.dex */
        public static class d {

            /* renamed from: a  reason: collision with root package name */
            public int f4154a;

            /* renamed from: b  reason: collision with root package name */
            public int f4155b;

            /* renamed from: c  reason: collision with root package name */
            public boolean f4156c;

            /* renamed from: d  reason: collision with root package name */
            public boolean f4157d;
        }

        public o() {
            a aVar = new a();
            this.f4136c = aVar;
            b bVar = new b();
            this.f4137d = bVar;
            this.f4138e = new androidx.recyclerview.widget.o(aVar);
            this.f4139f = new androidx.recyclerview.widget.o(bVar);
            this.f4141h = false;
            this.f4142i = false;
            this.f4143j = false;
            this.f4144k = true;
            this.f4145l = true;
        }

        /* JADX WARN: Code restructure failed: missing block: B:9:0x0017, code lost:
            if (r5 == 1073741824) goto L8;
         */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        public static int K(int i10, int i11, int i12, int i13, boolean z9) {
            int max = Math.max(0, i10 - i12);
            if (z9) {
                if (i13 < 0) {
                    if (i13 == -1) {
                        if (i11 != Integer.MIN_VALUE) {
                            if (i11 != 0) {
                            }
                        }
                        i13 = max;
                    }
                    i11 = 0;
                    i13 = 0;
                }
                i11 = 1073741824;
            } else {
                if (i13 < 0) {
                    if (i13 != -1) {
                        if (i13 == -2) {
                            i11 = (i11 == Integer.MIN_VALUE || i11 == 1073741824) ? RecyclerView.UNDEFINED_DURATION : 0;
                        }
                        i11 = 0;
                        i13 = 0;
                    }
                    i13 = max;
                }
                i11 = 1073741824;
            }
            return View.MeasureSpec.makeMeasureSpec(i13, i11);
        }

        private int[] L(View view, Rect rect) {
            int[] iArr = new int[2];
            int e02 = e0();
            int g02 = g0();
            int o02 = o0() - f0();
            int W = W() - d0();
            int left = (view.getLeft() + rect.left) - view.getScrollX();
            int top = (view.getTop() + rect.top) - view.getScrollY();
            int width = rect.width() + left;
            int height = rect.height() + top;
            int i10 = left - e02;
            int min = Math.min(0, i10);
            int i11 = top - g02;
            int min2 = Math.min(0, i11);
            int i12 = width - o02;
            int max = Math.max(0, i12);
            int max2 = Math.max(0, height - W);
            if (Z() != 1) {
                if (min == 0) {
                    min = Math.min(i10, max);
                }
                max = min;
            } else if (max == 0) {
                max = Math.max(min, i12);
            }
            if (min2 == 0) {
                min2 = Math.min(i11, max2);
            }
            iArr[0] = max;
            iArr[1] = min2;
            return iArr;
        }

        private void f(View view, int i10, boolean z9) {
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (z9 || childViewHolderInt.v()) {
                this.f4135b.mViewInfoStore.b(childViewHolderInt);
            } else {
                this.f4135b.mViewInfoStore.p(childViewHolderInt);
            }
            p pVar = (p) view.getLayoutParams();
            if (childViewHolderInt.L() || childViewHolderInt.w()) {
                if (childViewHolderInt.w()) {
                    childViewHolderInt.K();
                } else {
                    childViewHolderInt.e();
                }
                this.f4134a.c(view, i10, view.getLayoutParams(), false);
            } else if (view.getParent() == this.f4135b) {
                int m10 = this.f4134a.m(view);
                if (i10 == -1) {
                    i10 = this.f4134a.g();
                }
                if (m10 == -1) {
                    throw new IllegalStateException("Added View has RecyclerView as parent but view is not a real child. Unfiltered index:" + this.f4135b.indexOfChild(view) + this.f4135b.exceptionLabel());
                } else if (m10 != i10) {
                    this.f4135b.mLayout.B0(m10, i10);
                }
            } else {
                this.f4134a.a(view, i10, false);
                pVar.f4160c = true;
                z zVar = this.f4140g;
                if (zVar != null && zVar.h()) {
                    this.f4140g.k(view);
                }
            }
            if (pVar.f4161d) {
                childViewHolderInt.f4101a.invalidate();
                pVar.f4161d = false;
            }
        }

        public static d i0(Context context, AttributeSet attributeSet, int i10, int i11) {
            d dVar = new d();
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, d3.c.f6845f, i10, i11);
            dVar.f4154a = obtainStyledAttributes.getInt(d3.c.f6846g, 1);
            dVar.f4155b = obtainStyledAttributes.getInt(d3.c.f6856q, 1);
            dVar.f4156c = obtainStyledAttributes.getBoolean(d3.c.f6855p, false);
            dVar.f4157d = obtainStyledAttributes.getBoolean(d3.c.f6857r, false);
            obtainStyledAttributes.recycle();
            return dVar;
        }

        public static int n(int i10, int i11, int i12) {
            int mode = View.MeasureSpec.getMode(i10);
            int size = View.MeasureSpec.getSize(i10);
            return mode != Integer.MIN_VALUE ? mode != 1073741824 ? Math.max(i11, i12) : size : Math.min(size, Math.max(i11, i12));
        }

        private boolean t0(RecyclerView recyclerView, int i10, int i11) {
            View focusedChild = recyclerView.getFocusedChild();
            if (focusedChild == null) {
                return false;
            }
            int e02 = e0();
            int g02 = g0();
            int o02 = o0() - f0();
            int W = W() - d0();
            Rect rect = this.f4135b.mTempRect;
            P(focusedChild, rect);
            return rect.left - i10 < o02 && rect.right - i10 > e02 && rect.top - i11 < W && rect.bottom - i11 > g02;
        }

        private void v1(v vVar, int i10, View view) {
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt.J()) {
                return;
            }
            if (childViewHolderInt.t() && !childViewHolderInt.v() && !this.f4135b.mAdapter.g()) {
                q1(i10);
                vVar.C(childViewHolderInt);
                return;
            }
            x(i10);
            vVar.D(view);
            this.f4135b.mViewInfoStore.k(childViewHolderInt);
        }

        private static boolean w0(int i10, int i11, int i12) {
            int mode = View.MeasureSpec.getMode(i11);
            int size = View.MeasureSpec.getSize(i11);
            if (i12 <= 0 || i10 == i12) {
                if (mode == Integer.MIN_VALUE) {
                    return size >= i10;
                } else if (mode != 0) {
                    return mode == 1073741824 && size == i10;
                } else {
                    return true;
                }
            }
            return false;
        }

        private void y(int i10, View view) {
            this.f4134a.d(i10);
        }

        void A(RecyclerView recyclerView, v vVar) {
            this.f4142i = false;
            I0(recyclerView, vVar);
        }

        public void A0(View view, int i10, int i11) {
            p pVar = (p) view.getLayoutParams();
            Rect itemDecorInsetsForChild = this.f4135b.getItemDecorInsetsForChild(view);
            int i12 = i10 + itemDecorInsetsForChild.left + itemDecorInsetsForChild.right;
            int i13 = i11 + itemDecorInsetsForChild.top + itemDecorInsetsForChild.bottom;
            int K = K(o0(), p0(), e0() + f0() + ((ViewGroup.MarginLayoutParams) pVar).leftMargin + ((ViewGroup.MarginLayoutParams) pVar).rightMargin + i12, ((ViewGroup.MarginLayoutParams) pVar).width, k());
            int K2 = K(W(), X(), g0() + d0() + ((ViewGroup.MarginLayoutParams) pVar).topMargin + ((ViewGroup.MarginLayoutParams) pVar).bottomMargin + i13, ((ViewGroup.MarginLayoutParams) pVar).height, l());
            if (F1(view, K, K2, pVar)) {
                view.measure(K, K2);
            }
        }

        void A1(int i10, int i11) {
            this.f4150q = View.MeasureSpec.getSize(i10);
            int mode = View.MeasureSpec.getMode(i10);
            this.f4148o = mode;
            if (mode == 0 && !RecyclerView.ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.f4150q = 0;
            }
            this.f4151r = View.MeasureSpec.getSize(i11);
            int mode2 = View.MeasureSpec.getMode(i11);
            this.f4149p = mode2;
            if (mode2 != 0 || RecyclerView.ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                return;
            }
            this.f4151r = 0;
        }

        public View B(View view) {
            View findContainingItemView;
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView == null || (findContainingItemView = recyclerView.findContainingItemView(view)) == null || this.f4134a.n(findContainingItemView)) {
                return null;
            }
            return findContainingItemView;
        }

        public void B0(int i10, int i11) {
            View I = I(i10);
            if (I != null) {
                x(i10);
                h(I, i11);
                return;
            }
            throw new IllegalArgumentException("Cannot move a child from non-existing index:" + i10 + this.f4135b.toString());
        }

        public void B1(int i10, int i11) {
            this.f4135b.setMeasuredDimension(i10, i11);
        }

        public View C(int i10) {
            int J = J();
            for (int i11 = 0; i11 < J; i11++) {
                View I = I(i11);
                d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(I);
                if (childViewHolderInt != null && childViewHolderInt.m() == i10 && !childViewHolderInt.J() && (this.f4135b.mState.e() || !childViewHolderInt.v())) {
                    return I;
                }
            }
            return null;
        }

        public void C0(int i10) {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView != null) {
                recyclerView.offsetChildrenHorizontal(i10);
            }
        }

        public void C1(Rect rect, int i10, int i11) {
            B1(n(i10, rect.width() + e0() + f0(), c0()), n(i11, rect.height() + g0() + d0(), b0()));
        }

        public abstract p D();

        public void D0(int i10) {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView != null) {
                recyclerView.offsetChildrenVertical(i10);
            }
        }

        void D1(int i10, int i11) {
            int J = J();
            if (J == 0) {
                this.f4135b.defaultOnMeasure(i10, i11);
                return;
            }
            int i12 = RecyclerView.UNDEFINED_DURATION;
            int i13 = RecyclerView.UNDEFINED_DURATION;
            int i14 = Integer.MAX_VALUE;
            int i15 = Integer.MAX_VALUE;
            for (int i16 = 0; i16 < J; i16++) {
                View I = I(i16);
                Rect rect = this.f4135b.mTempRect;
                P(I, rect);
                int i17 = rect.left;
                if (i17 < i14) {
                    i14 = i17;
                }
                int i18 = rect.right;
                if (i18 > i12) {
                    i12 = i18;
                }
                int i19 = rect.top;
                if (i19 < i15) {
                    i15 = i19;
                }
                int i20 = rect.bottom;
                if (i20 > i13) {
                    i13 = i20;
                }
            }
            this.f4135b.mTempRect.set(i14, i15, i12, i13);
            C1(this.f4135b.mTempRect, i10, i11);
        }

        public p E(Context context, AttributeSet attributeSet) {
            return new p(context, attributeSet);
        }

        public void E0(g gVar, g gVar2) {
        }

        void E1(RecyclerView recyclerView) {
            int height;
            if (recyclerView == null) {
                this.f4135b = null;
                this.f4134a = null;
                height = 0;
                this.f4150q = 0;
            } else {
                this.f4135b = recyclerView;
                this.f4134a = recyclerView.mChildHelper;
                this.f4150q = recyclerView.getWidth();
                height = recyclerView.getHeight();
            }
            this.f4151r = height;
            this.f4148o = 1073741824;
            this.f4149p = 1073741824;
        }

        public p F(ViewGroup.LayoutParams layoutParams) {
            return layoutParams instanceof p ? new p((p) layoutParams) : layoutParams instanceof ViewGroup.MarginLayoutParams ? new p((ViewGroup.MarginLayoutParams) layoutParams) : new p(layoutParams);
        }

        public boolean F0(RecyclerView recyclerView, ArrayList arrayList, int i10, int i11) {
            return false;
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean F1(View view, int i10, int i11, p pVar) {
            return (!view.isLayoutRequested() && this.f4144k && w0(view.getWidth(), i10, ((ViewGroup.MarginLayoutParams) pVar).width) && w0(view.getHeight(), i11, ((ViewGroup.MarginLayoutParams) pVar).height)) ? false : true;
        }

        public int G() {
            return -1;
        }

        public void G0(RecyclerView recyclerView) {
        }

        boolean G1() {
            return false;
        }

        public int H(View view) {
            return ((p) view.getLayoutParams()).f4159b.bottom;
        }

        public void H0(RecyclerView recyclerView) {
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean H1(View view, int i10, int i11, p pVar) {
            return (this.f4144k && w0(view.getMeasuredWidth(), i10, ((ViewGroup.MarginLayoutParams) pVar).width) && w0(view.getMeasuredHeight(), i11, ((ViewGroup.MarginLayoutParams) pVar).height)) ? false : true;
        }

        public View I(int i10) {
            androidx.recyclerview.widget.b bVar = this.f4134a;
            if (bVar != null) {
                return bVar.f(i10);
            }
            return null;
        }

        public void I0(RecyclerView recyclerView, v vVar) {
            H0(recyclerView);
        }

        public abstract void I1(RecyclerView recyclerView, a0 a0Var, int i10);

        public int J() {
            androidx.recyclerview.widget.b bVar = this.f4134a;
            if (bVar != null) {
                return bVar.g();
            }
            return 0;
        }

        public abstract View J0(View view, int i10, v vVar, a0 a0Var);

        public void J1(z zVar) {
            z zVar2 = this.f4140g;
            if (zVar2 != null && zVar != zVar2 && zVar2.h()) {
                this.f4140g.r();
            }
            this.f4140g = zVar;
            zVar.q(this.f4135b, this);
        }

        public void K0(AccessibilityEvent accessibilityEvent) {
            RecyclerView recyclerView = this.f4135b;
            L0(recyclerView.mRecycler, recyclerView.mState, accessibilityEvent);
        }

        void K1() {
            z zVar = this.f4140g;
            if (zVar != null) {
                zVar.r();
            }
        }

        public void L0(v vVar, a0 a0Var, AccessibilityEvent accessibilityEvent) {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView == null || accessibilityEvent == null) {
                return;
            }
            boolean z9 = true;
            if (!recyclerView.canScrollVertically(1) && !this.f4135b.canScrollVertically(-1) && !this.f4135b.canScrollHorizontally(-1) && !this.f4135b.canScrollHorizontally(1)) {
                z9 = false;
            }
            accessibilityEvent.setScrollable(z9);
            g gVar = this.f4135b.mAdapter;
            if (gVar != null) {
                accessibilityEvent.setItemCount(gVar.c());
            }
        }

        public abstract boolean L1();

        public boolean M() {
            RecyclerView recyclerView = this.f4135b;
            return recyclerView != null && recyclerView.mClipToPadding;
        }

        public void M0(v vVar, a0 a0Var, w.l lVar) {
            if (this.f4135b.canScrollVertically(-1) || this.f4135b.canScrollHorizontally(-1)) {
                lVar.a(8192);
                lVar.A0(true);
            }
            if (this.f4135b.canScrollVertically(1) || this.f4135b.canScrollHorizontally(1)) {
                lVar.a(4096);
                lVar.A0(true);
            }
            lVar.l0(l.e.a(k0(vVar, a0Var), N(vVar, a0Var), v0(vVar, a0Var), l0(vVar, a0Var)));
        }

        public int N(v vVar, a0 a0Var) {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView == null || recyclerView.mAdapter == null || !k()) {
                return 1;
            }
            return this.f4135b.mAdapter.c();
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public void N0(w.l lVar) {
            RecyclerView recyclerView = this.f4135b;
            M0(recyclerView.mRecycler, recyclerView.mState, lVar);
        }

        public int O(View view) {
            return view.getBottom() + H(view);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public void O0(View view, w.l lVar) {
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt == null || childViewHolderInt.v() || this.f4134a.n(childViewHolderInt.f4101a)) {
                return;
            }
            RecyclerView recyclerView = this.f4135b;
            P0(recyclerView.mRecycler, recyclerView.mState, view, lVar);
        }

        public void P(View view, Rect rect) {
            RecyclerView.getDecoratedBoundsWithMarginsInt(view, rect);
        }

        public void P0(v vVar, a0 a0Var, View view, w.l lVar) {
            lVar.m0(l.f.a(l() ? h0(view) : 0, 1, k() ? h0(view) : 0, 1, false, false));
        }

        public int Q(View view) {
            return view.getLeft() - a0(view);
        }

        public View Q0(View view, int i10) {
            return null;
        }

        public int R(View view) {
            Rect rect = ((p) view.getLayoutParams()).f4159b;
            return view.getMeasuredHeight() + rect.top + rect.bottom;
        }

        public void R0(RecyclerView recyclerView, int i10, int i11) {
        }

        public int S(View view) {
            Rect rect = ((p) view.getLayoutParams()).f4159b;
            return view.getMeasuredWidth() + rect.left + rect.right;
        }

        public void S0(RecyclerView recyclerView) {
        }

        public int T(View view) {
            return view.getRight() + j0(view);
        }

        public void T0(RecyclerView recyclerView, int i10, int i11, int i12) {
        }

        public int U(View view) {
            return view.getTop() - m0(view);
        }

        public void U0(RecyclerView recyclerView, int i10, int i11) {
        }

        public View V() {
            View focusedChild;
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView == null || (focusedChild = recyclerView.getFocusedChild()) == null || this.f4134a.n(focusedChild)) {
                return null;
            }
            return focusedChild;
        }

        public void V0(RecyclerView recyclerView, int i10, int i11) {
        }

        public int W() {
            return this.f4151r;
        }

        public void W0(RecyclerView recyclerView, int i10, int i11, Object obj) {
            V0(recyclerView, i10, i11);
        }

        public int X() {
            return this.f4149p;
        }

        public abstract void X0(v vVar, a0 a0Var);

        public int Y() {
            RecyclerView recyclerView = this.f4135b;
            g adapter = recyclerView != null ? recyclerView.getAdapter() : null;
            if (adapter != null) {
                return adapter.c();
            }
            return 0;
        }

        public void Y0(a0 a0Var) {
        }

        public int Z() {
            return r0.B(this.f4135b);
        }

        public void Z0(v vVar, a0 a0Var, int i10, int i11) {
            this.f4135b.defaultOnMeasure(i10, i11);
        }

        public int a0(View view) {
            return ((p) view.getLayoutParams()).f4159b.left;
        }

        public boolean a1(RecyclerView recyclerView, View view, View view2) {
            return x0() || recyclerView.isComputingLayout();
        }

        public void b(View view) {
            c(view, -1);
        }

        public int b0() {
            return r0.C(this.f4135b);
        }

        public boolean b1(RecyclerView recyclerView, a0 a0Var, View view, View view2) {
            return a1(recyclerView, view, view2);
        }

        public void c(View view, int i10) {
            f(view, i10, true);
        }

        public int c0() {
            return r0.D(this.f4135b);
        }

        public abstract void c1(Parcelable parcelable);

        public void d(View view) {
            e(view, -1);
        }

        public int d0() {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView != null) {
                return recyclerView.getPaddingBottom();
            }
            return 0;
        }

        public abstract Parcelable d1();

        public void e(View view, int i10) {
            f(view, i10, false);
        }

        public int e0() {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView != null) {
                return recyclerView.getPaddingLeft();
            }
            return 0;
        }

        public void e1(int i10) {
        }

        public int f0() {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView != null) {
                return recyclerView.getPaddingRight();
            }
            return 0;
        }

        void f1(z zVar) {
            if (this.f4140g == zVar) {
                this.f4140g = null;
            }
        }

        public void g(String str) {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView != null) {
                recyclerView.assertNotInLayoutOrScroll(str);
            }
        }

        public int g0() {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView != null) {
                return recyclerView.getPaddingTop();
            }
            return 0;
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean g1(int i10, Bundle bundle) {
            RecyclerView recyclerView = this.f4135b;
            return h1(recyclerView.mRecycler, recyclerView.mState, i10, bundle);
        }

        public void h(View view, int i10) {
            i(view, i10, (p) view.getLayoutParams());
        }

        public int h0(View view) {
            return ((p) view.getLayoutParams()).a();
        }

        public boolean h1(v vVar, a0 a0Var, int i10, Bundle bundle) {
            int W;
            int o02;
            int i11;
            int i12;
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView == null) {
                return false;
            }
            if (i10 == 4096) {
                W = recyclerView.canScrollVertically(1) ? (W() - g0()) - d0() : 0;
                if (this.f4135b.canScrollHorizontally(1)) {
                    o02 = (o0() - e0()) - f0();
                    i11 = W;
                    i12 = o02;
                }
                i11 = W;
                i12 = 0;
            } else if (i10 != 8192) {
                i12 = 0;
                i11 = 0;
            } else {
                W = recyclerView.canScrollVertically(-1) ? -((W() - g0()) - d0()) : 0;
                if (this.f4135b.canScrollHorizontally(-1)) {
                    o02 = -((o0() - e0()) - f0());
                    i11 = W;
                    i12 = o02;
                }
                i11 = W;
                i12 = 0;
            }
            if (i11 == 0 && i12 == 0) {
                return false;
            }
            this.f4135b.smoothScrollBy(i12, i11, null, RecyclerView.UNDEFINED_DURATION, true);
            return true;
        }

        public void i(View view, int i10, p pVar) {
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt.v()) {
                this.f4135b.mViewInfoStore.b(childViewHolderInt);
            } else {
                this.f4135b.mViewInfoStore.p(childViewHolderInt);
            }
            this.f4134a.c(view, i10, pVar, childViewHolderInt.v());
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean i1(View view, int i10, Bundle bundle) {
            RecyclerView recyclerView = this.f4135b;
            return j1(recyclerView.mRecycler, recyclerView.mState, view, i10, bundle);
        }

        public void j(View view, Rect rect) {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView == null) {
                rect.set(0, 0, 0, 0);
            } else {
                rect.set(recyclerView.getItemDecorInsetsForChild(view));
            }
        }

        public int j0(View view) {
            return ((p) view.getLayoutParams()).f4159b.right;
        }

        public boolean j1(v vVar, a0 a0Var, View view, int i10, Bundle bundle) {
            return false;
        }

        public abstract boolean k();

        public int k0(v vVar, a0 a0Var) {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView == null || recyclerView.mAdapter == null || !l()) {
                return 1;
            }
            return this.f4135b.mAdapter.c();
        }

        public void k1(v vVar) {
            for (int J = J() - 1; J >= 0; J--) {
                if (!RecyclerView.getChildViewHolderInt(I(J)).J()) {
                    n1(J, vVar);
                }
            }
        }

        public abstract boolean l();

        public int l0(v vVar, a0 a0Var) {
            return 0;
        }

        void l1(v vVar) {
            int j10 = vVar.j();
            for (int i10 = j10 - 1; i10 >= 0; i10--) {
                View n10 = vVar.n(i10);
                d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(n10);
                if (!childViewHolderInt.J()) {
                    childViewHolderInt.G(false);
                    if (childViewHolderInt.x()) {
                        this.f4135b.removeDetachedView(n10, false);
                    }
                    l lVar = this.f4135b.mItemAnimator;
                    if (lVar != null) {
                        lVar.j(childViewHolderInt);
                    }
                    childViewHolderInt.G(true);
                    vVar.y(n10);
                }
            }
            vVar.e();
            if (j10 > 0) {
                this.f4135b.invalidate();
            }
        }

        public boolean m(p pVar) {
            return pVar != null;
        }

        public int m0(View view) {
            return ((p) view.getLayoutParams()).f4159b.top;
        }

        public void m1(View view, v vVar) {
            p1(view);
            vVar.B(view);
        }

        public void n0(View view, boolean z9, Rect rect) {
            Matrix matrix;
            if (z9) {
                Rect rect2 = ((p) view.getLayoutParams()).f4159b;
                rect.set(-rect2.left, -rect2.top, view.getWidth() + rect2.right, view.getHeight() + rect2.bottom);
            } else {
                rect.set(0, 0, view.getWidth(), view.getHeight());
            }
            if (this.f4135b != null && (matrix = view.getMatrix()) != null && !matrix.isIdentity()) {
                RectF rectF = this.f4135b.mTempRectF;
                rectF.set(rect);
                matrix.mapRect(rectF);
                rect.set((int) Math.floor(rectF.left), (int) Math.floor(rectF.top), (int) Math.ceil(rectF.right), (int) Math.ceil(rectF.bottom));
            }
            rect.offset(view.getLeft(), view.getTop());
        }

        public void n1(int i10, v vVar) {
            View I = I(i10);
            q1(i10);
            vVar.B(I);
        }

        public abstract void o(int i10, int i11, a0 a0Var, c cVar);

        public int o0() {
            return this.f4150q;
        }

        public boolean o1(Runnable runnable) {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView != null) {
                return recyclerView.removeCallbacks(runnable);
            }
            return false;
        }

        public void p(int i10, c cVar) {
        }

        public int p0() {
            return this.f4148o;
        }

        public void p1(View view) {
            this.f4134a.p(view);
        }

        public abstract int q(a0 a0Var);

        /* JADX INFO: Access modifiers changed from: package-private */
        public boolean q0() {
            int J = J();
            for (int i10 = 0; i10 < J; i10++) {
                ViewGroup.LayoutParams layoutParams = I(i10).getLayoutParams();
                if (layoutParams.width < 0 && layoutParams.height < 0) {
                    return true;
                }
            }
            return false;
        }

        public void q1(int i10) {
            if (I(i10) != null) {
                this.f4134a.q(i10);
            }
        }

        public abstract int r(a0 a0Var);

        public boolean r0() {
            return this.f4142i;
        }

        public boolean r1(RecyclerView recyclerView, View view, Rect rect, boolean z9) {
            return s1(recyclerView, view, rect, z9, false);
        }

        public abstract int s(a0 a0Var);

        public abstract boolean s0();

        public boolean s1(RecyclerView recyclerView, View view, Rect rect, boolean z9, boolean z10) {
            int[] L = L(view, rect);
            int i10 = L[0];
            int i11 = L[1];
            if ((!z10 || t0(recyclerView, i10, i11)) && !(i10 == 0 && i11 == 0)) {
                if (z9) {
                    recyclerView.scrollBy(i10, i11);
                } else {
                    recyclerView.smoothScrollBy(i10, i11);
                }
                return true;
            }
            return false;
        }

        public abstract int t(a0 a0Var);

        public void t1() {
            RecyclerView recyclerView = this.f4135b;
            if (recyclerView != null) {
                recyclerView.requestLayout();
            }
        }

        public abstract int u(a0 a0Var);

        public final boolean u0() {
            return this.f4145l;
        }

        public void u1() {
            this.f4141h = true;
        }

        public abstract int v(a0 a0Var);

        public boolean v0(v vVar, a0 a0Var) {
            return false;
        }

        public void w(v vVar) {
            for (int J = J() - 1; J >= 0; J--) {
                v1(vVar, J, I(J));
            }
        }

        public abstract int w1(int i10, v vVar, a0 a0Var);

        public void x(int i10) {
            y(i10, I(i10));
        }

        public boolean x0() {
            z zVar = this.f4140g;
            return zVar != null && zVar.h();
        }

        public abstract void x1(int i10);

        public boolean y0(View view, boolean z9, boolean z10) {
            boolean z11 = this.f4138e.b(view, 24579) && this.f4139f.b(view, 24579);
            return z9 ? z11 : !z11;
        }

        public abstract int y1(int i10, v vVar, a0 a0Var);

        void z(RecyclerView recyclerView) {
            this.f4142i = true;
            G0(recyclerView);
        }

        public void z0(View view, int i10, int i11, int i12, int i13) {
            p pVar = (p) view.getLayoutParams();
            Rect rect = pVar.f4159b;
            view.layout(i10 + rect.left + ((ViewGroup.MarginLayoutParams) pVar).leftMargin, i11 + rect.top + ((ViewGroup.MarginLayoutParams) pVar).topMargin, (i12 - rect.right) - ((ViewGroup.MarginLayoutParams) pVar).rightMargin, (i13 - rect.bottom) - ((ViewGroup.MarginLayoutParams) pVar).bottomMargin);
        }

        void z1(RecyclerView recyclerView) {
            A1(View.MeasureSpec.makeMeasureSpec(recyclerView.getWidth(), 1073741824), View.MeasureSpec.makeMeasureSpec(recyclerView.getHeight(), 1073741824));
        }
    }

    /* loaded from: classes.dex */
    public static class p extends ViewGroup.MarginLayoutParams {

        /* renamed from: a  reason: collision with root package name */
        d0 f4158a;

        /* renamed from: b  reason: collision with root package name */
        final Rect f4159b;

        /* renamed from: c  reason: collision with root package name */
        boolean f4160c;

        /* renamed from: d  reason: collision with root package name */
        boolean f4161d;

        public p(int i10, int i11) {
            super(i10, i11);
            this.f4159b = new Rect();
            this.f4160c = true;
            this.f4161d = false;
        }

        public p(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.f4159b = new Rect();
            this.f4160c = true;
            this.f4161d = false;
        }

        public p(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.f4159b = new Rect();
            this.f4160c = true;
            this.f4161d = false;
        }

        public p(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.f4159b = new Rect();
            this.f4160c = true;
            this.f4161d = false;
        }

        public p(p pVar) {
            super((ViewGroup.LayoutParams) pVar);
            this.f4159b = new Rect();
            this.f4160c = true;
            this.f4161d = false;
        }

        public int a() {
            return this.f4158a.m();
        }

        public boolean b() {
            return this.f4158a.y();
        }

        public boolean c() {
            return this.f4158a.v();
        }

        public boolean d() {
            return this.f4158a.t();
        }
    }

    /* loaded from: classes.dex */
    public interface q {
        void a(View view);

        void b(View view);
    }

    /* loaded from: classes.dex */
    public static abstract class r {
        public abstract boolean a(int i10, int i11);
    }

    /* loaded from: classes.dex */
    public interface s {
        void a(RecyclerView recyclerView, MotionEvent motionEvent);

        boolean b(RecyclerView recyclerView, MotionEvent motionEvent);

        void c(boolean z9);
    }

    /* loaded from: classes.dex */
    public static abstract class t {
        public void a(RecyclerView recyclerView, int i10) {
        }

        public abstract void b(RecyclerView recyclerView, int i10, int i11);
    }

    /* loaded from: classes.dex */
    public static class u {

        /* renamed from: a  reason: collision with root package name */
        SparseArray f4162a = new SparseArray();

        /* renamed from: b  reason: collision with root package name */
        private int f4163b = 0;

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public static class a {

            /* renamed from: a  reason: collision with root package name */
            final ArrayList f4164a = new ArrayList();

            /* renamed from: b  reason: collision with root package name */
            int f4165b = 5;

            /* renamed from: c  reason: collision with root package name */
            long f4166c = 0;

            /* renamed from: d  reason: collision with root package name */
            long f4167d = 0;

            a() {
            }
        }

        private a g(int i10) {
            a aVar = (a) this.f4162a.get(i10);
            if (aVar == null) {
                a aVar2 = new a();
                this.f4162a.put(i10, aVar2);
                return aVar2;
            }
            return aVar;
        }

        void a() {
            this.f4163b++;
        }

        public void b() {
            for (int i10 = 0; i10 < this.f4162a.size(); i10++) {
                ((a) this.f4162a.valueAt(i10)).f4164a.clear();
            }
        }

        void c() {
            this.f4163b--;
        }

        void d(int i10, long j10) {
            a g10 = g(i10);
            g10.f4167d = j(g10.f4167d, j10);
        }

        void e(int i10, long j10) {
            a g10 = g(i10);
            g10.f4166c = j(g10.f4166c, j10);
        }

        public d0 f(int i10) {
            a aVar = (a) this.f4162a.get(i10);
            if (aVar == null || aVar.f4164a.isEmpty()) {
                return null;
            }
            ArrayList arrayList = aVar.f4164a;
            for (int size = arrayList.size() - 1; size >= 0; size--) {
                if (!((d0) arrayList.get(size)).r()) {
                    return (d0) arrayList.remove(size);
                }
            }
            return null;
        }

        void h(g gVar, g gVar2, boolean z9) {
            if (gVar != null) {
                c();
            }
            if (!z9 && this.f4163b == 0) {
                b();
            }
            if (gVar2 != null) {
                a();
            }
        }

        public void i(d0 d0Var) {
            int l10 = d0Var.l();
            ArrayList arrayList = g(l10).f4164a;
            if (((a) this.f4162a.get(l10)).f4165b <= arrayList.size()) {
                return;
            }
            d0Var.D();
            arrayList.add(d0Var);
        }

        long j(long j10, long j11) {
            return j10 == 0 ? j11 : ((j10 / 4) * 3) + (j11 / 4);
        }

        boolean k(int i10, long j10, long j11) {
            long j12 = g(i10).f4167d;
            return j12 == 0 || j10 + j12 < j11;
        }

        boolean l(int i10, long j10, long j11) {
            long j12 = g(i10).f4166c;
            return j12 == 0 || j10 + j12 < j11;
        }
    }

    /* loaded from: classes.dex */
    public final class v {

        /* renamed from: a  reason: collision with root package name */
        final ArrayList f4168a;

        /* renamed from: b  reason: collision with root package name */
        ArrayList f4169b;

        /* renamed from: c  reason: collision with root package name */
        final ArrayList f4170c;

        /* renamed from: d  reason: collision with root package name */
        private final List f4171d;

        /* renamed from: e  reason: collision with root package name */
        private int f4172e;

        /* renamed from: f  reason: collision with root package name */
        int f4173f;

        /* renamed from: g  reason: collision with root package name */
        u f4174g;

        public v() {
            ArrayList arrayList = new ArrayList();
            this.f4168a = arrayList;
            this.f4169b = null;
            this.f4170c = new ArrayList();
            this.f4171d = Collections.unmodifiableList(arrayList);
            this.f4172e = 2;
            this.f4173f = 2;
        }

        private boolean H(d0 d0Var, int i10, int i11, long j10) {
            d0Var.f4118r = RecyclerView.this;
            int l10 = d0Var.l();
            long nanoTime = RecyclerView.this.getNanoTime();
            if (j10 == RecyclerView.FOREVER_NS || this.f4174g.k(l10, nanoTime, j10)) {
                RecyclerView.this.mAdapter.a(d0Var, i10);
                this.f4174g.d(d0Var.l(), RecyclerView.this.getNanoTime() - nanoTime);
                b(d0Var);
                if (RecyclerView.this.mState.e()) {
                    d0Var.f4107g = i11;
                    return true;
                }
                return true;
            }
            return false;
        }

        private void b(d0 d0Var) {
            if (RecyclerView.this.isAccessibilityEnabled()) {
                View view = d0Var.f4101a;
                if (r0.z(view) == 0) {
                    r0.x0(view, 1);
                }
                androidx.recyclerview.widget.k kVar = RecyclerView.this.mAccessibilityDelegate;
                if (kVar == null) {
                    return;
                }
                androidx.core.view.a n10 = kVar.n();
                if (n10 instanceof k.a) {
                    ((k.a) n10).o(view);
                }
                r0.n0(view, n10);
            }
        }

        private void q(ViewGroup viewGroup, boolean z9) {
            for (int childCount = viewGroup.getChildCount() - 1; childCount >= 0; childCount--) {
                View childAt = viewGroup.getChildAt(childCount);
                if (childAt instanceof ViewGroup) {
                    q((ViewGroup) childAt, true);
                }
            }
            if (z9) {
                if (viewGroup.getVisibility() == 4) {
                    viewGroup.setVisibility(0);
                    viewGroup.setVisibility(4);
                    return;
                }
                int visibility = viewGroup.getVisibility();
                viewGroup.setVisibility(4);
                viewGroup.setVisibility(visibility);
            }
        }

        private void r(d0 d0Var) {
            View view = d0Var.f4101a;
            if (view instanceof ViewGroup) {
                q((ViewGroup) view, false);
            }
        }

        void A(int i10) {
            a((d0) this.f4170c.get(i10), true);
            this.f4170c.remove(i10);
        }

        public void B(View view) {
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt.x()) {
                RecyclerView.this.removeDetachedView(view, false);
            }
            if (childViewHolderInt.w()) {
                childViewHolderInt.K();
            } else if (childViewHolderInt.L()) {
                childViewHolderInt.e();
            }
            C(childViewHolderInt);
            if (RecyclerView.this.mItemAnimator == null || childViewHolderInt.u()) {
                return;
            }
            RecyclerView.this.mItemAnimator.j(childViewHolderInt);
        }

        void C(d0 d0Var) {
            boolean z9;
            boolean z10 = true;
            if (d0Var.w() || d0Var.f4101a.getParent() != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Scrapped or attached views may not be recycled. isScrap:");
                sb.append(d0Var.w());
                sb.append(" isAttached:");
                sb.append(d0Var.f4101a.getParent() != null);
                sb.append(RecyclerView.this.exceptionLabel());
                throw new IllegalArgumentException(sb.toString());
            } else if (d0Var.x()) {
                throw new IllegalArgumentException("Tmp detached view should be removed from RecyclerView before it can be recycled: " + d0Var + RecyclerView.this.exceptionLabel());
            } else if (d0Var.J()) {
                throw new IllegalArgumentException("Trying to recycle an ignored view holder. You should first call stopIgnoringView(view) before calling recycle." + RecyclerView.this.exceptionLabel());
            } else {
                boolean h10 = d0Var.h();
                g gVar = RecyclerView.this.mAdapter;
                if ((gVar != null && h10 && gVar.n(d0Var)) || d0Var.u()) {
                    if (this.f4173f <= 0 || d0Var.p(526)) {
                        z9 = false;
                    } else {
                        int size = this.f4170c.size();
                        if (size >= this.f4173f && size > 0) {
                            A(0);
                            size--;
                        }
                        if (RecyclerView.ALLOW_THREAD_GAP_WORK && size > 0 && !RecyclerView.this.mPrefetchRegistry.d(d0Var.f4103c)) {
                            int i10 = size - 1;
                            while (i10 >= 0) {
                                if (!RecyclerView.this.mPrefetchRegistry.d(((d0) this.f4170c.get(i10)).f4103c)) {
                                    break;
                                }
                                i10--;
                            }
                            size = i10 + 1;
                        }
                        this.f4170c.add(size, d0Var);
                        z9 = true;
                    }
                    if (!z9) {
                        a(d0Var, true);
                        r1 = z9;
                        RecyclerView.this.mViewInfoStore.q(d0Var);
                        if (r1 && !z10 && h10) {
                            d0Var.f4118r = null;
                            return;
                        }
                        return;
                    }
                    r1 = z9;
                }
                z10 = false;
                RecyclerView.this.mViewInfoStore.q(d0Var);
                if (r1) {
                }
            }
        }

        void D(View view) {
            ArrayList arrayList;
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (!childViewHolderInt.p(12) && childViewHolderInt.y() && !RecyclerView.this.canReuseUpdatedViewHolder(childViewHolderInt)) {
                if (this.f4169b == null) {
                    this.f4169b = new ArrayList();
                }
                childViewHolderInt.H(this, true);
                arrayList = this.f4169b;
            } else if (childViewHolderInt.t() && !childViewHolderInt.v() && !RecyclerView.this.mAdapter.g()) {
                throw new IllegalArgumentException("Called scrap view with an invalid view. Invalid views cannot be reused from scrap, they should rebound from recycler pool." + RecyclerView.this.exceptionLabel());
            } else {
                childViewHolderInt.H(this, false);
                arrayList = this.f4168a;
            }
            arrayList.add(childViewHolderInt);
        }

        void E(u uVar) {
            u uVar2 = this.f4174g;
            if (uVar2 != null) {
                uVar2.c();
            }
            this.f4174g = uVar;
            if (uVar == null || RecyclerView.this.getAdapter() == null) {
                return;
            }
            this.f4174g.a();
        }

        void F(b0 b0Var) {
        }

        public void G(int i10) {
            this.f4172e = i10;
            K();
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* JADX WARN: Removed duplicated region for block: B:18:0x0037  */
        /* JADX WARN: Removed duplicated region for block: B:27:0x005c  */
        /* JADX WARN: Removed duplicated region for block: B:29:0x005f  */
        /* JADX WARN: Removed duplicated region for block: B:62:0x0130  */
        /* JADX WARN: Removed duplicated region for block: B:68:0x014d  */
        /* JADX WARN: Removed duplicated region for block: B:71:0x0170  */
        /* JADX WARN: Removed duplicated region for block: B:76:0x017f  */
        /* JADX WARN: Removed duplicated region for block: B:85:0x01a9  */
        /* JADX WARN: Removed duplicated region for block: B:87:0x01b7  */
        /* JADX WARN: Removed duplicated region for block: B:93:0x01cc A[ADDED_TO_REGION] */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        public d0 I(int i10, boolean z9, long j10) {
            d0 d0Var;
            boolean z10;
            d0 d0Var2;
            boolean z11;
            boolean H;
            ViewGroup.LayoutParams layoutParams;
            p pVar;
            ViewGroup.LayoutParams generateLayoutParams;
            RecyclerView findNestedRecyclerView;
            if (i10 < 0 || i10 >= RecyclerView.this.mState.b()) {
                throw new IndexOutOfBoundsException("Invalid item position " + i10 + "(" + i10 + "). Item count:" + RecyclerView.this.mState.b() + RecyclerView.this.exceptionLabel());
            }
            boolean z12 = true;
            if (RecyclerView.this.mState.e()) {
                d0Var = h(i10);
                if (d0Var != null) {
                    z10 = true;
                    if (d0Var == null && (d0Var = m(i10, z9)) != null) {
                        if (L(d0Var)) {
                            if (!z9) {
                                d0Var.b(4);
                                if (d0Var.w()) {
                                    RecyclerView.this.removeDetachedView(d0Var.f4101a, false);
                                    d0Var.K();
                                } else if (d0Var.L()) {
                                    d0Var.e();
                                }
                                C(d0Var);
                            }
                            d0Var = null;
                        } else {
                            z10 = true;
                        }
                    }
                    if (d0Var == null) {
                        int m10 = RecyclerView.this.mAdapterHelper.m(i10);
                        if (m10 < 0 || m10 >= RecyclerView.this.mAdapter.c()) {
                            throw new IndexOutOfBoundsException("Inconsistency detected. Invalid item position " + i10 + "(offset:" + m10 + ").state:" + RecyclerView.this.mState.b() + RecyclerView.this.exceptionLabel());
                        }
                        int e10 = RecyclerView.this.mAdapter.e(m10);
                        if (RecyclerView.this.mAdapter.g() && (d0Var = l(RecyclerView.this.mAdapter.d(m10), e10, z9)) != null) {
                            d0Var.f4103c = m10;
                            z10 = true;
                        }
                        if (d0Var == null) {
                            d0 f10 = i().f(e10);
                            if (f10 != null) {
                                f10.D();
                                if (RecyclerView.FORCE_INVALIDATE_DISPLAY_LIST) {
                                    r(f10);
                                }
                            }
                            d0Var = f10;
                        }
                        if (d0Var == null) {
                            long nanoTime = RecyclerView.this.getNanoTime();
                            if (j10 == RecyclerView.FOREVER_NS || this.f4174g.l(e10, nanoTime, j10)) {
                                RecyclerView recyclerView = RecyclerView.this;
                                d0 b10 = recyclerView.mAdapter.b(recyclerView, e10);
                                if (RecyclerView.ALLOW_THREAD_GAP_WORK && (findNestedRecyclerView = RecyclerView.findNestedRecyclerView(b10.f4101a)) != null) {
                                    b10.f4102b = new WeakReference(findNestedRecyclerView);
                                }
                                this.f4174g.e(e10, RecyclerView.this.getNanoTime() - nanoTime);
                                d0Var2 = b10;
                                z11 = z10;
                                if (z11 && !RecyclerView.this.mState.e() && d0Var2.p(8192)) {
                                    d0Var2.F(0, 8192);
                                    if (RecyclerView.this.mState.f4084k) {
                                        RecyclerView recyclerView2 = RecyclerView.this;
                                        RecyclerView.this.recordAnimationInfoIfBouncedHiddenView(d0Var2, recyclerView2.mItemAnimator.t(recyclerView2.mState, d0Var2, l.e(d0Var2) | 4096, d0Var2.o()));
                                    }
                                }
                                if (!RecyclerView.this.mState.e() && d0Var2.s()) {
                                    d0Var2.f4107g = i10;
                                } else if (d0Var2.s() || d0Var2.z() || d0Var2.t()) {
                                    H = H(d0Var2, RecyclerView.this.mAdapterHelper.m(i10), i10, j10);
                                    layoutParams = d0Var2.f4101a.getLayoutParams();
                                    if (layoutParams != null) {
                                        generateLayoutParams = RecyclerView.this.generateDefaultLayoutParams();
                                    } else if (RecyclerView.this.checkLayoutParams(layoutParams)) {
                                        pVar = (p) layoutParams;
                                        pVar.f4158a = d0Var2;
                                        pVar.f4161d = (z11 || !H) ? false : false;
                                        return d0Var2;
                                    } else {
                                        generateLayoutParams = RecyclerView.this.generateLayoutParams(layoutParams);
                                    }
                                    pVar = (p) generateLayoutParams;
                                    d0Var2.f4101a.setLayoutParams(pVar);
                                    pVar.f4158a = d0Var2;
                                    pVar.f4161d = (z11 || !H) ? false : false;
                                    return d0Var2;
                                }
                                H = false;
                                layoutParams = d0Var2.f4101a.getLayoutParams();
                                if (layoutParams != null) {
                                }
                                pVar = (p) generateLayoutParams;
                                d0Var2.f4101a.setLayoutParams(pVar);
                                pVar.f4158a = d0Var2;
                                pVar.f4161d = (z11 || !H) ? false : false;
                                return d0Var2;
                            }
                            return null;
                        }
                    }
                    d0Var2 = d0Var;
                    z11 = z10;
                    if (z11) {
                        d0Var2.F(0, 8192);
                        if (RecyclerView.this.mState.f4084k) {
                        }
                    }
                    if (!RecyclerView.this.mState.e()) {
                    }
                    if (d0Var2.s()) {
                    }
                    H = H(d0Var2, RecyclerView.this.mAdapterHelper.m(i10), i10, j10);
                    layoutParams = d0Var2.f4101a.getLayoutParams();
                    if (layoutParams != null) {
                    }
                    pVar = (p) generateLayoutParams;
                    d0Var2.f4101a.setLayoutParams(pVar);
                    pVar.f4158a = d0Var2;
                    pVar.f4161d = (z11 || !H) ? false : false;
                    return d0Var2;
                }
            } else {
                d0Var = null;
            }
            z10 = false;
            if (d0Var == null) {
                if (L(d0Var)) {
                }
            }
            if (d0Var == null) {
            }
            d0Var2 = d0Var;
            z11 = z10;
            if (z11) {
            }
            if (!RecyclerView.this.mState.e()) {
            }
            if (d0Var2.s()) {
            }
            H = H(d0Var2, RecyclerView.this.mAdapterHelper.m(i10), i10, j10);
            layoutParams = d0Var2.f4101a.getLayoutParams();
            if (layoutParams != null) {
            }
            pVar = (p) generateLayoutParams;
            d0Var2.f4101a.setLayoutParams(pVar);
            pVar.f4158a = d0Var2;
            pVar.f4161d = (z11 || !H) ? false : false;
            return d0Var2;
        }

        void J(d0 d0Var) {
            (d0Var.f4115o ? this.f4169b : this.f4168a).remove(d0Var);
            d0Var.f4114n = null;
            d0Var.f4115o = false;
            d0Var.e();
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public void K() {
            o oVar = RecyclerView.this.mLayout;
            this.f4173f = this.f4172e + (oVar != null ? oVar.f4146m : 0);
            for (int size = this.f4170c.size() - 1; size >= 0 && this.f4170c.size() > this.f4173f; size--) {
                A(size);
            }
        }

        boolean L(d0 d0Var) {
            if (d0Var.v()) {
                return RecyclerView.this.mState.e();
            }
            int i10 = d0Var.f4103c;
            if (i10 >= 0 && i10 < RecyclerView.this.mAdapter.c()) {
                if (RecyclerView.this.mState.e() || RecyclerView.this.mAdapter.e(d0Var.f4103c) == d0Var.l()) {
                    return !RecyclerView.this.mAdapter.g() || d0Var.k() == RecyclerView.this.mAdapter.d(d0Var.f4103c);
                }
                return false;
            }
            throw new IndexOutOfBoundsException("Inconsistency detected. Invalid view holder adapter position" + d0Var + RecyclerView.this.exceptionLabel());
        }

        void M(int i10, int i11) {
            int i12;
            int i13 = i11 + i10;
            for (int size = this.f4170c.size() - 1; size >= 0; size--) {
                d0 d0Var = (d0) this.f4170c.get(size);
                if (d0Var != null && (i12 = d0Var.f4103c) >= i10 && i12 < i13) {
                    d0Var.b(2);
                    A(size);
                }
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public void a(d0 d0Var, boolean z9) {
            RecyclerView.clearNestedRecyclerViewIfNotNested(d0Var);
            View view = d0Var.f4101a;
            androidx.recyclerview.widget.k kVar = RecyclerView.this.mAccessibilityDelegate;
            if (kVar != null) {
                androidx.core.view.a n10 = kVar.n();
                r0.n0(view, n10 instanceof k.a ? ((k.a) n10).n(view) : null);
            }
            if (z9) {
                g(d0Var);
            }
            d0Var.f4118r = null;
            i().i(d0Var);
        }

        public void c() {
            this.f4168a.clear();
            z();
        }

        void d() {
            int size = this.f4170c.size();
            for (int i10 = 0; i10 < size; i10++) {
                ((d0) this.f4170c.get(i10)).c();
            }
            int size2 = this.f4168a.size();
            for (int i11 = 0; i11 < size2; i11++) {
                ((d0) this.f4168a.get(i11)).c();
            }
            ArrayList arrayList = this.f4169b;
            if (arrayList != null) {
                int size3 = arrayList.size();
                for (int i12 = 0; i12 < size3; i12++) {
                    ((d0) this.f4169b.get(i12)).c();
                }
            }
        }

        void e() {
            this.f4168a.clear();
            ArrayList arrayList = this.f4169b;
            if (arrayList != null) {
                arrayList.clear();
            }
        }

        public int f(int i10) {
            if (i10 >= 0 && i10 < RecyclerView.this.mState.b()) {
                return !RecyclerView.this.mState.e() ? i10 : RecyclerView.this.mAdapterHelper.m(i10);
            }
            throw new IndexOutOfBoundsException("invalid position " + i10 + ". State item count is " + RecyclerView.this.mState.b() + RecyclerView.this.exceptionLabel());
        }

        void g(d0 d0Var) {
            w wVar = RecyclerView.this.mRecyclerListener;
            if (wVar != null) {
                wVar.a(d0Var);
            }
            g gVar = RecyclerView.this.mAdapter;
            if (gVar != null) {
                gVar.q(d0Var);
            }
            RecyclerView recyclerView = RecyclerView.this;
            if (recyclerView.mState != null) {
                recyclerView.mViewInfoStore.q(d0Var);
            }
        }

        d0 h(int i10) {
            int size;
            int m10;
            ArrayList arrayList = this.f4169b;
            if (arrayList != null && (size = arrayList.size()) != 0) {
                for (int i11 = 0; i11 < size; i11++) {
                    d0 d0Var = (d0) this.f4169b.get(i11);
                    if (!d0Var.L() && d0Var.m() == i10) {
                        d0Var.b(32);
                        return d0Var;
                    }
                }
                if (RecyclerView.this.mAdapter.g() && (m10 = RecyclerView.this.mAdapterHelper.m(i10)) > 0 && m10 < RecyclerView.this.mAdapter.c()) {
                    long d10 = RecyclerView.this.mAdapter.d(m10);
                    for (int i12 = 0; i12 < size; i12++) {
                        d0 d0Var2 = (d0) this.f4169b.get(i12);
                        if (!d0Var2.L() && d0Var2.k() == d10) {
                            d0Var2.b(32);
                            return d0Var2;
                        }
                    }
                }
            }
            return null;
        }

        u i() {
            if (this.f4174g == null) {
                this.f4174g = new u();
            }
            return this.f4174g;
        }

        int j() {
            return this.f4168a.size();
        }

        public List k() {
            return this.f4171d;
        }

        d0 l(long j10, int i10, boolean z9) {
            for (int size = this.f4168a.size() - 1; size >= 0; size--) {
                d0 d0Var = (d0) this.f4168a.get(size);
                if (d0Var.k() == j10 && !d0Var.L()) {
                    if (i10 == d0Var.l()) {
                        d0Var.b(32);
                        if (d0Var.v() && !RecyclerView.this.mState.e()) {
                            d0Var.F(2, 14);
                        }
                        return d0Var;
                    } else if (!z9) {
                        this.f4168a.remove(size);
                        RecyclerView.this.removeDetachedView(d0Var.f4101a, false);
                        y(d0Var.f4101a);
                    }
                }
            }
            int size2 = this.f4170c.size();
            while (true) {
                size2--;
                if (size2 < 0) {
                    return null;
                }
                d0 d0Var2 = (d0) this.f4170c.get(size2);
                if (d0Var2.k() == j10 && !d0Var2.r()) {
                    if (i10 == d0Var2.l()) {
                        if (!z9) {
                            this.f4170c.remove(size2);
                        }
                        return d0Var2;
                    } else if (!z9) {
                        A(size2);
                        return null;
                    }
                }
            }
        }

        d0 m(int i10, boolean z9) {
            View e10;
            int size = this.f4168a.size();
            for (int i11 = 0; i11 < size; i11++) {
                d0 d0Var = (d0) this.f4168a.get(i11);
                if (!d0Var.L() && d0Var.m() == i10 && !d0Var.t() && (RecyclerView.this.mState.f4081h || !d0Var.v())) {
                    d0Var.b(32);
                    return d0Var;
                }
            }
            if (z9 || (e10 = RecyclerView.this.mChildHelper.e(i10)) == null) {
                int size2 = this.f4170c.size();
                for (int i12 = 0; i12 < size2; i12++) {
                    d0 d0Var2 = (d0) this.f4170c.get(i12);
                    if (!d0Var2.t() && d0Var2.m() == i10 && !d0Var2.r()) {
                        if (!z9) {
                            this.f4170c.remove(i12);
                        }
                        return d0Var2;
                    }
                }
                return null;
            }
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(e10);
            RecyclerView.this.mChildHelper.s(e10);
            int m10 = RecyclerView.this.mChildHelper.m(e10);
            if (m10 != -1) {
                RecyclerView.this.mChildHelper.d(m10);
                D(e10);
                childViewHolderInt.b(8224);
                return childViewHolderInt;
            }
            throw new IllegalStateException("layout index should not be -1 after unhiding a view:" + childViewHolderInt + RecyclerView.this.exceptionLabel());
        }

        View n(int i10) {
            return ((d0) this.f4168a.get(i10)).f4101a;
        }

        public View o(int i10) {
            return p(i10, false);
        }

        View p(int i10, boolean z9) {
            return I(i10, z9, RecyclerView.FOREVER_NS).f4101a;
        }

        void s() {
            int size = this.f4170c.size();
            for (int i10 = 0; i10 < size; i10++) {
                p pVar = (p) ((d0) this.f4170c.get(i10)).f4101a.getLayoutParams();
                if (pVar != null) {
                    pVar.f4160c = true;
                }
            }
        }

        void t() {
            int size = this.f4170c.size();
            for (int i10 = 0; i10 < size; i10++) {
                d0 d0Var = (d0) this.f4170c.get(i10);
                if (d0Var != null) {
                    d0Var.b(6);
                    d0Var.a(null);
                }
            }
            g gVar = RecyclerView.this.mAdapter;
            if (gVar == null || !gVar.g()) {
                z();
            }
        }

        void u(int i10, int i11) {
            int size = this.f4170c.size();
            for (int i12 = 0; i12 < size; i12++) {
                d0 d0Var = (d0) this.f4170c.get(i12);
                if (d0Var != null && d0Var.f4103c >= i10) {
                    d0Var.A(i11, true);
                }
            }
        }

        void v(int i10, int i11) {
            int i12;
            int i13;
            int i14;
            int i15;
            if (i10 < i11) {
                i12 = -1;
                i14 = i10;
                i13 = i11;
            } else {
                i12 = 1;
                i13 = i10;
                i14 = i11;
            }
            int size = this.f4170c.size();
            for (int i16 = 0; i16 < size; i16++) {
                d0 d0Var = (d0) this.f4170c.get(i16);
                if (d0Var != null && (i15 = d0Var.f4103c) >= i14 && i15 <= i13) {
                    if (i15 == i10) {
                        d0Var.A(i11 - i10, false);
                    } else {
                        d0Var.A(i12, false);
                    }
                }
            }
        }

        void w(int i10, int i11, boolean z9) {
            int i12 = i10 + i11;
            for (int size = this.f4170c.size() - 1; size >= 0; size--) {
                d0 d0Var = (d0) this.f4170c.get(size);
                if (d0Var != null) {
                    int i13 = d0Var.f4103c;
                    if (i13 >= i12) {
                        d0Var.A(-i11, z9);
                    } else if (i13 >= i10) {
                        d0Var.b(8);
                        A(size);
                    }
                }
            }
        }

        void x(g gVar, g gVar2, boolean z9) {
            c();
            i().h(gVar, gVar2, z9);
        }

        void y(View view) {
            d0 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            childViewHolderInt.f4114n = null;
            childViewHolderInt.f4115o = false;
            childViewHolderInt.e();
            C(childViewHolderInt);
        }

        void z() {
            for (int size = this.f4170c.size() - 1; size >= 0; size--) {
                A(size);
            }
            this.f4170c.clear();
            if (RecyclerView.ALLOW_THREAD_GAP_WORK) {
                RecyclerView.this.mPrefetchRegistry.b();
            }
        }
    }

    /* loaded from: classes.dex */
    public interface w {
        void a(d0 d0Var);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class x extends i {
        x() {
        }

        @Override // androidx.recyclerview.widget.RecyclerView.i
        public void a() {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            RecyclerView recyclerView = RecyclerView.this;
            recyclerView.mState.f4080g = true;
            recyclerView.processDataSetCompletelyChanged(true);
            if (RecyclerView.this.mAdapterHelper.p()) {
                return;
            }
            RecyclerView.this.requestLayout();
        }
    }

    /* loaded from: classes.dex */
    public static class y extends b0.a {
        public static final Parcelable.Creator<y> CREATOR = new a();

        /* renamed from: i  reason: collision with root package name */
        Parcelable f4177i;

        /* loaded from: classes.dex */
        static class a implements Parcelable.ClassLoaderCreator {
            a() {
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: a */
            public y createFromParcel(Parcel parcel) {
                return new y(parcel, null);
            }

            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: b */
            public y createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new y(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: c */
            public y[] newArray(int i10) {
                return new y[i10];
            }
        }

        y(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f4177i = parcel.readParcelable(classLoader == null ? o.class.getClassLoader() : classLoader);
        }

        y(Parcelable parcelable) {
            super(parcelable);
        }

        void c(y yVar) {
            this.f4177i = yVar.f4177i;
        }

        @Override // b0.a, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i10) {
            super.writeToParcel(parcel, i10);
            parcel.writeParcelable(this.f4177i, 0);
        }
    }

    /* loaded from: classes.dex */
    public static abstract class z {

        /* renamed from: b  reason: collision with root package name */
        private RecyclerView f4179b;

        /* renamed from: c  reason: collision with root package name */
        private o f4180c;

        /* renamed from: d  reason: collision with root package name */
        private boolean f4181d;

        /* renamed from: e  reason: collision with root package name */
        private boolean f4182e;

        /* renamed from: f  reason: collision with root package name */
        private View f4183f;

        /* renamed from: h  reason: collision with root package name */
        private boolean f4185h;

        /* renamed from: a  reason: collision with root package name */
        private int f4178a = -1;

        /* renamed from: g  reason: collision with root package name */
        private final a f4184g = new a(0, 0);

        /* loaded from: classes.dex */
        public static class a {

            /* renamed from: a  reason: collision with root package name */
            private int f4186a;

            /* renamed from: b  reason: collision with root package name */
            private int f4187b;

            /* renamed from: c  reason: collision with root package name */
            private int f4188c;

            /* renamed from: d  reason: collision with root package name */
            private int f4189d;

            /* renamed from: e  reason: collision with root package name */
            private Interpolator f4190e;

            /* renamed from: f  reason: collision with root package name */
            private boolean f4191f;

            /* renamed from: g  reason: collision with root package name */
            private int f4192g;

            public a(int i10, int i11) {
                this(i10, i11, RecyclerView.UNDEFINED_DURATION, null);
            }

            public a(int i10, int i11, int i12, Interpolator interpolator) {
                this.f4189d = -1;
                this.f4191f = false;
                this.f4192g = 0;
                this.f4186a = i10;
                this.f4187b = i11;
                this.f4188c = i12;
                this.f4190e = interpolator;
            }

            private void e() {
                if (this.f4190e != null && this.f4188c < 1) {
                    throw new IllegalStateException("If you provide an interpolator, you must set a positive duration");
                }
                if (this.f4188c < 1) {
                    throw new IllegalStateException("Scroll duration must be a positive number");
                }
            }

            boolean a() {
                return this.f4189d >= 0;
            }

            public void b(int i10) {
                this.f4189d = i10;
            }

            void c(RecyclerView recyclerView) {
                int i10 = this.f4189d;
                if (i10 >= 0) {
                    this.f4189d = -1;
                    recyclerView.jumpToPositionForSmoothScroller(i10);
                    this.f4191f = false;
                } else if (!this.f4191f) {
                    this.f4192g = 0;
                } else {
                    e();
                    recyclerView.mViewFlinger.f(this.f4186a, this.f4187b, this.f4188c, this.f4190e);
                    int i11 = this.f4192g + 1;
                    this.f4192g = i11;
                    if (i11 > 10) {
                        Log.e(RecyclerView.TAG, "Smooth Scroll action is being updated too frequently. Make sure you are not changing it unless necessary");
                    }
                    this.f4191f = false;
                }
            }

            public void d(int i10, int i11, int i12, Interpolator interpolator) {
                this.f4186a = i10;
                this.f4187b = i11;
                this.f4188c = i12;
                this.f4190e = interpolator;
                this.f4191f = true;
            }
        }

        /* loaded from: classes.dex */
        public interface b {
            PointF a(int i10);
        }

        public PointF a(int i10) {
            o e10 = e();
            if (e10 instanceof b) {
                return ((b) e10).a(i10);
            }
            Log.w(RecyclerView.TAG, "You should override computeScrollVectorForPosition when the LayoutManager does not implement " + b.class.getCanonicalName());
            return null;
        }

        public View b(int i10) {
            return this.f4179b.mLayout.C(i10);
        }

        public int c() {
            return this.f4179b.mLayout.J();
        }

        public int d(View view) {
            return this.f4179b.getChildLayoutPosition(view);
        }

        public o e() {
            return this.f4180c;
        }

        public int f() {
            return this.f4178a;
        }

        public boolean g() {
            return this.f4181d;
        }

        public boolean h() {
            return this.f4182e;
        }

        /* JADX INFO: Access modifiers changed from: protected */
        public void i(PointF pointF) {
            float f10 = pointF.x;
            float f11 = pointF.y;
            float sqrt = (float) Math.sqrt((f10 * f10) + (f11 * f11));
            pointF.x /= sqrt;
            pointF.y /= sqrt;
        }

        void j(int i10, int i11) {
            PointF a10;
            RecyclerView recyclerView = this.f4179b;
            if (this.f4178a == -1 || recyclerView == null) {
                r();
            }
            if (this.f4181d && this.f4183f == null && this.f4180c != null && (a10 = a(this.f4178a)) != null) {
                float f10 = a10.x;
                if (f10 != 0.0f || a10.y != 0.0f) {
                    recyclerView.scrollStep((int) Math.signum(f10), (int) Math.signum(a10.y), null);
                }
            }
            this.f4181d = false;
            View view = this.f4183f;
            if (view != null) {
                if (d(view) == this.f4178a) {
                    o(this.f4183f, recyclerView.mState, this.f4184g);
                    this.f4184g.c(recyclerView);
                    r();
                } else {
                    Log.e(RecyclerView.TAG, "Passed over target position while smooth scrolling.");
                    this.f4183f = null;
                }
            }
            if (this.f4182e) {
                l(i10, i11, recyclerView.mState, this.f4184g);
                boolean a11 = this.f4184g.a();
                this.f4184g.c(recyclerView);
                if (a11 && this.f4182e) {
                    this.f4181d = true;
                    recyclerView.mViewFlinger.e();
                }
            }
        }

        protected void k(View view) {
            if (d(view) == f()) {
                this.f4183f = view;
            }
        }

        protected abstract void l(int i10, int i11, a0 a0Var, a aVar);

        protected abstract void m();

        protected abstract void n();

        protected abstract void o(View view, a0 a0Var, a aVar);

        public void p(int i10) {
            this.f4178a = i10;
        }

        void q(RecyclerView recyclerView, o oVar) {
            recyclerView.mViewFlinger.g();
            if (this.f4185h) {
                Log.w(RecyclerView.TAG, "An instance of " + getClass().getSimpleName() + " was started more than once. Each instance of" + getClass().getSimpleName() + " is intended to only be used once. You should create a new instance for each use.");
            }
            this.f4179b = recyclerView;
            this.f4180c = oVar;
            int i10 = this.f4178a;
            if (i10 == -1) {
                throw new IllegalArgumentException("Invalid target position");
            }
            recyclerView.mState.f4074a = i10;
            this.f4182e = true;
            this.f4181d = true;
            this.f4183f = b(f());
            m();
            this.f4179b.mViewFlinger.e();
            this.f4185h = true;
        }

        /* JADX INFO: Access modifiers changed from: protected */
        public final void r() {
            if (this.f4182e) {
                this.f4182e = false;
                n();
                this.f4179b.mState.f4074a = -1;
                this.f4183f = null;
                this.f4178a = -1;
                this.f4181d = false;
                this.f4180c.f1(this);
                this.f4180c = null;
                this.f4179b = null;
            }
        }
    }

    static {
        int i10 = Build.VERSION.SDK_INT;
        FORCE_INVALIDATE_DISPLAY_LIST = false;
        ALLOW_SIZE_IN_UNSPECIFIED_SPEC = i10 >= 23;
        POST_UPDATES_ON_ANIMATION = true;
        ALLOW_THREAD_GAP_WORK = true;
        FORCE_ABS_FOCUS_SEARCH_DIRECTION = false;
        IGNORE_DETACHED_FOCUSED_CHILD = false;
        Class<?> cls = Integer.TYPE;
        LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class, cls, cls};
        sQuinticInterpolator = new c();
    }

    public RecyclerView(Context context) {
        this(context, null);
    }

    public RecyclerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, d3.a.recyclerViewStyle);
    }

    public RecyclerView(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.mObserver = new x();
        this.mRecycler = new v();
        this.mViewInfoStore = new androidx.recyclerview.widget.p();
        this.mUpdateChildViewsRunnable = new a();
        this.mTempRect = new Rect();
        this.mTempRect2 = new Rect();
        this.mTempRectF = new RectF();
        this.mItemDecorations = new ArrayList<>();
        this.mOnItemTouchListeners = new ArrayList<>();
        this.mInterceptRequestLayoutDepth = 0;
        this.mDataSetHasChangedAfterLayout = false;
        this.mDispatchItemsChangedEvent = false;
        this.mLayoutOrScrollCounter = 0;
        this.mDispatchScrollCounter = 0;
        this.mEdgeEffectFactory = new k();
        this.mItemAnimator = new androidx.recyclerview.widget.c();
        this.mScrollState = 0;
        this.mScrollPointerId = -1;
        this.mScaledHorizontalScrollFactor = Float.MIN_VALUE;
        this.mScaledVerticalScrollFactor = Float.MIN_VALUE;
        this.mPreserveFocusAfterLayout = true;
        this.mViewFlinger = new c0();
        this.mPrefetchRegistry = ALLOW_THREAD_GAP_WORK ? new e.b() : null;
        this.mState = new a0();
        this.mItemsAddedOrRemoved = false;
        this.mItemsChanged = false;
        this.mItemAnimatorListener = new m();
        this.mPostedAnimatorRunner = false;
        this.mMinMaxLayoutPositions = new int[2];
        this.mScrollOffset = new int[2];
        this.mNestedOffsets = new int[2];
        this.mReusableIntPair = new int[2];
        this.mPendingAccessibilityImportanceChange = new ArrayList();
        this.mItemAnimatorRunner = new b();
        this.mViewInfoProcessCallback = new d();
        setScrollContainer(true);
        setFocusableInTouchMode(true);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mScaledHorizontalScrollFactor = o2.f(viewConfiguration, context);
        this.mScaledVerticalScrollFactor = o2.j(viewConfiguration, context);
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        setWillNotDraw(getOverScrollMode() == 2);
        this.mItemAnimator.v(this.mItemAnimatorListener);
        initAdapterManager();
        initChildrenHelper();
        initAutofill();
        if (r0.z(this) == 0) {
            r0.x0(this, 1);
        }
        this.mAccessibilityManager = (AccessibilityManager) getContext().getSystemService("accessibility");
        setAccessibilityDelegateCompat(new androidx.recyclerview.widget.k(this));
        int[] iArr = d3.c.f6845f;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, iArr, i10, 0);
        int i11 = Build.VERSION.SDK_INT;
        if (i11 >= 29) {
            saveAttributeDataForStyleable(context, iArr, attributeSet, obtainStyledAttributes, i10, 0);
        }
        String string = obtainStyledAttributes.getString(d3.c.f6854o);
        if (obtainStyledAttributes.getInt(d3.c.f6848i, -1) == -1) {
            setDescendantFocusability(262144);
        }
        this.mClipToPadding = obtainStyledAttributes.getBoolean(d3.c.f6847h, true);
        boolean z9 = obtainStyledAttributes.getBoolean(d3.c.f6849j, false);
        this.mEnableFastScroller = z9;
        if (z9) {
            initFastScroller((StateListDrawable) obtainStyledAttributes.getDrawable(d3.c.f6852m), obtainStyledAttributes.getDrawable(d3.c.f6853n), (StateListDrawable) obtainStyledAttributes.getDrawable(d3.c.f6850k), obtainStyledAttributes.getDrawable(d3.c.f6851l));
        }
        obtainStyledAttributes.recycle();
        createLayoutManager(context, string, attributeSet, i10, 0);
        int[] iArr2 = NESTED_SCROLLING_ATTRS;
        TypedArray obtainStyledAttributes2 = context.obtainStyledAttributes(attributeSet, iArr2, i10, 0);
        if (i11 >= 29) {
            saveAttributeDataForStyleable(context, iArr2, attributeSet, obtainStyledAttributes2, i10, 0);
        }
        boolean z10 = obtainStyledAttributes2.getBoolean(0, true);
        obtainStyledAttributes2.recycle();
        setNestedScrollingEnabled(z10);
    }

    private void addAnimatingView(d0 d0Var) {
        View view = d0Var.f4101a;
        boolean z9 = view.getParent() == this;
        this.mRecycler.J(getChildViewHolder(view));
        if (d0Var.x()) {
            this.mChildHelper.c(view, -1, view.getLayoutParams(), true);
            return;
        }
        androidx.recyclerview.widget.b bVar = this.mChildHelper;
        if (z9) {
            bVar.k(view);
        } else {
            bVar.b(view, true);
        }
    }

    private void animateChange(d0 d0Var, d0 d0Var2, l.c cVar, l.c cVar2, boolean z9, boolean z10) {
        d0Var.G(false);
        if (z9) {
            addAnimatingView(d0Var);
        }
        if (d0Var != d0Var2) {
            if (z10) {
                addAnimatingView(d0Var2);
            }
            d0Var.f4108h = d0Var2;
            addAnimatingView(d0Var);
            this.mRecycler.J(d0Var);
            d0Var2.G(false);
            d0Var2.f4109i = d0Var;
        }
        if (this.mItemAnimator.b(d0Var, d0Var2, cVar, cVar2)) {
            postAnimationRunner();
        }
    }

    private void cancelScroll() {
        resetScroll();
        setScrollState(0);
    }

    static void clearNestedRecyclerViewIfNotNested(d0 d0Var) {
        WeakReference weakReference = d0Var.f4102b;
        if (weakReference != null) {
            Object obj = weakReference.get();
            while (true) {
                for (View view = (View) obj; view != null; view = null) {
                    if (view == d0Var.f4101a) {
                        return;
                    }
                    obj = view.getParent();
                    if (obj instanceof View) {
                        break;
                    }
                }
                d0Var.f4102b = null;
                return;
            }
        }
    }

    private void createLayoutManager(Context context, String str, AttributeSet attributeSet, int i10, int i11) {
        Constructor constructor;
        if (str != null) {
            String trim = str.trim();
            if (trim.isEmpty()) {
                return;
            }
            String fullClassName = getFullClassName(context, trim);
            try {
                Class<? extends U> asSubclass = Class.forName(fullClassName, false, isInEditMode() ? getClass().getClassLoader() : context.getClassLoader()).asSubclass(o.class);
                Object[] objArr = null;
                try {
                    constructor = asSubclass.getConstructor(LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE);
                    objArr = new Object[]{context, attributeSet, Integer.valueOf(i10), Integer.valueOf(i11)};
                } catch (NoSuchMethodException e10) {
                    try {
                        constructor = asSubclass.getConstructor(new Class[0]);
                    } catch (NoSuchMethodException e11) {
                        e11.initCause(e10);
                        throw new IllegalStateException(attributeSet.getPositionDescription() + ": Error creating LayoutManager " + fullClassName, e11);
                    }
                }
                constructor.setAccessible(true);
                setLayoutManager((o) constructor.newInstance(objArr));
            } catch (ClassCastException e12) {
                throw new IllegalStateException(attributeSet.getPositionDescription() + ": Class is not a LayoutManager " + fullClassName, e12);
            } catch (ClassNotFoundException e13) {
                throw new IllegalStateException(attributeSet.getPositionDescription() + ": Unable to find LayoutManager " + fullClassName, e13);
            } catch (IllegalAccessException e14) {
                throw new IllegalStateException(attributeSet.getPositionDescription() + ": Cannot access non-public constructor " + fullClassName, e14);
            } catch (InstantiationException e15) {
                throw new IllegalStateException(attributeSet.getPositionDescription() + ": Could not instantiate the LayoutManager: " + fullClassName, e15);
            } catch (InvocationTargetException e16) {
                throw new IllegalStateException(attributeSet.getPositionDescription() + ": Could not instantiate the LayoutManager: " + fullClassName, e16);
            }
        }
    }

    private boolean didChildRangeChange(int i10, int i11) {
        findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        int[] iArr = this.mMinMaxLayoutPositions;
        return (iArr[0] == i10 && iArr[1] == i11) ? false : true;
    }

    private void dispatchContentChangedIfNecessary() {
        int i10 = this.mEatenAccessibilityChangeFlags;
        this.mEatenAccessibilityChangeFlags = 0;
        if (i10 == 0 || !isAccessibilityEnabled()) {
            return;
        }
        AccessibilityEvent obtain = AccessibilityEvent.obtain();
        obtain.setEventType(2048);
        w.b.b(obtain, i10);
        sendAccessibilityEventUnchecked(obtain);
    }

    private void dispatchLayoutStep1() {
        boolean z9 = true;
        this.mState.a(1);
        fillRemainingScrollValues(this.mState);
        this.mState.f4083j = false;
        startInterceptRequestLayout();
        this.mViewInfoStore.f();
        onEnterLayoutOrScroll();
        processAdapterUpdatesAndSetAnimationFlags();
        saveFocusInfo();
        a0 a0Var = this.mState;
        a0Var.f4082i = (a0Var.f4084k && this.mItemsChanged) ? false : false;
        this.mItemsChanged = false;
        this.mItemsAddedOrRemoved = false;
        a0Var.f4081h = a0Var.f4085l;
        a0Var.f4079f = this.mAdapter.c();
        findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        if (this.mState.f4084k) {
            int g10 = this.mChildHelper.g();
            for (int i10 = 0; i10 < g10; i10++) {
                d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.f(i10));
                if (!childViewHolderInt.J() && (!childViewHolderInt.t() || this.mAdapter.g())) {
                    this.mViewInfoStore.e(childViewHolderInt, this.mItemAnimator.t(this.mState, childViewHolderInt, l.e(childViewHolderInt), childViewHolderInt.o()));
                    if (this.mState.f4082i && childViewHolderInt.y() && !childViewHolderInt.v() && !childViewHolderInt.J() && !childViewHolderInt.t()) {
                        this.mViewInfoStore.c(getChangedHolderKey(childViewHolderInt), childViewHolderInt);
                    }
                }
            }
        }
        if (this.mState.f4085l) {
            saveOldPositions();
            a0 a0Var2 = this.mState;
            boolean z10 = a0Var2.f4080g;
            a0Var2.f4080g = false;
            this.mLayout.X0(this.mRecycler, a0Var2);
            this.mState.f4080g = z10;
            for (int i11 = 0; i11 < this.mChildHelper.g(); i11++) {
                d0 childViewHolderInt2 = getChildViewHolderInt(this.mChildHelper.f(i11));
                if (!childViewHolderInt2.J() && !this.mViewInfoStore.i(childViewHolderInt2)) {
                    int e10 = l.e(childViewHolderInt2);
                    boolean p10 = childViewHolderInt2.p(8192);
                    if (!p10) {
                        e10 |= 4096;
                    }
                    l.c t9 = this.mItemAnimator.t(this.mState, childViewHolderInt2, e10, childViewHolderInt2.o());
                    if (p10) {
                        recordAnimationInfoIfBouncedHiddenView(childViewHolderInt2, t9);
                    } else {
                        this.mViewInfoStore.a(childViewHolderInt2, t9);
                    }
                }
            }
        }
        clearOldPositions();
        onExitLayoutOrScroll();
        stopInterceptRequestLayout(false);
        this.mState.f4078e = 2;
    }

    private void dispatchLayoutStep2() {
        startInterceptRequestLayout();
        onEnterLayoutOrScroll();
        this.mState.a(6);
        this.mAdapterHelper.j();
        this.mState.f4079f = this.mAdapter.c();
        a0 a0Var = this.mState;
        a0Var.f4077d = 0;
        a0Var.f4081h = false;
        this.mLayout.X0(this.mRecycler, a0Var);
        a0 a0Var2 = this.mState;
        a0Var2.f4080g = false;
        this.mPendingSavedState = null;
        a0Var2.f4084k = a0Var2.f4084k && this.mItemAnimator != null;
        a0Var2.f4078e = 4;
        onExitLayoutOrScroll();
        stopInterceptRequestLayout(false);
    }

    private void dispatchLayoutStep3() {
        this.mState.a(4);
        startInterceptRequestLayout();
        onEnterLayoutOrScroll();
        a0 a0Var = this.mState;
        a0Var.f4078e = 1;
        if (a0Var.f4084k) {
            for (int g10 = this.mChildHelper.g() - 1; g10 >= 0; g10--) {
                d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.f(g10));
                if (!childViewHolderInt.J()) {
                    long changedHolderKey = getChangedHolderKey(childViewHolderInt);
                    l.c s9 = this.mItemAnimator.s(this.mState, childViewHolderInt);
                    d0 g11 = this.mViewInfoStore.g(changedHolderKey);
                    if (g11 != null && !g11.J()) {
                        boolean h10 = this.mViewInfoStore.h(g11);
                        boolean h11 = this.mViewInfoStore.h(childViewHolderInt);
                        if (!h10 || g11 != childViewHolderInt) {
                            l.c n10 = this.mViewInfoStore.n(g11);
                            this.mViewInfoStore.d(childViewHolderInt, s9);
                            l.c m10 = this.mViewInfoStore.m(childViewHolderInt);
                            if (n10 == null) {
                                handleMissingPreInfoForChangeError(changedHolderKey, childViewHolderInt, g11);
                            } else {
                                animateChange(g11, childViewHolderInt, n10, m10, h10, h11);
                            }
                        }
                    }
                    this.mViewInfoStore.d(childViewHolderInt, s9);
                }
            }
            this.mViewInfoStore.o(this.mViewInfoProcessCallback);
        }
        this.mLayout.l1(this.mRecycler);
        a0 a0Var2 = this.mState;
        a0Var2.f4076c = a0Var2.f4079f;
        this.mDataSetHasChangedAfterLayout = false;
        this.mDispatchItemsChangedEvent = false;
        a0Var2.f4084k = false;
        a0Var2.f4085l = false;
        this.mLayout.f4141h = false;
        ArrayList arrayList = this.mRecycler.f4169b;
        if (arrayList != null) {
            arrayList.clear();
        }
        o oVar = this.mLayout;
        if (oVar.f4147n) {
            oVar.f4146m = 0;
            oVar.f4147n = false;
            this.mRecycler.K();
        }
        this.mLayout.Y0(this.mState);
        onExitLayoutOrScroll();
        stopInterceptRequestLayout(false);
        this.mViewInfoStore.f();
        int[] iArr = this.mMinMaxLayoutPositions;
        if (didChildRangeChange(iArr[0], iArr[1])) {
            dispatchOnScrolled(0, 0);
        }
        recoverFocusFromState();
        resetFocusInfo();
    }

    private boolean dispatchToOnItemTouchListeners(MotionEvent motionEvent) {
        s sVar = this.mInterceptingOnItemTouchListener;
        if (sVar == null) {
            if (motionEvent.getAction() == 0) {
                return false;
            }
            return findInterceptingOnItemTouchListener(motionEvent);
        }
        sVar.a(this, motionEvent);
        int action = motionEvent.getAction();
        if (action == 3 || action == 1) {
            this.mInterceptingOnItemTouchListener = null;
        }
        return true;
    }

    private boolean findInterceptingOnItemTouchListener(MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        int size = this.mOnItemTouchListeners.size();
        for (int i10 = 0; i10 < size; i10++) {
            s sVar = this.mOnItemTouchListeners.get(i10);
            if (sVar.b(this, motionEvent) && action != 3) {
                this.mInterceptingOnItemTouchListener = sVar;
                return true;
            }
        }
        return false;
    }

    private void findMinMaxChildLayoutPositions(int[] iArr) {
        int g10 = this.mChildHelper.g();
        if (g10 == 0) {
            iArr[0] = -1;
            iArr[1] = -1;
            return;
        }
        int i10 = Integer.MAX_VALUE;
        int i11 = UNDEFINED_DURATION;
        for (int i12 = 0; i12 < g10; i12++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.f(i12));
            if (!childViewHolderInt.J()) {
                int m10 = childViewHolderInt.m();
                if (m10 < i10) {
                    i10 = m10;
                }
                if (m10 > i11) {
                    i11 = m10;
                }
            }
        }
        iArr[0] = i10;
        iArr[1] = i11;
    }

    static RecyclerView findNestedRecyclerView(View view) {
        if (view instanceof ViewGroup) {
            if (view instanceof RecyclerView) {
                return (RecyclerView) view;
            }
            ViewGroup viewGroup = (ViewGroup) view;
            int childCount = viewGroup.getChildCount();
            for (int i10 = 0; i10 < childCount; i10++) {
                RecyclerView findNestedRecyclerView = findNestedRecyclerView(viewGroup.getChildAt(i10));
                if (findNestedRecyclerView != null) {
                    return findNestedRecyclerView;
                }
            }
            return null;
        }
        return null;
    }

    private View findNextViewToFocus() {
        d0 findViewHolderForAdapterPosition;
        a0 a0Var = this.mState;
        int i10 = a0Var.f4086m;
        if (i10 == -1) {
            i10 = 0;
        }
        int b10 = a0Var.b();
        for (int i11 = i10; i11 < b10; i11++) {
            d0 findViewHolderForAdapterPosition2 = findViewHolderForAdapterPosition(i11);
            if (findViewHolderForAdapterPosition2 == null) {
                break;
            } else if (findViewHolderForAdapterPosition2.f4101a.hasFocusable()) {
                return findViewHolderForAdapterPosition2.f4101a;
            }
        }
        int min = Math.min(b10, i10);
        while (true) {
            min--;
            if (min < 0 || (findViewHolderForAdapterPosition = findViewHolderForAdapterPosition(min)) == null) {
                return null;
            }
            if (findViewHolderForAdapterPosition.f4101a.hasFocusable()) {
                return findViewHolderForAdapterPosition.f4101a;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static d0 getChildViewHolderInt(View view) {
        if (view == null) {
            return null;
        }
        return ((p) view.getLayoutParams()).f4158a;
    }

    static void getDecoratedBoundsWithMarginsInt(View view, Rect rect) {
        p pVar = (p) view.getLayoutParams();
        Rect rect2 = pVar.f4159b;
        rect.set((view.getLeft() - rect2.left) - ((ViewGroup.MarginLayoutParams) pVar).leftMargin, (view.getTop() - rect2.top) - ((ViewGroup.MarginLayoutParams) pVar).topMargin, view.getRight() + rect2.right + ((ViewGroup.MarginLayoutParams) pVar).rightMargin, view.getBottom() + rect2.bottom + ((ViewGroup.MarginLayoutParams) pVar).bottomMargin);
    }

    private int getDeepestFocusedViewWithId(View view) {
        int id;
        loop0: while (true) {
            id = view.getId();
            while (!view.isFocused() && (view instanceof ViewGroup) && view.hasFocus()) {
                view = ((ViewGroup) view).getFocusedChild();
                if (view.getId() != -1) {
                    break;
                }
            }
        }
        return id;
    }

    private String getFullClassName(Context context, String str) {
        if (str.charAt(0) == '.') {
            return context.getPackageName() + str;
        } else if (str.contains(".")) {
            return str;
        } else {
            return RecyclerView.class.getPackage().getName() + '.' + str;
        }
    }

    private f0 getScrollingChildHelper() {
        if (this.mScrollingChildHelper == null) {
            this.mScrollingChildHelper = new f0(this);
        }
        return this.mScrollingChildHelper;
    }

    private void handleMissingPreInfoForChangeError(long j10, d0 d0Var, d0 d0Var2) {
        int g10 = this.mChildHelper.g();
        for (int i10 = 0; i10 < g10; i10++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.f(i10));
            if (childViewHolderInt != d0Var && getChangedHolderKey(childViewHolderInt) == j10) {
                g gVar = this.mAdapter;
                if (gVar == null || !gVar.g()) {
                    throw new IllegalStateException("Two different ViewHolders have the same change ID. This might happen due to inconsistent Adapter update events or if the LayoutManager lays out the same View multiple times.\n ViewHolder 1:" + childViewHolderInt + " \n View Holder 2:" + d0Var + exceptionLabel());
                }
                throw new IllegalStateException("Two different ViewHolders have the same stable ID. Stable IDs in your adapter MUST BE unique and SHOULD NOT change.\n ViewHolder 1:" + childViewHolderInt + " \n View Holder 2:" + d0Var + exceptionLabel());
            }
        }
        Log.e(TAG, "Problem while matching changed view holders with the newones. The pre-layout information for the change holder " + d0Var2 + " cannot be found but it is necessary for " + d0Var + exceptionLabel());
    }

    private boolean hasUpdatedView() {
        int g10 = this.mChildHelper.g();
        for (int i10 = 0; i10 < g10; i10++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.f(i10));
            if (childViewHolderInt != null && !childViewHolderInt.J() && childViewHolderInt.y()) {
                return true;
            }
        }
        return false;
    }

    @SuppressLint({"InlinedApi"})
    private void initAutofill() {
        if (r0.A(this) == 0) {
            r0.z0(this, 8);
        }
    }

    private void initChildrenHelper() {
        this.mChildHelper = new androidx.recyclerview.widget.b(new e());
    }

    private boolean isPreferredNextFocus(View view, View view2, int i10) {
        int i11;
        if (view2 == null || view2 == this || findContainingItemView(view2) == null) {
            return false;
        }
        if (view == null || findContainingItemView(view) == null) {
            return true;
        }
        this.mTempRect.set(0, 0, view.getWidth(), view.getHeight());
        this.mTempRect2.set(0, 0, view2.getWidth(), view2.getHeight());
        offsetDescendantRectToMyCoords(view, this.mTempRect);
        offsetDescendantRectToMyCoords(view2, this.mTempRect2);
        char c10 = 65535;
        int i12 = this.mLayout.Z() == 1 ? -1 : 1;
        Rect rect = this.mTempRect;
        int i13 = rect.left;
        Rect rect2 = this.mTempRect2;
        int i14 = rect2.left;
        if ((i13 < i14 || rect.right <= i14) && rect.right < rect2.right) {
            i11 = 1;
        } else {
            int i15 = rect.right;
            int i16 = rect2.right;
            i11 = ((i15 > i16 || i13 >= i16) && i13 > i14) ? -1 : 0;
        }
        int i17 = rect.top;
        int i18 = rect2.top;
        if ((i17 < i18 || rect.bottom <= i18) && rect.bottom < rect2.bottom) {
            c10 = 1;
        } else {
            int i19 = rect.bottom;
            int i20 = rect2.bottom;
            if ((i19 <= i20 && i17 < i20) || i17 <= i18) {
                c10 = 0;
            }
        }
        if (i10 == 1) {
            return c10 < 0 || (c10 == 0 && i11 * i12 <= 0);
        } else if (i10 == 2) {
            return c10 > 0 || (c10 == 0 && i11 * i12 >= 0);
        } else if (i10 == 17) {
            return i11 < 0;
        } else if (i10 == 33) {
            return c10 < 0;
        } else if (i10 == 66) {
            return i11 > 0;
        } else if (i10 == 130) {
            return c10 > 0;
        } else {
            throw new IllegalArgumentException("Invalid direction: " + i10 + exceptionLabel());
        }
    }

    private void onPointerUp(MotionEvent motionEvent) {
        int actionIndex = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(actionIndex) == this.mScrollPointerId) {
            int i10 = actionIndex == 0 ? 1 : 0;
            this.mScrollPointerId = motionEvent.getPointerId(i10);
            int x9 = (int) (motionEvent.getX(i10) + 0.5f);
            this.mLastTouchX = x9;
            this.mInitialTouchX = x9;
            int y9 = (int) (motionEvent.getY(i10) + 0.5f);
            this.mLastTouchY = y9;
            this.mInitialTouchY = y9;
        }
    }

    private boolean predictiveItemAnimationsEnabled() {
        return this.mItemAnimator != null && this.mLayout.L1();
    }

    private void processAdapterUpdatesAndSetAnimationFlags() {
        boolean z9;
        if (this.mDataSetHasChangedAfterLayout) {
            this.mAdapterHelper.u();
            if (this.mDispatchItemsChangedEvent) {
                this.mLayout.S0(this);
            }
        }
        if (predictiveItemAnimationsEnabled()) {
            this.mAdapterHelper.s();
        } else {
            this.mAdapterHelper.j();
        }
        boolean z10 = false;
        boolean z11 = this.mItemsAddedOrRemoved || this.mItemsChanged;
        this.mState.f4084k = this.mFirstLayoutComplete && this.mItemAnimator != null && ((z9 = this.mDataSetHasChangedAfterLayout) || z11 || this.mLayout.f4141h) && (!z9 || this.mAdapter.g());
        a0 a0Var = this.mState;
        if (a0Var.f4084k && z11 && !this.mDataSetHasChangedAfterLayout && predictiveItemAnimationsEnabled()) {
            z10 = true;
        }
        a0Var.f4085l = z10;
    }

    /* JADX WARN: Removed duplicated region for block: B:12:0x003d  */
    /* JADX WARN: Removed duplicated region for block: B:13:0x0053  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void pullGlows(float f10, float f11, float f12, float f13) {
        boolean z9;
        EdgeEffect edgeEffect;
        float width;
        float height;
        boolean z10 = true;
        if (f11 < 0.0f) {
            ensureLeftGlow();
            edgeEffect = this.mLeftGlow;
            width = (-f11) / getWidth();
            height = 1.0f - (f12 / getHeight());
        } else if (f11 <= 0.0f) {
            z9 = false;
            if (f13 >= 0.0f) {
                ensureTopGlow();
                androidx.core.widget.e.c(this.mTopGlow, (-f13) / getHeight(), f10 / getWidth());
            } else if (f13 > 0.0f) {
                ensureBottomGlow();
                androidx.core.widget.e.c(this.mBottomGlow, f13 / getHeight(), 1.0f - (f10 / getWidth()));
            } else {
                z10 = z9;
            }
            if (z10 && f11 == 0.0f && f13 == 0.0f) {
                return;
            }
            r0.e0(this);
        } else {
            ensureRightGlow();
            edgeEffect = this.mRightGlow;
            width = f11 / getWidth();
            height = f12 / getHeight();
        }
        androidx.core.widget.e.c(edgeEffect, width, height);
        z9 = true;
        if (f13 >= 0.0f) {
        }
        if (z10) {
        }
        r0.e0(this);
    }

    private void recoverFocusFromState() {
        View findViewById;
        if (!this.mPreserveFocusAfterLayout || this.mAdapter == null || !hasFocus() || getDescendantFocusability() == 393216) {
            return;
        }
        if (getDescendantFocusability() == 131072 && isFocused()) {
            return;
        }
        if (!isFocused()) {
            View focusedChild = getFocusedChild();
            if (!IGNORE_DETACHED_FOCUSED_CHILD || (focusedChild.getParent() != null && focusedChild.hasFocus())) {
                if (!this.mChildHelper.n(focusedChild)) {
                    return;
                }
            } else if (this.mChildHelper.g() == 0) {
                requestFocus();
                return;
            }
        }
        View view = null;
        d0 findViewHolderForItemId = (this.mState.f4087n == -1 || !this.mAdapter.g()) ? null : findViewHolderForItemId(this.mState.f4087n);
        if (findViewHolderForItemId != null && !this.mChildHelper.n(findViewHolderForItemId.f4101a) && findViewHolderForItemId.f4101a.hasFocusable()) {
            view = findViewHolderForItemId.f4101a;
        } else if (this.mChildHelper.g() > 0) {
            view = findNextViewToFocus();
        }
        if (view != null) {
            int i10 = this.mState.f4088o;
            if (i10 != -1 && (findViewById = view.findViewById(i10)) != null && findViewById.isFocusable()) {
                view = findViewById;
            }
            view.requestFocus();
        }
    }

    private void releaseGlows() {
        boolean z9;
        EdgeEffect edgeEffect = this.mLeftGlow;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
            z9 = this.mLeftGlow.isFinished();
        } else {
            z9 = false;
        }
        EdgeEffect edgeEffect2 = this.mTopGlow;
        if (edgeEffect2 != null) {
            edgeEffect2.onRelease();
            z9 |= this.mTopGlow.isFinished();
        }
        EdgeEffect edgeEffect3 = this.mRightGlow;
        if (edgeEffect3 != null) {
            edgeEffect3.onRelease();
            z9 |= this.mRightGlow.isFinished();
        }
        EdgeEffect edgeEffect4 = this.mBottomGlow;
        if (edgeEffect4 != null) {
            edgeEffect4.onRelease();
            z9 |= this.mBottomGlow.isFinished();
        }
        if (z9) {
            r0.e0(this);
        }
    }

    private void requestChildOnScreen(View view, View view2) {
        View view3 = view2 != null ? view2 : view;
        this.mTempRect.set(0, 0, view3.getWidth(), view3.getHeight());
        ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
        if (layoutParams instanceof p) {
            p pVar = (p) layoutParams;
            if (!pVar.f4160c) {
                Rect rect = pVar.f4159b;
                Rect rect2 = this.mTempRect;
                rect2.left -= rect.left;
                rect2.right += rect.right;
                rect2.top -= rect.top;
                rect2.bottom += rect.bottom;
            }
        }
        if (view2 != null) {
            offsetDescendantRectToMyCoords(view2, this.mTempRect);
            offsetRectIntoDescendantCoords(view, this.mTempRect);
        }
        this.mLayout.s1(this, view, this.mTempRect, !this.mFirstLayoutComplete, view2 == null);
    }

    private void resetFocusInfo() {
        a0 a0Var = this.mState;
        a0Var.f4087n = -1L;
        a0Var.f4086m = -1;
        a0Var.f4088o = -1;
    }

    private void resetScroll() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.clear();
        }
        stopNestedScroll(0);
        releaseGlows();
    }

    private void saveFocusInfo() {
        View focusedChild = (this.mPreserveFocusAfterLayout && hasFocus() && this.mAdapter != null) ? getFocusedChild() : null;
        d0 findContainingViewHolder = focusedChild != null ? findContainingViewHolder(focusedChild) : null;
        if (findContainingViewHolder == null) {
            resetFocusInfo();
            return;
        }
        this.mState.f4087n = this.mAdapter.g() ? findContainingViewHolder.k() : -1L;
        this.mState.f4086m = this.mDataSetHasChangedAfterLayout ? -1 : findContainingViewHolder.v() ? findContainingViewHolder.f4104d : findContainingViewHolder.j();
        this.mState.f4088o = getDeepestFocusedViewWithId(findContainingViewHolder.f4101a);
    }

    private void setAdapterInternal(g gVar, boolean z9, boolean z10) {
        g gVar2 = this.mAdapter;
        if (gVar2 != null) {
            gVar2.t(this.mObserver);
            this.mAdapter.m(this);
        }
        if (!z9 || z10) {
            removeAndRecycleViews();
        }
        this.mAdapterHelper.u();
        g gVar3 = this.mAdapter;
        this.mAdapter = gVar;
        if (gVar != null) {
            gVar.r(this.mObserver);
            gVar.i(this);
        }
        o oVar = this.mLayout;
        if (oVar != null) {
            oVar.E0(gVar3, this.mAdapter);
        }
        this.mRecycler.x(gVar3, this.mAdapter, z9);
        this.mState.f4080g = true;
    }

    private void stopScrollersInternal() {
        this.mViewFlinger.g();
        o oVar = this.mLayout;
        if (oVar != null) {
            oVar.K1();
        }
    }

    void absorbGlows(int i10, int i11) {
        if (i10 < 0) {
            ensureLeftGlow();
            if (this.mLeftGlow.isFinished()) {
                this.mLeftGlow.onAbsorb(-i10);
            }
        } else if (i10 > 0) {
            ensureRightGlow();
            if (this.mRightGlow.isFinished()) {
                this.mRightGlow.onAbsorb(i10);
            }
        }
        if (i11 < 0) {
            ensureTopGlow();
            if (this.mTopGlow.isFinished()) {
                this.mTopGlow.onAbsorb(-i11);
            }
        } else if (i11 > 0) {
            ensureBottomGlow();
            if (this.mBottomGlow.isFinished()) {
                this.mBottomGlow.onAbsorb(i11);
            }
        }
        if (i10 == 0 && i11 == 0) {
            return;
        }
        r0.e0(this);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void addFocusables(ArrayList<View> arrayList, int i10, int i11) {
        o oVar = this.mLayout;
        if (oVar == null || !oVar.F0(this, arrayList, i10, i11)) {
            super.addFocusables(arrayList, i10, i11);
        }
    }

    public void addItemDecoration(n nVar) {
        addItemDecoration(nVar, -1);
    }

    public void addItemDecoration(n nVar, int i10) {
        o oVar = this.mLayout;
        if (oVar != null) {
            oVar.g("Cannot add item decoration during a scroll  or layout");
        }
        if (this.mItemDecorations.isEmpty()) {
            setWillNotDraw(false);
        }
        if (i10 < 0) {
            this.mItemDecorations.add(nVar);
        } else {
            this.mItemDecorations.add(i10, nVar);
        }
        markItemDecorInsetsDirty();
        requestLayout();
    }

    public void addOnChildAttachStateChangeListener(q qVar) {
        if (this.mOnChildAttachStateListeners == null) {
            this.mOnChildAttachStateListeners = new ArrayList();
        }
        this.mOnChildAttachStateListeners.add(qVar);
    }

    public void addOnItemTouchListener(s sVar) {
        this.mOnItemTouchListeners.add(sVar);
    }

    public void addOnScrollListener(t tVar) {
        if (this.mScrollListeners == null) {
            this.mScrollListeners = new ArrayList();
        }
        this.mScrollListeners.add(tVar);
    }

    void animateAppearance(d0 d0Var, l.c cVar, l.c cVar2) {
        d0Var.G(false);
        if (this.mItemAnimator.a(d0Var, cVar, cVar2)) {
            postAnimationRunner();
        }
    }

    void animateDisappearance(d0 d0Var, l.c cVar, l.c cVar2) {
        addAnimatingView(d0Var);
        d0Var.G(false);
        if (this.mItemAnimator.c(d0Var, cVar, cVar2)) {
            postAnimationRunner();
        }
    }

    void assertInLayoutOrScroll(String str) {
        if (isComputingLayout()) {
            return;
        }
        if (str == null) {
            throw new IllegalStateException("Cannot call this method unless RecyclerView is computing a layout or scrolling" + exceptionLabel());
        }
        throw new IllegalStateException(str + exceptionLabel());
    }

    void assertNotInLayoutOrScroll(String str) {
        if (isComputingLayout()) {
            if (str != null) {
                throw new IllegalStateException(str);
            }
            throw new IllegalStateException("Cannot call this method while RecyclerView is computing a layout or scrolling" + exceptionLabel());
        } else if (this.mDispatchScrollCounter > 0) {
            Log.w(TAG, "Cannot call this method in a scroll callback. Scroll callbacks mightbe run during a measure & layout pass where you cannot change theRecyclerView data. Any method call that might change the structureof the RecyclerView or the adapter contents should be postponed tothe next frame.", new IllegalStateException("" + exceptionLabel()));
        }
    }

    boolean canReuseUpdatedViewHolder(d0 d0Var) {
        l lVar = this.mItemAnimator;
        return lVar == null || lVar.g(d0Var, d0Var.o());
    }

    @Override // android.view.ViewGroup
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof p) && this.mLayout.m((p) layoutParams);
    }

    void clearOldPositions() {
        int j10 = this.mChildHelper.j();
        for (int i10 = 0; i10 < j10; i10++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.i(i10));
            if (!childViewHolderInt.J()) {
                childViewHolderInt.c();
            }
        }
        this.mRecycler.d();
    }

    public void clearOnChildAttachStateChangeListeners() {
        List<q> list = this.mOnChildAttachStateListeners;
        if (list != null) {
            list.clear();
        }
    }

    public void clearOnScrollListeners() {
        List<t> list = this.mScrollListeners;
        if (list != null) {
            list.clear();
        }
    }

    @Override // android.view.View
    public int computeHorizontalScrollExtent() {
        o oVar = this.mLayout;
        if (oVar != null && oVar.k()) {
            return this.mLayout.q(this.mState);
        }
        return 0;
    }

    @Override // android.view.View
    public int computeHorizontalScrollOffset() {
        o oVar = this.mLayout;
        if (oVar != null && oVar.k()) {
            return this.mLayout.r(this.mState);
        }
        return 0;
    }

    @Override // android.view.View
    public int computeHorizontalScrollRange() {
        o oVar = this.mLayout;
        if (oVar != null && oVar.k()) {
            return this.mLayout.s(this.mState);
        }
        return 0;
    }

    @Override // android.view.View
    public int computeVerticalScrollExtent() {
        o oVar = this.mLayout;
        if (oVar != null && oVar.l()) {
            return this.mLayout.t(this.mState);
        }
        return 0;
    }

    @Override // android.view.View
    public int computeVerticalScrollOffset() {
        o oVar = this.mLayout;
        if (oVar != null && oVar.l()) {
            return this.mLayout.u(this.mState);
        }
        return 0;
    }

    @Override // android.view.View
    public int computeVerticalScrollRange() {
        o oVar = this.mLayout;
        if (oVar != null && oVar.l()) {
            return this.mLayout.v(this.mState);
        }
        return 0;
    }

    void considerReleasingGlowsOnScroll(int i10, int i11) {
        boolean z9;
        EdgeEffect edgeEffect = this.mLeftGlow;
        if (edgeEffect == null || edgeEffect.isFinished() || i10 <= 0) {
            z9 = false;
        } else {
            this.mLeftGlow.onRelease();
            z9 = this.mLeftGlow.isFinished();
        }
        EdgeEffect edgeEffect2 = this.mRightGlow;
        if (edgeEffect2 != null && !edgeEffect2.isFinished() && i10 < 0) {
            this.mRightGlow.onRelease();
            z9 |= this.mRightGlow.isFinished();
        }
        EdgeEffect edgeEffect3 = this.mTopGlow;
        if (edgeEffect3 != null && !edgeEffect3.isFinished() && i11 > 0) {
            this.mTopGlow.onRelease();
            z9 |= this.mTopGlow.isFinished();
        }
        EdgeEffect edgeEffect4 = this.mBottomGlow;
        if (edgeEffect4 != null && !edgeEffect4.isFinished() && i11 < 0) {
            this.mBottomGlow.onRelease();
            z9 |= this.mBottomGlow.isFinished();
        }
        if (z9) {
            r0.e0(this);
        }
    }

    void consumePendingUpdateOperations() {
        if (!this.mFirstLayoutComplete || this.mDataSetHasChangedAfterLayout) {
            androidx.core.os.l.a(TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
            dispatchLayout();
            androidx.core.os.l.b();
        } else if (this.mAdapterHelper.p()) {
            if (this.mAdapterHelper.o(4) && !this.mAdapterHelper.o(11)) {
                androidx.core.os.l.a(TRACE_HANDLE_ADAPTER_UPDATES_TAG);
                startInterceptRequestLayout();
                onEnterLayoutOrScroll();
                this.mAdapterHelper.s();
                if (!this.mLayoutWasDefered) {
                    if (hasUpdatedView()) {
                        dispatchLayout();
                    } else {
                        this.mAdapterHelper.i();
                    }
                }
                stopInterceptRequestLayout(true);
                onExitLayoutOrScroll();
            } else if (!this.mAdapterHelper.p()) {
                return;
            } else {
                androidx.core.os.l.a(TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
                dispatchLayout();
            }
            androidx.core.os.l.b();
        }
    }

    void defaultOnMeasure(int i10, int i11) {
        setMeasuredDimension(o.n(i10, getPaddingLeft() + getPaddingRight(), r0.D(this)), o.n(i11, getPaddingTop() + getPaddingBottom(), r0.C(this)));
    }

    void dispatchChildAttached(View view) {
        d0 childViewHolderInt = getChildViewHolderInt(view);
        onChildAttachedToWindow(view);
        g gVar = this.mAdapter;
        if (gVar != null && childViewHolderInt != null) {
            gVar.o(childViewHolderInt);
        }
        List<q> list = this.mOnChildAttachStateListeners;
        if (list != null) {
            for (int size = list.size() - 1; size >= 0; size--) {
                this.mOnChildAttachStateListeners.get(size).b(view);
            }
        }
    }

    void dispatchChildDetached(View view) {
        d0 childViewHolderInt = getChildViewHolderInt(view);
        onChildDetachedFromWindow(view);
        g gVar = this.mAdapter;
        if (gVar != null && childViewHolderInt != null) {
            gVar.p(childViewHolderInt);
        }
        List<q> list = this.mOnChildAttachStateListeners;
        if (list != null) {
            for (int size = list.size() - 1; size >= 0; size--) {
                this.mOnChildAttachStateListeners.get(size).a(view);
            }
        }
    }

    void dispatchLayout() {
        String str;
        if (this.mAdapter == null) {
            str = "No adapter attached; skipping layout";
        } else if (this.mLayout != null) {
            a0 a0Var = this.mState;
            a0Var.f4083j = false;
            if (a0Var.f4078e == 1) {
                dispatchLayoutStep1();
            } else if (!this.mAdapterHelper.q() && this.mLayout.o0() == getWidth() && this.mLayout.W() == getHeight()) {
                this.mLayout.z1(this);
                dispatchLayoutStep3();
                return;
            }
            this.mLayout.z1(this);
            dispatchLayoutStep2();
            dispatchLayoutStep3();
            return;
        } else {
            str = "No layout manager attached; skipping layout";
        }
        Log.e(TAG, str);
    }

    @Override // android.view.View
    public boolean dispatchNestedFling(float f10, float f11, boolean z9) {
        return getScrollingChildHelper().a(f10, f11, z9);
    }

    @Override // android.view.View
    public boolean dispatchNestedPreFling(float f10, float f11) {
        return getScrollingChildHelper().b(f10, f11);
    }

    @Override // android.view.View
    public boolean dispatchNestedPreScroll(int i10, int i11, int[] iArr, int[] iArr2) {
        return getScrollingChildHelper().c(i10, i11, iArr, iArr2);
    }

    public boolean dispatchNestedPreScroll(int i10, int i11, int[] iArr, int[] iArr2, int i12) {
        return getScrollingChildHelper().d(i10, i11, iArr, iArr2, i12);
    }

    public final void dispatchNestedScroll(int i10, int i11, int i12, int i13, int[] iArr, int i14, int[] iArr2) {
        getScrollingChildHelper().e(i10, i11, i12, i13, iArr, i14, iArr2);
    }

    @Override // android.view.View
    public boolean dispatchNestedScroll(int i10, int i11, int i12, int i13, int[] iArr) {
        return getScrollingChildHelper().f(i10, i11, i12, i13, iArr);
    }

    public boolean dispatchNestedScroll(int i10, int i11, int i12, int i13, int[] iArr, int i14) {
        return getScrollingChildHelper().g(i10, i11, i12, i13, iArr, i14);
    }

    void dispatchOnScrollStateChanged(int i10) {
        o oVar = this.mLayout;
        if (oVar != null) {
            oVar.e1(i10);
        }
        onScrollStateChanged(i10);
        t tVar = this.mScrollListener;
        if (tVar != null) {
            tVar.a(this, i10);
        }
        List<t> list = this.mScrollListeners;
        if (list != null) {
            for (int size = list.size() - 1; size >= 0; size--) {
                this.mScrollListeners.get(size).a(this, i10);
            }
        }
    }

    void dispatchOnScrolled(int i10, int i11) {
        this.mDispatchScrollCounter++;
        int scrollX = getScrollX();
        int scrollY = getScrollY();
        onScrollChanged(scrollX, scrollY, scrollX - i10, scrollY - i11);
        onScrolled(i10, i11);
        t tVar = this.mScrollListener;
        if (tVar != null) {
            tVar.b(this, i10, i11);
        }
        List<t> list = this.mScrollListeners;
        if (list != null) {
            for (int size = list.size() - 1; size >= 0; size--) {
                this.mScrollListeners.get(size).b(this, i10, i11);
            }
        }
        this.mDispatchScrollCounter--;
    }

    void dispatchPendingImportantForAccessibilityChanges() {
        int i10;
        for (int size = this.mPendingAccessibilityImportanceChange.size() - 1; size >= 0; size--) {
            d0 d0Var = this.mPendingAccessibilityImportanceChange.get(size);
            if (d0Var.f4101a.getParent() == this && !d0Var.J() && (i10 = d0Var.f4117q) != -1) {
                r0.x0(d0Var.f4101a, i10);
                d0Var.f4117q = -1;
            }
        }
        this.mPendingAccessibilityImportanceChange.clear();
    }

    @Override // android.view.View
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        onPopulateAccessibilityEvent(accessibilityEvent);
        return true;
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        dispatchThawSelfOnly(sparseArray);
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        dispatchFreezeSelfOnly(sparseArray);
    }

    @Override // android.view.View
    public void draw(Canvas canvas) {
        boolean z9;
        float f10;
        int i10;
        super.draw(canvas);
        int size = this.mItemDecorations.size();
        boolean z10 = false;
        for (int i11 = 0; i11 < size; i11++) {
            this.mItemDecorations.get(i11).i(canvas, this, this.mState);
        }
        EdgeEffect edgeEffect = this.mLeftGlow;
        boolean z11 = true;
        if (edgeEffect == null || edgeEffect.isFinished()) {
            z9 = false;
        } else {
            int save = canvas.save();
            int paddingBottom = this.mClipToPadding ? getPaddingBottom() : 0;
            canvas.rotate(270.0f);
            canvas.translate((-getHeight()) + paddingBottom, 0.0f);
            EdgeEffect edgeEffect2 = this.mLeftGlow;
            z9 = edgeEffect2 != null && edgeEffect2.draw(canvas);
            canvas.restoreToCount(save);
        }
        EdgeEffect edgeEffect3 = this.mTopGlow;
        if (edgeEffect3 != null && !edgeEffect3.isFinished()) {
            int save2 = canvas.save();
            if (this.mClipToPadding) {
                canvas.translate(getPaddingLeft(), getPaddingTop());
            }
            EdgeEffect edgeEffect4 = this.mTopGlow;
            z9 |= edgeEffect4 != null && edgeEffect4.draw(canvas);
            canvas.restoreToCount(save2);
        }
        EdgeEffect edgeEffect5 = this.mRightGlow;
        if (edgeEffect5 != null && !edgeEffect5.isFinished()) {
            int save3 = canvas.save();
            int width = getWidth();
            int paddingTop = this.mClipToPadding ? getPaddingTop() : 0;
            canvas.rotate(90.0f);
            canvas.translate(-paddingTop, -width);
            EdgeEffect edgeEffect6 = this.mRightGlow;
            z9 |= edgeEffect6 != null && edgeEffect6.draw(canvas);
            canvas.restoreToCount(save3);
        }
        EdgeEffect edgeEffect7 = this.mBottomGlow;
        if (edgeEffect7 != null && !edgeEffect7.isFinished()) {
            int save4 = canvas.save();
            canvas.rotate(180.0f);
            if (this.mClipToPadding) {
                f10 = (-getWidth()) + getPaddingRight();
                i10 = (-getHeight()) + getPaddingBottom();
            } else {
                f10 = -getWidth();
                i10 = -getHeight();
            }
            canvas.translate(f10, i10);
            EdgeEffect edgeEffect8 = this.mBottomGlow;
            if (edgeEffect8 != null && edgeEffect8.draw(canvas)) {
                z10 = true;
            }
            z9 |= z10;
            canvas.restoreToCount(save4);
        }
        if (z9 || this.mItemAnimator == null || this.mItemDecorations.size() <= 0 || !this.mItemAnimator.p()) {
            z11 = z9;
        }
        if (z11) {
            r0.e0(this);
        }
    }

    @Override // android.view.ViewGroup
    public boolean drawChild(Canvas canvas, View view, long j10) {
        return super.drawChild(canvas, view, j10);
    }

    void ensureBottomGlow() {
        int measuredWidth;
        int measuredHeight;
        if (this.mBottomGlow != null) {
            return;
        }
        EdgeEffect a10 = this.mEdgeEffectFactory.a(this, 3);
        this.mBottomGlow = a10;
        if (this.mClipToPadding) {
            measuredWidth = (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight();
            measuredHeight = (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom();
        } else {
            measuredWidth = getMeasuredWidth();
            measuredHeight = getMeasuredHeight();
        }
        a10.setSize(measuredWidth, measuredHeight);
    }

    void ensureLeftGlow() {
        int measuredHeight;
        int measuredWidth;
        if (this.mLeftGlow != null) {
            return;
        }
        EdgeEffect a10 = this.mEdgeEffectFactory.a(this, 0);
        this.mLeftGlow = a10;
        if (this.mClipToPadding) {
            measuredHeight = (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom();
            measuredWidth = (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight();
        } else {
            measuredHeight = getMeasuredHeight();
            measuredWidth = getMeasuredWidth();
        }
        a10.setSize(measuredHeight, measuredWidth);
    }

    void ensureRightGlow() {
        int measuredHeight;
        int measuredWidth;
        if (this.mRightGlow != null) {
            return;
        }
        EdgeEffect a10 = this.mEdgeEffectFactory.a(this, 2);
        this.mRightGlow = a10;
        if (this.mClipToPadding) {
            measuredHeight = (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom();
            measuredWidth = (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight();
        } else {
            measuredHeight = getMeasuredHeight();
            measuredWidth = getMeasuredWidth();
        }
        a10.setSize(measuredHeight, measuredWidth);
    }

    void ensureTopGlow() {
        int measuredWidth;
        int measuredHeight;
        if (this.mTopGlow != null) {
            return;
        }
        EdgeEffect a10 = this.mEdgeEffectFactory.a(this, 1);
        this.mTopGlow = a10;
        if (this.mClipToPadding) {
            measuredWidth = (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight();
            measuredHeight = (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom();
        } else {
            measuredWidth = getMeasuredWidth();
            measuredHeight = getMeasuredHeight();
        }
        a10.setSize(measuredWidth, measuredHeight);
    }

    String exceptionLabel() {
        return " " + super.toString() + ", adapter:" + this.mAdapter + ", layout:" + this.mLayout + ", context:" + getContext();
    }

    final void fillRemainingScrollValues(a0 a0Var) {
        if (getScrollState() != 2) {
            a0Var.f4089p = 0;
            a0Var.f4090q = 0;
            return;
        }
        OverScroller overScroller = this.mViewFlinger.f4094i;
        a0Var.f4089p = overScroller.getFinalX() - overScroller.getCurrX();
        a0Var.f4090q = overScroller.getFinalY() - overScroller.getCurrY();
    }

    public View findChildViewUnder(float f10, float f11) {
        for (int g10 = this.mChildHelper.g() - 1; g10 >= 0; g10--) {
            View f12 = this.mChildHelper.f(g10);
            float translationX = f12.getTranslationX();
            float translationY = f12.getTranslationY();
            if (f10 >= f12.getLeft() + translationX && f10 <= f12.getRight() + translationX && f11 >= f12.getTop() + translationY && f11 <= f12.getBottom() + translationY) {
                return f12;
            }
        }
        return null;
    }

    /* JADX WARN: Code restructure failed: missing block: B:15:?, code lost:
        return r3;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public View findContainingItemView(View view) {
        while (true) {
            ViewParent parent = view.getParent();
            if (parent == null || parent == this || !(parent instanceof View)) {
                break;
            }
            view = (View) parent;
        }
        return null;
    }

    public d0 findContainingViewHolder(View view) {
        View findContainingItemView = findContainingItemView(view);
        if (findContainingItemView == null) {
            return null;
        }
        return getChildViewHolder(findContainingItemView);
    }

    public d0 findViewHolderForAdapterPosition(int i10) {
        d0 d0Var = null;
        if (this.mDataSetHasChangedAfterLayout) {
            return null;
        }
        int j10 = this.mChildHelper.j();
        for (int i11 = 0; i11 < j10; i11++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.i(i11));
            if (childViewHolderInt != null && !childViewHolderInt.v() && getAdapterPositionFor(childViewHolderInt) == i10) {
                if (!this.mChildHelper.n(childViewHolderInt.f4101a)) {
                    return childViewHolderInt;
                }
                d0Var = childViewHolderInt;
            }
        }
        return d0Var;
    }

    public d0 findViewHolderForItemId(long j10) {
        g gVar = this.mAdapter;
        d0 d0Var = null;
        if (gVar != null && gVar.g()) {
            int j11 = this.mChildHelper.j();
            for (int i10 = 0; i10 < j11; i10++) {
                d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.i(i10));
                if (childViewHolderInt != null && !childViewHolderInt.v() && childViewHolderInt.k() == j10) {
                    if (!this.mChildHelper.n(childViewHolderInt.f4101a)) {
                        return childViewHolderInt;
                    }
                    d0Var = childViewHolderInt;
                }
            }
        }
        return d0Var;
    }

    public d0 findViewHolderForLayoutPosition(int i10) {
        return findViewHolderForPosition(i10, false);
    }

    @Deprecated
    public d0 findViewHolderForPosition(int i10) {
        return findViewHolderForPosition(i10, false);
    }

    /* JADX WARN: Removed duplicated region for block: B:17:0x0034  */
    /* JADX WARN: Removed duplicated region for block: B:22:0x0036 A[SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    d0 findViewHolderForPosition(int i10, boolean z9) {
        int j10 = this.mChildHelper.j();
        d0 d0Var = null;
        for (int i11 = 0; i11 < j10; i11++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.i(i11));
            if (childViewHolderInt != null && !childViewHolderInt.v()) {
                if (z9) {
                    if (childViewHolderInt.f4103c != i10) {
                        continue;
                    }
                    if (this.mChildHelper.n(childViewHolderInt.f4101a)) {
                        return childViewHolderInt;
                    }
                    d0Var = childViewHolderInt;
                } else {
                    if (childViewHolderInt.m() != i10) {
                        continue;
                    }
                    if (this.mChildHelper.n(childViewHolderInt.f4101a)) {
                    }
                }
            }
        }
        return d0Var;
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r0v1, types: [boolean] */
    /* JADX WARN: Type inference failed for: r0v6 */
    public boolean fling(int i10, int i11) {
        o oVar = this.mLayout;
        if (oVar == null) {
            Log.e(TAG, "Cannot fling without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return false;
        } else if (this.mLayoutSuppressed) {
            return false;
        } else {
            int k10 = oVar.k();
            boolean l10 = this.mLayout.l();
            i10 = (k10 == 0 || Math.abs(i10) < this.mMinFlingVelocity) ? 0 : 0;
            i11 = (!l10 || Math.abs(i11) < this.mMinFlingVelocity) ? 0 : 0;
            if (i10 == 0 && i11 == 0) {
                return false;
            }
            float f10 = i10;
            float f11 = i11;
            if (!dispatchNestedPreFling(f10, f11)) {
                boolean z9 = k10 != 0 || l10;
                dispatchNestedFling(f10, f11, z9);
                r rVar = this.mOnFlingListener;
                if (rVar != null && rVar.a(i10, i11)) {
                    return true;
                }
                if (z9) {
                    if (l10) {
                        k10 = (k10 == true ? 1 : 0) | 2;
                    }
                    startNestedScroll(k10, 1);
                    int i12 = this.mMaxFlingVelocity;
                    int max = Math.max(-i12, Math.min(i10, i12));
                    int i13 = this.mMaxFlingVelocity;
                    this.mViewFlinger.c(max, Math.max(-i13, Math.min(i11, i13)));
                    return true;
                }
            }
            return false;
        }
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public View focusSearch(View view, int i10) {
        View view2;
        boolean z9;
        View Q0 = this.mLayout.Q0(view, i10);
        if (Q0 != null) {
            return Q0;
        }
        boolean z10 = (this.mAdapter == null || this.mLayout == null || isComputingLayout() || this.mLayoutSuppressed) ? false : true;
        FocusFinder focusFinder = FocusFinder.getInstance();
        if (z10 && (i10 == 2 || i10 == 1)) {
            if (this.mLayout.l()) {
                int i11 = i10 == 2 ? 130 : 33;
                z9 = focusFinder.findNextFocus(this, view, i11) == null;
                if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                    i10 = i11;
                }
            } else {
                z9 = false;
            }
            if (!z9 && this.mLayout.k()) {
                int i12 = (this.mLayout.Z() == 1) ^ (i10 == 2) ? 66 : 17;
                boolean z11 = focusFinder.findNextFocus(this, view, i12) == null;
                if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                    i10 = i12;
                }
                z9 = z11;
            }
            if (z9) {
                consumePendingUpdateOperations();
                if (findContainingItemView(view) == null) {
                    return null;
                }
                startInterceptRequestLayout();
                this.mLayout.J0(view, i10, this.mRecycler, this.mState);
                stopInterceptRequestLayout(false);
            }
            view2 = focusFinder.findNextFocus(this, view, i10);
        } else {
            View findNextFocus = focusFinder.findNextFocus(this, view, i10);
            if (findNextFocus == null && z10) {
                consumePendingUpdateOperations();
                if (findContainingItemView(view) == null) {
                    return null;
                }
                startInterceptRequestLayout();
                view2 = this.mLayout.J0(view, i10, this.mRecycler, this.mState);
                stopInterceptRequestLayout(false);
            } else {
                view2 = findNextFocus;
            }
        }
        if (view2 == null || view2.hasFocusable()) {
            return isPreferredNextFocus(view, view2, i10) ? view2 : super.focusSearch(view, i10);
        } else if (getFocusedChild() == null) {
            return super.focusSearch(view, i10);
        } else {
            requestChildOnScreen(view2, null);
            return view;
        }
    }

    @Override // android.view.ViewGroup
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        o oVar = this.mLayout;
        if (oVar != null) {
            return oVar.D();
        }
        throw new IllegalStateException("RecyclerView has no LayoutManager" + exceptionLabel());
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        o oVar = this.mLayout;
        if (oVar != null) {
            return oVar.E(getContext(), attributeSet);
        }
        throw new IllegalStateException("RecyclerView has no LayoutManager" + exceptionLabel());
    }

    @Override // android.view.ViewGroup
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        o oVar = this.mLayout;
        if (oVar != null) {
            return oVar.F(layoutParams);
        }
        throw new IllegalStateException("RecyclerView has no LayoutManager" + exceptionLabel());
    }

    @Override // android.view.ViewGroup, android.view.View
    public CharSequence getAccessibilityClassName() {
        return "androidx.recyclerview.widget.RecyclerView";
    }

    public g getAdapter() {
        return this.mAdapter;
    }

    int getAdapterPositionFor(d0 d0Var) {
        if (d0Var.p(524) || !d0Var.s()) {
            return -1;
        }
        return this.mAdapterHelper.e(d0Var.f4103c);
    }

    @Override // android.view.View
    public int getBaseline() {
        o oVar = this.mLayout;
        return oVar != null ? oVar.G() : super.getBaseline();
    }

    long getChangedHolderKey(d0 d0Var) {
        return this.mAdapter.g() ? d0Var.k() : d0Var.f4103c;
    }

    public int getChildAdapterPosition(View view) {
        d0 childViewHolderInt = getChildViewHolderInt(view);
        if (childViewHolderInt != null) {
            return childViewHolderInt.j();
        }
        return -1;
    }

    @Override // android.view.ViewGroup
    protected int getChildDrawingOrder(int i10, int i11) {
        j jVar = this.mChildDrawingOrderCallback;
        return jVar == null ? super.getChildDrawingOrder(i10, i11) : jVar.a(i10, i11);
    }

    public long getChildItemId(View view) {
        d0 childViewHolderInt;
        g gVar = this.mAdapter;
        if (gVar == null || !gVar.g() || (childViewHolderInt = getChildViewHolderInt(view)) == null) {
            return -1L;
        }
        return childViewHolderInt.k();
    }

    public int getChildLayoutPosition(View view) {
        d0 childViewHolderInt = getChildViewHolderInt(view);
        if (childViewHolderInt != null) {
            return childViewHolderInt.m();
        }
        return -1;
    }

    @Deprecated
    public int getChildPosition(View view) {
        return getChildAdapterPosition(view);
    }

    public d0 getChildViewHolder(View view) {
        ViewParent parent = view.getParent();
        if (parent == null || parent == this) {
            return getChildViewHolderInt(view);
        }
        throw new IllegalArgumentException("View " + view + " is not a direct child of " + this);
    }

    @Override // android.view.ViewGroup
    public boolean getClipToPadding() {
        return this.mClipToPadding;
    }

    public androidx.recyclerview.widget.k getCompatAccessibilityDelegate() {
        return this.mAccessibilityDelegate;
    }

    public void getDecoratedBoundsWithMargins(View view, Rect rect) {
        getDecoratedBoundsWithMarginsInt(view, rect);
    }

    public k getEdgeEffectFactory() {
        return this.mEdgeEffectFactory;
    }

    public l getItemAnimator() {
        return this.mItemAnimator;
    }

    Rect getItemDecorInsetsForChild(View view) {
        p pVar = (p) view.getLayoutParams();
        if (pVar.f4160c) {
            if (this.mState.e() && (pVar.b() || pVar.d())) {
                return pVar.f4159b;
            }
            Rect rect = pVar.f4159b;
            rect.set(0, 0, 0, 0);
            int size = this.mItemDecorations.size();
            for (int i10 = 0; i10 < size; i10++) {
                this.mTempRect.set(0, 0, 0, 0);
                this.mItemDecorations.get(i10).e(this.mTempRect, view, this, this.mState);
                int i11 = rect.left;
                Rect rect2 = this.mTempRect;
                rect.left = i11 + rect2.left;
                rect.top += rect2.top;
                rect.right += rect2.right;
                rect.bottom += rect2.bottom;
            }
            pVar.f4160c = false;
            return rect;
        }
        return pVar.f4159b;
    }

    public n getItemDecorationAt(int i10) {
        int itemDecorationCount = getItemDecorationCount();
        if (i10 < 0 || i10 >= itemDecorationCount) {
            throw new IndexOutOfBoundsException(i10 + " is an invalid index for size " + itemDecorationCount);
        }
        return this.mItemDecorations.get(i10);
    }

    public int getItemDecorationCount() {
        return this.mItemDecorations.size();
    }

    public o getLayoutManager() {
        return this.mLayout;
    }

    public int getMaxFlingVelocity() {
        return this.mMaxFlingVelocity;
    }

    public int getMinFlingVelocity() {
        return this.mMinFlingVelocity;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public long getNanoTime() {
        if (ALLOW_THREAD_GAP_WORK) {
            return System.nanoTime();
        }
        return 0L;
    }

    public r getOnFlingListener() {
        return this.mOnFlingListener;
    }

    public boolean getPreserveFocusAfterLayout() {
        return this.mPreserveFocusAfterLayout;
    }

    public u getRecycledViewPool() {
        return this.mRecycler.i();
    }

    public int getScrollState() {
        return this.mScrollState;
    }

    public boolean hasFixedSize() {
        return this.mHasFixedSize;
    }

    @Override // android.view.View
    public boolean hasNestedScrollingParent() {
        return getScrollingChildHelper().k();
    }

    public boolean hasNestedScrollingParent(int i10) {
        return getScrollingChildHelper().l(i10);
    }

    public boolean hasPendingAdapterUpdates() {
        return !this.mFirstLayoutComplete || this.mDataSetHasChangedAfterLayout || this.mAdapterHelper.p();
    }

    void initAdapterManager() {
        this.mAdapterHelper = new androidx.recyclerview.widget.a(new f());
    }

    void initFastScroller(StateListDrawable stateListDrawable, Drawable drawable, StateListDrawable stateListDrawable2, Drawable drawable2) {
        if (stateListDrawable != null && drawable != null && stateListDrawable2 != null && drawable2 != null) {
            Resources resources = getContext().getResources();
            new androidx.recyclerview.widget.d(this, stateListDrawable, drawable, stateListDrawable2, drawable2, resources.getDimensionPixelSize(d3.b.fastscroll_default_thickness), resources.getDimensionPixelSize(d3.b.fastscroll_minimum_range), resources.getDimensionPixelOffset(d3.b.fastscroll_margin));
            return;
        }
        throw new IllegalArgumentException("Trying to set fast scroller without both required drawables." + exceptionLabel());
    }

    void invalidateGlows() {
        this.mBottomGlow = null;
        this.mTopGlow = null;
        this.mRightGlow = null;
        this.mLeftGlow = null;
    }

    public void invalidateItemDecorations() {
        if (this.mItemDecorations.size() == 0) {
            return;
        }
        o oVar = this.mLayout;
        if (oVar != null) {
            oVar.g("Cannot invalidate item decorations during a scroll or layout");
        }
        markItemDecorInsetsDirty();
        requestLayout();
    }

    boolean isAccessibilityEnabled() {
        AccessibilityManager accessibilityManager = this.mAccessibilityManager;
        return accessibilityManager != null && accessibilityManager.isEnabled();
    }

    public boolean isAnimating() {
        l lVar = this.mItemAnimator;
        return lVar != null && lVar.p();
    }

    @Override // android.view.View
    public boolean isAttachedToWindow() {
        return this.mIsAttached;
    }

    public boolean isComputingLayout() {
        return this.mLayoutOrScrollCounter > 0;
    }

    @Deprecated
    public boolean isLayoutFrozen() {
        return isLayoutSuppressed();
    }

    @Override // android.view.ViewGroup
    public final boolean isLayoutSuppressed() {
        return this.mLayoutSuppressed;
    }

    @Override // android.view.View
    public boolean isNestedScrollingEnabled() {
        return getScrollingChildHelper().m();
    }

    void jumpToPositionForSmoothScroller(int i10) {
        if (this.mLayout == null) {
            return;
        }
        setScrollState(2);
        this.mLayout.x1(i10);
        awakenScrollBars();
    }

    void markItemDecorInsetsDirty() {
        int j10 = this.mChildHelper.j();
        for (int i10 = 0; i10 < j10; i10++) {
            ((p) this.mChildHelper.i(i10).getLayoutParams()).f4160c = true;
        }
        this.mRecycler.s();
    }

    void markKnownViewsInvalid() {
        int j10 = this.mChildHelper.j();
        for (int i10 = 0; i10 < j10; i10++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.i(i10));
            if (childViewHolderInt != null && !childViewHolderInt.J()) {
                childViewHolderInt.b(6);
            }
        }
        markItemDecorInsetsDirty();
        this.mRecycler.t();
    }

    public void offsetChildrenHorizontal(int i10) {
        int g10 = this.mChildHelper.g();
        for (int i11 = 0; i11 < g10; i11++) {
            this.mChildHelper.f(i11).offsetLeftAndRight(i10);
        }
    }

    public void offsetChildrenVertical(int i10) {
        int g10 = this.mChildHelper.g();
        for (int i11 = 0; i11 < g10; i11++) {
            this.mChildHelper.f(i11).offsetTopAndBottom(i10);
        }
    }

    void offsetPositionRecordsForInsert(int i10, int i11) {
        int j10 = this.mChildHelper.j();
        for (int i12 = 0; i12 < j10; i12++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.i(i12));
            if (childViewHolderInt != null && !childViewHolderInt.J() && childViewHolderInt.f4103c >= i10) {
                childViewHolderInt.A(i11, false);
                this.mState.f4080g = true;
            }
        }
        this.mRecycler.u(i10, i11);
        requestLayout();
    }

    void offsetPositionRecordsForMove(int i10, int i11) {
        int i12;
        int i13;
        int i14;
        int i15;
        int j10 = this.mChildHelper.j();
        if (i10 < i11) {
            i14 = -1;
            i13 = i10;
            i12 = i11;
        } else {
            i12 = i10;
            i13 = i11;
            i14 = 1;
        }
        for (int i16 = 0; i16 < j10; i16++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.i(i16));
            if (childViewHolderInt != null && (i15 = childViewHolderInt.f4103c) >= i13 && i15 <= i12) {
                if (i15 == i10) {
                    childViewHolderInt.A(i11 - i10, false);
                } else {
                    childViewHolderInt.A(i14, false);
                }
                this.mState.f4080g = true;
            }
        }
        this.mRecycler.v(i10, i11);
        requestLayout();
    }

    void offsetPositionRecordsForRemove(int i10, int i11, boolean z9) {
        int i12 = i10 + i11;
        int j10 = this.mChildHelper.j();
        for (int i13 = 0; i13 < j10; i13++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.i(i13));
            if (childViewHolderInt != null && !childViewHolderInt.J()) {
                int i14 = childViewHolderInt.f4103c;
                if (i14 >= i12) {
                    childViewHolderInt.A(-i11, z9);
                } else if (i14 >= i10) {
                    childViewHolderInt.i(i10 - 1, -i11, z9);
                }
                this.mState.f4080g = true;
            }
        }
        this.mRecycler.w(i10, i11, z9);
        requestLayout();
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mLayoutOrScrollCounter = 0;
        boolean z9 = true;
        this.mIsAttached = true;
        this.mFirstLayoutComplete = (!this.mFirstLayoutComplete || isLayoutRequested()) ? false : false;
        o oVar = this.mLayout;
        if (oVar != null) {
            oVar.z(this);
        }
        this.mPostedAnimatorRunner = false;
        if (ALLOW_THREAD_GAP_WORK) {
            ThreadLocal threadLocal = androidx.recyclerview.widget.e.f4332k;
            androidx.recyclerview.widget.e eVar = (androidx.recyclerview.widget.e) threadLocal.get();
            this.mGapWorker = eVar;
            if (eVar == null) {
                this.mGapWorker = new androidx.recyclerview.widget.e();
                Display u9 = r0.u(this);
                float f10 = 60.0f;
                if (!isInEditMode() && u9 != null) {
                    float refreshRate = u9.getRefreshRate();
                    if (refreshRate >= 30.0f) {
                        f10 = refreshRate;
                    }
                }
                androidx.recyclerview.widget.e eVar2 = this.mGapWorker;
                eVar2.f4336i = 1.0E9f / f10;
                threadLocal.set(eVar2);
            }
            this.mGapWorker.a(this);
        }
    }

    public void onChildAttachedToWindow(View view) {
    }

    public void onChildDetachedFromWindow(View view) {
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onDetachedFromWindow() {
        androidx.recyclerview.widget.e eVar;
        super.onDetachedFromWindow();
        l lVar = this.mItemAnimator;
        if (lVar != null) {
            lVar.k();
        }
        stopScroll();
        this.mIsAttached = false;
        o oVar = this.mLayout;
        if (oVar != null) {
            oVar.A(this, this.mRecycler);
        }
        this.mPendingAccessibilityImportanceChange.clear();
        removeCallbacks(this.mItemAnimatorRunner);
        this.mViewInfoStore.j();
        if (!ALLOW_THREAD_GAP_WORK || (eVar = this.mGapWorker) == null) {
            return;
        }
        eVar.j(this);
        this.mGapWorker = null;
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int size = this.mItemDecorations.size();
        for (int i10 = 0; i10 < size; i10++) {
            this.mItemDecorations.get(i10).g(canvas, this, this.mState);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void onEnterLayoutOrScroll() {
        this.mLayoutOrScrollCounter++;
    }

    void onExitLayoutOrScroll() {
        onExitLayoutOrScroll(true);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void onExitLayoutOrScroll(boolean z9) {
        int i10 = this.mLayoutOrScrollCounter - 1;
        this.mLayoutOrScrollCounter = i10;
        if (i10 < 1) {
            this.mLayoutOrScrollCounter = 0;
            if (z9) {
                dispatchContentChangedIfNecessary();
                dispatchPendingImportantForAccessibilityChanges();
            }
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:31:0x0066  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f10;
        float f11;
        if (this.mLayout != null && !this.mLayoutSuppressed && motionEvent.getAction() == 8) {
            if ((motionEvent.getSource() & 2) != 0) {
                f10 = this.mLayout.l() ? -motionEvent.getAxisValue(9) : 0.0f;
                if (this.mLayout.k()) {
                    f11 = motionEvent.getAxisValue(10);
                    if (f10 == 0.0f || f11 != 0.0f) {
                        scrollByInternal((int) (f11 * this.mScaledHorizontalScrollFactor), (int) (f10 * this.mScaledVerticalScrollFactor), motionEvent);
                    }
                }
                f11 = 0.0f;
                if (f10 == 0.0f) {
                }
                scrollByInternal((int) (f11 * this.mScaledHorizontalScrollFactor), (int) (f10 * this.mScaledVerticalScrollFactor), motionEvent);
            } else {
                if ((motionEvent.getSource() & 4194304) != 0) {
                    float axisValue = motionEvent.getAxisValue(26);
                    if (this.mLayout.l()) {
                        f10 = -axisValue;
                        f11 = 0.0f;
                        if (f10 == 0.0f) {
                        }
                        scrollByInternal((int) (f11 * this.mScaledHorizontalScrollFactor), (int) (f10 * this.mScaledVerticalScrollFactor), motionEvent);
                    } else if (this.mLayout.k()) {
                        f11 = axisValue;
                        f10 = 0.0f;
                        if (f10 == 0.0f) {
                        }
                        scrollByInternal((int) (f11 * this.mScaledHorizontalScrollFactor), (int) (f10 * this.mScaledVerticalScrollFactor), motionEvent);
                    }
                }
                f10 = 0.0f;
                f11 = 0.0f;
                if (f10 == 0.0f) {
                }
                scrollByInternal((int) (f11 * this.mScaledHorizontalScrollFactor), (int) (f10 * this.mScaledVerticalScrollFactor), motionEvent);
            }
        }
        return false;
    }

    @Override // android.view.ViewGroup
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean z9;
        if (this.mLayoutSuppressed) {
            return false;
        }
        this.mInterceptingOnItemTouchListener = null;
        if (findInterceptingOnItemTouchListener(motionEvent)) {
            cancelScroll();
            return true;
        }
        o oVar = this.mLayout;
        if (oVar == null) {
            return false;
        }
        boolean k10 = oVar.k();
        boolean l10 = this.mLayout.l();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int actionMasked = motionEvent.getActionMasked();
        int actionIndex = motionEvent.getActionIndex();
        if (actionMasked == 0) {
            if (this.mIgnoreMotionEventTillDown) {
                this.mIgnoreMotionEventTillDown = false;
            }
            this.mScrollPointerId = motionEvent.getPointerId(0);
            int x9 = (int) (motionEvent.getX() + 0.5f);
            this.mLastTouchX = x9;
            this.mInitialTouchX = x9;
            int y9 = (int) (motionEvent.getY() + 0.5f);
            this.mLastTouchY = y9;
            this.mInitialTouchY = y9;
            if (this.mScrollState == 2) {
                getParent().requestDisallowInterceptTouchEvent(true);
                setScrollState(1);
                stopNestedScroll(1);
            }
            int[] iArr = this.mNestedOffsets;
            iArr[1] = 0;
            iArr[0] = 0;
            int i10 = k10;
            if (l10) {
                i10 = (k10 ? 1 : 0) | 2;
            }
            startNestedScroll(i10, 0);
        } else if (actionMasked == 1) {
            this.mVelocityTracker.clear();
            stopNestedScroll(0);
        } else if (actionMasked == 2) {
            int findPointerIndex = motionEvent.findPointerIndex(this.mScrollPointerId);
            if (findPointerIndex < 0) {
                Log.e(TAG, "Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?");
                return false;
            }
            int x10 = (int) (motionEvent.getX(findPointerIndex) + 0.5f);
            int y10 = (int) (motionEvent.getY(findPointerIndex) + 0.5f);
            if (this.mScrollState != 1) {
                int i11 = x10 - this.mInitialTouchX;
                int i12 = y10 - this.mInitialTouchY;
                if (!k10 || Math.abs(i11) <= this.mTouchSlop) {
                    z9 = false;
                } else {
                    this.mLastTouchX = x10;
                    z9 = true;
                }
                if (l10 && Math.abs(i12) > this.mTouchSlop) {
                    this.mLastTouchY = y10;
                    z9 = true;
                }
                if (z9) {
                    setScrollState(1);
                }
            }
        } else if (actionMasked == 3) {
            cancelScroll();
        } else if (actionMasked == 5) {
            this.mScrollPointerId = motionEvent.getPointerId(actionIndex);
            int x11 = (int) (motionEvent.getX(actionIndex) + 0.5f);
            this.mLastTouchX = x11;
            this.mInitialTouchX = x11;
            int y11 = (int) (motionEvent.getY(actionIndex) + 0.5f);
            this.mLastTouchY = y11;
            this.mInitialTouchY = y11;
        } else if (actionMasked == 6) {
            onPointerUp(motionEvent);
        }
        return this.mScrollState == 1;
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        androidx.core.os.l.a(TRACE_ON_LAYOUT_TAG);
        dispatchLayout();
        androidx.core.os.l.b();
        this.mFirstLayoutComplete = true;
    }

    @Override // android.view.View
    protected void onMeasure(int i10, int i11) {
        o oVar = this.mLayout;
        if (oVar == null) {
            defaultOnMeasure(i10, i11);
            return;
        }
        boolean z9 = false;
        if (oVar.s0()) {
            int mode = View.MeasureSpec.getMode(i10);
            int mode2 = View.MeasureSpec.getMode(i11);
            this.mLayout.Z0(this.mRecycler, this.mState, i10, i11);
            if (mode == 1073741824 && mode2 == 1073741824) {
                z9 = true;
            }
            if (z9 || this.mAdapter == null) {
                return;
            }
            if (this.mState.f4078e == 1) {
                dispatchLayoutStep1();
            }
            this.mLayout.A1(i10, i11);
            this.mState.f4083j = true;
            dispatchLayoutStep2();
            this.mLayout.D1(i10, i11);
            if (this.mLayout.G1()) {
                this.mLayout.A1(View.MeasureSpec.makeMeasureSpec(getMeasuredWidth(), 1073741824), View.MeasureSpec.makeMeasureSpec(getMeasuredHeight(), 1073741824));
                this.mState.f4083j = true;
                dispatchLayoutStep2();
                this.mLayout.D1(i10, i11);
            }
        } else if (this.mHasFixedSize) {
            this.mLayout.Z0(this.mRecycler, this.mState, i10, i11);
        } else {
            if (this.mAdapterUpdateDuringMeasure) {
                startInterceptRequestLayout();
                onEnterLayoutOrScroll();
                processAdapterUpdatesAndSetAnimationFlags();
                onExitLayoutOrScroll();
                a0 a0Var = this.mState;
                if (a0Var.f4085l) {
                    a0Var.f4081h = true;
                } else {
                    this.mAdapterHelper.j();
                    this.mState.f4081h = false;
                }
                this.mAdapterUpdateDuringMeasure = false;
                stopInterceptRequestLayout(false);
            } else if (this.mState.f4085l) {
                setMeasuredDimension(getMeasuredWidth(), getMeasuredHeight());
                return;
            }
            g gVar = this.mAdapter;
            if (gVar != null) {
                this.mState.f4079f = gVar.c();
            } else {
                this.mState.f4079f = 0;
            }
            startInterceptRequestLayout();
            this.mLayout.Z0(this.mRecycler, this.mState, i10, i11);
            stopInterceptRequestLayout(false);
            this.mState.f4081h = false;
        }
    }

    @Override // android.view.ViewGroup
    protected boolean onRequestFocusInDescendants(int i10, Rect rect) {
        if (isComputingLayout()) {
            return false;
        }
        return super.onRequestFocusInDescendants(i10, rect);
    }

    @Override // android.view.View
    protected void onRestoreInstanceState(Parcelable parcelable) {
        Parcelable parcelable2;
        if (!(parcelable instanceof y)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        y yVar = (y) parcelable;
        this.mPendingSavedState = yVar;
        super.onRestoreInstanceState(yVar.a());
        o oVar = this.mLayout;
        if (oVar == null || (parcelable2 = this.mPendingSavedState.f4177i) == null) {
            return;
        }
        oVar.c1(parcelable2);
    }

    @Override // android.view.View
    protected Parcelable onSaveInstanceState() {
        y yVar = new y(super.onSaveInstanceState());
        y yVar2 = this.mPendingSavedState;
        if (yVar2 != null) {
            yVar.c(yVar2);
        } else {
            o oVar = this.mLayout;
            yVar.f4177i = oVar != null ? oVar.d1() : null;
        }
        return yVar;
    }

    public void onScrollStateChanged(int i10) {
    }

    public void onScrolled(int i10, int i11) {
    }

    @Override // android.view.View
    protected void onSizeChanged(int i10, int i11, int i12, int i13) {
        super.onSizeChanged(i10, i11, i12, i13);
        if (i10 == i12 && i11 == i13) {
            return;
        }
        invalidateGlows();
    }

    /* JADX WARN: Removed duplicated region for block: B:50:0x00e0  */
    /* JADX WARN: Removed duplicated region for block: B:57:0x00f4  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean z9;
        boolean z10 = false;
        if (this.mLayoutSuppressed || this.mIgnoreMotionEventTillDown) {
            return false;
        }
        if (dispatchToOnItemTouchListeners(motionEvent)) {
            cancelScroll();
            return true;
        }
        o oVar = this.mLayout;
        if (oVar == null) {
            return false;
        }
        boolean k10 = oVar.k();
        boolean l10 = this.mLayout.l();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        int actionMasked = motionEvent.getActionMasked();
        int actionIndex = motionEvent.getActionIndex();
        if (actionMasked == 0) {
            int[] iArr = this.mNestedOffsets;
            iArr[1] = 0;
            iArr[0] = 0;
        }
        MotionEvent obtain = MotionEvent.obtain(motionEvent);
        int[] iArr2 = this.mNestedOffsets;
        obtain.offsetLocation(iArr2[0], iArr2[1]);
        if (actionMasked == 0) {
            this.mScrollPointerId = motionEvent.getPointerId(0);
            int x9 = (int) (motionEvent.getX() + 0.5f);
            this.mLastTouchX = x9;
            this.mInitialTouchX = x9;
            int y9 = (int) (motionEvent.getY() + 0.5f);
            this.mLastTouchY = y9;
            this.mInitialTouchY = y9;
            int i10 = k10;
            if (l10) {
                i10 = (k10 ? 1 : 0) | 2;
            }
            startNestedScroll(i10, 0);
        } else if (actionMasked == 1) {
            this.mVelocityTracker.addMovement(obtain);
            this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaxFlingVelocity);
            float f10 = k10 ? -this.mVelocityTracker.getXVelocity(this.mScrollPointerId) : 0.0f;
            float f11 = l10 ? -this.mVelocityTracker.getYVelocity(this.mScrollPointerId) : 0.0f;
            if ((f10 == 0.0f && f11 == 0.0f) || !fling((int) f10, (int) f11)) {
                setScrollState(0);
            }
            resetScroll();
            z10 = true;
        } else if (actionMasked == 2) {
            int findPointerIndex = motionEvent.findPointerIndex(this.mScrollPointerId);
            if (findPointerIndex < 0) {
                Log.e(TAG, "Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?");
                return false;
            }
            int x10 = (int) (motionEvent.getX(findPointerIndex) + 0.5f);
            int y10 = (int) (motionEvent.getY(findPointerIndex) + 0.5f);
            int i11 = this.mLastTouchX - x10;
            int i12 = this.mLastTouchY - y10;
            if (this.mScrollState != 1) {
                if (k10) {
                    int i13 = this.mTouchSlop;
                    i11 = i11 > 0 ? Math.max(0, i11 - i13) : Math.min(0, i11 + i13);
                    if (i11 != 0) {
                        z9 = true;
                        if (l10) {
                            int i14 = this.mTouchSlop;
                            i12 = i12 > 0 ? Math.max(0, i12 - i14) : Math.min(0, i12 + i14);
                            if (i12 != 0) {
                                z9 = true;
                            }
                        }
                        if (z9) {
                            setScrollState(1);
                        }
                    }
                }
                z9 = false;
                if (l10) {
                }
                if (z9) {
                }
            }
            int i15 = i11;
            int i16 = i12;
            if (this.mScrollState == 1) {
                int[] iArr3 = this.mReusableIntPair;
                iArr3[0] = 0;
                iArr3[1] = 0;
                if (dispatchNestedPreScroll(k10 ? i15 : 0, l10 ? i16 : 0, iArr3, this.mScrollOffset, 0)) {
                    int[] iArr4 = this.mReusableIntPair;
                    i15 -= iArr4[0];
                    i16 -= iArr4[1];
                    int[] iArr5 = this.mNestedOffsets;
                    int i17 = iArr5[0];
                    int[] iArr6 = this.mScrollOffset;
                    iArr5[0] = i17 + iArr6[0];
                    iArr5[1] = iArr5[1] + iArr6[1];
                    getParent().requestDisallowInterceptTouchEvent(true);
                }
                int i18 = i16;
                int[] iArr7 = this.mScrollOffset;
                this.mLastTouchX = x10 - iArr7[0];
                this.mLastTouchY = y10 - iArr7[1];
                if (scrollByInternal(k10 ? i15 : 0, l10 ? i18 : 0, motionEvent)) {
                    getParent().requestDisallowInterceptTouchEvent(true);
                }
                androidx.recyclerview.widget.e eVar = this.mGapWorker;
                if (eVar != null && (i15 != 0 || i18 != 0)) {
                    eVar.f(this, i15, i18);
                }
            }
        } else if (actionMasked == 3) {
            cancelScroll();
        } else if (actionMasked == 5) {
            this.mScrollPointerId = motionEvent.getPointerId(actionIndex);
            int x11 = (int) (motionEvent.getX(actionIndex) + 0.5f);
            this.mLastTouchX = x11;
            this.mInitialTouchX = x11;
            int y11 = (int) (motionEvent.getY(actionIndex) + 0.5f);
            this.mLastTouchY = y11;
            this.mInitialTouchY = y11;
        } else if (actionMasked == 6) {
            onPointerUp(motionEvent);
        }
        if (!z10) {
            this.mVelocityTracker.addMovement(obtain);
        }
        obtain.recycle();
        return true;
    }

    void postAnimationRunner() {
        if (this.mPostedAnimatorRunner || !this.mIsAttached) {
            return;
        }
        r0.f0(this, this.mItemAnimatorRunner);
        this.mPostedAnimatorRunner = true;
    }

    void processDataSetCompletelyChanged(boolean z9) {
        this.mDispatchItemsChangedEvent = z9 | this.mDispatchItemsChangedEvent;
        this.mDataSetHasChangedAfterLayout = true;
        markKnownViewsInvalid();
    }

    void recordAnimationInfoIfBouncedHiddenView(d0 d0Var, l.c cVar) {
        d0Var.F(0, 8192);
        if (this.mState.f4082i && d0Var.y() && !d0Var.v() && !d0Var.J()) {
            this.mViewInfoStore.c(getChangedHolderKey(d0Var), d0Var);
        }
        this.mViewInfoStore.e(d0Var, cVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void removeAndRecycleViews() {
        l lVar = this.mItemAnimator;
        if (lVar != null) {
            lVar.k();
        }
        o oVar = this.mLayout;
        if (oVar != null) {
            oVar.k1(this.mRecycler);
            this.mLayout.l1(this.mRecycler);
        }
        this.mRecycler.c();
    }

    boolean removeAnimatingView(View view) {
        startInterceptRequestLayout();
        boolean r10 = this.mChildHelper.r(view);
        if (r10) {
            d0 childViewHolderInt = getChildViewHolderInt(view);
            this.mRecycler.J(childViewHolderInt);
            this.mRecycler.C(childViewHolderInt);
        }
        stopInterceptRequestLayout(!r10);
        return r10;
    }

    @Override // android.view.ViewGroup
    protected void removeDetachedView(View view, boolean z9) {
        d0 childViewHolderInt = getChildViewHolderInt(view);
        if (childViewHolderInt != null) {
            if (childViewHolderInt.x()) {
                childViewHolderInt.f();
            } else if (!childViewHolderInt.J()) {
                throw new IllegalArgumentException("Called removeDetachedView with a view which is not flagged as tmp detached." + childViewHolderInt + exceptionLabel());
            }
        }
        view.clearAnimation();
        dispatchChildDetached(view);
        super.removeDetachedView(view, z9);
    }

    public void removeItemDecoration(n nVar) {
        o oVar = this.mLayout;
        if (oVar != null) {
            oVar.g("Cannot remove item decoration during a scroll  or layout");
        }
        this.mItemDecorations.remove(nVar);
        if (this.mItemDecorations.isEmpty()) {
            setWillNotDraw(getOverScrollMode() == 2);
        }
        markItemDecorInsetsDirty();
        requestLayout();
    }

    public void removeItemDecorationAt(int i10) {
        int itemDecorationCount = getItemDecorationCount();
        if (i10 >= 0 && i10 < itemDecorationCount) {
            removeItemDecoration(getItemDecorationAt(i10));
            return;
        }
        throw new IndexOutOfBoundsException(i10 + " is an invalid index for size " + itemDecorationCount);
    }

    public void removeOnChildAttachStateChangeListener(q qVar) {
        List<q> list = this.mOnChildAttachStateListeners;
        if (list == null) {
            return;
        }
        list.remove(qVar);
    }

    public void removeOnItemTouchListener(s sVar) {
        this.mOnItemTouchListeners.remove(sVar);
        if (this.mInterceptingOnItemTouchListener == sVar) {
            this.mInterceptingOnItemTouchListener = null;
        }
    }

    public void removeOnScrollListener(t tVar) {
        List<t> list = this.mScrollListeners;
        if (list != null) {
            list.remove(tVar);
        }
    }

    void repositionShadowingViews() {
        d0 d0Var;
        int g10 = this.mChildHelper.g();
        for (int i10 = 0; i10 < g10; i10++) {
            View f10 = this.mChildHelper.f(i10);
            d0 childViewHolder = getChildViewHolder(f10);
            if (childViewHolder != null && (d0Var = childViewHolder.f4109i) != null) {
                View view = d0Var.f4101a;
                int left = f10.getLeft();
                int top = f10.getTop();
                if (left != view.getLeft() || top != view.getTop()) {
                    view.layout(left, top, view.getWidth() + left, view.getHeight() + top);
                }
            }
        }
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void requestChildFocus(View view, View view2) {
        if (!this.mLayout.b1(this, this.mState, view, view2) && view2 != null) {
            requestChildOnScreen(view, view2);
        }
        super.requestChildFocus(view, view2);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z9) {
        return this.mLayout.r1(this, view, rect, z9);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void requestDisallowInterceptTouchEvent(boolean z9) {
        int size = this.mOnItemTouchListeners.size();
        for (int i10 = 0; i10 < size; i10++) {
            this.mOnItemTouchListeners.get(i10).c(z9);
        }
        super.requestDisallowInterceptTouchEvent(z9);
    }

    @Override // android.view.View, android.view.ViewParent
    public void requestLayout() {
        if (this.mInterceptRequestLayoutDepth != 0 || this.mLayoutSuppressed) {
            this.mLayoutWasDefered = true;
        } else {
            super.requestLayout();
        }
    }

    void saveOldPositions() {
        int j10 = this.mChildHelper.j();
        for (int i10 = 0; i10 < j10; i10++) {
            d0 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.i(i10));
            if (!childViewHolderInt.J()) {
                childViewHolderInt.E();
            }
        }
    }

    @Override // android.view.View
    public void scrollBy(int i10, int i11) {
        o oVar = this.mLayout;
        if (oVar == null) {
            Log.e(TAG, "Cannot scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
        } else if (this.mLayoutSuppressed) {
        } else {
            boolean k10 = oVar.k();
            boolean l10 = this.mLayout.l();
            if (k10 || l10) {
                if (!k10) {
                    i10 = 0;
                }
                if (!l10) {
                    i11 = 0;
                }
                scrollByInternal(i10, i11, null);
            }
        }
    }

    boolean scrollByInternal(int i10, int i11, MotionEvent motionEvent) {
        int i12;
        int i13;
        int i14;
        int i15;
        consumePendingUpdateOperations();
        if (this.mAdapter != null) {
            int[] iArr = this.mReusableIntPair;
            iArr[0] = 0;
            iArr[1] = 0;
            scrollStep(i10, i11, iArr);
            int[] iArr2 = this.mReusableIntPair;
            int i16 = iArr2[0];
            int i17 = iArr2[1];
            i12 = i17;
            i13 = i16;
            i14 = i10 - i16;
            i15 = i11 - i17;
        } else {
            i12 = 0;
            i13 = 0;
            i14 = 0;
            i15 = 0;
        }
        if (!this.mItemDecorations.isEmpty()) {
            invalidate();
        }
        int[] iArr3 = this.mReusableIntPair;
        iArr3[0] = 0;
        iArr3[1] = 0;
        dispatchNestedScroll(i13, i12, i14, i15, this.mScrollOffset, 0, iArr3);
        int[] iArr4 = this.mReusableIntPair;
        int i18 = iArr4[0];
        int i19 = i14 - i18;
        int i20 = iArr4[1];
        int i21 = i15 - i20;
        boolean z9 = (i18 == 0 && i20 == 0) ? false : true;
        int i22 = this.mLastTouchX;
        int[] iArr5 = this.mScrollOffset;
        int i23 = iArr5[0];
        this.mLastTouchX = i22 - i23;
        int i24 = this.mLastTouchY;
        int i25 = iArr5[1];
        this.mLastTouchY = i24 - i25;
        int[] iArr6 = this.mNestedOffsets;
        iArr6[0] = iArr6[0] + i23;
        iArr6[1] = iArr6[1] + i25;
        if (getOverScrollMode() != 2) {
            if (motionEvent != null && !e0.a(motionEvent, 8194)) {
                pullGlows(motionEvent.getX(), i19, motionEvent.getY(), i21);
            }
            considerReleasingGlowsOnScroll(i10, i11);
        }
        if (i13 != 0 || i12 != 0) {
            dispatchOnScrolled(i13, i12);
        }
        if (!awakenScrollBars()) {
            invalidate();
        }
        return (!z9 && i13 == 0 && i12 == 0) ? false : true;
    }

    void scrollStep(int i10, int i11, int[] iArr) {
        startInterceptRequestLayout();
        onEnterLayoutOrScroll();
        androidx.core.os.l.a(TRACE_SCROLL_TAG);
        fillRemainingScrollValues(this.mState);
        int w12 = i10 != 0 ? this.mLayout.w1(i10, this.mRecycler, this.mState) : 0;
        int y12 = i11 != 0 ? this.mLayout.y1(i11, this.mRecycler, this.mState) : 0;
        androidx.core.os.l.b();
        repositionShadowingViews();
        onExitLayoutOrScroll();
        stopInterceptRequestLayout(false);
        if (iArr != null) {
            iArr[0] = w12;
            iArr[1] = y12;
        }
    }

    @Override // android.view.View
    public void scrollTo(int i10, int i11) {
        Log.w(TAG, "RecyclerView does not support scrolling to an absolute position. Use scrollToPosition instead");
    }

    public void scrollToPosition(int i10) {
        if (this.mLayoutSuppressed) {
            return;
        }
        stopScroll();
        o oVar = this.mLayout;
        if (oVar == null) {
            Log.e(TAG, "Cannot scroll to position a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        oVar.x1(i10);
        awakenScrollBars();
    }

    @Override // android.view.View, android.view.accessibility.AccessibilityEventSource
    public void sendAccessibilityEventUnchecked(AccessibilityEvent accessibilityEvent) {
        if (shouldDeferAccessibilityEvent(accessibilityEvent)) {
            return;
        }
        super.sendAccessibilityEventUnchecked(accessibilityEvent);
    }

    public void setAccessibilityDelegateCompat(androidx.recyclerview.widget.k kVar) {
        this.mAccessibilityDelegate = kVar;
        r0.n0(this, kVar);
    }

    public void setAdapter(g gVar) {
        setLayoutFrozen(false);
        setAdapterInternal(gVar, false, true);
        processDataSetCompletelyChanged(false);
        requestLayout();
    }

    public void setChildDrawingOrderCallback(j jVar) {
        if (jVar == this.mChildDrawingOrderCallback) {
            return;
        }
        this.mChildDrawingOrderCallback = jVar;
        setChildrenDrawingOrderEnabled(jVar != null);
    }

    boolean setChildImportantForAccessibilityInternal(d0 d0Var, int i10) {
        if (!isComputingLayout()) {
            r0.x0(d0Var.f4101a, i10);
            return true;
        }
        d0Var.f4117q = i10;
        this.mPendingAccessibilityImportanceChange.add(d0Var);
        return false;
    }

    @Override // android.view.ViewGroup
    public void setClipToPadding(boolean z9) {
        if (z9 != this.mClipToPadding) {
            invalidateGlows();
        }
        this.mClipToPadding = z9;
        super.setClipToPadding(z9);
        if (this.mFirstLayoutComplete) {
            requestLayout();
        }
    }

    public void setEdgeEffectFactory(k kVar) {
        v.h.g(kVar);
        this.mEdgeEffectFactory = kVar;
        invalidateGlows();
    }

    public void setHasFixedSize(boolean z9) {
        this.mHasFixedSize = z9;
    }

    public void setItemAnimator(l lVar) {
        l lVar2 = this.mItemAnimator;
        if (lVar2 != null) {
            lVar2.k();
            this.mItemAnimator.v(null);
        }
        this.mItemAnimator = lVar;
        if (lVar != null) {
            lVar.v(this.mItemAnimatorListener);
        }
    }

    public void setItemViewCacheSize(int i10) {
        this.mRecycler.G(i10);
    }

    @Deprecated
    public void setLayoutFrozen(boolean z9) {
        suppressLayout(z9);
    }

    public void setLayoutManager(o oVar) {
        if (oVar == this.mLayout) {
            return;
        }
        stopScroll();
        if (this.mLayout != null) {
            l lVar = this.mItemAnimator;
            if (lVar != null) {
                lVar.k();
            }
            this.mLayout.k1(this.mRecycler);
            this.mLayout.l1(this.mRecycler);
            this.mRecycler.c();
            if (this.mIsAttached) {
                this.mLayout.A(this, this.mRecycler);
            }
            this.mLayout.E1(null);
            this.mLayout = null;
        } else {
            this.mRecycler.c();
        }
        this.mChildHelper.o();
        this.mLayout = oVar;
        if (oVar != null) {
            if (oVar.f4135b != null) {
                throw new IllegalArgumentException("LayoutManager " + oVar + " is already attached to a RecyclerView:" + oVar.f4135b.exceptionLabel());
            }
            oVar.E1(this);
            if (this.mIsAttached) {
                this.mLayout.z(this);
            }
        }
        this.mRecycler.K();
        requestLayout();
    }

    @Override // android.view.ViewGroup
    @Deprecated
    public void setLayoutTransition(LayoutTransition layoutTransition) {
        if (layoutTransition != null) {
            throw new IllegalArgumentException("Providing a LayoutTransition into RecyclerView is not supported. Please use setItemAnimator() instead for animating changes to the items in this RecyclerView");
        }
        super.setLayoutTransition(null);
    }

    @Override // android.view.View
    public void setNestedScrollingEnabled(boolean z9) {
        getScrollingChildHelper().n(z9);
    }

    public void setOnFlingListener(r rVar) {
        this.mOnFlingListener = rVar;
    }

    @Deprecated
    public void setOnScrollListener(t tVar) {
        this.mScrollListener = tVar;
    }

    public void setPreserveFocusAfterLayout(boolean z9) {
        this.mPreserveFocusAfterLayout = z9;
    }

    public void setRecycledViewPool(u uVar) {
        this.mRecycler.E(uVar);
    }

    public void setRecyclerListener(w wVar) {
        this.mRecyclerListener = wVar;
    }

    void setScrollState(int i10) {
        if (i10 == this.mScrollState) {
            return;
        }
        this.mScrollState = i10;
        if (i10 != 2) {
            stopScrollersInternal();
        }
        dispatchOnScrollStateChanged(i10);
    }

    public void setScrollingTouchSlop(int i10) {
        int scaledTouchSlop;
        ViewConfiguration viewConfiguration = ViewConfiguration.get(getContext());
        if (i10 != 0) {
            if (i10 == 1) {
                scaledTouchSlop = viewConfiguration.getScaledPagingTouchSlop();
                this.mTouchSlop = scaledTouchSlop;
            }
            Log.w(TAG, "setScrollingTouchSlop(): bad argument constant " + i10 + "; using default value");
        }
        scaledTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mTouchSlop = scaledTouchSlop;
    }

    public void setViewCacheExtension(b0 b0Var) {
        this.mRecycler.F(b0Var);
    }

    boolean shouldDeferAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (isComputingLayout()) {
            int a10 = accessibilityEvent != null ? w.b.a(accessibilityEvent) : 0;
            this.mEatenAccessibilityChangeFlags |= a10 != 0 ? a10 : 0;
            return true;
        }
        return false;
    }

    public void smoothScrollBy(int i10, int i11) {
        smoothScrollBy(i10, i11, null);
    }

    public void smoothScrollBy(int i10, int i11, Interpolator interpolator) {
        smoothScrollBy(i10, i11, interpolator, UNDEFINED_DURATION);
    }

    public void smoothScrollBy(int i10, int i11, Interpolator interpolator, int i12) {
        smoothScrollBy(i10, i11, interpolator, i12, false);
    }

    void smoothScrollBy(int i10, int i11, Interpolator interpolator, int i12, boolean z9) {
        o oVar = this.mLayout;
        if (oVar == null) {
            Log.e(TAG, "Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
        } else if (this.mLayoutSuppressed) {
        } else {
            if (!oVar.k()) {
                i10 = 0;
            }
            if (!this.mLayout.l()) {
                i11 = 0;
            }
            if (i10 == 0 && i11 == 0) {
                return;
            }
            if (!(i12 == Integer.MIN_VALUE || i12 > 0)) {
                scrollBy(i10, i11);
                return;
            }
            if (z9) {
                int i13 = i10 != 0 ? 1 : 0;
                if (i11 != 0) {
                    i13 |= 2;
                }
                startNestedScroll(i13, 1);
            }
            this.mViewFlinger.f(i10, i11, i12, interpolator);
        }
    }

    public void smoothScrollToPosition(int i10) {
        if (this.mLayoutSuppressed) {
            return;
        }
        o oVar = this.mLayout;
        if (oVar == null) {
            Log.e(TAG, "Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
        } else {
            oVar.I1(this, this.mState, i10);
        }
    }

    void startInterceptRequestLayout() {
        int i10 = this.mInterceptRequestLayoutDepth + 1;
        this.mInterceptRequestLayoutDepth = i10;
        if (i10 != 1 || this.mLayoutSuppressed) {
            return;
        }
        this.mLayoutWasDefered = false;
    }

    @Override // android.view.View
    public boolean startNestedScroll(int i10) {
        return getScrollingChildHelper().p(i10);
    }

    public boolean startNestedScroll(int i10, int i11) {
        return getScrollingChildHelper().q(i10, i11);
    }

    void stopInterceptRequestLayout(boolean z9) {
        if (this.mInterceptRequestLayoutDepth < 1) {
            this.mInterceptRequestLayoutDepth = 1;
        }
        if (!z9 && !this.mLayoutSuppressed) {
            this.mLayoutWasDefered = false;
        }
        if (this.mInterceptRequestLayoutDepth == 1) {
            if (z9 && this.mLayoutWasDefered && !this.mLayoutSuppressed && this.mLayout != null && this.mAdapter != null) {
                dispatchLayout();
            }
            if (!this.mLayoutSuppressed) {
                this.mLayoutWasDefered = false;
            }
        }
        this.mInterceptRequestLayoutDepth--;
    }

    @Override // android.view.View
    public void stopNestedScroll() {
        getScrollingChildHelper().r();
    }

    public void stopNestedScroll(int i10) {
        getScrollingChildHelper().s(i10);
    }

    public void stopScroll() {
        setScrollState(0);
        stopScrollersInternal();
    }

    @Override // android.view.ViewGroup
    public final void suppressLayout(boolean z9) {
        if (z9 != this.mLayoutSuppressed) {
            assertNotInLayoutOrScroll("Do not suppressLayout in layout or scroll");
            if (z9) {
                long uptimeMillis = SystemClock.uptimeMillis();
                onTouchEvent(MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0));
                this.mLayoutSuppressed = true;
                this.mIgnoreMotionEventTillDown = true;
                stopScroll();
                return;
            }
            this.mLayoutSuppressed = false;
            if (this.mLayoutWasDefered && this.mLayout != null && this.mAdapter != null) {
                requestLayout();
            }
            this.mLayoutWasDefered = false;
        }
    }

    public void swapAdapter(g gVar, boolean z9) {
        setLayoutFrozen(false);
        setAdapterInternal(gVar, true, z9);
        processDataSetCompletelyChanged(true);
        requestLayout();
    }

    void viewRangeUpdate(int i10, int i11, Object obj) {
        int i12;
        int j10 = this.mChildHelper.j();
        int i13 = i10 + i11;
        for (int i14 = 0; i14 < j10; i14++) {
            View i15 = this.mChildHelper.i(i14);
            d0 childViewHolderInt = getChildViewHolderInt(i15);
            if (childViewHolderInt != null && !childViewHolderInt.J() && (i12 = childViewHolderInt.f4103c) >= i10 && i12 < i13) {
                childViewHolderInt.b(2);
                childViewHolderInt.a(obj);
                ((p) i15.getLayoutParams()).f4160c = true;
            }
        }
        this.mRecycler.M(i10, i11);
    }
}
