package androidx.recyclerview.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Arrays;
import w.l;
/* loaded from: classes.dex */
public class GridLayoutManager extends LinearLayoutManager {
    boolean I;
    int J;
    int[] K;
    View[] L;
    final SparseIntArray M;
    final SparseIntArray N;
    c O;
    final Rect P;
    private boolean Q;

    /* loaded from: classes.dex */
    public static final class a extends c {
        @Override // androidx.recyclerview.widget.GridLayoutManager.c
        public int e(int i10, int i11) {
            return i10 % i11;
        }

        @Override // androidx.recyclerview.widget.GridLayoutManager.c
        public int f(int i10) {
            return 1;
        }
    }

    /* loaded from: classes.dex */
    public static class b extends RecyclerView.p {

        /* renamed from: e  reason: collision with root package name */
        int f4034e;

        /* renamed from: f  reason: collision with root package name */
        int f4035f;

        public b(int i10, int i11) {
            super(i10, i11);
            this.f4034e = -1;
            this.f4035f = 0;
        }

        public b(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.f4034e = -1;
            this.f4035f = 0;
        }

        public b(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.f4034e = -1;
            this.f4035f = 0;
        }

        public b(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.f4034e = -1;
            this.f4035f = 0;
        }

        public int e() {
            return this.f4034e;
        }

        public int f() {
            return this.f4035f;
        }
    }

    /* loaded from: classes.dex */
    public static abstract class c {

        /* renamed from: a  reason: collision with root package name */
        final SparseIntArray f4036a = new SparseIntArray();

        /* renamed from: b  reason: collision with root package name */
        final SparseIntArray f4037b = new SparseIntArray();

        /* renamed from: c  reason: collision with root package name */
        private boolean f4038c = false;

        /* renamed from: d  reason: collision with root package name */
        private boolean f4039d = false;

        static int a(SparseIntArray sparseIntArray, int i10) {
            int size = sparseIntArray.size() - 1;
            int i11 = 0;
            while (i11 <= size) {
                int i12 = (i11 + size) >>> 1;
                if (sparseIntArray.keyAt(i12) < i10) {
                    i11 = i12 + 1;
                } else {
                    size = i12 - 1;
                }
            }
            int i13 = i11 - 1;
            if (i13 < 0 || i13 >= sparseIntArray.size()) {
                return -1;
            }
            return sparseIntArray.keyAt(i13);
        }

        int b(int i10, int i11) {
            if (this.f4039d) {
                int i12 = this.f4037b.get(i10, -1);
                if (i12 != -1) {
                    return i12;
                }
                int d10 = d(i10, i11);
                this.f4037b.put(i10, d10);
                return d10;
            }
            return d(i10, i11);
        }

        int c(int i10, int i11) {
            if (this.f4038c) {
                int i12 = this.f4036a.get(i10, -1);
                if (i12 != -1) {
                    return i12;
                }
                int e10 = e(i10, i11);
                this.f4036a.put(i10, e10);
                return e10;
            }
            return e(i10, i11);
        }

        /* JADX WARN: Removed duplicated region for block: B:13:0x002d  */
        /* JADX WARN: Removed duplicated region for block: B:21:0x0043  */
        /* JADX WARN: Removed duplicated region for block: B:27:? A[RETURN, SYNTHETIC] */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        public int d(int i10, int i11) {
            int i12;
            int i13;
            int a10;
            if (this.f4039d && (a10 = a(this.f4037b, i10)) != -1) {
                int i14 = this.f4037b.get(a10);
                i12 = a10 + 1;
                i13 = c(a10, i11) + f(a10);
                i14 = i13 == i11 ? i14 + 1 : 0;
                int f10 = f(i10);
                while (i12 < i10) {
                    int f11 = f(i12);
                    i13 += f11;
                    if (i13 == i11) {
                        i14++;
                        i13 = 0;
                    } else if (i13 > i11) {
                        i14++;
                        i13 = f11;
                    }
                    i12++;
                }
                return i13 + f10 <= i11 ? i14 + 1 : i14;
            }
            i12 = 0;
            i13 = 0;
            int f102 = f(i10);
            while (i12 < i10) {
            }
            if (i13 + f102 <= i11) {
            }
        }

        public abstract int e(int i10, int i11);

        public abstract int f(int i10);

        public void g() {
            this.f4037b.clear();
        }

        public void h() {
            this.f4036a.clear();
        }
    }

    public GridLayoutManager(Context context, int i10, int i11, boolean z9) {
        super(context, i11, z9);
        this.I = false;
        this.J = -1;
        this.M = new SparseIntArray();
        this.N = new SparseIntArray();
        this.O = new a();
        this.P = new Rect();
        e3(i10);
    }

    public GridLayoutManager(Context context, AttributeSet attributeSet, int i10, int i11) {
        super(context, attributeSet, i10, i11);
        this.I = false;
        this.J = -1;
        this.M = new SparseIntArray();
        this.N = new SparseIntArray();
        this.O = new a();
        this.P = new Rect();
        e3(RecyclerView.o.i0(context, attributeSet, i10, i11).f4155b);
    }

    private void N2(RecyclerView.v vVar, RecyclerView.a0 a0Var, int i10, boolean z9) {
        int i11;
        int i12;
        int i13 = 0;
        int i14 = -1;
        if (z9) {
            i14 = i10;
            i11 = 0;
            i12 = 1;
        } else {
            i11 = i10 - 1;
            i12 = -1;
        }
        while (i11 != i14) {
            View view = this.L[i11];
            b bVar = (b) view.getLayoutParams();
            int a32 = a3(vVar, a0Var, h0(view));
            bVar.f4035f = a32;
            bVar.f4034e = i13;
            i13 += a32;
            i11 += i12;
        }
    }

    private void O2() {
        int J = J();
        for (int i10 = 0; i10 < J; i10++) {
            b bVar = (b) I(i10).getLayoutParams();
            int a10 = bVar.a();
            this.M.put(a10, bVar.f());
            this.N.put(a10, bVar.e());
        }
    }

    private void P2(int i10) {
        this.K = Q2(this.K, this.J, i10);
    }

    static int[] Q2(int[] iArr, int i10, int i11) {
        int i12;
        if (iArr == null || iArr.length != i10 + 1 || iArr[iArr.length - 1] != i11) {
            iArr = new int[i10 + 1];
        }
        int i13 = 0;
        iArr[0] = 0;
        int i14 = i11 / i10;
        int i15 = i11 % i10;
        int i16 = 0;
        for (int i17 = 1; i17 <= i10; i17++) {
            i13 += i15;
            if (i13 <= 0 || i10 - i13 >= i15) {
                i12 = i14;
            } else {
                i12 = i14 + 1;
                i13 -= i10;
            }
            i16 += i12;
            iArr[i17] = i16;
        }
        return iArr;
    }

    private void R2() {
        this.M.clear();
        this.N.clear();
    }

    private int S2(RecyclerView.a0 a0Var) {
        if (J() != 0 && a0Var.b() != 0) {
            T1();
            boolean r22 = r2();
            View Y1 = Y1(!r22, true);
            View X1 = X1(!r22, true);
            if (Y1 != null && X1 != null) {
                int b10 = this.O.b(h0(Y1), this.J);
                int b11 = this.O.b(h0(X1), this.J);
                int min = Math.min(b10, b11);
                int max = this.f4045x ? Math.max(0, ((this.O.b(a0Var.b() - 1, this.J) + 1) - Math.max(b10, b11)) - 1) : Math.max(0, min);
                if (r22) {
                    return Math.round((max * (Math.abs(this.f4042u.d(X1) - this.f4042u.g(Y1)) / ((this.O.b(h0(X1), this.J) - this.O.b(h0(Y1), this.J)) + 1))) + (this.f4042u.m() - this.f4042u.g(Y1)));
                }
                return max;
            }
        }
        return 0;
    }

    private int T2(RecyclerView.a0 a0Var) {
        if (J() != 0 && a0Var.b() != 0) {
            T1();
            View Y1 = Y1(!r2(), true);
            View X1 = X1(!r2(), true);
            if (Y1 != null && X1 != null) {
                if (r2()) {
                    int d10 = this.f4042u.d(X1) - this.f4042u.g(Y1);
                    int b10 = this.O.b(h0(Y1), this.J);
                    return (int) ((d10 / ((this.O.b(h0(X1), this.J) - b10) + 1)) * (this.O.b(a0Var.b() - 1, this.J) + 1));
                }
                return this.O.b(a0Var.b() - 1, this.J) + 1;
            }
        }
        return 0;
    }

    private void U2(RecyclerView.v vVar, RecyclerView.a0 a0Var, LinearLayoutManager.a aVar, int i10) {
        boolean z9 = i10 == 1;
        int Z2 = Z2(vVar, a0Var, aVar.f4049b);
        if (z9) {
            while (Z2 > 0) {
                int i11 = aVar.f4049b;
                if (i11 <= 0) {
                    return;
                }
                int i12 = i11 - 1;
                aVar.f4049b = i12;
                Z2 = Z2(vVar, a0Var, i12);
            }
            return;
        }
        int b10 = a0Var.b() - 1;
        int i13 = aVar.f4049b;
        while (i13 < b10) {
            int i14 = i13 + 1;
            int Z22 = Z2(vVar, a0Var, i14);
            if (Z22 <= Z2) {
                break;
            }
            i13 = i14;
            Z2 = Z22;
        }
        aVar.f4049b = i13;
    }

    private void V2() {
        View[] viewArr = this.L;
        if (viewArr == null || viewArr.length != this.J) {
            this.L = new View[this.J];
        }
    }

    private int Y2(RecyclerView.v vVar, RecyclerView.a0 a0Var, int i10) {
        if (a0Var.e()) {
            int f10 = vVar.f(i10);
            if (f10 == -1) {
                Log.w("GridLayoutManager", "Cannot find span size for pre layout position. " + i10);
                return 0;
            }
            return this.O.b(f10, this.J);
        }
        return this.O.b(i10, this.J);
    }

    private int Z2(RecyclerView.v vVar, RecyclerView.a0 a0Var, int i10) {
        if (a0Var.e()) {
            int i11 = this.N.get(i10, -1);
            if (i11 != -1) {
                return i11;
            }
            int f10 = vVar.f(i10);
            if (f10 == -1) {
                Log.w("GridLayoutManager", "Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + i10);
                return 0;
            }
            return this.O.c(f10, this.J);
        }
        return this.O.c(i10, this.J);
    }

    private int a3(RecyclerView.v vVar, RecyclerView.a0 a0Var, int i10) {
        if (a0Var.e()) {
            int i11 = this.M.get(i10, -1);
            if (i11 != -1) {
                return i11;
            }
            int f10 = vVar.f(i10);
            if (f10 == -1) {
                Log.w("GridLayoutManager", "Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + i10);
                return 1;
            }
            return this.O.f(f10);
        }
        return this.O.f(i10);
    }

    private void b3(float f10, int i10) {
        P2(Math.max(Math.round(f10 * this.J), i10));
    }

    private void c3(View view, int i10, boolean z9) {
        int i11;
        int i12;
        b bVar = (b) view.getLayoutParams();
        Rect rect = bVar.f4159b;
        int i13 = rect.top + rect.bottom + ((ViewGroup.MarginLayoutParams) bVar).topMargin + ((ViewGroup.MarginLayoutParams) bVar).bottomMargin;
        int i14 = rect.left + rect.right + ((ViewGroup.MarginLayoutParams) bVar).leftMargin + ((ViewGroup.MarginLayoutParams) bVar).rightMargin;
        int W2 = W2(bVar.f4034e, bVar.f4035f);
        if (this.f4040s == 1) {
            i12 = RecyclerView.o.K(W2, i10, i14, ((ViewGroup.MarginLayoutParams) bVar).width, false);
            i11 = RecyclerView.o.K(this.f4042u.n(), X(), i13, ((ViewGroup.MarginLayoutParams) bVar).height, true);
        } else {
            int K = RecyclerView.o.K(W2, i10, i13, ((ViewGroup.MarginLayoutParams) bVar).height, false);
            int K2 = RecyclerView.o.K(this.f4042u.n(), p0(), i14, ((ViewGroup.MarginLayoutParams) bVar).width, true);
            i11 = K;
            i12 = K2;
        }
        d3(view, i12, i11, z9);
    }

    private void d3(View view, int i10, int i11, boolean z9) {
        RecyclerView.p pVar = (RecyclerView.p) view.getLayoutParams();
        if (z9 ? H1(view, i10, i11, pVar) : F1(view, i10, i11, pVar)) {
            view.measure(i10, i11);
        }
    }

    private void f3() {
        int W;
        int g02;
        if (p2() == 1) {
            W = o0() - f0();
            g02 = e0();
        } else {
            W = W() - d0();
            g02 = g0();
        }
        P2(W - g02);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public void C1(Rect rect, int i10, int i11) {
        int n10;
        int n11;
        if (this.K == null) {
            super.C1(rect, i10, i11);
        }
        int e02 = e0() + f0();
        int g02 = g0() + d0();
        if (this.f4040s == 1) {
            n11 = RecyclerView.o.n(i11, rect.height() + g02, b0());
            int[] iArr = this.K;
            n10 = RecyclerView.o.n(i10, iArr[iArr.length - 1] + e02, c0());
        } else {
            n10 = RecyclerView.o.n(i10, rect.width() + e02, c0());
            int[] iArr2 = this.K;
            n11 = RecyclerView.o.n(i11, iArr2[iArr2.length - 1] + g02, b0());
        }
        B1(n10, n11);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public RecyclerView.p D() {
        return this.f4040s == 0 ? new b(-2, -1) : new b(-1, -2);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public RecyclerView.p E(Context context, AttributeSet attributeSet) {
        return new b(context, attributeSet);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager
    public void E2(boolean z9) {
        if (z9) {
            throw new UnsupportedOperationException("GridLayoutManager does not support stack from end. Consider using reverse layout");
        }
        super.E2(false);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public RecyclerView.p F(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams ? new b((ViewGroup.MarginLayoutParams) layoutParams) : new b(layoutParams);
    }

    /* JADX WARN: Code restructure failed: missing block: B:59:0x00d6, code lost:
        if (r13 == (r2 > r15)) goto L50;
     */
    /* JADX WARN: Code restructure failed: missing block: B:72:0x00f6, code lost:
        if (r13 == (r2 > r7)) goto L51;
     */
    /* JADX WARN: Removed duplicated region for block: B:79:0x0107  */
    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public View J0(View view, int i10, RecyclerView.v vVar, RecyclerView.a0 a0Var) {
        int J;
        int i11;
        int i12;
        View view2;
        View view3;
        int i13;
        int i14;
        boolean z9;
        int i15;
        int i16;
        RecyclerView.v vVar2 = vVar;
        RecyclerView.a0 a0Var2 = a0Var;
        View B = B(view);
        View view4 = null;
        if (B == null) {
            return null;
        }
        b bVar = (b) B.getLayoutParams();
        int i17 = bVar.f4034e;
        int i18 = bVar.f4035f + i17;
        if (super.J0(view, i10, vVar, a0Var) == null) {
            return null;
        }
        if ((R1(i10) == 1) != this.f4045x) {
            i11 = J() - 1;
            J = -1;
            i12 = -1;
        } else {
            J = J();
            i11 = 0;
            i12 = 1;
        }
        boolean z10 = this.f4040s == 1 && q2();
        int Y2 = Y2(vVar2, a0Var2, i11);
        int i19 = i11;
        int i20 = 0;
        int i21 = -1;
        int i22 = -1;
        int i23 = 0;
        View view5 = null;
        while (i19 != J) {
            int Y22 = Y2(vVar2, a0Var2, i19);
            View I = I(i19);
            if (I == B) {
                break;
            }
            if (!I.hasFocusable() || Y22 == Y2) {
                b bVar2 = (b) I.getLayoutParams();
                int i24 = bVar2.f4034e;
                view2 = B;
                int i25 = bVar2.f4035f + i24;
                if (I.hasFocusable() && i24 == i17 && i25 == i18) {
                    return I;
                }
                if (!(I.hasFocusable() && view4 == null) && (I.hasFocusable() || view5 != null)) {
                    view3 = view5;
                    int min = Math.min(i25, i18) - Math.max(i24, i17);
                    if (I.hasFocusable()) {
                        if (min <= i20) {
                            if (min == i20) {
                            }
                        }
                    } else if (view4 == null) {
                        i13 = i20;
                        i14 = J;
                        if (y0(I, false, true)) {
                            i15 = i23;
                            if (min > i15) {
                                i16 = i22;
                                if (z9) {
                                    if (I.hasFocusable()) {
                                        i21 = bVar2.f4034e;
                                        i22 = i16;
                                        i23 = i15;
                                        view5 = view3;
                                        view4 = I;
                                        i20 = Math.min(i25, i18) - Math.max(i24, i17);
                                    } else {
                                        int i26 = bVar2.f4034e;
                                        i23 = Math.min(i25, i18) - Math.max(i24, i17);
                                        i22 = i26;
                                        i20 = i13;
                                        view5 = I;
                                    }
                                    i19 += i12;
                                    vVar2 = vVar;
                                    a0Var2 = a0Var;
                                    B = view2;
                                    J = i14;
                                }
                            } else {
                                if (min == i15) {
                                    i16 = i22;
                                } else {
                                    i16 = i22;
                                }
                                z9 = false;
                                if (z9) {
                                }
                            }
                        }
                        i16 = i22;
                        i15 = i23;
                        z9 = false;
                        if (z9) {
                        }
                    }
                    i13 = i20;
                    i14 = J;
                    i16 = i22;
                    i15 = i23;
                    z9 = false;
                    if (z9) {
                    }
                } else {
                    view3 = view5;
                }
                i13 = i20;
                i14 = J;
                i16 = i22;
                i15 = i23;
                z9 = true;
                if (z9) {
                }
            } else if (view4 != null) {
                break;
            } else {
                view2 = B;
                view3 = view5;
                i13 = i20;
                i14 = J;
                i16 = i22;
                i15 = i23;
            }
            i22 = i16;
            i23 = i15;
            i20 = i13;
            view5 = view3;
            i19 += i12;
            vVar2 = vVar;
            a0Var2 = a0Var;
            B = view2;
            J = i14;
        }
        return view4 != null ? view4 : view5;
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public boolean L1() {
        return this.D == null && !this.I;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public int N(RecyclerView.v vVar, RecyclerView.a0 a0Var) {
        if (this.f4040s == 1) {
            return this.J;
        }
        if (a0Var.b() < 1) {
            return 0;
        }
        return Y2(vVar, a0Var, a0Var.b() - 1) + 1;
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager
    void N1(RecyclerView.a0 a0Var, LinearLayoutManager.c cVar, RecyclerView.o.c cVar2) {
        int i10 = this.J;
        for (int i11 = 0; i11 < this.J && cVar.c(a0Var) && i10 > 0; i11++) {
            int i12 = cVar.f4060d;
            cVar2.a(i12, Math.max(0, cVar.f4063g));
            i10 -= this.O.f(i12);
            cVar.f4060d += cVar.f4061e;
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public void P0(RecyclerView.v vVar, RecyclerView.a0 a0Var, View view, w.l lVar) {
        int i10;
        int e10;
        int f10;
        boolean z9;
        boolean z10;
        int i11;
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (!(layoutParams instanceof b)) {
            super.O0(view, lVar);
            return;
        }
        b bVar = (b) layoutParams;
        int Y2 = Y2(vVar, a0Var, bVar.a());
        if (this.f4040s == 0) {
            i11 = bVar.e();
            i10 = bVar.f();
            f10 = 1;
            z9 = false;
            z10 = false;
            e10 = Y2;
        } else {
            i10 = 1;
            e10 = bVar.e();
            f10 = bVar.f();
            z9 = false;
            z10 = false;
            i11 = Y2;
        }
        lVar.m0(l.f.a(i11, i10, e10, f10, z9, z10));
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public void R0(RecyclerView recyclerView, int i10, int i11) {
        this.O.h();
        this.O.g();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public void S0(RecyclerView recyclerView) {
        this.O.h();
        this.O.g();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public void T0(RecyclerView recyclerView, int i10, int i11, int i12) {
        this.O.h();
        this.O.g();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public void U0(RecyclerView recyclerView, int i10, int i11) {
        this.O.h();
        this.O.g();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public void W0(RecyclerView recyclerView, int i10, int i11, Object obj) {
        this.O.h();
        this.O.g();
    }

    int W2(int i10, int i11) {
        if (this.f4040s != 1 || !q2()) {
            int[] iArr = this.K;
            return iArr[i11 + i10] - iArr[i10];
        }
        int[] iArr2 = this.K;
        int i12 = this.J;
        return iArr2[i12 - i10] - iArr2[(i12 - i10) - i11];
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public void X0(RecyclerView.v vVar, RecyclerView.a0 a0Var) {
        if (a0Var.e()) {
            O2();
        }
        super.X0(vVar, a0Var);
        R2();
    }

    public int X2() {
        return this.J;
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public void Y0(RecyclerView.a0 a0Var) {
        super.Y0(a0Var);
        this.I = false;
    }

    public void e3(int i10) {
        if (i10 == this.J) {
            return;
        }
        this.I = true;
        if (i10 >= 1) {
            this.J = i10;
            this.O.h();
            t1();
            return;
        }
        throw new IllegalArgumentException("Span count should be at least 1. Provided " + i10);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager
    View h2(RecyclerView.v vVar, RecyclerView.a0 a0Var, int i10, int i11, int i12) {
        T1();
        int m10 = this.f4042u.m();
        int i13 = this.f4042u.i();
        int i14 = i11 > i10 ? 1 : -1;
        View view = null;
        View view2 = null;
        while (i10 != i11) {
            View I = I(i10);
            int h02 = h0(I);
            if (h02 >= 0 && h02 < i12 && Z2(vVar, a0Var, h02) == 0) {
                if (((RecyclerView.p) I.getLayoutParams()).c()) {
                    if (view2 == null) {
                        view2 = I;
                    }
                } else if (this.f4042u.g(I) < i13 && this.f4042u.d(I) >= m10) {
                    return I;
                } else {
                    if (view == null) {
                        view = I;
                    }
                }
            }
            i10 += i14;
        }
        return view != null ? view : view2;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public int k0(RecyclerView.v vVar, RecyclerView.a0 a0Var) {
        if (this.f4040s == 0) {
            return this.J;
        }
        if (a0Var.b() < 1) {
            return 0;
        }
        return Y2(vVar, a0Var, a0Var.b() - 1) + 1;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.o
    public boolean m(RecyclerView.p pVar) {
        return pVar instanceof b;
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public int r(RecyclerView.a0 a0Var) {
        return this.Q ? S2(a0Var) : super.r(a0Var);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public int s(RecyclerView.a0 a0Var) {
        return this.Q ? T2(a0Var) : super.s(a0Var);
    }

    /* JADX WARN: Code restructure failed: missing block: B:37:0x009f, code lost:
        r21.f4054b = true;
     */
    /* JADX WARN: Code restructure failed: missing block: B:38:0x00a1, code lost:
        return;
     */
    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r5v0 */
    /* JADX WARN: Type inference failed for: r5v1, types: [int, boolean] */
    /* JADX WARN: Type inference failed for: r5v19 */
    @Override // androidx.recyclerview.widget.LinearLayoutManager
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    void s2(RecyclerView.v vVar, RecyclerView.a0 a0Var, LinearLayoutManager.c cVar, LinearLayoutManager.b bVar) {
        int i10;
        int i11;
        int i12;
        int i13;
        int i14;
        int i15;
        int f10;
        int i16;
        int K;
        int i17;
        View d10;
        int l10 = this.f4042u.l();
        ?? r52 = 0;
        boolean z9 = l10 != 1073741824;
        int i18 = J() > 0 ? this.K[this.J] : 0;
        if (z9) {
            f3();
        }
        boolean z10 = cVar.f4061e == 1;
        int i19 = this.J;
        if (!z10) {
            i19 = Z2(vVar, a0Var, cVar.f4060d) + a3(vVar, a0Var, cVar.f4060d);
        }
        int i20 = 0;
        while (i20 < this.J && cVar.c(a0Var) && i19 > 0) {
            int i21 = cVar.f4060d;
            int a32 = a3(vVar, a0Var, i21);
            if (a32 > this.J) {
                throw new IllegalArgumentException("Item at position " + i21 + " requires " + a32 + " spans but GridLayoutManager has only " + this.J + " spans.");
            }
            i19 -= a32;
            if (i19 < 0 || (d10 = cVar.d(vVar)) == null) {
                break;
            }
            this.L[i20] = d10;
            i20++;
        }
        float f11 = 0.0f;
        N2(vVar, a0Var, i20, z10);
        int i22 = 0;
        int i23 = 0;
        while (i22 < i20) {
            View view = this.L[i22];
            if (cVar.f4068l == null) {
                if (z10) {
                    d(view);
                } else {
                    e(view, r52);
                }
            } else if (z10) {
                b(view);
            } else {
                c(view, r52);
            }
            j(view, this.P);
            c3(view, l10, r52);
            int e10 = this.f4042u.e(view);
            if (e10 > i23) {
                i23 = e10;
            }
            float f12 = (this.f4042u.f(view) * 1.0f) / ((b) view.getLayoutParams()).f4035f;
            if (f12 > f11) {
                f11 = f12;
            }
            i22++;
            r52 = 0;
        }
        if (z9) {
            b3(f11, i18);
            i23 = 0;
            for (int i24 = 0; i24 < i20; i24++) {
                View view2 = this.L[i24];
                c3(view2, 1073741824, true);
                int e11 = this.f4042u.e(view2);
                if (e11 > i23) {
                    i23 = e11;
                }
            }
        }
        for (int i25 = 0; i25 < i20; i25++) {
            View view3 = this.L[i25];
            if (this.f4042u.e(view3) != i23) {
                b bVar2 = (b) view3.getLayoutParams();
                Rect rect = bVar2.f4159b;
                int i26 = rect.top + rect.bottom + ((ViewGroup.MarginLayoutParams) bVar2).topMargin + ((ViewGroup.MarginLayoutParams) bVar2).bottomMargin;
                int i27 = rect.left + rect.right + ((ViewGroup.MarginLayoutParams) bVar2).leftMargin + ((ViewGroup.MarginLayoutParams) bVar2).rightMargin;
                int W2 = W2(bVar2.f4034e, bVar2.f4035f);
                if (this.f4040s == 1) {
                    i17 = RecyclerView.o.K(W2, 1073741824, i27, ((ViewGroup.MarginLayoutParams) bVar2).width, false);
                    K = View.MeasureSpec.makeMeasureSpec(i23 - i26, 1073741824);
                } else {
                    int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i23 - i27, 1073741824);
                    K = RecyclerView.o.K(W2, 1073741824, i26, ((ViewGroup.MarginLayoutParams) bVar2).height, false);
                    i17 = makeMeasureSpec;
                }
                d3(view3, i17, K, true);
            }
        }
        int i28 = 0;
        bVar.f4053a = i23;
        if (this.f4040s == 1) {
            if (cVar.f4062f == -1) {
                i12 = cVar.f4058b;
                i13 = i12 - i23;
            } else {
                int i29 = cVar.f4058b;
                i13 = i29;
                i12 = i23 + i29;
            }
            i10 = 0;
            i11 = 0;
        } else if (cVar.f4062f == -1) {
            int i30 = cVar.f4058b;
            i11 = i30 - i23;
            i13 = 0;
            i10 = i30;
            i12 = 0;
        } else {
            int i31 = cVar.f4058b;
            i10 = i23 + i31;
            i11 = i31;
            i12 = 0;
            i13 = 0;
        }
        while (i28 < i20) {
            View view4 = this.L[i28];
            b bVar3 = (b) view4.getLayoutParams();
            if (this.f4040s != 1) {
                int g02 = g0() + this.K[bVar3.f4034e];
                i14 = g02;
                i15 = i10;
                f10 = this.f4042u.f(view4) + g02;
            } else if (q2()) {
                int e02 = e0() + this.K[this.J - bVar3.f4034e];
                i11 = e02 - this.f4042u.f(view4);
                f10 = i12;
                i15 = e02;
                i14 = i13;
            } else {
                int e03 = e0() + this.K[bVar3.f4034e];
                f10 = i12;
                i16 = e03;
                i14 = i13;
                i15 = this.f4042u.f(view4) + e03;
                z0(view4, i16, i14, i15, f10);
                if (!bVar3.c() || bVar3.b()) {
                    bVar.f4055c = true;
                }
                bVar.f4056d |= view4.hasFocusable();
                i28++;
                i12 = f10;
                i10 = i15;
                i13 = i14;
                i11 = i16;
            }
            i16 = i11;
            z0(view4, i16, i14, i15, f10);
            if (!bVar3.c()) {
            }
            bVar.f4055c = true;
            bVar.f4056d |= view4.hasFocusable();
            i28++;
            i12 = f10;
            i10 = i15;
            i13 = i14;
            i11 = i16;
        }
        Arrays.fill(this.L, (Object) null);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public int u(RecyclerView.a0 a0Var) {
        return this.Q ? S2(a0Var) : super.u(a0Var);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // androidx.recyclerview.widget.LinearLayoutManager
    public void u2(RecyclerView.v vVar, RecyclerView.a0 a0Var, LinearLayoutManager.a aVar, int i10) {
        super.u2(vVar, a0Var, aVar, i10);
        f3();
        if (a0Var.b() > 0 && !a0Var.e()) {
            U2(vVar, a0Var, aVar, i10);
        }
        V2();
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public int v(RecyclerView.a0 a0Var) {
        return this.Q ? T2(a0Var) : super.v(a0Var);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public int w1(int i10, RecyclerView.v vVar, RecyclerView.a0 a0Var) {
        f3();
        V2();
        return super.w1(i10, vVar, a0Var);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.o
    public int y1(int i10, RecyclerView.v vVar, RecyclerView.a0 a0Var) {
        f3();
        V2();
        return super.y1(i10, vVar, a0Var);
    }
}
