package androidx.profileinstaller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public abstract class o {

    /* renamed from: a  reason: collision with root package name */
    static final byte[] f4011a = {112, 114, 111, 0};

    /* renamed from: b  reason: collision with root package name */
    static final byte[] f4012b = {112, 114, 109, 0};

    private static void A(InputStream inputStream) {
        f.h(inputStream);
        int j10 = f.j(inputStream);
        if (j10 == 6 || j10 == 7) {
            return;
        }
        while (j10 > 0) {
            f.j(inputStream);
            for (int j11 = f.j(inputStream); j11 > 0; j11--) {
                f.h(inputStream);
            }
            j10--;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean B(OutputStream outputStream, byte[] bArr, e[] eVarArr) {
        if (Arrays.equals(bArr, q.f4023a)) {
            N(outputStream, eVarArr);
            return true;
        } else if (Arrays.equals(bArr, q.f4024b)) {
            M(outputStream, eVarArr);
            return true;
        } else if (Arrays.equals(bArr, q.f4026d)) {
            K(outputStream, eVarArr);
            return true;
        } else if (Arrays.equals(bArr, q.f4025c)) {
            L(outputStream, eVarArr);
            return true;
        } else if (Arrays.equals(bArr, q.f4027e)) {
            J(outputStream, eVarArr);
            return true;
        } else {
            return false;
        }
    }

    private static void C(OutputStream outputStream, e eVar) {
        int i10 = 0;
        for (int i11 : eVar.f3992h) {
            Integer valueOf = Integer.valueOf(i11);
            f.p(outputStream, valueOf.intValue() - i10);
            i10 = valueOf.intValue();
        }
    }

    private static r D(e[] eVarArr) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            f.p(byteArrayOutputStream, eVarArr.length);
            int i10 = 2;
            for (e eVar : eVarArr) {
                f.q(byteArrayOutputStream, eVar.f3987c);
                f.q(byteArrayOutputStream, eVar.f3988d);
                f.q(byteArrayOutputStream, eVar.f3991g);
                String j10 = j(eVar.f3985a, eVar.f3986b, q.f4023a);
                int k10 = f.k(j10);
                f.p(byteArrayOutputStream, k10);
                i10 = i10 + 4 + 4 + 4 + 2 + (k10 * 1);
                f.n(byteArrayOutputStream, j10);
            }
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            if (i10 == byteArray.length) {
                r rVar = new r(g.DEX_FILES, i10, byteArray, false);
                byteArrayOutputStream.close();
                return rVar;
            }
            throw f.c("Expected size " + i10 + ", does not match actual size " + byteArray.length);
        } catch (Throwable th) {
            try {
                byteArrayOutputStream.close();
            } catch (Throwable th2) {
                th.addSuppressed(th2);
            }
            throw th;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void E(OutputStream outputStream, byte[] bArr) {
        outputStream.write(f4011a);
        outputStream.write(bArr);
    }

    private static void F(OutputStream outputStream, e eVar) {
        I(outputStream, eVar);
        C(outputStream, eVar);
        H(outputStream, eVar);
    }

    private static void G(OutputStream outputStream, e eVar, String str) {
        f.p(outputStream, f.k(str));
        f.p(outputStream, eVar.f3989e);
        f.q(outputStream, eVar.f3990f);
        f.q(outputStream, eVar.f3987c);
        f.q(outputStream, eVar.f3991g);
        f.n(outputStream, str);
    }

    private static void H(OutputStream outputStream, e eVar) {
        byte[] bArr = new byte[k(eVar.f3991g)];
        for (Map.Entry entry : eVar.f3993i.entrySet()) {
            int intValue = ((Integer) entry.getKey()).intValue();
            int intValue2 = ((Integer) entry.getValue()).intValue();
            if ((intValue2 & 2) != 0) {
                z(bArr, 2, intValue, eVar);
            }
            if ((intValue2 & 4) != 0) {
                z(bArr, 4, intValue, eVar);
            }
        }
        outputStream.write(bArr);
    }

    private static void I(OutputStream outputStream, e eVar) {
        int i10 = 0;
        for (Map.Entry entry : eVar.f3993i.entrySet()) {
            int intValue = ((Integer) entry.getKey()).intValue();
            if ((((Integer) entry.getValue()).intValue() & 1) != 0) {
                f.p(outputStream, intValue - i10);
                f.p(outputStream, 0);
                i10 = intValue;
            }
        }
    }

    private static void J(OutputStream outputStream, e[] eVarArr) {
        f.p(outputStream, eVarArr.length);
        for (e eVar : eVarArr) {
            String j10 = j(eVar.f3985a, eVar.f3986b, q.f4027e);
            f.p(outputStream, f.k(j10));
            f.p(outputStream, eVar.f3993i.size());
            f.p(outputStream, eVar.f3992h.length);
            f.q(outputStream, eVar.f3987c);
            f.n(outputStream, j10);
            for (Integer num : eVar.f3993i.keySet()) {
                f.p(outputStream, num.intValue());
            }
            for (int i10 : eVar.f3992h) {
                f.p(outputStream, i10);
            }
        }
    }

    private static void K(OutputStream outputStream, e[] eVarArr) {
        f.r(outputStream, eVarArr.length);
        for (e eVar : eVarArr) {
            String j10 = j(eVar.f3985a, eVar.f3986b, q.f4026d);
            f.p(outputStream, f.k(j10));
            f.p(outputStream, eVar.f3992h.length);
            f.q(outputStream, eVar.f3993i.size() * 4);
            f.q(outputStream, eVar.f3987c);
            f.n(outputStream, j10);
            for (Integer num : eVar.f3993i.keySet()) {
                f.p(outputStream, num.intValue());
                f.p(outputStream, 0);
            }
            for (int i10 : eVar.f3992h) {
                f.p(outputStream, i10);
            }
        }
    }

    private static void L(OutputStream outputStream, e[] eVarArr) {
        byte[] b10 = b(eVarArr, q.f4025c);
        f.r(outputStream, eVarArr.length);
        f.m(outputStream, b10);
    }

    private static void M(OutputStream outputStream, e[] eVarArr) {
        byte[] b10 = b(eVarArr, q.f4024b);
        f.r(outputStream, eVarArr.length);
        f.m(outputStream, b10);
    }

    private static void N(OutputStream outputStream, e[] eVarArr) {
        O(outputStream, eVarArr);
    }

    private static void O(OutputStream outputStream, e[] eVarArr) {
        int length;
        ArrayList arrayList = new ArrayList(3);
        ArrayList arrayList2 = new ArrayList(3);
        arrayList.add(D(eVarArr));
        arrayList.add(c(eVarArr));
        arrayList.add(d(eVarArr));
        long length2 = q.f4023a.length + f4011a.length + 4 + (arrayList.size() * 16);
        f.q(outputStream, arrayList.size());
        for (int i10 = 0; i10 < arrayList.size(); i10++) {
            r rVar = (r) arrayList.get(i10);
            f.q(outputStream, rVar.f4030a.g());
            f.q(outputStream, length2);
            if (rVar.f4033d) {
                byte[] bArr = rVar.f4032c;
                byte[] b10 = f.b(bArr);
                arrayList2.add(b10);
                f.q(outputStream, b10.length);
                f.q(outputStream, bArr.length);
                length = b10.length;
            } else {
                arrayList2.add(rVar.f4032c);
                f.q(outputStream, rVar.f4032c.length);
                f.q(outputStream, 0L);
                length = rVar.f4032c.length;
            }
            length2 += length;
        }
        for (int i11 = 0; i11 < arrayList2.size(); i11++) {
            outputStream.write((byte[]) arrayList2.get(i11));
        }
    }

    private static int a(e eVar) {
        int i10 = 0;
        for (Map.Entry entry : eVar.f3993i.entrySet()) {
            i10 |= ((Integer) entry.getValue()).intValue();
        }
        return i10;
    }

    private static byte[] b(e[] eVarArr, byte[] bArr) {
        int i10 = 0;
        int i11 = 0;
        for (e eVar : eVarArr) {
            i11 += f.k(j(eVar.f3985a, eVar.f3986b, bArr)) + 16 + (eVar.f3989e * 2) + eVar.f3990f + k(eVar.f3991g);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(i11);
        if (Arrays.equals(bArr, q.f4025c)) {
            int length = eVarArr.length;
            while (i10 < length) {
                e eVar2 = eVarArr[i10];
                G(byteArrayOutputStream, eVar2, j(eVar2.f3985a, eVar2.f3986b, bArr));
                F(byteArrayOutputStream, eVar2);
                i10++;
            }
        } else {
            for (e eVar3 : eVarArr) {
                G(byteArrayOutputStream, eVar3, j(eVar3.f3985a, eVar3.f3986b, bArr));
            }
            int length2 = eVarArr.length;
            while (i10 < length2) {
                F(byteArrayOutputStream, eVarArr[i10]);
                i10++;
            }
        }
        if (byteArrayOutputStream.size() == i11) {
            return byteArrayOutputStream.toByteArray();
        }
        throw f.c("The bytes saved do not match expectation. actual=" + byteArrayOutputStream.size() + " expected=" + i11);
    }

    private static r c(e[] eVarArr) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int i10 = 0;
        for (int i11 = 0; i11 < eVarArr.length; i11++) {
            try {
                e eVar = eVarArr[i11];
                f.p(byteArrayOutputStream, i11);
                f.p(byteArrayOutputStream, eVar.f3989e);
                i10 = i10 + 2 + 2 + (eVar.f3989e * 2);
                C(byteArrayOutputStream, eVar);
            } catch (Throwable th) {
                try {
                    byteArrayOutputStream.close();
                } catch (Throwable th2) {
                    th.addSuppressed(th2);
                }
                throw th;
            }
        }
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        if (i10 == byteArray.length) {
            r rVar = new r(g.CLASSES, i10, byteArray, true);
            byteArrayOutputStream.close();
            return rVar;
        }
        throw f.c("Expected size " + i10 + ", does not match actual size " + byteArray.length);
    }

    private static r d(e[] eVarArr) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int i10 = 0;
        for (int i11 = 0; i11 < eVarArr.length; i11++) {
            try {
                e eVar = eVarArr[i11];
                int a10 = a(eVar);
                byte[] e10 = e(eVar);
                byte[] f10 = f(eVar);
                f.p(byteArrayOutputStream, i11);
                int length = e10.length + 2 + f10.length;
                f.q(byteArrayOutputStream, length);
                f.p(byteArrayOutputStream, a10);
                byteArrayOutputStream.write(e10);
                byteArrayOutputStream.write(f10);
                i10 = i10 + 2 + 4 + length;
            } catch (Throwable th) {
                try {
                    byteArrayOutputStream.close();
                } catch (Throwable th2) {
                    th.addSuppressed(th2);
                }
                throw th;
            }
        }
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        if (i10 == byteArray.length) {
            r rVar = new r(g.METHODS, i10, byteArray, true);
            byteArrayOutputStream.close();
            return rVar;
        }
        throw f.c("Expected size " + i10 + ", does not match actual size " + byteArray.length);
    }

    private static byte[] e(e eVar) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            H(byteArrayOutputStream, eVar);
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byteArray;
        } catch (Throwable th) {
            try {
                byteArrayOutputStream.close();
            } catch (Throwable th2) {
                th.addSuppressed(th2);
            }
            throw th;
        }
    }

    private static byte[] f(e eVar) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            I(byteArrayOutputStream, eVar);
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byteArray;
        } catch (Throwable th) {
            try {
                byteArrayOutputStream.close();
            } catch (Throwable th2) {
                th.addSuppressed(th2);
            }
            throw th;
        }
    }

    private static String g(String str, String str2) {
        return "!".equals(str2) ? str.replace(":", "!") : ":".equals(str2) ? str.replace("!", ":") : str;
    }

    private static String h(String str) {
        int indexOf = str.indexOf("!");
        if (indexOf < 0) {
            indexOf = str.indexOf(":");
        }
        return indexOf > 0 ? str.substring(indexOf + 1) : str;
    }

    private static e i(e[] eVarArr, String str) {
        if (eVarArr.length <= 0) {
            return null;
        }
        String h10 = h(str);
        for (int i10 = 0; i10 < eVarArr.length; i10++) {
            if (eVarArr[i10].f3986b.equals(h10)) {
                return eVarArr[i10];
            }
        }
        return null;
    }

    private static String j(String str, String str2, byte[] bArr) {
        String a10 = q.a(bArr);
        if (str.length() <= 0) {
            return g(str2, a10);
        }
        if (str2.equals("classes.dex")) {
            return str;
        }
        if (str2.contains("!") || str2.contains(":")) {
            return g(str2, a10);
        }
        if (str2.endsWith(".apk")) {
            return str2;
        }
        return str + q.a(bArr) + str2;
    }

    private static int k(int i10) {
        return y(i10 * 2) / 8;
    }

    private static int l(int i10, int i11, int i12) {
        if (i10 != 1) {
            if (i10 != 2) {
                if (i10 == 4) {
                    return i11 + i12;
                }
                throw f.c("Unexpected flag: " + i10);
            }
            return i11;
        }
        throw f.c("HOT methods are not stored in the bitmap");
    }

    private static int[] m(InputStream inputStream, int i10) {
        int[] iArr = new int[i10];
        int i11 = 0;
        for (int i12 = 0; i12 < i10; i12++) {
            i11 += f.h(inputStream);
            iArr[i12] = i11;
        }
        return iArr;
    }

    private static int n(BitSet bitSet, int i10, int i11) {
        int i12 = bitSet.get(l(2, i10, i11)) ? 2 : 0;
        return bitSet.get(l(4, i10, i11)) ? i12 | 4 : i12;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static byte[] o(InputStream inputStream, byte[] bArr) {
        if (Arrays.equals(bArr, f.d(inputStream, bArr.length))) {
            return f.d(inputStream, q.f4024b.length);
        }
        throw f.c("Invalid magic");
    }

    private static void p(InputStream inputStream, e eVar) {
        int available = inputStream.available() - eVar.f3990f;
        int i10 = 0;
        while (inputStream.available() > available) {
            i10 += f.h(inputStream);
            eVar.f3993i.put(Integer.valueOf(i10), 1);
            for (int h10 = f.h(inputStream); h10 > 0; h10--) {
                A(inputStream);
            }
        }
        if (inputStream.available() != available) {
            throw f.c("Read too much data during profile line parse");
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static e[] q(InputStream inputStream, byte[] bArr, byte[] bArr2, e[] eVarArr) {
        if (Arrays.equals(bArr, q.f4028f)) {
            if (Arrays.equals(q.f4023a, bArr2)) {
                throw f.c("Requires new Baseline Profile Metadata. Please rebuild the APK with Android Gradle Plugin 7.2 Canary 7 or higher");
            }
            return r(inputStream, bArr, eVarArr);
        } else if (Arrays.equals(bArr, q.f4029g)) {
            return t(inputStream, bArr2, eVarArr);
        } else {
            throw f.c("Unsupported meta version");
        }
    }

    static e[] r(InputStream inputStream, byte[] bArr, e[] eVarArr) {
        if (Arrays.equals(bArr, q.f4028f)) {
            int j10 = f.j(inputStream);
            byte[] e10 = f.e(inputStream, (int) f.i(inputStream), (int) f.i(inputStream));
            if (inputStream.read() <= 0) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(e10);
                try {
                    e[] s9 = s(byteArrayInputStream, j10, eVarArr);
                    byteArrayInputStream.close();
                    return s9;
                } catch (Throwable th) {
                    try {
                        byteArrayInputStream.close();
                    } catch (Throwable th2) {
                        th.addSuppressed(th2);
                    }
                    throw th;
                }
            }
            throw f.c("Content found after the end of file");
        }
        throw f.c("Unsupported meta version");
    }

    private static e[] s(InputStream inputStream, int i10, e[] eVarArr) {
        if (inputStream.available() == 0) {
            return new e[0];
        }
        if (i10 == eVarArr.length) {
            String[] strArr = new String[i10];
            int[] iArr = new int[i10];
            for (int i11 = 0; i11 < i10; i11++) {
                int h10 = f.h(inputStream);
                iArr[i11] = f.h(inputStream);
                strArr[i11] = f.f(inputStream, h10);
            }
            for (int i12 = 0; i12 < i10; i12++) {
                e eVar = eVarArr[i12];
                if (!eVar.f3986b.equals(strArr[i12])) {
                    throw f.c("Order of dexfiles in metadata did not match baseline");
                }
                int i13 = iArr[i12];
                eVar.f3989e = i13;
                eVar.f3992h = m(inputStream, i13);
            }
            return eVarArr;
        }
        throw f.c("Mismatched number of dex files found in metadata");
    }

    static e[] t(InputStream inputStream, byte[] bArr, e[] eVarArr) {
        int h10 = f.h(inputStream);
        byte[] e10 = f.e(inputStream, (int) f.i(inputStream), (int) f.i(inputStream));
        if (inputStream.read() <= 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(e10);
            try {
                e[] u9 = u(byteArrayInputStream, bArr, h10, eVarArr);
                byteArrayInputStream.close();
                return u9;
            } catch (Throwable th) {
                try {
                    byteArrayInputStream.close();
                } catch (Throwable th2) {
                    th.addSuppressed(th2);
                }
                throw th;
            }
        }
        throw f.c("Content found after the end of file");
    }

    private static e[] u(InputStream inputStream, byte[] bArr, int i10, e[] eVarArr) {
        if (inputStream.available() == 0) {
            return new e[0];
        }
        if (i10 == eVarArr.length) {
            for (int i11 = 0; i11 < i10; i11++) {
                f.h(inputStream);
                String f10 = f.f(inputStream, f.h(inputStream));
                long i12 = f.i(inputStream);
                int h10 = f.h(inputStream);
                e i13 = i(eVarArr, f10);
                if (i13 == null) {
                    throw f.c("Missing profile key: " + f10);
                }
                i13.f3988d = i12;
                int[] m10 = m(inputStream, h10);
                if (Arrays.equals(bArr, q.f4027e)) {
                    i13.f3989e = h10;
                    i13.f3992h = m10;
                }
            }
            return eVarArr;
        }
        throw f.c("Mismatched number of dex files found in metadata");
    }

    private static void v(InputStream inputStream, e eVar) {
        BitSet valueOf = BitSet.valueOf(f.d(inputStream, f.a(eVar.f3991g * 2)));
        int i10 = 0;
        while (true) {
            int i11 = eVar.f3991g;
            if (i10 >= i11) {
                return;
            }
            int n10 = n(valueOf, i10, i11);
            if (n10 != 0) {
                Integer num = (Integer) eVar.f3993i.get(Integer.valueOf(i10));
                if (num == null) {
                    num = 0;
                }
                eVar.f3993i.put(Integer.valueOf(i10), Integer.valueOf(n10 | num.intValue()));
            }
            i10++;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static e[] w(InputStream inputStream, byte[] bArr, String str) {
        if (Arrays.equals(bArr, q.f4024b)) {
            int j10 = f.j(inputStream);
            byte[] e10 = f.e(inputStream, (int) f.i(inputStream), (int) f.i(inputStream));
            if (inputStream.read() <= 0) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(e10);
                try {
                    e[] x9 = x(byteArrayInputStream, str, j10);
                    byteArrayInputStream.close();
                    return x9;
                } catch (Throwable th) {
                    try {
                        byteArrayInputStream.close();
                    } catch (Throwable th2) {
                        th.addSuppressed(th2);
                    }
                    throw th;
                }
            }
            throw f.c("Content found after the end of file");
        }
        throw f.c("Unsupported version");
    }

    private static e[] x(InputStream inputStream, String str, int i10) {
        if (inputStream.available() == 0) {
            return new e[0];
        }
        e[] eVarArr = new e[i10];
        for (int i11 = 0; i11 < i10; i11++) {
            int h10 = f.h(inputStream);
            int h11 = f.h(inputStream);
            long i12 = f.i(inputStream);
            eVarArr[i11] = new e(str, f.f(inputStream, h10), f.i(inputStream), 0L, h11, (int) i12, (int) f.i(inputStream), new int[h11], new TreeMap());
        }
        for (int i13 = 0; i13 < i10; i13++) {
            e eVar = eVarArr[i13];
            p(inputStream, eVar);
            eVar.f3992h = m(inputStream, eVar.f3989e);
            v(inputStream, eVar);
        }
        return eVarArr;
    }

    private static int y(int i10) {
        return ((i10 + 8) - 1) & (-8);
    }

    private static void z(byte[] bArr, int i10, int i11, e eVar) {
        int l10 = l(i10, i11, eVar.f3991g);
        int i12 = l10 / 8;
        bArr[i12] = (byte) ((1 << (l10 % 8)) | bArr[i12]);
    }
}
