package androidx.profileinstaller;

import android.content.res.AssetManager;
import android.os.Build;
import androidx.profileinstaller.j;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
/* loaded from: classes.dex */
public class d {

    /* renamed from: a  reason: collision with root package name */
    private final AssetManager f3974a;

    /* renamed from: b  reason: collision with root package name */
    private final Executor f3975b;

    /* renamed from: c  reason: collision with root package name */
    private final j.c f3976c;

    /* renamed from: e  reason: collision with root package name */
    private final File f3978e;

    /* renamed from: f  reason: collision with root package name */
    private final String f3979f;

    /* renamed from: g  reason: collision with root package name */
    private final String f3980g;

    /* renamed from: h  reason: collision with root package name */
    private final String f3981h;

    /* renamed from: j  reason: collision with root package name */
    private e[] f3983j;

    /* renamed from: k  reason: collision with root package name */
    private byte[] f3984k;

    /* renamed from: i  reason: collision with root package name */
    private boolean f3982i = false;

    /* renamed from: d  reason: collision with root package name */
    private final byte[] f3977d = d();

    public d(AssetManager assetManager, Executor executor, j.c cVar, String str, String str2, String str3, File file) {
        this.f3974a = assetManager;
        this.f3975b = executor;
        this.f3976c = cVar;
        this.f3979f = str;
        this.f3980g = str2;
        this.f3981h = str3;
        this.f3978e = file;
    }

    private d b(e[] eVarArr, byte[] bArr) {
        j.c cVar;
        int i10;
        InputStream h10;
        try {
            h10 = h(this.f3974a, this.f3981h);
        } catch (FileNotFoundException e10) {
            e = e10;
            cVar = this.f3976c;
            i10 = 9;
            cVar.b(i10, e);
            return null;
        } catch (IOException e11) {
            e = e11;
            cVar = this.f3976c;
            i10 = 7;
            cVar.b(i10, e);
            return null;
        } catch (IllegalStateException e12) {
            e = e12;
            this.f3983j = null;
            cVar = this.f3976c;
            i10 = 8;
            cVar.b(i10, e);
            return null;
        }
        if (h10 != null) {
            this.f3983j = o.q(h10, o.o(h10, o.f4012b), bArr, eVarArr);
            h10.close();
            return this;
        }
        if (h10 != null) {
            h10.close();
        }
        return null;
    }

    private void c() {
        if (!this.f3982i) {
            throw new IllegalStateException("This device doesn't support aot. Did you call deviceSupportsAotProfile()?");
        }
    }

    private static byte[] d() {
        int i10 = Build.VERSION.SDK_INT;
        if (i10 < 24 || i10 > 34) {
            return null;
        }
        switch (i10) {
            case 24:
            case 25:
                return q.f4027e;
            case 26:
                return q.f4026d;
            case 27:
                return q.f4025c;
            case 28:
            case 29:
            case 30:
                return q.f4024b;
            case 31:
            case 32:
            case 33:
            case 34:
                return q.f4023a;
            default:
                return null;
        }
    }

    private InputStream f(AssetManager assetManager) {
        j.c cVar;
        int i10;
        try {
            return h(assetManager, this.f3980g);
        } catch (FileNotFoundException e10) {
            e = e10;
            cVar = this.f3976c;
            i10 = 6;
            cVar.b(i10, e);
            return null;
        } catch (IOException e11) {
            e = e11;
            cVar = this.f3976c;
            i10 = 7;
            cVar.b(i10, e);
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void g(int i10, Object obj) {
        this.f3976c.b(i10, obj);
    }

    private InputStream h(AssetManager assetManager, String str) {
        try {
            return assetManager.openFd(str).createInputStream();
        } catch (FileNotFoundException e10) {
            String message = e10.getMessage();
            if (message == null || !message.contains("compressed")) {
                return null;
            }
            this.f3976c.a(5, null);
            return null;
        }
    }

    private e[] j(InputStream inputStream) {
        try {
        } catch (IOException e10) {
            this.f3976c.b(7, e10);
        }
        try {
            try {
                e[] w9 = o.w(inputStream, o.o(inputStream, o.f4011a), this.f3979f);
                try {
                    inputStream.close();
                    return w9;
                } catch (IOException e11) {
                    this.f3976c.b(7, e11);
                    return w9;
                }
            } catch (Throwable th) {
                try {
                    inputStream.close();
                } catch (IOException e12) {
                    this.f3976c.b(7, e12);
                }
                throw th;
            }
        } catch (IOException e13) {
            this.f3976c.b(7, e13);
            inputStream.close();
            return null;
        } catch (IllegalStateException e14) {
            this.f3976c.b(8, e14);
            inputStream.close();
            return null;
        }
    }

    private static boolean k() {
        int i10 = Build.VERSION.SDK_INT;
        if (i10 < 24 || i10 > 34) {
            return false;
        }
        if (i10 != 24 && i10 != 25) {
            switch (i10) {
                case 31:
                case 32:
                case 33:
                case 34:
                    break;
                default:
                    return false;
            }
        }
        return true;
    }

    private void l(final int i10, final Object obj) {
        this.f3975b.execute(new Runnable() { // from class: androidx.profileinstaller.c
            @Override // java.lang.Runnable
            public final void run() {
                d.this.g(i10, obj);
            }
        });
    }

    public boolean e() {
        if (this.f3977d == null) {
            l(3, Integer.valueOf(Build.VERSION.SDK_INT));
            return false;
        }
        if (!this.f3978e.exists()) {
            try {
                this.f3978e.createNewFile();
            } catch (IOException unused) {
                l(4, null);
                return false;
            }
        } else if (!this.f3978e.canWrite()) {
            l(4, null);
            return false;
        }
        this.f3982i = true;
        return true;
    }

    public d i() {
        d b10;
        c();
        if (this.f3977d == null) {
            return this;
        }
        InputStream f10 = f(this.f3974a);
        if (f10 != null) {
            this.f3983j = j(f10);
        }
        e[] eVarArr = this.f3983j;
        return (eVarArr == null || !k() || (b10 = b(eVarArr, this.f3977d)) == null) ? this : b10;
    }

    public d m() {
        j.c cVar;
        int i10;
        ByteArrayOutputStream byteArrayOutputStream;
        e[] eVarArr = this.f3983j;
        byte[] bArr = this.f3977d;
        if (eVarArr != null && bArr != null) {
            c();
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    o.E(byteArrayOutputStream, bArr);
                } catch (Throwable th) {
                    try {
                        byteArrayOutputStream.close();
                    } catch (Throwable th2) {
                        th.addSuppressed(th2);
                    }
                    throw th;
                }
            } catch (IOException e10) {
                e = e10;
                cVar = this.f3976c;
                i10 = 7;
                cVar.b(i10, e);
                this.f3983j = null;
                return this;
            } catch (IllegalStateException e11) {
                e = e11;
                cVar = this.f3976c;
                i10 = 8;
                cVar.b(i10, e);
                this.f3983j = null;
                return this;
            }
            if (!o.B(byteArrayOutputStream, bArr, eVarArr)) {
                this.f3976c.b(5, null);
                this.f3983j = null;
                byteArrayOutputStream.close();
                return this;
            }
            this.f3984k = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            this.f3983j = null;
        }
        return this;
    }

    /* JADX WARN: Type inference failed for: r2v0, types: [androidx.profileinstaller.e[], byte[]] */
    public boolean n() {
        byte[] bArr = this.f3984k;
        if (bArr == null) {
            return false;
        }
        c();
        try {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bArr);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.f3978e);
                    f.l(byteArrayInputStream, fileOutputStream);
                    l(1, null);
                    fileOutputStream.close();
                    byteArrayInputStream.close();
                    return true;
                } catch (Throwable th) {
                    try {
                        byteArrayInputStream.close();
                    } catch (Throwable th2) {
                        th.addSuppressed(th2);
                    }
                    throw th;
                }
            } catch (FileNotFoundException e10) {
                l(6, e10);
                return false;
            } catch (IOException e11) {
                l(7, e11);
                return false;
            }
        } finally {
            this.f3984k = null;
            this.f3983j = null;
        }
    }
}
