package androidx.media3.exoplayer.rtsp;

import android.net.Uri;
import androidx.media3.exoplayer.rtsp.m;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import r6.v;
import r6.y0;
import s0.j0;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public abstract class u {

    /* renamed from: a  reason: collision with root package name */
    private static final Pattern f3893a = Pattern.compile("([A-Z_]+) (.*) RTSP/1\\.0");

    /* renamed from: b  reason: collision with root package name */
    private static final Pattern f3894b = Pattern.compile("RTSP/1\\.0 (\\d+) (.+)");

    /* renamed from: c  reason: collision with root package name */
    private static final Pattern f3895c = Pattern.compile("Content-Length:\\s?(\\d+)", 2);

    /* renamed from: d  reason: collision with root package name */
    private static final Pattern f3896d = Pattern.compile("([\\w$\\-_.+]+)(?:;\\s?timeout=(\\d+))?");

    /* renamed from: e  reason: collision with root package name */
    private static final Pattern f3897e = Pattern.compile("Digest realm=\"([^\"\\x00-\\x08\\x0A-\\x1f\\x7f]+)\",\\s?(?:domain=\"(.+)\",\\s?)?nonce=\"([^\"\\x00-\\x08\\x0A-\\x1f\\x7f]+)\"(?:,\\s?opaque=\"([^\"\\x00-\\x08\\x0A-\\x1f\\x7f]+)\")?");

    /* renamed from: f  reason: collision with root package name */
    private static final Pattern f3898f = Pattern.compile("Basic realm=\"([^\"\\x00-\\x08\\x0A-\\x1f\\x7f]+)\"");

    /* renamed from: g  reason: collision with root package name */
    private static final String f3899g = new String(new byte[]{10});

    /* renamed from: h  reason: collision with root package name */
    private static final String f3900h = new String(new byte[]{13, 10});

    /* loaded from: classes.dex */
    public static final class a {

        /* renamed from: a  reason: collision with root package name */
        public final String f3901a;

        /* renamed from: b  reason: collision with root package name */
        public final String f3902b;

        public a(String str, String str2) {
            this.f3901a = str;
            this.f3902b = str2;
        }
    }

    /* loaded from: classes.dex */
    public static final class b {

        /* renamed from: a  reason: collision with root package name */
        public final String f3903a;

        /* renamed from: b  reason: collision with root package name */
        public final long f3904b;

        public b(String str, long j10) {
            this.f3903a = str;
            this.f3904b = j10;
        }
    }

    public static void a(boolean z9, String str) {
        if (!z9) {
            throw p0.z.c(str, null);
        }
    }

    public static byte[] b(List list) {
        return q6.g.g(f3900h).d(list).getBytes(s.f3871m);
    }

    private static String c(int i10) {
        if (i10 != 200) {
            if (i10 != 461) {
                if (i10 != 500) {
                    if (i10 != 505) {
                        if (i10 != 301) {
                            if (i10 != 302) {
                                if (i10 != 400) {
                                    if (i10 != 401) {
                                        if (i10 != 404) {
                                            if (i10 != 405) {
                                                switch (i10) {
                                                    case 454:
                                                        return "Session Not Found";
                                                    case 455:
                                                        return "Method Not Valid In This State";
                                                    case 456:
                                                        return "Header Field Not Valid";
                                                    case 457:
                                                        return "Invalid Range";
                                                    default:
                                                        throw new IllegalArgumentException();
                                                }
                                            }
                                            return "Method Not Allowed";
                                        }
                                        return "Not Found";
                                    }
                                    return "Unauthorized";
                                }
                                return "Bad Request";
                            }
                            return "Move Temporarily";
                        }
                        return "Move Permanently";
                    }
                    return "RTSP Version Not Supported";
                }
                return "Internal Server Error";
            }
            return "Unsupported Transport";
        }
        return "OK";
    }

    public static byte[] d(String str) {
        return str.getBytes(s.f3871m);
    }

    public static boolean e(List list) {
        return f3894b.matcher((CharSequence) list.get(0)).matches();
    }

    public static boolean f(String str) {
        return f3893a.matcher(str).matches() || f3894b.matcher(str).matches();
    }

    public static long g(String str) {
        try {
            Matcher matcher = f3895c.matcher(str);
            if (matcher.find()) {
                return Long.parseLong((String) s0.a.e(matcher.group(1)));
            }
            return -1L;
        } catch (NumberFormatException e10) {
            throw p0.z.c(str, e10);
        }
    }

    public static int h(String str) {
        try {
            return Integer.parseInt(str);
        } catch (NumberFormatException e10) {
            throw p0.z.c(str, e10);
        }
    }

    private static int i(String str) {
        str.hashCode();
        char c10 = 65535;
        switch (str.hashCode()) {
            case -1881579439:
                if (str.equals("RECORD")) {
                    c10 = 0;
                    break;
                }
                break;
            case -880847356:
                if (str.equals("TEARDOWN")) {
                    c10 = 1;
                    break;
                }
                break;
            case -702888512:
                if (str.equals("GET_PARAMETER")) {
                    c10 = 2;
                    break;
                }
                break;
            case -531492226:
                if (str.equals("OPTIONS")) {
                    c10 = 3;
                    break;
                }
                break;
            case -84360524:
                if (str.equals("PLAY_NOTIFY")) {
                    c10 = 4;
                    break;
                }
                break;
            case 2458420:
                if (str.equals("PLAY")) {
                    c10 = 5;
                    break;
                }
                break;
            case 6481884:
                if (str.equals("REDIRECT")) {
                    c10 = 6;
                    break;
                }
                break;
            case 71242700:
                if (str.equals("SET_PARAMETER")) {
                    c10 = 7;
                    break;
                }
                break;
            case 75902422:
                if (str.equals("PAUSE")) {
                    c10 = '\b';
                    break;
                }
                break;
            case 78791261:
                if (str.equals("SETUP")) {
                    c10 = '\t';
                    break;
                }
                break;
            case 133006441:
                if (str.equals("ANNOUNCE")) {
                    c10 = '\n';
                    break;
                }
                break;
            case 1800840907:
                if (str.equals("DESCRIBE")) {
                    c10 = 11;
                    break;
                }
                break;
        }
        switch (c10) {
            case 0:
                return 8;
            case 1:
                return 12;
            case 2:
                return 3;
            case 3:
                return 4;
            case 4:
                return 7;
            case 5:
                return 6;
            case 6:
                return 9;
            case 7:
                return 11;
            case '\b':
                return 5;
            case '\t':
                return 10;
            case '\n':
                return 1;
            case 11:
                return 2;
            default:
                return 0;
        }
    }

    public static r6.v j(String str) {
        if (str == null) {
            return r6.v.y();
        }
        v.a aVar = new v.a();
        for (String str2 : j0.e1(str, ",\\s?")) {
            int i10 = i(str2);
            if (i10 != 0) {
                aVar.a(Integer.valueOf(i10));
            }
        }
        return aVar.k();
    }

    public static x k(List list) {
        Matcher matcher = f3893a.matcher((CharSequence) list.get(0));
        s0.a.a(matcher.matches());
        int i10 = i((String) s0.a.e(matcher.group(1)));
        Uri parse = Uri.parse((String) s0.a.e(matcher.group(2)));
        int indexOf = list.indexOf("");
        s0.a.a(indexOf > 0);
        return new x(parse, i10, new m.b().c(list.subList(1, indexOf)).e(), q6.g.g(f3900h).d(list.subList(indexOf + 1, list.size())));
    }

    public static y l(List list) {
        Matcher matcher = f3894b.matcher((CharSequence) list.get(0));
        s0.a.a(matcher.matches());
        int parseInt = Integer.parseInt((String) s0.a.e(matcher.group(1)));
        int indexOf = list.indexOf("");
        s0.a.a(indexOf > 0);
        return new y(parseInt, new m.b().c(list.subList(1, indexOf)).e(), q6.g.g(f3900h).d(list.subList(indexOf + 1, list.size())));
    }

    public static b m(String str) {
        Matcher matcher = f3896d.matcher(str);
        if (matcher.matches()) {
            String str2 = (String) s0.a.e(matcher.group(1));
            long j10 = 60000;
            String group = matcher.group(2);
            if (group != null) {
                try {
                    j10 = Integer.parseInt(group) * 1000;
                } catch (NumberFormatException e10) {
                    throw p0.z.c(str, e10);
                }
            }
            return new b(str2, j10);
        }
        throw p0.z.c(str, null);
    }

    public static a n(Uri uri) {
        String userInfo = uri.getUserInfo();
        if (userInfo != null && userInfo.contains(":")) {
            String[] f12 = j0.f1(userInfo, ":");
            return new a(f12[0], f12[1]);
        }
        return null;
    }

    public static i o(String str) {
        Matcher matcher = f3897e.matcher(str);
        if (matcher.find()) {
            return new i(2, (String) s0.a.e(matcher.group(1)), (String) s0.a.e(matcher.group(3)), q6.q.c(matcher.group(4)));
        }
        Matcher matcher2 = f3898f.matcher(str);
        if (matcher2.matches()) {
            return new i(1, (String) s0.a.e(matcher2.group(1)), "", "");
        }
        throw p0.z.c("Invalid WWW-Authenticate header " + str, null);
    }

    public static Uri p(Uri uri) {
        if (uri.getUserInfo() == null) {
            return uri;
        }
        String str = (String) s0.a.e(uri.getAuthority());
        s0.a.a(str.contains("@"));
        return uri.buildUpon().encodedAuthority(j0.e1(str, "@")[1]).build();
    }

    public static r6.v q(x xVar) {
        s0.a.a(xVar.f3912c.d("CSeq") != null);
        v.a aVar = new v.a();
        aVar.a(j0.H("%s %s %s", t(xVar.f3911b), xVar.f3910a, "RTSP/1.0"));
        r6.w b10 = xVar.f3912c.b();
        y0 o10 = b10.keySet().o();
        while (o10.hasNext()) {
            String str = (String) o10.next();
            r6.v vVar = b10.get(str);
            for (int i10 = 0; i10 < vVar.size(); i10++) {
                aVar.a(j0.H("%s: %s", str, vVar.get(i10)));
            }
        }
        aVar.a("");
        aVar.a(xVar.f3913d);
        return aVar.k();
    }

    public static r6.v r(y yVar) {
        s0.a.a(yVar.f3915b.d("CSeq") != null);
        v.a aVar = new v.a();
        aVar.a(j0.H("%s %s %s", "RTSP/1.0", Integer.valueOf(yVar.f3914a), c(yVar.f3914a)));
        r6.w b10 = yVar.f3915b.b();
        y0 o10 = b10.keySet().o();
        while (o10.hasNext()) {
            String str = (String) o10.next();
            r6.v vVar = b10.get(str);
            for (int i10 = 0; i10 < vVar.size(); i10++) {
                aVar.a(j0.H("%s: %s", str, vVar.get(i10)));
            }
        }
        aVar.a("");
        aVar.a(yVar.f3916c);
        return aVar.k();
    }

    public static String[] s(String str) {
        String str2 = f3900h;
        if (!str.contains(str2)) {
            str2 = f3899g;
        }
        return j0.e1(str, str2);
    }

    public static String t(int i10) {
        switch (i10) {
            case 1:
                return "ANNOUNCE";
            case 2:
                return "DESCRIBE";
            case 3:
                return "GET_PARAMETER";
            case 4:
                return "OPTIONS";
            case 5:
                return "PAUSE";
            case 6:
                return "PLAY";
            case 7:
                return "PLAY_NOTIFY";
            case 8:
                return "RECORD";
            case 9:
                return "REDIRECT";
            case 10:
                return "SETUP";
            case 11:
                return "SET_PARAMETER";
            case 12:
                return "TEARDOWN";
            default:
                throw new IllegalStateException();
        }
    }
}
