package androidx.media3.exoplayer.rtsp;

import android.os.Handler;
import android.os.HandlerThread;
import androidx.media3.exoplayer.rtsp.s;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import q1.n;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public final class s implements Closeable {

    /* renamed from: m  reason: collision with root package name */
    public static final Charset f3871m = q6.d.f12236c;

    /* renamed from: g  reason: collision with root package name */
    private final d f3872g;

    /* renamed from: h  reason: collision with root package name */
    private final q1.n f3873h = new q1.n("ExoPlayer:RtspMessageChannel:ReceiverLoader");

    /* renamed from: i  reason: collision with root package name */
    private final Map f3874i = Collections.synchronizedMap(new HashMap());

    /* renamed from: j  reason: collision with root package name */
    private g f3875j;

    /* renamed from: k  reason: collision with root package name */
    private Socket f3876k;

    /* renamed from: l  reason: collision with root package name */
    private volatile boolean f3877l;

    /* loaded from: classes.dex */
    public interface b {
        void f(byte[] bArr);
    }

    /* loaded from: classes.dex */
    private final class c implements n.b {
        private c() {
        }

        @Override // q1.n.b
        /* renamed from: a */
        public void t(f fVar, long j10, long j11, boolean z9) {
        }

        @Override // q1.n.b
        /* renamed from: b */
        public void p(f fVar, long j10, long j11) {
        }

        @Override // q1.n.b
        /* renamed from: c */
        public n.c n(f fVar, long j10, long j11, IOException iOException, int i10) {
            if (!s.this.f3877l) {
                s.this.f3872g.a(iOException);
            }
            return q1.n.f12131f;
        }
    }

    /* loaded from: classes.dex */
    public interface d {
        void a(Exception exc);

        void b(List list, Exception exc);

        void c(List list);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class e {

        /* renamed from: a  reason: collision with root package name */
        private final List f3879a = new ArrayList();

        /* renamed from: b  reason: collision with root package name */
        private int f3880b = 1;

        /* renamed from: c  reason: collision with root package name */
        private long f3881c;

        private r6.v a(byte[] bArr) {
            s0.a.g(this.f3880b == 3);
            if (bArr.length <= 0 || bArr[bArr.length - 1] != 10) {
                throw new IllegalArgumentException("Message body is empty or does not end with a LF.");
            }
            this.f3879a.add((bArr.length <= 1 || bArr[bArr.length + (-2)] != 13) ? new String(bArr, 0, bArr.length - 1, s.f3871m) : new String(bArr, 0, bArr.length - 2, s.f3871m));
            r6.v u9 = r6.v.u(this.f3879a);
            e();
            return u9;
        }

        private r6.v b(byte[] bArr) {
            s0.a.a(bArr.length >= 2 && bArr[bArr.length - 2] == 13 && bArr[bArr.length - 1] == 10);
            String str = new String(bArr, 0, bArr.length - 2, s.f3871m);
            this.f3879a.add(str);
            int i10 = this.f3880b;
            if (i10 == 1) {
                if (u.f(str)) {
                    this.f3880b = 2;
                    return null;
                }
                return null;
            } else if (i10 == 2) {
                long g10 = u.g(str);
                if (g10 != -1) {
                    this.f3881c = g10;
                }
                if (str.isEmpty()) {
                    if (this.f3881c > 0) {
                        this.f3880b = 3;
                        return null;
                    }
                    r6.v u9 = r6.v.u(this.f3879a);
                    e();
                    return u9;
                }
                return null;
            } else {
                throw new IllegalStateException();
            }
        }

        private static byte[] d(byte b10, DataInputStream dataInputStream) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] bArr = {b10, dataInputStream.readByte()};
            byteArrayOutputStream.write(bArr);
            while (true) {
                if (bArr[0] == 13 && bArr[1] == 10) {
                    return byteArrayOutputStream.toByteArray();
                }
                bArr[0] = bArr[1];
                byte readByte = dataInputStream.readByte();
                bArr[1] = readByte;
                byteArrayOutputStream.write(readByte);
            }
        }

        private void e() {
            this.f3879a.clear();
            this.f3880b = 1;
            this.f3881c = 0L;
        }

        public r6.v c(byte b10, DataInputStream dataInputStream) {
            r6.v b11 = b(d(b10, dataInputStream));
            while (b11 == null) {
                if (this.f3880b == 3) {
                    long j10 = this.f3881c;
                    if (j10 <= 0) {
                        throw new IllegalStateException("Expects a greater than zero Content-Length.");
                    }
                    int d10 = u6.g.d(j10);
                    s0.a.g(d10 != -1);
                    byte[] bArr = new byte[d10];
                    dataInputStream.readFully(bArr, 0, d10);
                    b11 = a(bArr);
                } else {
                    b11 = b(d(dataInputStream.readByte(), dataInputStream));
                }
            }
            return b11;
        }
    }

    /* loaded from: classes.dex */
    private final class f implements n.e {

        /* renamed from: a  reason: collision with root package name */
        private final DataInputStream f3882a;

        /* renamed from: b  reason: collision with root package name */
        private final e f3883b = new e();

        /* renamed from: c  reason: collision with root package name */
        private volatile boolean f3884c;

        public f(InputStream inputStream) {
            this.f3882a = new DataInputStream(inputStream);
        }

        private void a() {
            int readUnsignedByte = this.f3882a.readUnsignedByte();
            int readUnsignedShort = this.f3882a.readUnsignedShort();
            byte[] bArr = new byte[readUnsignedShort];
            this.f3882a.readFully(bArr, 0, readUnsignedShort);
            b bVar = (b) s.this.f3874i.get(Integer.valueOf(readUnsignedByte));
            if (bVar == null || s.this.f3877l) {
                return;
            }
            bVar.f(bArr);
        }

        private void d(byte b10) {
            if (s.this.f3877l) {
                return;
            }
            s.this.f3872g.c(this.f3883b.c(b10, this.f3882a));
        }

        @Override // q1.n.e
        public void b() {
            while (!this.f3884c) {
                byte readByte = this.f3882a.readByte();
                if (readByte == 36) {
                    a();
                } else {
                    d(readByte);
                }
            }
        }

        @Override // q1.n.e
        public void c() {
            this.f3884c = true;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class g implements Closeable {

        /* renamed from: g  reason: collision with root package name */
        private final OutputStream f3886g;

        /* renamed from: h  reason: collision with root package name */
        private final HandlerThread f3887h;

        /* renamed from: i  reason: collision with root package name */
        private final Handler f3888i;

        public g(OutputStream outputStream) {
            this.f3886g = outputStream;
            HandlerThread handlerThread = new HandlerThread("ExoPlayer:RtspMessageChannel:Sender");
            this.f3887h = handlerThread;
            handlerThread.start();
            this.f3888i = new Handler(handlerThread.getLooper());
        }

        /* JADX INFO: Access modifiers changed from: private */
        public /* synthetic */ void b(byte[] bArr, List list) {
            try {
                this.f3886g.write(bArr);
            } catch (Exception e10) {
                if (s.this.f3877l) {
                    return;
                }
                s.this.f3872g.b(list, e10);
            }
        }

        public void c(final List list) {
            final byte[] b10 = u.b(list);
            this.f3888i.post(new Runnable() { // from class: androidx.media3.exoplayer.rtsp.t
                @Override // java.lang.Runnable
                public final void run() {
                    s.g.this.b(b10, list);
                }
            });
        }

        @Override // java.io.Closeable, java.lang.AutoCloseable
        public void close() {
            Handler handler = this.f3888i;
            final HandlerThread handlerThread = this.f3887h;
            Objects.requireNonNull(handlerThread);
            handler.post(new Runnable() { // from class: i1.e
                @Override // java.lang.Runnable
                public final void run() {
                    handlerThread.quit();
                }
            });
            try {
                this.f3887h.join();
            } catch (InterruptedException unused) {
                this.f3887h.interrupt();
            }
        }
    }

    public s(d dVar) {
        this.f3872g = dVar;
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable
    public void close() {
        if (this.f3877l) {
            return;
        }
        try {
            g gVar = this.f3875j;
            if (gVar != null) {
                gVar.close();
            }
            this.f3873h.l();
            Socket socket = this.f3876k;
            if (socket != null) {
                socket.close();
            }
        } finally {
            this.f3877l = true;
        }
    }

    public void g(Socket socket) {
        this.f3876k = socket;
        this.f3875j = new g(socket.getOutputStream());
        this.f3873h.n(new f(socket.getInputStream()), new c(), 0);
    }

    public void k(int i10, b bVar) {
        this.f3874i.put(Integer.valueOf(i10), bVar);
    }

    public void m(List list) {
        s0.a.i(this.f3875j);
        this.f3875j.c(list);
    }
}
