package androidx.media3.exoplayer.rtsp;

import android.net.Uri;
import android.os.Handler;
import android.util.SparseArray;
import androidx.media3.exoplayer.rtsp.RtspMediaSource;
import androidx.media3.exoplayer.rtsp.j;
import androidx.media3.exoplayer.rtsp.m;
import androidx.media3.exoplayer.rtsp.n;
import androidx.media3.exoplayer.rtsp.s;
import androidx.media3.exoplayer.rtsp.u;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import r6.v;
import s0.j0;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public final class j implements Closeable {

    /* renamed from: g  reason: collision with root package name */
    private final f f3794g;

    /* renamed from: h  reason: collision with root package name */
    private final e f3795h;

    /* renamed from: i  reason: collision with root package name */
    private final String f3796i;

    /* renamed from: j  reason: collision with root package name */
    private final SocketFactory f3797j;

    /* renamed from: k  reason: collision with root package name */
    private final boolean f3798k;

    /* renamed from: o  reason: collision with root package name */
    private Uri f3802o;

    /* renamed from: q  reason: collision with root package name */
    private u.a f3804q;

    /* renamed from: r  reason: collision with root package name */
    private String f3805r;

    /* renamed from: t  reason: collision with root package name */
    private b f3807t;

    /* renamed from: u  reason: collision with root package name */
    private i f3808u;

    /* renamed from: w  reason: collision with root package name */
    private boolean f3810w;

    /* renamed from: x  reason: collision with root package name */
    private boolean f3811x;

    /* renamed from: y  reason: collision with root package name */
    private boolean f3812y;

    /* renamed from: l  reason: collision with root package name */
    private final ArrayDeque f3799l = new ArrayDeque();

    /* renamed from: m  reason: collision with root package name */
    private final SparseArray f3800m = new SparseArray();

    /* renamed from: n  reason: collision with root package name */
    private final d f3801n = new d();

    /* renamed from: p  reason: collision with root package name */
    private s f3803p = new s(new c());

    /* renamed from: s  reason: collision with root package name */
    private long f3806s = 60000;

    /* renamed from: z  reason: collision with root package name */
    private long f3813z = -9223372036854775807L;

    /* renamed from: v  reason: collision with root package name */
    private int f3809v = -1;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class b implements Runnable, Closeable {

        /* renamed from: g  reason: collision with root package name */
        private final Handler f3814g = j0.A();

        /* renamed from: h  reason: collision with root package name */
        private final long f3815h;

        /* renamed from: i  reason: collision with root package name */
        private boolean f3816i;

        public b(long j10) {
            this.f3815h = j10;
        }

        public void a() {
            if (this.f3816i) {
                return;
            }
            this.f3816i = true;
            this.f3814g.postDelayed(this, this.f3815h);
        }

        @Override // java.io.Closeable, java.lang.AutoCloseable
        public void close() {
            this.f3816i = false;
            this.f3814g.removeCallbacks(this);
        }

        @Override // java.lang.Runnable
        public void run() {
            j.this.f3801n.e(j.this.f3802o, j.this.f3805r);
            this.f3814g.postDelayed(this, this.f3815h);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class c implements s.d {

        /* renamed from: a  reason: collision with root package name */
        private final Handler f3818a = j0.A();

        public c() {
        }

        /* JADX INFO: Access modifiers changed from: private */
        /* renamed from: e */
        public void h(List list) {
            j.this.h0(list);
            if (u.e(list)) {
                g(list);
            } else {
                f(list);
            }
        }

        private void f(List list) {
            j.this.f3801n.d(Integer.parseInt((String) s0.a.e(u.k(list).f3912c.d("CSeq"))));
        }

        private void g(List list) {
            r6.v y9;
            y l10 = u.l(list);
            int parseInt = Integer.parseInt((String) s0.a.e(l10.f3915b.d("CSeq")));
            x xVar = (x) j.this.f3800m.get(parseInt);
            if (xVar == null) {
                return;
            }
            j.this.f3800m.remove(parseInt);
            int i10 = xVar.f3911b;
            try {
                try {
                    int i11 = l10.f3914a;
                    if (i11 == 200) {
                        switch (i10) {
                            case 1:
                            case 3:
                            case 7:
                            case 8:
                            case 9:
                            case 11:
                            case 12:
                                return;
                            case 2:
                                i(new l(l10.f3915b, i11, d0.b(l10.f3916c)));
                                return;
                            case 4:
                                j(new v(i11, u.j(l10.f3915b.d("Public"))));
                                return;
                            case 5:
                                k();
                                return;
                            case 6:
                                String d10 = l10.f3915b.d("Range");
                                z d11 = d10 == null ? z.f3917c : z.d(d10);
                                try {
                                    String d12 = l10.f3915b.d("RTP-Info");
                                    y9 = d12 == null ? r6.v.y() : b0.a(d12, j.this.f3802o);
                                } catch (p0.z unused) {
                                    y9 = r6.v.y();
                                }
                                l(new w(l10.f3914a, d11, y9));
                                return;
                            case 10:
                                String d13 = l10.f3915b.d("Session");
                                String d14 = l10.f3915b.d("Transport");
                                if (d13 == null || d14 == null) {
                                    throw p0.z.c("Missing mandatory session or transport header", null);
                                }
                                m(new a0(l10.f3914a, u.m(d13), d14));
                                return;
                            default:
                                throw new IllegalStateException();
                        }
                    }
                    if (i11 == 401) {
                        if (j.this.f3804q == null || j.this.f3811x) {
                            j.this.e0(new RtspMediaSource.c(u.t(i10) + " " + l10.f3914a));
                            return;
                        }
                        r6.v e10 = l10.f3915b.e("WWW-Authenticate");
                        if (e10.isEmpty()) {
                            throw p0.z.c("Missing WWW-Authenticate header in a 401 response.", null);
                        }
                        for (int i12 = 0; i12 < e10.size(); i12++) {
                            j.this.f3808u = u.o((String) e10.get(i12));
                            if (j.this.f3808u.f3790a == 2) {
                                break;
                            }
                        }
                        j.this.f3801n.b();
                        j.this.f3811x = true;
                    } else if (i11 == 461) {
                        String str = u.t(i10) + " " + l10.f3914a;
                        j.this.e0((i10 != 10 || ((String) s0.a.e(xVar.f3912c.d("Transport"))).contains("TCP")) ? new RtspMediaSource.c(str) : new RtspMediaSource.d(str));
                    } else if (i11 == 301 || i11 == 302) {
                        if (j.this.f3809v != -1) {
                            j.this.f3809v = 0;
                        }
                        String d15 = l10.f3915b.d("Location");
                        if (d15 == null) {
                            j.this.f3794g.a("Redirection without new location.", null);
                            return;
                        }
                        Uri parse = Uri.parse(d15);
                        j.this.f3802o = u.p(parse);
                        j.this.f3804q = u.n(parse);
                        j.this.f3801n.c(j.this.f3802o, j.this.f3805r);
                    } else {
                        j.this.e0(new RtspMediaSource.c(u.t(i10) + " " + l10.f3914a));
                    }
                } catch (IllegalArgumentException e11) {
                    e = e11;
                    j.this.e0(new RtspMediaSource.c(e));
                }
            } catch (p0.z e12) {
                e = e12;
                j.this.e0(new RtspMediaSource.c(e));
            }
        }

        private void i(l lVar) {
            z zVar = z.f3917c;
            String str = (String) lVar.f3827c.f3718a.get("range");
            if (str != null) {
                try {
                    zVar = z.d(str);
                } catch (p0.z e10) {
                    j.this.f3794g.a("SDP format error.", e10);
                    return;
                }
            }
            r6.v c02 = j.c0(lVar, j.this.f3802o);
            if (c02.isEmpty()) {
                j.this.f3794g.a("No playable track.", null);
                return;
            }
            j.this.f3794g.b(zVar, c02);
            j.this.f3810w = true;
        }

        private void j(v vVar) {
            if (j.this.f3807t != null) {
                return;
            }
            if (j.l0(vVar.f3906b)) {
                j.this.f3801n.c(j.this.f3802o, j.this.f3805r);
            } else {
                j.this.f3794g.a("DESCRIBE not supported.", null);
            }
        }

        private void k() {
            s0.a.g(j.this.f3809v == 2);
            j.this.f3809v = 1;
            j.this.f3812y = false;
            if (j.this.f3813z != -9223372036854775807L) {
                j jVar = j.this;
                jVar.p0(j0.l1(jVar.f3813z));
            }
        }

        private void l(w wVar) {
            boolean z9 = true;
            if (j.this.f3809v != 1 && j.this.f3809v != 2) {
                z9 = false;
            }
            s0.a.g(z9);
            j.this.f3809v = 2;
            if (j.this.f3807t == null) {
                j jVar = j.this;
                jVar.f3807t = new b(jVar.f3806s / 2);
                j.this.f3807t.a();
            }
            j.this.f3813z = -9223372036854775807L;
            j.this.f3795h.d(j0.K0(wVar.f3908b.f3919a), wVar.f3909c);
        }

        private void m(a0 a0Var) {
            s0.a.g(j.this.f3809v != -1);
            j.this.f3809v = 1;
            j.this.f3805r = a0Var.f3710b.f3903a;
            j.this.f3806s = a0Var.f3710b.f3904b;
            j.this.d0();
        }

        @Override // androidx.media3.exoplayer.rtsp.s.d
        public /* synthetic */ void a(Exception exc) {
            i1.d.a(this, exc);
        }

        @Override // androidx.media3.exoplayer.rtsp.s.d
        public /* synthetic */ void b(List list, Exception exc) {
            i1.d.b(this, list, exc);
        }

        @Override // androidx.media3.exoplayer.rtsp.s.d
        public void c(final List list) {
            this.f3818a.post(new Runnable() { // from class: androidx.media3.exoplayer.rtsp.k
                @Override // java.lang.Runnable
                public final void run() {
                    j.c.this.h(list);
                }
            });
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class d {

        /* renamed from: a  reason: collision with root package name */
        private int f3820a;

        /* renamed from: b  reason: collision with root package name */
        private x f3821b;

        private d() {
        }

        private x a(int i10, String str, Map map, Uri uri) {
            String str2 = j.this.f3796i;
            int i11 = this.f3820a;
            this.f3820a = i11 + 1;
            m.b bVar = new m.b(str2, str, i11);
            if (j.this.f3808u != null) {
                s0.a.i(j.this.f3804q);
                try {
                    bVar.b("Authorization", j.this.f3808u.a(j.this.f3804q, uri, i10));
                } catch (p0.z e10) {
                    j.this.e0(new RtspMediaSource.c(e10));
                }
            }
            bVar.d(map);
            return new x(uri, i10, bVar.e(), "");
        }

        private void h(x xVar) {
            int parseInt = Integer.parseInt((String) s0.a.e(xVar.f3912c.d("CSeq")));
            s0.a.g(j.this.f3800m.get(parseInt) == null);
            j.this.f3800m.append(parseInt, xVar);
            r6.v q10 = u.q(xVar);
            j.this.h0(q10);
            j.this.f3803p.m(q10);
            this.f3821b = xVar;
        }

        private void i(y yVar) {
            r6.v r10 = u.r(yVar);
            j.this.h0(r10);
            j.this.f3803p.m(r10);
        }

        public void b() {
            s0.a.i(this.f3821b);
            r6.w b10 = this.f3821b.f3912c.b();
            HashMap hashMap = new HashMap();
            for (String str : b10.keySet()) {
                if (!str.equals("CSeq") && !str.equals("User-Agent") && !str.equals("Session") && !str.equals("Authorization")) {
                    hashMap.put(str, (String) r6.a0.d(b10.get(str)));
                }
            }
            h(a(this.f3821b.f3911b, j.this.f3805r, hashMap, this.f3821b.f3910a));
        }

        public void c(Uri uri, String str) {
            h(a(2, str, r6.x.j(), uri));
        }

        public void d(int i10) {
            i(new y(405, new m.b(j.this.f3796i, j.this.f3805r, i10).e()));
            this.f3820a = Math.max(this.f3820a, i10 + 1);
        }

        public void e(Uri uri, String str) {
            h(a(4, str, r6.x.j(), uri));
        }

        public void f(Uri uri, String str) {
            s0.a.g(j.this.f3809v == 2);
            h(a(5, str, r6.x.j(), uri));
            j.this.f3812y = true;
        }

        public void g(Uri uri, long j10, String str) {
            boolean z9 = true;
            if (j.this.f3809v != 1 && j.this.f3809v != 2) {
                z9 = false;
            }
            s0.a.g(z9);
            h(a(6, str, r6.x.k("Range", z.b(j10)), uri));
        }

        public void j(Uri uri, String str, String str2) {
            j.this.f3809v = 0;
            h(a(10, str2, r6.x.k("Transport", str), uri));
        }

        public void k(Uri uri, String str) {
            if (j.this.f3809v == -1 || j.this.f3809v == 0) {
                return;
            }
            j.this.f3809v = 0;
            h(a(12, str, r6.x.j(), uri));
        }
    }

    /* loaded from: classes.dex */
    public interface e {
        void c();

        void d(long j10, r6.v vVar);

        void e(RtspMediaSource.c cVar);
    }

    /* loaded from: classes.dex */
    public interface f {
        void a(String str, Throwable th);

        void b(z zVar, r6.v vVar);
    }

    public j(f fVar, e eVar, String str, Uri uri, SocketFactory socketFactory, boolean z9) {
        this.f3794g = fVar;
        this.f3795h = eVar;
        this.f3796i = str;
        this.f3797j = socketFactory;
        this.f3798k = z9;
        this.f3802o = u.p(uri);
        this.f3804q = u.n(uri);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static r6.v c0(l lVar, Uri uri) {
        v.a aVar = new v.a();
        for (int i10 = 0; i10 < lVar.f3827c.f3719b.size(); i10++) {
            androidx.media3.exoplayer.rtsp.a aVar2 = (androidx.media3.exoplayer.rtsp.a) lVar.f3827c.f3719b.get(i10);
            if (h.c(aVar2)) {
                aVar.a(new r(lVar.f3825a, aVar2, uri));
            }
        }
        return aVar.k();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void d0() {
        n.e eVar = (n.e) this.f3799l.pollFirst();
        if (eVar == null) {
            this.f3795h.c();
        } else {
            this.f3801n.j(eVar.c(), eVar.d(), this.f3805r);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void e0(Throwable th) {
        RtspMediaSource.c cVar = th instanceof RtspMediaSource.c ? (RtspMediaSource.c) th : new RtspMediaSource.c(th);
        if (this.f3810w) {
            this.f3795h.e(cVar);
        } else {
            this.f3794g.a(q6.q.c(th.getMessage()), th);
        }
    }

    private Socket f0(Uri uri) {
        s0.a.a(uri.getHost() != null);
        return this.f3797j.createSocket((String) s0.a.e(uri.getHost()), uri.getPort() > 0 ? uri.getPort() : 554);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void h0(List list) {
        if (this.f3798k) {
            s0.o.b("RtspClient", q6.g.g("\n").d(list));
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static boolean l0(List list) {
        return list.isEmpty() || list.contains(2);
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable
    public void close() {
        b bVar = this.f3807t;
        if (bVar != null) {
            bVar.close();
            this.f3807t = null;
            this.f3801n.k(this.f3802o, (String) s0.a.e(this.f3805r));
        }
        this.f3803p.close();
    }

    public int g0() {
        return this.f3809v;
    }

    public void i0(int i10, s.b bVar) {
        this.f3803p.k(i10, bVar);
    }

    public void j0() {
        try {
            close();
            s sVar = new s(new c());
            this.f3803p = sVar;
            sVar.g(f0(this.f3802o));
            this.f3805r = null;
            this.f3811x = false;
            this.f3808u = null;
        } catch (IOException e10) {
            this.f3795h.e(new RtspMediaSource.c(e10));
        }
    }

    public void k0(long j10) {
        if (this.f3809v == 2 && !this.f3812y) {
            this.f3801n.f(this.f3802o, (String) s0.a.e(this.f3805r));
        }
        this.f3813z = j10;
    }

    public void m0(List list) {
        this.f3799l.addAll(list);
        d0();
    }

    public void n0() {
        this.f3809v = 1;
    }

    public void o0() {
        try {
            this.f3803p.g(f0(this.f3802o));
            this.f3801n.e(this.f3802o, this.f3805r);
        } catch (IOException e10) {
            j0.m(this.f3803p);
            throw e10;
        }
    }

    public void p0(long j10) {
        this.f3801n.g(this.f3802o, j10, (String) s0.a.e(this.f3805r));
    }
}
