package androidx.media3.exoplayer.hls;

import android.net.Uri;
import android.os.Handler;
import android.util.SparseIntArray;
import androidx.media3.exoplayer.hls.c;
import androidx.media3.exoplayer.hls.l;
import b1.v;
import b1.x;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import m1.a1;
import m1.b0;
import m1.b1;
import m1.c1;
import m1.l1;
import m1.m0;
import p0.p;
import p0.w;
import p0.y;
import p0.z;
import p1.r;
import q1.m;
import q1.n;
import r6.a0;
import r6.v;
import s0.j0;
import s0.o;
import u1.r0;
import u1.s0;
import u1.t;
import w0.o1;
import w0.t2;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public final class l implements n.b, n.f, c1, t, a1.d {

    /* renamed from: e0  reason: collision with root package name */
    private static final Set f3636e0 = Collections.unmodifiableSet(new HashSet(Arrays.asList(1, 2, 5)));
    private n1.e A;
    private d[] B;
    private Set D;
    private SparseIntArray E;
    private s0 F;
    private int G;
    private int H;
    private boolean I;
    private boolean J;
    private int K;
    private p L;
    private p M;
    private boolean N;
    private l1 O;
    private Set P;
    private int[] Q;
    private int R;
    private boolean S;
    private boolean[] T;
    private boolean[] U;
    private long V;
    private long W;
    private boolean X;
    private boolean Y;
    private boolean Z;

    /* renamed from: a0  reason: collision with root package name */
    private boolean f3637a0;

    /* renamed from: b0  reason: collision with root package name */
    private long f3638b0;

    /* renamed from: c0  reason: collision with root package name */
    private p0.l f3639c0;

    /* renamed from: d0  reason: collision with root package name */
    private e f3640d0;

    /* renamed from: g  reason: collision with root package name */
    private final String f3641g;

    /* renamed from: h  reason: collision with root package name */
    private final int f3642h;

    /* renamed from: i  reason: collision with root package name */
    private final b f3643i;

    /* renamed from: j  reason: collision with root package name */
    private final androidx.media3.exoplayer.hls.c f3644j;

    /* renamed from: k  reason: collision with root package name */
    private final q1.b f3645k;

    /* renamed from: l  reason: collision with root package name */
    private final p f3646l;

    /* renamed from: m  reason: collision with root package name */
    private final x f3647m;

    /* renamed from: n  reason: collision with root package name */
    private final v.a f3648n;

    /* renamed from: o  reason: collision with root package name */
    private final m f3649o;

    /* renamed from: q  reason: collision with root package name */
    private final m0.a f3651q;

    /* renamed from: r  reason: collision with root package name */
    private final int f3652r;

    /* renamed from: t  reason: collision with root package name */
    private final ArrayList f3654t;

    /* renamed from: u  reason: collision with root package name */
    private final List f3655u;

    /* renamed from: v  reason: collision with root package name */
    private final Runnable f3656v;

    /* renamed from: w  reason: collision with root package name */
    private final Runnable f3657w;

    /* renamed from: x  reason: collision with root package name */
    private final Handler f3658x;

    /* renamed from: y  reason: collision with root package name */
    private final ArrayList f3659y;

    /* renamed from: z  reason: collision with root package name */
    private final Map f3660z;

    /* renamed from: p  reason: collision with root package name */
    private final n f3650p = new n("Loader:HlsSampleStreamWrapper");

    /* renamed from: s  reason: collision with root package name */
    private final c.b f3653s = new c.b();
    private int[] C = new int[0];

    /* loaded from: classes.dex */
    public interface b extends c1.a {
        void e();

        void m(Uri uri);
    }

    /* loaded from: classes.dex */
    private static class c implements s0 {

        /* renamed from: g  reason: collision with root package name */
        private static final p f3661g = new p.b().o0("application/id3").K();

        /* renamed from: h  reason: collision with root package name */
        private static final p f3662h = new p.b().o0("application/x-emsg").K();

        /* renamed from: a  reason: collision with root package name */
        private final f2.b f3663a = new f2.b();

        /* renamed from: b  reason: collision with root package name */
        private final s0 f3664b;

        /* renamed from: c  reason: collision with root package name */
        private final p f3665c;

        /* renamed from: d  reason: collision with root package name */
        private p f3666d;

        /* renamed from: e  reason: collision with root package name */
        private byte[] f3667e;

        /* renamed from: f  reason: collision with root package name */
        private int f3668f;

        public c(s0 s0Var, int i10) {
            p pVar;
            this.f3664b = s0Var;
            if (i10 == 1) {
                pVar = f3661g;
            } else if (i10 != 3) {
                throw new IllegalArgumentException("Unknown metadataType: " + i10);
            } else {
                pVar = f3662h;
            }
            this.f3665c = pVar;
            this.f3667e = new byte[0];
            this.f3668f = 0;
        }

        private boolean g(f2.a aVar) {
            p h10 = aVar.h();
            return h10 != null && j0.c(this.f3665c.f11208n, h10.f11208n);
        }

        private void h(int i10) {
            byte[] bArr = this.f3667e;
            if (bArr.length < i10) {
                this.f3667e = Arrays.copyOf(bArr, i10 + (i10 / 2));
            }
        }

        private s0.x i(int i10, int i11) {
            int i12 = this.f3668f - i11;
            s0.x xVar = new s0.x(Arrays.copyOfRange(this.f3667e, i12 - i10, i12));
            byte[] bArr = this.f3667e;
            System.arraycopy(bArr, i12, bArr, 0, i11);
            this.f3668f = i11;
            return xVar;
        }

        @Override // u1.s0
        public void a(long j10, int i10, int i11, int i12, s0.a aVar) {
            s0.a.e(this.f3666d);
            s0.x i13 = i(i11, i12);
            if (!j0.c(this.f3666d.f11208n, this.f3665c.f11208n)) {
                if (!"application/x-emsg".equals(this.f3666d.f11208n)) {
                    o.h("HlsSampleStreamWrapper", "Ignoring sample for unsupported format: " + this.f3666d.f11208n);
                    return;
                }
                f2.a c10 = this.f3663a.c(i13);
                if (!g(c10)) {
                    o.h("HlsSampleStreamWrapper", String.format("Ignoring EMSG. Expected it to contain wrapped %s but actual wrapped format: %s", this.f3665c.f11208n, c10.h()));
                    return;
                }
                i13 = new s0.x((byte[]) s0.a.e(c10.q()));
            }
            int a10 = i13.a();
            this.f3664b.e(i13, a10);
            this.f3664b.a(j10, i10, a10, 0, aVar);
        }

        @Override // u1.s0
        public void b(p pVar) {
            this.f3666d = pVar;
            this.f3664b.b(this.f3665c);
        }

        @Override // u1.s0
        public void c(s0.x xVar, int i10, int i11) {
            h(this.f3668f + i10);
            xVar.l(this.f3667e, this.f3668f, i10);
            this.f3668f += i10;
        }

        @Override // u1.s0
        public /* synthetic */ int d(p0.h hVar, int i10, boolean z9) {
            return r0.a(this, hVar, i10, z9);
        }

        @Override // u1.s0
        public /* synthetic */ void e(s0.x xVar, int i10) {
            r0.b(this, xVar, i10);
        }

        @Override // u1.s0
        public int f(p0.h hVar, int i10, boolean z9, int i11) {
            h(this.f3668f + i10);
            int read = hVar.read(this.f3667e, this.f3668f, i10);
            if (read != -1) {
                this.f3668f += read;
                return read;
            } else if (z9) {
                return -1;
            } else {
                throw new EOFException();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class d extends a1 {
        private final Map H;
        private p0.l I;

        private d(q1.b bVar, x xVar, v.a aVar, Map map) {
            super(bVar, xVar, aVar);
            this.H = map;
        }

        private w i0(w wVar) {
            if (wVar == null) {
                return null;
            }
            int f10 = wVar.f();
            int i10 = 0;
            int i11 = 0;
            while (true) {
                if (i11 >= f10) {
                    i11 = -1;
                    break;
                }
                w.b e10 = wVar.e(i11);
                if ((e10 instanceof i2.m) && "com.apple.streaming.transportStreamTimestamp".equals(((i2.m) e10).f8281h)) {
                    break;
                }
                i11++;
            }
            if (i11 == -1) {
                return wVar;
            }
            if (f10 == 1) {
                return null;
            }
            w.b[] bVarArr = new w.b[f10 - 1];
            while (i10 < f10) {
                if (i10 != i11) {
                    bVarArr[i10 < i11 ? i10 : i10 - 1] = wVar.e(i10);
                }
                i10++;
            }
            return new w(bVarArr);
        }

        @Override // m1.a1, u1.s0
        public void a(long j10, int i10, int i11, int i12, s0.a aVar) {
            super.a(j10, i10, i11, i12, aVar);
        }

        public void j0(p0.l lVar) {
            this.I = lVar;
            J();
        }

        public void k0(e eVar) {
            g0(eVar.f3592k);
        }

        @Override // m1.a1
        public p x(p pVar) {
            p0.l lVar;
            p0.l lVar2 = this.I;
            if (lVar2 == null) {
                lVar2 = pVar.f11212r;
            }
            if (lVar2 != null && (lVar = (p0.l) this.H.get(lVar2.f11152i)) != null) {
                lVar2 = lVar;
            }
            w i02 = i0(pVar.f11205k);
            if (lVar2 != pVar.f11212r || i02 != pVar.f11205k) {
                pVar = pVar.a().U(lVar2).h0(i02).K();
            }
            return super.x(pVar);
        }
    }

    public l(String str, int i10, b bVar, androidx.media3.exoplayer.hls.c cVar, Map map, q1.b bVar2, long j10, p pVar, x xVar, v.a aVar, m mVar, m0.a aVar2, int i11) {
        this.f3641g = str;
        this.f3642h = i10;
        this.f3643i = bVar;
        this.f3644j = cVar;
        this.f3660z = map;
        this.f3645k = bVar2;
        this.f3646l = pVar;
        this.f3647m = xVar;
        this.f3648n = aVar;
        this.f3649o = mVar;
        this.f3651q = aVar2;
        this.f3652r = i11;
        Set set = f3636e0;
        this.D = new HashSet(set.size());
        this.E = new SparseIntArray(set.size());
        this.B = new d[0];
        this.U = new boolean[0];
        this.T = new boolean[0];
        ArrayList arrayList = new ArrayList();
        this.f3654t = arrayList;
        this.f3655u = Collections.unmodifiableList(arrayList);
        this.f3659y = new ArrayList();
        this.f3656v = new Runnable() { // from class: androidx.media3.exoplayer.hls.j
            @Override // java.lang.Runnable
            public final void run() {
                l.this.V();
            }
        };
        this.f3657w = new Runnable() { // from class: androidx.media3.exoplayer.hls.k
            @Override // java.lang.Runnable
            public final void run() {
                l.this.e0();
            }
        };
        this.f3658x = j0.A();
        this.V = j10;
        this.W = j10;
    }

    private void A() {
        p pVar;
        int length = this.B.length;
        int i10 = 0;
        int i11 = -2;
        int i12 = -1;
        while (true) {
            if (i10 >= length) {
                break;
            }
            String str = ((p) s0.a.i(this.B[i10].G())).f11208n;
            int i13 = y.s(str) ? 2 : y.o(str) ? 1 : y.r(str) ? 3 : -2;
            if (N(i13) > N(i11)) {
                i12 = i10;
                i11 = i13;
            } else if (i13 == i11 && i12 != -1) {
                i12 = -1;
            }
            i10++;
        }
        p0.j0 k10 = this.f3644j.k();
        int i14 = k10.f11061a;
        this.R = -1;
        this.Q = new int[length];
        for (int i15 = 0; i15 < length; i15++) {
            this.Q[i15] = i15;
        }
        p0.j0[] j0VarArr = new p0.j0[length];
        int i16 = 0;
        while (i16 < length) {
            p pVar2 = (p) s0.a.i(this.B[i16].G());
            if (i16 == i12) {
                p[] pVarArr = new p[i14];
                for (int i17 = 0; i17 < i14; i17++) {
                    p a10 = k10.a(i17);
                    if (i11 == 1 && (pVar = this.f3646l) != null) {
                        a10 = a10.h(pVar);
                    }
                    pVarArr[i17] = i14 == 1 ? pVar2.h(a10) : G(a10, pVar2, true);
                }
                j0VarArr[i16] = new p0.j0(this.f3641g, pVarArr);
                this.R = i16;
            } else {
                p pVar3 = (i11 == 2 && y.o(pVar2.f11208n)) ? this.f3646l : null;
                StringBuilder sb = new StringBuilder();
                sb.append(this.f3641g);
                sb.append(":muxed:");
                sb.append(i16 < i12 ? i16 : i16 - 1);
                j0VarArr[i16] = new p0.j0(sb.toString(), G(pVar3, pVar2, false));
            }
            i16++;
        }
        this.O = F(j0VarArr);
        s0.a.g(this.P == null);
        this.P = Collections.emptySet();
    }

    private boolean B(int i10) {
        for (int i11 = i10; i11 < this.f3654t.size(); i11++) {
            if (((e) this.f3654t.get(i11)).f3595n) {
                return false;
            }
        }
        e eVar = (e) this.f3654t.get(i10);
        for (int i12 = 0; i12 < this.B.length; i12++) {
            if (this.B[i12].D() > eVar.m(i12)) {
                return false;
            }
        }
        return true;
    }

    private static u1.n D(int i10, int i11) {
        o.h("HlsSampleStreamWrapper", "Unmapped track with id " + i10 + " of type " + i11);
        return new u1.n();
    }

    private a1 E(int i10, int i11) {
        int length = this.B.length;
        boolean z9 = true;
        if (i11 != 1 && i11 != 2) {
            z9 = false;
        }
        d dVar = new d(this.f3645k, this.f3647m, this.f3648n, this.f3660z);
        dVar.c0(this.V);
        if (z9) {
            dVar.j0(this.f3639c0);
        }
        dVar.b0(this.f3638b0);
        e eVar = this.f3640d0;
        if (eVar != null) {
            dVar.k0(eVar);
        }
        dVar.e0(this);
        int i12 = length + 1;
        int[] copyOf = Arrays.copyOf(this.C, i12);
        this.C = copyOf;
        copyOf[length] = i10;
        this.B = (d[]) j0.N0(this.B, dVar);
        boolean[] copyOf2 = Arrays.copyOf(this.U, i12);
        this.U = copyOf2;
        copyOf2[length] = z9;
        this.S |= z9;
        this.D.add(Integer.valueOf(i11));
        this.E.append(i11, length);
        if (N(i11) > N(this.G)) {
            this.H = length;
            this.G = i11;
        }
        this.T = Arrays.copyOf(this.T, i12);
        return dVar;
    }

    private l1 F(p0.j0[] j0VarArr) {
        for (int i10 = 0; i10 < j0VarArr.length; i10++) {
            p0.j0 j0Var = j0VarArr[i10];
            p[] pVarArr = new p[j0Var.f11061a];
            for (int i11 = 0; i11 < j0Var.f11061a; i11++) {
                p a10 = j0Var.a(i11);
                pVarArr[i11] = a10.b(this.f3647m.b(a10));
            }
            j0VarArr[i10] = new p0.j0(j0Var.f11062b, pVarArr);
        }
        return new l1(j0VarArr);
    }

    private static p G(p pVar, p pVar2, boolean z9) {
        String d10;
        String str;
        if (pVar == null) {
            return pVar2;
        }
        int k10 = y.k(pVar2.f11208n);
        if (j0.R(pVar.f11204j, k10) == 1) {
            d10 = j0.S(pVar.f11204j, k10);
            str = y.g(d10);
        } else {
            d10 = y.d(pVar.f11204j, pVar2.f11208n);
            str = pVar2.f11208n;
        }
        p.b O = pVar2.a().a0(pVar.f11195a).c0(pVar.f11196b).d0(pVar.f11197c).e0(pVar.f11198d).q0(pVar.f11199e).m0(pVar.f11200f).M(z9 ? pVar.f11201g : -1).j0(z9 ? pVar.f11202h : -1).O(d10);
        if (k10 == 2) {
            O.v0(pVar.f11214t).Y(pVar.f11215u).X(pVar.f11216v);
        }
        if (str != null) {
            O.o0(str);
        }
        int i10 = pVar.B;
        if (i10 != -1 && k10 == 1) {
            O.N(i10);
        }
        w wVar = pVar.f11205k;
        if (wVar != null) {
            w wVar2 = pVar2.f11205k;
            if (wVar2 != null) {
                wVar = wVar2.c(wVar);
            }
            O.h0(wVar);
        }
        return O.K();
    }

    private void H(int i10) {
        s0.a.g(!this.f3650p.j());
        while (true) {
            if (i10 >= this.f3654t.size()) {
                i10 = -1;
                break;
            } else if (B(i10)) {
                break;
            } else {
                i10++;
            }
        }
        if (i10 == -1) {
            return;
        }
        long j10 = L().f10265h;
        e I = I(i10);
        if (this.f3654t.isEmpty()) {
            this.W = this.V;
        } else {
            ((e) a0.d(this.f3654t)).o();
        }
        this.Z = false;
        this.f3651q.C(this.G, I.f10264g, j10);
    }

    private e I(int i10) {
        e eVar = (e) this.f3654t.get(i10);
        ArrayList arrayList = this.f3654t;
        j0.V0(arrayList, i10, arrayList.size());
        for (int i11 = 0; i11 < this.B.length; i11++) {
            this.B[i11].u(eVar.m(i11));
        }
        return eVar;
    }

    private boolean J(e eVar) {
        int i10 = eVar.f3592k;
        int length = this.B.length;
        for (int i11 = 0; i11 < length; i11++) {
            if (this.T[i11] && this.B[i11].R() == i10) {
                return false;
            }
        }
        return true;
    }

    private static boolean K(p pVar, p pVar2) {
        String str = pVar.f11208n;
        String str2 = pVar2.f11208n;
        int k10 = y.k(str);
        if (k10 != 3) {
            return k10 == y.k(str2);
        } else if (j0.c(str, str2)) {
            return !("application/cea-608".equals(str) || "application/cea-708".equals(str)) || pVar.G == pVar2.G;
        } else {
            return false;
        }
    }

    private e L() {
        ArrayList arrayList = this.f3654t;
        return (e) arrayList.get(arrayList.size() - 1);
    }

    private s0 M(int i10, int i11) {
        s0.a.a(f3636e0.contains(Integer.valueOf(i11)));
        int i12 = this.E.get(i11, -1);
        if (i12 == -1) {
            return null;
        }
        if (this.D.add(Integer.valueOf(i11))) {
            this.C[i12] = i10;
        }
        return this.C[i12] == i10 ? this.B[i12] : D(i10, i11);
    }

    private static int N(int i10) {
        if (i10 != 1) {
            if (i10 != 2) {
                return i10 != 3 ? 0 : 1;
            }
            return 3;
        }
        return 2;
    }

    private void O(e eVar) {
        d[] dVarArr;
        this.f3640d0 = eVar;
        this.L = eVar.f10261d;
        this.W = -9223372036854775807L;
        this.f3654t.add(eVar);
        v.a r10 = r6.v.r();
        for (d dVar : this.B) {
            r10.a(Integer.valueOf(dVar.H()));
        }
        eVar.n(this, r10.k());
        for (d dVar2 : this.B) {
            dVar2.k0(eVar);
            if (eVar.f3595n) {
                dVar2.h0();
            }
        }
    }

    private static boolean P(n1.e eVar) {
        return eVar instanceof e;
    }

    private boolean Q() {
        return this.W != -9223372036854775807L;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void T(e eVar) {
        this.f3643i.m(eVar.f3594m);
    }

    private void U() {
        int i10 = this.O.f9811a;
        int[] iArr = new int[i10];
        this.Q = iArr;
        Arrays.fill(iArr, -1);
        for (int i11 = 0; i11 < i10; i11++) {
            int i12 = 0;
            while (true) {
                d[] dVarArr = this.B;
                if (i12 >= dVarArr.length) {
                    break;
                } else if (K((p) s0.a.i(dVarArr[i12].G()), this.O.b(i11).a(0))) {
                    this.Q[i11] = i12;
                    break;
                } else {
                    i12++;
                }
            }
        }
        Iterator it = this.f3659y.iterator();
        while (it.hasNext()) {
            ((h) it.next()).a();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void V() {
        if (!this.N && this.Q == null && this.I) {
            for (d dVar : this.B) {
                if (dVar.G() == null) {
                    return;
                }
            }
            if (this.O != null) {
                U();
                return;
            }
            A();
            n0();
            this.f3643i.e();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void e0() {
        this.I = true;
        V();
    }

    private void i0() {
        for (d dVar : this.B) {
            dVar.X(this.X);
        }
        this.X = false;
    }

    private boolean j0(long j10, e eVar) {
        int length = this.B.length;
        for (int i10 = 0; i10 < length; i10++) {
            d dVar = this.B[i10];
            if (!(eVar != null ? dVar.Z(eVar.m(i10)) : dVar.a0(j10, false)) && (this.U[i10] || !this.S)) {
                return false;
            }
        }
        return true;
    }

    private void n0() {
        this.J = true;
    }

    private void s0(b1[] b1VarArr) {
        this.f3659y.clear();
        for (b1 b1Var : b1VarArr) {
            if (b1Var != null) {
                this.f3659y.add((h) b1Var);
            }
        }
    }

    private void y() {
        s0.a.g(this.J);
        s0.a.e(this.O);
        s0.a.e(this.P);
    }

    public void C() {
        if (this.J) {
            return;
        }
        f(new o1.b().f(this.V).d());
    }

    public boolean R(int i10) {
        return !Q() && this.B[i10].L(this.Z);
    }

    public boolean S() {
        return this.G == 2;
    }

    public void W() {
        this.f3650p.e();
        this.f3644j.p();
    }

    public void X(int i10) {
        W();
        this.B[i10].O();
    }

    @Override // q1.n.b
    /* renamed from: Y */
    public void t(n1.e eVar, long j10, long j11, boolean z9) {
        this.A = null;
        m1.y yVar = new m1.y(eVar.f10258a, eVar.f10259b, eVar.f(), eVar.e(), j10, j11, eVar.a());
        this.f3649o.b(eVar.f10258a);
        this.f3651q.q(yVar, eVar.f10260c, this.f3642h, eVar.f10261d, eVar.f10262e, eVar.f10263f, eVar.f10264g, eVar.f10265h);
        if (z9) {
            return;
        }
        if (Q() || this.K == 0) {
            i0();
        }
        if (this.K > 0) {
            this.f3643i.d(this);
        }
    }

    @Override // q1.n.b
    /* renamed from: Z */
    public void p(n1.e eVar, long j10, long j11) {
        this.A = null;
        this.f3644j.r(eVar);
        m1.y yVar = new m1.y(eVar.f10258a, eVar.f10259b, eVar.f(), eVar.e(), j10, j11, eVar.a());
        this.f3649o.b(eVar.f10258a);
        this.f3651q.t(yVar, eVar.f10260c, this.f3642h, eVar.f10261d, eVar.f10262e, eVar.f10263f, eVar.f10264g, eVar.f10265h);
        if (this.J) {
            this.f3643i.d(this);
        } else {
            f(new o1.b().f(this.V).d());
        }
    }

    @Override // m1.c1
    public long a() {
        if (Q()) {
            return this.W;
        }
        if (this.Z) {
            return Long.MIN_VALUE;
        }
        return L().f10265h;
    }

    @Override // q1.n.b
    /* renamed from: a0 */
    public n.c n(n1.e eVar, long j10, long j11, IOException iOException, int i10) {
        n.c h10;
        int i11;
        boolean P = P(eVar);
        if (P && !((e) eVar).q() && (iOException instanceof u0.t) && ((i11 = ((u0.t) iOException).f13587j) == 410 || i11 == 404)) {
            return n.f12129d;
        }
        long a10 = eVar.a();
        m1.y yVar = new m1.y(eVar.f10258a, eVar.f10259b, eVar.f(), eVar.e(), j10, j11, a10);
        m.c cVar = new m.c(yVar, new b0(eVar.f10260c, this.f3642h, eVar.f10261d, eVar.f10262e, eVar.f10263f, j0.l1(eVar.f10264g), j0.l1(eVar.f10265h)), iOException, i10);
        m.b a11 = this.f3649o.a(p1.v.c(this.f3644j.l()), cVar);
        boolean o10 = (a11 == null || a11.f12123a != 2) ? false : this.f3644j.o(eVar, a11.f12124b);
        if (o10) {
            if (P && a10 == 0) {
                ArrayList arrayList = this.f3654t;
                s0.a.g(((e) arrayList.remove(arrayList.size() - 1)) == eVar);
                if (this.f3654t.isEmpty()) {
                    this.W = this.V;
                } else {
                    ((e) a0.d(this.f3654t)).o();
                }
            }
            h10 = n.f12131f;
        } else {
            long c10 = this.f3649o.c(cVar);
            h10 = c10 != -9223372036854775807L ? n.h(false, c10) : n.f12132g;
        }
        n.c cVar2 = h10;
        boolean z9 = !cVar2.c();
        this.f3651q.v(yVar, eVar.f10260c, this.f3642h, eVar.f10261d, eVar.f10262e, eVar.f10263f, eVar.f10264g, eVar.f10265h, iOException, z9);
        if (z9) {
            this.A = null;
            this.f3649o.b(eVar.f10258a);
        }
        if (o10) {
            if (this.J) {
                this.f3643i.d(this);
            } else {
                f(new o1.b().f(this.V).d());
            }
        }
        return cVar2;
    }

    public long b(long j10, t2 t2Var) {
        return this.f3644j.c(j10, t2Var);
    }

    public void b0() {
        this.D.clear();
    }

    @Override // m1.c1
    public boolean c() {
        return this.f3650p.j();
    }

    public boolean c0(Uri uri, m.c cVar, boolean z9) {
        m.b a10;
        if (this.f3644j.q(uri)) {
            long j10 = (z9 || (a10 = this.f3649o.a(p1.v.c(this.f3644j.l()), cVar)) == null || a10.f12123a != 2) ? -9223372036854775807L : a10.f12124b;
            return this.f3644j.s(uri, j10) && j10 != -9223372036854775807L;
        }
        return true;
    }

    @Override // u1.t
    public s0 d(int i10, int i11) {
        s0 s0Var;
        if (!f3636e0.contains(Integer.valueOf(i11))) {
            int i12 = 0;
            while (true) {
                s0[] s0VarArr = this.B;
                if (i12 >= s0VarArr.length) {
                    s0Var = null;
                    break;
                } else if (this.C[i12] == i10) {
                    s0Var = s0VarArr[i12];
                    break;
                } else {
                    i12++;
                }
            }
        } else {
            s0Var = M(i10, i11);
        }
        if (s0Var == null) {
            if (this.f3637a0) {
                return D(i10, i11);
            }
            s0Var = E(i10, i11);
        }
        if (i11 == 5) {
            if (this.F == null) {
                this.F = new c(s0Var, this.f3652r);
            }
            return this.F;
        }
        return s0Var;
    }

    public void d0() {
        if (this.f3654t.isEmpty()) {
            return;
        }
        final e eVar = (e) a0.d(this.f3654t);
        int d10 = this.f3644j.d(eVar);
        if (d10 == 1) {
            eVar.v();
        } else if (d10 == 0) {
            this.f3658x.post(new Runnable() { // from class: androidx.media3.exoplayer.hls.i
                @Override // java.lang.Runnable
                public final void run() {
                    l.this.T(eVar);
                }
            });
        } else if (d10 == 2 && !this.Z && this.f3650p.j()) {
            this.f3650p.f();
        }
    }

    @Override // u1.t
    public void e(u1.m0 m0Var) {
    }

    @Override // m1.c1
    public boolean f(o1 o1Var) {
        List list;
        long max;
        if (this.Z || this.f3650p.j() || this.f3650p.i()) {
            return false;
        }
        if (Q()) {
            list = Collections.emptyList();
            max = this.W;
            for (d dVar : this.B) {
                dVar.c0(this.W);
            }
        } else {
            list = this.f3655u;
            e L = L();
            max = L.h() ? L.f10265h : Math.max(this.V, L.f10264g);
        }
        List list2 = list;
        long j10 = max;
        this.f3653s.a();
        this.f3644j.f(o1Var, j10, list2, this.J || !list2.isEmpty(), this.f3653s);
        c.b bVar = this.f3653s;
        boolean z9 = bVar.f3580b;
        n1.e eVar = bVar.f3579a;
        Uri uri = bVar.f3581c;
        if (z9) {
            this.W = -9223372036854775807L;
            this.Z = true;
            return true;
        } else if (eVar == null) {
            if (uri != null) {
                this.f3643i.m(uri);
            }
            return false;
        } else {
            if (P(eVar)) {
                O((e) eVar);
            }
            this.A = eVar;
            this.f3651q.z(new m1.y(eVar.f10258a, eVar.f10259b, this.f3650p.n(eVar, this, this.f3649o.d(eVar.f10260c))), eVar.f10260c, this.f3642h, eVar.f10261d, eVar.f10262e, eVar.f10263f, eVar.f10264g, eVar.f10265h);
            return true;
        }
    }

    public void f0(p0.j0[] j0VarArr, int i10, int... iArr) {
        this.O = F(j0VarArr);
        this.P = new HashSet();
        for (int i11 : iArr) {
            this.P.add(this.O.b(i11));
        }
        this.R = i10;
        Handler handler = this.f3658x;
        final b bVar = this.f3643i;
        Objects.requireNonNull(bVar);
        handler.post(new Runnable() { // from class: c1.g
            @Override // java.lang.Runnable
            public final void run() {
                l.b.this.e();
            }
        });
        n0();
    }

    @Override // m1.c1
    public long g() {
        ArrayList arrayList;
        if (this.Z) {
            return Long.MIN_VALUE;
        }
        if (Q()) {
            return this.W;
        }
        long j10 = this.V;
        e L = L();
        if (!L.h()) {
            L = this.f3654t.size() > 1 ? (e) this.f3654t.get(arrayList.size() - 2) : null;
        }
        if (L != null) {
            j10 = Math.max(j10, L.f10265h);
        }
        if (this.I) {
            for (d dVar : this.B) {
                j10 = Math.max(j10, dVar.A());
            }
        }
        return j10;
    }

    public int g0(int i10, w0.l1 l1Var, v0.g gVar, int i11) {
        if (Q()) {
            return -3;
        }
        int i12 = 0;
        if (!this.f3654t.isEmpty()) {
            int i13 = 0;
            while (i13 < this.f3654t.size() - 1 && J((e) this.f3654t.get(i13))) {
                i13++;
            }
            j0.V0(this.f3654t, 0, i13);
            e eVar = (e) this.f3654t.get(0);
            p pVar = eVar.f10261d;
            if (!pVar.equals(this.M)) {
                this.f3651q.h(this.f3642h, pVar, eVar.f10262e, eVar.f10263f, eVar.f10264g);
            }
            this.M = pVar;
        }
        if (this.f3654t.isEmpty() || ((e) this.f3654t.get(0)).q()) {
            int T = this.B[i10].T(l1Var, gVar, i11, this.Z);
            if (T == -5) {
                p pVar2 = (p) s0.a.e(l1Var.f14451b);
                if (i10 == this.H) {
                    int d10 = u6.g.d(this.B[i10].R());
                    while (i12 < this.f3654t.size() && ((e) this.f3654t.get(i12)).f3592k != d10) {
                        i12++;
                    }
                    pVar2 = pVar2.h(i12 < this.f3654t.size() ? ((e) this.f3654t.get(i12)).f10261d : (p) s0.a.e(this.L));
                }
                l1Var.f14451b = pVar2;
            }
            return T;
        }
        return -3;
    }

    @Override // m1.c1
    public void h(long j10) {
        if (this.f3650p.i() || Q()) {
            return;
        }
        if (this.f3650p.j()) {
            s0.a.e(this.A);
            if (this.f3644j.x(j10, this.A, this.f3655u)) {
                this.f3650p.f();
                return;
            }
            return;
        }
        int size = this.f3655u.size();
        while (size > 0 && this.f3644j.d((e) this.f3655u.get(size - 1)) == 2) {
            size--;
        }
        if (size < this.f3655u.size()) {
            H(size);
        }
        int i10 = this.f3644j.i(j10, this.f3655u);
        if (i10 < this.f3654t.size()) {
            H(i10);
        }
    }

    public void h0() {
        if (this.J) {
            for (d dVar : this.B) {
                dVar.S();
            }
        }
        this.f3644j.t();
        this.f3650p.m(this);
        this.f3658x.removeCallbacksAndMessages(null);
        this.N = true;
        this.f3659y.clear();
    }

    @Override // q1.n.f
    public void i() {
        for (d dVar : this.B) {
            dVar.U();
        }
    }

    public void k() {
        W();
        if (this.Z && !this.J) {
            throw z.a("Loading finished before preparation is complete.", null);
        }
    }

    public boolean k0(long j10, boolean z9) {
        this.V = j10;
        if (Q()) {
            this.W = j10;
            return true;
        }
        e eVar = null;
        if (this.f3644j.m()) {
            int i10 = 0;
            while (true) {
                if (i10 >= this.f3654t.size()) {
                    break;
                }
                e eVar2 = (e) this.f3654t.get(i10);
                if (eVar2.f10264g == j10) {
                    eVar = eVar2;
                    break;
                }
                i10++;
            }
        }
        if (this.I && !z9 && j0(j10, eVar)) {
            return false;
        }
        this.W = j10;
        this.Z = false;
        this.f3654t.clear();
        if (this.f3650p.j()) {
            if (this.I) {
                for (d dVar : this.B) {
                    dVar.r();
                }
            }
            this.f3650p.f();
        } else {
            this.f3650p.g();
            i0();
        }
        return true;
    }

    /* JADX WARN: Removed duplicated region for block: B:72:0x0123  */
    /* JADX WARN: Removed duplicated region for block: B:75:0x012d  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean l0(r[] rVarArr, boolean[] zArr, b1[] b1VarArr, boolean[] zArr2, long j10, boolean z9) {
        boolean z10;
        boolean z11;
        y();
        int i10 = this.K;
        int i11 = 0;
        for (int i12 = 0; i12 < rVarArr.length; i12++) {
            h hVar = (h) b1VarArr[i12];
            if (hVar != null && (rVarArr[i12] == null || !zArr[i12])) {
                this.K--;
                hVar.c();
                b1VarArr[i12] = null;
            }
        }
        boolean z12 = z9 || (!this.Y ? j10 == this.V : i10 != 0);
        r l10 = this.f3644j.l();
        boolean z13 = z12;
        r rVar = l10;
        for (int i13 = 0; i13 < rVarArr.length; i13++) {
            r rVar2 = rVarArr[i13];
            if (rVar2 != null) {
                int d10 = this.O.d(rVar2.a());
                if (d10 == this.R) {
                    this.f3644j.w(rVar2);
                    rVar = rVar2;
                }
                if (b1VarArr[i13] == null) {
                    this.K++;
                    h hVar2 = new h(this, d10);
                    b1VarArr[i13] = hVar2;
                    zArr2[i13] = true;
                    if (this.Q != null) {
                        hVar2.a();
                        if (!z13) {
                            d dVar = this.B[this.Q[d10]];
                            z13 = (dVar.D() == 0 || dVar.a0(j10, true)) ? false : true;
                        }
                    }
                }
            }
        }
        if (this.K == 0) {
            this.f3644j.t();
            this.M = null;
            this.X = true;
            this.f3654t.clear();
            if (this.f3650p.j()) {
                if (this.I) {
                    d[] dVarArr = this.B;
                    int length = dVarArr.length;
                    while (i11 < length) {
                        dVarArr[i11].r();
                        i11++;
                    }
                }
                this.f3650p.f();
            } else {
                i0();
            }
        } else {
            if (!this.f3654t.isEmpty() && !j0.c(rVar, l10)) {
                if (!this.Y) {
                    long j11 = j10 < 0 ? -j10 : 0L;
                    e L = L();
                    rVar.j(j10, j11, -9223372036854775807L, this.f3655u, this.f3644j.a(L, j10));
                    if (rVar.o() == this.f3644j.k().b(L.f10261d)) {
                        z11 = false;
                        if (z11) {
                            this.X = true;
                            z10 = true;
                            z13 = true;
                            if (z13) {
                                k0(j10, z10);
                                while (i11 < b1VarArr.length) {
                                    if (b1VarArr[i11] != null) {
                                        zArr2[i11] = true;
                                    }
                                    i11++;
                                }
                            }
                        }
                    }
                }
                z11 = true;
                if (z11) {
                }
            }
            z10 = z9;
            if (z13) {
            }
        }
        s0(b1VarArr);
        this.Y = true;
        return z13;
    }

    @Override // u1.t
    public void m() {
        this.f3637a0 = true;
        this.f3658x.post(this.f3657w);
    }

    public void m0(p0.l lVar) {
        if (j0.c(this.f3639c0, lVar)) {
            return;
        }
        this.f3639c0 = lVar;
        int i10 = 0;
        while (true) {
            d[] dVarArr = this.B;
            if (i10 >= dVarArr.length) {
                return;
            }
            if (this.U[i10]) {
                dVarArr[i10].j0(lVar);
            }
            i10++;
        }
    }

    @Override // m1.a1.d
    public void o(p pVar) {
        this.f3658x.post(this.f3656v);
    }

    public void o0(boolean z9) {
        this.f3644j.v(z9);
    }

    public void p0(long j10) {
        if (this.f3638b0 != j10) {
            this.f3638b0 = j10;
            for (d dVar : this.B) {
                dVar.b0(j10);
            }
        }
    }

    public int q0(int i10, long j10) {
        if (Q()) {
            return 0;
        }
        d dVar = this.B[i10];
        int F = dVar.F(j10, this.Z);
        e eVar = (e) a0.e(this.f3654t, null);
        if (eVar != null && !eVar.q()) {
            F = Math.min(F, eVar.m(i10) - dVar.D());
        }
        dVar.f0(F);
        return F;
    }

    public void r0(int i10) {
        y();
        s0.a.e(this.Q);
        int i11 = this.Q[i10];
        s0.a.g(this.T[i11]);
        this.T[i11] = false;
    }

    public l1 s() {
        y();
        return this.O;
    }

    public void u(long j10, boolean z9) {
        if (!this.I || Q()) {
            return;
        }
        int length = this.B.length;
        for (int i10 = 0; i10 < length; i10++) {
            this.B[i10].q(j10, z9, this.T[i10]);
        }
    }

    public int z(int i10) {
        y();
        s0.a.e(this.Q);
        int i11 = this.Q[i10];
        if (i11 == -1) {
            return this.P.contains(this.O.b(i10)) ? -3 : -2;
        }
        boolean[] zArr = this.T;
        if (zArr[i11]) {
            return -2;
        }
        zArr[i11] = true;
        return i11;
    }
}
