package androidx.media3.exoplayer.dash;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.media3.exoplayer.dash.DashMediaSource;
import androidx.media3.exoplayer.dash.a;
import androidx.media3.exoplayer.dash.d;
import androidx.media3.exoplayer.dash.f;
import b1.a0;
import b1.l;
import b1.x;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import m1.b0;
import m1.c0;
import m1.f0;
import m1.j;
import m1.m0;
import p0.i0;
import p0.t;
import p0.u;
import p0.z;
import q1.f;
import q1.k;
import q1.m;
import q1.n;
import q1.o;
import q1.p;
import r1.a;
import r2.t;
import s0.j0;
import u0.g;
import u0.y;
/* loaded from: classes.dex */
public final class DashMediaSource extends m1.a {
    private final SparseArray A;
    private final Runnable B;
    private final Runnable C;
    private final f.b D;
    private final o E;
    private u0.g F;
    private n G;
    private y H;
    private IOException I;
    private Handler J;
    private t.g K;
    private Uri L;
    private Uri M;
    private a1.c N;
    private boolean O;
    private long P;
    private long Q;
    private long R;
    private int S;
    private long T;
    private int U;
    private t V;

    /* renamed from: n  reason: collision with root package name */
    private final boolean f3407n;

    /* renamed from: o  reason: collision with root package name */
    private final g.a f3408o;

    /* renamed from: p  reason: collision with root package name */
    private final a.InterfaceC0042a f3409p;

    /* renamed from: q  reason: collision with root package name */
    private final j f3410q;

    /* renamed from: r  reason: collision with root package name */
    private final x f3411r;

    /* renamed from: s  reason: collision with root package name */
    private final m f3412s;

    /* renamed from: t  reason: collision with root package name */
    private final z0.b f3413t;

    /* renamed from: u  reason: collision with root package name */
    private final long f3414u;

    /* renamed from: v  reason: collision with root package name */
    private final long f3415v;

    /* renamed from: w  reason: collision with root package name */
    private final m0.a f3416w;

    /* renamed from: x  reason: collision with root package name */
    private final p.a f3417x;

    /* renamed from: y  reason: collision with root package name */
    private final e f3418y;

    /* renamed from: z  reason: collision with root package name */
    private final Object f3419z;

    /* loaded from: classes.dex */
    public static final class Factory implements f0.a {

        /* renamed from: a  reason: collision with root package name */
        private final a.InterfaceC0042a f3420a;

        /* renamed from: b  reason: collision with root package name */
        private final g.a f3421b;

        /* renamed from: c  reason: collision with root package name */
        private f.a f3422c;

        /* renamed from: d  reason: collision with root package name */
        private a0 f3423d;

        /* renamed from: e  reason: collision with root package name */
        private j f3424e;

        /* renamed from: f  reason: collision with root package name */
        private m f3425f;

        /* renamed from: g  reason: collision with root package name */
        private long f3426g;

        /* renamed from: h  reason: collision with root package name */
        private long f3427h;

        /* renamed from: i  reason: collision with root package name */
        private p.a f3428i;

        public Factory(a.InterfaceC0042a interfaceC0042a, g.a aVar) {
            this.f3420a = (a.InterfaceC0042a) s0.a.e(interfaceC0042a);
            this.f3421b = aVar;
            this.f3423d = new l();
            this.f3425f = new k();
            this.f3426g = 30000L;
            this.f3427h = 5000000L;
            this.f3424e = new m1.k();
            b(true);
        }

        public Factory(g.a aVar) {
            this(new d.a(aVar), aVar);
        }

        @Override // m1.f0.a
        /* renamed from: g */
        public DashMediaSource c(t tVar) {
            s0.a.e(tVar.f11281b);
            p.a aVar = this.f3428i;
            if (aVar == null) {
                aVar = new a1.d();
            }
            List list = tVar.f11281b.f11376d;
            h1.b bVar = !list.isEmpty() ? new h1.b(aVar, list) : aVar;
            f.a aVar2 = this.f3422c;
            if (aVar2 != null) {
                aVar2.a(tVar);
            }
            return new DashMediaSource(tVar, null, this.f3421b, bVar, this.f3420a, this.f3424e, null, this.f3423d.a(tVar), this.f3425f, this.f3426g, this.f3427h, null);
        }

        @Override // m1.f0.a
        /* renamed from: h */
        public Factory b(boolean z9) {
            this.f3420a.b(z9);
            return this;
        }

        @Override // m1.f0.a
        /* renamed from: i */
        public Factory d(f.a aVar) {
            this.f3422c = (f.a) s0.a.e(aVar);
            return this;
        }

        @Override // m1.f0.a
        /* renamed from: j */
        public Factory f(a0 a0Var) {
            this.f3423d = (a0) s0.a.f(a0Var, "MediaSource.Factory#setDrmSessionManagerProvider no longer handles null by instantiating a new DefaultDrmSessionManagerProvider. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        @Override // m1.f0.a
        /* renamed from: k */
        public Factory e(m mVar) {
            this.f3425f = (m) s0.a.f(mVar, "MediaSource.Factory#setLoadErrorHandlingPolicy no longer handles null by instantiating a new DefaultLoadErrorHandlingPolicy. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        @Override // m1.f0.a
        /* renamed from: l */
        public Factory a(t.a aVar) {
            this.f3420a.a((t.a) s0.a.e(aVar));
            return this;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements a.b {
        a() {
        }

        @Override // r1.a.b
        public void a(IOException iOException) {
            DashMediaSource.this.a0(iOException);
        }

        @Override // r1.a.b
        public void b() {
            DashMediaSource.this.b0(r1.a.h());
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class b extends i0 {

        /* renamed from: e  reason: collision with root package name */
        private final long f3430e;

        /* renamed from: f  reason: collision with root package name */
        private final long f3431f;

        /* renamed from: g  reason: collision with root package name */
        private final long f3432g;

        /* renamed from: h  reason: collision with root package name */
        private final int f3433h;

        /* renamed from: i  reason: collision with root package name */
        private final long f3434i;

        /* renamed from: j  reason: collision with root package name */
        private final long f3435j;

        /* renamed from: k  reason: collision with root package name */
        private final long f3436k;

        /* renamed from: l  reason: collision with root package name */
        private final a1.c f3437l;

        /* renamed from: m  reason: collision with root package name */
        private final p0.t f3438m;

        /* renamed from: n  reason: collision with root package name */
        private final t.g f3439n;

        public b(long j10, long j11, long j12, int i10, long j13, long j14, long j15, a1.c cVar, p0.t tVar, t.g gVar) {
            s0.a.g(cVar.f30d == (gVar != null));
            this.f3430e = j10;
            this.f3431f = j11;
            this.f3432g = j12;
            this.f3433h = i10;
            this.f3434i = j13;
            this.f3435j = j14;
            this.f3436k = j15;
            this.f3437l = cVar;
            this.f3438m = tVar;
            this.f3439n = gVar;
        }

        private long s(long j10) {
            z0.f l10;
            long j11 = this.f3436k;
            if (t(this.f3437l)) {
                if (j10 > 0) {
                    j11 += j10;
                    if (j11 > this.f3435j) {
                        return -9223372036854775807L;
                    }
                }
                long j12 = this.f3434i + j11;
                long g10 = this.f3437l.g(0);
                int i10 = 0;
                while (i10 < this.f3437l.e() - 1 && j12 >= g10) {
                    j12 -= g10;
                    i10++;
                    g10 = this.f3437l.g(i10);
                }
                a1.g d10 = this.f3437l.d(i10);
                int a10 = d10.a(2);
                return (a10 == -1 || (l10 = ((a1.j) ((a1.a) d10.f64c.get(a10)).f19c.get(0)).l()) == null || l10.i(g10) == 0) ? j11 : (j11 + l10.b(l10.f(j12, g10))) - j12;
            }
            return j11;
        }

        private static boolean t(a1.c cVar) {
            return cVar.f30d && cVar.f31e != -9223372036854775807L && cVar.f28b == -9223372036854775807L;
        }

        @Override // p0.i0
        public int b(Object obj) {
            int intValue;
            if ((obj instanceof Integer) && (intValue = ((Integer) obj).intValue() - this.f3433h) >= 0 && intValue < i()) {
                return intValue;
            }
            return -1;
        }

        @Override // p0.i0
        public i0.b g(int i10, i0.b bVar, boolean z9) {
            s0.a.c(i10, 0, i());
            return bVar.s(z9 ? this.f3437l.d(i10).f62a : null, z9 ? Integer.valueOf(this.f3433h + i10) : null, 0, this.f3437l.g(i10), j0.K0(this.f3437l.d(i10).f63b - this.f3437l.d(0).f63b) - this.f3434i);
        }

        @Override // p0.i0
        public int i() {
            return this.f3437l.e();
        }

        @Override // p0.i0
        public Object m(int i10) {
            s0.a.c(i10, 0, i());
            return Integer.valueOf(this.f3433h + i10);
        }

        @Override // p0.i0
        public i0.c o(int i10, i0.c cVar, long j10) {
            s0.a.c(i10, 0, 1);
            long s9 = s(j10);
            Object obj = i0.c.f11032q;
            p0.t tVar = this.f3438m;
            a1.c cVar2 = this.f3437l;
            return cVar.g(obj, tVar, cVar2, this.f3430e, this.f3431f, this.f3432g, true, t(cVar2), this.f3439n, s9, this.f3435j, 0, i() - 1, this.f3434i);
        }

        @Override // p0.i0
        public int p() {
            return 1;
        }
    }

    /* loaded from: classes.dex */
    private final class c implements f.b {
        private c() {
        }

        /* synthetic */ c(DashMediaSource dashMediaSource, a aVar) {
            this();
        }

        @Override // androidx.media3.exoplayer.dash.f.b
        public void a() {
            DashMediaSource.this.U();
        }

        @Override // androidx.media3.exoplayer.dash.f.b
        public void b(long j10) {
            DashMediaSource.this.T(j10);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static final class d implements p.a {

        /* renamed from: a  reason: collision with root package name */
        private static final Pattern f3441a = Pattern.compile("(.+?)(Z|((\\+|-|−)(\\d\\d)(:?(\\d\\d))?))");

        d() {
        }

        @Override // q1.p.a
        /* renamed from: b */
        public Long a(Uri uri, InputStream inputStream) {
            String readLine = new BufferedReader(new InputStreamReader(inputStream, q6.d.f12236c)).readLine();
            try {
                Matcher matcher = f3441a.matcher(readLine);
                if (!matcher.matches()) {
                    throw z.c("Couldn't parse timestamp: " + readLine, null);
                }
                String group = matcher.group(1);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                long time = simpleDateFormat.parse(group).getTime();
                if (!"Z".equals(matcher.group(2))) {
                    long j10 = "+".equals(matcher.group(4)) ? 1L : -1L;
                    long parseLong = Long.parseLong(matcher.group(5));
                    String group2 = matcher.group(7);
                    time -= j10 * ((((parseLong * 60) + (TextUtils.isEmpty(group2) ? 0L : Long.parseLong(group2))) * 60) * 1000);
                }
                return Long.valueOf(time);
            } catch (ParseException e10) {
                throw z.c(null, e10);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class e implements n.b {
        private e() {
        }

        /* synthetic */ e(DashMediaSource dashMediaSource, a aVar) {
            this();
        }

        @Override // q1.n.b
        /* renamed from: a */
        public void t(p pVar, long j10, long j11, boolean z9) {
            DashMediaSource.this.V(pVar, j10, j11);
        }

        @Override // q1.n.b
        /* renamed from: b */
        public void p(p pVar, long j10, long j11) {
            DashMediaSource.this.W(pVar, j10, j11);
        }

        @Override // q1.n.b
        /* renamed from: c */
        public n.c n(p pVar, long j10, long j11, IOException iOException, int i10) {
            return DashMediaSource.this.X(pVar, j10, j11, iOException, i10);
        }
    }

    /* loaded from: classes.dex */
    final class f implements o {
        f() {
        }

        private void a() {
            if (DashMediaSource.this.I != null) {
                throw DashMediaSource.this.I;
            }
        }

        @Override // q1.o
        public void e() {
            DashMediaSource.this.G.e();
            a();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class g implements n.b {
        private g() {
        }

        /* synthetic */ g(DashMediaSource dashMediaSource, a aVar) {
            this();
        }

        @Override // q1.n.b
        /* renamed from: a */
        public void t(p pVar, long j10, long j11, boolean z9) {
            DashMediaSource.this.V(pVar, j10, j11);
        }

        @Override // q1.n.b
        /* renamed from: b */
        public void p(p pVar, long j10, long j11) {
            DashMediaSource.this.Y(pVar, j10, j11);
        }

        @Override // q1.n.b
        /* renamed from: c */
        public n.c n(p pVar, long j10, long j11, IOException iOException, int i10) {
            return DashMediaSource.this.Z(pVar, j10, j11, iOException);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class h implements p.a {
        private h() {
        }

        /* synthetic */ h(a aVar) {
            this();
        }

        @Override // q1.p.a
        /* renamed from: b */
        public Long a(Uri uri, InputStream inputStream) {
            return Long.valueOf(j0.R0(new BufferedReader(new InputStreamReader(inputStream)).readLine()));
        }
    }

    static {
        u.a("media3.exoplayer.dash");
    }

    private DashMediaSource(p0.t tVar, a1.c cVar, g.a aVar, p.a aVar2, a.InterfaceC0042a interfaceC0042a, j jVar, q1.f fVar, x xVar, m mVar, long j10, long j11) {
        this.V = tVar;
        this.K = tVar.f11283d;
        this.L = ((t.h) s0.a.e(tVar.f11281b)).f11373a;
        this.M = tVar.f11281b.f11373a;
        this.N = cVar;
        this.f3408o = aVar;
        this.f3417x = aVar2;
        this.f3409p = interfaceC0042a;
        this.f3411r = xVar;
        this.f3412s = mVar;
        this.f3414u = j10;
        this.f3415v = j11;
        this.f3410q = jVar;
        this.f3413t = new z0.b();
        boolean z9 = cVar != null;
        this.f3407n = z9;
        this.f3416w = x(null);
        this.f3419z = new Object();
        this.A = new SparseArray();
        this.D = new c(this, null);
        this.T = -9223372036854775807L;
        this.R = -9223372036854775807L;
        if (!z9) {
            this.f3418y = new e(this, null);
            this.E = new f();
            this.B = new Runnable() { // from class: z0.d
                @Override // java.lang.Runnable
                public final void run() {
                    DashMediaSource.this.i0();
                }
            };
            this.C = new Runnable() { // from class: z0.e
                @Override // java.lang.Runnable
                public final void run() {
                    DashMediaSource.this.R();
                }
            };
            return;
        }
        s0.a.g(true ^ cVar.f30d);
        this.f3418y = null;
        this.B = null;
        this.C = null;
        this.E = new o.a();
    }

    /* synthetic */ DashMediaSource(p0.t tVar, a1.c cVar, g.a aVar, p.a aVar2, a.InterfaceC0042a interfaceC0042a, j jVar, q1.f fVar, x xVar, m mVar, long j10, long j11, a aVar3) {
        this(tVar, cVar, aVar, aVar2, interfaceC0042a, jVar, fVar, xVar, mVar, j10, j11);
    }

    private static long L(a1.g gVar, long j10, long j11) {
        long K0 = j0.K0(gVar.f63b);
        boolean P = P(gVar);
        long j12 = Long.MAX_VALUE;
        for (int i10 = 0; i10 < gVar.f64c.size(); i10++) {
            a1.a aVar = (a1.a) gVar.f64c.get(i10);
            List list = aVar.f19c;
            int i11 = aVar.f18b;
            boolean z9 = true;
            z9 = (i11 == 1 || i11 == 2) ? false : false;
            if ((!P || !z9) && !list.isEmpty()) {
                z0.f l10 = ((a1.j) list.get(0)).l();
                if (l10 == null) {
                    return K0 + j10;
                }
                long j13 = l10.j(j10, j11);
                if (j13 == 0) {
                    return K0;
                }
                long c10 = (l10.c(j10, j11) + j13) - 1;
                j12 = Math.min(j12, l10.a(c10, j10) + l10.b(c10) + K0);
            }
        }
        return j12;
    }

    private static long M(a1.g gVar, long j10, long j11) {
        long K0 = j0.K0(gVar.f63b);
        boolean P = P(gVar);
        long j12 = K0;
        for (int i10 = 0; i10 < gVar.f64c.size(); i10++) {
            a1.a aVar = (a1.a) gVar.f64c.get(i10);
            List list = aVar.f19c;
            int i11 = aVar.f18b;
            boolean z9 = true;
            z9 = (i11 == 1 || i11 == 2) ? false : false;
            if ((!P || !z9) && !list.isEmpty()) {
                z0.f l10 = ((a1.j) list.get(0)).l();
                if (l10 == null || l10.j(j10, j11) == 0) {
                    return K0;
                }
                j12 = Math.max(j12, l10.b(l10.c(j10, j11)) + K0);
            }
        }
        return j12;
    }

    private static long N(a1.c cVar, long j10) {
        z0.f l10;
        int e10 = cVar.e() - 1;
        a1.g d10 = cVar.d(e10);
        long K0 = j0.K0(d10.f63b);
        long g10 = cVar.g(e10);
        long K02 = j0.K0(j10);
        long K03 = j0.K0(cVar.f27a);
        long K04 = j0.K0(5000L);
        for (int i10 = 0; i10 < d10.f64c.size(); i10++) {
            List list = ((a1.a) d10.f64c.get(i10)).f19c;
            if (!list.isEmpty() && (l10 = ((a1.j) list.get(0)).l()) != null) {
                long d11 = ((K03 + K0) + l10.d(g10, K02)) - K02;
                if (d11 < K04 - 100000 || (d11 > K04 && d11 < K04 + 100000)) {
                    K04 = d11;
                }
            }
        }
        return t6.e.b(K04, 1000L, RoundingMode.CEILING);
    }

    private long O() {
        return Math.min((this.S - 1) * 1000, 5000);
    }

    private static boolean P(a1.g gVar) {
        for (int i10 = 0; i10 < gVar.f64c.size(); i10++) {
            int i11 = ((a1.a) gVar.f64c.get(i10)).f18b;
            if (i11 == 1 || i11 == 2) {
                return true;
            }
        }
        return false;
    }

    private static boolean Q(a1.g gVar) {
        for (int i10 = 0; i10 < gVar.f64c.size(); i10++) {
            z0.f l10 = ((a1.j) ((a1.a) gVar.f64c.get(i10)).f19c.get(0)).l();
            if (l10 == null || l10.g()) {
                return true;
            }
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void R() {
        c0(false);
    }

    private void S() {
        r1.a.j(this.G, new a());
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a0(IOException iOException) {
        s0.o.d("DashMediaSource", "Failed to resolve time offset.", iOException);
        this.R = System.currentTimeMillis() - SystemClock.elapsedRealtime();
        c0(true);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void b0(long j10) {
        this.R = j10;
        c0(true);
    }

    private void c0(boolean z9) {
        a1.g gVar;
        long j10;
        long j11;
        for (int i10 = 0; i10 < this.A.size(); i10++) {
            int keyAt = this.A.keyAt(i10);
            if (keyAt >= this.U) {
                ((androidx.media3.exoplayer.dash.c) this.A.valueAt(i10)).P(this.N, keyAt - this.U);
            }
        }
        a1.g d10 = this.N.d(0);
        int e10 = this.N.e() - 1;
        a1.g d11 = this.N.d(e10);
        long g10 = this.N.g(e10);
        long K0 = j0.K0(j0.f0(this.R));
        long M = M(d10, this.N.g(0), K0);
        long L = L(d11, g10, K0);
        boolean z10 = this.N.f30d && !Q(d11);
        if (z10) {
            long j12 = this.N.f32f;
            if (j12 != -9223372036854775807L) {
                M = Math.max(M, L - j0.K0(j12));
            }
        }
        long j13 = L - M;
        a1.c cVar = this.N;
        if (cVar.f30d) {
            s0.a.g(cVar.f27a != -9223372036854775807L);
            long K02 = (K0 - j0.K0(this.N.f27a)) - M;
            j0(K02, j13);
            long l12 = this.N.f27a + j0.l1(M);
            long K03 = K02 - j0.K0(this.K.f11355a);
            long min = Math.min(this.f3415v, j13 / 2);
            j10 = l12;
            j11 = K03 < min ? min : K03;
            gVar = d10;
        } else {
            gVar = d10;
            j10 = -9223372036854775807L;
            j11 = 0;
        }
        long K04 = M - j0.K0(gVar.f63b);
        a1.c cVar2 = this.N;
        D(new b(cVar2.f27a, j10, this.R, this.U, K04, j13, j11, cVar2, e(), this.N.f30d ? this.K : null));
        if (this.f3407n) {
            return;
        }
        this.J.removeCallbacks(this.C);
        if (z10) {
            this.J.postDelayed(this.C, N(this.N, j0.f0(this.R)));
        }
        if (this.O) {
            i0();
        } else if (z9) {
            a1.c cVar3 = this.N;
            if (cVar3.f30d) {
                long j14 = cVar3.f31e;
                if (j14 != -9223372036854775807L) {
                    if (j14 == 0) {
                        j14 = 5000;
                    }
                    g0(Math.max(0L, (this.P + j14) - SystemClock.elapsedRealtime()));
                }
            }
        }
    }

    private void d0(a1.o oVar) {
        p.a dVar;
        String str = oVar.f116a;
        if (j0.c(str, "urn:mpeg:dash:utc:direct:2014") || j0.c(str, "urn:mpeg:dash:utc:direct:2012")) {
            e0(oVar);
            return;
        }
        if (j0.c(str, "urn:mpeg:dash:utc:http-iso:2014") || j0.c(str, "urn:mpeg:dash:utc:http-iso:2012")) {
            dVar = new d();
        } else if (!j0.c(str, "urn:mpeg:dash:utc:http-xsdate:2014") && !j0.c(str, "urn:mpeg:dash:utc:http-xsdate:2012")) {
            if (j0.c(str, "urn:mpeg:dash:utc:ntp:2014") || j0.c(str, "urn:mpeg:dash:utc:ntp:2012")) {
                S();
                return;
            } else {
                a0(new IOException("Unsupported UTC timing scheme"));
                return;
            }
        } else {
            dVar = new h(null);
        }
        f0(oVar, dVar);
    }

    private void e0(a1.o oVar) {
        try {
            b0(j0.R0(oVar.f117b) - this.Q);
        } catch (z e10) {
            a0(e10);
        }
    }

    private void f0(a1.o oVar, p.a aVar) {
        h0(new p(this.F, Uri.parse(oVar.f117b), 5, aVar), new g(this, null), 1);
    }

    private void g0(long j10) {
        this.J.postDelayed(this.B, j10);
    }

    private void h0(p pVar, n.b bVar, int i10) {
        this.f3416w.y(new m1.y(pVar.f12149a, pVar.f12150b, this.G.n(pVar, bVar, i10)), pVar.f12151c);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void i0() {
        Uri uri;
        this.J.removeCallbacks(this.B);
        if (this.G.i()) {
            return;
        }
        if (this.G.j()) {
            this.O = true;
            return;
        }
        synchronized (this.f3419z) {
            uri = this.L;
        }
        this.O = false;
        h0(new p(this.F, uri, 4, this.f3417x), this.f3418y, this.f3412s.d(4));
    }

    /* JADX WARN: Code restructure failed: missing block: B:25:0x005f, code lost:
        if (r2 != (-9223372036854775807L)) goto L14;
     */
    /* JADX WARN: Code restructure failed: missing block: B:8:0x0027, code lost:
        if (r2 != (-9223372036854775807L)) goto L3;
     */
    /* JADX WARN: Removed duplicated region for block: B:18:0x0044  */
    /* JADX WARN: Removed duplicated region for block: B:22:0x0055  */
    /* JADX WARN: Removed duplicated region for block: B:29:0x0066  */
    /* JADX WARN: Removed duplicated region for block: B:33:0x0070  */
    /* JADX WARN: Removed duplicated region for block: B:44:0x008b  */
    /* JADX WARN: Removed duplicated region for block: B:47:0x0090  */
    /* JADX WARN: Removed duplicated region for block: B:51:0x00b1  */
    /* JADX WARN: Removed duplicated region for block: B:58:0x00c4  */
    /* JADX WARN: Removed duplicated region for block: B:64:0x00d6  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void j0(long j10, long j11) {
        long j12;
        long l12;
        long j13;
        long j14;
        long j15;
        long j16;
        float f10;
        float f11;
        a1.l lVar;
        t.g gVar = e().f11283d;
        long l13 = j0.l1(j10);
        long j17 = gVar.f11357c;
        if (j17 == -9223372036854775807L) {
            a1.l lVar2 = this.N.f36j;
            if (lVar2 != null) {
                j17 = lVar2.f109c;
            }
            j12 = l13;
            l12 = j0.l1(j10 - j11);
            if (l12 < 0 && j12 > 0) {
                l12 = 0;
            }
            j13 = this.N.f29c;
            if (j13 != -9223372036854775807L) {
                l12 = Math.min(l12 + j13, l13);
            }
            j14 = l12;
            j15 = gVar.f11356b;
            if (j15 == -9223372036854775807L) {
                a1.l lVar3 = this.N.f36j;
                if (lVar3 != null) {
                    j15 = lVar3.f108b;
                }
                if (j14 > j12) {
                    j12 = j14;
                }
                j16 = this.K.f11355a;
                if (j16 == -9223372036854775807L) {
                    a1.c cVar = this.N;
                    a1.l lVar4 = cVar.f36j;
                    if (lVar4 != null) {
                        long j18 = lVar4.f107a;
                        if (j18 != -9223372036854775807L) {
                            j16 = j18;
                        }
                    }
                    j16 = cVar.f33g;
                    if (j16 == -9223372036854775807L) {
                        j16 = this.f3414u;
                    }
                }
                if (j16 < j14) {
                    j16 = j14;
                }
                if (j16 > j12) {
                    j16 = j0.q(j0.l1(j10 - Math.min(this.f3415v, j11 / 2)), j14, j12);
                }
                f10 = gVar.f11358d;
                if (f10 == -3.4028235E38f) {
                    a1.l lVar5 = this.N.f36j;
                    f10 = lVar5 != null ? lVar5.f110d : -3.4028235E38f;
                }
                f11 = gVar.f11359e;
                if (f11 == -3.4028235E38f) {
                    a1.l lVar6 = this.N.f36j;
                    f11 = lVar6 != null ? lVar6.f111e : -3.4028235E38f;
                }
                if (f10 == -3.4028235E38f && f11 == -3.4028235E38f && ((lVar = this.N.f36j) == null || lVar.f107a == -9223372036854775807L)) {
                    f11 = 1.0f;
                    f10 = 1.0f;
                }
                this.K = new t.g.a().k(j16).i(j14).g(j12).j(f10).h(f11).f();
            }
            j14 = j0.q(j15, j14, l13);
            if (j14 > j12) {
            }
            j16 = this.K.f11355a;
            if (j16 == -9223372036854775807L) {
            }
            if (j16 < j14) {
            }
            if (j16 > j12) {
            }
            f10 = gVar.f11358d;
            if (f10 == -3.4028235E38f) {
            }
            f11 = gVar.f11359e;
            if (f11 == -3.4028235E38f) {
            }
            if (f10 == -3.4028235E38f) {
                f11 = 1.0f;
                f10 = 1.0f;
            }
            this.K = new t.g.a().k(j16).i(j14).g(j12).j(f10).h(f11).f();
        }
        j12 = Math.min(l13, j17);
        l12 = j0.l1(j10 - j11);
        if (l12 < 0) {
            l12 = 0;
        }
        j13 = this.N.f29c;
        if (j13 != -9223372036854775807L) {
        }
        j14 = l12;
        j15 = gVar.f11356b;
        if (j15 == -9223372036854775807L) {
        }
        j14 = j0.q(j15, j14, l13);
        if (j14 > j12) {
        }
        j16 = this.K.f11355a;
        if (j16 == -9223372036854775807L) {
        }
        if (j16 < j14) {
        }
        if (j16 > j12) {
        }
        f10 = gVar.f11358d;
        if (f10 == -3.4028235E38f) {
        }
        f11 = gVar.f11359e;
        if (f11 == -3.4028235E38f) {
        }
        if (f10 == -3.4028235E38f) {
        }
        this.K = new t.g.a().k(j16).i(j14).g(j12).j(f10).h(f11).f();
    }

    @Override // m1.a
    protected void C(y yVar) {
        this.H = yVar;
        this.f3411r.c(Looper.myLooper(), A());
        this.f3411r.a();
        if (this.f3407n) {
            c0(false);
            return;
        }
        this.F = this.f3408o.a();
        this.G = new n("DashMediaSource");
        this.J = j0.A();
        i0();
    }

    @Override // m1.a
    protected void E() {
        this.O = false;
        this.F = null;
        n nVar = this.G;
        if (nVar != null) {
            nVar.l();
            this.G = null;
        }
        this.P = 0L;
        this.Q = 0L;
        this.L = this.M;
        this.I = null;
        Handler handler = this.J;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
            this.J = null;
        }
        this.R = -9223372036854775807L;
        this.S = 0;
        this.T = -9223372036854775807L;
        this.A.clear();
        this.f3413t.i();
        this.f3411r.release();
    }

    void T(long j10) {
        long j11 = this.T;
        if (j11 == -9223372036854775807L || j11 < j10) {
            this.T = j10;
        }
    }

    void U() {
        this.J.removeCallbacks(this.C);
        i0();
    }

    void V(p pVar, long j10, long j11) {
        m1.y yVar = new m1.y(pVar.f12149a, pVar.f12150b, pVar.f(), pVar.d(), j10, j11, pVar.a());
        this.f3412s.b(pVar.f12149a);
        this.f3416w.p(yVar, pVar.f12151c);
    }

    /* JADX WARN: Removed duplicated region for block: B:24:0x00a7  */
    /* JADX WARN: Removed duplicated region for block: B:29:0x00c7  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    void W(p pVar, long j10, long j11) {
        boolean z9;
        String str;
        String str2;
        m1.y yVar = new m1.y(pVar.f12149a, pVar.f12150b, pVar.f(), pVar.d(), j10, j11, pVar.a());
        this.f3412s.b(pVar.f12149a);
        this.f3416w.s(yVar, pVar.f12151c);
        a1.c cVar = (a1.c) pVar.e();
        a1.c cVar2 = this.N;
        int e10 = cVar2 == null ? 0 : cVar2.e();
        long j12 = cVar.d(0).f63b;
        int i10 = 0;
        while (i10 < e10 && this.N.d(i10).f63b < j12) {
            i10++;
        }
        if (cVar.f30d) {
            if (e10 - i10 > cVar.e()) {
                str = "DashMediaSource";
                str2 = "Loaded out of sync manifest";
            } else {
                long j13 = this.T;
                if (j13 == -9223372036854775807L || cVar.f34h * 1000 > j13) {
                    z9 = false;
                    if (!z9) {
                        int i11 = this.S;
                        this.S = i11 + 1;
                        if (i11 < this.f3412s.d(pVar.f12151c)) {
                            g0(O());
                            return;
                        } else {
                            this.I = new z0.c();
                            return;
                        }
                    }
                    this.S = 0;
                } else {
                    str = "DashMediaSource";
                    str2 = "Loaded stale dynamic manifest: " + cVar.f34h + ", " + this.T;
                }
            }
            s0.o.h(str, str2);
            z9 = true;
            if (!z9) {
            }
        }
        this.N = cVar;
        this.O = cVar.f30d & this.O;
        this.P = j10 - j11;
        this.Q = j10;
        this.U += i10;
        synchronized (this.f3419z) {
            if (pVar.f12150b.f13519a == this.L) {
                Uri uri = this.N.f37k;
                if (uri == null) {
                    uri = pVar.f();
                }
                this.L = uri;
            }
        }
        a1.c cVar3 = this.N;
        if (!cVar3.f30d || this.R != -9223372036854775807L) {
            c0(true);
            return;
        }
        a1.o oVar = cVar3.f35i;
        if (oVar != null) {
            d0(oVar);
        } else {
            S();
        }
    }

    n.c X(p pVar, long j10, long j11, IOException iOException, int i10) {
        m1.y yVar = new m1.y(pVar.f12149a, pVar.f12150b, pVar.f(), pVar.d(), j10, j11, pVar.a());
        long c10 = this.f3412s.c(new m.c(yVar, new b0(pVar.f12151c), iOException, i10));
        n.c h10 = c10 == -9223372036854775807L ? n.f12132g : n.h(false, c10);
        boolean z9 = !h10.c();
        this.f3416w.w(yVar, pVar.f12151c, iOException, z9);
        if (z9) {
            this.f3412s.b(pVar.f12149a);
        }
        return h10;
    }

    void Y(p pVar, long j10, long j11) {
        m1.y yVar = new m1.y(pVar.f12149a, pVar.f12150b, pVar.f(), pVar.d(), j10, j11, pVar.a());
        this.f3412s.b(pVar.f12149a);
        this.f3416w.s(yVar, pVar.f12151c);
        b0(((Long) pVar.e()).longValue() - j10);
    }

    n.c Z(p pVar, long j10, long j11, IOException iOException) {
        this.f3416w.w(new m1.y(pVar.f12149a, pVar.f12150b, pVar.f(), pVar.d(), j10, j11, pVar.a()), pVar.f12151c, iOException, true);
        this.f3412s.b(pVar.f12149a);
        a0(iOException);
        return n.f12131f;
    }

    @Override // m1.a, m1.f0
    public synchronized void a(p0.t tVar) {
        this.V = tVar;
    }

    @Override // m1.f0
    public synchronized p0.t e() {
        return this.V;
    }

    @Override // m1.f0
    public void g() {
        this.E.e();
    }

    @Override // m1.f0
    public c0 i(f0.b bVar, q1.b bVar2, long j10) {
        int intValue = ((Integer) bVar.f9717a).intValue() - this.U;
        m0.a x9 = x(bVar);
        androidx.media3.exoplayer.dash.c cVar = new androidx.media3.exoplayer.dash.c(intValue + this.U, this.N, this.f3413t, intValue, this.f3409p, this.H, null, this.f3411r, v(bVar), this.f3412s, x9, this.R, this.E, bVar2, this.f3410q, this.D, A());
        this.A.put(cVar.f3445g, cVar);
        return cVar;
    }

    @Override // m1.f0
    public void s(c0 c0Var) {
        androidx.media3.exoplayer.dash.c cVar = (androidx.media3.exoplayer.dash.c) c0Var;
        cVar.L();
        this.A.remove(cVar.f3445g);
    }
}
