package androidx.lifecycle;

import androidx.lifecycle.h;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/* loaded from: classes.dex */
final class b {

    /* renamed from: c  reason: collision with root package name */
    static b f3301c = new b();

    /* renamed from: a  reason: collision with root package name */
    private final Map f3302a = new HashMap();

    /* renamed from: b  reason: collision with root package name */
    private final Map f3303b = new HashMap();

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a {

        /* renamed from: a  reason: collision with root package name */
        final Map f3304a = new HashMap();

        /* renamed from: b  reason: collision with root package name */
        final Map f3305b;

        a(Map map) {
            this.f3305b = map;
            for (Map.Entry entry : map.entrySet()) {
                h.a aVar = (h.a) entry.getValue();
                List list = (List) this.f3304a.get(aVar);
                if (list == null) {
                    list = new ArrayList();
                    this.f3304a.put(aVar, list);
                }
                list.add((C0035b) entry.getKey());
            }
        }

        private static void b(List list, m mVar, h.a aVar, Object obj) {
            if (list != null) {
                for (int size = list.size() - 1; size >= 0; size--) {
                    ((C0035b) list.get(size)).a(mVar, aVar, obj);
                }
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public void a(m mVar, h.a aVar, Object obj) {
            b((List) this.f3304a.get(aVar), mVar, aVar, obj);
            b((List) this.f3304a.get(h.a.ON_ANY), mVar, aVar, obj);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: androidx.lifecycle.b$b  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static final class C0035b {

        /* renamed from: a  reason: collision with root package name */
        final int f3306a;

        /* renamed from: b  reason: collision with root package name */
        final Method f3307b;

        C0035b(int i10, Method method) {
            this.f3306a = i10;
            this.f3307b = method;
            method.setAccessible(true);
        }

        void a(m mVar, h.a aVar, Object obj) {
            try {
                int i10 = this.f3306a;
                if (i10 == 0) {
                    this.f3307b.invoke(obj, new Object[0]);
                } else if (i10 == 1) {
                    this.f3307b.invoke(obj, mVar);
                } else if (i10 != 2) {
                } else {
                    this.f3307b.invoke(obj, mVar, aVar);
                }
            } catch (IllegalAccessException e10) {
                throw new RuntimeException(e10);
            } catch (InvocationTargetException e11) {
                throw new RuntimeException("Failed to call observer method", e11.getCause());
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof C0035b) {
                C0035b c0035b = (C0035b) obj;
                return this.f3306a == c0035b.f3306a && this.f3307b.getName().equals(c0035b.f3307b.getName());
            }
            return false;
        }

        public int hashCode() {
            return (this.f3306a * 31) + this.f3307b.getName().hashCode();
        }
    }

    b() {
    }

    private a a(Class cls, Method[] methodArr) {
        int i10;
        a c10;
        Class superclass = cls.getSuperclass();
        HashMap hashMap = new HashMap();
        if (superclass != null && (c10 = c(superclass)) != null) {
            hashMap.putAll(c10.f3305b);
        }
        for (Class<?> cls2 : cls.getInterfaces()) {
            for (Map.Entry entry : c(cls2).f3305b.entrySet()) {
                e(hashMap, (C0035b) entry.getKey(), (h.a) entry.getValue(), cls);
            }
        }
        if (methodArr == null) {
            methodArr = b(cls);
        }
        boolean z9 = false;
        for (Method method : methodArr) {
            t tVar = (t) method.getAnnotation(t.class);
            if (tVar != null) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length <= 0) {
                    i10 = 0;
                } else if (!m.class.isAssignableFrom(parameterTypes[0])) {
                    throw new IllegalArgumentException("invalid parameter type. Must be one and instanceof LifecycleOwner");
                } else {
                    i10 = 1;
                }
                h.a value = tVar.value();
                if (parameterTypes.length > 1) {
                    if (!h.a.class.isAssignableFrom(parameterTypes[1])) {
                        throw new IllegalArgumentException("invalid parameter type. second arg must be an event");
                    }
                    if (value != h.a.ON_ANY) {
                        throw new IllegalArgumentException("Second arg is supported only for ON_ANY value");
                    }
                    i10 = 2;
                }
                if (parameterTypes.length > 2) {
                    throw new IllegalArgumentException("cannot have more than 2 params");
                }
                e(hashMap, new C0035b(i10, method), value, cls);
                z9 = true;
            }
        }
        a aVar = new a(hashMap);
        this.f3302a.put(cls, aVar);
        this.f3303b.put(cls, Boolean.valueOf(z9));
        return aVar;
    }

    private Method[] b(Class cls) {
        try {
            return cls.getDeclaredMethods();
        } catch (NoClassDefFoundError e10) {
            throw new IllegalArgumentException("The observer class has some methods that use newer APIs which are not available in the current OS version. Lifecycles cannot access even other methods so you should make sure that your observer classes only access framework classes that are available in your min API level OR use lifecycle:compiler annotation processor.", e10);
        }
    }

    private void e(Map map, C0035b c0035b, h.a aVar, Class cls) {
        h.a aVar2 = (h.a) map.get(c0035b);
        if (aVar2 == null || aVar == aVar2) {
            if (aVar2 == null) {
                map.put(c0035b, aVar);
                return;
            }
            return;
        }
        Method method = c0035b.f3307b;
        throw new IllegalArgumentException("Method " + method.getName() + " in " + cls.getName() + " already declared with different @OnLifecycleEvent value: previous value " + aVar2 + ", new value " + aVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public a c(Class cls) {
        a aVar = (a) this.f3302a.get(cls);
        return aVar != null ? aVar : a(cls, null);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean d(Class cls) {
        Boolean bool = (Boolean) this.f3303b.get(cls);
        if (bool != null) {
            return bool.booleanValue();
        }
        Method[] b10 = b(cls);
        for (Method method : b10) {
            if (((t) method.getAnnotation(t.class)) != null) {
                a(cls, b10);
                return true;
            }
        }
        this.f3303b.put(cls, Boolean.FALSE);
        return false;
    }
}
