package androidx.fragment.app;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class v {

    /* renamed from: a  reason: collision with root package name */
    private final ArrayList f3161a = new ArrayList();

    /* renamed from: b  reason: collision with root package name */
    private final HashMap f3162b = new HashMap();

    /* renamed from: c  reason: collision with root package name */
    private q f3163c;

    /* JADX INFO: Access modifiers changed from: package-private */
    public void a(Fragment fragment) {
        if (this.f3161a.contains(fragment)) {
            throw new IllegalStateException("Fragment already added: " + fragment);
        }
        synchronized (this.f3161a) {
            this.f3161a.add(fragment);
        }
        fragment.mAdded = true;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void b() {
        this.f3162b.values().removeAll(Collections.singleton(null));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean c(String str) {
        return this.f3162b.get(str) != null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void d(int i10) {
        for (u uVar : this.f3162b.values()) {
            if (uVar != null) {
                uVar.t(i10);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void e(String str, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] strArr) {
        String str2 = str + "    ";
        if (!this.f3162b.isEmpty()) {
            printWriter.print(str);
            printWriter.println("Active Fragments:");
            for (u uVar : this.f3162b.values()) {
                printWriter.print(str);
                if (uVar != null) {
                    Fragment k10 = uVar.k();
                    printWriter.println(k10);
                    k10.dump(str2, fileDescriptor, printWriter, strArr);
                } else {
                    printWriter.println("null");
                }
            }
        }
        int size = this.f3161a.size();
        if (size > 0) {
            printWriter.print(str);
            printWriter.println("Added Fragments:");
            for (int i10 = 0; i10 < size; i10++) {
                printWriter.print(str);
                printWriter.print("  #");
                printWriter.print(i10);
                printWriter.print(": ");
                printWriter.println(((Fragment) this.f3161a.get(i10)).toString());
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Fragment f(String str) {
        u uVar = (u) this.f3162b.get(str);
        if (uVar != null) {
            return uVar.k();
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Fragment g(int i10) {
        for (int size = this.f3161a.size() - 1; size >= 0; size--) {
            Fragment fragment = (Fragment) this.f3161a.get(size);
            if (fragment != null && fragment.mFragmentId == i10) {
                return fragment;
            }
        }
        for (u uVar : this.f3162b.values()) {
            if (uVar != null) {
                Fragment k10 = uVar.k();
                if (k10.mFragmentId == i10) {
                    return k10;
                }
            }
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Fragment h(String str) {
        if (str != null) {
            for (int size = this.f3161a.size() - 1; size >= 0; size--) {
                Fragment fragment = (Fragment) this.f3161a.get(size);
                if (fragment != null && str.equals(fragment.mTag)) {
                    return fragment;
                }
            }
        }
        if (str != null) {
            for (u uVar : this.f3162b.values()) {
                if (uVar != null) {
                    Fragment k10 = uVar.k();
                    if (str.equals(k10.mTag)) {
                        return k10;
                    }
                }
            }
            return null;
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Fragment i(String str) {
        Fragment findFragmentByWho;
        for (u uVar : this.f3162b.values()) {
            if (uVar != null && (findFragmentByWho = uVar.k().findFragmentByWho(str)) != null) {
                return findFragmentByWho;
            }
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int j(Fragment fragment) {
        View view;
        View view2;
        ViewGroup viewGroup = fragment.mContainer;
        if (viewGroup == null) {
            return -1;
        }
        int indexOf = this.f3161a.indexOf(fragment);
        for (int i10 = indexOf - 1; i10 >= 0; i10--) {
            Fragment fragment2 = (Fragment) this.f3161a.get(i10);
            if (fragment2.mContainer == viewGroup && (view2 = fragment2.mView) != null) {
                return viewGroup.indexOfChild(view2) + 1;
            }
        }
        while (true) {
            indexOf++;
            if (indexOf >= this.f3161a.size()) {
                return -1;
            }
            Fragment fragment3 = (Fragment) this.f3161a.get(indexOf);
            if (fragment3.mContainer == viewGroup && (view = fragment3.mView) != null) {
                return viewGroup.indexOfChild(view);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public List k() {
        ArrayList arrayList = new ArrayList();
        for (u uVar : this.f3162b.values()) {
            if (uVar != null) {
                arrayList.add(uVar);
            }
        }
        return arrayList;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public List l() {
        ArrayList arrayList = new ArrayList();
        for (u uVar : this.f3162b.values()) {
            arrayList.add(uVar != null ? uVar.k() : null);
        }
        return arrayList;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public u m(String str) {
        return (u) this.f3162b.get(str);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public List n() {
        ArrayList arrayList;
        if (this.f3161a.isEmpty()) {
            return Collections.emptyList();
        }
        synchronized (this.f3161a) {
            arrayList = new ArrayList(this.f3161a);
        }
        return arrayList;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public q o() {
        return this.f3163c;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void p(u uVar) {
        Fragment k10 = uVar.k();
        if (c(k10.mWho)) {
            return;
        }
        this.f3162b.put(k10.mWho, uVar);
        if (k10.mRetainInstanceChangedWhileDetached) {
            if (k10.mRetainInstance) {
                this.f3163c.f(k10);
            } else {
                this.f3163c.n(k10);
            }
            k10.mRetainInstanceChangedWhileDetached = false;
        }
        if (n.F0(2)) {
            Log.v("FragmentManager", "Added fragment to active set " + k10);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void q(u uVar) {
        Fragment k10 = uVar.k();
        if (k10.mRetainInstance) {
            this.f3163c.n(k10);
        }
        if (((u) this.f3162b.put(k10.mWho, null)) != null && n.F0(2)) {
            Log.v("FragmentManager", "Removed fragment from active set " + k10);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void r() {
        Iterator it = this.f3161a.iterator();
        while (it.hasNext()) {
            u uVar = (u) this.f3162b.get(((Fragment) it.next()).mWho);
            if (uVar != null) {
                uVar.m();
            }
        }
        for (u uVar2 : this.f3162b.values()) {
            if (uVar2 != null) {
                uVar2.m();
                Fragment k10 = uVar2.k();
                if (k10.mRemoving && !k10.isInBackStack()) {
                    q(uVar2);
                }
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void s(Fragment fragment) {
        synchronized (this.f3161a) {
            this.f3161a.remove(fragment);
        }
        fragment.mAdded = false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void t() {
        this.f3162b.clear();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void u(List list) {
        this.f3161a.clear();
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String str = (String) it.next();
                Fragment f10 = f(str);
                if (f10 == null) {
                    throw new IllegalStateException("No instantiated fragment for (" + str + ")");
                }
                if (n.F0(2)) {
                    Log.v("FragmentManager", "restoreSaveState: added (" + str + "): " + f10);
                }
                a(f10);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public ArrayList v() {
        ArrayList arrayList = new ArrayList(this.f3162b.size());
        for (u uVar : this.f3162b.values()) {
            if (uVar != null) {
                Fragment k10 = uVar.k();
                t r10 = uVar.r();
                arrayList.add(r10);
                if (n.F0(2)) {
                    Log.v("FragmentManager", "Saved state of " + k10 + ": " + r10.f3152s);
                }
            }
        }
        return arrayList;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public ArrayList w() {
        synchronized (this.f3161a) {
            if (this.f3161a.isEmpty()) {
                return null;
            }
            ArrayList arrayList = new ArrayList(this.f3161a.size());
            Iterator it = this.f3161a.iterator();
            while (it.hasNext()) {
                Fragment fragment = (Fragment) it.next();
                arrayList.add(fragment.mWho);
                if (n.F0(2)) {
                    Log.v("FragmentManager", "saveAllState: adding fragment (" + fragment.mWho + "): " + fragment);
                }
            }
            return arrayList;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void x(q qVar) {
        this.f3163c = qVar;
    }
}
