package androidx.fragment.app;

import android.app.Activity;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.core.view.r0;
import androidx.fragment.app.c0;
import androidx.lifecycle.h;
import androidx.lifecycle.l0;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class u {

    /* renamed from: a  reason: collision with root package name */
    private final m f3153a;

    /* renamed from: b  reason: collision with root package name */
    private final v f3154b;

    /* renamed from: c  reason: collision with root package name */
    private final Fragment f3155c;

    /* renamed from: d  reason: collision with root package name */
    private boolean f3156d = false;

    /* renamed from: e  reason: collision with root package name */
    private int f3157e = -1;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements View.OnAttachStateChangeListener {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ View f3158g;

        a(View view) {
            this.f3158g = view;
        }

        @Override // android.view.View.OnAttachStateChangeListener
        public void onViewAttachedToWindow(View view) {
            this.f3158g.removeOnAttachStateChangeListener(this);
            r0.k0(this.f3158g);
        }

        @Override // android.view.View.OnAttachStateChangeListener
        public void onViewDetachedFromWindow(View view) {
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static /* synthetic */ class b {

        /* renamed from: a  reason: collision with root package name */
        static final /* synthetic */ int[] f3160a;

        static {
            int[] iArr = new int[h.b.values().length];
            f3160a = iArr;
            try {
                iArr[h.b.RESUMED.ordinal()] = 1;
            } catch (NoSuchFieldError unused) {
            }
            try {
                f3160a[h.b.STARTED.ordinal()] = 2;
            } catch (NoSuchFieldError unused2) {
            }
            try {
                f3160a[h.b.CREATED.ordinal()] = 3;
            } catch (NoSuchFieldError unused3) {
            }
            try {
                f3160a[h.b.INITIALIZED.ordinal()] = 4;
            } catch (NoSuchFieldError unused4) {
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public u(m mVar, v vVar, Fragment fragment) {
        this.f3153a = mVar;
        this.f3154b = vVar;
        this.f3155c = fragment;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public u(m mVar, v vVar, Fragment fragment, t tVar) {
        this.f3153a = mVar;
        this.f3154b = vVar;
        this.f3155c = fragment;
        fragment.mSavedViewState = null;
        fragment.mSavedViewRegistryState = null;
        fragment.mBackStackNesting = 0;
        fragment.mInLayout = false;
        fragment.mAdded = false;
        Fragment fragment2 = fragment.mTarget;
        fragment.mTargetWho = fragment2 != null ? fragment2.mWho : null;
        fragment.mTarget = null;
        Bundle bundle = tVar.f3152s;
        fragment.mSavedFragmentState = bundle == null ? new Bundle() : bundle;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public u(m mVar, v vVar, ClassLoader classLoader, j jVar, t tVar) {
        this.f3153a = mVar;
        this.f3154b = vVar;
        Fragment a10 = jVar.a(classLoader, tVar.f3140g);
        this.f3155c = a10;
        Bundle bundle = tVar.f3149p;
        if (bundle != null) {
            bundle.setClassLoader(classLoader);
        }
        a10.setArguments(tVar.f3149p);
        a10.mWho = tVar.f3141h;
        a10.mFromLayout = tVar.f3142i;
        a10.mRestored = true;
        a10.mFragmentId = tVar.f3143j;
        a10.mContainerId = tVar.f3144k;
        a10.mTag = tVar.f3145l;
        a10.mRetainInstance = tVar.f3146m;
        a10.mRemoving = tVar.f3147n;
        a10.mDetached = tVar.f3148o;
        a10.mHidden = tVar.f3150q;
        a10.mMaxState = h.b.values()[tVar.f3151r];
        Bundle bundle2 = tVar.f3152s;
        a10.mSavedFragmentState = bundle2 == null ? new Bundle() : bundle2;
        if (n.F0(2)) {
            Log.v("FragmentManager", "Instantiated fragment " + a10);
        }
    }

    private boolean l(View view) {
        if (view == this.f3155c.mView) {
            return true;
        }
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            if (parent == this.f3155c.mView) {
                return true;
            }
        }
        return false;
    }

    private Bundle q() {
        Bundle bundle = new Bundle();
        this.f3155c.performSaveInstanceState(bundle);
        this.f3153a.j(this.f3155c, bundle, false);
        if (bundle.isEmpty()) {
            bundle = null;
        }
        if (this.f3155c.mView != null) {
            s();
        }
        if (this.f3155c.mSavedViewState != null) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putSparseParcelableArray("android:view_state", this.f3155c.mSavedViewState);
        }
        if (this.f3155c.mSavedViewRegistryState != null) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putBundle("android:view_registry_state", this.f3155c.mSavedViewRegistryState);
        }
        if (!this.f3155c.mUserVisibleHint) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putBoolean("android:user_visible_hint", this.f3155c.mUserVisibleHint);
        }
        return bundle;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void a() {
        if (n.F0(3)) {
            Log.d("FragmentManager", "moveto ACTIVITY_CREATED: " + this.f3155c);
        }
        Fragment fragment = this.f3155c;
        fragment.performActivityCreated(fragment.mSavedFragmentState);
        m mVar = this.f3153a;
        Fragment fragment2 = this.f3155c;
        mVar.a(fragment2, fragment2.mSavedFragmentState, false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void b() {
        int j10 = this.f3154b.j(this.f3155c);
        Fragment fragment = this.f3155c;
        fragment.mContainer.addView(fragment.mView, j10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c() {
        if (n.F0(3)) {
            Log.d("FragmentManager", "moveto ATTACHED: " + this.f3155c);
        }
        Fragment fragment = this.f3155c;
        Fragment fragment2 = fragment.mTarget;
        u uVar = null;
        if (fragment2 != null) {
            u m10 = this.f3154b.m(fragment2.mWho);
            if (m10 == null) {
                throw new IllegalStateException("Fragment " + this.f3155c + " declared target fragment " + this.f3155c.mTarget + " that does not belong to this FragmentManager!");
            }
            Fragment fragment3 = this.f3155c;
            fragment3.mTargetWho = fragment3.mTarget.mWho;
            fragment3.mTarget = null;
            uVar = m10;
        } else {
            String str = fragment.mTargetWho;
            if (str != null && (uVar = this.f3154b.m(str)) == null) {
                throw new IllegalStateException("Fragment " + this.f3155c + " declared target fragment " + this.f3155c.mTargetWho + " that does not belong to this FragmentManager!");
            }
        }
        if (uVar != null && (n.P || uVar.k().mState < 1)) {
            uVar.m();
        }
        Fragment fragment4 = this.f3155c;
        fragment4.mHost = fragment4.mFragmentManager.t0();
        Fragment fragment5 = this.f3155c;
        fragment5.mParentFragment = fragment5.mFragmentManager.w0();
        this.f3153a.g(this.f3155c, false);
        this.f3155c.performAttach();
        this.f3153a.b(this.f3155c, false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int d() {
        Fragment fragment;
        ViewGroup viewGroup;
        Fragment fragment2 = this.f3155c;
        if (fragment2.mFragmentManager == null) {
            return fragment2.mState;
        }
        int i10 = this.f3157e;
        int i11 = b.f3160a[fragment2.mMaxState.ordinal()];
        if (i11 != 1) {
            i10 = i11 != 2 ? i11 != 3 ? i11 != 4 ? Math.min(i10, -1) : Math.min(i10, 0) : Math.min(i10, 1) : Math.min(i10, 5);
        }
        Fragment fragment3 = this.f3155c;
        if (fragment3.mFromLayout) {
            if (fragment3.mInLayout) {
                i10 = Math.max(this.f3157e, 2);
                View view = this.f3155c.mView;
                if (view != null && view.getParent() == null) {
                    i10 = Math.min(i10, 2);
                }
            } else {
                i10 = this.f3157e < 4 ? Math.min(i10, fragment3.mState) : Math.min(i10, 1);
            }
        }
        if (!this.f3155c.mAdded) {
            i10 = Math.min(i10, 1);
        }
        c0.e.b bVar = null;
        if (n.P && (viewGroup = (fragment = this.f3155c).mContainer) != null) {
            bVar = c0.n(viewGroup, fragment.getParentFragmentManager()).l(this);
        }
        if (bVar == c0.e.b.ADDING) {
            i10 = Math.min(i10, 6);
        } else if (bVar == c0.e.b.REMOVING) {
            i10 = Math.max(i10, 3);
        } else {
            Fragment fragment4 = this.f3155c;
            if (fragment4.mRemoving) {
                i10 = fragment4.isInBackStack() ? Math.min(i10, 1) : Math.min(i10, -1);
            }
        }
        Fragment fragment5 = this.f3155c;
        if (fragment5.mDeferStart && fragment5.mState < 5) {
            i10 = Math.min(i10, 4);
        }
        if (n.F0(2)) {
            Log.v("FragmentManager", "computeExpectedState() of " + i10 + " for " + this.f3155c);
        }
        return i10;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void e() {
        if (n.F0(3)) {
            Log.d("FragmentManager", "moveto CREATED: " + this.f3155c);
        }
        Fragment fragment = this.f3155c;
        if (fragment.mIsCreated) {
            fragment.restoreChildFragmentState(fragment.mSavedFragmentState);
            this.f3155c.mState = 1;
            return;
        }
        this.f3153a.h(fragment, fragment.mSavedFragmentState, false);
        Fragment fragment2 = this.f3155c;
        fragment2.performCreate(fragment2.mSavedFragmentState);
        m mVar = this.f3153a;
        Fragment fragment3 = this.f3155c;
        mVar.c(fragment3, fragment3.mSavedFragmentState, false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void f() {
        String str;
        if (this.f3155c.mFromLayout) {
            return;
        }
        if (n.F0(3)) {
            Log.d("FragmentManager", "moveto CREATE_VIEW: " + this.f3155c);
        }
        Fragment fragment = this.f3155c;
        LayoutInflater performGetLayoutInflater = fragment.performGetLayoutInflater(fragment.mSavedFragmentState);
        ViewGroup viewGroup = null;
        Fragment fragment2 = this.f3155c;
        ViewGroup viewGroup2 = fragment2.mContainer;
        if (viewGroup2 != null) {
            viewGroup = viewGroup2;
        } else {
            int i10 = fragment2.mContainerId;
            if (i10 != 0) {
                if (i10 == -1) {
                    throw new IllegalArgumentException("Cannot create fragment " + this.f3155c + " for a container view with no id");
                }
                viewGroup = (ViewGroup) fragment2.mFragmentManager.o0().c(this.f3155c.mContainerId);
                if (viewGroup == null) {
                    Fragment fragment3 = this.f3155c;
                    if (!fragment3.mRestored) {
                        try {
                            str = fragment3.getResources().getResourceName(this.f3155c.mContainerId);
                        } catch (Resources.NotFoundException unused) {
                            str = "unknown";
                        }
                        throw new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(this.f3155c.mContainerId) + " (" + str + ") for fragment " + this.f3155c);
                    }
                }
            }
        }
        Fragment fragment4 = this.f3155c;
        fragment4.mContainer = viewGroup;
        fragment4.performCreateView(performGetLayoutInflater, viewGroup, fragment4.mSavedFragmentState);
        View view = this.f3155c.mView;
        if (view != null) {
            boolean z9 = false;
            view.setSaveFromParentEnabled(false);
            Fragment fragment5 = this.f3155c;
            fragment5.mView.setTag(k0.b.fragment_container_view_tag, fragment5);
            if (viewGroup != null) {
                b();
            }
            Fragment fragment6 = this.f3155c;
            if (fragment6.mHidden) {
                fragment6.mView.setVisibility(8);
            }
            if (r0.Q(this.f3155c.mView)) {
                r0.k0(this.f3155c.mView);
            } else {
                View view2 = this.f3155c.mView;
                view2.addOnAttachStateChangeListener(new a(view2));
            }
            this.f3155c.performViewCreated();
            m mVar = this.f3153a;
            Fragment fragment7 = this.f3155c;
            mVar.m(fragment7, fragment7.mView, fragment7.mSavedFragmentState, false);
            int visibility = this.f3155c.mView.getVisibility();
            float alpha = this.f3155c.mView.getAlpha();
            if (n.P) {
                this.f3155c.setPostOnViewCreatedAlpha(alpha);
                Fragment fragment8 = this.f3155c;
                if (fragment8.mContainer != null && visibility == 0) {
                    View findFocus = fragment8.mView.findFocus();
                    if (findFocus != null) {
                        this.f3155c.setFocusedView(findFocus);
                        if (n.F0(2)) {
                            Log.v("FragmentManager", "requestFocus: Saved focused view " + findFocus + " for Fragment " + this.f3155c);
                        }
                    }
                    this.f3155c.mView.setAlpha(0.0f);
                }
            } else {
                Fragment fragment9 = this.f3155c;
                if (visibility == 0 && fragment9.mContainer != null) {
                    z9 = true;
                }
                fragment9.mIsNewlyAdded = z9;
            }
        }
        this.f3155c.mState = 2;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void g() {
        Fragment f10;
        if (n.F0(3)) {
            Log.d("FragmentManager", "movefrom CREATED: " + this.f3155c);
        }
        Fragment fragment = this.f3155c;
        boolean z9 = true;
        boolean z10 = fragment.mRemoving && !fragment.isInBackStack();
        if (!(z10 || this.f3154b.o().p(this.f3155c))) {
            String str = this.f3155c.mTargetWho;
            if (str != null && (f10 = this.f3154b.f(str)) != null && f10.mRetainInstance) {
                this.f3155c.mTarget = f10;
            }
            this.f3155c.mState = 0;
            return;
        }
        k kVar = this.f3155c.mHost;
        if (kVar instanceof l0) {
            z9 = this.f3154b.o().m();
        } else if (kVar.f() instanceof Activity) {
            z9 = true ^ ((Activity) kVar.f()).isChangingConfigurations();
        }
        if (z10 || z9) {
            this.f3154b.o().g(this.f3155c);
        }
        this.f3155c.performDestroy();
        this.f3153a.d(this.f3155c, false);
        for (u uVar : this.f3154b.k()) {
            if (uVar != null) {
                Fragment k10 = uVar.k();
                if (this.f3155c.mWho.equals(k10.mTargetWho)) {
                    k10.mTarget = this.f3155c;
                    k10.mTargetWho = null;
                }
            }
        }
        Fragment fragment2 = this.f3155c;
        String str2 = fragment2.mTargetWho;
        if (str2 != null) {
            fragment2.mTarget = this.f3154b.f(str2);
        }
        this.f3154b.q(this);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void h() {
        View view;
        if (n.F0(3)) {
            Log.d("FragmentManager", "movefrom CREATE_VIEW: " + this.f3155c);
        }
        Fragment fragment = this.f3155c;
        ViewGroup viewGroup = fragment.mContainer;
        if (viewGroup != null && (view = fragment.mView) != null) {
            viewGroup.removeView(view);
        }
        this.f3155c.performDestroyView();
        this.f3153a.n(this.f3155c, false);
        Fragment fragment2 = this.f3155c;
        fragment2.mContainer = null;
        fragment2.mView = null;
        fragment2.mViewLifecycleOwner = null;
        fragment2.mViewLifecycleOwnerLiveData.j(null);
        this.f3155c.mInLayout = false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void i() {
        if (n.F0(3)) {
            Log.d("FragmentManager", "movefrom ATTACHED: " + this.f3155c);
        }
        this.f3155c.performDetach();
        boolean z9 = false;
        this.f3153a.e(this.f3155c, false);
        Fragment fragment = this.f3155c;
        fragment.mState = -1;
        fragment.mHost = null;
        fragment.mParentFragment = null;
        fragment.mFragmentManager = null;
        if (fragment.mRemoving && !fragment.isInBackStack()) {
            z9 = true;
        }
        if (z9 || this.f3154b.o().p(this.f3155c)) {
            if (n.F0(3)) {
                Log.d("FragmentManager", "initState called for fragment: " + this.f3155c);
            }
            this.f3155c.initState();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void j() {
        Fragment fragment = this.f3155c;
        if (fragment.mFromLayout && fragment.mInLayout && !fragment.mPerformedCreateView) {
            if (n.F0(3)) {
                Log.d("FragmentManager", "moveto CREATE_VIEW: " + this.f3155c);
            }
            Fragment fragment2 = this.f3155c;
            fragment2.performCreateView(fragment2.performGetLayoutInflater(fragment2.mSavedFragmentState), null, this.f3155c.mSavedFragmentState);
            View view = this.f3155c.mView;
            if (view != null) {
                view.setSaveFromParentEnabled(false);
                Fragment fragment3 = this.f3155c;
                fragment3.mView.setTag(k0.b.fragment_container_view_tag, fragment3);
                Fragment fragment4 = this.f3155c;
                if (fragment4.mHidden) {
                    fragment4.mView.setVisibility(8);
                }
                this.f3155c.performViewCreated();
                m mVar = this.f3153a;
                Fragment fragment5 = this.f3155c;
                mVar.m(fragment5, fragment5.mView, fragment5.mSavedFragmentState, false);
                this.f3155c.mState = 2;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Fragment k() {
        return this.f3155c;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void m() {
        ViewGroup viewGroup;
        ViewGroup viewGroup2;
        ViewGroup viewGroup3;
        if (this.f3156d) {
            if (n.F0(2)) {
                Log.v("FragmentManager", "Ignoring re-entrant call to moveToExpectedState() for " + k());
                return;
            }
            return;
        }
        try {
            this.f3156d = true;
            while (true) {
                int d10 = d();
                Fragment fragment = this.f3155c;
                int i10 = fragment.mState;
                if (d10 == i10) {
                    if (n.P && fragment.mHiddenChanged) {
                        if (fragment.mView != null && (viewGroup = fragment.mContainer) != null) {
                            c0 n10 = c0.n(viewGroup, fragment.getParentFragmentManager());
                            if (this.f3155c.mHidden) {
                                n10.c(this);
                            } else {
                                n10.e(this);
                            }
                        }
                        Fragment fragment2 = this.f3155c;
                        n nVar = fragment2.mFragmentManager;
                        if (nVar != null) {
                            nVar.D0(fragment2);
                        }
                        Fragment fragment3 = this.f3155c;
                        fragment3.mHiddenChanged = false;
                        fragment3.onHiddenChanged(fragment3.mHidden);
                    }
                    return;
                } else if (d10 > i10) {
                    switch (i10 + 1) {
                        case 0:
                            c();
                            continue;
                        case 1:
                            e();
                            continue;
                        case 2:
                            j();
                            f();
                            continue;
                        case 3:
                            a();
                            continue;
                        case 4:
                            if (fragment.mView != null && (viewGroup2 = fragment.mContainer) != null) {
                                c0.n(viewGroup2, fragment.getParentFragmentManager()).b(c0.e.c.g(this.f3155c.mView.getVisibility()), this);
                            }
                            this.f3155c.mState = 4;
                            continue;
                        case 5:
                            u();
                            continue;
                        case 6:
                            fragment.mState = 6;
                            continue;
                        case 7:
                            p();
                            continue;
                        default:
                            continue;
                    }
                } else {
                    switch (i10 - 1) {
                        case -1:
                            i();
                            continue;
                        case 0:
                            g();
                            continue;
                        case 1:
                            h();
                            this.f3155c.mState = 1;
                            continue;
                        case 2:
                            fragment.mInLayout = false;
                            fragment.mState = 2;
                            continue;
                        case 3:
                            if (n.F0(3)) {
                                Log.d("FragmentManager", "movefrom ACTIVITY_CREATED: " + this.f3155c);
                            }
                            Fragment fragment4 = this.f3155c;
                            if (fragment4.mView != null && fragment4.mSavedViewState == null) {
                                s();
                            }
                            Fragment fragment5 = this.f3155c;
                            if (fragment5.mView != null && (viewGroup3 = fragment5.mContainer) != null) {
                                c0.n(viewGroup3, fragment5.getParentFragmentManager()).d(this);
                            }
                            this.f3155c.mState = 3;
                            continue;
                        case 4:
                            v();
                            continue;
                        case 5:
                            fragment.mState = 5;
                            continue;
                        case 6:
                            n();
                            continue;
                        default:
                            continue;
                    }
                }
            }
        } finally {
            this.f3156d = false;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void n() {
        if (n.F0(3)) {
            Log.d("FragmentManager", "movefrom RESUMED: " + this.f3155c);
        }
        this.f3155c.performPause();
        this.f3153a.f(this.f3155c, false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void o(ClassLoader classLoader) {
        Bundle bundle = this.f3155c.mSavedFragmentState;
        if (bundle == null) {
            return;
        }
        bundle.setClassLoader(classLoader);
        Fragment fragment = this.f3155c;
        fragment.mSavedViewState = fragment.mSavedFragmentState.getSparseParcelableArray("android:view_state");
        Fragment fragment2 = this.f3155c;
        fragment2.mSavedViewRegistryState = fragment2.mSavedFragmentState.getBundle("android:view_registry_state");
        Fragment fragment3 = this.f3155c;
        fragment3.mTargetWho = fragment3.mSavedFragmentState.getString("android:target_state");
        Fragment fragment4 = this.f3155c;
        if (fragment4.mTargetWho != null) {
            fragment4.mTargetRequestCode = fragment4.mSavedFragmentState.getInt("android:target_req_state", 0);
        }
        Fragment fragment5 = this.f3155c;
        Boolean bool = fragment5.mSavedUserVisibleHint;
        if (bool != null) {
            fragment5.mUserVisibleHint = bool.booleanValue();
            this.f3155c.mSavedUserVisibleHint = null;
        } else {
            fragment5.mUserVisibleHint = fragment5.mSavedFragmentState.getBoolean("android:user_visible_hint", true);
        }
        Fragment fragment6 = this.f3155c;
        if (fragment6.mUserVisibleHint) {
            return;
        }
        fragment6.mDeferStart = true;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void p() {
        if (n.F0(3)) {
            Log.d("FragmentManager", "moveto RESUMED: " + this.f3155c);
        }
        View focusedView = this.f3155c.getFocusedView();
        if (focusedView != null && l(focusedView)) {
            boolean requestFocus = focusedView.requestFocus();
            if (n.F0(2)) {
                StringBuilder sb = new StringBuilder();
                sb.append("requestFocus: Restoring focused view ");
                sb.append(focusedView);
                sb.append(" ");
                sb.append(requestFocus ? "succeeded" : "failed");
                sb.append(" on Fragment ");
                sb.append(this.f3155c);
                sb.append(" resulting in focused view ");
                sb.append(this.f3155c.mView.findFocus());
                Log.v("FragmentManager", sb.toString());
            }
        }
        this.f3155c.setFocusedView(null);
        this.f3155c.performResume();
        this.f3153a.i(this.f3155c, false);
        Fragment fragment = this.f3155c;
        fragment.mSavedFragmentState = null;
        fragment.mSavedViewState = null;
        fragment.mSavedViewRegistryState = null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public t r() {
        t tVar = new t(this.f3155c);
        Fragment fragment = this.f3155c;
        if (fragment.mState <= -1 || tVar.f3152s != null) {
            tVar.f3152s = fragment.mSavedFragmentState;
        } else {
            Bundle q10 = q();
            tVar.f3152s = q10;
            if (this.f3155c.mTargetWho != null) {
                if (q10 == null) {
                    tVar.f3152s = new Bundle();
                }
                tVar.f3152s.putString("android:target_state", this.f3155c.mTargetWho);
                int i10 = this.f3155c.mTargetRequestCode;
                if (i10 != 0) {
                    tVar.f3152s.putInt("android:target_req_state", i10);
                }
            }
        }
        return tVar;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void s() {
        if (this.f3155c.mView == null) {
            return;
        }
        SparseArray<Parcelable> sparseArray = new SparseArray<>();
        this.f3155c.mView.saveHierarchyState(sparseArray);
        if (sparseArray.size() > 0) {
            this.f3155c.mSavedViewState = sparseArray;
        }
        Bundle bundle = new Bundle();
        this.f3155c.mViewLifecycleOwner.e(bundle);
        if (bundle.isEmpty()) {
            return;
        }
        this.f3155c.mSavedViewRegistryState = bundle;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void t(int i10) {
        this.f3157e = i10;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void u() {
        if (n.F0(3)) {
            Log.d("FragmentManager", "moveto STARTED: " + this.f3155c);
        }
        this.f3155c.performStart();
        this.f3153a.k(this.f3155c, false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void v() {
        if (n.F0(3)) {
            Log.d("FragmentManager", "movefrom STARTED: " + this.f3155c);
        }
        this.f3155c.performStop();
        this.f3153a.l(this.f3155c, false);
    }
}
