package androidx.fragment.app;

import android.util.Log;
import androidx.lifecycle.g0;
import androidx.lifecycle.h0;
import androidx.lifecycle.i0;
import androidx.lifecycle.k0;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public final class q extends g0 {

    /* renamed from: k  reason: collision with root package name */
    private static final h0.b f3132k = new a();

    /* renamed from: g  reason: collision with root package name */
    private final boolean f3136g;

    /* renamed from: d  reason: collision with root package name */
    private final HashMap f3133d = new HashMap();

    /* renamed from: e  reason: collision with root package name */
    private final HashMap f3134e = new HashMap();

    /* renamed from: f  reason: collision with root package name */
    private final HashMap f3135f = new HashMap();

    /* renamed from: h  reason: collision with root package name */
    private boolean f3137h = false;

    /* renamed from: i  reason: collision with root package name */
    private boolean f3138i = false;

    /* renamed from: j  reason: collision with root package name */
    private boolean f3139j = false;

    /* loaded from: classes.dex */
    class a implements h0.b {
        a() {
        }

        @Override // androidx.lifecycle.h0.b
        public /* synthetic */ g0 a(Class cls, o0.a aVar) {
            return i0.b(this, cls, aVar);
        }

        @Override // androidx.lifecycle.h0.b
        public g0 b(Class cls) {
            return new q(true);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public q(boolean z9) {
        this.f3136g = z9;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static q j(k0 k0Var) {
        return (q) new h0(k0Var, f3132k).a(q.class);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.lifecycle.g0
    public void d() {
        if (n.F0(3)) {
            Log.d("FragmentManager", "onCleared called for " + this);
        }
        this.f3137h = true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || q.class != obj.getClass()) {
            return false;
        }
        q qVar = (q) obj;
        return this.f3133d.equals(qVar.f3133d) && this.f3134e.equals(qVar.f3134e) && this.f3135f.equals(qVar.f3135f);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void f(Fragment fragment) {
        if (this.f3139j) {
            if (n.F0(2)) {
                Log.v("FragmentManager", "Ignoring addRetainedFragment as the state is already saved");
            }
        } else if (this.f3133d.containsKey(fragment.mWho)) {
        } else {
            this.f3133d.put(fragment.mWho, fragment);
            if (n.F0(2)) {
                Log.v("FragmentManager", "Updating retained Fragments: Added " + fragment);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void g(Fragment fragment) {
        if (n.F0(3)) {
            Log.d("FragmentManager", "Clearing non-config state for " + fragment);
        }
        q qVar = (q) this.f3134e.get(fragment.mWho);
        if (qVar != null) {
            qVar.d();
            this.f3134e.remove(fragment.mWho);
        }
        k0 k0Var = (k0) this.f3135f.get(fragment.mWho);
        if (k0Var != null) {
            k0Var.a();
            this.f3135f.remove(fragment.mWho);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Fragment h(String str) {
        return (Fragment) this.f3133d.get(str);
    }

    public int hashCode() {
        return (((this.f3133d.hashCode() * 31) + this.f3134e.hashCode()) * 31) + this.f3135f.hashCode();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public q i(Fragment fragment) {
        q qVar = (q) this.f3134e.get(fragment.mWho);
        if (qVar == null) {
            q qVar2 = new q(this.f3136g);
            this.f3134e.put(fragment.mWho, qVar2);
            return qVar2;
        }
        return qVar;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Collection k() {
        return new ArrayList(this.f3133d.values());
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public k0 l(Fragment fragment) {
        k0 k0Var = (k0) this.f3135f.get(fragment.mWho);
        if (k0Var == null) {
            k0 k0Var2 = new k0();
            this.f3135f.put(fragment.mWho, k0Var2);
            return k0Var2;
        }
        return k0Var;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean m() {
        return this.f3137h;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void n(Fragment fragment) {
        if (this.f3139j) {
            if (n.F0(2)) {
                Log.v("FragmentManager", "Ignoring removeRetainedFragment as the state is already saved");
                return;
            }
            return;
        }
        if ((this.f3133d.remove(fragment.mWho) != null) && n.F0(2)) {
            Log.v("FragmentManager", "Updating retained Fragments: Removed " + fragment);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void o(boolean z9) {
        this.f3139j = z9;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean p(Fragment fragment) {
        if (this.f3133d.containsKey(fragment.mWho)) {
            return this.f3136g ? this.f3137h : !this.f3138i;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FragmentManagerViewModel{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("} Fragments (");
        Iterator it = this.f3133d.values().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (it.hasNext()) {
                sb.append(", ");
            }
        }
        sb.append(") Child Non Config (");
        Iterator it2 = this.f3134e.keySet().iterator();
        while (it2.hasNext()) {
            sb.append((String) it2.next());
            if (it2.hasNext()) {
                sb.append(", ");
            }
        }
        sb.append(") ViewModelStores (");
        Iterator it3 = this.f3135f.keySet().iterator();
        while (it3.hasNext()) {
            sb.append((String) it3.next());
            if (it3.hasNext()) {
                sb.append(", ");
            }
        }
        sb.append(')');
        return sb.toString();
    }
}
