package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import androidx.activity.OnBackPressedDispatcher;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.f;
import androidx.fragment.app.w;
import androidx.fragment.app.x;
import androidx.lifecycle.h;
import androidx.lifecycle.k0;
import androidx.lifecycle.l0;
import e.g;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
/* loaded from: classes.dex */
public abstract class n {
    private static boolean O = false;
    static boolean P = true;
    private e.c A;
    private e.c B;
    private boolean D;
    private boolean E;
    private boolean F;
    private boolean G;
    private boolean H;
    private ArrayList I;
    private ArrayList J;
    private ArrayList K;
    private ArrayList L;
    private q M;

    /* renamed from: b  reason: collision with root package name */
    private boolean f3076b;

    /* renamed from: d  reason: collision with root package name */
    ArrayList f3078d;

    /* renamed from: e  reason: collision with root package name */
    private ArrayList f3079e;

    /* renamed from: g  reason: collision with root package name */
    private OnBackPressedDispatcher f3081g;

    /* renamed from: l  reason: collision with root package name */
    private ArrayList f3086l;

    /* renamed from: r  reason: collision with root package name */
    private androidx.fragment.app.k f3092r;

    /* renamed from: s  reason: collision with root package name */
    private androidx.fragment.app.g f3093s;

    /* renamed from: t  reason: collision with root package name */
    private Fragment f3094t;

    /* renamed from: u  reason: collision with root package name */
    Fragment f3095u;

    /* renamed from: z  reason: collision with root package name */
    private e.c f3100z;

    /* renamed from: a  reason: collision with root package name */
    private final ArrayList f3075a = new ArrayList();

    /* renamed from: c  reason: collision with root package name */
    private final v f3077c = new v();

    /* renamed from: f  reason: collision with root package name */
    private final androidx.fragment.app.l f3080f = new androidx.fragment.app.l(this);

    /* renamed from: h  reason: collision with root package name */
    private final androidx.activity.t f3082h = new c(false);

    /* renamed from: i  reason: collision with root package name */
    private final AtomicInteger f3083i = new AtomicInteger();

    /* renamed from: j  reason: collision with root package name */
    private final Map f3084j = Collections.synchronizedMap(new HashMap());

    /* renamed from: k  reason: collision with root package name */
    private final Map f3085k = Collections.synchronizedMap(new HashMap());

    /* renamed from: m  reason: collision with root package name */
    private Map f3087m = Collections.synchronizedMap(new HashMap());

    /* renamed from: n  reason: collision with root package name */
    private final x.g f3088n = new d();

    /* renamed from: o  reason: collision with root package name */
    private final androidx.fragment.app.m f3089o = new androidx.fragment.app.m(this);

    /* renamed from: p  reason: collision with root package name */
    private final CopyOnWriteArrayList f3090p = new CopyOnWriteArrayList();

    /* renamed from: q  reason: collision with root package name */
    int f3091q = -1;

    /* renamed from: v  reason: collision with root package name */
    private androidx.fragment.app.j f3096v = null;

    /* renamed from: w  reason: collision with root package name */
    private androidx.fragment.app.j f3097w = new e();

    /* renamed from: x  reason: collision with root package name */
    private d0 f3098x = null;

    /* renamed from: y  reason: collision with root package name */
    private d0 f3099y = new f();
    ArrayDeque C = new ArrayDeque();
    private Runnable N = new g();

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements e.b {
        a() {
        }

        @Override // e.b
        /* renamed from: b */
        public void a(e.a aVar) {
            l lVar = (l) n.this.C.pollFirst();
            if (lVar == null) {
                Log.w("FragmentManager", "No IntentSenders were started for " + this);
                return;
            }
            String str = lVar.f3115g;
            int i10 = lVar.f3116h;
            Fragment i11 = n.this.f3077c.i(str);
            if (i11 != null) {
                i11.onActivityResult(i10, aVar.c(), aVar.a());
                return;
            }
            Log.w("FragmentManager", "Intent Sender result delivered for unknown Fragment " + str);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b implements e.b {
        b() {
        }

        @Override // e.b
        /* renamed from: b */
        public void a(Map map) {
            StringBuilder sb;
            String[] strArr = (String[]) map.keySet().toArray(new String[0]);
            ArrayList arrayList = new ArrayList(map.values());
            int[] iArr = new int[arrayList.size()];
            for (int i10 = 0; i10 < arrayList.size(); i10++) {
                iArr[i10] = ((Boolean) arrayList.get(i10)).booleanValue() ? 0 : -1;
            }
            l lVar = (l) n.this.C.pollFirst();
            if (lVar == null) {
                sb = new StringBuilder();
                sb.append("No permissions were requested for ");
                sb.append(this);
            } else {
                String str = lVar.f3115g;
                int i11 = lVar.f3116h;
                Fragment i12 = n.this.f3077c.i(str);
                if (i12 != null) {
                    i12.onRequestPermissionsResult(i11, strArr, iArr);
                    return;
                }
                sb = new StringBuilder();
                sb.append("Permission request result delivered for unknown Fragment ");
                sb.append(str);
            }
            Log.w("FragmentManager", sb.toString());
        }
    }

    /* loaded from: classes.dex */
    class c extends androidx.activity.t {
        c(boolean z9) {
            super(z9);
        }

        @Override // androidx.activity.t
        public void handleOnBackPressed() {
            n.this.B0();
        }
    }

    /* loaded from: classes.dex */
    class d implements x.g {
        d() {
        }

        @Override // androidx.fragment.app.x.g
        public void a(Fragment fragment, androidx.core.os.e eVar) {
            if (eVar.b()) {
                return;
            }
            n.this.b1(fragment, eVar);
        }

        @Override // androidx.fragment.app.x.g
        public void b(Fragment fragment, androidx.core.os.e eVar) {
            n.this.f(fragment, eVar);
        }
    }

    /* loaded from: classes.dex */
    class e extends androidx.fragment.app.j {
        e() {
        }

        @Override // androidx.fragment.app.j
        public Fragment a(ClassLoader classLoader, String str) {
            return n.this.t0().b(n.this.t0().f(), str, null);
        }
    }

    /* loaded from: classes.dex */
    class f implements d0 {
        f() {
        }

        @Override // androidx.fragment.app.d0
        public c0 a(ViewGroup viewGroup) {
            return new androidx.fragment.app.c(viewGroup);
        }
    }

    /* loaded from: classes.dex */
    class g implements Runnable {
        g() {
        }

        @Override // java.lang.Runnable
        public void run() {
            n.this.b0(true);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class h extends AnimatorListenerAdapter {

        /* renamed from: a  reason: collision with root package name */
        final /* synthetic */ ViewGroup f3108a;

        /* renamed from: b  reason: collision with root package name */
        final /* synthetic */ View f3109b;

        /* renamed from: c  reason: collision with root package name */
        final /* synthetic */ Fragment f3110c;

        h(ViewGroup viewGroup, View view, Fragment fragment) {
            this.f3108a = viewGroup;
            this.f3109b = view;
            this.f3110c = fragment;
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationEnd(Animator animator) {
            this.f3108a.endViewTransition(this.f3109b);
            animator.removeListener(this);
            Fragment fragment = this.f3110c;
            View view = fragment.mView;
            if (view == null || !fragment.mHidden) {
                return;
            }
            view.setVisibility(8);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class i implements r {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ Fragment f3112g;

        i(Fragment fragment) {
            this.f3112g = fragment;
        }

        @Override // androidx.fragment.app.r
        public void a(n nVar, Fragment fragment) {
            this.f3112g.onAttachFragment(fragment);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class j implements e.b {
        j() {
        }

        @Override // e.b
        /* renamed from: b */
        public void a(e.a aVar) {
            l lVar = (l) n.this.C.pollFirst();
            if (lVar == null) {
                Log.w("FragmentManager", "No Activities were started for result for " + this);
                return;
            }
            String str = lVar.f3115g;
            int i10 = lVar.f3116h;
            Fragment i11 = n.this.f3077c.i(str);
            if (i11 != null) {
                i11.onActivityResult(i10, aVar.c(), aVar.a());
                return;
            }
            Log.w("FragmentManager", "Activity result delivered for unknown Fragment " + str);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class k extends f.a {
        k() {
        }

        @Override // f.a
        /* renamed from: d */
        public Intent a(Context context, e.g gVar) {
            Bundle bundleExtra;
            Intent intent = new Intent("androidx.activity.result.contract.action.INTENT_SENDER_REQUEST");
            Intent a10 = gVar.a();
            if (a10 != null && (bundleExtra = a10.getBundleExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE")) != null) {
                intent.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", bundleExtra);
                a10.removeExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE");
                if (a10.getBooleanExtra("androidx.fragment.extra.ACTIVITY_OPTIONS_BUNDLE", false)) {
                    gVar = new g.a(gVar.e()).b(null).c(gVar.d(), gVar.c()).a();
                }
            }
            intent.putExtra("androidx.activity.result.contract.extra.INTENT_SENDER_REQUEST", gVar);
            if (n.F0(2)) {
                Log.v("FragmentManager", "CreateIntent created the following intent: " + intent);
            }
            return intent;
        }

        @Override // f.a
        /* renamed from: e */
        public e.a c(int i10, Intent intent) {
            return new e.a(i10, intent);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class l implements Parcelable {
        public static final Parcelable.Creator<l> CREATOR = new a();

        /* renamed from: g  reason: collision with root package name */
        String f3115g;

        /* renamed from: h  reason: collision with root package name */
        int f3116h;

        /* loaded from: classes.dex */
        class a implements Parcelable.Creator {
            a() {
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: a */
            public l createFromParcel(Parcel parcel) {
                return new l(parcel);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: b */
            public l[] newArray(int i10) {
                return new l[i10];
            }
        }

        l(Parcel parcel) {
            this.f3115g = parcel.readString();
            this.f3116h = parcel.readInt();
        }

        l(String str, int i10) {
            this.f3115g = str;
            this.f3116h = i10;
        }

        @Override // android.os.Parcelable
        public int describeContents() {
            return 0;
        }

        @Override // android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i10) {
            parcel.writeString(this.f3115g);
            parcel.writeInt(this.f3116h);
        }
    }

    /* loaded from: classes.dex */
    public interface m {
        void onBackStackChanged();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: androidx.fragment.app.n$n  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public interface InterfaceC0034n {
        boolean a(ArrayList arrayList, ArrayList arrayList2);
    }

    /* loaded from: classes.dex */
    private class o implements InterfaceC0034n {

        /* renamed from: a  reason: collision with root package name */
        final String f3117a;

        /* renamed from: b  reason: collision with root package name */
        final int f3118b;

        /* renamed from: c  reason: collision with root package name */
        final int f3119c;

        o(String str, int i10, int i11) {
            this.f3117a = str;
            this.f3118b = i10;
            this.f3119c = i11;
        }

        @Override // androidx.fragment.app.n.InterfaceC0034n
        public boolean a(ArrayList arrayList, ArrayList arrayList2) {
            Fragment fragment = n.this.f3095u;
            if (fragment == null || this.f3118b >= 0 || this.f3117a != null || !fragment.getChildFragmentManager().X0()) {
                return n.this.Z0(arrayList, arrayList2, this.f3117a, this.f3118b, this.f3119c);
            }
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class p implements Fragment.l {

        /* renamed from: a  reason: collision with root package name */
        final boolean f3121a;

        /* renamed from: b  reason: collision with root package name */
        final androidx.fragment.app.a f3122b;

        /* renamed from: c  reason: collision with root package name */
        private int f3123c;

        p(androidx.fragment.app.a aVar, boolean z9) {
            this.f3121a = z9;
            this.f3122b = aVar;
        }

        @Override // androidx.fragment.app.Fragment.l
        public void a() {
            this.f3123c++;
        }

        @Override // androidx.fragment.app.Fragment.l
        public void b() {
            int i10 = this.f3123c - 1;
            this.f3123c = i10;
            if (i10 != 0) {
                return;
            }
            this.f3122b.f2922t.j1();
        }

        void c() {
            androidx.fragment.app.a aVar = this.f3122b;
            aVar.f2922t.u(aVar, this.f3121a, false, false);
        }

        void d() {
            boolean z9 = this.f3123c > 0;
            for (Fragment fragment : this.f3122b.f2922t.s0()) {
                fragment.setOnStartEnterTransitionListener(null);
                if (z9 && fragment.isPostponed()) {
                    fragment.startPostponedEnterTransition();
                }
            }
            androidx.fragment.app.a aVar = this.f3122b;
            aVar.f2922t.u(aVar, this.f3121a, !z9, true);
        }

        public boolean e() {
            return this.f3123c == 0;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean F0(int i10) {
        return O || Log.isLoggable("FragmentManager", i10);
    }

    private boolean G0(Fragment fragment) {
        return (fragment.mHasMenu && fragment.mMenuVisible) || fragment.mChildFragmentManager.o();
    }

    private void M(Fragment fragment) {
        if (fragment == null || !fragment.equals(g0(fragment.mWho))) {
            return;
        }
        fragment.performPrimaryNavigationFragmentChanged();
    }

    private void O0(o.b bVar) {
        int size = bVar.size();
        for (int i10 = 0; i10 < size; i10++) {
            Fragment fragment = (Fragment) bVar.p(i10);
            if (!fragment.mAdded) {
                View requireView = fragment.requireView();
                fragment.mPostponedAlpha = requireView.getAlpha();
                requireView.setAlpha(0.0f);
            }
        }
    }

    private void T(int i10) {
        try {
            this.f3076b = true;
            this.f3077c.d(i10);
            Q0(i10, false);
            if (P) {
                for (c0 c0Var : s()) {
                    c0Var.j();
                }
            }
            this.f3076b = false;
            b0(true);
        } catch (Throwable th) {
            this.f3076b = false;
            throw th;
        }
    }

    private void W() {
        if (this.H) {
            this.H = false;
            p1();
        }
    }

    private void Y() {
        if (P) {
            for (c0 c0Var : s()) {
                c0Var.j();
            }
        } else if (!this.f3087m.isEmpty()) {
            for (Fragment fragment : this.f3087m.keySet()) {
                n(fragment);
                R0(fragment);
            }
        }
    }

    private boolean Y0(String str, int i10, int i11) {
        b0(false);
        a0(true);
        Fragment fragment = this.f3095u;
        if (fragment == null || i10 >= 0 || str != null || !fragment.getChildFragmentManager().X0()) {
            boolean Z0 = Z0(this.I, this.J, str, i10, i11);
            if (Z0) {
                this.f3076b = true;
                try {
                    d1(this.I, this.J);
                } finally {
                    q();
                }
            }
            q1();
            W();
            this.f3077c.b();
            return Z0;
        }
        return true;
    }

    private void a0(boolean z9) {
        if (this.f3076b) {
            throw new IllegalStateException("FragmentManager is already executing transactions");
        }
        if (this.f3092r == null) {
            if (!this.G) {
                throw new IllegalStateException("FragmentManager has not been attached to a host.");
            }
            throw new IllegalStateException("FragmentManager has been destroyed");
        } else if (Looper.myLooper() != this.f3092r.g().getLooper()) {
            throw new IllegalStateException("Must be called from main thread of fragment host");
        } else {
            if (!z9) {
                p();
            }
            if (this.I == null) {
                this.I = new ArrayList();
                this.J = new ArrayList();
            }
            this.f3076b = true;
            try {
                f0(null, null);
            } finally {
                this.f3076b = false;
            }
        }
    }

    private int a1(ArrayList arrayList, ArrayList arrayList2, int i10, int i11, o.b bVar) {
        int i12 = i11;
        for (int i13 = i11 - 1; i13 >= i10; i13--) {
            androidx.fragment.app.a aVar = (androidx.fragment.app.a) arrayList.get(i13);
            boolean booleanValue = ((Boolean) arrayList2.get(i13)).booleanValue();
            if (aVar.A() && !aVar.y(arrayList, i13 + 1, i11)) {
                if (this.L == null) {
                    this.L = new ArrayList();
                }
                p pVar = new p(aVar, booleanValue);
                this.L.add(pVar);
                aVar.C(pVar);
                if (booleanValue) {
                    aVar.t();
                } else {
                    aVar.u(false);
                }
                i12--;
                if (i13 != i12) {
                    arrayList.remove(i13);
                    arrayList.add(i12, aVar);
                }
                d(bVar);
            }
        }
        return i12;
    }

    private void d(o.b bVar) {
        int i10 = this.f3091q;
        if (i10 < 1) {
            return;
        }
        int min = Math.min(i10, 5);
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment.mState < min) {
                S0(fragment, min);
                if (fragment.mView != null && !fragment.mHidden && fragment.mIsNewlyAdded) {
                    bVar.add(fragment);
                }
            }
        }
    }

    private static void d0(ArrayList arrayList, ArrayList arrayList2, int i10, int i11) {
        while (i10 < i11) {
            androidx.fragment.app.a aVar = (androidx.fragment.app.a) arrayList.get(i10);
            if (((Boolean) arrayList2.get(i10)).booleanValue()) {
                aVar.p(-1);
                aVar.u(i10 == i11 + (-1));
            } else {
                aVar.p(1);
                aVar.t();
            }
            i10++;
        }
    }

    private void d1(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList.isEmpty()) {
            return;
        }
        if (arrayList.size() != arrayList2.size()) {
            throw new IllegalStateException("Internal error with the back stack records");
        }
        f0(arrayList, arrayList2);
        int size = arrayList.size();
        int i10 = 0;
        int i11 = 0;
        while (i10 < size) {
            if (!((androidx.fragment.app.a) arrayList.get(i10)).f3181r) {
                if (i11 != i10) {
                    e0(arrayList, arrayList2, i11, i10);
                }
                i11 = i10 + 1;
                if (((Boolean) arrayList2.get(i10)).booleanValue()) {
                    while (i11 < size && ((Boolean) arrayList2.get(i11)).booleanValue() && !((androidx.fragment.app.a) arrayList.get(i11)).f3181r) {
                        i11++;
                    }
                }
                e0(arrayList, arrayList2, i10, i11);
                i10 = i11 - 1;
            }
            i10++;
        }
        if (i11 != size) {
            e0(arrayList, arrayList2, i11, size);
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:110:? A[RETURN, SYNTHETIC] */
    /* JADX WARN: Removed duplicated region for block: B:41:0x00c5  */
    /* JADX WARN: Removed duplicated region for block: B:63:0x0143  */
    /* JADX WARN: Removed duplicated region for block: B:76:0x019d  */
    /* JADX WARN: Removed duplicated region for block: B:83:0x01be  */
    /* JADX WARN: Type inference failed for: r1v17 */
    /* JADX WARN: Type inference failed for: r1v3 */
    /* JADX WARN: Type inference failed for: r1v4, types: [int, boolean] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void e0(ArrayList arrayList, ArrayList arrayList2, int i10, int i11) {
        ?? r12;
        boolean z9;
        int i12;
        int i13;
        ArrayList arrayList3;
        int i14;
        int i15;
        ArrayList arrayList4;
        int i16;
        boolean z10;
        int i17;
        boolean z11 = ((androidx.fragment.app.a) arrayList.get(i10)).f3181r;
        ArrayList arrayList5 = this.K;
        if (arrayList5 == null) {
            this.K = new ArrayList();
        } else {
            arrayList5.clear();
        }
        this.K.addAll(this.f3077c.n());
        Fragment x02 = x0();
        boolean z12 = false;
        for (int i18 = i10; i18 < i11; i18++) {
            androidx.fragment.app.a aVar = (androidx.fragment.app.a) arrayList.get(i18);
            x02 = !((Boolean) arrayList2.get(i18)).booleanValue() ? aVar.v(this.K, x02) : aVar.D(this.K, x02);
            z12 = z12 || aVar.f3172i;
        }
        this.K.clear();
        if (!z11 && this.f3091q >= 1) {
            if (!P) {
                r12 = 1;
                x.B(this.f3092r.f(), this.f3093s, arrayList, arrayList2, i10, i11, false, this.f3088n);
                d0(arrayList, arrayList2, i10, i11);
                if (P) {
                    if (z11) {
                        o.b bVar = new o.b();
                        d(bVar);
                        i14 = 1;
                        z9 = z11;
                        i12 = i11;
                        i13 = i10;
                        arrayList3 = arrayList2;
                        i15 = a1(arrayList, arrayList2, i10, i11, bVar);
                        O0(bVar);
                    } else {
                        z9 = z11;
                        i12 = i11;
                        i13 = i10;
                        arrayList3 = arrayList2;
                        i14 = 1;
                        i15 = i12;
                    }
                    if (i15 == i13 || !z9) {
                        arrayList4 = arrayList3;
                        i16 = i12;
                    } else {
                        if (this.f3091q >= i14) {
                            arrayList4 = arrayList3;
                            int i19 = i15;
                            i16 = i12;
                            z10 = true;
                            x.B(this.f3092r.f(), this.f3093s, arrayList, arrayList2, i10, i19, true, this.f3088n);
                        } else {
                            arrayList4 = arrayList3;
                            i16 = i12;
                            z10 = true;
                        }
                        Q0(this.f3091q, z10);
                    }
                } else {
                    boolean booleanValue = ((Boolean) arrayList2.get(i11 - 1)).booleanValue();
                    for (int i20 = i10; i20 < i11; i20++) {
                        androidx.fragment.app.a aVar2 = (androidx.fragment.app.a) arrayList.get(i20);
                        if (booleanValue) {
                            for (int size = aVar2.f3166c.size() - r12; size >= 0; size--) {
                                Fragment fragment = ((w.a) aVar2.f3166c.get(size)).f3184b;
                                if (fragment != null) {
                                    w(fragment).m();
                                }
                            }
                        } else {
                            Iterator it = aVar2.f3166c.iterator();
                            while (it.hasNext()) {
                                Fragment fragment2 = ((w.a) it.next()).f3184b;
                                if (fragment2 != null) {
                                    w(fragment2).m();
                                }
                            }
                        }
                    }
                    Q0(this.f3091q, r12);
                    for (c0 c0Var : t(arrayList, i10, i11)) {
                        c0Var.r(booleanValue);
                        c0Var.p();
                        c0Var.g();
                    }
                    i16 = i11;
                    arrayList4 = arrayList2;
                }
                for (i17 = i10; i17 < i16; i17++) {
                    androidx.fragment.app.a aVar3 = (androidx.fragment.app.a) arrayList.get(i17);
                    if (((Boolean) arrayList4.get(i17)).booleanValue() && aVar3.f2924v >= 0) {
                        aVar3.f2924v = -1;
                    }
                    aVar3.B();
                }
                if (z12) {
                    return;
                }
                f1();
                return;
            }
            for (int i21 = i10; i21 < i11; i21++) {
                Iterator it2 = ((androidx.fragment.app.a) arrayList.get(i21)).f3166c.iterator();
                while (it2.hasNext()) {
                    Fragment fragment3 = ((w.a) it2.next()).f3184b;
                    if (fragment3 != null && fragment3.mFragmentManager != null) {
                        this.f3077c.p(w(fragment3));
                    }
                }
            }
        }
        r12 = 1;
        d0(arrayList, arrayList2, i10, i11);
        if (P) {
        }
        while (i17 < i16) {
        }
        if (z12) {
        }
    }

    private void f0(ArrayList arrayList, ArrayList arrayList2) {
        int indexOf;
        int indexOf2;
        ArrayList arrayList3 = this.L;
        int size = arrayList3 == null ? 0 : arrayList3.size();
        int i10 = 0;
        while (i10 < size) {
            p pVar = (p) this.L.get(i10);
            if (arrayList == null || pVar.f3121a || (indexOf2 = arrayList.indexOf(pVar.f3122b)) == -1 || arrayList2 == null || !((Boolean) arrayList2.get(indexOf2)).booleanValue()) {
                if (pVar.e() || (arrayList != null && pVar.f3122b.y(arrayList, 0, arrayList.size()))) {
                    this.L.remove(i10);
                    i10--;
                    size--;
                    if (arrayList == null || pVar.f3121a || (indexOf = arrayList.indexOf(pVar.f3122b)) == -1 || arrayList2 == null || !((Boolean) arrayList2.get(indexOf)).booleanValue()) {
                        pVar.d();
                    }
                }
                i10++;
            } else {
                this.L.remove(i10);
                i10--;
                size--;
            }
            pVar.c();
            i10++;
        }
    }

    private void f1() {
        if (this.f3086l != null) {
            for (int i10 = 0; i10 < this.f3086l.size(); i10++) {
                ((m) this.f3086l.get(i10)).onBackStackChanged();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static int h1(int i10) {
        if (i10 != 4097) {
            if (i10 != 4099) {
                return i10 != 8194 ? 0 : 4097;
            }
            return 4099;
        }
        return 8194;
    }

    private void k0() {
        if (P) {
            for (c0 c0Var : s()) {
                c0Var.k();
            }
        } else if (this.L != null) {
            while (!this.L.isEmpty()) {
                ((p) this.L.remove(0)).d();
            }
        }
    }

    private boolean l0(ArrayList arrayList, ArrayList arrayList2) {
        synchronized (this.f3075a) {
            if (this.f3075a.isEmpty()) {
                return false;
            }
            int size = this.f3075a.size();
            boolean z9 = false;
            for (int i10 = 0; i10 < size; i10++) {
                z9 |= ((InterfaceC0034n) this.f3075a.get(i10)).a(arrayList, arrayList2);
            }
            this.f3075a.clear();
            this.f3092r.g().removeCallbacks(this.N);
            return z9;
        }
    }

    private void n(Fragment fragment) {
        HashSet hashSet = (HashSet) this.f3087m.get(fragment);
        if (hashSet != null) {
            Iterator it = hashSet.iterator();
            while (it.hasNext()) {
                ((androidx.core.os.e) it.next()).a();
            }
            hashSet.clear();
            x(fragment);
            this.f3087m.remove(fragment);
        }
    }

    private q n0(Fragment fragment) {
        return this.M.i(fragment);
    }

    private void n1(Fragment fragment) {
        ViewGroup p02 = p0(fragment);
        if (p02 == null || fragment.getEnterAnim() + fragment.getExitAnim() + fragment.getPopEnterAnim() + fragment.getPopExitAnim() <= 0) {
            return;
        }
        int i10 = k0.b.visible_removing_fragment_view_tag;
        if (p02.getTag(i10) == null) {
            p02.setTag(i10, fragment);
        }
        ((Fragment) p02.getTag(i10)).setPopDirection(fragment.getPopDirection());
    }

    private void p() {
        if (K0()) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
    }

    private ViewGroup p0(Fragment fragment) {
        ViewGroup viewGroup = fragment.mContainer;
        if (viewGroup != null) {
            return viewGroup;
        }
        if (fragment.mContainerId > 0 && this.f3093s.d()) {
            View c10 = this.f3093s.c(fragment.mContainerId);
            if (c10 instanceof ViewGroup) {
                return (ViewGroup) c10;
            }
        }
        return null;
    }

    private void p1() {
        for (u uVar : this.f3077c.k()) {
            V0(uVar);
        }
    }

    private void q() {
        this.f3076b = false;
        this.J.clear();
        this.I.clear();
    }

    private void q1() {
        synchronized (this.f3075a) {
            boolean z9 = true;
            if (this.f3075a.isEmpty()) {
                this.f3082h.setEnabled((m0() <= 0 || !I0(this.f3094t)) ? false : false);
            } else {
                this.f3082h.setEnabled(true);
            }
        }
    }

    private Set s() {
        HashSet hashSet = new HashSet();
        for (u uVar : this.f3077c.k()) {
            ViewGroup viewGroup = uVar.k().mContainer;
            if (viewGroup != null) {
                hashSet.add(c0.o(viewGroup, y0()));
            }
        }
        return hashSet;
    }

    private Set t(ArrayList arrayList, int i10, int i11) {
        ViewGroup viewGroup;
        HashSet hashSet = new HashSet();
        while (i10 < i11) {
            Iterator it = ((androidx.fragment.app.a) arrayList.get(i10)).f3166c.iterator();
            while (it.hasNext()) {
                Fragment fragment = ((w.a) it.next()).f3184b;
                if (fragment != null && (viewGroup = fragment.mContainer) != null) {
                    hashSet.add(c0.n(viewGroup, this));
                }
            }
            i10++;
        }
        return hashSet;
    }

    private void v(Fragment fragment) {
        Animator animator;
        if (fragment.mView != null) {
            f.d c10 = androidx.fragment.app.f.c(this.f3092r.f(), fragment, !fragment.mHidden, fragment.getPopDirection());
            if (c10 == null || (animator = c10.f3053b) == null) {
                if (c10 != null) {
                    fragment.mView.startAnimation(c10.f3052a);
                    c10.f3052a.start();
                }
                fragment.mView.setVisibility((!fragment.mHidden || fragment.isHideReplaced()) ? 0 : 8);
                if (fragment.isHideReplaced()) {
                    fragment.setHideReplaced(false);
                }
            } else {
                animator.setTarget(fragment.mView);
                if (!fragment.mHidden) {
                    fragment.mView.setVisibility(0);
                } else if (fragment.isHideReplaced()) {
                    fragment.setHideReplaced(false);
                } else {
                    ViewGroup viewGroup = fragment.mContainer;
                    View view = fragment.mView;
                    viewGroup.startViewTransition(view);
                    c10.f3053b.addListener(new h(viewGroup, view, fragment));
                }
                c10.f3053b.start();
            }
        }
        D0(fragment);
        fragment.mHiddenChanged = false;
        fragment.onHiddenChanged(fragment.mHidden);
    }

    private void x(Fragment fragment) {
        fragment.performDestroyView();
        this.f3089o.n(fragment, false);
        fragment.mContainer = null;
        fragment.mView = null;
        fragment.mViewLifecycleOwner = null;
        fragment.mViewLifecycleOwnerLiveData.j(null);
        fragment.mInLayout = false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Fragment z0(View view) {
        Object tag = view.getTag(k0.b.fragment_container_view_tag);
        if (tag instanceof Fragment) {
            return (Fragment) tag;
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void A() {
        this.E = false;
        this.F = false;
        this.M.o(false);
        T(0);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public k0 A0(Fragment fragment) {
        return this.M.l(fragment);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void B(Configuration configuration) {
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null) {
                fragment.performConfigurationChanged(configuration);
            }
        }
    }

    void B0() {
        b0(true);
        if (this.f3082h.isEnabled()) {
            X0();
        } else {
            this.f3081g.k();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean C(MenuItem menuItem) {
        if (this.f3091q < 1) {
            return false;
        }
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null && fragment.performContextItemSelected(menuItem)) {
                return true;
            }
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void C0(Fragment fragment) {
        if (F0(2)) {
            Log.v("FragmentManager", "hide: " + fragment);
        }
        if (fragment.mHidden) {
            return;
        }
        fragment.mHidden = true;
        fragment.mHiddenChanged = true ^ fragment.mHiddenChanged;
        n1(fragment);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void D() {
        this.E = false;
        this.F = false;
        this.M.o(false);
        T(1);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void D0(Fragment fragment) {
        if (fragment.mAdded && G0(fragment)) {
            this.D = true;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean E(Menu menu, MenuInflater menuInflater) {
        if (this.f3091q < 1) {
            return false;
        }
        ArrayList arrayList = null;
        boolean z9 = false;
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null && H0(fragment) && fragment.performCreateOptionsMenu(menu, menuInflater)) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(fragment);
                z9 = true;
            }
        }
        if (this.f3079e != null) {
            for (int i10 = 0; i10 < this.f3079e.size(); i10++) {
                Fragment fragment2 = (Fragment) this.f3079e.get(i10);
                if (arrayList == null || !arrayList.contains(fragment2)) {
                    fragment2.onDestroyOptionsMenu();
                }
            }
        }
        this.f3079e = arrayList;
        return z9;
    }

    public boolean E0() {
        return this.G;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void F() {
        this.G = true;
        b0(true);
        Y();
        T(-1);
        this.f3092r = null;
        this.f3093s = null;
        this.f3094t = null;
        if (this.f3081g != null) {
            this.f3082h.remove();
            this.f3081g = null;
        }
        e.c cVar = this.f3100z;
        if (cVar != null) {
            cVar.c();
            this.A.c();
            this.B.c();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void G() {
        T(1);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void H() {
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null) {
                fragment.performLowMemory();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean H0(Fragment fragment) {
        if (fragment == null) {
            return true;
        }
        return fragment.isMenuVisible();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void I(boolean z9) {
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null) {
                fragment.performMultiWindowModeChanged(z9);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean I0(Fragment fragment) {
        if (fragment == null) {
            return true;
        }
        n nVar = fragment.mFragmentManager;
        return fragment.equals(nVar.x0()) && I0(nVar.f3094t);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void J(Fragment fragment) {
        Iterator it = this.f3090p.iterator();
        while (it.hasNext()) {
            ((r) it.next()).a(this, fragment);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean J0(int i10) {
        return this.f3091q >= i10;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean K(MenuItem menuItem) {
        if (this.f3091q < 1) {
            return false;
        }
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null && fragment.performOptionsItemSelected(menuItem)) {
                return true;
            }
        }
        return false;
    }

    public boolean K0() {
        return this.E || this.F;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void L(Menu menu) {
        if (this.f3091q < 1) {
            return;
        }
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null) {
                fragment.performOptionsMenuClosed(menu);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void L0(Fragment fragment, String[] strArr, int i10) {
        if (this.B == null) {
            this.f3092r.j(fragment, strArr, i10);
            return;
        }
        this.C.addLast(new l(fragment.mWho, i10));
        this.B.a(strArr);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void M0(Fragment fragment, Intent intent, int i10, Bundle bundle) {
        if (this.f3100z == null) {
            this.f3092r.m(fragment, intent, i10, bundle);
            return;
        }
        this.C.addLast(new l(fragment.mWho, i10));
        if (intent != null && bundle != null) {
            intent.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", bundle);
        }
        this.f3100z.a(intent);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void N() {
        T(5);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void N0(Fragment fragment, IntentSender intentSender, int i10, Intent intent, int i11, int i12, int i13, Bundle bundle) {
        Intent intent2;
        if (this.A == null) {
            this.f3092r.n(fragment, intentSender, i10, intent, i11, i12, i13, bundle);
            return;
        }
        if (bundle != null) {
            if (intent == null) {
                intent2 = new Intent();
                intent2.putExtra("androidx.fragment.extra.ACTIVITY_OPTIONS_BUNDLE", true);
            } else {
                intent2 = intent;
            }
            if (F0(2)) {
                Log.v("FragmentManager", "ActivityOptions " + bundle + " were added to fillInIntent " + intent2 + " for fragment " + fragment);
            }
            intent2.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", bundle);
        } else {
            intent2 = intent;
        }
        e.g a10 = new g.a(intentSender).b(intent2).c(i12, i11).a();
        this.C.addLast(new l(fragment.mWho, i10));
        if (F0(2)) {
            Log.v("FragmentManager", "Fragment " + fragment + "is launching an IntentSender for result ");
        }
        this.A.a(a10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void O(boolean z9) {
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null) {
                fragment.performPictureInPictureModeChanged(z9);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean P(Menu menu) {
        boolean z9 = false;
        if (this.f3091q < 1) {
            return false;
        }
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null && H0(fragment) && fragment.performPrepareOptionsMenu(menu)) {
                z9 = true;
            }
        }
        return z9;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void P0(Fragment fragment) {
        if (!this.f3077c.c(fragment.mWho)) {
            if (F0(3)) {
                Log.d("FragmentManager", "Ignoring moving " + fragment + " to state " + this.f3091q + "since it is not added to " + this);
                return;
            }
            return;
        }
        R0(fragment);
        View view = fragment.mView;
        if (view != null && fragment.mIsNewlyAdded && fragment.mContainer != null) {
            float f10 = fragment.mPostponedAlpha;
            if (f10 > 0.0f) {
                view.setAlpha(f10);
            }
            fragment.mPostponedAlpha = 0.0f;
            fragment.mIsNewlyAdded = false;
            f.d c10 = androidx.fragment.app.f.c(this.f3092r.f(), fragment, true, fragment.getPopDirection());
            if (c10 != null) {
                Animation animation = c10.f3052a;
                if (animation != null) {
                    fragment.mView.startAnimation(animation);
                } else {
                    c10.f3053b.setTarget(fragment.mView);
                    c10.f3053b.start();
                }
            }
        }
        if (fragment.mHiddenChanged) {
            v(fragment);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void Q() {
        q1();
        M(this.f3095u);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void Q0(int i10, boolean z9) {
        androidx.fragment.app.k kVar;
        if (this.f3092r == null && i10 != -1) {
            throw new IllegalStateException("No activity");
        }
        if (z9 || i10 != this.f3091q) {
            this.f3091q = i10;
            if (P) {
                this.f3077c.r();
            } else {
                for (Fragment fragment : this.f3077c.n()) {
                    P0(fragment);
                }
                for (u uVar : this.f3077c.k()) {
                    Fragment k10 = uVar.k();
                    if (!k10.mIsNewlyAdded) {
                        P0(k10);
                    }
                    if (k10.mRemoving && !k10.isInBackStack()) {
                        this.f3077c.q(uVar);
                    }
                }
            }
            p1();
            if (this.D && (kVar = this.f3092r) != null && this.f3091q == 7) {
                kVar.o();
                this.D = false;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void R() {
        this.E = false;
        this.F = false;
        this.M.o(false);
        T(7);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void R0(Fragment fragment) {
        S0(fragment, this.f3091q);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void S() {
        this.E = false;
        this.F = false;
        this.M.o(false);
        T(5);
    }

    /* JADX WARN: Code restructure failed: missing block: B:24:0x0053, code lost:
        if (r2 != 5) goto L26;
     */
    /* JADX WARN: Removed duplicated region for block: B:31:0x0063  */
    /* JADX WARN: Removed duplicated region for block: B:33:0x0068  */
    /* JADX WARN: Removed duplicated region for block: B:35:0x006d  */
    /* JADX WARN: Removed duplicated region for block: B:37:0x0072  */
    /* JADX WARN: Removed duplicated region for block: B:39:0x0077  */
    /* JADX WARN: Removed duplicated region for block: B:99:0x0160  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    void S0(Fragment fragment, int i10) {
        ViewGroup viewGroup;
        u m10 = this.f3077c.m(fragment.mWho);
        int i11 = 1;
        if (m10 == null) {
            m10 = new u(this.f3089o, this.f3077c, fragment);
            m10.t(1);
        }
        if (fragment.mFromLayout && fragment.mInLayout && fragment.mState == 2) {
            i10 = Math.max(i10, 2);
        }
        int min = Math.min(i10, m10.d());
        int i12 = fragment.mState;
        if (i12 <= min) {
            if (i12 < min && !this.f3087m.isEmpty()) {
                n(fragment);
            }
            int i13 = fragment.mState;
            if (i13 != -1) {
                if (i13 != 0) {
                    if (i13 != 1) {
                        if (i13 != 2) {
                            if (i13 != 4) {
                            }
                            if (min > 4) {
                                m10.u();
                            }
                            if (min > 5) {
                                m10.p();
                            }
                        }
                        if (min > 2) {
                            m10.a();
                        }
                        if (min > 4) {
                        }
                        if (min > 5) {
                        }
                    }
                    if (min > -1) {
                        m10.j();
                    }
                    if (min > 1) {
                        m10.f();
                    }
                    if (min > 2) {
                    }
                    if (min > 4) {
                    }
                    if (min > 5) {
                    }
                }
            } else if (min > -1) {
                m10.c();
            }
            if (min > 0) {
                m10.e();
            }
            if (min > -1) {
            }
            if (min > 1) {
            }
            if (min > 2) {
            }
            if (min > 4) {
            }
            if (min > 5) {
            }
        } else if (i12 > min) {
            if (i12 != 0) {
                if (i12 != 1) {
                    if (i12 != 2) {
                        if (i12 != 4) {
                            if (i12 != 5) {
                                if (i12 == 7) {
                                    if (min < 7) {
                                        m10.n();
                                    }
                                }
                            }
                            if (min < 5) {
                                m10.v();
                            }
                        }
                        if (min < 4) {
                            if (F0(3)) {
                                Log.d("FragmentManager", "movefrom ACTIVITY_CREATED: " + fragment);
                            }
                            if (fragment.mView != null && this.f3092r.k(fragment) && fragment.mSavedViewState == null) {
                                m10.s();
                            }
                        }
                    }
                    if (min < 2) {
                        f.d dVar = null;
                        View view = fragment.mView;
                        if (view != null && (viewGroup = fragment.mContainer) != null) {
                            viewGroup.endViewTransition(view);
                            fragment.mView.clearAnimation();
                            if (!fragment.isRemovingParent()) {
                                if (this.f3091q > -1 && !this.G && fragment.mView.getVisibility() == 0 && fragment.mPostponedAlpha >= 0.0f) {
                                    dVar = androidx.fragment.app.f.c(this.f3092r.f(), fragment, false, fragment.getPopDirection());
                                }
                                fragment.mPostponedAlpha = 0.0f;
                                ViewGroup viewGroup2 = fragment.mContainer;
                                View view2 = fragment.mView;
                                if (dVar != null) {
                                    androidx.fragment.app.f.a(fragment, dVar, this.f3088n);
                                }
                                viewGroup2.removeView(view2);
                                if (F0(2)) {
                                    Log.v("FragmentManager", "Removing view " + view2 + " for fragment " + fragment + " from container " + viewGroup2);
                                }
                                if (viewGroup2 != fragment.mContainer) {
                                    return;
                                }
                            }
                        }
                        if (this.f3087m.get(fragment) == null) {
                            m10.h();
                        }
                    }
                }
                if (min < 1) {
                    if (this.f3087m.get(fragment) == null) {
                        m10.g();
                    }
                    if (i11 < 0) {
                        m10.i();
                    }
                    min = i11;
                }
            }
            i11 = min;
            if (i11 < 0) {
            }
            min = i11;
        }
        if (fragment.mState != min) {
            if (F0(3)) {
                Log.d("FragmentManager", "moveToState: Fragment state for " + fragment + " not updated inline; expected state " + min + " found " + fragment.mState);
            }
            fragment.mState = min;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void T0() {
        if (this.f3092r == null) {
            return;
        }
        this.E = false;
        this.F = false;
        this.M.o(false);
        for (Fragment fragment : this.f3077c.n()) {
            if (fragment != null) {
                fragment.noteStateNotSaved();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void U() {
        this.F = true;
        this.M.o(true);
        T(4);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void U0(androidx.fragment.app.h hVar) {
        View view;
        for (u uVar : this.f3077c.k()) {
            Fragment k10 = uVar.k();
            if (k10.mContainerId == hVar.getId() && (view = k10.mView) != null && view.getParent() == null) {
                k10.mContainer = hVar;
                uVar.b();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void V() {
        T(2);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void V0(u uVar) {
        Fragment k10 = uVar.k();
        if (k10.mDeferStart) {
            if (this.f3076b) {
                this.H = true;
                return;
            }
            k10.mDeferStart = false;
            if (P) {
                uVar.m();
            } else {
                R0(k10);
            }
        }
    }

    public void W0(int i10, int i11) {
        if (i10 >= 0) {
            Z(new o(null, i10, i11), false);
            return;
        }
        throw new IllegalArgumentException("Bad id: " + i10);
    }

    public void X(String str, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] strArr) {
        int size;
        int size2;
        String str2 = str + "    ";
        this.f3077c.e(str, fileDescriptor, printWriter, strArr);
        ArrayList arrayList = this.f3079e;
        if (arrayList != null && (size2 = arrayList.size()) > 0) {
            printWriter.print(str);
            printWriter.println("Fragments Created Menus:");
            for (int i10 = 0; i10 < size2; i10++) {
                printWriter.print(str);
                printWriter.print("  #");
                printWriter.print(i10);
                printWriter.print(": ");
                printWriter.println(((Fragment) this.f3079e.get(i10)).toString());
            }
        }
        ArrayList arrayList2 = this.f3078d;
        if (arrayList2 != null && (size = arrayList2.size()) > 0) {
            printWriter.print(str);
            printWriter.println("Back Stack:");
            for (int i11 = 0; i11 < size; i11++) {
                androidx.fragment.app.a aVar = (androidx.fragment.app.a) this.f3078d.get(i11);
                printWriter.print(str);
                printWriter.print("  #");
                printWriter.print(i11);
                printWriter.print(": ");
                printWriter.println(aVar.toString());
                aVar.r(str2, printWriter);
            }
        }
        printWriter.print(str);
        printWriter.println("Back Stack Index: " + this.f3083i.get());
        synchronized (this.f3075a) {
            int size3 = this.f3075a.size();
            if (size3 > 0) {
                printWriter.print(str);
                printWriter.println("Pending Actions:");
                for (int i12 = 0; i12 < size3; i12++) {
                    printWriter.print(str);
                    printWriter.print("  #");
                    printWriter.print(i12);
                    printWriter.print(": ");
                    printWriter.println((InterfaceC0034n) this.f3075a.get(i12));
                }
            }
        }
        printWriter.print(str);
        printWriter.println("FragmentManager misc state:");
        printWriter.print(str);
        printWriter.print("  mHost=");
        printWriter.println(this.f3092r);
        printWriter.print(str);
        printWriter.print("  mContainer=");
        printWriter.println(this.f3093s);
        if (this.f3094t != null) {
            printWriter.print(str);
            printWriter.print("  mParent=");
            printWriter.println(this.f3094t);
        }
        printWriter.print(str);
        printWriter.print("  mCurState=");
        printWriter.print(this.f3091q);
        printWriter.print(" mStateSaved=");
        printWriter.print(this.E);
        printWriter.print(" mStopped=");
        printWriter.print(this.F);
        printWriter.print(" mDestroyed=");
        printWriter.println(this.G);
        if (this.D) {
            printWriter.print(str);
            printWriter.print("  mNeedMenuInvalidate=");
            printWriter.println(this.D);
        }
    }

    public boolean X0() {
        return Y0(null, -1, 0);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void Z(InterfaceC0034n interfaceC0034n, boolean z9) {
        if (!z9) {
            if (this.f3092r == null) {
                if (!this.G) {
                    throw new IllegalStateException("FragmentManager has not been attached to a host.");
                }
                throw new IllegalStateException("FragmentManager has been destroyed");
            }
            p();
        }
        synchronized (this.f3075a) {
            if (this.f3092r == null) {
                if (!z9) {
                    throw new IllegalStateException("Activity has been destroyed");
                }
                return;
            }
            this.f3075a.add(interfaceC0034n);
            j1();
        }
    }

    boolean Z0(ArrayList arrayList, ArrayList arrayList2, String str, int i10, int i11) {
        int i12;
        ArrayList arrayList3 = this.f3078d;
        if (arrayList3 == null) {
            return false;
        }
        if (str == null && i10 < 0 && (i11 & 1) == 0) {
            int size = arrayList3.size() - 1;
            if (size < 0) {
                return false;
            }
            arrayList.add(this.f3078d.remove(size));
            arrayList2.add(Boolean.TRUE);
        } else {
            if (str != null || i10 >= 0) {
                int size2 = arrayList3.size() - 1;
                while (size2 >= 0) {
                    androidx.fragment.app.a aVar = (androidx.fragment.app.a) this.f3078d.get(size2);
                    if ((str != null && str.equals(aVar.w())) || (i10 >= 0 && i10 == aVar.f2924v)) {
                        break;
                    }
                    size2--;
                }
                if (size2 < 0) {
                    return false;
                }
                if ((i11 & 1) != 0) {
                    while (true) {
                        size2--;
                        if (size2 < 0) {
                            break;
                        }
                        androidx.fragment.app.a aVar2 = (androidx.fragment.app.a) this.f3078d.get(size2);
                        if (str == null || !str.equals(aVar2.w())) {
                            if (i10 < 0 || i10 != aVar2.f2924v) {
                                break;
                            }
                        }
                    }
                }
                i12 = size2;
            } else {
                i12 = -1;
            }
            if (i12 == this.f3078d.size() - 1) {
                return false;
            }
            for (int size3 = this.f3078d.size() - 1; size3 > i12; size3--) {
                arrayList.add(this.f3078d.remove(size3));
                arrayList2.add(Boolean.TRUE);
            }
        }
        return true;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean b0(boolean z9) {
        a0(z9);
        boolean z10 = false;
        while (l0(this.I, this.J)) {
            this.f3076b = true;
            try {
                d1(this.I, this.J);
                q();
                z10 = true;
            } catch (Throwable th) {
                q();
                throw th;
            }
        }
        q1();
        W();
        this.f3077c.b();
        return z10;
    }

    void b1(Fragment fragment, androidx.core.os.e eVar) {
        HashSet hashSet = (HashSet) this.f3087m.get(fragment);
        if (hashSet != null && hashSet.remove(eVar) && hashSet.isEmpty()) {
            this.f3087m.remove(fragment);
            if (fragment.mState < 5) {
                x(fragment);
                R0(fragment);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c0(InterfaceC0034n interfaceC0034n, boolean z9) {
        if (z9 && (this.f3092r == null || this.G)) {
            return;
        }
        a0(z9);
        if (interfaceC0034n.a(this.I, this.J)) {
            this.f3076b = true;
            try {
                d1(this.I, this.J);
            } finally {
                q();
            }
        }
        q1();
        W();
        this.f3077c.b();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c1(Fragment fragment) {
        if (F0(2)) {
            Log.v("FragmentManager", "remove: " + fragment + " nesting=" + fragment.mBackStackNesting);
        }
        boolean z9 = !fragment.isInBackStack();
        if (!fragment.mDetached || z9) {
            this.f3077c.s(fragment);
            if (G0(fragment)) {
                this.D = true;
            }
            fragment.mRemoving = true;
            n1(fragment);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void e(androidx.fragment.app.a aVar) {
        if (this.f3078d == null) {
            this.f3078d = new ArrayList();
        }
        this.f3078d.add(aVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void e1(Fragment fragment) {
        this.M.n(fragment);
    }

    void f(Fragment fragment, androidx.core.os.e eVar) {
        if (this.f3087m.get(fragment) == null) {
            this.f3087m.put(fragment, new HashSet());
        }
        ((HashSet) this.f3087m.get(fragment)).add(eVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public u g(Fragment fragment) {
        if (F0(2)) {
            Log.v("FragmentManager", "add: " + fragment);
        }
        u w9 = w(fragment);
        fragment.mFragmentManager = this;
        this.f3077c.p(w9);
        if (!fragment.mDetached) {
            this.f3077c.a(fragment);
            fragment.mRemoving = false;
            if (fragment.mView == null) {
                fragment.mHiddenChanged = false;
            }
            if (G0(fragment)) {
                this.D = true;
            }
        }
        return w9;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Fragment g0(String str) {
        return this.f3077c.f(str);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void g1(Parcelable parcelable) {
        u uVar;
        if (parcelable == null) {
            return;
        }
        androidx.fragment.app.p pVar = (androidx.fragment.app.p) parcelable;
        if (pVar.f3124g == null) {
            return;
        }
        this.f3077c.t();
        Iterator it = pVar.f3124g.iterator();
        while (it.hasNext()) {
            t tVar = (t) it.next();
            if (tVar != null) {
                Fragment h10 = this.M.h(tVar.f3141h);
                if (h10 != null) {
                    if (F0(2)) {
                        Log.v("FragmentManager", "restoreSaveState: re-attaching retained " + h10);
                    }
                    uVar = new u(this.f3089o, this.f3077c, h10, tVar);
                } else {
                    uVar = new u(this.f3089o, this.f3077c, this.f3092r.f().getClassLoader(), q0(), tVar);
                }
                Fragment k10 = uVar.k();
                k10.mFragmentManager = this;
                if (F0(2)) {
                    Log.v("FragmentManager", "restoreSaveState: active (" + k10.mWho + "): " + k10);
                }
                uVar.o(this.f3092r.f().getClassLoader());
                this.f3077c.p(uVar);
                uVar.t(this.f3091q);
            }
        }
        for (Fragment fragment : this.M.k()) {
            if (!this.f3077c.c(fragment.mWho)) {
                if (F0(2)) {
                    Log.v("FragmentManager", "Discarding retained Fragment " + fragment + " that was not found in the set of active Fragments " + pVar.f3124g);
                }
                this.M.n(fragment);
                fragment.mFragmentManager = this;
                u uVar2 = new u(this.f3089o, this.f3077c, fragment);
                uVar2.t(1);
                uVar2.m();
                fragment.mRemoving = true;
                uVar2.m();
            }
        }
        this.f3077c.u(pVar.f3125h);
        if (pVar.f3126i != null) {
            this.f3078d = new ArrayList(pVar.f3126i.length);
            int i10 = 0;
            while (true) {
                androidx.fragment.app.b[] bVarArr = pVar.f3126i;
                if (i10 >= bVarArr.length) {
                    break;
                }
                androidx.fragment.app.a a10 = bVarArr[i10].a(this);
                if (F0(2)) {
                    Log.v("FragmentManager", "restoreAllState: back stack #" + i10 + " (index " + a10.f2924v + "): " + a10);
                    PrintWriter printWriter = new PrintWriter(new b0("FragmentManager"));
                    a10.s("  ", printWriter, false);
                    printWriter.close();
                }
                this.f3078d.add(a10);
                i10++;
            }
        } else {
            this.f3078d = null;
        }
        this.f3083i.set(pVar.f3127j);
        String str = pVar.f3128k;
        if (str != null) {
            Fragment g02 = g0(str);
            this.f3095u = g02;
            M(g02);
        }
        ArrayList arrayList = pVar.f3129l;
        if (arrayList != null) {
            for (int i11 = 0; i11 < arrayList.size(); i11++) {
                Bundle bundle = (Bundle) pVar.f3130m.get(i11);
                bundle.setClassLoader(this.f3092r.f().getClassLoader());
                this.f3084j.put(arrayList.get(i11), bundle);
            }
        }
        this.C = new ArrayDeque(pVar.f3131n);
    }

    public void h(r rVar) {
        this.f3090p.add(rVar);
    }

    public Fragment h0(int i10) {
        return this.f3077c.g(i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void i(Fragment fragment) {
        this.M.f(fragment);
    }

    public Fragment i0(String str) {
        return this.f3077c.h(str);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Parcelable i1() {
        int size;
        k0();
        Y();
        b0(true);
        this.E = true;
        this.M.o(true);
        ArrayList v9 = this.f3077c.v();
        androidx.fragment.app.b[] bVarArr = null;
        if (v9.isEmpty()) {
            if (F0(2)) {
                Log.v("FragmentManager", "saveAllState: no fragments!");
            }
            return null;
        }
        ArrayList w9 = this.f3077c.w();
        ArrayList arrayList = this.f3078d;
        if (arrayList != null && (size = arrayList.size()) > 0) {
            bVarArr = new androidx.fragment.app.b[size];
            for (int i10 = 0; i10 < size; i10++) {
                bVarArr[i10] = new androidx.fragment.app.b((androidx.fragment.app.a) this.f3078d.get(i10));
                if (F0(2)) {
                    Log.v("FragmentManager", "saveAllState: adding back stack #" + i10 + ": " + this.f3078d.get(i10));
                }
            }
        }
        androidx.fragment.app.p pVar = new androidx.fragment.app.p();
        pVar.f3124g = v9;
        pVar.f3125h = w9;
        pVar.f3126i = bVarArr;
        pVar.f3127j = this.f3083i.get();
        Fragment fragment = this.f3095u;
        if (fragment != null) {
            pVar.f3128k = fragment.mWho;
        }
        pVar.f3129l.addAll(this.f3084j.keySet());
        pVar.f3130m.addAll(this.f3084j.values());
        pVar.f3131n = new ArrayList(this.C);
        return pVar;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int j() {
        return this.f3083i.getAndIncrement();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Fragment j0(String str) {
        return this.f3077c.i(str);
    }

    void j1() {
        synchronized (this.f3075a) {
            ArrayList arrayList = this.L;
            boolean z9 = (arrayList == null || arrayList.isEmpty()) ? false : true;
            boolean z10 = this.f3075a.size() == 1;
            if (z9 || z10) {
                this.f3092r.g().removeCallbacks(this.N);
                this.f3092r.g().post(this.N);
                q1();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* JADX WARN: Removed duplicated region for block: B:13:0x0021  */
    /* JADX WARN: Removed duplicated region for block: B:16:0x0028  */
    /* JADX WARN: Removed duplicated region for block: B:21:0x003b  */
    /* JADX WARN: Removed duplicated region for block: B:23:0x0044  */
    /* JADX WARN: Removed duplicated region for block: B:29:0x0070  */
    /* JADX WARN: Removed duplicated region for block: B:37:? A[RETURN, SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void k(androidx.fragment.app.k kVar, androidx.fragment.app.g gVar, Fragment fragment) {
        r rVar;
        androidx.fragment.app.k kVar2;
        String str;
        if (this.f3092r != null) {
            throw new IllegalStateException("Already attached");
        }
        this.f3092r = kVar;
        this.f3093s = gVar;
        this.f3094t = fragment;
        if (fragment == null) {
            if (kVar instanceof r) {
                rVar = (r) kVar;
            }
            if (this.f3094t != null) {
                q1();
            }
            if (kVar instanceof androidx.activity.v) {
                androidx.activity.v vVar = (androidx.activity.v) kVar;
                OnBackPressedDispatcher onBackPressedDispatcher = vVar.getOnBackPressedDispatcher();
                this.f3081g = onBackPressedDispatcher;
                androidx.lifecycle.m mVar = vVar;
                if (fragment != null) {
                    mVar = fragment;
                }
                onBackPressedDispatcher.h(mVar, this.f3082h);
            }
            this.M = fragment == null ? fragment.mFragmentManager.n0(fragment) : kVar instanceof l0 ? q.j(((l0) kVar).getViewModelStore()) : new q(false);
            this.M.o(K0());
            this.f3077c.x(this.M);
            kVar2 = this.f3092r;
            if (kVar2 instanceof e.f) {
                return;
            }
            e.e activityResultRegistry = ((e.f) kVar2).getActivityResultRegistry();
            if (fragment != null) {
                str = fragment.mWho + ":";
            } else {
                str = "";
            }
            String str2 = "FragmentManager:" + str;
            this.f3100z = activityResultRegistry.m(str2 + "StartActivityForResult", new f.f(), new j());
            this.A = activityResultRegistry.m(str2 + "StartIntentSenderForResult", new k(), new a());
            this.B = activityResultRegistry.m(str2 + "RequestPermissions", new f.e(), new b());
            return;
        }
        rVar = new i(fragment);
        h(rVar);
        if (this.f3094t != null) {
        }
        if (kVar instanceof androidx.activity.v) {
        }
        this.M = fragment == null ? fragment.mFragmentManager.n0(fragment) : kVar instanceof l0 ? q.j(((l0) kVar).getViewModelStore()) : new q(false);
        this.M.o(K0());
        this.f3077c.x(this.M);
        kVar2 = this.f3092r;
        if (kVar2 instanceof e.f) {
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void k1(Fragment fragment, boolean z9) {
        ViewGroup p02 = p0(fragment);
        if (p02 == null || !(p02 instanceof androidx.fragment.app.h)) {
            return;
        }
        ((androidx.fragment.app.h) p02).setDrawDisappearingViewsLast(!z9);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void l(Fragment fragment) {
        if (F0(2)) {
            Log.v("FragmentManager", "attach: " + fragment);
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (fragment.mAdded) {
                return;
            }
            this.f3077c.a(fragment);
            if (F0(2)) {
                Log.v("FragmentManager", "add from attach: " + fragment);
            }
            if (G0(fragment)) {
                this.D = true;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void l1(Fragment fragment, h.b bVar) {
        if (fragment.equals(g0(fragment.mWho)) && (fragment.mHost == null || fragment.mFragmentManager == this)) {
            fragment.mMaxState = bVar;
            return;
        }
        throw new IllegalArgumentException("Fragment " + fragment + " is not an active fragment of FragmentManager " + this);
    }

    public w m() {
        return new androidx.fragment.app.a(this);
    }

    public int m0() {
        ArrayList arrayList = this.f3078d;
        if (arrayList != null) {
            return arrayList.size();
        }
        return 0;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void m1(Fragment fragment) {
        if (fragment == null || (fragment.equals(g0(fragment.mWho)) && (fragment.mHost == null || fragment.mFragmentManager == this))) {
            Fragment fragment2 = this.f3095u;
            this.f3095u = fragment;
            M(fragment2);
            M(this.f3095u);
            return;
        }
        throw new IllegalArgumentException("Fragment " + fragment + " is not an active fragment of FragmentManager " + this);
    }

    boolean o() {
        boolean z9 = false;
        for (Fragment fragment : this.f3077c.l()) {
            if (fragment != null) {
                z9 = G0(fragment);
                continue;
            }
            if (z9) {
                return true;
            }
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public androidx.fragment.app.g o0() {
        return this.f3093s;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void o1(Fragment fragment) {
        if (F0(2)) {
            Log.v("FragmentManager", "show: " + fragment);
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
        }
    }

    public androidx.fragment.app.j q0() {
        androidx.fragment.app.j jVar = this.f3096v;
        if (jVar != null) {
            return jVar;
        }
        Fragment fragment = this.f3094t;
        return fragment != null ? fragment.mFragmentManager.q0() : this.f3097w;
    }

    public final void r(String str) {
        this.f3084j.remove(str);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public v r0() {
        return this.f3077c;
    }

    public List s0() {
        return this.f3077c.n();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public androidx.fragment.app.k t0() {
        return this.f3092r;
    }

    public String toString() {
        Object obj;
        StringBuilder sb = new StringBuilder(128);
        sb.append("FragmentManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        Fragment fragment = this.f3094t;
        if (fragment != null) {
            sb.append(fragment.getClass().getSimpleName());
            sb.append("{");
            obj = this.f3094t;
        } else {
            androidx.fragment.app.k kVar = this.f3092r;
            if (kVar == null) {
                sb.append("null");
                sb.append("}}");
                return sb.toString();
            }
            sb.append(kVar.getClass().getSimpleName());
            sb.append("{");
            obj = this.f3092r;
        }
        sb.append(Integer.toHexString(System.identityHashCode(obj)));
        sb.append("}");
        sb.append("}}");
        return sb.toString();
    }

    void u(androidx.fragment.app.a aVar, boolean z9, boolean z10, boolean z11) {
        if (z9) {
            aVar.u(z11);
        } else {
            aVar.t();
        }
        ArrayList arrayList = new ArrayList(1);
        ArrayList arrayList2 = new ArrayList(1);
        arrayList.add(aVar);
        arrayList2.add(Boolean.valueOf(z9));
        if (z10 && this.f3091q >= 1) {
            x.B(this.f3092r.f(), this.f3093s, arrayList, arrayList2, 0, 1, true, this.f3088n);
        }
        if (z11) {
            Q0(this.f3091q, true);
        }
        for (Fragment fragment : this.f3077c.l()) {
            if (fragment != null && fragment.mView != null && fragment.mIsNewlyAdded && aVar.x(fragment.mContainerId)) {
                float f10 = fragment.mPostponedAlpha;
                if (f10 > 0.0f) {
                    fragment.mView.setAlpha(f10);
                }
                if (z11) {
                    fragment.mPostponedAlpha = 0.0f;
                } else {
                    fragment.mPostponedAlpha = -1.0f;
                    fragment.mIsNewlyAdded = false;
                }
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public LayoutInflater.Factory2 u0() {
        return this.f3080f;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public androidx.fragment.app.m v0() {
        return this.f3089o;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public u w(Fragment fragment) {
        u m10 = this.f3077c.m(fragment.mWho);
        if (m10 != null) {
            return m10;
        }
        u uVar = new u(this.f3089o, this.f3077c, fragment);
        uVar.o(this.f3092r.f().getClassLoader());
        uVar.t(this.f3091q);
        return uVar;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Fragment w0() {
        return this.f3094t;
    }

    public Fragment x0() {
        return this.f3095u;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void y(Fragment fragment) {
        if (F0(2)) {
            Log.v("FragmentManager", "detach: " + fragment);
        }
        if (fragment.mDetached) {
            return;
        }
        fragment.mDetached = true;
        if (fragment.mAdded) {
            if (F0(2)) {
                Log.v("FragmentManager", "remove from detach: " + fragment);
            }
            this.f3077c.s(fragment);
            if (G0(fragment)) {
                this.D = true;
            }
            n1(fragment);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public d0 y0() {
        d0 d0Var = this.f3098x;
        if (d0Var != null) {
            return d0Var;
        }
        Fragment fragment = this.f3094t;
        return fragment != null ? fragment.mFragmentManager.y0() : this.f3099y;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void z() {
        this.E = false;
        this.F = false;
        this.M.o(false);
        T(4);
    }
}
