package androidx.fragment.app;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import androidx.core.view.r0;
import androidx.core.view.y2;
import java.util.ArrayList;
/* loaded from: classes.dex */
public final class h extends FrameLayout {

    /* renamed from: g  reason: collision with root package name */
    private ArrayList f3059g;

    /* renamed from: h  reason: collision with root package name */
    private ArrayList f3060h;

    /* renamed from: i  reason: collision with root package name */
    private View.OnApplyWindowInsetsListener f3061i;

    /* renamed from: j  reason: collision with root package name */
    private boolean f3062j;

    /* JADX INFO: Access modifiers changed from: package-private */
    public h(Context context, AttributeSet attributeSet, n nVar) {
        super(context, attributeSet);
        String str;
        this.f3062j = true;
        String classAttribute = attributeSet.getClassAttribute();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, k0.c.f9170h);
        classAttribute = classAttribute == null ? obtainStyledAttributes.getString(k0.c.f9171i) : classAttribute;
        String string = obtainStyledAttributes.getString(k0.c.f9172j);
        obtainStyledAttributes.recycle();
        int id = getId();
        Fragment h02 = nVar.h0(id);
        if (classAttribute != null && h02 == null) {
            if (id <= 0) {
                if (string != null) {
                    str = " with tag " + string;
                } else {
                    str = "";
                }
                throw new IllegalStateException("FragmentContainerView must have an android:id to add Fragment " + classAttribute + str);
            }
            Fragment a10 = nVar.q0().a(context.getClassLoader(), classAttribute);
            a10.onInflate(context, attributeSet, (Bundle) null);
            nVar.m().o(true).c(this, a10, string).i();
        }
        nVar.U0(this);
    }

    private void a(View view) {
        ArrayList arrayList = this.f3060h;
        if (arrayList == null || !arrayList.contains(view)) {
            return;
        }
        if (this.f3059g == null) {
            this.f3059g = new ArrayList();
        }
        this.f3059g.add(view);
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i10, ViewGroup.LayoutParams layoutParams) {
        if (n.z0(view) != null) {
            super.addView(view, i10, layoutParams);
            return;
        }
        throw new IllegalStateException("Views added to a FragmentContainerView must be associated with a Fragment. View " + view + " is not associated with a Fragment.");
    }

    @Override // android.view.ViewGroup
    protected boolean addViewInLayout(View view, int i10, ViewGroup.LayoutParams layoutParams, boolean z9) {
        if (n.z0(view) != null) {
            return super.addViewInLayout(view, i10, layoutParams, z9);
        }
        throw new IllegalStateException("Views added to a FragmentContainerView must be associated with a Fragment. View " + view + " is not associated with a Fragment.");
    }

    @Override // android.view.ViewGroup, android.view.View
    public WindowInsets dispatchApplyWindowInsets(WindowInsets windowInsets) {
        y2 u9 = y2.u(windowInsets);
        View.OnApplyWindowInsetsListener onApplyWindowInsetsListener = this.f3061i;
        y2 u10 = onApplyWindowInsetsListener != null ? y2.u(onApplyWindowInsetsListener.onApplyWindowInsets(this, windowInsets)) : r0.Z(this, u9);
        if (!u10.n()) {
            int childCount = getChildCount();
            for (int i10 = 0; i10 < childCount; i10++) {
                r0.h(getChildAt(i10), u10);
            }
        }
        return windowInsets;
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void dispatchDraw(Canvas canvas) {
        if (this.f3062j && this.f3059g != null) {
            for (int i10 = 0; i10 < this.f3059g.size(); i10++) {
                super.drawChild(canvas, (View) this.f3059g.get(i10), getDrawingTime());
            }
        }
        super.dispatchDraw(canvas);
    }

    @Override // android.view.ViewGroup
    protected boolean drawChild(Canvas canvas, View view, long j10) {
        ArrayList arrayList;
        if (!this.f3062j || (arrayList = this.f3059g) == null || arrayList.size() <= 0 || !this.f3059g.contains(view)) {
            return super.drawChild(canvas, view, j10);
        }
        return false;
    }

    @Override // android.view.ViewGroup
    public void endViewTransition(View view) {
        ArrayList arrayList = this.f3060h;
        if (arrayList != null) {
            arrayList.remove(view);
            ArrayList arrayList2 = this.f3059g;
            if (arrayList2 != null && arrayList2.remove(view)) {
                this.f3062j = true;
            }
        }
        super.endViewTransition(view);
    }

    @Override // android.view.View
    public WindowInsets onApplyWindowInsets(WindowInsets windowInsets) {
        return windowInsets;
    }

    @Override // android.view.ViewGroup
    public void removeAllViewsInLayout() {
        for (int childCount = getChildCount() - 1; childCount >= 0; childCount--) {
            a(getChildAt(childCount));
        }
        super.removeAllViewsInLayout();
    }

    @Override // android.view.ViewGroup
    protected void removeDetachedView(View view, boolean z9) {
        if (z9) {
            a(view);
        }
        super.removeDetachedView(view, z9);
    }

    @Override // android.view.ViewGroup, android.view.ViewManager
    public void removeView(View view) {
        a(view);
        super.removeView(view);
    }

    @Override // android.view.ViewGroup
    public void removeViewAt(int i10) {
        a(getChildAt(i10));
        super.removeViewAt(i10);
    }

    @Override // android.view.ViewGroup
    public void removeViewInLayout(View view) {
        a(view);
        super.removeViewInLayout(view);
    }

    @Override // android.view.ViewGroup
    public void removeViews(int i10, int i11) {
        for (int i12 = i10; i12 < i10 + i11; i12++) {
            a(getChildAt(i12));
        }
        super.removeViews(i10, i11);
    }

    @Override // android.view.ViewGroup
    public void removeViewsInLayout(int i10, int i11) {
        for (int i12 = i10; i12 < i10 + i11; i12++) {
            a(getChildAt(i12));
        }
        super.removeViewsInLayout(i10, i11);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void setDrawDisappearingViewsLast(boolean z9) {
        this.f3062j = z9;
    }

    @Override // android.view.ViewGroup
    public void setLayoutTransition(LayoutTransition layoutTransition) {
        throw new UnsupportedOperationException("FragmentContainerView does not support Layout Transitions or animateLayoutChanges=\"true\".");
    }

    @Override // android.view.View
    public void setOnApplyWindowInsetsListener(View.OnApplyWindowInsetsListener onApplyWindowInsetsListener) {
        this.f3061i = onApplyWindowInsetsListener;
    }

    @Override // android.view.ViewGroup
    public void startViewTransition(View view) {
        if (view.getParent() == this) {
            if (this.f3060h == null) {
                this.f3060h = new ArrayList();
            }
            this.f3060h.add(view);
        }
        super.startViewTransition(view);
    }
}
