package androidx.fragment.app;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.lifecycle.m0;
import androidx.lifecycle.n0;
/* loaded from: classes.dex */
public class d extends Fragment implements DialogInterface.OnCancelListener, DialogInterface.OnDismissListener {

    /* renamed from: g  reason: collision with root package name */
    private Handler f3016g;

    /* renamed from: p  reason: collision with root package name */
    private boolean f3025p;

    /* renamed from: r  reason: collision with root package name */
    private Dialog f3027r;

    /* renamed from: s  reason: collision with root package name */
    private boolean f3028s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f3029t;

    /* renamed from: u  reason: collision with root package name */
    private boolean f3030u;

    /* renamed from: h  reason: collision with root package name */
    private Runnable f3017h = new a();

    /* renamed from: i  reason: collision with root package name */
    private DialogInterface.OnCancelListener f3018i = new b();

    /* renamed from: j  reason: collision with root package name */
    private DialogInterface.OnDismissListener f3019j = new c();

    /* renamed from: k  reason: collision with root package name */
    private int f3020k = 0;

    /* renamed from: l  reason: collision with root package name */
    private int f3021l = 0;

    /* renamed from: m  reason: collision with root package name */
    private boolean f3022m = true;

    /* renamed from: n  reason: collision with root package name */
    private boolean f3023n = true;

    /* renamed from: o  reason: collision with root package name */
    private int f3024o = -1;

    /* renamed from: q  reason: collision with root package name */
    private androidx.lifecycle.s f3026q = new C0033d();

    /* renamed from: v  reason: collision with root package name */
    private boolean f3031v = false;

    /* loaded from: classes.dex */
    class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            d.this.f3019j.onDismiss(d.this.f3027r);
        }
    }

    /* loaded from: classes.dex */
    class b implements DialogInterface.OnCancelListener {
        b() {
        }

        @Override // android.content.DialogInterface.OnCancelListener
        public void onCancel(DialogInterface dialogInterface) {
            if (d.this.f3027r != null) {
                d dVar = d.this;
                dVar.onCancel(dVar.f3027r);
            }
        }
    }

    /* loaded from: classes.dex */
    class c implements DialogInterface.OnDismissListener {
        c() {
        }

        @Override // android.content.DialogInterface.OnDismissListener
        public void onDismiss(DialogInterface dialogInterface) {
            if (d.this.f3027r != null) {
                d dVar = d.this;
                dVar.onDismiss(dVar.f3027r);
            }
        }
    }

    /* renamed from: androidx.fragment.app.d$d  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    class C0033d implements androidx.lifecycle.s {
        C0033d() {
        }

        @Override // androidx.lifecycle.s
        /* renamed from: b */
        public void a(androidx.lifecycle.m mVar) {
            if (mVar == null || !d.this.f3023n) {
                return;
            }
            View requireView = d.this.requireView();
            if (requireView.getParent() != null) {
                throw new IllegalStateException("DialogFragment can not be attached to a container view");
            }
            if (d.this.f3027r != null) {
                if (n.F0(3)) {
                    Log.d("FragmentManager", "DialogFragment " + this + " setting the content view on " + d.this.f3027r);
                }
                d.this.f3027r.setContentView(requireView);
            }
        }
    }

    /* loaded from: classes.dex */
    class e extends g {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ g f3036g;

        e(g gVar) {
            this.f3036g = gVar;
        }

        @Override // androidx.fragment.app.g
        public View c(int i10) {
            return this.f3036g.d() ? this.f3036g.c(i10) : d.this.o(i10);
        }

        @Override // androidx.fragment.app.g
        public boolean d() {
            return this.f3036g.d() || d.this.p();
        }
    }

    private void k(boolean z9, boolean z10) {
        if (this.f3029t) {
            return;
        }
        this.f3029t = true;
        this.f3030u = false;
        Dialog dialog = this.f3027r;
        if (dialog != null) {
            dialog.setOnDismissListener(null);
            this.f3027r.dismiss();
            if (!z10) {
                if (Looper.myLooper() == this.f3016g.getLooper()) {
                    onDismiss(this.f3027r);
                } else {
                    this.f3016g.post(this.f3017h);
                }
            }
        }
        this.f3028s = true;
        if (this.f3024o >= 0) {
            getParentFragmentManager().W0(this.f3024o, 1);
            this.f3024o = -1;
            return;
        }
        w m10 = getParentFragmentManager().m();
        m10.l(this);
        if (z9) {
            m10.g();
        } else {
            m10.f();
        }
    }

    private void q(Bundle bundle) {
        if (this.f3023n && !this.f3031v) {
            try {
                this.f3025p = true;
                Dialog n10 = n(bundle);
                this.f3027r = n10;
                if (this.f3023n) {
                    s(n10, this.f3020k);
                    Context context = getContext();
                    if (context instanceof Activity) {
                        this.f3027r.setOwnerActivity((Activity) context);
                    }
                    this.f3027r.setCancelable(this.f3022m);
                    this.f3027r.setOnCancelListener(this.f3018i);
                    this.f3027r.setOnDismissListener(this.f3019j);
                    this.f3031v = true;
                } else {
                    this.f3027r = null;
                }
            } finally {
                this.f3025p = false;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // androidx.fragment.app.Fragment
    public g createFragmentContainer() {
        return new e(super.createFragmentContainer());
    }

    public void j() {
        k(false, false);
    }

    public Dialog l() {
        return this.f3027r;
    }

    public int m() {
        return this.f3021l;
    }

    public Dialog n(Bundle bundle) {
        if (n.F0(3)) {
            Log.d("FragmentManager", "onCreateDialog called for DialogFragment " + this);
        }
        return new Dialog(requireContext(), m());
    }

    View o(int i10) {
        Dialog dialog = this.f3027r;
        if (dialog != null) {
            return dialog.findViewById(i10);
        }
        return null;
    }

    @Override // androidx.fragment.app.Fragment
    public void onAttach(Context context) {
        super.onAttach(context);
        getViewLifecycleOwnerLiveData().e(this.f3026q);
        if (this.f3030u) {
            return;
        }
        this.f3029t = false;
    }

    @Override // android.content.DialogInterface.OnCancelListener
    public void onCancel(DialogInterface dialogInterface) {
    }

    @Override // androidx.fragment.app.Fragment
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.f3016g = new Handler();
        this.f3023n = this.mContainerId == 0;
        if (bundle != null) {
            this.f3020k = bundle.getInt("android:style", 0);
            this.f3021l = bundle.getInt("android:theme", 0);
            this.f3022m = bundle.getBoolean("android:cancelable", true);
            this.f3023n = bundle.getBoolean("android:showsDialog", this.f3023n);
            this.f3024o = bundle.getInt("android:backStackId", -1);
        }
    }

    @Override // androidx.fragment.app.Fragment
    public void onDestroyView() {
        super.onDestroyView();
        Dialog dialog = this.f3027r;
        if (dialog != null) {
            this.f3028s = true;
            dialog.setOnDismissListener(null);
            this.f3027r.dismiss();
            if (!this.f3029t) {
                onDismiss(this.f3027r);
            }
            this.f3027r = null;
            this.f3031v = false;
        }
    }

    @Override // androidx.fragment.app.Fragment
    public void onDetach() {
        super.onDetach();
        if (!this.f3030u && !this.f3029t) {
            this.f3029t = true;
        }
        getViewLifecycleOwnerLiveData().i(this.f3026q);
    }

    @Override // android.content.DialogInterface.OnDismissListener
    public void onDismiss(DialogInterface dialogInterface) {
        if (this.f3028s) {
            return;
        }
        if (n.F0(3)) {
            Log.d("FragmentManager", "onDismiss called for DialogFragment " + this);
        }
        k(true, true);
    }

    @Override // androidx.fragment.app.Fragment
    public LayoutInflater onGetLayoutInflater(Bundle bundle) {
        StringBuilder sb;
        String str;
        LayoutInflater onGetLayoutInflater = super.onGetLayoutInflater(bundle);
        if (this.f3023n && !this.f3025p) {
            q(bundle);
            if (n.F0(2)) {
                Log.d("FragmentManager", "get layout inflater for DialogFragment " + this + " from dialog context");
            }
            Dialog dialog = this.f3027r;
            return dialog != null ? onGetLayoutInflater.cloneInContext(dialog.getContext()) : onGetLayoutInflater;
        }
        if (n.F0(2)) {
            String str2 = "getting layout inflater for DialogFragment " + this;
            if (this.f3023n) {
                sb = new StringBuilder();
                str = "mCreatingDialog = true: ";
            } else {
                sb = new StringBuilder();
                str = "mShowsDialog = false: ";
            }
            sb.append(str);
            sb.append(str2);
            Log.d("FragmentManager", sb.toString());
        }
        return onGetLayoutInflater;
    }

    @Override // androidx.fragment.app.Fragment
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Dialog dialog = this.f3027r;
        if (dialog != null) {
            Bundle onSaveInstanceState = dialog.onSaveInstanceState();
            onSaveInstanceState.putBoolean("android:dialogShowing", false);
            bundle.putBundle("android:savedDialogState", onSaveInstanceState);
        }
        int i10 = this.f3020k;
        if (i10 != 0) {
            bundle.putInt("android:style", i10);
        }
        int i11 = this.f3021l;
        if (i11 != 0) {
            bundle.putInt("android:theme", i11);
        }
        boolean z9 = this.f3022m;
        if (!z9) {
            bundle.putBoolean("android:cancelable", z9);
        }
        boolean z10 = this.f3023n;
        if (!z10) {
            bundle.putBoolean("android:showsDialog", z10);
        }
        int i12 = this.f3024o;
        if (i12 != -1) {
            bundle.putInt("android:backStackId", i12);
        }
    }

    @Override // androidx.fragment.app.Fragment
    public void onStart() {
        super.onStart();
        Dialog dialog = this.f3027r;
        if (dialog != null) {
            this.f3028s = false;
            dialog.show();
            View decorView = this.f3027r.getWindow().getDecorView();
            m0.a(decorView, this);
            n0.a(decorView, this);
            h3.e.a(decorView, this);
        }
    }

    @Override // androidx.fragment.app.Fragment
    public void onStop() {
        super.onStop();
        Dialog dialog = this.f3027r;
        if (dialog != null) {
            dialog.hide();
        }
    }

    @Override // androidx.fragment.app.Fragment
    public void onViewStateRestored(Bundle bundle) {
        Bundle bundle2;
        super.onViewStateRestored(bundle);
        if (this.f3027r == null || bundle == null || (bundle2 = bundle.getBundle("android:savedDialogState")) == null) {
            return;
        }
        this.f3027r.onRestoreInstanceState(bundle2);
    }

    boolean p() {
        return this.f3031v;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // androidx.fragment.app.Fragment
    public void performCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        Bundle bundle2;
        super.performCreateView(layoutInflater, viewGroup, bundle);
        if (this.mView != null || this.f3027r == null || bundle == null || (bundle2 = bundle.getBundle("android:savedDialogState")) == null) {
            return;
        }
        this.f3027r.onRestoreInstanceState(bundle2);
    }

    public final Dialog r() {
        Dialog l10 = l();
        if (l10 != null) {
            return l10;
        }
        throw new IllegalStateException("DialogFragment " + this + " does not have a Dialog.");
    }

    public void s(Dialog dialog, int i10) {
        if (i10 != 1 && i10 != 2) {
            if (i10 != 3) {
                return;
            }
            Window window = dialog.getWindow();
            if (window != null) {
                window.addFlags(24);
            }
        }
        dialog.requestWindowFeature(1);
    }
}
